#!/usr/bin/perl --
# perl antispam smtp proxy professional
# (c) John Hanna, John Calvi, Robert Orso, AJ 2004 under the terms of the GPL
# (c) Fritz Borgstedt 2006 under the terms of the GPL
# (c) Thomas Eckardt 2008 under the terms of the GPL
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation;

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# ASSP founded and developed to Version 1.0.12 by John Hanna
# ASSP development since 1.0.12 by John Calvi
# ASSP development since 1.2.0 by Fritz Borgstedt
#
# ASSP V2 pro development since 2.0.0 by
# Thomas Eckardt - DB Support, Conversions, Transparent SMTP Proxy, SSL/TLS support,
#                  LDAP-List, recipient replacement, Plugins, multithreading,
#                  global-penalty-box, backscatter-checks(BATV,FBMTV,DNS), VRFY-check,
#                  MailLog- and Resend-Function, multipart SpamReport, RebuildSpamDB,
#                  move2num, https for GUI, many GUI improvements,Block Reports,
#                  encryption, DB-encryption, DKIM/Domainkey, AdminUsers Interface,
#                  connection damping, code autoupdate, GUI multi language support,
#                  local charset support, UTF8 support for check engines,
#                  delay queuing, LDAPS, global penaltybox , regex optimization,
#                  POP3 collector, config sync , SNMP, group management ,IPv6 support,
#                  Crash Analyzer , Perl module update, (Win32)Unicode support, DMARC,
#                  private Whitelist
#
# Feature implementations:
# AJ - Web interface
# Robert Orso - LDAP
# Nigel Barling - SPF & DNSBL
# Mark Pizzolato - SMTP Session Limits
# Przemek Czerkas - SRS, Delaying, Maillog Search, HTTP Compression, URIBL, RWL,
#					and many ideas and pieces
# Craig Schmitt - SPF2 & code optimizing
# Misc. contributions:
# Wim Borghs, Micheal Espinola, Doug Traylor, Lars Troen, Marco Tomasi,
# Andrew Macpherson, Marco Michelino, Matti Haack, Dave Emory, Kevin,
# Grayhat (Andrea), Victor Miasnikov
#
# the latest released version is available at:
# http://downloads.sourceforge.net/projects/assp/files/ASSP%20V2%20multithreading/autoupdate/assp.pl.gz
#
# the latest development version is available at
# http://assp.cvs.sourceforge.net/viewvc/*checkout*/assp/assp2/assp.pl.gz

## no critic qw(BuiltinFunctions::ProhibitStringyEval)

use strict qw(vars subs);

our %signo;
sub check_iThreads {
use Config qw(myconfig);

my $iThreads = myconfig();
$iThreads =~ /useithreads\s*=\s*([^\s\r\n]+)/gio;
$iThreads = lc($1);
{
    my $i = 0;
    foreach (split(/\s+/o, $Config::Config{sig_name})) {
        $signo{$_} = $i;
        $i++;
    }
}

die <<EOT  if ($iThreads !~ /define/i);

***** ATTENTION *****

******************************************************************************
This version of Perl ( $] ) does not support iThreads (multithreading)!
iThreads are needed to run ASSP version 2.0.0 or higher!
To get more information about your Perl installation
start the following commands in commandline or shell:

perl -v
perl -V

Upgrade your Perl installation to a multithreading version or
use a singlethread version of ASSP (version 1.x.x)!
To run this version of ASSP, a Perl version 5.016003 (5.16.3) or higher
is recommended - a version 5.010000 is at least required.
Perl version 6.x is not supported.
******************************************************************************

EOT
no Config;
undef $iThreads;
}

my $VSTR;
BEGIN {
    $VSTR = $];
    $VSTR =~ s/^(5\.)0(\d\d).+$/$1$2/o;
}

use 5.010;
use feature ":$VSTR";     # <- turn on the available version features
use threads 1.69 ('yield');
use threads::shared 1.18;
use Thread::Queue 2.06;
use IO::Poll 0.07 qw(POLLIN POLLOUT POLLERR POLLHUP POLLNVAL);
use IO::Select;
use Encode 2.12;
use File::Copy;
use IO::Socket;
use Sys::Hostname;
use Time::Local;
use Time::HiRes;
use HTML::Entities ();
use Cwd;
use MIME::Base64();
use MIME::QuotedPrint();
no warnings qw(uninitialized);  # possibly add   'recursion' and/or 'utf8'

#eval{$^M = 'a' x (1 << 16);}; # use 64KB for "out of memory" area
STDOUT->autoflush;
STDERR->autoflush;
$SIG{ALRM} = sub {};

our $MAINVERSION;
our $MajorVersion;
our $version;
our $modversion;
our $build;
our $availversion:shared;
our $versionURL;
our $NewAsspURL;
our $ChangeLogURL;
our $requiredSelfLoaderVersion;
our %requiredDBVersion:shared;
our $codename;
our $perl = $^X;
our $assp = $0;
our $allIdle:shared = 0;

#
sub setVersion {
$version='2.3.3';
$build = '14029';
$modversion="($build)";    #appended in version display (YYDDD[.subver]).
$MAINVERSION = $version . $modversion;
$MajorVersion = substr($version,0,1);
$requiredSelfLoaderVersion = '2.03';
#$codename = 'SIC58&nbsp;&dagger;&nbsp;';
$codename = '';

# the database versions build and required by this release
$requiredDBVersion{'Spamdb'} = $MajorVersion.'_13218_'.$];
$requiredDBVersion{'HMMdb'}  = $MajorVersion.'_13218_'.$];
}
#
&setVersion();

our $utf8;
our $open;
our $unicodeFH;
our $unicodeDH;
our $move;
our $copy;
our $unlink;
our $rename;
our $chmod;
our $stat;
our $mkdir;
our $rmdir;
our $rmtree;
our $eF;
our $dF;
our $unicodeName;

sub disableUnicode {
    $utf8 = sub {};
    $open = sub { open(shift,shift,shift); };    ## no critic
    $unicodeFH = sub {};
    $unicodeDH = sub { opendir(my $d,shift);my @l = readdir($d);close $d;return @l; };
    $move = sub { File::Copy::move(shift,shift) };
    $copy = sub { File::Copy::copy(shift,shift) };
    $unlink = sub { unlink(shift) };
    $rename = sub { rename(shift,shift) };
    $chmod = sub { chmod(shift,shift) };
    $stat = sub { stat(shift) };
    $mkdir = sub { mkdir(shift,shift) };
    $rmdir = sub { rmdir(shift) };
    $rmtree = sub { return unless eval('use File::Path 2.00 ();1;'); File::Path::remove_tree(@_);};
    $eF = sub { -e shift; };
    $dF = sub { -d shift; };
    $unicodeName = sub { $_[0];};
}
disableUnicode();

my ($subversion) = $version =~ /\d+\.\d+\.(\d+)/o;
if ($subversion % 2) {
# stabil published version download
    $versionURL = 'http://downloads.sourceforge.net/project/assp/ASSP%20V2%20multithreading/autoupdate/version.txt';
    $NewAsspURL = 'http://downloads.sourceforge.net/project/assp/ASSP%20V2%20multithreading/autoupdate/assp.pl.gz';
    $ChangeLogURL = 'http://downloads.sourceforge.net/project/assp/ASSP%20V2%20multithreading/changelog.txt';
} else {
# stabil development (beta) version download
    $versionURL = 'http://assp.cvs.sourceforge.net/viewvc/*checkout*/assp/assp2/version.txt';
    $NewAsspURL = 'http://assp.cvs.sourceforge.net/viewvc/*checkout*/assp/assp2/assp.pl.gz';
    $ChangeLogURL = 'http://assp.cvs.sourceforge.net/viewvc/*checkout*/assp/assp2/changelog.txt';
}
our $gripListDownUrl = 'http://*HOST*/cgi-bin/assp_griplist?binary';
our $gripListUpUrl = 'http://*HOST*/cgi-bin/assp_griplist?binary';
our $gripListUpHost = 'assp.sourceforge.net';
$gripListDownUrl =~ s/\*HOST\*/$gripListUpHost/o;
$gripListUpUrl  =~ s/\*HOST\*/$gripListUpHost/o;
our $GroupsFileURL = 'http://assp.cvs.sourceforge.net/viewvc/*checkout*/assp/assp2/files/groups.txt';
#-----------

our %neverLockTable;
our %skipDeclare;
our @ConfigArray;
our %Modules;
our %ModulesUsed;
our @prelog;
our $mydb;
our %DBvars;
our %tempDBvars;
our %Config:shared;
our %ConfigSync;
our %newConfig;
our %ConfigAdd;
our %RunTaskNow:shared;
our $Charsets;
our %CurrentMEM:shared;
our $base:shared;
our %Plugins:shared;
our %PluginFiles:shared;
our $runlvl0PL:shared;
our $runlvl1PL:shared;
our $runlvl2PL:shared;
our $wikiinfo;
our $mtObj = threads->self();
our $DBdrivers;
our $DBdriversJ;
our $DBautocommit = 1;
our $dftrestartcmd;
our $dftCaFile;
our $dftCertFile;
our $dftPrivKeyFile;
our $AsAService;
our $ServiceStopping = 0;
our $LogDateFormat;
our $LogDateLang;
our $defaultLogCharset;
our $WorkerNumber = 0;
our $WorkerName = 'startup';
our %lngmsg;
our %lngmsghint;
our $PIDH;
our $NODHO = 1;
our $CreateMIB = 0;
our $GPBinstallLib;
our $GPBmodTestList;
our $GPBCompLibVer;
our $crashHMM;
our $optReModule;
our %MemTable;
our %MemTableHist;
#our $ProtPrefix = '(?:'.erw('ht').'|' .erw('f').')'.erw('tp').erw('s','?').erw('://');  # (ht|f)tps?://

# *********************************************************************************************************************************************
# hidden config variables that could be changed using the module CorrectASSPcfg.pm
# or that could be changed using a commandline switch like --enableCrashAnalyzer:=1
# *********************************************************************************************************************************************

# CrashAnalyzer related
our $enableCrashAnalyzer = 0;            # (0/1) enable the automatic crash analyzer (CA)
our $CrashAnalyzerTopCount = 10;         # (number > 0) number of records used for the CA top count
our $CrashAnalyzerWouldBlock = 1;        # (0/1) block the mail if CA detects that the mail would crash ASSP

#IP related
our $IPv6TestPort = '51965';             # (port number) the port number that is used at startup to bind IPv6 to - to check if IPv6 is available
our $forceDNSv4:shared = 1;              # (0/1) force DNS querys to use IPv4 instead to try IPv6 first

# Bayesian and HMM related
our $HMMSequenceLength = 4;              # (number > 0) count of words used for a sequence
our $HMMDBWords = 600;                   # (number > 0) number of words used per mail in rebuildspamdb
our $BayesDomainPrior = 2;               # (number > 0) Bayesian/HMM domain entry priority (1 = lowest)
our $BayesPrivatPrior = 3;               # (number > 0) Bayesian/HMM privat/user entry priority (1 = lowest)

# logging related
our $AUTHLogUser = 0;                    # (0/1) write the username for AUTH (PLAIN/LOGIN) to maillog.txt
our $AUTHLogPWD = 0;                     # (0/1) write the userpassword for AUTH (PLAIN/LOGIN) to maillog.txt
our $Unidecode2Console = 0;              # (0/1) use Text::Unidecode to decode NONASCII characters to ASCII - if available  - if set - 'ConsoleCharset' is ignored
our $showMEM = 0;                        # (0/1) show the current memory usage in every worker
our $AnalyzeLogRegex = 0;                # (0/1) enables enhanced regex analyzing (in console mode only)

# database related
our $forceTrunc4ClearDB = 0;             # (0/1) try/force a 'TRUNCATE TABLE' instead of a 'DELETE FROM' - 'DELETE FROM' is used as fall back if the truncate failes
our $DoSQL_LIKE = 1;                     # (0/1) do an 'DELETE FROM table WHERE pkey LIKE ?' to remove generic keys
our $lockBDB = 0;                        # (0/1) use the CDB locking for BerkeleyDB (default = 0)
our $lockDatabases = 0;                  # (0/1) locks all databases on access in every worker to prevent access violation
our $DBCacheSize = 12;                   # (number > 0) database cache record count , if less it will be set to NumComWorkers * 2 + 8

# some more
our $SPF_max_dns_interactive_terms = 10; # (number > 0) max_dns_interactive_terms max number of SPF-mechanism per domain (defaults to 10)
our $neverQueueSize = 12000000;          # (number > 0) never queue mails larger than these number of bytes
our $SpamCountNormCorrection = 0;        # (+/- number in percent) correct the required by X% higher
our $FileScanCMDbuild_API;               # called if defined in FileScanOK with - $FileScanCMDbuild_API->(\$cmd,$this) - $cmd in place modification

# *********************************************************************************************************************************************

$BayesDomainPrior ||= 1;
$BayesPrivatPrior ||= 1;

our %NotifyFreqTF:shared = (     # one notification per timeframe in seconds per tag per worker
    'info'    => 60,
    'warning' => 60,
    'error'   => 60
);

our $tlds_alpha_URL = 'http://data.iana.org/TLD/tlds-alpha-by-domain.txt';
our $tlds2_URL = 'http://george.surbl.org/two-level-tlds';
#    "http://www.surbl.org/tld/two-level-tlds",
#    "http://assp.cvs.sourceforge.net/viewvc/*checkout*/assp/assp2/files/URIBLCCTLDS-L2.txt",
our $tlds3_URL = 'http://george.surbl.org/three-level-tlds';
#    "http://www.surbl.org/tld/three-level-tlds",
#    "http://assp.cvs.sourceforge.net/viewvc/*checkout*/assp/assp2/files/URIBLCCTLDS-L3.txt",

our $BackDNSFileURL = 'http://wget-mirrors.uceprotect.net/rbldnsd-all/ips.backscatterer.org.gz';

# static config sharing vars
our $syncToDo:shared;
our $syncUser;
our $syncIP;
our %neverShareCFG = (
    'DisableSMTPNetworking' => 1,
    'defaultLocalHost' => 1,
    'myServerRe' => 1,
    'pbdb' => 1,
    'DelayShowDB' => 1,
    'DelayShowDBwhite' => 1,
    'base' => 1,
    'spamdb' => 1,
    'whitelistdb' => 1,
    'redlistdb' => 1,
    'persblackdb' => 1,
    'griplist' => 1,
    'droplist' => 1,
    'delaydb' => 1,
    'ldaplistdb' => 1,
    'adminusersdb' => 1,
    'mysqlSlaveMode' => 1,
    'fillUpImportDBDir' => 1,
    'ImportMysqlDB' => 1,
    'ExportMysqlDB' => 1,
    'LDAPShowDB' => 1,
    'forceLDAPcrossCheck' => 1,
    'myName' => 1,
    'asspCfg' => 1,
    'asspCfgVersion' => 1,
    'NumComWorkers' => 1,
    'ReservedOutboundWorkers' => 1,
    'RebuildSchedule' => 1,
    'ReplaceOldSpamdb' => 1,
    'RunRebuildNow' => 1,
    'globalClientName' => 1,
    'globalClientPass' => 1,
    'globalClientLicDate' => 1,
    'DoGlobalBlack' => 1,
    'globalValencePB' => 1,
    'globalBlackExpiration' => 1,
    'DoGlobalWhite' => 1,
    'globalWhiteExpiration' => 1,
    'GPBDownloadLists' => 1,
    'GPBautoLibUpdate' => 1,
    'BlockRepForwHost' => 1,
    'BlockReportNow' => 1,
    'POP3ConfigFile' => 1,
    'POP3Interval' => 1,
    'POP3fork' => 1,
    'POP3KeepRejected' => 1,
    'POP3debug' => 1,
    'BerkeleyDB_DBEngine' => 1,
    'TLDS' => 1,
    'URIBLCCTLDS' => 1,
    'localBackDNSFile' => 1,
    'asspCpuAffinity' => 1,
    'MemoryUsageLimit' => 1,

# never share the sync vars
    'enableCFGShare' => 1,
    'isShareMaster' => 1,
    'isShareSlave' => 1,
    'syncServer' => 1,
    'syncTestMode' => 1,
    'syncConfigFile' => 1,
    'syncCFGPass' => 1,
    'syncShowGUIDetails' => 1
);
### end sharing vars

# set the blocking mode for HTTPS (0/1 default is 0) and HTTP (0/1 default is 0) on the GUI
our $HTTPSblocking = 0;
our $HTTPblocking = 0;

# set the blocking mode for STATS connection (0/1) - default is 0
our $STATSblocking = 0;

#set BerkeleyDB sync to off (0) or on (1)
our $DoSyncBDB = 1;
our $DoCompactBDB = 1;

# change regexes in ConfigCompileRe to allow grouping only (...) -> (?:...) to spend memory
our $RegexGroupingOnly = 1;

our $TimeZoneDiff = time;
$TimeZoneDiff = Time::Local::timelocal(localtime($TimeZoneDiff))-Time::Local::timelocal(gmtime($TimeZoneDiff));
*{'Time::HiRes::gmtime'} = sub {Time::HiRes::time - $TimeZoneDiff;};

# some special regular expressions
our $ScheduleRe;
our $ScheduleGUIRe;
our $neverMatch;
our $neverMatchRE;
our $punyRE;
our $EmailAdrRe;
our $EmailDomainRe;
our $HeaderNameRe;
our $HeaderValueRe;
our $HeaderRe;
our $UUENCODEDRe;
our $UTFBOMRE;
our $UTF8BOMRE;
our $UTF8BOM;
our $complexREStart;
our $complexREEnd;
our $dot;
our $UriDot;
our $NONPRINT;
our $HamTagRE;
our $SpamTagRE;
our $ValencePBRE;
our $ValencePB2RE;
our $NonSymLangRE;
our $SymLangRE;
our $notAllowedSMTP;

# IP Address representations
our $IPprivate;
our $IPQuadSectRE;
our $IPQuadSectDotRE;
our $IPQuadRE;
our $IPStrictQuadRE;
our $RFC822RE;

# Host
our $IPSectRe;
our $IPSectHexRe;
our $IPSectDotRe;
our $IPSectHexDotRe;
our $IPRe;
our $IPv4Re;
our $IPv6Re;
our $IPv6LikeRe;
our $PortRe;
our $HostRe;
our $HostPortRe;

# for GUI check
our $GUIHostPort;

# some special variables to DEBUG IO and Poll Errors and to reduce memory usage
our $CloseHandleOnPollError = 1;
our $undefMEM = 1;
our $printVars;
our $countRefs;
our %Vars2Print;
our %Refs2Count;
our $process_external_cmdqueue:shared = unlink("$base/cmdqueue");
print "\nexternal CMD-queue '$base/cmdqueue' registered " if $process_external_cmdqueue;
# end of DEBUG special vars

#DKIM html to base64 conversion (0/1) - default is 0 - set it to  1 to workaround an issue in older Mail::DKIM
our $DKIMconvHTML2base64 = 0;

# runtime variable
our $runHMMusesBDB:shared;

srand();

our %cryptConfigVars:shared = (
    'myuser' => 1,
    'mypassword' => 1,
    'LDAPLogin' => 1 ,
    'LDAPPassword' => 1 ,
    'adminusersdb' => 1,
    'adminusersdbpass' => 1,
    'adminusersdbNoBIN' => 1,
    'Notify' => 1,
    'NotifyRe' => 1,
    'NoNotifyRe' => 1,
    'proxyuser' => 1,
    'proxypass' => 1,
    'globalRegisterURL' => 1,
    'globalUploadURL' => 1,
    'globalClientPass' => 1,
    'globalClientName' => 1,
    'SSLCaFile' => 1,
    'SSLCertFile' => 1,
    'SSLKeyFile' => 1,
    'SSLPKPassword' => 1,
    'SRSSecretKey' => 1,
    'relayAuthUser' => 1,
    'relayAuthPass' => 1,
    'syncCFGPass' => 1,
    'Groups' => 1,
    'SNMPUser' => 1,
    'ConfigChangeSchedule' => 1
);

# UnicodeBlocks
our @UnicodeBlocks = qw (
    InAlphabeticPresentationForms
    InArabic
    InArabicPresentationFormsA
    InArabicPresentationFormsB
    InArmenian
    InArrows
    InBasicLatin
    InBengali
    InBlockElements
    InBopomofo
    InBopomofoExtended
    InBoxDrawing
    InBraillePatterns
    InBuhid
    InByzantineMusicalSymbols
    InCJKCompatibility
    InCJKCompatibilityForms
    InCJKCompatibilityIdeographs
    InCJKCompatibilityIdeographsSupplement
    InCJKRadicalsSupplement
    InCJKSymbolsAndPunctuation
    InCJKUnifiedIdeographs
    InCJKUnifiedIdeographsExtensionA
    InCJKUnifiedIdeographsExtensionB
    InCherokee
    InCombiningDiacriticalMarks
    InCombiningDiacriticalMarksforSymbols
    InCombiningHalfMarks
    InControlPictures
    InCurrencySymbols
    InCyrillic
    InCyrillicSupplementary
    InDeseret
    InDevanagari
    InDingbats
    InEgyptianHieroglyphs
    InEnclosedAlphanumerics
    InEnclosedCJKLettersAndMonths
    InEthiopic
    InGeneralPunctuation
    InGeometricShapes
    InGeorgian
    InGothic
    InGreekExtended
    InGreekAndCoptic
    InGujarati
    InGurmukhi
    InHalfwidthAndFullwidthForms
    InHangulCompatibilityJamo
    InHangulJamo
    InHangulSyllables
    InHanunoo
    InHebrew
    InHighPrivateUseSurrogates
    InHighSurrogates
    InHiragana
    InIPAExtensions
    InIdeographicDescriptionCharacters
    InKanbun
    InKangxiRadicals
    InKannada
    InKatakana
    InKatakanaPhoneticExtensions
    InKhmer
    InLao
    InLatin1Supplement
    InLatinExtendedA
    InLatinExtendedAdditional
    InLatinExtendedB
    InLetterlikeSymbols
    InLowSurrogates
    InMalayalam
    InMathematicalAlphanumericSymbols
    InMathematicalOperators
    InMiscellaneousMathematicalSymbolsA
    InMiscellaneousMathematicalSymbolsB
    InMiscellaneousSymbols
    InMiscellaneousTechnical
    InMongolian
    InMusicalSymbols
    InMyanmar
    InNumberForms
    InOgham
    InOldItalic
    InOpticalCharacterRecognition
    InOriya
    InPrivateUseArea
    InRunic
    InSinhala
    InSmallFormVariants
    InSpacingModifierLetters
    InSpecials
    InSuperscriptsAndSubscripts
    InSupplementalArrowsA
    InSupplementalArrowsB
    InSupplementalMathematicalOperators
    InSupplementaryPrivateUseAreaA
    InSupplementaryPrivateUseAreaB
    InSyriac
    InTagalog
    InTagbanwa
    InTags
    InTamil
    InTelugu
    InThaana
    InThai
    InTibetan
    InUnifiedCanadianAboriginalSyllabics
    InVariationSelectors
    InYiRadicals
    InYiSyllables
);


our @NonSymLangs = qw (
    InAlphabeticPresentationForms
    InArabic
    InArabicPresentationFormsA
    InArabicPresentationFormsB
    InArmenian
    InBasicLatin
    InCyrillic
    InCyrillicSupplementary
    InEnclosedAlphanumerics
    InGeorgian
    InGothic
    InGreekExtended
    InGreekAndCoptic
    InHebrew
    InLatin1Supplement
    InLatinExtendedA
    InLatinExtendedAdditional
    InLatinExtendedB
    InLetterlikeSymbols
    InMathematicalAlphanumericSymbols
    InMathematicalOperators
    InOldItalic
    InOpticalCharacterRecognition
);
our @SymLangs;

our @UniCodeScripts = qw (
    Common
    Arabic
    Armenian
    Bengali
    Bopomofo
    Braille
    Buhid
    CanadianAboriginal
    Cherokee
    Cyrillic
    Devanagari
    Ethiopic
    Georgian
    Greek
    Gujarati
    Gurmukhi
    Han
    Hangul
    Hanunoo
    Hebrew
    Hiragana
    Kannada
    Katakana
    Khmer
    Lao
    Latin
    Limbu
    Malayalam
    Mongolian
    Myanmar
    Ogham
    Oriya
    Runic
    Sinhala
    Syriac
    Tagalog
    Tagbanwa
    TaiLe
    Tamil
    Telugu
    Thaana
    Thai
    Tibetan
    Yi
);

sub setSpecialRegex {
my $w = 'a-zA-Z0-9_';
my $d = '0-9';
$ScheduleRe = '(?:\S+\s+){4}\S+';
$ScheduleGUIRe = '^('.$ScheduleRe.'(?:\|'.$ScheduleRe.")*|[$d]+|)\$";
$neverMatch = '^(?!)';
$neverMatchRE = quotemeta($neverMatch).'\)?\$?\)*$';
$punyRE = 'xn--[a-zA-Z0-9\-]+';
$EmailAdrRe=qr/[^()<>@,;:"\[\]\000-\040\x7F-\xFF]+/o;
$EmailDomainRe=qr/(?:[$w][$w\-]*(?:\.[$w][$w\-]*)*\.(?:$punyRE|[$w][$w]+)|\[[$d][$d\.]*\.[$d]+\])/o;
$HeaderNameRe=qr/\S[^\r\n]*/o;
$HeaderValueRe=qr/[ \t]*[^\r\n]*(?:\r?\n[ \t]+\S[^\r\n]*)*(?:\r?\n)?/o;
$HeaderRe=qr/(?:$HeaderNameRe:$HeaderValueRe)/o;
$UUENCODEDRe=qr/\bbegin\b [$d]{3} \b\S{0,72}.*?\S{61}.{0,61}\bend\b/o;
$UTF8BOM = "\xEF\xBB\xBF";
$UTFBOMRE = qr/(?:\x00\x00\xFE\xFF|\xFF\xFE\x00\x00|\xFE\xFF|\xFF\xFE|$UTF8BOM)/o;
$UTF8BOMRE = qr/(?:$UTF8BOM)/o;
$NONPRINT = qr/[\x00-\x1F\x7F-\xFF]/o;
$complexREStart = '^(?=.*?(((?!)';
$complexREEnd = '(?!)).*?(?!\g{-1})){';
$notAllowedSMTP = qr/CHUNKING|PIPELINING|XEXCH50|
                     SMTPUTF8|UTF8REPLY|
                     UTF8SMTP|UTF8SMTPA|UTF8SMTPS|UTF8SMTPAS|
                     UTF8LMTP|UTF8LMTPA|UTF8LMTPS|UTF8LMTPAS|
                     XCLIENT|XFORWARD|
                     TURN|ATRN|ETRN|TURNME|X-TURNME|XTRN|
                     SEND|SOML|SAML|EMAL|ESAM|ESND|ESOM|
                     XAUTH|XQUE|XREMOTEQUEUE|
                     X-EXPS|X-ADAT|X-DRCP|X-ERCP|EVFY|
                     8BITMIME|BINARYMIME|BDAT|
                     AUTH GSSAPI|AUTH NTLM|X-LINK2STATE
                  /oix;

# IP Address representations
my $sep;
my $v6Re = '[0-9A-Fa-f]{1,4}';
$IPSectRe = "(?:25[0-5]|2[0-4][$d]|1[$d]{2}|0?[$d]?[$d])";
$IPSectHexRe = '(?:(?:0x)?(?:[A-Fa-f][A-Fa-f0-9]?|[A-Fa-f0-9]?[A-Fa-f]))';

$IPprivate  = '^(?:0{1,3}\.0{1,3}\.0{1,3}\.0{1,3}|127(?:\.'.$IPSectRe.'){3}|169\.254(?:\.'.$IPSectRe.'){2}|0?10(?:\.'.$IPSectRe.'){3}|192\.168(?:\.'.$IPSectRe.'){2}|172\.0?1[6-9](?:\.'.$IPSectRe.'){2}|172\.0?2[0-9](?:\.'.$IPSectRe.'){2}|172\.0?3[01](?:\.'.$IPSectRe.'){2})$';   #RFC 1918 decimal
$IPprivate .= '|^(?:(?:0x)?0{1,2}\.(?:0x)?0{1,2}\.(?:0x)?0{1,2}\.(?:0x)?0{1,2}|(?:0x)?7[Ff](?:\.'.$IPSectHexRe.'){3}|(?:0x)?[aA]9\.(?:0x)?[Ff][Ee](?:\.'.$IPSectHexRe.'){2}|(?:0x)?0[aA](?:\.'.$IPSectHexRe.'){3}|(?:0x)?[Cc]0\.(?:0x)?[Aa]8(?:\.'.$IPSectHexRe.'){2}|(?:0x)[Aa][Cc]\.(?:0x)1[0-9a-fA-F](?:\.'.$IPSectHexRe.'){2})$';   #RFC 1918 Hex
$IPprivate .= '|^(?:0{0,4}:){2,6}'.$IPprivate.'$';  # private IPv4 in IPv6
$IPprivate .= '|^(?:0{0,4}:){2,7}[1:]?$';  # IPv6 loopback and universal

$IPQuadSectRE="(?:0([0-7]+)|0x([0-9a-fA-F]+)|([$d]+))";
$IPQuadSectDotRE='(?:'.$IPQuadSectRE.'\.)';
$IPQuadRE=qr/$IPQuadSectDotRE?$IPQuadSectDotRE?$IPQuadSectDotRE?$IPQuadSectRE/o;

$dot = '[^a-zA-Z0-9\.]?d[^a-zA-Z0-9\.]?o[^a-zA-Z0-9\.]?t[^a-zA-Z0-9\.]?|[\=\%]2[eE]|\&\#0?46\;?';      # the DOT
$UriDot = '(?:[\=\%]2[eE]|\&\#0?46\;?|\.)';

$IPSectDotRe = '(?:'.$IPSectRe.'\.)';
$IPSectHexDotRe = '(?:'.$IPSectHexRe.'\.)';
$IPv4Re = qr/(?:
(?:$IPSectDotRe){3}$IPSectRe
|
(?:$IPSectHexDotRe){3}$IPSectHexRe
)/xo;

# private IPv6 addresses
$IPprivate .= <<EOT;
|^(?i:FE[89A-F][0-9A-F]):
(?:
(?:(?:$v6Re:){6}(?:                                $v6Re      |:))|
(?:(?:$v6Re:){5}(?:                   $IPv4Re |   :$v6Re      |:))|
(?:(?:$v6Re:){4}(?:                  :$IPv4Re |(?::$v6Re){1,2}|:))|
(?:(?:$v6Re:){3}(?:(?:(?::$v6Re)?    :$IPv4Re)|(?::$v6Re){1,3}|:))|
(?:(?:$v6Re:){2}(?:(?:(?::$v6Re){0,2}:$IPv4Re)|(?::$v6Re){1,4}|:))|
(?:(?:$v6Re:)   (?:(?:(?::$v6Re){0,3}:$IPv4Re)|(?::$v6Re){1,5}|:))|
                (?:(?:(?::$v6Re){0,4}:$IPv4Re)|(?::$v6Re){1,6}|:)
)\$
EOT
$IPprivate = qr/$IPprivate/xo;

# RFC4291, section 2.2, "Text Representation of Addresses"
$sep = '[:-]';
$IPv6Re = $IPv6LikeRe = <<EOT;
(?:
(?:(?:$v6Re$sep){7}(?:                                         $v6Re      |$sep))|
(?:(?:$v6Re$sep){6}(?:                         $IPv4Re |   $sep$v6Re      |$sep))|
(?:(?:$v6Re$sep){5}(?:                     $sep$IPv4Re |(?:$sep$v6Re){1,2}|$sep))|
(?:(?:$v6Re$sep){4}(?:(?:(?:$sep$v6Re)?    $sep$IPv4Re)|(?:$sep$v6Re){1,3}|$sep))|
(?:(?:$v6Re$sep){3}(?:(?:(?:$sep$v6Re){0,2}$sep$IPv4Re)|(?:$sep$v6Re){1,4}|$sep))|
(?:(?:$v6Re$sep){2}(?:(?:(?:$sep$v6Re){0,3}$sep$IPv4Re)|(?:$sep$v6Re){1,5}|$sep))|
(?:(?:$v6Re$sep)   (?:(?:(?:$sep$v6Re){0,4}$sep$IPv4Re)|(?:$sep$v6Re){1,6}|$sep))|
(?:        $sep    (?:(?:(?:$sep$v6Re){0,5}$sep$IPv4Re)|(?:$sep$v6Re){1,7}|$sep))
)
EOT

$IPv6Re =~ s/\Q$sep\E/:/go;
$IPv6Re = qr/$IPv6Re/xo;
$IPv6LikeRe = qr/$IPv6LikeRe/xo;

$IPRe = qr/(?:
$IPv4Re
|
$IPv6Re
)/xo;

# re for a single port - could be number 1 to 65535
$PortRe = qr/(?:(?:[1-6][$d]{4})|(?:[1-9][$d]{0,3}))/o;
# re for a single host - could be an IP a name or a fqdn
$HostRe = qr/(?:(?:$IPv4Re|\[?$IPv6Re\]?)|$EmailDomainRe|[$w][$w]+)/o;
$HostPortRe = qr/$HostRe:$PortRe/o;

$GUIHostPort = qr/^((?:(?:$PortRe|$HostPortRe)(?:\|(?:$PortRe|$HostPortRe))*)|)$/o;

$RFC822RE = <<'EOF';
[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\
xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xf
f\n\015()]*)*\)[\040\t]*)*(?:(?:[^(\040)<>@,;:".\\\[\]\000-\037\x80-\x
ff]+(?![^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff])|"[^\\\x80-\xff\n\015
"]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015"]*)*")[\040\t]*(?:\([^\\\x80-\
xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80
-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*
)*(?:\.[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\
\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\
x80-\xff\n\015()]*)*\)[\040\t]*)*(?:[^(\040)<>@,;:".\\\[\]\000-\037\x8
0-\xff]+(?![^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff])|"[^\\\x80-\xff\n
\015"]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015"]*)*")[\040\t]*(?:\([^\\\x
80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^
\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040
\t]*)*)*@[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([
^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\
\\x80-\xff\n\015()]*)*\)[\040\t]*)*(?:[^(\040)<>@,;:".\\\[\]\000-\037\
x80-\xff]+(?![^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff])|\[(?:[^\\\x80-
\xff\n\015\[\]]|\\[^\x80-\xff])*\])[\040\t]*(?:\([^\\\x80-\xff\n\015()
]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\
x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)*(?:\.[\04
0\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\
n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\
015()]*)*\)[\040\t]*)*(?:[^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff]+(?!
[^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff])|\[(?:[^\\\x80-\xff\n\015\[\
]]|\\[^\x80-\xff])*\])[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\
x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\01
5()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)*)*|(?:[^(\040)<>@,;:".
\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff]
)|"[^\\\x80-\xff\n\015"]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015"]*)*")[^
()<>@,;:".\\\[\]\x80-\xff\000-\010\012-\037]*(?:(?:\([^\\\x80-\xff\n\0
15()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][
^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)|"[^\\\x80-\xff\
n\015"]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015"]*)*")[^()<>@,;:".\\\[\]\
x80-\xff\000-\010\012-\037]*)*<[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?
:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-
\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)*(?:@[\040\t]*
(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015
()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()
]*)*\)[\040\t]*)*(?:[^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff]+(?![^(\0
40)<>@,;:".\\\[\]\000-\037\x80-\xff])|\[(?:[^\\\x80-\xff\n\015\[\]]|\\
[^\x80-\xff])*\])[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\
xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*
)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)*(?:\.[\040\t]*(?:\([^\\\x80
-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x
80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t
]*)*(?:[^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\
\[\]\000-\037\x80-\xff])|\[(?:[^\\\x80-\xff\n\015\[\]]|\\[^\x80-\xff])
*\])[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x
80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80
-\xff\n\015()]*)*\)[\040\t]*)*)*(?:,[\040\t]*(?:\([^\\\x80-\xff\n\015(
)]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\
\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)*@[\040\t
]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\0
15()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015
()]*)*\)[\040\t]*)*(?:[^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff]+(?![^(
\040)<>@,;:".\\\[\]\000-\037\x80-\xff])|\[(?:[^\\\x80-\xff\n\015\[\]]|
\\[^\x80-\xff])*\])[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80
-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()
]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)*(?:\.[\040\t]*(?:\([^\\\x
80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^
\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040
\t]*)*(?:[^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".
\\\[\]\000-\037\x80-\xff])|\[(?:[^\\\x80-\xff\n\015\[\]]|\\[^\x80-\xff
])*\])[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\
\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x
80-\xff\n\015()]*)*\)[\040\t]*)*)*)*:[\040\t]*(?:\([^\\\x80-\xff\n\015
()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\
\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)*)?(?:[^
(\040)<>@,;:".\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\\[\]\000-
\037\x80-\xff])|"[^\\\x80-\xff\n\015"]*(?:\\[^\x80-\xff][^\\\x80-\xff\
n\015"]*)*")[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|
\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)*\))
[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)*(?:\.[\040\t]*(?:\([^\\\x80-\xff
\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\x
ff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)*(
?:[^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\\[\]\
000-\037\x80-\xff])|"[^\\\x80-\xff\n\015"]*(?:\\[^\x80-\xff][^\\\x80-\
xff\n\015"]*)*")[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\x
ff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)
*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)*)*@[\040\t]*(?:\([^\\\x80-\x
ff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-
\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)
*(?:[^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\\[\
]\000-\037\x80-\xff])|\[(?:[^\\\x80-\xff\n\015\[\]]|\\[^\x80-\xff])*\]
)[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-
\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\x
ff\n\015()]*)*\)[\040\t]*)*(?:\.[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(
?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80
-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)*(?:[^(\040)<
>@,;:".\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\\[\]\000-\037\x8
0-\xff])|\[(?:[^\\\x80-\xff\n\015\[\]]|\\[^\x80-\xff])*\])[\040\t]*(?:
\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]
*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)
*\)[\040\t]*)*)*>)
EOF

$RFC822RE =~ s/\r?\n//go;
$RFC822RE = qr/^$RFC822RE$/;

$SpamTagRE = qr/(?:
                  \[
                  (?:
                   Attachment | AUTHError

                   Backscatter | BATV | Bayesian |
                   BlackDomain | BlackHELO | BombBlack |
                   BombData | BombHeader | BombRe |
                   BombScript | BombSender | BounceAddress |

                   Collect | Connection | CountryCode |

                   DCC | DNSBL | Delayed | DenyIP |
                   DenyStrict | DomainKey | DKIM | DMARC

                   Extreme | ForgedHELO |
                   ForgedLocalSender | FromMissing |

                   History | HMM |

                   IPfrequency | IPperDomain |
                   InternalAddress | InvalidAddress | InvalidHELO |

                   MailLoop | MalformedAddress | Max-Equal-X-Header |
                   MaxAUTHErrors | MaxErrors | MessageScore |
                   messageSize | MaxRealMessageSize | MaxMessageSize |
                   MissingMXA? | MsgID | MSGID-sig |

                   Organization | OversizedHeader |

                   PTRinvalid | PTRmissing | PenaltyBox | Penalty |

                   razor | RelayAttempt |

                   SameSubject | SPF | SRS | SpoofedSender |
                   SuspiciousHelo |

                   Trap |
                   UnknownLocalSender | URIBL |
                   VIRUS | ValidHELO |

                   WhitelistOnly
                  )
                  \] |
                   spam\sfound
               )/iox;

$HamTagRE = qr/(?:\[(?:Local|MessageOK|RWL|Whitelisted|NoProcessing)\])/io;
$ValencePBRE = qr/(\s*[$d]+\s*(?:[\|,]\s*[$d]+\s*){0,1})/o;
$ValencePB2RE = qr/(\s*-?[$d]+\s*(?:[\|,]\s*-?[$d]+\s*){0,1})/o;

$NonSymLangRE .= '\p{'.$_.'}|' for (@NonSymLangs);
chop $NonSymLangRE;
$NonSymLangRE = qr/$NonSymLangRE/;
map {my $t = $_; unless (grep(/$t/,@NonSymLangs)) {$SymLangRE .= '\p{'.$t.'}|'; push @SymLangs,$t;}} @UnicodeBlocks;
chop $SymLangRE;
$SymLangRE = qr/$SymLangRE/;

%skipDeclare = (
    'LogDateLang' => 1,
    'LogDateFormat' => 1,
    'mydb' => 1,
    'base' => 1,
    'delaySameIP' => 1
);

%neverLockTable = (
    'hmmdb' => 1,
    'spamdb' => 1,
    'spamdbhelo' => 1,
    'adminusers' => 1,
    'adminusersright' => 1,
    'backdns' => 1
);

}

sub printVarsOn {
    %Vars2Print = ();
    %Refs2Count = ();
    return unless (open my $va,'<', "$base/debug/vardebug.txt");
    $printVars = 1;
    binmode $va;
    while (my $line = (<$va>)) {
        $line =~ s/\r|\n|\s//go;
        $line =~ s/^([^#;]*)([#;])/$1/go;
        next unless $line;
        next if $line =~ /^#|;/o;
        $Vars2Print{$line} = 1;
    }
    close $va;
    if (open $va ,'<',"$base/debug/refcount.txt") {
        binmode $va;
        $countRefs = 1;
        while (my $line = (<$va>)) {
            $line =~ s/\r|\n|\s//go;
            $line =~ s/^([^#;]*)([#;])/$1/go;
            next unless $line;
            next if $line =~ /^#|;/o;
            $Refs2Count{$line} = 1;
        }
        close $va;
    }
    return;
}

sub setLocalCharsets {
    $Charsets = '0:System Default|';
    $defaultLogCharset = 0;
    foreach (Encode->encodings(':all')) {
        $Charsets .= $_ . ':' . $_ . '|' if $_ !~ /mime|symbol|null|nextstep/io;
        $defaultLogCharset = $_ if ($^O ne 'MSWin32' &&
                                    $defaultLogCharset !~ /^utf-?8/io &&
                                    $_ =~ /^utf-?8/io);
    }
    chop $Charsets;
}

sub loadModuleVars {
    %Modules = (
      'IO::Socket::INET6' => 1,
      'Thread::State' => 1,
      'File::Scan::ClamAV' => 1,
      'Net::LDAP' => 1,
      'Net::DNS' => 1,
      'Mail::SPF::Query' => 1,
      'Mail::SPF' => 1,
      'Mail::SRS' => 1,
      'Compress::Zlib' => 1,
      'Digest::MD5' => 1,
      'Digest::SHA1' => 1,
      'File::ReadBackwards' => 1,
      'PerlIO::scalar' => 1,
      'Sys::Syslog' => 1,
      'Win32::Daemon' => 1,
      'Win32::API::OutputDebugString' => 1,
      'Tie::RDBM' => 1,
      'Net::CIDR::Lite' => 1,
      'NetAddr::IP::Lite' => 1,
      'Net::IP' => 1,
      'LWP::Simple' => 1,
      'Email::MIME' => 1,
      'MIME::Types' => 1,
      'Email::Send' => 1,
      'Convert::TNEF' => 1,
      'Mail::DKIM::Verifier' => 1,
      'Net::SMTP' => 1,
      'Net::SMTP::TLS' => 1,
      'Schedule::Cron' => 1,
      'Sys::MemInfo' => 1,
      'IO::Socket::SSL' => 1,
      'BerkeleyDB' => 1,
      'DB_File' => 1,
      'Authen::SASL' => 1,
      'Regex::Optimizer' => 1,
      'Regexp::Optimizer' => 1,
      'NetSNMP::agent' => 1,
      'Time::Hi::Res' => 1,
      'AsspSelfLoader' => 1,
      'ASSP_WordStem' => 1,
      'ASSP_FC' => 1,
      'ASSP_SVG' => 1,
      'Win32::Unicode' => 1,
      'Unicode::GCString' => 1,
      'Text::Unidecode' => 1,
      'Sys::CpuAffinity' => 1
    );
    my @cfglines;
    my $i = 3000;
    foreach (sort keys %Modules) {
        my $mod = $_;
        my $link;
        for my $idx (0...$#ConfigArray) {
            my $c = $ConfigArray[$idx];
            if ($c->[7] && $c->[7] =~ /$mod/i) {
                $link .= " $c->[0]";
            }
        }

        next if $mod eq 'Time::Hi::Res';
        my $hint = ($mod eq 'Regex::Optimizer') ? ' Using this module disables the module Regexp::Optimizer internaly! ' : '';
        $mod =~ s/:://go;
        my $varname = 'use'.$mod;
        $ModulesUsed{$varname} = 1;
        $link = $link ? "<br />This module is possibly used for$link and maybe some other features." : '';
        $i++;
        push (@cfglines,[$varname,"Use Module $_",0,\&checkbox,1,'(.*)',undef,"If selected, the perl module $_ will be loaded if it is installed. If not selected, ASSP will not load the perl module $_ even it is installed and several features of ASSP will not be available! It is recommended to disable installed but unused modules to reduce the required memory.<span class=\"negative\"> Requires ASSP restart!</span>$hint$link",undef,undef,'msg0'.$i.'0','msg0'.$i.'1'])
    }
    push (@ConfigArray,[0,0,0,'heading','Module Setup <a href="javascript:popFileEditor(\'moduleLoadErrors.txt\',8);"><img height=12 width=12 src="' . $wikiinfo . '" alt="show module load errors" /></a>']);
    while (@cfglines) {
        push(@ConfigArray,shift @cfglines);
    }
}

# imported from IO :: Socket version 1.30_01 to handle MSWIN32 blocking mode
# modified by Thomas Eckardt to use a real long pointer
sub assp_socket_blocking {
    my $sock = shift;

    return $sock->SUPER::blocking(@_)
        if $^O ne 'MSWin32';

    # Windows handles blocking differently
    #
    # http://groups.google.co.uk/group/perl.perl5.porters/browse_thread/thread/b4e2b1d88280ddff/630b667a66e3509f?#630b667a66e3509f
    # http://msdn.microsoft.com/library/default.asp?url=/library/en-us/winsock/winsock/ioctlsocket_2.asp
    #
    # http://www.perlmonks.org/?node_id=780083   /TE
    #
    # 0x8004667e is FIONBIO
    #
    # which is used to set blocking behaviour.

    # NOTE:
    # This is a little confusing, the perl keyword for this is
    # 'blocking' but the OS level behaviour is 'non-blocking', probably
    # because sockets are blocking by default.
    # Therefore internally we have to reverse the semantics.

    my $orig= !${*$sock}{io_sock_nonblocking};

    return $orig unless @_;

    my $block = shift;

    my $nonblocking = "\x00\x00\x00\x01"; # pack("L",1) works too
    my $blocking = "\x00\x00\x00\x00"; # pack("L",0) works too
    my $FIONBIO = 0x8004667e;

    if ( !$block != !$orig ) {
        ${*$sock}{io_sock_nonblocking} = $block ? $blocking : $nonblocking;
        ioctl($sock, $FIONBIO, unpack('I',pack('P',${*$sock}{io_sock_nonblocking})))
            or return;
    }

    return $orig;
}

sub defConfigArray {
 # last used msg number 010121

 # still unused msg numbers
 #

@ConfigArray = (

 # except for the heading lines, all config lines have the following:
 # $name,$nicename,$size,$func,$default,$valid,$onchange,$description(,CssAdition,note,MSG-nicename,MSG-description)
 # name is the variable name that holds the data
 # nicename is a human readable pretty display name (oh how nice!)
 # size is the appropriate input box size
 # func is a function called to render the config item
 # default is the default value
 # valid is a regular expression used to clean and validate the input -- no match is an error and $1 is the desired result
 # onchange is a function to be called when this value is changed -- usually undef; just updating the value is enough
 # description is text displayed to help the user figure what to put in the entry
 # CssAdition (optional) adds the string to the CSS-name for nicename Style
 # note for Edit java script
 # message number for the nicename - for multilingual support - SNMP OID extension
 # message number for the description - for multilingual support


[0,0,0,'heading','Configuration Synchronization and Sharing'],
['enableCFGShare','Enable Configuration Sharing',0,\&checkbox,'','(.*)','ConfigChangeEnableCFGSync', '<hr><b>Read all positions in this section carefully (multiple times is recommended!!!)!&nbsp;A wrong configuration sequence or wrong configuration values can lead in to a destroyed ASSP configuration!</b><hr>
  If set, the configuration value and option files synchronization will be enabled. This synchronization belong to the configuration values, to the file that is possibly defined in a value and to the include files that are possibly defined in the configured file. If you don\'t want a specific configuration file or include file to be synchronized (send and receive), write<br />
  # assp-no-sync<br />
  as a comment anywhere in the file. An possible reason could be for example \'localDomains\' - if ASSP1 is hosting DOMAIN1 and DOMAIN2 but ASSP2 is hosting only DOMAIN2 - so the entry for DOMAIN2 could be put in a not synchronized include file on ASSP1 and the synchronized main config file contains the entry for DOMAIN1.<br />
  If the configuration of all values in this section is valid, the synchronization status will be shown in the GUI for each config value that is, or <b>could be shared</b>. There are several configuration values, that could not be shared. The list of all shareable values could be found in the distributed file assp_sync.cfg<br /><br />
  For an initial synchronization setup set the following config values in this order: setup syncServer, syncConfigFile, syncTestMode and as last syncCFGPass (leave isShareSlave and isShareMaster off). Use the default (distributed syncConfigFile assp_sync.cfg) file and configure all values to your needs - do this on all peers by removing lines or setting the general sync flag to 0 or 1 (see the description of syncConfigFile ).<br />
  If you have finished this initial setup, enable isShareMaster or isShareSlave - now assp will setup all entries in the configuration file for all sync peers to the configured default values (to 1 if isShareMaster or to 3 if isShareSlave is selected). Do this on all peers. Now you can configure the synchronization behavior for each single configuration value for each peer, if it should differ from the default setup.<br />
  For the initial synchronization, configure only one ASSP installation as master (all others as slave). If the initial synchronization has finished, which will take up to one hour, you can configure all or some assp as master and slave. On the initial master simply switch on isShareSlave. On the inital slaves, switch on isShareMaster and change all values in the sync config file that should be bidirectional shared from 3 to 1. As last action enable enableCFGShare on the SyncSlaves first and then on the SyncMaster.<br />
  After such an initial setup, any changes of the peers (syncServer) will have no effect to the configuration file (syncConfigFile)! To add or remove a sync peer after an initial setup, you have to configure syncServer and you have to edit the sync config file manualy.<br /><br />
  This option can only be enabled, if isShareMaster and/or isShareSlave and syncServer and syncConfigFile and syncCFGPass are configured!<br />
  <b>Because the synchronization is done using a special SMTP protocol (without "mail from" and "rcpt to"), this option requires an installed <a href="http://search.cpan.org/search?query=Net::SMTP" rel="external">Net::SMTP</a> module in PERL. If you want the sync feature to use a secured connection (using STARTTLS) you need (in addition) to install the perl module <a href="http://search.cpan.org/search?query=Net::SMTP::TLS" rel="external">Net::SMTP::TLS</a> and DoTLS has to be set to "do TLS". This special SMTP protocol is not usable to for any MTA for security reasons, so the "sync mails" could not be forwarded via any MTA.<br />
  For this reason all sync peers must have a direct or routed TCP connection to each other peer.</b><br /><br />
  If you build a sync topology with more than two ASSP, please notice, that it is not allowed to build any ring-synchronization. Only a chain-, tree- or star- topology is supported. It is also not allowed to build a sync ring inside any of the three allowed topologies!<br />
  <input type="button" value="show sync status" onclick="javascript:popFileEditor(\'files/sync_failed.txt\',8);" />',undef,undef,'msg009170','msg009171'],
['isShareMaster','This is a Share Master',0,\&checkbox,'','(.*)','ConfigChangeSync', 'If selected, ASSP will send configured configuration changes to sync peers.',undef,undef,'msg009180','msg009181'],
['isShareSlave','This is a Share Slave',0,\&checkbox,'','(.*)','ConfigChangeSync', 'If selected, ASSP will receive configured configuration changes from sync peers. To accept a sync request, every sending peer has to be defined in syncServer - even if there are manualy made entries in the sync config file for a peer.',undef,undef,'msg009190','msg009191'],
['syncServer','Default Sync Peers',100,\&textinput,'','^((?:' . $HostPortRe . '(?:\|' . $HostPortRe . ')*)|)$','ConfigChangeSyncServer','Define all configuration sync peers here (to send changes to or to receive changes from). Sepatate multiple values by "|". Any value must be a pair of hostname or ip-address and :port, like 10.10.10.10:25 or mypeerhost:125 or mypeerhost.mydomain.com:225. The :port must be defined!<br />
  The target port can be the listenPort , listenPort2 or relayPort of the peer.',undef,undef,'msg009200','msg009201'],
['syncTestMode','Test Mode for Config Sync',0,\&checkbox,'','(.*)',undef, 'If selected, a master (isShareMaster) will process all steps to send configuration changes, but will not realy send the request to the peers. A slave (isShareSlave) will receive all sync requests, but it will not change the configuration values and possibly sent configuration files will be stored at the original location and will get an extension of ".synctest".',undef,undef,'msg009210','msg009211'],
['syncConfigFile','Configuration File for Config Sync*',40,\&textinput,'file:assp_sync.cfg','(file:\S+|)','ConfigChangeSyncFile','Define the synchronization configuration file here (default is file:assp_sync.cfg).<br />
 This file holds the configuration and the current status of all synchronized assp configuration values.<br />
 The format of an initial value is:  "varname:=syncflag" - where syncflag could be 0 -not shared and 1 -is shared - for example: HeaderMaxLength:=1 . The syncflag is a general sign, which meens, a value of 0 disables the synchronization of the config value for all peers. A value of 1, enables the peer configuration that possibly follows.<br />
 The format after an initial setup is: "varname:=syncflag,syncServer1=status,syncServer2=status,......". The "status" could be one of the following:<br /><br />
 0 - no sync - changes of this value will not be sent to this syncServer - I will ignore all change requests for this value from there<br />
 1 - I am a SyncMaster, the value is still out of sync to this peer and should be synchronized as soon as possible<br />
 2 - I am a SyncMaster, the value is still in sync to this peer - I am also a SyncSlave to this peer (bidirectional sync) if isShareSlave is enabled<br />
 3 - I am not a SyncMaster but a SyncSlave - only this SyncMaster (peer) knows the current sync status to me<br />
 4 - I am a SyncMaster and a SyncSlave (bidirectional sync) - a change of this value was still received from this syncServer (peer) and should not be sent back to this syncServer - this flag will be automaticaly set back to 2 at the next synchronization check<br /><br />
 ',undef,undef,'msg009220','msg009221'],
['syncCFGPass','Config Sync Password',20,\&passinput,'','(.{6,}|)','ConfigChangeSync','The password that is used and required (additionaly to the sending IP address) to identify a valid sync request. This password has to be set equal in all ASSP installations, from where and/or to where the configuration should be synchronized.<br />
  The password must be at least six characters long.<br />
  If you want or need to change this password, first disable enableCFGShare here and on all peers, change the password on all peers, enable enableCFGShare on SyncSlaves then enable enableCFGShare on SyncMasters.',undef,undef,'msg009230','msg009231'],
['syncShowGUIDetails','Show Detail Sync Information in GUI',0,\&checkbox,'','(.*)',undef, 'If selected, the detail synchronization status is shown at the top of each configuration parameter like:<br /><br />
  nothing shown - there is no entry defined for this parameter in the syncConfigFile or it is an unsharable parameter<br />
  "(shareable)" - the parameter is shareable but the general sync sign in the syncConfigFile is zero<br />
  "(shared: ...)" - the detail sync status for each sync peer<br /><br />
  If not selected, only different colored bulls are shown at the top of each configuration parameter like:<br /><br />
  nothing shown - no entry in the syncConfigFile or it is an unsharable parameter<br />
  "black bull <b><font color=\'black\'>&bull;</font></b>" - the parameter is shareable but the general sync sign in the syncConfigFile is zero<br />
  "green bull <b><font color=\'green\'>&bull;</font></b>" - the parameter is shared and in sync to each peer<br />
  "red bull <b><font color=\'red\'>&bull;</font></b>" - the parameter is shared but it is currently out of sync to at least one peer<br /><br />
  If you move the mouse over the bull, a hint box will show the detail synchronization status. An click on the bull or link will open a sync config dialog box for the single configuration parameter.
  <hr /><div class="menuLevel1">Notes Config Sync</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/configsync.txt\',3);" />',undef,undef,'msg009250','msg009251'],

[ 0, 0, 0, 'heading', 'Network Setup <a href="http://www.iworld.de/homes/assp/docu/BasicFlow" target=wiki><img height=12 width=12 src="' . $wikiinfo . '" alt="Network Flow" /></a>' ],
['DisableSMTPNetworking',"Disable all new SMTP and Proxy Network Connections",0,\&checkbox,0,'(.*)','configUpdateSMTPNet',
  'If selected, ASSP will not answer to new SMTP and Proxy connections on \'listenPort , listenPort2 , listenPortSSL , relayPort and ProxyConf\'. Currently existing SMTP and Proxy connections are not affected! Web and Stat connection are also not affected.',undef,undef,'msg000010','msg000011'],
['enableINET6','Enable IPv6 support',0,\&checkbox,'','(.*)','ConfigChangeIPv6','For IPv6 network support to be enabled, check this box. Default is disabled. IO::Socket::INET6 is able to handle both IPv4 and IPv6. NOTE: This option requires an installed <a href="http://search.cpan.org/search?query=IO::Socket::INET6" rel="external">IO::Socket::INET6</a> module in PERL and your system should support IPv6 sockets to give enableing this option a sense!<br />
  Before you enable or disable IPv6, please check every IP listener and destination definition in assp and correct the settings. After changing this option a restart of assp is recommended. IPv4 addresses are defined for example 192.168.0.1 or 192.168.0.1:25 - IPv6 addresses are defined like [FE80:1:0:0:0:0:0:1]:25 or [FE80:1::1]:25 ! If an IPv4 address is defined for a listener, assp will listen only on the IPv4 socket. If an IPv6 address is defined for a listener, assp will listen only on the IPv6 socket. If only a port is defined for a listener, assp will listen on both IPv4 and IPv6 sockets.<br />
  For the definition of destination IP\'s applies the same. You are free to define hostnames instead of IP addresses like myhost.mydomain.com:25 - how ever, because of the needed IP address resolving, this will possibly slow down assp.',undef,undef,'msg009480','msg009481'],
['listenPort','SMTP Listen Port',80,\&textinput,'25',$GUIHostPort,'ConfigChangeMailPort',
  'The port number on which ASSP will listen for incoming SMTP connections (normally 25). You can specify both an IP address and port number to limit connections to a specific interface. Separate multiple entries by "|".<p><small><i>Examples:</i> 25, 127.0.0.1:25, 127.0.0.1:25|127.0.0.2:25 </small></p>','Basic',undef,'msg000020','msg000021'],
['smtpDestination','SMTP Destination',80,\&textinput,'125',$GUIHostPort,undef,
  'The IP <b>number!</b> and port number of your primary SMTP <a href=http://en.wikipedia.org/wiki/Mail_transfer_agent>mail transfer agent</a> (MTA). If multiple servers are listed and the first listed MTA does not respond, each additional MTA will be tried. If only a port number is entered, or the dynamic keyword <b>INBOUND</b> is used with a port number, then the connection will be established to the local IP address on which the connection was received. This is useful when you have several IP addresses with different domains or profiles in your MTA. If INBOUND:PORT is used, ReportingReplies (Analyze,Help,etc and CopyMail will go to 127.0.0.1:PORT. If your needs are different, use smtpReportServer (SMTP Reporting Destination) and sendAllDestination (Copy Spam SMTP Destination). Separate multiple entries by "|".<small><i>Examples:</i> 125,  127.0.0.1:125, 127.0.0.1:125|127.0.0.5:125, INBOUND:125</small>','Basic',undef,'msg000030','msg000031'],
['smtpDestinationRT','SMTP Destination Routing Table*',80,\&textinput,'','^((?:(?:\s*'.$HostRe.'\s*=>\s*'.$HostPortRe.'\s*)(?:\|\s*'.$HostRe.'\s*=>\s*'.$HostPortRe.'\s*)*)|\s*file\s*:\s*.+|)$','configChangeRT',
  'If INBOUND is used in the SMTP Destination field, the rules specified here are used to route the inbound IP address to a different outbound IP address. You must specify a port number with the outbound IP address. <p><small><i>Example:</i>141.120.110.1=>141.120.110.129:25|141.120.110.2=>141.120.110.130:125|141.120.110.3=>141.120.110.130:125</small></p>',undef,undef,'msg000040','msg000041'],
['listenPortSSL','SMTP Secure Listen Port',80,\&textinput,'',$GUIHostPort,'ConfigChangeMailPortSSL',
  'The port number on which ASSP will listen for incoming secure SMTP connections (normally 465). You can specify both an IP address and port number to limit connections to a specific interface. Separate multiple entries by "|".<p><small><i>Examples:</i> 465, 127.0.0.1:465, 127.0.0.1:465|127.0.0.2:465 </small></p>',undef,undef,'msg000050','msg000051'],
['smtpDestinationSSL','SSL Destination',80,\&textinput,'',$GUIHostPort,undef,
  'The IP <b>address!</b> and port number to connect to when mail is received on the SSL listen port. If the field is blank, the primary SMTP destination will be used. <p><small><i>Examples:</i>127.0.0.1:565, 565</small></p>',undef,undef,'msg000060','msg000061'],
['listenPort2','Second SMTP Listen Port',80,\&textinput,'',$GUIHostPort,'ConfigChangeMailPort2',
  'A secondary port number on which ASSP can accept SMTP connections. This is useful as a dedicated port for VPN clients or for those who cannot directly send mail to a mail server outside of their ISP\'s network because the ISP is blocking port 25. You may also specify an IP address to limit connections to a specific interface. Separate multiple entries by "|".<p><small><i>Examples:</i> 2525, 127.0.0.1:2525, 192.168.0.100:25000</small></p>',undef,undef,'msg000070','msg000071'],
['smtpAuthServer','Second SMTP Destination',20,\&textinput,'',$GUIHostPort,undef,
  'The IP address and port number to connect to when mail is received on the second SMTP listen port. If the field is blank, the primary SMTP destination will be used. The purpose of this setting is to allow remote users to make authenticated connections and transmit their email without encountering SPF failures.<p><small><i>Examples:</i> 587, 127.0.0.1:587</small></p>',undef,undef,'msg000080','msg000081'],
['NoAUTHlistenPorts','Disable AUTH support on listenPorts',80,\&textinput,'','(.*)','ConfigChangeNoAUTHPorts',
  'This disables the SMTP AUTH command on the defined listenPorts. This option works for listenPort , listenPort2 and listenPortSSL . The listener definition here has to be the same like in the port definitions. Separate multiple entries by "|".<p><small><i>Examples:</i> 25, 127.0.0.1:25, 127.0.0.1:25|127.0.0.2:25 </small></p>',undef,undef,'msg008060','msg008061'],
['EnforceAuth',"Force SMTP AUTH on Second SMTP Listen Port",0,\&checkbox,0,'(.*)',undef,
  'Force clients connecting to the second listen port to authenticate before transferring mail. To use this setting, both listenPort2 (Second SMTP Listen Port) and smtpAuthServer (Second SMTP Destination) must be configured.<hr /><div class="menuLevel1">Notes On Network Setup</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/network.txt\',3);" />',undef,undef,'msg000090','msg000091'],

[0,0,0,'heading','SMTP Session Limits '],
['MaxErrors','Maximum Errors Per Session',5,\&textinput,'5','(\d+)',undef,
  'The maximum number of SMTP session errors encountered before the connection is dropped. An value of zero disables this feature. PB: meValencePB',undef,undef,'msg000100','msg000101'],

['maxSMTPSessions','Maximum Sessions',5,\&textinput,'64','(\d?\d?\d?)',undef,
  'The maximum number of simultaneous SMTP sessions. This can prevent server overloading and DoS attacks. 64 simultaneous sessions are typically enough. No entry or zero means no limit. Connections on relayPort will be counted, but connections on relayPort will never be limited because of this value. If the value is reached, assp will wait until the number of simultaneous SMTP sessions is lower than (value - 20) or (value * 0.75).',undef,undef,'msg000110','msg000111'],
['noMaxSMTPSessions','No Maximum Sessions IP numbers*',60,\&textinput,'','(\S*)','ConfigMakeIPRe','Mail from any of these IP numbers will pass through without checking maximum number of simultaneous SMTP sessions. For example: 145.145.145.145',undef,undef,'msg009160','msg009161'],
['maxSMTPipSessions','Maximum Sessions Per IP Address',3,\&textinput,'5','(\d?\d?\d?)',undef,
  'The maximum number of SMTP sessions allowed per IP address. Use this setting to prevent server overloading and DoS attacks. 5 sessions are typically enough. If left blank or set to 0 there is no limit imposed by ASSP. ispip (ISP/Secondary MX Servers) and acceptAllMail (Accept All Mail) matches are excluded from SMTP session limiting. PB: iplValencePB',undef,undef,'msg000120','msg000121'],

['HeaderMaxLength','Maximum Header Size',10,\&textinput,50000,'(\d*)',undef,
  'The maximum allowed header length, in bytes. At each mail hop header information is added by the mail server. A large mail header can indicate a mail loop. If the value is blank or 0 the header size will not be checked.',undef,undef,'msg000130','msg000131'],
['detectMailLoop','Detect Possible Mailloop',10,\&textinput,'3','(\d*)',undef,
 'If set to a value higher than 0, ASSP count it\'s own Received-header in the header of the mail. If this count exceeds the defined value, the transmission of the message will be canceled.',undef,undef,'msg008860','msg008861'],
['MaxEqualXHeader','Maximum Equal X-Header Lines*',40,\&textinput,'*=>20','^((?:.+?\s*=>\s*\d+(?:\s*\|.+?\s*=>\s*\d+)*)|\s*file\s*:\s*.+|)$','configUpdateStringToNum',
 'The maximum allowed equal X-header lines - eg. "X-SubscriberID". If the value is set to empty the header will not be checked for equal X-header lines. This check will be skipped for noprocessing, whitelisted and outgoing mails.<br />
  The default is "*=&gt;20", which means any X-header can occure 20 time maximum. You can define different values for different X-headers - wildcards like "*" and "?" are allowed to be used.<br />
  For example:<br />
  *=&gt;20|X-Notes-Item=&gt;100|X-Subscriber*=&gt;10|X-AnyTag=&gt;0<br />
  An value of zero disables the check for the defined X-header. The check is also skipped if no default like "*=&gt;20" is defined and the X-header defintion is not found.',undef,undef,'msg009060','msg009061'],

['maxRealSize','Max Real Size of Local Message',10,\&textinput,'','(\d*)',undef,
 'If the value of (number of [rcpt to] * [message size]) exceeds maxRealSize in bytes the transmission of the local message will be canceled. No limit is imposed by ASSP if the field is left blank or set to 0. This option allows admins to limit useless bandwidth wasting based on the total transmit size.',undef,undef,'msg000140','msg000141'],
['MaxRealSizeAdr','Max Real Size of Local Message Addresses*',40,\&textinput,'file:files/MaxRealSize.txt','(\s*file\s*:\s*.+|)','configUpdateMaxSize',
'Use this parameter to set individual maxRealSize values for email addresses, domains, user names and IP addresses. A file must be specified if used.<br />
Accepts specific addresses (user@domain.com), user parts (user), entire domains (@domain.com) and IP addresses (CIDR notation like 123.1.101/32 is here not supported!) - group definitions could be used. Use one entry per line. Wildcards are supported (fribo*@domain.co?). A second parameter separated by "=>" specifies the size limit. <br />
For example:<br />
fribo*@thisdomain.co?=&gt;1000000<br />
jhanna=&gt;0<br />
@sillyguys.org=&gt;500000<br />
101.1.2.*=&gt;0<br />
[admins]=&gt;0 <br />
If multiple matches (values) are found in a mail for any IP address in the transport mail chain, any envelope recipient and the envelope sender, the highest value or 0 (no limit) will be used! If no match (value) is found in a mail, the definition in maxRealSize will take place.'
,undef,undef,'msg009490','msg009491'],
['maxRealSizeExternal','Max Real Size of External Message',10,\&textinput,'','(\d*)',undef,
 'If the value of (number of [rcpt to] * [message size]) exceeds maxRealSizeExternal in bytes the transmission of the external message will be canceled. No limit is imposed by ASSP if the field is left blank or set to 0. This option allows admins to limit useless bandwidth wasting based on the total transmit size.',undef,undef,'msg000150','msg000151'],
['MaxRealSizeExternalAdr','Max Real Size of External Message Addresses*',40,\&textinput,'file:files/MaxRealSizeExt.txt','(\s*file\s*:\s*.+|)','configUpdateMaxSize',
'Use this parameter to set individual maxRealSizeExternal values for email addresses, domains, user names and IP addresses. A file must be specified if used.<br />
Accepts specific addresses (user@domain.com), user parts (user), entire domains (@domain.com) and IP addresses (CIDR notation like 123.1.101/32 is here not supported!) - group definitions could be used. Use one entry per line. Wildcards are supported (fribo*@domain.co?). A second parameter separated by "=>" specifies the size limit. <br />
For example:<br />
fribo*@thisdomain.co?=&gt;1000000<br />
jhanna=&gt;0<br />
@sillyguys.org=&gt;500000<br />
101.1.2.*=&gt;0<br />
[admins]=&gt;0 <br />
If multiple matches (values) are found in a mail for any IP address in the transport mail chain, any envelope recipient and the envelope sender, the highest value or 0 (no limit) will be used! If no match (value) is found in a mail, the definition in maxRealSizeExternal will take place.'
,undef,undef,'msg009500','msg009501'],
['maxRealSizeError','max real message size Error',80,\&textinput,'552 message exceeds MAXREALSIZE byte (size * rcpt)','(552 .*)',undef,'SMTP error message to reject maxRealSize / maxRealSizeExternal exceeding mails. For example:552 message exceeds MAXREALSIZE byte (size * rcpt)! MAXREALSIZE will be replaced by the value of maxRealSize / maxRealSizeExternal.',undef,undef,'msg000160','msg000161'],

['maxSize','Max Size of Local Message',10,\&textinput,'','(\d*)',undef,
 'If the value of ([message size]) exceeds maxSize in bytes the transmission of the local message will be canceled. No limit is imposed by ASSP if the field is left blank or set to 0. This option allows admins to limit useless bandwidth wasting based on the transmit size.',undef,undef,'msg008620','msg008621'],
['MaxSizeAdr','Max Size of Local Message Addresses*',40,\&textinput,'file:files/MaxSize.txt','(\s*file\s*:\s*.+|)','configUpdateMaxSize',
'Use this parameter to set individual maxSize values for email addresses, domains, user names and IP addresses. A file must be specified if used.<br />
Accepts specific addresses (user@domain.com), user parts (user), entire domains (@domain.com) and IP addresses (CIDR notation like 123.1.101/32 is here not supported!) - group definitions could be used. Use one entry per line. Wildcards are supported (fribo*@domain.co?). A second parameter separated by "=>" specifies the size limit. <br />
For example:<br />
fribo*@thisdomain.co?=&gt;1000000<br />
jhanna=&gt;0<br />
@sillyguys.org=&gt;500000<br />
101.1.2.*=&gt;0<br />
[admins]=&gt;0 <br />
If multiple matches (values) are found in a mail for any IP address in the transport mail chain, any envelope recipient and the envelope sender, the highest value or 0 (no limit) will be used! If no match (value) is found in a mail, the definition in maxSize will take place.'
,undef,undef,'msg009510','msg009511'],
['maxSizeExternal','Max Size of External Message',10,\&textinput,'','(\d*)',undef,
 'If the value of ([message size]) exceeds maxSizeExternal in bytes the transmission of the external message will be canceled. No limit is imposed by ASSP if the field is left blank or set to 0. This option allows admins to limit useless bandwidth wasting based on the transmit size.',undef,undef,'msg008630','msg008631'],
['MaxSizeExternalAdr','Max Size of External Message Addresses*',40,\&textinput,'file:files/MaxSizeExt.txt','(\s*file\s*:\s*.+|)','configUpdateMaxSize',
'Use this parameter to set individual maxSizeExternal values for email addresses, domains, user names and IP addresses. A file must be specified if used.<br />
Accepts specific addresses (user@domain.com), user parts (user), entire domains (@domain.com) and IP addresses (CIDR notation like 123.1.101/32 is here not supported!) - group definitions could be used. Use one entry per line. Wildcards are supported (fribo*@domain.co?). A second parameter separated by "=>" specifies the size limit. <br />
For example:<br />
fribo*@thisdomain.co?=&gt;1000000<br />
jhanna=&gt;0<br />
@sillyguys.org=&gt;500000<br />
101.1.2.*=&gt;0<br />
[admins]=&gt;0 <br />
If multiple matches (values) are found in a mail for any IP address in the transport mail chain, any envelope recipient and the envelope sender, the highest value or 0 (no limit) will be used! If no match (value) is found in a mail, the definition in maxSizeExternal will take place.',undef,undef,'msg009520','msg009521'],
['maxSizeError','max message size Error',80,\&textinput,'552 message exceeds MAXSIZE byte (size)','(552 .*)',undef,'SMTP error message to reject maxSize / maxSizeExternal exceeding mails. For example:552 message exceeds MAXSIZE byte (size)! MAXSIZE will be replaced by the value of maxSize / maxSizeExternal.',undef,undef,'msg008640','msg008641'],

['MaxAUTHErrors','Max Number of AUTHentication Errors',10,\&textinput,'','(\d*)',undef,
 'If an IP (/24 network is used) exceeds this number of authentication errors (535 or 530) the transmission of the current message will be canceled and any new connection from that IP will be blocked for 5-10 minutes.<br />
  Every 5 Minutes the \'AUTHError\' -counter of the IP will be decreased by one. autValencePB is used for the penalty box.<br />
  No limit is imposed by ASSP if the field is left blank or set to 0. This option allows admins to prevent external bruteforce or dictionary attacks via AUTH command. Whitelisted, noBlockingIPs and NoProcessing IP\'s are ignored like any relayed connection.',undef,undef,'msg009310','msg009311'],
['noMaxAUTHErrorIPs','Do not check MaxAUTHErrors for these IP\'s*',40,\&textinput,'','(\S*)','ConfigMakeIPRe','List of IP\'s which should not be checked for MaxAUTHErrors .  For example: 145.145.145.145|145.146.',undef,undef,'msg009580','msg009581'],

['DoSameSubject','Check Same Subjects','0:disabled|1:block|2:monitor|3:score|4:testmode',\&listbox,0,'(.*)',undef,
 'If activated, assp will check the mail subjects for equality using the config parameters below. Scoring is done with \'isValencePB\'.',undef,undef,'msg010040','msg010041'],

['subjectFrequencyInt','Subject Frequency Interval',40,\&textinput,'300','(\d*)',undef,'The time interval in seconds in which the number of equal subjects has not to exceed a specific number ( subjectFrequencyNumSubj ).<br />
  Use this in combination with subjectFrequencyNumSubj to limit the number of equal subjects in a given interval. A value of 0 (default) will disable this feature and clean the cache within five minutes.<br />
  <input type="button" value="edit Subject Frequency Cache" onclick="javascript:popFileEditor(\'DB-subjectFrequencyCache\',\'1h\');" />',undef,undef,'msg010050','msg010051'],

['subjectFrequencyNumSubj','Subject Frequency Number of Subjects',40,\&textinput,'5','(\d*)',undef,'The number of equal sbujects that has not to exceed in a specific time interval ( subjectFrequencyInt ).<br />
  Use this in combination with subjectFrequencyInt to limit the number of equal subjects in a given interval. A value of 0 (default) will disable this feature and clean the cache within five minutes.<br />
  <input type="button" value="edit Subject Frequency Cache" onclick="javascript:popFileEditor(\'DB-subjectFrequencyCache\',\'1h\');" />',undef,undef,'msg010060','msg010061'],

['subjectFrequencyOnly','Check Equal Subject Frequency for this Users only*',60,\&textinput,'','(.*)','ConfigMakeSLRe',
 'A list of local addresses, for which the \'subject frequency check\' should be done. Leave this field blank (default), to do the check for every address.<br />
  Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com).  Wildcards are supported (fribo*@domain.com).<br />
  For example: fribo*@thisdomain.com|jhanna|@sillyguys.org ',undef,undef,'msg010070','msg010071'],

['NoSubjectFrequency','Check Equal Subject Frequency NOT for this Users*',60,\&textinput,'','(.*)','ConfigMakeSLRe',
 'A list of local addresses, for which the \'subject frequency check\' should not be done.<br />
  Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com).  Wildcards are supported (fribo*@domain.com).<br />
  For example: fribo*@thisdomain.com|jhanna|@sillyguys.org ',undef,undef,'msg010080','msg010081'],

['NoSubjectFrequencyIP','Check Equal Subject Frequency NOT for this IP\'s*',60,\&textinput,'','(\S*)','ConfigMakeIPRe','Mail from any of these IP numbers will pass through without checking the equality of subjects. For example: 145.145.145.145',undef,undef,'msg010090','msg010091'],

['smtpIdleTimeout','SMTP Idle Timeout',5,\&textinput,'180','(\d?\d?\d?\d?)',undef,
 'The number of seconds a session is allowed to be idle before being forcibly disconnected. The default is 180 seconds. No limit is imposed by ASSP if the field is left blank or set to 0. If you have not defined an IdleTimeout on your MTA, this value should not be set to 0, because then a connection will never be timed out!',undef,undef,'msg000170','msg000171'],
['NpWlTimeOut','SMTP Idle Timeout for Whitelisted an Noprocessing',5,\&textinput,'1200','(\d?\d?\d?\d?)',undef,
 'The number of seconds a whitelisted or noprocessing session is allowed to be idle before being forcibly disconnected. The default is 1200 seconds. No limit is imposed by ASSP if the field is left blank or set to 0. If you have not defined an IdleTimeout on your MTA, this value should not be set to 0, because then a connection will never be timed out!',undef,undef,'msg009860','msg009861'],
['smtpNOOPIdleTimeout','SMTP Idle Timeout after NOOP',5,\&textinput,'0','(\d?\d?\d?\d?)',undef,
 'The number of seconds a session is allowed to be idle after a "NOOP" command is received, before being forcibly disconnected. The default is 0 seconds. No limit is imposed by ASSP if the field is left blank or set to 0.<br />
  This should prevent hackers to hold and block connections by sending "NOOP" commands short before the "smtpIdleTimeout" is reached.',undef,undef,'msg000180','msg000181'],
['smtpNOOPIdleTimeoutCount','SMTP Idle Timeout after NOOP Count',5,\&textinput,'0','(\d?\d?)',undef,
 'The number of counts a session is allowed send "NOOP" commands following on each other, before being forcibly disconnected. The default is 0. No limit is imposed by ASSP if the field is left blank or set to 0.<br />
  This in cooperation with "smtpNOOPIdleTimeout" should prevent hackers to hold and block connections by sending repeatedly "NOOP" commands short before the "smtpNOOPIdleTimeout" is reached. If "smtpNOOPIdleTimeout" is not defined or 0, this value will be ignored!<hr /><div class="menuLevel1">Notes On SMTP Session Limits</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/sessionlimits.txt\',3);" />',undef,undef,'msg000190','msg000191'],

[0,0,0,'heading','Group definition'],
['Groups','Address and Domain Groups*',80,\&textinput,'','(\s*file\s*:\s*.+|)','ConfigMakeGroupRe','
 If you don\'t want to use group definitions, leave this field blank otherwise a file definition like \'file:files/groups.txt\' is required.<br/>
 Group definitions could be used in any other configuration value where multiple user names, email addresses or domain names or IP addresses could be defined.<br />
 Groups are defined and used using the same syntax [group-name] (including the brackets) in a single line. In the configuration parameters, the line [group-name] will be replaced by the content of the group definition, that is done here.<br />
 All group definitions are case sensitive. Group names can only contain the following characters: A-Z, a-z, 0-9, - , _ and @ !<br />
 The structure of this file has to be as follows:<br />
 <br />
 [super_spamlovers]<br />
 myBoss<br />
 ldap:{host=&gt;my_LDAP_server:389,base=&gt;(sep)DC=domain,DC=tld(sep),user=&gt;(sep)CN=admin,DC=domain(sep),password=&gt;(sep)pass(sep),timeout=&gt;2,scheme=&gt;ldap,STARTTLS=&gt;1,version=&gt;3},{(CN=management)}{member},{(CN=%USERID%)}{mailaddress}<br />
 entry<br />
 exec:/usr/bin/list_postfix_users --domain mydomain --group postoffice<br />
 entry<br />
 ...<br />
 <br />
 [admins]<br />
 ldap:{host=&gt;domino1.mydomain.com:389,base=&gt;(sep)DC=domain,DC=tld(sep),user=&gt;(sep)Administrator(sep),password=&gt;(sep)pass(sep),timeout=&gt;2,scheme=&gt;ldap,STARTTLS=&gt;1,version=&gt;3},{(CN=LocalDomainAdmins)}{member},{(CN=%USERID%)}{mailaddress}<br />
 entry<br />
 entry<br />
 ...<br />
 <br />
 [specialIPList]<br />
 1.2.3.4<br />
 123.234.0.0/16<br />
 ::1<br />
 <br />
 Lines starting with a # OR ; are consider a comment. Empty lines will be ignored. An group definition stopps, if a new group definition starts or at the end of the file. Comments are not allowed inside a definition line.<br />
 <br />
 There are two possible methodes to import entries from an external source in to a group - the execution of a system command or a LDAP query.<br />
 To import entries via a system command like (eg. cat|grep or find or your self made shell script), write a single line that begins with exec: followed by the command to be executed - like:<br />
 exec:cat /etc/anydir/*.txt|grep \'@\'<br />
 The executed system command has to write a comma(,) or pipe(|) or linefeed(LF,CRLF) separated list of entries to STDOUT, that should become part of that group, where this line is used. There could be multiple and any combination of entry types in one group definition.<br />
 <br />
 If you are familar with the usage of LDAP, you can define LDAP querys to import entries from one or more LDAP server. This is done, defining one query per line. The syntax of such a line is:<br />
 <br />
 ldap:{host_and_protocol},{LDAP_group_query_filter}{LDAP_group_query_attribut_to_return},{LDAP_entry_query_filter}{LDAP_entry_query_attribut_to_return}<br />
 <br />
 If the \'host_and_protocol\' part is empty {}, the default LDAP configuration will be used. An \'host_and_protocol\' part should contain the following entries in the following structure:<br />
 {host=&gt;127.0.0.1:389,base=&gt;(sep)DC=domain,DC=tld(sep),user=&gt;(sep)...(sep),password=&gt;(sep)pass(sep),timeout=&gt;..,scheme=&gt;ldap/ldaps,STARTTLS=&gt;0/1,version=&gt;2/3}<br />
 The \'host\' has to be set, if you want to define any other LDAP parameter. If any other parameter is not defined, the default LDAP configuration value will be used, except user and password. The port definition (:xxx) in the host setting is optional - if not defined, the default LDAP ports 389(LDAP) and 636(LDAPS) will be used. It is possible to define a comma(,) separated list of hosts for failover functionality like \'host=>"localhost:389,192.168.1.1:389,...."\' - notice the quotes as terminator which are required in this case!<br />
 The value of the base, password and user parameter has to start and end with a single character (sep) as terminator, that is not part of the value
 and is not used in the value. The parameter "base" defines the LDAP search root like LDAPRoot .<br />
 <br />
 The \'LDAP_group_query_filter\' and \'LDAP_group_query_attribut_to_return\' are used to query a LDAP group for it\'s members (users). The resulting list will contain the requested attributes of all group members. The definition of these two parameters could look as follows:<br />
 {(&(objectclass=dominoGroup)(CN=LocalDomainAdmins))}{member}<br />
 <br />
 It is possible to modify each returned value with a callback-code. This is for example usefull for MS-AD querys on the attribute \'proxyaddresses\', which returns a list of all available mail addresses (SMTP,smtp,X400...).
 <br />
 example: ldap:{},{(&(CN=firstname lastname)(proxyaddresses=smtp:*))<=s/^\s*smtp:\s*(.+)\s*$/$1/i}{proxyaddresses},{}{}
 <br />
 <= is the required separator, s/^\s*smtp:\s*(.+)\s*$/$1/i is the callback code.<br />
 The callback code has to return a value of not zero or undef on success. The code gets the LDAP result in the variable $_ and has to modify this variable in place on success.<br />
 It is not allowed to use any of the following characters in the callback definiton of a ldap line: {}| <br />
 <br />
 The \'LDAP_entry_query_filter\' and \'LDAP_entry_query_attribut_to_return\' are used to query each member from the first query, for it\'s email address. The literal \'%USERID%\' in the \'LDAP_entry_query_filter\' will be replaced by each LDAP-attribute result of the first query. The definition of these two parameters could look as follows:<br />
 {(&(objecttype=person)(CN=%USERID%)(o=%USERID%))}{mailaddress}<br />
 or more simple<br />
 {(&(objecttype=person)(CN=%USERID%))}{mailaddress}<br />
 <br />
 An callback code could be used the same way like for \'LDAP_group_query_filter\' - {(&(objecttype=person)(CN=%USERID%))<=callback-code}{mailaddress}.
 <br />
 To break long lines in to multiple, terminate a continued line with a slash "/"<br /><br />
 If you are able to get all results (eg. email addresses or domain names) with the \'LDAP_group_query\' query, leave the definition of \'LDAP_entry_query_filter\' and \'LDAP_entry_query_attribut_to_return\' empty {}{}.<br />
 <br />
 The result of each group definition will be stored in a file in files/group_export/GROUPNAME.txt.<br />
 The groups are build at every start of assp and if the defined file or an include file is stored (changed file time). To force a reload of all groups, open the file and click \'Save changes\' or change the file time with an external shell script. It is also possible to use GroupsReloadEvery, to reload the Groups definition in time intervals, if the exec: or ldap: option are used.','Basic',undef,'msg009470','msg009471'],
['GroupsReloadEvery','Reload the Groups definitions every this minutes <sup>s</sup>',40,\&textinput,60,$ScheduleGUIRe,'configChangeSched',
 'ASSP will reload the Groups definiton every this minutes, if the exec: or ldap: option is used in Groups. <br />
 An value of zero disables the scheduled reload. Defaults to 60 minutes.<br />
 <hr /><div class="menuLevel1">Notes On Group Definitions</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/groupsdef.txt\',3);" />','Basic',undef,'msg007910','msg007911'],

[0,0,0,'heading','SPAM Control <a href="http://apps.sourceforge.net/mediawiki/assp/index.php?title=Getting_Started" target=wiki><img height=12 width=12 src="' . $wikiinfo . '" alt="Getting Started" /></a>'],
['redRe','Regular Expression to Identify Redlisted Mail*',80,\&textinput,'file:files/redre.txt','(.*)','ConfigCompileRe',
 'If an email matches this Perl regular expression it will be considered redlisted.<br />
 redRe detects tags to process a mail like the recipient were redlisted - nothing else (no redlist addition/removal).<br />
 The Redlist serves two purposes:<br />
1) the Redlist is a list of addresses that cannot contribute to the
whitelist and which are not considered local even if their mail is
from a local computer. For example, if someone goes on a vacation and
turns on their autoresponder, put them on the redlist until
they return. Then as they reply to every spam they receive they won\'t
corrupt your non-spam collection or whitelist: \[autoreply\]<br />
2) Redlisted addresses will not be added to the Whitelist when your
local user sends mail to that address, thereby preventing accidental
pollution of the Whitelist by, say, inadvertent replies by your
users to mails from the spammer.<br />
Redlisted messages will not be stored in the SPAM/NOTSPAM-collection. As all fields marked by * this field accepts
a list separated by | or a specified file \'file:files/redre.txt\'. ',undef,undef,'msg000200','msg000201'],
['EmailWhiteRemovalToRed','Add  Whitelist Removals To Redlist ',0,\&checkbox,'','(.*)',undef,
  'If set addresses which are removed from Whitelist via email-interface will automatically be added to the Redlist. The address can only be added again to the Whitelist after it is removed from the Redlist.',undef,undef,'msg000210','msg000211'],
['SpamError','Spam Error',80,\&textinput,'554 5.7.1 Mail appears to be unsolicited -- send error reports to postmaster@LOCALDOMAIN','([245]\d\d .*)',undef,'SMTP error message to reject spam. The literal LOCALDOMAIN will be replaced by the recipient domain. For example:554 5.7.1 Mail appears to be unsolicited -- send error reports to postmaster@LOCALDOMAIN. ',undef,undef,'msg000220','msg000221'],
['noGriplistUpload','Don\'t Upload Griplist Stats',0,\&checkbox,'','(.*)',undef,
 'Check this to disable the Griplist upload when rebuildspamdb runs. The Griplist contains IPs and their value between 0 and 1, lower is less spammy, higher is more spammy. This value is called the grip value. ',undef,undef,'msg000230','msg000231'],
['noGriplistDownload','Don\'t auto-download the Griplist file',0,\&checkbox,'','(.*)',undef,
 'Set this checkbox, if you don\'t use the Griplist. You have to disable also noGriplistUpload to download the Griplist.',undef,undef,'msg000240','msg000241'],

['StoreASSPHeader','Store Assp-Header into Spam Collection',0,\&checkbox,'','(.*)',undef,
 'Add "X-Assp-" to the collected spam-mails.',undef,undef,'msg008770','msg008771'],
['AddIntendedForHeader','Add Envelope-Recipient Header',0,\&checkbox,1,'(.*)',undef,
 'Adds two lines to the email header: "X-Assp-Intended-For: user@domain" and "X-Assp-Envelope-From: user@domain".',undef,undef,'msg000250','msg000251'],
['NoExternalSpamProb','Block Outgoing Spam-Prob header',0,\&checkbox,1,'(.*)',undef,
'Check this box if you don\'t want your X-Assp-Spam-Prob header on external mail<br />
 Note this means mail from local users to local users will also be missing the header.',undef,undef,'msg000260','msg000261'],
['AddSpamHeader','Add Spam Header',0,\&checkbox,1,'(.*)',undef,
 'Adds a line to the email header "X-Assp-Spam: YES" if the message is spam.',undef,undef,'msg000270','msg000271'],
['AddCustomHeader','Add Custom Header',80,\&textinput,'X-Spam-Status:yes','^(|X\-[A-Za-z0-9_.-]+?:.*)$',undef,
 'Adds a line to the email header if the message is spam. For example: <a href="http://exchangepedia.com/blog/2008/01/assigning-scl-to-messages-scanned-by.html">X-Spam-Status:yes<img src="' . $wikiinfo . '" alt="Assigning SCL to messages scanned by 3rd-party antispam filters" /></a>',undef,undef,'msg000280','msg000281'],
['AddLevelHeader','Add Graphical Level Header',0,\&checkbox,1,'(.*)',undef,
 'Adds a line to the email header "X-Assp-Spam-Level: **** " showing the total message score represented by stars (1 - 20), every star represents five scoring points.',undef,undef,'msg000290','msg000291'],
['AddSubjectHeader','Add X-ASSP-Original-Subject Header',1,\&checkbox,'','(.*)',undef,
 'Adds a line to the email header "X-ASSP-Original-Subject: the subject".',undef,undef,'msg000300','msg000301'],
['AddSpamReasonHeader','Add Spam Reason Header',0,\&checkbox,1,'(.*)',undef,
 'Adds a line to the email header "X-Assp-Spam-Reason: " explaining why the message is spam.<br /><hr /><div class="menuLevel1">Notes On Spam Control</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/spamcontrol.txt\',3);" />',undef,undef,'msg000310','msg000311'],

[0,0,0,'heading','Copy Spam & Ham'],
['sendAllSpam','Copy Spam and Send to this Address',80,\&textinput,'','(.*)',undef,
 'If this is set ASSP will deliver a copy of spam mails to this address. For example: spammaster@mydomain.com. The literal USERNAME is replaced by the user part of the recipient, the literal DOMAIN is replaced by the domain part of the recipient.
 For example: USERNAME@Spam.DOMAIN, USERNAME+Spam@DOMAIN, catchallspamthis@DOMAIN. Separate multiple entries by comma or space. To deliver copy of spams based on the domain name (only some special hosted domains), use ccSpamInDomain .','Basic',undef,'msg000320','msg000321'],
['ccSpamInDomain','Copy Spam and Send to this Address per Domain*',60,\&textinput,'','(.*)','configUpdateCCD',
 'ASSP will deliver an additional copy of spam emails of a domain to this address (even if sendAllSpam is not set) - if the domain of the recipient-address is matched. For example: monitorspam@example1.com|monitor@example2.com.','Basic',undef,'msg008880','msg008881'],
['sendAllDestination','Copy Spam SMTP Destination',20,\&textinput,'','^('.$PortRe.'|'.$HostPortRe.'|)$',undef,
 'Port to connect to when  Spam messages are copied. If blank they go to the main SMTP Destination. eg "10.0.1.3:1025", "1025", etc.',undef,undef,'msg000330','msg000331'],
['ccSpamFilter','Copy Spam to these Recipients Only*',40,\&textinput,'','(.*)','ConfigMakeSLRe',
 'Restricts Copy Spam to these recipients. Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com). Wildcards are supported (fribo*@domain.com).',undef,undef,'msg000340','msg000341'],
['ccSpamAlways','Copy Spam to these Recipients always*',40,\&textinput,'','(.*)','ConfigMakeSLRe',
 'Copy Spam to these recipients regardless of collection mode. Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com).  Wildcards are supported (fribo*@domain.com).',undef,undef,'msg000350','msg000351'],
['ccSpamNeverRe','Do Not Copy Spam Regex*',40,\&textinput,'','(.*)','ConfigCompileRe',
 'Never Copy Spam regardless of collection mode. Put anything here to identify messages which should not be copied.',undef,undef,'msg000360','msg000361'],
['ccMaxScore','Do Not Copy Messages Above This MessageTotal score',3,\&textinput,'','(\d*)',undef,
 'Messages whose score exceeds this threshold will not be copied.  For example: 75',undef,undef,'msg000370','msg000371'],
['ccMaxBytes','Restrict Copy Spam to MaxBytes',0,\&checkbox,1,'(.*)',undef,
 'CCMail will cut off Spam mails, thereby reducing the load considerably (recommended).',undef,undef,'msg000380','msg000381'],
['spamSubjectCC','Prepend Spam Subject to Copied Spam',0,\&checkbox,'','(.*)',undef,
 'If set, spamSubject gets prepended to the subject of the copied message.',undef,undef,'msg000390','msg000391'],
['spamTagCC','Prepend Spam Tag to Copied Spam',0,\&checkbox,1,'(.*)',undef,'The check which caused the spam detection will be prepended to the subject of the message. For example: [DNSBL]',undef,undef,'msg000400','msg000401'],
['sendAllHamDestination','Copy Not-Spam SMTP Destination',20,\&textinput,'','^('.$PortRe.'|'.$HostPortRe.'|)$',undef,
 'Port to connect to when  Ham messages are copied. If blank they go to the Spam SMTP Destination. eg "10.0.1.3:1025", "1025", etc.',undef,undef,'msg000410','msg000411'],
['sendHamInbound','Copy Incoming Not-Spam and Send to this Address',20,\&textinput,'','(.*)',undef, 'If you put an address in this box  ASSP will forward a copy of notspam messages from outside to this address. The literal USERNAME is replaced by the user part of the recipient, the literal DOMAIN is replaced by the domain part of the recipient. For example: archiv@mydomain.com, USERNAME@mybackup.domain, catchallforthis@DOMAIN',undef,undef,'msg000420','msg000421'],
['sendHamOutbound','Copy Outgoing Not-Spam and Send to this Address',20,\&textinput,'','(.*)',undef, 'If you put an address in this box ASSP will forward a copy of outgoing notspam messages to this address.',undef,undef,'msg000430','msg000431'],
['ccHamFilter','Copy Ham Filter*',40,\&textinput,'','(.*)','ConfigMakeSLRe',
 'Copy Not-Spam to these addresses only. Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com). Wildcards are supported (fribo*@domain.com).',undef,undef,'msg000440','msg000441'],
['ccnHamFilter','Do Not Copy Ham Filter*',40,\&textinput,'','(.*)','ConfigMakeSLRe',
 'Do Not Copy Ham to these addresses. Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com). Wildcards are supported (fribo*@domain.com).',undef,undef,'msg000450','msg000451'],
['ccMailReplaceRecpt','ccMail Recipient Replacement',0,\&checkbox,'','(.*)',undef,'The recipient replacement (ReplaceRecpt) rules from the "Recipients/Local Domains" section, will be used to replace ccMail recipients. For example: sendHamInbound = USERNAME@yourspamdomain.lan - in this case you are able to detect the target domain "yourspamdomain.lan" in a rule and you can replace the recipient/domain depending on its values and/or on the senders address.<br />
<hr /><div class="menuLevel1">Notes On CC Messages</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/copymail.txt\',3);" />',undef,undef,'msg000460','msg000461'],

[0,0,0,'heading','SPAM Lover/Hater'],
['spamSubjectSL','Suppress SpamSubject to Spam-Lover-Messages',0,\&checkbox,'','(.*)',undef,
 'If set, spamSubject and spamTag does NOT get prepended to the subject of the Spam-Lover-Message.',undef,undef,'msg000470','msg000471'],
['spamTagSL','Suppress SpamTags to Spam-Lover-Messages',0,\&checkbox,1,'(.*)',undef,
 'If set, spamTags does NOT get prepended to the subject of the Spam-Lover-Message.',undef,undef,'msg000480','msg000481'],
['groupSpamLovers',"Group SpamLovers and Not SpamLovers per mail",0,\&checkbox,'','(.*)',undef,
 'If set, the first envelope recipient consider a mail to be for spamlovers or not. If the first envelope recipient is any SpamLover, all other (following) envelope recipients must be also any SpamLover (or reverse) - if not, their address will be not accepted by ASSP for this single mail and \'452 too many recipients\' will be sent.',undef,undef,'msg008800','msg008801'],
['spamLovers','All Spam-Lover*',60,\&textinput,'postmaster|abuse','(.*)','ConfigMakeSLReSL',
 'Messages to Spam-Lovers are processed and filtered by ASSP, but get tagged with spamSubject and are not blocked. When a
 Spam-Lover is not the sole recipient of a message, the message is processed
 normally, and if it is found to be spam, it will not be delivered to the
 Spam-Lover. Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com). Wildcards are supported (fribo*@domain.com). Default: postmaster|abuse.<br />For example: fribo*@thisdomain.com|jhanna|@sillyguys.org
 <hr>
 This option and all SpamLover-Options below accepting a second score parameter like "user@your-domain.com=>70"<br />
 If such a parameter is defined in any option for an entry and the recipient address matches this entry and the message score exceeds the parameter value, the message will be blocked.<br />
 If there are multiple possible matches for a recipient address found, the generic longest match (and value) will be used.<br />
 ASSP will use the highest found value for all recipients of an email.',undef,undef,'msg000490','msg000491'],
['SpamLoversRe','Regular Expression to Identify  Spam-Lover*',60,\&textinput,'','(.*)','ConfigCompileRe',
'If a message matches this regular expression it will be considered a Spam-Lover message.',undef,undef,'msg000500','msg000501'],
['baysSpamLovers','Bayesian Spam-Lover*',60,\&textinput,'','(.*)','ConfigMakeSLReSL','',undef,undef,'msg000510','msg000511'],
['baysSpamLoversRe','Regular Expression to Identify Bayesian Spam-Lover*',60,\&textinput,'','(.*)','ConfigCompileRe',
 'If a message matches this regular expression it will be considered a Bayesian Spam-Lover message. For example: passwor|news',undef,undef,'msg000520','msg000521'],
['baysSpamLoversRed','Do not store Bayesian Spam-Lover in SpamDB',0,\&checkbox,'','(.*)',undef,
 'If set, mail to Bayesian Spam-Lover will not be stored in Spam/Notspam folder.',undef,undef,'msg000530','msg000531'],
['blSpamLovers','Blacklisted Domains Spam-Lover*',60,\&textinput,'','(.*)','ConfigMakeSLReSL','',undef,undef,'msg000540','msg000541'],
['bombSpamLovers','Bomb Spam-Lover*',60,\&textinput,'','(.*)','ConfigMakeSLReSL','',undef,undef,'msg000550','msg000551'],
['hlSpamLovers','HELO Blacklisted Spam-Lover*',60,\&textinput,'','(.*)','ConfigMakeSLReSL','',undef,undef,'msg000560','msg000561'],
['hiSpamLovers','Valid/Invalid Helo*',60,\&textinput,'','(.*)','ConfigMakeSLReSL','',undef,undef,'msg000570','msg000571'],
['atSpamLovers','Bad Attachment Spam-Lover*',60,\&textinput,'','(.*)','ConfigMakeSLReSL','',undef,undef,'msg000580','msg000581'],
['spfSpamLovers','SPF Failures Spam-Lover*',60,\&textinput,'','(.*)','ConfigMakeSLReSL','',undef,undef,'msg000590','msg000591'],
['rblSpamLovers','DNSBL Failures Spam-Lover*',60,\&textinput,'','(.*)','ConfigMakeSLReSL','',undef,undef,'msg000600','msg000601'],
['uriblSpamLovers','URIBL Failures Spam-Lover*',60,\&textinput,'','(.*)','ConfigMakeSLReSL','',undef,undef,'msg000610','msg000611'],
['srsSpamLovers','Unsigned SRS Bounces Spam-Lover *',60,\&textinput,'','(.*)','ConfigMakeSLReSL','',undef,undef,'msg000620','msg000621'],
['delaySpamLovers','No Delaying Spam-Lover*',60,\&textinput,'','(.*)','ConfigMakeSLReSL','',undef,undef,'msg000630','msg000631'],
['isSpamLovers','Invalid Sender Spam-Lover*',60,\&textinput,'','(.*)','ConfigMakeSLReSL','',undef,undef,'msg000640','msg000641'],
['mxaSpamLovers','Missing MX Spam-Lover*',60,\&textinput,'','(.*)','ConfigMakeSLReSL','',undef,undef,'msg000650','msg000651'],
['ptrSpamLovers','Invalid/Missing PTR Spam-Lover*',60,\&textinput,'','(.*)','ConfigMakeSLReSL','',undef,undef,'msg000660','msg000661'],
['pbSpamLovers','Penalty Box Blocking Spam-Lover *',60,\&textinput,'','(.*)','ConfigMakeSLReSL','',undef,undef,'msg000670','msg000671'],
['sbSpamLovers','Country Blocking Spam-Lover *',60,\&textinput,'','(.*)','ConfigMakeSLReSL','',undef,undef,'msg000680','msg000681'],
['spamHaters','All Spam-Haters*',60,\&textinput,'','(.*)','ConfigMakeSLRe',
 'Spam-Haters are used to override Spam-Lovers.
 Example: If you have set your entire domain as a Spam-Lover(s), but there are still some addresses you still wish to block spam for. If you add those addresses to the Spam-Haters field allows messages to only those addresses to be blocked while still allowing the messages to the other Spam-Lovers pass through. The message will only be blocked if all recipients are Spam-Haters. Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com).  Wildcards are supported (fribo*@domain.com).<br />For example: *fribo@thisdomain.com|jhanna|@sillyguys.org ',undef,undef,'msg000690','msg000691'],
['baysSpamHaters','Bayesian Spam-Hater*',60,\&textinput,'','(.*)','ConfigMakeSLRe','',undef,undef,'msg000700','msg000701'],
['rblSpamHaters','DNSBL Failures Spam-Hater*',60,\&textinput,'','(.*)','ConfigMakeSLRe','',undef,undef,'msg000710','msg000711'],
['hlSpamHaters','HELO Blacklisted Spam-Hater*',60,\&textinput,'','(.*)','ConfigMakeSLRe','',undef,undef,'msg000720','msg000721'],
['switchSpamLoverToScoring',"Switch Spam-Lover to Message Scoring",0,\&checkbox,'','(.*)',undef,
 'Put the filter automatically in "Message Scoring Mode" when DoPenaltyMessage is set (instead of stopping spam processing altogether).<br /><hr /> <div class="menuLevel1">Notes On Spam-Lover</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/spamlover.txt\',3);" />',,undef,undef,'msg000730','msg000731'],

[0,0,0,'heading','No Processing'],
['noProcessingIPs','No Processing IPs*',60,\&textinput,'file:files/ipnp.txt','(\S*)','ConfigMakeIPRe','Mail from any of these IP\'s will pass through without processing. <br />
 For example: 145.145.145.145|146.145.<br />
  To define IP\'s only for specific email addresses or domains (recipients) you must use the file:... option<br />
  An entry (line) may look as follows:<br />
  145.146.0.0/16=>*@local.domain|user@mydomain|user2@*.mydomain # comment<br /><br />
  It is possible to define a predefined group on any or both sides of the \'=>\' separator, like:<br />
  [ipgroup]=>[usergroup]|user@mydomain<br /><br />
  NOTICE: the following combination of two entries, will lead in to a user/domain based matching - the global entry will be ignored!<br />
  145.146.0.0/16 # comment<br />
  145.146.0.0/16=>*@local.domain|user@mydomain|user2@*.mydomain # comment<br />
  If multiple user/domain based entries are defined for the same IP, only the last one will be used!<br /><br />
 <span class="positive"> All fields marked by \'*\' accept  a filepath/filename : \'file:files/ipnp.txt\'.</span>',undef,'7','msg000740','msg000741'],
['noProcessing','No Processing Addresses*',60,\&textinput,'','(.*)','ConfigMakeSLRe',
 'Mail solely to or from any of these addresses are proxied without processing. Like a more efficient version of Spam-Lovers &amp; redlist combined. Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com).  Wildcards are supported (fribo*@domain.com).',undef,undef,'msg000750','msg000751'],
['noProcessingFrom','No Processing Addresses From*',60,\&textinput,'','(.*)','ConfigMakeSLRe',
 'Mail solely from any of these addresses are proxied without processing. Accepts specific addresses (user@example.com), user parts (user) or entire domains (@example.com).  Wildcards are supported (fribo*@example.com).',undef,undef,'msg000760','msg000761'],
['noProcessingDomains','No Processing Domains*',60,\&textinput,'sourceforge.net','(.*)','ConfigMakeRe',
 'Domains from which you want to receive all mail and  proxy without processing. Your ISP, domain registration, mail list servers, stock broker, or other key business partners might be good candidates. Note this matches the end of the address, so if you don\'t want to match subdomains then include the @. Note that buy.com would also match spambuy.com but .buy.com won\'t match buy.com. For example: sourceforge.net|@google.com|.buy.com',undef,undef,'msg000770','msg000771'],
['npRe','Regular Expression to Identify No Processing Mail*',60,\&textinput,'','(.*)','ConfigCompileRe',
 'If a message matches this Perl regular expression ASSP will treat the message as a \'No Processing\' mail. For example: 169\.254\.122\.|172\.16\.|\\[autoreply\\].',undef,undef,'msg000780','msg000781'],
['npSize','Message Size Limit',10,\&textinput,'500000','(.*)',undef,'ASSP will treat incoming messages larger than this SIZE (in bytes) as \'No Processing\' mail, after the header part of the mail is received without any error. Empty or 0 disables the feature.',undef,undef,'msg000790','msg000791'],
['npSizeOut','Message Size Limit Outgoing',10,\&textinput,'500000','(.*)',undef,'ASSP will treat outgoing messages larger than this SIZE (in bytes) as \'No Processing\' mail. Empty or 0 disables the feature. ',undef,undef,'msg000800','msg000801'],
['processOnlyAddresses','Process Only These Addresses*',80,\&textinput,'','(.*)','ConfigMakeSLRe','Mail solely to or from any of these addresses will be processed by ASSP. All others will be proxied without processing. Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com).  Wildcards are supported (fribo*@domain.com).<br /> Note that if an address matches both the NoProcessing and the OnlyTheseProcessing lists, the NoProcessing rules take precedence.',undef,undef,'msg000810','msg000811'],
['poTestMode','Enable Process Only Addresses',0,\&checkbox,'','(.*)',undef,'<br /><hr /><div class="menuLevel1">Notes On No Processing</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/noprocessing.txt\',3);" />',,undef,undef,'msg000820','msg000821'],

[0,0,0,'heading','Whitelisting'],
['whiteListedIPs','Whitelisted IPs*',80,\&textinput,'file:files/ipwl.txt','(\S*)','ConfigMakeIPRe',
 'They contribute to the Whitelist and to Notspam. For example: 145.145.145.145|146.145.|146.145.0.0/16. It is recommended to use the CIDR notation.<br />
  To define IP\'s only for specific email addresses or domains (recipients) you must use the file:... option<br />
  An entry (line) may look as follows:<br />
  145.146.0.0/16=>*@local.domain|user@mydomain|user2@*.mydomain # comment<br /><br />
  It is possible to define a predefined group on any or both sides of the \'=>\' separator, like:<br />
  [ipgroup]=>[usergroup]|user@mydomain<br /><br />
  NOTICE: the following combination of two entries, will lead in to a user/domain based matching - the global entry will be ignored!<br />
  145.146.0.0/16 # comment<br />
  145.146.0.0/16=>*@local.domain|user@mydomain|user2@*.mydomain # comment<br />
  If multiple user/domain based entries are defined for the same IP, only the last one will be used!<br /><br />
  <span class="positive"> All fields marked by \'*\' accept  a filepath/filename : \'file:files/ipwl.txt\'.</span>',undef,'7','msg000830','msg000831'],
['whiteRe','Regular Expression to Identify Non-Spam*',80,\&textinput,'','(.*)','ConfigCompileRe','If an incoming email matches this Perl regular expression it will be considered whitelisted.<br />For example: Secret Ham Password|307\D{0,3}730\D{0,3}4[12]\d\d<br />For help writing regular expressions click <a href="http://www.perlmonks.org/index.pl?node=perlre" rel="external">here</a>.<br />IMPORTANT: The body is scanned in a later stage  AFTER all sender related checks are performed. So a white regular expression here might not prevent the message to be blocked by eg. invalid PTR. Set the sender related checks to score only if you want to make sure that the white regular expression will be seen. Some things you might include here are your office phone number or street address, spam rarely includes these details.  .',undef,undef,'msg000840','msg000841'],
['whiteListedDomains','Whitelisted Domains and Addresses*',80,\&textinput,'file:files/whitedomains.txt','(.*)','ConfigMakePrivatRe','Domains and addresses from which you want to receive all mail. Your ISP, domain registration, mail list servers, stock broker, or other key business partners might be good candidates. Be careful not to put widely used domains here like google.com or hotmail.com. Our recommended approach is to put whitelisted domains into whiteSenderBase. Note this matches the end of the address, so if you don\'t want to match subdomains then include the @. Note that example.com would also match spamexample.com but .example.com won\'t match example.com. Wildcards are supported. For example: sourceforge.net|group*@google.com|.example.com<br /><br />
  It is possible to make email addresses whitelisted only for a set of local domains and/or local users. Use wildcards (* and ?) to define domains.<br />
  Use the following syntax to do this:<br />
  *@anydomain=>*@any_local_domain - for domain to domain<br />
  *@*.anydomain=>*@any_local_domain - for any sub-domain to domain<br />
  user@anydomain=>*@*.any_local_domain - for user to any sub-domain<br /><br />
  It is possible to define more than one entry at the left and the right side of the definition (=&gt;), like:<br />
  *@anydomain|*@other_domain=>*@any_local_domain|*@other_local_domain - always separate multiple entries by pipes<br />
  It is also possible to use a GroupDefinition in any or both sides, like:<br />
  [sendergroup]=>[recipientgroup]<br />
  [sendergroup1]|[sendergroup2]|*@domain=>[recipientgroup1]|[recipientgroup2]|user@local_domain<br /><br />
  NOTICE - that the local email addresses and domains are not checked to be local once',undef,undef,'msg000850','msg000851'],
['wildcardUser','Wildcard User for White Domain ',20,\&textinput,'*','(.*)',undef,'If you add this user via email-interface(eg: *@domain.com), the whole domain will be whitelisted. For example: \'*\'',undef,undef,'msg000860','msg000861'],
['ValidateRWL','Enable Realtime Whitelist Validation',0,\&checkbox,'','(.*)','configUpdateRWL','RWL: Real-time white list. These are lists of IP addresses that have
 somehow been verified to be from a known good host. Senders that pass RWL validation will pass IP-based filters. This requires an installed <a href="http://search.cpan.org/search?query=Net::DNS" rel="external">Net::DNS</a> module in PERL. ',undef,undef,'msg000870','msg000871'],
['RWLwhitelisting','Whitelist all RWL Validated Addresses',0,\&checkbox,'','(.*)',undef,'If set, the message will also pass Bayesian Filter and URIBL.',undef,undef,'msg000880','msg000881'],
['RWLServiceProvider','RWL Service Providers*',80,\&textinput,'file:files/dnsrws.txt','(.*)','configUpdateRWLSP','Host Names of RWLs to use separated by "|".<br />
 Examples are:<br />
 <p>list.dnswl.org|query.bondedsender.org|cml.anti-spam.org.cn|iadb.isipp.com|hul.habeas.com </p>',undef,undef,'msg000890','msg000891'],
['RWLmaxreplies','Maximum Replies',5,\&textinput,4,'(\d*)','configUpdateRWLMR','A reply is affirmative or negative reply from a RWL. The RWL module will wait for this number of replies (negative or positive) from the RWLs listed under Service Provider for up to the Maximum Time below. This number should be equal to or less than the number of RWL Service Providers listed to allow for randomly unavailable RWLs. ',undef,undef,'msg000900','msg000901'],
['RWLminhits','Minimum Hits',5,\&textinput,1,'(\d*)','configUpdateRWLMH','A hit is an affirmative response from a RWL. The RWL module will check all of the RWLs listed under Service Provider, and flag the email with a RWL pass flag if equal to or more than this number of RWLs return a postive whitelisted response. This number should be less than or equal to Maximum Replies above and greater than 0',undef,undef,'msg000910','msg000911'],
['RWLmaxtime','Maximum Time',5,\&textinput,10,'(\d*)',undef,'This sets the maximum time to spend on each message performing RWL checks',undef,undef,'msg000920','msg000921'],
['noRWL','Don\'t Validate RWL for these IPs*',80,\&textinput,'','(\S*)','ConfigMakeIPRe','Enter IP addresses that you don\'t want to be RWL validated, separated by pipes (|). For example: 145.145.145.145|146.145.',undef,'7','msg000930','msg000931'],
['AddRWLHeader','Add X-Assp-Received-RWL Header',0,\&checkbox,1,'(.*)',undef,'Add X-Assp-Received-RWL header to header of all mails processed by RWL.',undef,undef,'msg000940','msg000941'],
['RWLCacheInterval','RWL Cache Refresh Interval',4,\&textinput,7,'(\d+\.?\d*|)','configUpdateRWLCR','IP\'s in cache will be removed after this interval in days. 0 will disable the cache. <input type="button" value=" Show RWL Cache" onclick="javascript:popFileEditor(\'pb/pbdb.rwl.db\',5);" />',undef,undef,'msg000950','msg000951'],
['WhitelistPrivacyLevel','PrivacyLevel of the Whitelist','0:global & private(legacy)|1:domain & private|2:private only',\&listbox,0,'(.*)',undef,
 'Sets the privacy level of the whitelistdb . If an (local) user adds an email address to the whitelist:<br /><br />
  (0) global & private - this email address is automaticaly whitelisted for all other local users<br />
  (1) domain & private - this email address is automaticaly whitelisted for all other local users in the same local domain<br />
  (2) private only - this email address is only whitelisted for this single local user<br /><br />
  (0-1) unless another user has removed this email address from his whitelist. Default is zero, which is the legacy setting.<br />
  NOTICE: independend from this setting, the whitelistdb is filled with all three entries (global,domain,private), to make it possible to change this value.',undef,undef,'msg009740','msg009741'],
['MaxWhitelistDays','Max Whitelist/Personal Black Days',5,\&textinput,'365','(\d+)',undef,'This is the number of days an address will be kept on the whitelist and personal blacklist without any email to/from this address. Set it to 0 to keep the entries infinity.',undef,undef,'msg000960','msg000961'],
['WhitelistOnly','Reject All But Whitelisted Mail',0,\&checkbox,'','(.*)',undef,'Check this if you don\'t want Bayesian filtering and want to reject all mail from anyone not whitelisted. To do this related to local user addresses, use InternalAndWhiteAddresses and switch this option off.',undef,undef,'msg000970','msg000971'],
['NoAutoWhite','Only Email-Interface Addition to Whitelist.',0,\&checkbox,'','(.*)',undef,'Check this box to  allow additions to the whitelist by email interface only.',undef,undef,'msg000980','msg000981'],
['NoAutoWhiteAdresses','No AutoWhite Addresses*',60,\&textinput,'','(.*)','ConfigMakeSLRe',
 'Mail solely to or from any of these addresses are excluded from automatic whitelist additions. Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com).  Wildcards are supported (fribo*@domain.com).',undef,undef,'msg009970','msg009971'],
['NotGreedyWhitelist','Only the envelope-sender is added/compared to the whitelist','0:check all addresses|1:consider whitelisted if ANY match, only check the envelop|2:only consider whitelisted if ALL match',\&listbox,'0','(.*)',undef,'Normal operation includes addresses in the FROM, SENDER, REPLY-TO, ERRORS-TO, or LIST-* header fields.<br />
  This allows nearly all list email to be whitelisted. If set to \'envelope-sender only\', only this address is compared/added.<br />
  If set to \'check all addresses - one match for white - add all\', one match in any of this fields is enough to get white and all addresses will be added to whitelist.<br />
  If set to \'check all addresses - all matches for white - update all\', all defined addresses in all defined fields must be already whitelisted for a message to get a whitelisted state and all addresses will updated in whitelist.<br />
  If any address is found in redlist, no whitelist addition will be done and the message gets not white. Will not do anything if you add/remove whitelist entries via email-interface.',undef,undef,'msg000990','msg000991'],
['GreedyWhitelistAdditions','How add Greedy Senders to Whitelist','0:none|1:envelope only|2:all senders',\&listbox,1,'(.*)',undef,
  'Defines what sender addresses are added to the whitelist if a message is considered to be from a whitelisted sender. NotGreedyWhitelist is considered in determining if a message is from a whitelisted sender.',undef,undef,'msg008780','msg008781'],
['WhitelistLocalOnly','Only local or authenticated users contribute to the whitelist.',0,\&checkbox,'','(.*)',undef,'Normal operation allows all local, authenticated, or whitelisted users to contribute to the whitelist.<br />
  Check this box to not allow whitelisted users to add to the whitelist.',undef,undef,'msg001000','msg001001'],
['WhitelistLocalFromOnly','Only users with a local domain in mailfrom contribute to the whitelist.',0,\&checkbox,'1','(.*)',undef,'Check this box to prevent sender with non-local domains from contributing to the whitelist. (for example: redirected messages).',undef,undef,'msg001010','msg001011'],
['WhitelistAuth','Whitelist mails from authenticated users.',0,\&checkbox,'','(.*)',undef,'Mails from authenticated users will be processed as whitelisted.',undef,undef,'msg001020','msg001021'],
['UpdateWhitelist','Save Whitelist <sup>s</sup>',40,\&textinput,3600,$ScheduleGUIRe,'configChangeSched','Save a copy of the white list every this many seconds. Empty or Zero will prevent any saving and the cleanup of old records.<br />
  <hr /><div class="menuLevel1">Notes On Whitelist</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/whitelist.txt\',3);" />',undef,undef,'msg001030','msg001031'],

[0,0,0,'heading','Relaying <a href="http://apps.sourceforge.net/mediawiki/assp/index.php?title=Relaying" target=wiki><img height=12 width=12 src="' . $wikiinfo . '" alt="relaying not allowed" /></a>'],
['acceptAllMail','Accept All Mail*',80,\&textinput,'','(\S*)','ConfigMakeIPRe','Relaying is allowed for these IPs. They  contribute also to the whitelist. This can take either a directly entered list of IP\'s separated by pipes or a file \'file:files/acceptall.txt\'.<br />For example: 145.145.145.145|146.145.','Basic','7','msg001040','msg001041'],
['DoLocalSenderDomain','Do Local Domain Check for Local Sender',0,\&checkbox,'','(.*)',undef,
  'If activated, each local sender address must have a valid Local Domain.',undef,undef,'msg001050','msg001051'],
['DoLocalSenderAddress','Do Local Address Check for Local Sender',0,\&checkbox,'','(.*)',undef,
  'If activated, each local sender address must have a valid Local Address.',undef,undef,'msg001060','msg001061'],
['nolocalDomains','Skip Local Domain Check',0,\&checkbox,'','(.*)',undef,'Do not check relaying based on localDomains. Let the mailserver do it. <b>NOT RECOMMENDED</b>.',undef,undef,'msg001070','msg001071'],
['ldLDAP','Do LDAP lookup for local domains',0,\&checkbox,'','(.*)',undef,'Check local domains against an LDAP database.<br />Note: Checking this requires filling in LDAP DomainFilter ( ldLDAPFilter ) in the LDAP section.<br />This requires an installed <a href="http://search.cpan.org/~gbarr/perl-ldap-0.31/lib/Net/LDAP.pod" rel="external">NET::LDAP</a> module in Perl.',undef,undef,'msg001080','msg001081'],
['ispip','ISP/Secondary MX Servers*',80,\&textinput,'','(\S*)','ConfigMakeIPRe','Enter any addresses that are your ISP or backup MX servers, separated by pipes (|). <br />These addresses will (necessarily) bypass Griplist, IP Limiting, Delaying, Penalty Box, SPF, DNSBL &amp; SRS checks unless the IP can be determined by (ispHostnames) ISP/Secondary Hostnames. For example: 127.0.0.1|172.16..','Basic','7','msg001090','msg001091'],
['contentOnlyRe', 'Regular Expression to Identify Forwarded Messages*',80,\&textinput,'','(.*)','ConfigCompileRe',
 "Put anything here to identify messages which should bypass PB, Sender Validation, Griplist, IP Limiting, Delaying, SPF, DNSBL &amp; SRS checks. For example:  email addresses of people who are forwarding from other accounts to their mailbox on your server.",undef,undef,'msg001100','msg001101'],
['ispHostnames','Regular Expression to Identify ISP/Secondary Hostnames*',80,\&textinput, '','(.*)', 'ConfigCompileRe', 'Hostnames (regular expression) to lookup the IP that connected to the ISP/Secondary server.<br />If found, this address is used to perform IP-based checks on forwarded messages. <br />For example: mx1\.yourisp\.com or mx1\.yourisp\.net|mx2\.yoursecondary\.com . <i>This hostnames are found in the \'Received:\' header, like  \'Received: from ...123.123.123.123... by <b>mx1.yourisp.com</b>\'</i>. Leave this blank to disable the feature. ',undef,undef,'msg001110','msg001111'],
['send250OKISP','Send 250 OK To ISP/Secondary MX Servers',0,\&checkbox,'1','(.*)',undef,
 'Set this checkbox if you want ASSP to reply to IP\'s in ISPIP with \'250 OK\' instead of SMTP error code \'554 5.7.1\'.',undef,undef,'msg001120','msg001121'],
['ispgripvalue','ISP/Secondary MX Grip Value',5,\&textinput,'0.5','^(0\.?\d*|)$',undef,'It is recommended  to set it to 0.5 (Completely GReyIP) for ISP and Secondary MX servers. If left blank the Griplist X value is used (percentage of spam messages in relation to total). <br />Note: value has to be greater than 0 and less than 1, where 0 = never spam and 1 = always spam',undef,undef,'msg001130','msg001131'],

['BounceSenders','Bounce Senders*',80,\&textinput,'postmaster|mailer-daemon','(.*)','ConfigMakeRe','Envelope sender addresses treated as bounce origins. Null sender (&lt;&gt;) is always included.<br />
 Accepts specific addresses (postmaster@domain.com), usernames (mailer-daemon), or entire domains (@bounces.domain.com)<br />Separate entries with pipes: |. For example: postmaster|mailer-daemon',undef,undef,'msg001140','msg001141'],
['PopB4SMTPFile','Pop Before SMTP DB File',40,\&textinput,'','(.*)',undef,'Enter the DB database filename of your POP before SMTP implementation with records stored for dotted-quad IP addresses.<br />For example: /etc/mail/popip.db',undef,undef,'msg001150','msg001151'],
['PopB4SMTPMerak','Pop Before SMTP Merak Style',0,\&checkbox,'','(.*)',undef,'If set Merak 7.5.2 is supported.',undef,undef,'msg001160','msg001161'],
['relayHost','Relay Host',80,\&textinput,'',$GUIHostPort,undef,'Your isp\'s mail relayhost (smarthost). For example: mail.isp.com:25<br />If you run Exchange/Notes and you want assp to update the nonspam database and the whitelist, then enter your isp\'s smtp relay host here. Blank means no relayhost. Only required if clients don\'t deliver through SMTP. Separate multiple entries by "|".<br />
 Examples: your_ISP_Server:25, 149.1.1.1:25, 149.1.1.2:325|any_other_host:25 !','Basic',undef,'msg001170','msg001171'],
['relayAuthUser','User to Authenticate to Relay Host',80,\&passinput,'','(.*)',undef,'The username used for SMTP AUTH authentication to the relayhost  - for example, if your ISP need authentication on the SMTP port! Supported authentication methodes are PLAIN, LOGIN, CRAM-MD5 and DIGEST-MD5 . If the relayhost offers multiple methodes, the one with highest security option will be used. The Perl module <a href="http://search.cpan.org/search?query=Authen::SASL" rel="external">Authen::SASL</a> must be installed to use this feature! The usage of this feature will be skipped, if the sending MTA uses the AUTH command. Leave this blank, if you do not want use this feature.','Basic',undef,'msg009040','msg009041'],
['relayAuthPass','Password to Authenticate to Relay Host',80,\&passinput,'','(.*)',undef,'The password used for SMTP AUTH authentication to the relayhost ! Leave this blank, if you do not want use this feature.','Basic',undef,'msg009050','msg009051'],
['relayPort','Relay Port',80,\&textinput,'',$GUIHostPort,'ConfigChangeRelayPort','Tell your mail server to connect to this IP/port as its smarthost / relayhost. For example: 225<br /> Note that you\'ll want to keep the relayPort protected from external access by your firewall.<br />You can supply an interface:port to limit connections. Separate multiple entries by "|".<p><small><i>Examples:</i> 225, 127.0.0.1:225, 192.168.1.1:225|192.168.2.1:225 </small></p>!',undef,undef,'msg001180','msg001181'],
['allowRelayCon','Allow Relay Connection from these IP\'s*',80,\&textinput,'','(\S*)','ConfigMakeIPRe','Enter any addresses that are allowed to use the relayPort , separated by pipes (|). If empty, any ip address is allowed to connect to the relayPort. If this option is defined, keep in mind : Addresses defined in acceptAllMail are <b>NOT</b> automaticly included and have to be also defined here, if them should allow to use the relayPort. For example: 127.0.0.1|172.16..','Basic','7','msg008830','msg008831'],
['NoRelaying','No Relaying Error <a href="http://apps.sourceforge.net/mediawiki/assp/Relaying" target="ASSPHELP"><img src="' . $wikiinfo . '" alt="wiki" /></a>',80,\&textinput,'530 Relaying not allowed','([25]\d\d .*)',undef,'SMTP error message to deny relaying.',undef,undef,'msg001190','msg001191'],
['defaultLocalHost','Default Local Host',40,\&textinput,'assp.local','('.$EmailDomainRe.')?',undef,'If you want to be able to send mail to local users without a domain name then put the default local domain here.<br /> Blank disables this feature. For example: mydomain.com .',undef,undef,'msg001200','msg001201'],

['LocalFrequencyInt','Local Frequency Interval',40,\&textinput,'0','(\d*)',undef,'The time interval in seconds in which the number of envelope recipients per sending address has not to exceed a specific number ( LocalFrequencyNumRcpt ).<br />
  Use this in combination with LocalFrequencyNumRcpt to limit the number of recipients in a given interval, to prevent local abuse - for example from highjacked local accounts. A value of 0 (default) will disable this feature and clean the cache within five minutes. It is recommended to enable DoLocalSenderAddress and/or DoLocalSenderDomain, if you want to use this feature. To give users the chance to inform an admin about such blocked mails, local mails to EmailAdmins are never blocked because of that feature.<br />
  <input type="button" value="edit local Frequency Cache" onclick="javascript:popFileEditor(\'DB-localFrequencyCache\',\'1h\');" />',undef,undef,'msg008720','msg008721'],
['LocalFrequencyNumRcpt','Local Frequency Recipient Number',40,\&textinput,'0','(\d*)',undef,'The number of envelope recipients per sending address that has not to exceed in a specific time interval ( LocalFrequencyInt ).<br />
  Use this in combination with LocalFrequencyInt to limit the number of recipients in a given interval, to prevent local abuse - for example from highjacked local accounts. A value of 0 (default) will disable this feature and clean the cache within five minutes. It is recommended to enable DoLocalSenderAddress and/or DoLocalSenderDomain, if you want to use this feature. To give users the chance to inform an admin about such blocked mails, local mails to EmailAdmins are never blocked because of that feature. <br />
  <input type="button" value="edit local Frequency Cache" onclick="javascript:popFileEditor(\'DB-localFrequencyCache\',\'1h\');" />',undef,undef,'msg008730','msg008731'],
['LocalFrequencyOnly','Check local Frequency for this Users only*',60,\&textinput,'','(.*)','ConfigMakeSLRe',
 'A list of local addresses, for which the \'local frequency check\' should be done. Leave this field blank (default), to do the check for every address.<br />
  Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com).  Wildcards are supported (fribo*@domain.com).<br />
  For example: fribo*@thisdomain.com|jhanna|@sillyguys.org ',undef,undef,'msg008740','msg008741'],
['NoLocalFrequency','Check local Frequency NOT for this Users*',60,\&textinput,'','(.*)','ConfigMakeSLRe',
 'A list of local addresses, for which the \'local frequency check\' should not be done. Noprocessing messages will skip this check.<br />
  Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com).  Wildcards are supported (fribo*@domain.com).<br />
  For example: fribo*@thisdomain.com|jhanna|@sillyguys.org ',undef,undef,'msg008750','msg008751'],
['NoLocalFrequencyIP','Check local Frequency NOT for this IP\'s*',60,\&textinput,'','(.*)','ConfigMakeIPRe',
 'A list of local IP-addresses, for which the \'local frequency check\' should not be done.<br />
  For example: 145.145.145.145|145.146. ',undef,undef,'msg010110','msg010111'],

['genDKIM','Generate and Add DKIM <a href="http://en.wikipedia.org/wiki/DomainKeys_Identified_Mail" target=wiki><img height=12 width=12 src="' . $wikiinfo . '" alt="Network Flow" /></a> signatures to relayed messages',0,\&checkbox,'','(.*)',undef,'If selected, ASSP will add DKIM signatures to relayed messages if it finds a valid DKIM configuration in DKIMgenConfig for the sending domain. This will also be done for noprocessing mails. This requires an installed <a href="http://search.cpan.org/search?query=Mail::DKIM" rel="external">Mail::DKIM</a> module in PERL.',undef,undef,'msg001210','msg001211'],
['DKIMgenConfig','The File with the DKIM configurations*',40,\&textinput,'file:dkim/dkimconfig.txt','(file:\S*)','configUpdateDKIMConf','The file that contains the DKIM configuration. A description how to configure DKIM could be found in the default file dkim/dkimconfig.txt.<br />
<hr /><div class="menuLevel1">Notes On Relaying</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/relaying.txt\',3);" />',undef,undef,'msg001220','msg001221'],

[0,0,0,'heading','Recipients/Local Domains'],
['removeForeignBCC','remove Foreign BCC',0,\&checkbox,'','(.*)',undef,'Remove foreign BCC: header lines from the mail header. The remove is done before the DoHeaderAddrCheck is done!',undef,undef,'msg009780','msg009781'],

['DoHeaderAddrCheck','Check TO,CC and BCC headers',0,\&checkbox,'','(.*)',undef,'If enabled TO: , CC: and BCC: header lines are checked the following way:<br /><br />
 1. a possible recipient replacement is done<br />
 2. local email address validation is done -  if OK, the next address or headerline is processed<br />
 3. spamtrapaddresses will be detected - scored with stValencePB - <b>mail is blocked</b> (noPenaltyMakeTraps is honored)<br />
 4. a local but not valid TO/CC/BCC: address will be detected - scored with irValencePB<br />
 5. a RelayAttempt will be detected if a BCC address is not local - scored with rlValencePB - <b>mail is blocked</b><br />
 The check 3 and 4 honors whitelisting , noprocessing and noBlockingIPs<br />
 Enable this check only, if assp is configured to validate local domains and email addresses!<br />
 NOTICE: that removeForeignBCC take place before this check is done - step 5 will be never reached if removeForeignBCC is enabled!',undef,undef,'msg010010','msg010011'],

['sendAllPostmaster','Catchall Address for Messages to Postmaster',20,\&textinput,'','(.*)',undef,'ASSP will deliver messages addressed to all postmasters of your local domains to this address. For example: postmaster@mydomain.com',undef,undef,'msg001250','msg001251'],
['sendAllPostmasterNP','Skip Spam Checks for Postmaster Catchall',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg001260','msg001261'],
['sendAllAbuse','Catchall Address for Messages to Abuse',20,\&textinput,'','(.*)',undef,'ASSP will deliver messages to all abuse addresses of your local domains to this address. For example: abuse@mydomain.com',undef,undef,'msg001270','msg001271'],
['sendAllAbuseNP','Skip Spam Checks for Abuse Catchall',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg001280','msg001281'],
['DoRFC822','Validate addresses to conform with RFC 822','0:disabled|1:recipients|2:sender|3:both',\&listbox,1,'(.*)',undef,'If activated, the envelope sender and/or each envelope recipient is checked to conform with the email format defined in RFC 822. For an invalid sender address \'nofromValencePB\' is used for scoring - for invalid recipient addresses, each is scored with \'irValencePB\'.<br />
  For the sender address in addition a top level domain existence and DNS name server registration check is done.',undef,undef,'msg001290','msg001291'],
['LocalAddresses_Flat','Lookup valid Local Addresses from here*',80,\&textinput,'','(.*)','ConfigMakeSLRe','These email addresses are the list of your local addresses. You can list specific addresses (user@mydomain.com), addresses at any local domain (user), or entire domains (@mydomain.com).  Wildcards are supported (fribo*@domain.com). (|).<br />For example: fribo@thisdomain.com|jhanna|@sillyguys.org or place them in a plain ASCII file one address per line:file:files/localuser.txt. You can use entries like @mydomain.com=>vrfyhost:port to VRFY users on your MTA, for more information read localDomains. You can use an entry like ALL=>vrfyhost:port to define a VRFY host for all domain entries ( better use Groups ).','Basic',undef,'msg001300','msg001301'],
['LocalAddresses_Flat_Domains','Use Addresses without \'@\' as Domains',0,\&checkbox,0,'([01]?)',undef,'Will handle entries without \'@\' as full domains',undef,undef,'msg001310','msg001311'],
['RejectTheseLocalAddresses','Reject These Local Addresses*',80,\&textinput,'','(.*)','ConfigMakeSLRe',
'If ANY recipient is on reject list, message will not be delivered. Used for disabled legitimate accounts, where a user may have left the company. This stops wildcard mailboxes from getting these messages.',undef,undef,'msg001320','msg001321'],
['localDomains','Local Domains*',80,\&textinput,'putYourDomains.com|here.org','(.*)','ConfigMakeLocalDomainsRe','Check local domains against these addresses. Add a fake domain like \'assp-nospam.org\' for the email interface if you run MS Exchange. When mailing to eg. \'spam@assp-nospam.org\' MS Exchange forwards it outbound to ASSP who handles the different options. As in every field marked by \'*\' separate addresses with | or use file \'file:files/localdomains.txt\'. Wildcards are supported.<br /> For example: *mydomain.com|*.mydomain.com|here.org <br />
 Use the syntax: *mydomain.com=>smtp.mydomain.com|other.com=>mx.other.com:port|other2.com=>mx.other.com:port,mx2.other.com:port to verify the recipient addresses with the SMTP-VRFY (if VRFY is not supported \'MAIL FROM:\' and \'RCPT TO:\' will be used) command on other SMTP servers. The entry behind => must be the hostname:port or ip-address:port of the MTA which is used to verify \'RCPT TO\' addresses with a VRFY command! If :port is not defined, port :25 will be used. You can use an entry like ALL=>vrfyhost:port to define a VRFY host for all local domain entries that don\'t have a MTA defined ( better use Groups ). Separate multiple VRFY hosts for failover by comma ",". You have to enable the SMTP \'VRFY\' command on your MTA - the \'EXPN\' command should be enabled! This requires an installed <a href="http://search.cpan.org/search?query=Net::SMTP" rel="external">Net::SMTP</a> module in PERL. <br />
 If you have configured LDAP and enabled DoLDAP and ASSP finds a VRFY entry for a domain, LDAP search will be done first and if this fails, the VRFY will be used. So VRFY could be used for LDAP backup/fallback/failover!<br />
 It is recommended to configure \'ldaplistdb\' in the \'File Paths and Database\' section when using this verify extension - so ASSP will store all verified recipients addresses there to minimize the querys on MTA\'s. There is no need to configure LDAP, but both VRFY and LDAP are using ldaplistdb. Please go to the \'LDAP setup\' section to configure MaxLDAPlistDays and LDAPcrossCheckInterval or start a crosscheck now with forceLDAPcrossCheck. This three parameters belong also to VRFY.','Basic',undef,'msg001330','msg001331'],
['DoVRFY','Verify Recipients with SMTP-VRFY',0,\&checkbox,1,'(.*)',undef,  'If activated and the format \'Domain=>MTA\' is encountered in
 localDomains recipient addresses will be verified with SMTP-VRFY (if VRFY is not supported \'MAIL FROM:\' and \'RCPT TO:\' will be used).
 If you know that VRFY is not supported with a MTA, you may put the MTA into VRFYforceRCPTTO. Don\'t forget to configure LDAPFail (belongs also to VRFY) to your needs!', undef,undef,'msg008850','msg008851'],
['VRFYQueryTimeOut','SMTP VRFY-Query Timeout',5,\&textinput,'5','(\d\d?)',undef,
 'The number of seconds ASSP will wait for an answer of the MTA that is queryed with the VRFY command to verify a recipient address.',undef,undef,'msg001340','msg001341'],
['VRFYforceRCPTTO','Force the usage of RCPT TO*',80,\&textinput,'','(.*)','ConfigMakeRe','Define MTA\'s here for which you want ASSP to force the usage of MAIL FROM:,RCPT TO: instead of the VRFY command. The definition of each MTA has to be the same as defined in LocalAddresses_Flat and/or localDomains (after the \'=>\') for example: smtp.mydomain.com|mx.other.com:port|10.1.1.1|10.1.1.2:125 .',undef,undef,'msg001350','msg001351'],
['DisableVRFY','Disable VRFY and EXPN for External Clients',0,\&checkbox,'','(.*)',undef,'If you have enabled VRFY and/or EXPN on your MTA to make assp able to verify addresses and you do not want external clients to use VRFY and EXPN - select this option.',undef,undef,'msg008600','msg008601'],
['DoLDAP','Do LDAP lookup for valid local addresses',0,\&checkbox,'','(.*)',undef,'Check local addresses against an LDAP database before accepting the message.<br />Note: Checking this requires filling in the other LDAP parameters below.<br />This requires an installed <a href="http://search.cpan.org/~gbarr/perl-ldap-0.31/lib/Net/LDAP.pod" rel="external">Net::LDAP</a> module in PERL.',undef,undef,'msg001360','msg001361'],
['LocalAddressesNP','Do Not  Validate Local Addresses if in NoProcessing List',0,\&checkbox,'','(.*)',undef,'If a recipient is found in NoProcessing, the user validation is skipped. ',undef,undef,'msg001370','msg001371'],
['CatchAll','Catchall per Domain*',40,\&textinput,'','(.*)','configUpdateCA','ASSP will send to this addresses/domain if no valid user is found in LocalAddresses_Flat/LDAP. <br />For example: catchall@domain1.com|catchall@domain2.com',undef,undef,'msg001390','msg001391'],
['CatchAllAll','Catchall for All Domains',40,\&textinput,'','(.*)',undef,'ASSP will send to this address if no valid user is found  in LocalAddresses_Flat/LDAP and no match is found in Catchall per Domain. <br />For example: catchall@domain.com',undef,undef,'msg001400','msg001401'],
['CatchallallISP2NULL','Move ISP Connection with wrong Recipient Address to NULL',0,\&checkbox,'','(.*)',undef,
  'If set, ASSP will move all ISP connections with wrong recipient addresses to a NULL-connection. The ISP will receive "250 OK" until the mail has passed, but the mail will not be sent to your MTA. This is done after CatchAll but before CatchAllAll is checked.',undef,undef,'msg001410','msg001411'],
['NullAddresses','NULL Connection Addresses*',80,\&textinput,'','(.*)','ConfigMakeSLRe','ASSP will dump a message silently when encountering such an address in "MAIL FROM:" or "RCPT TO:". Accepts specific addresses (null@example.com), user parts (nobody) or entire domains (@example.com).',undef,undef,'msg001420','msg001421'],
['InternalAddresses','Accept Mail from Local Domains only*',80,\&textinput,'','(.*)','ConfigMakeSLRe','These local addresses accept mail only from local domains. Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com). Wildcards are supported (fribo*@domain.com).',undef,undef,'msg001430','msg001431'],
['InternalAndWhiteAddresses','Accept Mail from Local Domains and Whitelisted Senders only*',80,\&textinput,'','(.*)','ConfigMakeSLRe','These local addresses accept mail only from local domains and whitelisted external serders. Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com). Wildcards are supported (fribo*@domain.com).',undef,undef,'msg009890','msg009891'],
['SepChar','Separation Character for Subaddressing',2,\&textinput,'+','([^*]?)',undef,'RFC 3598 describes subaddressing with a Separation Character. A star (\'*\') is not allowed as Separation Character. Everything between Separation Character and @ is ignored (including Separation Character). For Example = \'+\' will allow user+subaddress@domain.com.',undef,undef,'msg001440','msg001441'],
['EnableBangPath','Support Bang Path',0,\&checkbox,'','(.*)',undef,
 'If set, ASSP will support addresses like domainx!user and will convert them to user@domainx .',undef,undef,'msg001450','msg001451'],
['MaxVRFYErrors','Maximum recipient verification Errors',5,\&textinput,'0','(\d+)',undef,
  'The maximum number of failed \'RCPT TO\' or \'VRFY\' commands encountered before the connection is dropped. You can leave this field at 0, if you are using \'DoLDAP\', \'LocalAddresses_Flat\'! If configured, ASSP will drop the connection, if the count of \'550 unknown user\' errors, received from your \'smtpDestination\'(MTA), reached this value!',undef,undef,'msg001460','msg001461'],
['DoMaxDupRcpt','Block Max Duplicate Recipients','0:disabled|1:block|2:monitor|3:score',\&listbox,3,'(\d*)',undef,
  'Block remote servers that uses the same recipient address more times, than the number defined in MaxDupRcpt in the RCPT TO: command. Scoring is done with mdrValencePB . This check is skipped for outgoing, noprocessing, whitelisted and spamlovers mails. If a message has to be delayed, this check will score before the delay if set to block or score - and score and/or block on the next server request.',undef,undef,'msg008950','msg008951'],
['MaxDupRcpt','Maximum Allowed Duplicate Recipient Addresses',5,\&textinput,'0','(\d+)',undef,
  'The maximum number of duplicate recipient addresses that are allowed in the sequence of the RCPT TO: commands!<br />
  The number per mail is calculated by \'number of RCPT TO: commands  -  number of unique recipient addresses\'.<br />
  For example: if one address is used three times or two addresses are used each two times, will result in the same count - 2. Or if both is the case in one mail, the count will be 4.',undef,undef,'msg008960','msg008961'],
['ReplaceRecpt','Enable recipient replacement*',80,\&textinput,'','(.*)','configChangeRcptRepl','recommented if used: file:files/rcptreplrules.txt - default empty ! This enables recipient replacement. If you do not use file:, separate the rules with |. The replacement will be done before any ASSP check. Use this option carefully - for example: if you have enabled DKIM check, the DKIM check will fail, if the recipient of the mail was modified. For a more detailed description of the rules and options, read the file: files/rcptreplrules.txt!',undef,undef,'msg001470','msg001471'],
['NoValidRecipient','No-Valid-Local-User Reply',80,\&textinput,'550 5.1.1 User unknown: EMAILADDRESS','([5|4|2]\d\d .*)',undef,'SMTP reply for invalid Users. Default: \'550 5.1.1 User unknown: EMAILADDRESS\' <br /> The literal EMAILADDRESS (case sensitive) is replaced by the fully qualified SMTP recipient (e.g., thisuser@yourcompany.com).<br /><hr /><div class="menuLevel1">Notes On Local Addresses</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/localaddresses.txt\',3);" />',undef,undef,'msg001480','msg001481'],

[0,0,0,'heading','Validate Helo'],
['useHeloBlacklist','Use the Helo Blacklist','0:disabled|1:block|2:monitor|3:score',\&listbox,3,'(.*)',undef,
  'Use the list of blacklisted-helo hosts built by rebuildspamdb.',undef,undef,'msg001490','msg001491'],
['useHeloGoodlist','Use the Helo Goodlist','0:disabled|1:bonus|2:whitelisted|3:bonus &amp; whitelisted',\&listbox,1,'(.*)',undef,
  'Use the list of known good helo hosts built by rebuildspamdb.<br />
  bonus - the message/IP get a bonus of the weigthed negative value of hlValencePB <br />
  whitelisted - the message is processed as whitelisted<br /><br />
  The good helos and weights are stored together with the helo blacklist.',undef,undef,'msg009920','msg009921'],
['DoIPinHelo','Do Score Suspicious Helos','0:disabled|2:monitor|3:score',\&listbox,3,'(\d*)',undef,
  'Score servers with IP number in Helo and check for mismatch with sending IP.',undef,undef,'msg001500','msg001501'],
['ForceFakedLocalHelo','Enforce Check of Forged Helos Before Delaying',0,\&checkbox,1,'(.*)',undef,
  'If set, ASSP will  check Forged Helos before DELAYING. Collecting, Testmode, CopySpam, Spam-Lover is ignored.',undef,undef,'msg001510','msg001511'],
['DoFakedLocalHelo','Block Forged Helos','0:disabled|1:block|2:monitor|3:score',\&listbox,1,'(\d*)',undef,
  'Block remote servers that claim to come from our Local Domains/Local IP\'s/Local Host.',undef,undef,'msg001520','msg001521'],
['DoFakedUseLocalDomain','Use Local Domain List for Blocking Forged Helos',0,\&checkbox,1,'(.*)',undef,
  'If set, DoFakedLocalHelo will  use <b>localDomains</b>.',undef,undef,'msg001530','msg001531'],
['DoFakedWL','Do Not Block Whitelisted',0,\&checkbox,'','(.*)',undef,
  'Disable "Block Forged Helo\'s" for whitelisted addresses (not recommended).',undef,undef,'msg001540','msg001541'],
['DoFakedNP','Do Not Block Noprocessing',0,\&checkbox,'','(.*)',undef,
  'Disable "Block Forged Helo\'s" for addresses identified as noprocessing (not recommended).',undef,undef,'msg001550','msg001551'],
['myServerRe','Local Domains,IP\'s and Hostnames*',80,\&textinput,'','(.*)','ConfigMakeRe',
  'Local Domains, IP\'s and Hostnames are often use to fake (forge) the Helo. Include all IP addresses and hostnames for your server here, localhost is already included. Include Local Domains of your choice here, if you deactivated the automatic use of the local domain list.  For example: 11.22.33.44|mx.YourDomains.com|here.org','Basic',undef,'msg001560','msg001561'],
['noHelo','Don\'t Validate HELO for these IP\'s*',60,\&textinput,'','(\S*)','ConfigMakeIPRe',
  'Enter IP addresses that you don\'t want to be HELO validated.<br />
   For example: 127.0.0.1|192.168.',undef,'7','msg001570','msg001571'],
['heloBlacklistIgnore','Don\'t block these HELO\'s*',80,\&textinput,'','(.*)','ConfigMakeRe',
  'HELO / EHLO greetings on this list will be excluded from the HELO checks. For example: host123.isp.com|host456.*.com',undef,undef,'msg001580','msg001581'],
['ForceValidateHelo','Enforce Early Helo Checks',0,\&checkbox,1,'(.*)',undef,
  'If set, ASSP will  Validate/Invalidate the format of HELO before DELAYING. Collecting, Testmode, CopySpam, Spam-Lover is ignored.',undef,undef,'msg001590','msg001591'],
['DoValidFormatHelo','Validate Format of HELO','0:disabled|1:block|2:monitor|3:score',\&listbox,1,'(\d*)',undef,
  'If activated, the HELO is checked against the expression below. If the Regular Expression matches, the HELO is validated as being ok. ',undef,undef,'msg001600','msg001601'],
['validFormatHeloRe','Regular Expression to Validate Format of HELO*',80,\&textinput,'file:files/validhelo.txt','(.*)','ConfigCompileRe',
  'Validate Format HELO will check incoming HELOs according to rfc1123. <br />For example: ^(?:\w[\w\.\-]*\.\w{2,6})$ or ^(?:(?:[a-z\d][a-z\d\-]*)?[a-z\d]\.)+[a-z]{2,6}$',undef,undef,'msg001610','msg001611'],
['DoInvalidFormatHelo','Invalidate Format of HELO','0:disabled|1:block|2:monitor|3:score',\&listbox,1,'(\d*)',undef,
  'If activated, the HELO is checked against the expression below. If the Regular Expression matches, the HELO is invalidated as being not ok.',undef,undef,'msg001620','msg001621'],
['invalidFormatHeloRe','Regular Expression to Invalidate Format of HELO**',80,\&textinput,'file:files/invalidhelo.txt','(.*)','ConfigCompileRe','Invalidate Format HELO will check incoming HELOs for this. <br />
 For example:  ^\d+\.\d+\.\d+\.\d+$|^[^\.]+\.?$,',undef,undef,'msg001630','msg001631'],
['DoHeloWL','Do Valid/Invalid/Black Helo for Whitelisted',0,\&checkbox,'1','(.*)',undef,
  'Do valid/invalid Helo for whitelisted addresses.',undef,undef,'msg001640','msg001641'],
['DoHeloNP','Do Valid/Invalid/Black Helo for Noprocessing',0,\&checkbox,'1','(.*)',undef,
  'Do valid/invalid Helo for noprocessing addresses.<br /><hr />
  <div class="menuLevel1">Notes On Validate Helo</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/validatehelo.txt\',3);" />',undef,undef,'msg001650','msg001651'],

[0,0,0,'heading','Validate Sender'],

['DoBlackDomain','Do Blacklisted Addresses and Domains','0:disabled|1:block|2:monitor|3:score', \&listbox,1,'(\d*)',undef, '',undef,undef,'msg001660','msg001661'],
['DoBlackDomainWL','Do Blacklisting Addresses and Domains for White',0,\&checkbox,'1','(.*)',undef,
  'Do blacklisting addresses & domains in messages which are marked whitelisted by whiteRe, whiteListedDomains, whiteListedIPs or whitelistdb.',undef,undef,'msg001670','msg001671'],
['DoBlackDomainNP','Do Blacklisting Addresses and Domains for NoProcessing',0,\&checkbox,'1','(.*)',undef,
  'Do blacklisting addresses & domains in messages which are marked noprocessing by npRe, noProcessingDomains, noProcessingIPs or noProcessing.',undef,undef,'msg001680','msg001681'],
['blackListedDomains','Blacklisted Addresses and Domains*',60,\&textinput,'file:files/blackdomains.txt','(.*)','ConfigMakePrivatRe','Addresses  &amp; Domains from which you always want to reject mail, they only send you spam. Note this matches the end of the address, so if you don\'t want to match subdomains then include the @. Note that buy.com would also match spambuy.com but .buy.com won\'t match buy.com. abc@def.com will match abc@def.com but won\'t match bbc@def.com. Wildcards are supported. For example: cc|info|biz|seller@bayer.com|sell*@basf.com<br /><br />
  It is possible to make email addresses blacklisted only for a set of local domains and/or local users. Use wildcards (* and ?) to define domains.<br />
  Use the following syntax to do this:<br />
  *@anydomain=>*@any_local_domain - for domain to domain<br />
  *@*.anydomain=>*@any_local_domain - for any sub-domain to domain<br />
  user@anydomain=>*@*.any_local_domain - for user to any sub-domain<br /><br />
  It is possible to define more than one entry at the left and the right side of the definition (=&gt;), like:<br />
  *@anydomain|*@other_domain=>*@any_local_domain|*@other_local_domain - always separate multiple entries by pipes<br />
  It is also possible to use a GroupDefinition in any or both sides, like:<br />
  [sendergroup]=>[recipientgroup]<br />
  [sendergroup1]|[sendergroup2]|*@domain=>[recipientgroup1]|[recipientgroup2]|user@local_domain<br /><br />
  NOTICE - that the local email addresses and domains are not checked to be local once',undef,undef,'msg001690','msg001691'],

['DoMsgID','Check Message IDs','0:disabled|2:monitor|3:score',\&listbox,3,'(\d*)',undef,
  'Score messages with missing/suspicious/invalid Message-ID. Scoring is done by midmValencePB / midsValencePB / midiValencePB .',undef,undef,'msg001700','msg001701'],
['noMsgID','Don\'t Validate Message-IDs for these IPs*',80,\&textinput,'127.0.0.|192.168.|10.','(\S*)','ConfigMakeIPRe','Enter IP addresses that you don\'t want to be Message-ID validated, separated by pipes (|). For example: 127.0.0.1|192.168.',undef,'7','msg001710','msg001711'],
['validMsgIDRe','Regular Expression to Validate Format of Message-ID*',80,\&textinput,'^.+\@.+\..+$','(.*)','ConfigCompileRe',
  'Check Message IDs will check incoming messages for valid Message-IDs. <br />For example: ^.+\@.+\..+$  ',undef,undef,'msg001720','msg001721'],
['invalidMsgIDRe','Regular Expression to Invalidate Format of Message-ID**',80,\&textinput,'','(.*)','ConfigCompileRe',
  'Check Message IDs will check incoming messages for invalid Message-IDs.',undef,undef,'msg001730','msg001731'],

['DoNoValidLocalSender','Validate Remote Sender with Local Domain Address','0:disabled|1:block|2:monitor|3:score|4:testmode',\&listbox,1,'(\d*)',undef,
  'If activated, each remote sender  with a local domain is checked against the <i>Local Addresses File</i> and/or LDAP. ',undef,undef,'msg001740','msg001741'],
['ForceNoValidLocalSender','Early "Remote Sender with Local Domain Address" Check',0,\&checkbox,'1','(.*)',undef,
  'If set, ASSP will check Remote Sender with Local Domain Address before Delaying a message.<br /> Collecting, Testmode, CopySpam, and Spam-Lover settings are ignored.',undef,undef,'msg001750','msg001751'],
['DoNoSpoofing','Block Local Address from External Sender ','0:disabled|1:block|2:monitor|3:score',\&listbox,3,'(.*)',undef,
  'If activated, each external sender address built with a domain in localDomains is regarded a spoofed address. An external sender is a sender from an IP not in acceptAllMail and not authenticated. ',undef,undef,'msg001760','msg001761'],
['onlySpoofingCheckIP','Do Spoofing Check ONLY for these IP\'s*',80,\&textinput,'','(\S*)','ConfigMakeIPRe',
 'Enter IP\'s that you want to be checked for spoofing. If this is set, ONLY these IP\'s will be checked. For example:145.145.145.145|145.146.',undef,'7','msg009900','msg009901'],
['onlySpoofingCheckDomain','Do Spoofing Check ONLY for these Addresses/Domains*',80,\&textinput,'','(.*)','ConfigMakeSLRe',
 'Accepts specific addresses (user@example.com), user parts (user) or entire domains (@example.com). Wildcards are supported (fribo*@example.com). If set, ONLY these addresses/domains will be checked for spoofing.',undef,undef,'msg009910','msg009911'],
['noSpoofingCheckIP','Don\'t do Spoofing Check for these IP\'s*',80,\&textinput,'','(\S*)','ConfigMakeIPRe',
 'Enter IP\'s that you don\'t want to be checked for spoofing. For example:145.145.145.145|145.146.',undef,'7','msg001770','msg001771'],
['noSpoofingCheckDomain','Don\'t do Spoofing Check for these Addresses/Domains*',80,\&textinput,'','(.*)','ConfigMakeSLRe',
 'Accepts specific addresses (user@example.com), user parts (user) or entire domains (@example.com). Wildcards are supported (fribo*@example.com).',undef,undef,'msg001780','msg001781'],
['DoNoSpoofing4From','Do NoSpoofing for from:',0,\&checkbox,'','(.*)',undef,
  'Do the NoSpoofing check also for header \'from:\' addresses.',undef,undef,'msg009850','msg009851'],
['DoReversed','Reversed Lookup','0:disabled|1:block|2:monitor|3:score',\&listbox,3,'(.*)',undef,
  'If activated, each sender IP is checked for a PTR record. This requires an installed <a href="http://search.cpan.org/search?query=Net::DNS" rel="external">Net::DNS</a> module in PERL.',undef,undef,'msg001800','msg001801'],
['DoReversedWL','Do Reversed Lookup for Whitelisted',0,\&checkbox,'1','(.*)',undef,
  'Do reversed lookup for whitelisted addresses.',undef,undef,'msg001810','msg001811'],
['DoReversedNP','Do Reversed Lookup for Noprocessing',0,\&checkbox,'1','(.*)',undef,
  'Do reversed lookup for noprocessing addresses.',undef,undef,'msg001820','msg001821'],
['DoInvalidPTR','Reversed Lookup FQDN','0:disabled|1:block|2:monitor|3:score',\&listbox,3,'(.*)',undef,
  'If activated - and Reversed Lookup is activated -, the PTR-FQDN record is checked against the Regex. This requires an installed <a href="http://search.cpan.org/search?query=Net::DNS" rel="external">Net::DNS</a> module in PERL.',undef,undef,'msg001830','msg001831'],
['invalidPTRRe','Regular Expression to Invalidate Format of PTR**',80,\&textinput,'file:files/invalidptr.txt','(.*)','ConfigCompileRe',
  'Validate Format PTR will check PTR records for this. <br />
  For example:  ^\d+\.\d+\.\d+\.\d+$|^[^\.]+\.?$ or file:files/invalidptr.txt',undef,undef,'msg001840','msg001841'],
['validPTRRe','Regular Expression to Validate Format of PTR*',80,\&textinput,'file:files/validptr.txt','(.*)','ConfigCompileRe',
  'Validate Format PTR will check PTR records for this. <br />
  For example:  static or file:files/validptr.txt',undef,undef,'msg001850','msg001851'],
['PTRCacheInterval','Reversed Lookup Cache Refresh Interval',4,\&textinput,7,'(\d+\.?\d*|)','configUpdatePTRCR',
  'IP\'s in cache will be removed after this interval in days. 0 will disable the cache. <input type="button" value=" Show PTR Cache" onclick="javascript:popFileEditor(\'pb/pbdb.ptr.db\',5);" />',undef,undef,'msg001860','msg001861'],
['DoDomainCheck','Validate MX or A Record','0:disabled|1:block|2:monitor|3:score',\&listbox,3,'(.*)',undef,
  'If activated, the sender address and each address found in the following header lines (ReturnReceipt:, Return-Receipt-To:, Disposition-Notification-To:, Return-Path:, Reply-To:, Sender:, Errors-To:, List-...:) is checked for a valid MX or A record. Scoring is done for non existing MX record and non existing A record - a messages failes (block), if both records are not found.',undef,undef,'msg001870','msg001871'],
['MXACacheInterval','Validate Domain MX Cache Refresh Interval',4,\&textinput,7,'(\d+\.?\d*|)','configUpdateMXACR',
  'IP\'s in cache will be removed after this interval in days. 0 will disable the cache.<input type="button" value=" Show MX Cache" onclick="javascript:popFileEditor(\'pb/pbdb.mxa.db\',5);" />',undef,undef,'msg001880','msg001881'],
['DoNoFrom','Check For Existing From Header ','0:disabled|2:monitor|3:score',\&listbox,3,'(.*)',undef,
  'Scoring is set with fromValencePB.',undef,undef,'msg001890','msg001891'],
['DoNoFromWL','Do DoNoFrom for Whitelisted',0,\&checkbox,'1','(.*)',undef,
  'Check for existing From Header for whitelisted addresses.',undef,undef,'msg001900','msg001901'],
['DoNoFromNP','Do DoNoFrom for NoProcessing',0,\&checkbox,'1','(.*)',undef,
  'Check for existing From Header for noprocessing addresses.',undef,undef,'msg001910','msg001911'],
['removeDispositionNotification','Remove Disposition Notification Headers',0,\&checkbox,'','(.*)',undef,
  'If set, all headers : "ReturnReceipt: , Return-Receipt-To: and Disposition-Notification-To:" will be removed from not whitelisted and not noprocessing incoming mails. Select this to prevent unwanted whitelisting of spammers that request a Disposition Notification. An other way to prevent autowhitelisting because of an autoresponds is to use redRe .',undef,undef,'msg008970','msg008971'],
['DoDKIM','Validate DomainKeys Identified Mail <a href="http://en.wikipedia.org/wiki/DomainKeys" target=wiki><img height=12 width=12 src="' . $wikiinfo . '" alt="DKIM" /></a>','0:disabled|1:block|2:monitor|3:score',\&listbox,3,'(.*)',undef,
  'If activated, DomainKeys Identified Mails are checked for the right signature and contents. All DKIM parameters belongs also to the old DomainKey specification. This requires an installed <a href="http://search.cpan.org/search?query=Mail::DKIM::Verifier" rel="external">Mail::DKIM::Verifier</a> module in PERL. In addition DKIM is used to process Domain-based Message Authentication, Reporting &amp; Conformance - described in <a href="http://www.dmarc.org/" rel="external">DMARC</a> (DMARC requires also ValidateSPF to be enabled).',undef,undef,'msg001920','msg001921'],
['DoStrictDKIM','Validate DomainKeys Identified Mail strictly',0,\&checkbox,0,'(.*)',undef,
  'The DKIM test will fail, if the mail was modified by a mailhop. In this case the from address, the from domain, the to domain, the DKIM-signature by itself and the prefix of the digest-verification are valid, only the lower digest value differs! This may happen, if a mailhop has modified any other headerfield like X-...! If unchecked a mail will only pass, if the author policy and sender policy are accept or neutral!',undef,undef,'msg001930','msg001931'],
['noDKIMAddresses','Do not any DKIM Check for this Addresses *',80,\&textinput,'','(.*)','ConfigMakeSLRe',
  'Mail from any of these addresses will not be tagged and checked for DKIM. Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com).',undef,undef,'msg001940','msg001941'],
['noDKIMIP','Exclude these IP\'s from any DKIM Check*',80,\&textinput,'','(\S*)','ConfigMakeIPRe','Enter IP\'s that you want to exclude from DKIM check, separated by pipes (|).',undef,undef,'msg001950','msg001951'],
['DKIMCacheInterval','Validate DKIM-Pre-Check-Cache Refresh Interval',4,\&textinput,7,'(\d+\.?\d*|)','configUpdateDKIMCR',
  'domains\'s in cache will be removed after this interval in days. 0 will disable the cache.<br />
  If activated a DKIM-pre-check will be done. If ASSP finds a DKIM-Signature in the mail header, it checks the DNS records of the sending domain for valid DKIM configurations and writes a record in to the DKIM-pre-check-cache, if it finds such configuration.<br />
  If ASSP does not find a DKIM-Signature in the mail header, it also checks the DNS records of the sending domain for valid DKIM configurations. If it find such a configuration, the mail is considered spam, because it should have a DKIM-Signature.<br />
  The next mail from a domain that is found in this cache, must have a DKIM-Signature to pass the DKIM-pre-check. How ever, some DNS records are wrong or inaccurate and will cause ASSP to block mails because of this - register such domains and/or IP\'s in noDKIMAddresses and/or noDKIMIP .<br />
  <input type="button" value=" Show DKIM Cache" onclick="javascript:popFileEditor(\'pb/pbdb.dkim.db\',5);" />',undef,undef,'msg001960','msg001961'],
['AddDKIMHeader','Add X-Assp-DKIM Header',0,\&checkbox,1,'(.*)',undef,
  'Add X-Assp-DKIM header.',undef,undef,'msg001970','msg001971'],
['SenderInvalidError','Sender Validation Error',80,\&textinput,'554 5.7.1 REASON .','^([245]\d\d .*)$',undef,
  'SMTP error message to reject invalid senders. The literal REASON is replaced by (missing MX, missing PTR, invalid Helo, invalid user) depending on the check.<br /><hr />
  <div class="menuLevel1">Notes On Validate Sender</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/validatesender.txt\',3);" />',undef,undef,'msg001980','msg001981'],

[0,0,0,'heading','IP Blocking '],
['DelayIP','Simple IP Greylisting',10,\&textinput,'','(\d*)',undef,
  'Enable simple delaying for IP\'s in black penaltybox with totalscore above this value. An value of zero or empty disables this feature.',undef,undef,'msg009320','msg009321'],
['DelayIPTime','Simple IP Greylisting Embargo Time',5,\&textinput,5,'(\d*)',undef,
  'Enter the number of minutes for which delivery, related with IP address of the sending host, is refused with a temporary failure. Default is 5 minutes.',undef,undef,'msg009330','msg009331'],
['DoDenySMTP','Do Deny Connections from these IP\'s','0:disabled|1:block|2:monitor',\&listbox,1,'(\d*)',undef,
 'If activated, the IP is checked against (denySMTPConnectionsFrom) Deny Connections from these IP\'s.<br />',undef,undef,'msg001990','msg001991'],
['denySMTPConnectionsFrom','Deny Connections from these IP\'s*',40,\&textinput,'','(\S*)','ConfigMakeIPRe','Manually maintained list of IP\'s which should be blocked. IP\'s in noPB, noDelay, acceptAllMail, ispip, whiteListedIPs, noProcessingIPs, whitebox will pass. For example: file:files/blockip.txt.<br />
  To define IP\'s only for specific email addresses or domains (recipients) you must use the file:... option<br />
  An entry (line) may look as follows:<br />
  145.146.0.0/16=>*@local.domain|user@mydomain|user2@*.mydomain # comment<br /><br />
  It is possible to define a predefined group on any or both sides of the \'=>\' separator, like:<br />
  [ipgroup]=>[usergroup]|user@mydomain<br /><br />
  NOTICE: the following combination of two entries, will lead in to a user/domain based matching - the global entry will be ignored!<br />
  145.146.0.0/16 # comment<br />
  145.146.0.0/16=>*@local.domain|user@mydomain|user2@*.mydomain # comment<br />
  If multiple user/domain based entries are defined for the same IP, only the last one will be used!',undef,'7','msg002000','msg002001'],
['noBlockingIPs','Do not block Connections from these IP\'s*',40,\&textinput,'','(\S*)','ConfigMakeIPRe','Manually maintained list of IP\'s which should not be blocked.  For example: 145.145.145.145|145.146.<br />
  To define IP\'s only for specific email addresses or domains (recipients) you must use the file:... option<br />
  An entry (line) may look as follows:<br />
  145.146.0.0/16=>*@local.domain|user@mydomain|user2@*.mydomain # comment<br /><br />
  It is possible to define a predefined group on any or both sides of the \'=>\' separator, like:<br />
  [ipgroup]=>[usergroup]|user@mydomain<br /><br />
  NOTICE: the following combination of two entries, will lead in to a user/domain based matching - the global entry will be ignored!<br />
  145.146.0.0/16 # comment<br />
  145.146.0.0/16=>*@local.domain|user@mydomain|user2@*.mydomain # comment<br />
  If multiple user/domain based entries are defined for the same IP, only the last one will be used!',undef,'7','msg002010','msg002011'],
['DoDenySMTPstrict','Do Deny Connections from these IP\'s Strictly','0:disabled|1:block|2:monitor',\&listbox,1,'(\d*)',undef,
 'If activated, the IP is checked against (\'denySMTPConnectionsFromAlways\') Deny Connections from these IP\'s Strictly.',undef,undef,'msg002020','msg002021'],
['denySMTPConnectionsFromAlways','Deny Connections from these IP\'s Strictly*',40,\&textinput,'file:files/denyalways.txt','(\S*)','ConfigMakeIPRe',
 'Manually maintained list of IP\'s which should <b>strictly</b> be blocked after address verification and before body and header is downloaded. Contrary to <i>denySMTPConnectionsFrom</i> IP\'s in noDelay, acceptAllMail, ispip, whiteListedIPs, noProcessingIPs, whitebox will <b>not</b> pass if listed here.',undef,'7','msg002030','msg002031'],
['DoDropList','Do also Deny Connections from these IP\'s','0:disabled|1:add to deny|2:add to denyAlways|3:add to both',\&listbox,0,'(\d*)',undef,
 'If activated, the IP is checked against the Droplist in addition to \'denySMTPConnectionsFromAlways\' and/or \'denySMTPConnectionsFrom\'. The droplist is downloaded if a new one is available and contains the Spamhaus DROP List. See "http://www.spamhaus.org/drop/drop.lasso".',undef,undef,'msg002040','msg002041'],
['denySMTPstrictEarly','Do Strictly Deny Connections Early',0,\&checkbox,'','(.*)',undef,
  'IP\'s in <b>denySMTPConnectionsFromAlways</b> will be denied right away.',undef,undef,'msg002050','msg002051'],
['enhancedOriginIPDetect','Do an Enhanced Origin IP Address Detection in the Mail Header',0,\&checkbox,'1','(.*)',undef,
  'If selected, ASSP will analyze the mail headers "RECEIVED:" lines for IP\'s on the mail routing way to detect spam bots, that uses open relay or highjacked mail servers for mail delivery.<br />
  Local and private IP\'s, and IP\'s listed in ispip, acceptAllMail, whiteListedIPs, noProcessingIPs, noDelay and noPB will be ingnored.<br />
  The detected IP\'s will be additionaly checked for IP-Blocking, DNSBL and IP-Frequency - the same way like the connected IP. These IP\'s are also additionaly used for the maximum mail size calculation in MaxRealSizeAdr and MaxRealSizeExternalAdr.',undef,undef,'msg009590','msg009591'],
['DoFrequencyIP','Check Frequency - Maximum Connections Per IP','0:disabled|1:block|2:monitor|3:score|4:testmode',\&listbox,0,'(\d*)',undef,
 '',undef,undef,'msg002060','msg002061'],
['maxSMTPipConnects','Maximum Frequency of Connections Per IP ',3,\&textinput,'10','(\d?\d?\d?)',undef,
 'The maximum number of SMTP connections an IP Address can make during the <a href="./#maxSMTPipDuration">IP Address Frequency Duration</a>. If a server makes more than this many connections to ASSP within the (maxSMTPipDuration) IP Address Frequency Duration it will be banned from future connections until the (maxSMTPipExpiration) IP Address Frequency Expiration is reached. This can be used to prevent server overloading and DoS attacks. 10 connections are typically enough. If left blank or 0, there is no limit imposed by ASSP. IP\'s in noPB, noDelay, acceptAllMail, ispip, whiteListedIPs, noProcessingIPs, PB-whitebox are excluded from SMTP session limiting, whitelisted and noprocessing addresses are honored',undef,undef,'msg002070','msg002071'],
['maxSMTPipDuration','Maximum Frequency of Connections Per IP Duration',5,\&textinput,'90','(\d?\d?\d?\d?)',undef,
 'The window (in seconds) during which the (maxSMTPipConnects) IP Frequency (see above for more details) will be scrutinized for each IP. The default is 90 seconds.',undef,undef,'msg002080','msg002081'],
['maxSMTPipExpiration','Expiration of Maximum Frequency',5,\&textinput,'7200','(\d?\d?\d?\d?)',undef,
 'The number of seconds that must pass before an IP address blocked by the (maxSMTPipConnects) IP Address Frequency setting is allowed to connect again. The default is 7200 (seconds) .',undef,undef,'msg002090','msg002091'],
['DoDomainIP','Check Number of IP\'s Per Domain','0:disabled|1:block|2:monitor|3:score|4:testmode',\&listbox,0,'(\d*)',undef,
 'This check is skipped if the IP and domain have passed the SPF-check. If ValidateSPF is enabled and an IP/Domain reaches the maxSMTPdomainIP limit, the MaintThread starts a background SPF check to prevent blocking good mails in future.',undef,undef,'msg002100','msg002101'],
['maxSMTPdomainIP','Limit Number of IP\'s  Per Domain',3,\&textinput,'10','(\d?\d?\d?)',undef,
 'The number of IP(subnet) switches a domain may have during the (maxSMTPdomainIPExpiration) Limit Different IP\'s Per Domain Expiration. If a domain switches more often than this it will be banned from future connections until the Expiration is reached. This can be used to prevent server overloading and DoS attacks. 10 connections are typically enough. If left blank or 0, there is no limit imposed by ASSP. IP\'s in noPB, noDelay, acceptAllMail, ispip, whiteListedIPs, noProcessingIPs, PB-whitebox are excluded, whitelisted and noprocessing addresses are honored.',undef,undef,'msg002110','msg002111'],
['maxSMTPdomainIPExpiration','Expiration of Limit Number',5,\&textinput,'7200','(\d?\d?\d?\d?\d?)',undef,
  'The number of seconds that must pass before a domain blocked by the (maxSMTPdomainIP) Limit Subnet IP\'s Per Domain setting (see above for more details) is allowed to connect again. The default is 7200 (seconds).',undef,undef,'msg002120','msg002121'],
['maxSMTPdomainIPWL','Do Not Limit Different IP\'s For These Domains*',60,\&textinput,'gmx.de|t-online.de|yahoo.com|hotmail.com|gmail.com','(.*)','ConfigMakeRe',
  'This prevents specific domains from limiting. For example: yahoo.com|hotmail.*.com|gmail.com<br /><hr />
  <div class="menuLevel1">Notes On IP Blocking</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/ipblocking.txt\',3);" />',undef,undef,'msg002130','msg002131'],

[0,0,0,'heading','SenderBase <a href="http://www.senderbase.org/" target=wiki><img height=12 width=12 src="' . $wikiinfo . '" alt="SenderBase" /></a>'],
['sbTestMode','SenderBase Testmode',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg002140','msg002141'],
['DoOrgWhiting','Do Organization Whiting','0:disabled|1:whiting|2:monitor|3:score',\&listbox,1,'(.*)',undef,
   'If activated, each sending IP address has its assigned organization looked up. Scoring is set with sworgValencePB.',undef,undef,'msg002150','msg002151'],
['whiteSenderBase','Whitelisted Organizations and Domains in SenderBase**',80,\&textinput,'file:files/whiteorg.txt','(.*)','ConfigCompileRe','If the organization or domain  in the <a href="http://www.senderbase.org/" rel="external">SenderBase</a> IP description matches this Perl regular expression the message will be considered non-spam. For example file:files/whiteorg.txt',undef,undef,'msg002160','msg002161'],
['DoOrgBlocking','Do Organization Blocking','0:disabled|1:block|2:monitor|3:score',\&listbox,2,'(.*)',undef,
   'If activated, each sending IP address has its assigned organization looked up. Scoring is set with sborgValencePB, Testmode is set with sbTestMode.',undef,undef,'msg002170','msg002171'],
['blackSenderBase','Blacklisted Organizations and Domains in SenderBase**',80,\&textinput,'','(.*)','ConfigCompileRe','If the organization or domain in the <a href="http://www.senderbase.org/" rel="external">SenderBase</a> IP description matches this Perl regular expression the message will be considered spam.',undef,undef,'msg002180','msg002181'],
['DoCountryBlocking','Do Country Blocking','0:disabled|1:block|2:monitor|3:score',\&listbox,2,'(.*)',undef,
   'If activated, each sending IP address has its assigned country looked up.',undef,undef,'msg002190','msg002191'],

['CountryCodeBlockedRe','Blocked Country Codes**',80,\&textinput,'CN|KR|RU|JP|TR|TH|PL|LT|CL|RO|UA|GR|HU|SA|IN|GB|IE|PT|MD|PE|CZ|TW|BR|CL','(.*)','ConfigCompileRe',
  'Messages from IP\'s based in these countries will be blocked. For example: CN|KR|RU|JP|TR|TH|PL|LT|CL|RO|UA|GR|HU|SA|IN|IE|PT|MD|PE|CZ|TW|BR|CL. "all" will block all foreign countrycodes which are not in \'Suspicious Country Codes\' or \'Ignore Country Codes\'. See: <a href="http://www.iso.org/iso/country_codes/iso_3166_code_lists/english_country_names_and_code_elements.htm" rel="external">English country names and code elements</a>. ',undef,undef,'msg002200','msg002201'],
['DoSenderBase','Do Country Code Scoring','0:disabled|2:monitor|3:score',\&listbox,3,'(.*)',undef,
   'If activated, each sending IP address has its assigned country looked up.',undef,undef,'msg002210','msg002211'],

['NoCountryCodeRe','Ignore Countries*',80,\&textinput,'US|CA|DE','(.*)','ConfigCompileRe',
  'Messages from IP\'s based in these countries will be ignored. For example: US|CA|DE',undef,undef,'msg002220','msg002221'],
['CountryCodeRe','Suspicious Country Codes**',80,\&textinput,'CN|KR|RU|JP|TR|TH|PL|LT|CL|RO|UA|GR|HU|SA|IN|IE|PT|MD|PE|CZ|TW|BR|CL|ID|PH','(.*)','ConfigCompileRe',
  'Messages from IP\'s based in these countries will increase the MessageScore. For example: CN|KR|RU|JP|TR|TH|PL|LT|CL|RO|UA|GR|HU|SA|IN|IE|PT|MD|PE|CZ|TW|BR|CL|ID|PH',undef,undef,'msg002230','msg002231'],
['MyCountryCodeRe','Home Country Codes**',80,\&textinput,'','(.*)','ConfigCompileRe',
  'Put here your own country code(s) (for example: US). Messages from IP\'s based in these countries will decrease, messages from other countries will increase the MessageScore.',undef,undef,'msg002240','msg002241'],
['ScoreForeignCountries','Score Foreign Countries',0,\&checkbox,'1','(.*)',undef,
  'Messages from foreign countries will increase the total messageScore using sbfccValencePB.',undef,undef,'msg002250','msg002251'],
['SBCacheExp','Country Cache Refresh Interval',4,\&textinput,3,'(\d+\.?\d*|)','configUpdateSBCR',
  'IP\'s in cache will be removed after this interval in days. 0 will disable the cache.  <input type="button" value=" show cache" onclick="javascript:popFileEditor(\'pb/pbdb.sb.db\',5);" />',undef,undef,'msg002260','msg002261'],

[0,0,0,'heading','PenaltyBox <a href="http://apps.sourceforge.net/mediawiki/assp/index.php?title=Penalty_Box" target=wiki><img height=12 width=12 src="' . $wikiinfo . '" alt="PenaltyBox" /></a>'],
['DoPenalty','Do PenaltyBox - IP History<a href="http://apps.sourceforge.net/mediawiki/assp/Penalty_Box" target="ASSPHELP"><img src="' . $wikiinfo . '" alt="wiki" /></a>','0:disabled|1:block|2:monitor/messageScoring',\&listbox,2,'(\d*)',undef,'The PenaltyBox is a  temporary position of low esteem awarded for a perceived misdeed. It scores IP\'s based on some events ( baValencePB see  penalty scores )and writes them into  a BlackBox. If the score per specified time interval surpasses the threshold the message is rejected (and the IP is marked for blocking). They continue to get scored  up to the Extreme Threshold.<br />
 These top performers can get a special treatment PenaltyExtreme when DoPenaltyExtreme is enabled. The WhiteBox stores IP\'s which should not be put into the BlackBox. The WhiteBox is always enabled. If an address is in the whitelist or whitedomain, the IP goes into the WhiteBox. The WhiteBox is one of the sources  Delaying/Greylisting uses to determine when delaying should not be done. <br />Entries in <i>Don\'t do penalties for these IP\'s</i> or <i>ISP/Secondary MX Servers</i> will prevent from penalties. Select \'monitor/messageScoring\' to fill WhiteBox and BlackBox. \'monitor/messageScoring\' is also the right choice if you do not want to block IP\'s but rather score a message in \'Message Scoring Mode\'. ',undef,undef,'msg002270','msg002271'],
['DoPenaltyMessage','Message Scoring Mode ','0:disabled|1:block|2:monitor|4:tagging',\&listbox,1,'(\d*)',undef,'If this feature is selected, the total score for all checks during a message is used to determine if the email is Spam. If the combined score is greater than the <b>Low MessageLimit</b> (PenaltyMessageLow) and less than or equal the <b>High MessageLimit</b> (PenaltyMessageLimit) the message will not be blocked but tagged. If the combined score is greater than the <b>High MessageLimit</b> (PenaltyMessageLimit), the message will be blocked.',undef,undef,'msg002280','msg002281'],
['MsgScoreOnEnd','Message Scoring on End',0,\&checkbox,'','(.*)',undef,'ASSP will wait using the \'DoPenaltyMessage\' action, until all configured possible checks are finished. Use this, to force calculating a complete message score over all values, including all bonus values.',undef,undef,'msg002290','msg002291'],
['PenaltyMessageLow','Low MessageLimit',3,\&textinput,40,'(\d*)',undef,'MessageMode will not block messages whose score exceeds this threshold during the message but will tag them.  For example: 40',undef,undef,'msg002300','msg002301'],

['PenaltyMessageLimit','High MessageLimit',3,\&textinput,50,'(\d*)',undef,'MessageMode will block messages whose score exceeds this threshold during the message.  For example: 50',undef,undef,'msg002310','msg002311'],
['AddScoringHeader','Add IP/Message Scoring Header',0,\&checkbox,1,'(.*)',undef,'Adds a line to the email header "X-Assp-XXX-Score: ", where XXX may be IP, Message or both.',undef,undef,'msg002320','msg002321'],

['pbdb','PenaltyBox Database',40,\&textinput,'pb/pbdb','(\S*)','configChangeDB','The directory/file with the penaltybox database files. For removal of entries from BlackBox use noPB .
 For removal of entries from WhiteBox use noPBwhite. For whitelisting IP\'s use whiteListedIPs or noProcessingIPs . For blacklisting use denySMTPConnectionsFrom and denySMTPConnectionsFromAlways .<br />Write only "DB:" to use a database table instead of a local file. <br />
 <input type="button" value=" Show BlackBox" onclick="javascript:popFileEditor(\'pb/pbdb.black.db\',4);" /><input type="button" value="Show White Box" onclick="javascript:popFileEditor(\'pb/pbdb.white.db\',4);" />',undef,undef,'msg002330','msg002331'],
['noPB','Don\'t do Profiling for these IP\'s*',80,\&textinput,'','(\S*)','ConfigMakeIPRe',
 'Enter IP\'s that you don\'t want to be penalized. These IP\'s will also be automatically removed from PB-BlackBox. For example: 127.0.0.1|172.16.',undef,'7','msg002340','msg002341'],
['noPBwhite','Don\'t do WhiteBox for these IP\'s*',80,\&textinput,'','(\S*)','ConfigMakeIPRe',
 'Enter IP\'s that you want to be penalized. These IP\'s will also be automatically removed from PB-WhiteBox.',undef,'7','msg002350','msg002351'],
['WhiteExpiration','Expiration Time for WhiteBox Entries',4,\&textinput,30,'(\d?\d?\d?\d?)',undef,
  "The WhiteBox is always activated. The WhiteBox is similar to the  Whitelist  - but it is not a whitelist: content-related checks like Bayesian, URIBL, Bomb  will be done, IP-related checks will be skipped. WhiteBox entries will expire after this specified number of days. For example: 30",undef,undef,'msg002360','msg002361'],
['DoDamping','Do Damping on Messagescore [0...99]',4,\&textinput,'0','(\d{1,2})',undef,'If DoPenalty and DoPenaltyMessage are set not to disabled and DoDamping is not set to 0, ASSP will slowdown the spammers traffic speed proportional to the current message score - because slowing down their speed will reduce spam everywhere.<br />
  The delay in seconds per receive/read cycle is calculated by the division [messagescore / DoDamping] . A recommended value is 5 default is 0. In this case the delay for a message score of 50 would be 10 seconds.<br />
  Do not use this option, if you have a highly frequented system, because the spammers connections will stay possibly a long time on your system, and you system could possibly reach the sessions limit ( maxSMTPSessions ).<br />
  Damping is never done for: noprocessing, whitelisted, nodelay, ISP, redlisted, noPB, outgoing/releayed and contentonly addresses, IP\'s, messages.<br />
  Damping may not be done for forced checks, relay attemps, messages reaching maxerrors, spamtrapaddresses and if any block condition is found - because ASSP will no more read from those connections and closes such connections immediately - but ASSP will try to keep the connection open for the calculated time, before it closes the connection.<br />
  Using this option or using a too low value (long delay) could possibly prevent ASSP from receiving spam messages, for example for spamlovers or sendAllSpam . Some Servers could give up sending data, because of too long delays.',undef,undef,'msg002370','msg002371'],
['maxDampingTime','Max time Used for Damping',4,\&textinput,30,'(\d?\d?\d?)',undef,
  "The maximum time in second, that is used for one damping cycle if DoDamping is not set to 0, even if the calculated value caused by DoDamping is higher. For example: 30",undef,undef,'msg002380','msg002381'],
['spamtrapaddresses','PenaltyBox Trap Addresses *',80,\&textinput,'put|your@penaltytrap.com|addresses|@here.org','(.*)','ConfigMakeSLRe',
  'Mail to any of these addresses will be blocked and the scoring value is added. Whitelist and noPenaltyMakeTraps will be ignored. Nothing will be stored in the Spam Collection, if these addresses are not checked for validity. TO: and CC: addresses will be also checked - BCC: addresses only, if \'removeForeignBCC\' is not set. Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com).',undef,undef,'msg002390','msg002391'],
['PenaltyTrapPolite','PenaltyTrap Reply',80,\&textinput,'550 5.1.1 User unknown: EMAILADDRESS','^([542]\d\d .+)',undef,'SMTP reply for invalid Users. Default: \'550 5.1.1 User unknown: EMAILADDRESS\' <br /> The literal EMAILADDRESS (case sensitive) is replaced by the fully qualified SMTP recipient (e.g., thisuser@example.com).',undef,undef,'msg002400','msg002401'],
['DoPenaltyMakeTraps','Do Heavy Used Invalid Addresses as PenaltyBox Trap Addresses','0:disabled|1:make traps and block them|2:make traps, only collect them|3:do not make them but block',\&listbox,2,'(.*)',undef,
  'If set to \'make traps, only collect them\', the frequency of Invalid Addresses is stored, no other action taken. If set to \'do not make them but block\' or \'make traps and block them\', addresses in heavy use will act like spamtrapaddresses (PenaltyBox Trap Addresses). If UseTrapToCollect is also set they will work like spamaddresses and collect the mails.',undef,undef,'msg002410','msg002411'],
['PenaltyMakeTraps','Invalid Addresses Limit',3,\&textinput,'10','(\d*)',undef,
  'Minimum number of times an address must appear before it will be used as Trap. For example 10.',undef,undef,'msg002420','msg002421'],

['noPenaltyMakeTraps','Exceptionlist for Traps*',60,\&textinput,'','(.*)','ConfigMakeSLRe',
 'Addresses which should not be used for traps. This list is also opponent to spamtrapaddresses . Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com).  Wildcards are supported (fribo*@domain.com).',undef,undef,'msg002430','msg002431'],
['PBTrapInterval','Invalid Addresses Refresh Interval',4,\&textinput,3,'(\d+\.?\d*|)',undef,
  'Addresses will be removed after this interval in days. For example 3. <input type="button" value=" Show Invalid Addresses" onclick="javascript:popFileEditor(\'pb/pbdb.trap.db\',5);" />',undef,undef,'msg002440','msg002441'],
['PenaltyUseNetblocks','Use IP Netblocks',0,\&checkbox,'1','(.*)',undef,
  'Perform the IP address checks of the sending host based on the /24 subnet  rather than on the specific IP.',undef,undef,'msg002450','msg002451'],
['PenaltyError','Penalty Reply',80,\&textinput,'','^([245]\d\d .*|)$',undef,
  'If set SMTP reply for Penalty Deny. eg: \'554 5.7.1 Error, send your mail to postmaster@LOCALDOMAIN to ensure delivery\'. The literal LOCALDOMAIN will be replaced by the recipient domain. For example:554 5.7.1 Mail appears to be unsolicited -- send error reports to postmaster@LOCALDOMAIN.',undef,undef,'msg002460','msg002461'],
['PenaltyDuration','Penalty Interval',4,\&textinput,60,'(\d?\d?\d?\d?)','updatePenaltyDuration',
  "IP\'s will be kept in the BlackBox if their score exceeds the Penalty Limit during this interval (minutes).",undef,undef,'msg002470','msg002471'],
['PenaltyLimit','Penalty Limit',4,\&textinput,50,'(\d*)',undef,
  'PB will block IP\'s whose score exceeds this threshold during the Penalty Interval. <br />Successful ASSP checks will increase the internal score per IP. For example: 50',undef,undef,'msg002480','msg002481'],
['PenaltyExpiration','Expiration Time',4,\&textinput,360,'(\d?\d?\d?\d?)','updatePenaltyExpiration',
  "Penalties will expire after this number of minutes. If set to Zero the Penalty BlackBox will be deleted and started from scratch.",undef,undef,'msg002490','msg002491'],
['CleanPBInterval','Clean Up PB Databases <sup>s</sup>',40,\&textinput,3,$ScheduleGUIRe,'configChangeSched',
  'Delete outdated entries from blackbox and whitebox databases every this many hours.<br />
  Defaults to 3 hours.',undef,undef,'msg002500','msg002501'],
['DoPenaltyExtreme','PenaltyBox Extreme IP Profiling','0:disabled|1:block|2:monitor',\&listbox,0,'(\d*)',undef,'If set PBextreme will block IP\'s whose score meet or exceed Extreme Scoring Threshold. DoPenaltyExtreme blocks after the header is done, based on the IP\'s score from previous and current SMTP session',undef,undef,'msg002510','msg002511'],
['DoPenaltyExtremeSMTP','Enforce Early PenaltyBox Extreme IP Profiling','0:disabled|1:block|2:monitor',\&listbox,0,'(.*)',undef,
  'If set PBextreme will block IP\'s whose score meet or exceed Extreme Scoring Threshold before DELAYING, based on the IP\'s score from previous SMTP sessions. This can be set independently from DoPenaltyExtreme above. Whitelist, Collecting, Testmode, CopySpam, Spam-Lover is ignored.',undef,undef,'msg002520','msg002521'],

['noExtremePB','Don\'t do Extreme Profiling for these IP\'s*',80,\&textinput,'','(\S*)','ConfigMakeIPRe',
 'Enter IP\'s that you don\'t want to be extreme penalized. IP\'s in noPB are already included. For example: 127.0.0.1|172.16.',undef,'7','msg009280','msg009281'],
['noExtremePBAddresses','Don\'t do Extreme Profiling for Mails from any of these Addresses*',60,\&textinput,'','(.*)','ConfigMakeSLRe',
 'Mails from any of these addresses will not be extreme profiled if DoPenaltyExtremeSMTP is not set. Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com).  Wildcards are supported (fribo*@domain.com).',undef,undef,'msg009290','msg009291'],
['PenaltyExtreme','Extreme Scoring Threshold',4,\&textinput,150,'(\d*)',undef,
  'PBextreme will use this to determine candidates for special treatment. For example: 150.',undef,undef,'msg002530','msg002531'],
['ExtremeWL','Penalize Whitelisted',0,\&checkbox,'','(.*)',undef,
  'Enable extreme penalties for whitelisted addresses.',undef,undef,'msg002540','msg002541'],
['ExtremeNP','Penalize NonProcessing',0,\&checkbox,'','(.*)',undef,
  'Enable extreme penalties for addresses on the noProcessing list.',undef,undef,'msg002550','msg002551'],
['ExtremeExpiration','Expiration Time for Extreme Penalties',4,\&textinput,7,'(\d?\d?\d?\d?)',undef,,
  "Extreme penalties will expire after this number of days. For example: 7",undef,undef,'msg002560','msg002561'],
['DoExtremeExport','Do Export Penalty BlackBox Extreme',0,\&checkbox,'','(.*)',undef,  '',undef,undef,'msg002570','msg002571'],
['DoExtremeExportAppend','Append Export File',0,\&checkbox,'','(.*)',undef,'Do not overwrite the export file but append to it.',undef,undef,'msg002580','msg002581'],
['exportInterval','Export BlackBox Extreme File Interval <sup>s</sup>',40,\&textinput,6,$ScheduleGUIRe,'configChangeSched',
  ' Exported Penalty Black Box Extreme File every this hours.<br />
  Defaults to 6 hours.',undef,undef,'msg002590','msg002591'],
['exportExtremeBlack','Exported BlackBox Extreme File ',40,\&textinput,'file:files/exportedextreme.txt','(\S*)',undef, 'IP\'s in Penalty BlackBox which surpassed the extreme level will be regularly stored into this file. May be used for setting the firewall or similar applications.'  ,undef,undef,'msg002600','msg002601'],
['DoNotPenalizeRed','Do Not Score IP\'s in Redlisted Messages',0,\&checkbox,'','(.*)',undef,
  'IP\'s matching Red Regex or Redlist will not collect scoring values from PenaltyBox.',undef,undef,'msg002610','msg002611'],
['DoNotPenalizeNull','Do Not Score IP\'s From Bounce/Null-Senders',0,\&checkbox,'','(.*)',undef,
  'IP\'s matching BounceSenders will not be IP-penalized.<hr>',undef,undef,'msg002620','msg002621'],

['autValencePB','Bad SMTP Authentication, default=60 +',10,\&textinput,60,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring<br />
 <hr>This option and all other *ValencePB options with an "+" at the end of the description, accepts a second comma or pipe separated value like: "20,10" .<br />
  In this case the first value is used for message scoring and the second value is used for IP scoring.<br />
  If only the first value is defined, this value is used for both scoring mechanism.<br />
  If a *ValencePB option is related to any feature which allowes the usage of weighted penalties, the message scoring value is used to calculate the weighted penalty and the result is used for message and IP scoring.','Basic',undef,'msg009300','msg009301'],
['baValencePB','Bad Attachment, default=20 +',10,\&textinput,20,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002630','msg002631'],
['backsctrValencePB','Backscatter detection, default=10 +',10,\&textinput,10,$ValencePBRE,'ConfigChangeValencePB', 'Message scoring',undef,undef,'msg002640','msg002641'],
['baysValencePB','Bayesian, default=49 +',10,\&textinput,49,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002650','msg002651'],
['bayslocalValencePB','Bayesian for Local Messages, default=55 +',10,\&textinput,55,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg009550','msg009551'],
['HMMValencePB','Hidden-Makov-Model, default=49 +',10,\&textinput,49,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg009640','msg009641'],
['HMMlocalValencePB','Hidden-Makov-Model for Local Messages, default=55 +',10,\&textinput,55,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg009650','msg009651'],
['blValencePB','Blacklisted Domain, default=20 +',10,\&textinput,20,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002660','msg002661'],
['bombSuspiciousValencePB','Bomb Suspicious - scoring only, default=10 +',10,\&textinput,10,$ValencePBRE,'ConfigChangeValencePB', 'Message scoring',undef,undef,'msg002670','msg002671'],
['bombValencePB','Bomb Expression, default=20 +',10,\&textinput,20,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002680','msg002681'],
['blackValencePB','Bomb Black Expression, default=20 +',10,\&textinput,20,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002690','msg002691'],
['dkimValencePB','Domain Key Verification failed, default=15 +',10,\&textinput,15,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002700','msg002701'],
['dkimOkValencePB','Domain Key Verification OK, default=0',3,\&textinput,0,'(-{0,1}\d*)','ConfigChangeValencePB', '<span class="positive">Message Scoring Bonus</span>',undef,undef,'msg002710','msg002711'],
['erValencePB','Empty Recipients, default=5 +',10,\&textinput,5,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002720','msg002721'],
['etValencePB','Early Talker Scoring, default=25 +',10,\&textinput,25,$ValencePBRE,'ConfigChangeValencePB', "Message/IP scoring for clients who talk before server's greeting is sent. An value of zero will disable this check - otherwise assp scores the IP and droppes the connection.",undef,undef,'msg002730','msg002731'],
['fhValencePB','Forged HELO, default=150 +',10,\&textinput,150,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002740','msg002741'],
['fiphValencePB','Suspicious HELO: IP in HELO, default=39 +',10,\&textinput,39,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002750','msg002751'],
['fiphmValencePB','Suspicious HELO: IP in HELO mismatch, default=60 +',10,\&textinput,60,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002760','msg002761'],
['flValencePB','Invalid Local Sender, default=20 +',10,\&textinput,20,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002770','msg002771'],
['hlValencePB','Blacklisted/Good HELO, default=20 +',10,\&textinput,20,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002780','msg002781'],
['iaValencePB','Internal Only Address, default=25 +',10,\&textinput,25,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002790','msg002791'],
['idValencePB','Domain Changing IP Frequency, default=150 +',10,\&textinput,150,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002800','msg002801'],
['ifValencePB','IP Frequency, default=150 +',10,\&textinput,150,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002810','msg002811'],
['idleValencePB','Timeout Score',3,\&textinput,0,'(\d+)','ConfigChangeValencePB', 'For IP scoring with smtpIdleTimeout.',undef,undef,'msg008870','msg008871'],
['iplValencePB','IP Parallel Sessions, default=5 +',10,\&textinput,5,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002820','msg002821'],
['ihValencePB','Invalid HELO, default=10 +',10,\&textinput,10,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002830','msg002831'],
['irValencePB','Invalid Recipient, default=10 +',10,\&textinput,10,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg008940','msg008941'],
['isValencePB','Subject Frequency, default=150 +',10,\&textinput,150,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg010030','msg010031'],
['mdrValencePB','Duplicate Recipient, default=10 +',10,\&textinput,10,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002840','msg002841'],
['midmValencePB','Missing Message-ID, default=10 +',10,\&textinput,10,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002850','msg002851'],
['midsValencePB','Suspicious Message-ID, default=10 +',10,\&textinput,10,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002860','msg002861'],
['midiValencePB','Invalid Message-ID, default=10 +',10,\&textinput,10,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002870','msg002871'],
['fbmtvValencePB','Invalid FBMTV check, default=25 +',10,\&textinput,25,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002880','msg002881'],
['batvValencePB','Invalid BATV check, default=25 +',10,\&textinput,25,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002890','msg002891'],
['meValencePB','Max Errors Exceeded, default=10 +',10,\&textinput,10,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002900','msg002901'],
['msValencePB','Message Scoring Limit Exceeded, default=10 +',10,\&textinput,10,$ValencePBRE,'ConfigChangeValencePB', 'IP scoring',undef,undef,'msg002910','msg002911'],
['mxValencePB','Missing MX, default=10 +',10,\&textinput,10,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002920','msg002921'],
['mxaValencePB','Missing MX &amp; A Record, default=15 +',10,\&textinput,15,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002930','msg002931'],
['nofromValencePB','No From Score, default=50 +',10,\&textinput,50,$ValencePBRE,'ConfigChangeValencePB','For Message/IP scoring in DoNoFrom.',undef,undef,'msg002940','msg002941'],
['pbeValencePB','Extreme Bad IP History, TotalScore larger than PenaltyExtreme, default=25',3,\&textinput,25,'(\d+)','ConfigChangeValencePB', 'Message Scoring',undef,undef,'msg002950','msg002951'],
['pbValencePB','Bad IP History, TotalScore larger than PenaltyLimit, default=15',3,\&textinput,15,'(\d+)','ConfigChangeValencePB', 'Message Scoring',undef,undef,'msg002960','msg002961'],
['pbwValencePB','Good IP History (IP in PB WhiteBox), default=-15',3,\&textinput,-15,'(-{0,1}\d*)','ConfigChangeValencePB', '<span class="positive">Message Scoring Bonus</span>',undef,undef,'msg002970','msg002971'],
['gripValencePB','GRIP value (+ if > 0.9,- if < 0.1), default=5',3,\&textinput,5,'(\d+)','ConfigChangeValencePB', 'Message scoring',undef,undef,'msg002980','msg002981'],
['okValencePB','Message OK, default=-25',3,\&textinput,-25,'(-?\d*)','ConfigChangeValencePB', '<span class="positive">IP Bonus</span>',undef,undef,'msg002990','msg002991'],
['ptmValencePB','Missing PTR Record, default=10 +',10,\&textinput,10,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg003000','msg003001'],
['ptiValencePB','Invalid PTR Record, default=15 +',10,\&textinput,15,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg003010','msg003011'],
['rblnValencePB','DNSBL Neutral, default=35 +',10,\&textinput,35,$ValencePBRE,'ConfigChangeValencePB','Message/IP scoring',undef,undef,'msg003020','msg003021'],
['rblValencePB','DNSBL Failed, default=100 +',10,\&textinput,100,$ValencePBRE,'ConfigChangeValencePB','Message/IP scoring',undef,undef,'msg003030','msg003031'],
['rlValencePB','Failed Relay Attempt, default=10 +',10,\&textinput,10,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg003040','msg003041'],
['saValencePB','Spam Collect Address, default=25',3,\&textinput,25,'(\d+)','ConfigChangeValencePB', 'IP scoring',undef,undef,'msg003050','msg003051'],
['scriptValencePB','Script Expression, default=25 +',10,\&textinput,25,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg003060','msg003061'],
['sbnValencePB','No Organization and No CountryCode, default=10 +',10,\&textinput,10,$ValencePBRE,'ConfigChangeValencePB', 'For Message/IP scoring in DoOrgBlocking/DoCountryBlocking',undef,undef,'msg003070','msg003071'],
['sworgValencePB','White Organizations Score, default=-25',3,\&textinput,-25,'(-\d*)','ConfigChangeValencePB', '<span class="positive"> Bonus for Message/IP scoring in DoOrgWhiting</span>',undef,undef,'msg003080','msg003081'],
['sbsccValencePB','Suspicious Country Code, default=10',3,\&textinput,10,'(\d+)','ConfigChangeValencePB', 'Message scoring',undef,undef,'msg003090','msg003091'],
['bccValencePB','Blocked Country Code Score, default=25 +',10,\&textinput,25,$ValencePBRE,'ConfigChangeValencePB', 'For Message/IP scoring  in PenaltyBox ( DoPenalty )',undef,undef,'msg003100','msg003101'],
['sbfccValencePB','Foreign Country Code Score, default=10 +',10,\&textinput,10,$ValencePBRE,'ConfigChangeValencePB', 'message scoring  in PenaltyBox ( DoPenaltyMessage )',undef,undef,'msg003110','msg003111'],
['sbhccValencePB','<span class="positive">Home Country Code Score, default=-10</span> +',10,\&textinput,-10,$ValencePB2RE,'ConfigChangeValencePB', '<span class="positive"> Bonus for Message/IP Scoring  in PenaltyBox ( DoPenalty )</span>',undef,undef,'msg003120','msg003121'],
['sborgValencePB','Blocked Organizations Score, default=25 +',10,\&textinput,25,$ValencePBRE,'ConfigChangeValencePB', 'For Message/IP scoring  in PenaltyBox ( DoPenalty )',undef,undef,'msg003130','msg003131'],
['spfpValencePB','SPF Pass Score, default=-10',3,\&textinput,-10,'(-{0,1}\d*)','ConfigChangeValencePB','<span class="positive"> Bonus for Message/IP scoring with SPF',undef,undef,'msg003140','msg003141'],
['spfnValencePB','SPF Neutral, default=5 +',10,\&textinput,5,$ValencePBRE,'ConfigChangeValencePB','Message/IP scoring',undef,undef,'msg003150','msg003151'],
['spfsValencePB','SPF Softfailed, default=5 +',10,\&textinput,5,$ValencePBRE,'ConfigChangeValencePB','Message/IP scoring',undef,undef,'msg003160','msg003161'],
['spfnonValencePB','SPF None, default=0 +',10,\&textinput,0,$ValencePBRE,'ConfigChangeValencePB','Message/IP scoring',undef,undef,'msg003170','msg003171'],
['spfuValencePB','SPF Unknown, default=0 +',10,\&textinput,0,$ValencePBRE,'ConfigChangeValencePB','Message/IP scoring',undef,undef,'msg003180','msg003181'],
['spfeValencePB','SPF Error, default=5 +',10,\&textinput,5,$ValencePBRE,'ConfigChangeValencePB','Message/IP scoring',undef,undef,'msg003190','msg003191'],
['spfValencePB','SPF Failed, default=10 +',10,\&textinput,10,$ValencePBRE,'ConfigChangeValencePB','Message/IP scoring',undef,undef,'msg003200','msg003201'],
['srsValencePB','SRS Validate Bounce Failed Score, default=10 +',10,\&textinput,10,$ValencePBRE,'ConfigChangeValencePB','For Message/IP scoring in SRSValidateBounce',undef,undef,'msg003210','msg003211'],
['stValencePB','Penalty Trap Address, default=50 +',10,\&textinput,50,$ValencePBRE,'ConfigChangeValencePB', 'For Message/IP scoring',undef,undef,'msg003220','msg003221'],
['tlsValencePB','OK, Is a SSL/TLS connection, default=-10 +',10,\&textinput,-10,$ValencePB2RE,'ConfigChangeValencePB', '<span class="positive">Message Scoring/IP scoring Bonus for SSL/TLS connections</span>',undef,undef,'msg003230','msg003231'],
['uriblnValencePB','URIBL Neutral, default=20 +',10,\&textinput,20,$ValencePBRE,'ConfigChangeValencePB','Message/IP scoring',undef,undef,'msg003240','msg003241'],
['uriblValencePB','URIBL Failed, default=25 +',10,\&textinput,25,$ValencePBRE,'ConfigChangeValencePB','Message/IP scoring',undef,undef,'msg003250','msg003251'],
['vsValencePB','Virus suspicious, default=25',3,\&textinput,25,'(\d+)','ConfigChangeValencePB','Message scoring',undef,undef,'msg003260','msg003261'],
['vdValencePB','Virus detected, default=50 +',10,\&textinput,50,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg003270','msg003271'],
['teValencePB','TestRe Valence, default=20 +',10,\&textinput,20,$ValencePBRE,'ConfigChangeValencePB', 'Valence for testing testRe<br /><hr />
  <div class="menuLevel1">Notes On Penalty Box</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/penaltybox.txt\',3);" />',undef,undef,'msg008710','msg008711'],

[0,0,0,'heading','Delaying/Greylisting <a href="http://apps.sourceforge.net/mediawiki/assp/index.php?title=Delaying/Greylisting" target=wiki><img height=12 width=12 src="' . $wikiinfo . '" alt="Delaying" /></a>'],
['EnableDelaying','Enable Delaying/Greylisting',0,\&checkbox,1,'(.*)',undef,
  'Enable Greylisting as described at <a href="http://projects.puremagic.com/greylisting/whitepaper.html?view=markup" rel="external">Greylisting-whitepaper</a>.<br />
  It\'s a new method of blocking significant amounts of spam at the mailserver level, but without resorting to heavyweight statistical analysis or other heuristical approaches.',undef,undef,'msg003280','msg003281'],
['DelayWL','Whitelisted Greylisting',0,\&checkbox,'','(.*)',undef,
  'Enable Greylisting for whitelisted mails. This also enables Geylisting for SPF-Cache-OK listed IP\'s and mails from white organizations, which are normaly not greylisted.',undef,undef,'msg003290','msg003291'],
['DelayNP','NoProcessing Greylisting',0,\&checkbox,'','(.*)',undef,
  'Enable Greylisting for noprocessing mails.',undef,undef,'msg003300','msg003301'],
['DelaySL','Spam-Lovers Greylisting',0,\&checkbox,'','(.*)',undef,
  'Enable Greylisting for Spam-Lovers.',undef,undef,'msg003310','msg003311'],
['DelayAddHeader','Add X-Assp-Delayed Header',0,\&checkbox,1,'(.*)',undef,
  'Add X-Assp-Delayed header to header of all delayed or whitelisted mails.',undef,undef,'msg003320','msg003321'],
['DelayEmbargoTime','Embargo Time',5,\&textinput,5,'(\d+)',undef,
  'Enter the number of minutes for which delivery, related with new \'triplet\' (IP address of the sending<br />
  host + mail from + rcpt to), is refused with a temporary failure. Default is 5 minutes.',undef,undef,'msg003330','msg003331'],
['DelayWaitTime','Wait Time',5,\&textinput,28,'(\d+)',undef,
  'Enter the number of hours to wait for delivery attempts related with recognised \'triplet\'; delivery is accepted <br />
  immediately and the \'tuplet\' (IP address of the sending host + sender\'s domain) is safelisted. Default is 28 hours.',undef,undef,'msg003340','msg003341'],
['DelayExpiryTime','Expiry Time',5,\&textinput,36,'(\d+)',undef,
  'Enter the number of days for which whitelisted \'tuplet\' is considered valid. Default is 36 days.',undef,undef,'msg003350','msg003351'],
['DelayUseNetblocks','Use IP Netblocks',0,\&checkbox,1,'(.*)',undef,
  'Perform the IP address checks of the sending host based on the /24 subnet it is at rather than the specific IP. <br />
  This feature may be useful for legitimate mail systems that shuffle messages among SMTP clients between retransmissions.',undef,undef,'msg003360','msg003361'],
['DelayNormalizeVERPs','Normalize VERP Addresses',0,\&checkbox,1,'(.*)',undef,
  'Some mailing lists (such as Ezmlm) try to track bounces to individual mails, rather than just individual recipients, which creates a variation on the VERP method where each email has its own unique envelope sender. Since the automatic whitelisting (called savelisting to make a difference to the standard whitelisting) that is built into Greylisting depends on the envelope addresses for subsequent mails being the same, the greylisting filter will attempt to normalize the unique sender addresses, when this option is checked.',undef,undef,'msg003370','msg003371'],
['DelayWithMyName','Add myName to Triplets',0,\&checkbox,0,'(.*)',undef,
  'If set, myName is added to every delay triplet (not to tuplets). This is useful and recommended, if you are using more than one ASSP host with shared databases for delaydb. This option makes the triplets unique to every ASSP host, because it is allowed for SMTP-hosts, to request a backup MX immediately after the primary MX, without waiting 5 minutes (DelayEmbargoTime) between the two requests.',undef,undef,'msg003380','msg003381'],
['DelayMD5','Use MD5 for DelayDB',0,\&checkbox,'1','(.*)',undef,
  'Message-Digest algorithm 5 is a cryptographic hash function and adds some level of security to the delay database. Must be set to off if you want to list the database with DelayShowDB/DelayShowDBwhite. This requires an installed <a href="http://search.cpan.org/search?query=Digest::MD5" rel="external">Digest::MD5</a> module in PERL.',undef,undef,'msg003390','msg003391'],
['DelayShowDB','Show Delay/Greylisting Database',40,\&textinput,'file:delaydb','(\S*)',undef,'The directory/file with the delay database file. If you change the filename in section Filepath ( delaydb ) you must change it here too.',undef,'8','msg003400','msg003401'],
['DelayShowDBwhite','Show Delay/Greylisting Save Database',40,\&textinput,'file:delaydb.white','(\S*)',undef,'The directory/file with the save delay database file. If you change the filename in section Filepath ( delaydb )  you must change it here too.',undef,'8','msg003410','msg003411'],
['DelayExpireOnSpam','Expire Spamming Safelisted Tuplets',0,\&checkbox,1,'(.*)',undef,
  'If a safelisted \'tuplet\' is ever associated with spam, viri, failed rbl, spf etc, it is deleted from the safelist. <br />
  This renews the temporary embargo for subsequent mail involving the tuplet.',undef,undef,'msg003420','msg003421'],
['CleanDelayDBInterval','Clean Up Delaying Database <sup>s</sup>',40,\&textinput,10800,$ScheduleGUIRe,'configChangeSched',
  'Delete outdated entries from triplets and safelisted tuplets databases every this many seconds.<br />
  Defaults to 3 hour.',undef,undef,'msg003430','msg003431'],
['noDelay','Don\'t Delay these IPs*',80,\&textinput,'file:files/nodelay.txt','(\S*)','ConfigMakeIPRe',
  'Enter IP addresses that you don\'t want to be delayed, separated by pipes (|). There are misbehaving MTAs that will not be able to get a legitimate email through a Greylisting server because they do not try again later. An INCOMPLETE list of such mailers is available at <a href="http://cvs.puremagic.com/viewcvs/greylisting/schema/whitelist_ip.txt" rel="external">cvs.puremagic.com/viewcvs/Greylisting/schema/whitelist_ip.txt</a>. <br />
  When using mentioned list remember to add trailing dots in IP addresses which specify subnets (eg. 192.168 -> 192.168. ).<br />
  For example:  127.0.0.1|172.16..<br />
  To define IP\'s only for specific email addresses or domains (recipients) you must use the file:... option<br />
  An entry (line) may look as follows:<br />
  145.146.0.0/16=>*@local.domain|user@mydomain|user2@*.mydomain # comment<br /><br />
  It is possible to define a predefined group on any or both sides of the \'=>\' separator, like:<br />
  [ipgroup]=>[usergroup]|user@mydomain<br /><br />
  NOTICE: the following combination of two entries, will lead in to a user/domain based matching - the global entry will be ignored!<br />
  145.146.0.0/16 # comment<br />
  145.146.0.0/16=>*@local.domain|user@mydomain|user2@*.mydomain # comment<br />
  If multiple user/domain based entries are defined for the same IP, only the last one will be used!',undef,'7','msg003440','msg003441'],
['noDelayAddresses','Do not Delay these Addresses*',80,\&textinput,'','(.*)','ConfigMakeSLRe','Enter senders email addresses that you don\'t want to be delayed, separated by pipes (|). You can list specific addresses (user@anydomain.com), addresses at any domain (user), or entire domains (@anydomain.com).  Wildcards are supported (fribo*@domain.com). (|).<br />For example: fribo@anydomain.com|jhanna|@sillyguys.org or place them in a plain ASCII file one address per line:file:files/nodelayuser.txt.',undef,undef,'msg008610','msg008611'],
['localnoDelayAddresses','Do not Delay local Addresses*',0,\&checkbox,'','(.*)',undef,'Skip delaying if the recipient matches \'noDelayAddresses\' (incoming mail only).',undef,undef,'msg009760','msg009761'],
['DelayError','Reply Code to Refuse Delayed Messages',80,\&textinput,'451 4.7.1 Please try again later','(45\d .*)',undef,
  'SMTP reply code to refuse delayed messages. Default: 451 4.7.1 Please try again later
  <br /><hr />
  <div class="menuLevel1">Notes On Delaying</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/delaying.txt\',3);" />',undef,undef,'msg003450','msg003451'],

[0,0,0,'heading','SPF/DMARC/SRS <a href="http://apps.sourceforge.net/mediawiki/assp/index.php?title=SPF" target=wiki><img height=12 width=12 src="' . $wikiinfo . '" alt="SPF" /></a>'],
['ValidateSPF','Enable SPF Validation','0:disabled|1:block|2:monitor|3:score',\&listbox,3,'(.*)',undef,
  'Enable Sender Policy Framework Validation as described at <a href="http://www.openspf.org/" rel="external">openspf</a> and Domain-based Message Authentication, Reporting &amp; Conformance - described in <a href="http://www.dmarc.org/" rel="external">DMARC</a> (DMARC requires also DoDKIM to be enabled).<br />
  This requires an installed <a href="http://www.openspf.org/Implementations" rel="external">Mail::SPF</a> module in PERL. Testmode is set with spfTestMode, scoring is set with spfValencePB. If you need more information about the syntax of SPF records, visit <a href="http://www.openspf.org/SPF_Record_Syntax" rel="external">SPF_Record_Syntax</a>.',undef,undef,'msg003460','msg003461'],
['SPF2','Do SPF Version 2 Validation',0,\&checkbox,'1','(.*)',undef,
  'Enable Sender Policy Framework Validation Version 2.<br />
  This requires an installed <a href="http://search.cpan.org/dist/Mail-SPF/" rel="external">Mail::SPF</a> object-oriented Perl module that supersedes the old Mail::SPF::Query module. ',undef,undef,'msg003470','msg003471'],
['SPFWL','Whitelisted SPF Validation',0,\&checkbox,'','(.*)',undef,
  'Enable Sender Policy Framework Validation for whitelisted users also.',undef,undef,'msg003480','msg003481'],
['SPFNP','noProcessing SPF Validation',0,\&checkbox,'','(.*)',undef,
  'Enable Sender Policy Framework Validation for nonprocessed messages also.',undef,undef,'msg009560','msg009561'],
['SPFLocal','Local and outgoing mail SPF Validation',0,\&checkbox,'','(.*)',undef,
  'Enable Sender Policy Framework Validation for local and outgoing messages also. Don\'t forget to configure your DNS-server for SPF and/or to configure SPFoverride / SPFfallback / SPFlocalRecord, if you enable this option.',undef,undef,'msg003490','msg003491'],
['enableSPFbackground','Enable SPF Background Check',0,\&checkbox,'1','(.*)',undef,
 'SPF background checks are initiated by some features (for example DoDomainIP) to fillup the SPFCache. The collected results are later used to prevent blocking good mails.',undef,undef,'msg003500','msg003501'],
['AddSPFHeader','Add Received-SPF Header',0,\&checkbox,1,'(.*)',undef,
  'Add Received-SPF header to header of all mails processed by SPF.',undef,undef,'msg003510','msg003511'],
['SPFError','SPF Failed Reply',80,\&textinput,'554 5.7.1 failed SPF: SPFRESULT','([245]\d\d .*)',undef,
  'SMTP reply for SPF failed messages. Default: \'554 5.7.1 failed SPF: SPFRESULT\'<br />
  The literal SPFRESULT (case sensitive) is replaced by the actual result.',undef,undef,'msg003520','msg003521'],
['noSPFRe','Skip SPF Processing*',80,\&textinput,'','(.*)','ConfigCompileRe',
 'Put anything here to identify these messages in mailfrom or header',undef,undef,'msg003530','msg003531'],
['SPFoverride','Override Domains*',80,\&textinput,'','(.*)','configUpdateSPFOF',
 'Set override to define SPF records for domains that do publish but which you want to override anyway. If you specify only domains the Local SPF Record ( SPFlocalRecord ) below will be used as default. Wildcards are supported. For example: abc.com=>v=spf1 a/24 mx/24 ptr -all|cello.ch=>v=spf1 ip4:213.46.243.0/26  ~all|abc.com|*.def.com . <br />
 To generate a SPF record for a domain:<br />
 - go to <a href="http://www.senderbase.org/" target="_blank">http://www.senderbase.org</a><br />
 - lookup the domain information in "Look up your network"<br />
 - right beside "Addresses in domain used to send email" click on export, and export the list in to plain text<br />
 - copy and past the list in to an editor and generate a comma separated IP list<br />
 - go to an online SPF record generator - for example: <a href="http://www.royhochstenbach.com/projects/spfgenerator/" target="_blank">http://www.royhochstenbach.com/projects/spfgenerator</a> and generate the SPF record<br />
 - put "domain=>SPF-record" in any of SPFoverride or SPFfallback<br />
 - define the policy as strict as possible',undef,undef,'msg003540','msg003541'],
['SPFfallback','Fallback Domains*',80,\&textinput,'','(.*)','configUpdateSPFOF',
 'Set fallback to define "pretend" SPF records for domains that don\'t publish them yet. If you specify only domains the Local SPF Record ( SPFlocalRecord ) below will be used as default. Wildcards are supported. For example: abc.com=>v=spf1 a/24 mx/24 ptr -all|cello.ch=>v=spf1 ip4:213.46.243.0/26  ~all|abc.com|*.def.com',undef,undef,'msg003550','msg003551'],
['LocalPolicySPF','Local SPF Policy',80,\&textinput,'v=spf1 a/24 mx/24 ptr ~all','(.*)','configUpdateSPFLR','If the sending domain does not publish its own SPF Records this will be used.<br />The default is v=spf1 a/24 mx/24 ptr ~all<br />
 <span class="negative">This option applies to Mail::SPF::Query module only.</span>',undef,undef,'msg003560','msg003561'],
['SPFlocalRecord','Fallback/Override SPF Record',80,\&textinput,'v=spf1 a/24 mx/24 ptr -all','(.*)','configUpdateSPFLR','Used in Fallback/Override Domains<br />The default is v=spf1 a/24 mx/24 ptr -all',undef,undef,'msg003570','msg003571'],
['strictSPFRe','Strict SPF Processing Regex*',80,\&textinput,'file:files/strictspf.txt','(.*)','ConfigCompileRe',
 'Softfail/Neutral will be failed for these sending addresses. Put anything here to identify the addresses',undef,undef,'msg003580','msg003581'],
['blockstrictSPFRe','Block SPF Processing Regex*',80,\&textinput,'@ebay.com|@paypal.com','(.*)','ConfigCompileRe',
 'All failed messages will be blocked for these sending addresses. Put anything here to identify the addresses.',undef,undef,'msg003590','msg003591'],
['DoSPFinHeader','Additional SPF Check on the Header from',0,\&checkbox,'','(.*)',undef,
  'Do an additional SPF check on the header from: address if it is in blockstrictSPFRe *** this check breakes RFC rules ***.',undef,undef,'msg009820','msg009821'],
['SPFsoftfail','Fail SPF Softfail Validations',0,\&checkbox,'','(.*)',undef,
  'Intentionally fail SPF softfail status responses. The possible results of a query are:
<br />pass:The client IP address is an authorized mailer for the sender. The mail should be accepted subject to local policy regarding the sender.
<br />fail:The client IP address is not an authorized mailer, and the sender wants you to reject the transaction for fear of forgery.
<br />softfail:The client IP address is not an authorized mailer, but the sender prefers that you accept the transaction because it isn\'t absolutely sure all its users are mailing through approved servers. The softfail status is often used during initial deployment of SPF records by a domain.
<br />neutral:The sender makes no assertion about the status of the client IP.
<br />none:There is no SPF record for this domain.
<br />permerror &amp; temperror:The DNS lookup encountered an error during processing.
<br />unknown:The domain has a configuration error in the published data or defines a mechanism that this library does not understand.',undef,undef,'msg003600','msg003601'],
['SPFneutral','Fail SPF Neutral Validations',0,\&checkbox,'','(.*)',undef,
  'Intentionally fail SPF neutral status responses',undef,undef,'msg003610','msg003611'],
['SPFqueryerror','Fail SPF Error Responses',0,\&checkbox,'','(.*)',undef,
  'Intentionally fail SPF \'error\' status responses',undef,undef,'msg003620','msg003621'],
['SPFnone','Fail SPF None and Unknown Responses',0,\&checkbox,'','(.*)',undef,
  'Intentionally fail SPF \'none\' and \'unknown\' status responses',undef,undef,'msg003630','msg003631'],
['SPFunknown','Fail SPF Unknown  Responses',0,\&checkbox,'','(.*)',undef,
  'Intentionally fail SPF \'unknown\'  status responses',undef,undef,'msg003640','msg003641'],
['SPFCacheInterval','SPF Cache Refresh Interval',4,\&textinput,7,'(\d+\.?\d*|)','configUpdateSPFCR',
  'SPF records in cache will be removed after this interval in days. 0 will disable the cache.<input type="button" value=" Show SPF Cache" onclick="javascript:popFileEditor(\'pb/pbdb.spf.db\',6);" />',undef,undef,'msg003650','msg003651'],
['DebugSPF','Enable SPF Debug output to ASSP Logfile',0,\&checkbox,'','(.*)',undef,
 'Enables verbose debugging of SPF queries within the Mail::SPF module.
 <br /><hr />
 <div class="menuLevel1">Notes On SPF</div>
 <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/spf.txt\',3);" /> ',undef,undef,'msg003660','msg003661'],
['DMARCReportFrom','From Address for DMARC Reports',40,\&textinput,'','('.$EmailAdrRe.'(?:\@'.$EmailDomainRe.')?|)',undef,
  'The email address to be used as FROM: address to send <a href="http://www.dmarc.org/" rel="external">DMARC</a> reports. If blank, no DMARC reports will be sent! If only the user name is defined, assp will add the domain name that belongs to the report.',undef,undef,'msg009730','msg009731'],
['EnableSRS','Enable Sender Rewriting Scheme',0,\&checkbox,'','(.*)','updateSRS',
  'Enable Sender Rewriting Scheme as described at <a href="http://www.openspf.org/SRS" rel="external">www.openspf.org/SRS</a>.<br />
  This requires an installed <a href="http://www.openspf.org/Implementations" rel="external">Mail::SRS</a> module in PERL.<br />
  You should use SRS if your message handling system forwards email for domains with published spf records and there SPF record not includes your MX.<br />
  NOTICE: In case your local users are forwarding mails (e.g. from external domains) to external domains (external mail accounts) and these foreign domains bounces back (e.g. out_of_office / vacation), your MTA (smtpDestination) will possibly get mails from external domains to be deliverd to external domains!<br />
  Note that you have to setup the outgoing path (Relay Host and Port) to let ASSP see and rewrite your outgoing traffic.<br /> Testmode is set with srsTestMode.',undef,undef,'msg003670','msg003671'],
['SRSAliasDomain','Alias Domain',40,\&textinput,'thisdomain.com','(.*)','updateSRSAD',
  'SPF requires the SMTP client IP to match the envelope sender (return-path). When a message is forwarded through<br />
  an intermediate server, that intermediate server may need to rewrite the return-path to remain SPF compliant.<br />
  For example: thisdomain.com',undef,undef,'msg003680','msg003681'],
['SRSSecretKey','Secret Key',20,\&textinput,'','(.*)','updateSRSSK',
  'A key for the cryptographic algorithms -- Must be at least 5 characters long.',undef,undef,'msg003690','msg003691'],
['SRSTimestampMaxAge','Maximum Timestamp Age',5,\&textinput,2,'(\d+)',undef,
  'Enter the maximum number of days for which a timestamp is considered valid. Default is 2 days. After this number of days a SRS bounce is no longer valid!',undef,undef,'msg003700','msg003701'],
['SRSHashLength','Hash Length',5,\&textinput,6,'(\d+)',undef,
  'The number of bytes of base64 encoded data to use for the cryptographic hash.<br />
  More is better, but makes for longer addresses which might exceed the 64 character length suggested by RFC2821.<br />
  This defaults to 6, which gives 6 x 6 = 36 bits of cryptographic information, which means that a spammer will have <br />
  to make 2^36 attempts to guarantee forging an SRS address.',undef,undef,'msg003710','msg003711'],
['SRSValidateBounce','Enable Bounce Recipient Validation','0:disabled|1:block|2:monitor|3:score',\&listbox,0,'(.*)',undef,
  'Bounce messages that fail reverse SRS validation (but not a valid SMTP probe)<br />
  will receive a 554 5.7.5 [Bounce address not SRS signed] SMTP error code.<br /> Testmode is set with srsTestMode, scoring is set with srsValencePB.',undef,undef,'msg003720','msg003721'],
['SRSno','Don\'t Rewrite These Addresses*',60,\&textinput,'','(.*)','ConfigMakeSLRe',
  'Don\'t rewrite addresses when messages come from these addresses. Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com). <br />For example: fribo@thisdomain.com|jhanna|@sillyguys.org',undef,undef,'msg003730','msg003731'],
['noSRS','Don\'t Validate Bounces From these IPs*',80,\&textinput,'','(\S*)','ConfigMakeIPRe',
  'Enter IP addresses that you don\'t want to validate bounces from, separated by pipes (|).
  For example:  127.0.0.1|172.16..<br /><hr />
  <div class="menuLevel1">Notes On SRS</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/srs.txt\',3);" />',undef,'7','msg003740','msg003741'],

[0,0,0,'heading','DNSBL <a href="http://apps.sourceforge.net/mediawiki/assp/index.php?title=DNSBL" target=wiki><img height=12 width=12 src="' . $wikiinfo . '" alt="DNSBL" /></a>'],
['ValidateRBL','Enable DNS Blacklist Validation ','0:disabled|1:block|2:monitor|3:score',\&listbox,1,'(.*)','configUpdateRBL',
  'This requires an installed <a href="http://search.cpan.org/search?query=Net::DNS" rel="external">Net::DNS</a> module in PERL.',undef,undef,'msg003750','msg003751'],
['ForceRBLCache','Early DNSBL Cache Blocking',0,\&checkbox,'','(.*)',undef,
  'If set, ASSP will use cached DNSBL hits to block messages before other tests. <b>testmode</b> will override this. <b>spamlover settings</b> will be ignored.',undef,undef,'msg003760','msg003761'],
['noRBL','Don\'t do DNSBL for these IPs*',80,\&textinput,'','(\S*)','ConfigMakeIPRe',
 'Enter IP addresses that you don\'t want to be DNSBL validated, separated by pipes (|). For example:  127.0.0.1|172.16..',undef,'7','msg003770','msg003771'],
['RBLWL','Whitelisted DNSBL Validation',0,\&checkbox,0,'(.*)',undef,
  'Enable DNSBL for whitelisted users also',undef,undef,'msg003780','msg003781'],
['AddRBLHeader','Add X-Assp-DNSBL Header',0,\&checkbox,1,'(.*)',undef,
  'Add X-Assp-DNSBL header to messages with positive reply from DNSBL.',undef,undef,'msg003790','msg003791'],
['RBLError','DNSBL Failed Reply',80,\&textinput,'554 5.7.1 DNS Blacklisted by RBLLISTED','(.*)',undef,
  'SMTP reply for DNSBL failed messages. Default: \'554 5.7.1 DNS Blacklisted by RBLLISTED\'<br />
  The literal RBLLISTED (case sensitive) is replaced by the actual serviceproviders(s).',undef,undef,'msg003800','msg003801'],
['RBLServiceProvider','RBL Service Providers*',80,\&textinput,'file:files/dnsbls.txt','(\S*)','configUpdateRBLSP',
 'Names of DNSBLs to use separated by "|". You may set for every provider a weight like zen.spamhaus.org=>50|bl.spamcop.net=>25.<br />
 Defaults are:<br />
 zen.spamhaus.org=>1|bl.spamcop.net=>1|psbl.surriel.com=>2|ix.dnsbl.manitu.net=>2|<br />
 l2.apews.org=>3|combined.njabl.org=>1|safe.dnsbl.sorbs.net=>1|dnsbl-1.uceprotect.net=>2|<br />
 dnsbl-2.uceprotect.net=>2|dnsbl-3.uceprotect.net=>2|blackholes.five-ten-sg.com=>3".<br />
 DNSBL providers can get a "weight" like bl.spamcop.net=>1.<br />
 The value of the weight can be set directly like=>45 or as a divisor of RBLmaxweight. Low numbers < 6 are divisors . So if RBLmaxweight = 50 (default) bl.spamcop.net=>50  would be the same as bl.spamcop.net=>1, bl.spamcop.net=>2 would be the same as bl.spamcop.net=>25.<br />
 If the sum of weights surpasses RBLmaxweight, the DNSBL check fails.  If not, the DNSBL check is scored as "neutral" even with RBLmaxhits reached. Setting Showmaxreplies will allow ALL replies to contribute to the total weight regardless of RBLmaxhits.<br />
 Some RBL Service Providers, like blackholes.five-ten-sg.com, provides different return codes in a single DNS-zone: like 127.a.b.c - where a,b,c are used to identify a weight or type (or what ever) of the returned entry. If you want to care about special return codes, or if you want to use different weights for different return codes, you should use the following enhanced entry syntax:<br /><br />
 RBL-Service-Provider=>result-to-watch=>weight (like:)<br />
 blackholes.five-ten-sg.com=>127.0.0.2=>3<br />
 blackholes.five-ten-sg.com=>127.0.0.5=>4<br />
 blackholes.five-ten-sg.com=>127.0.?.*=>5<br /><br />
 You can see, the wildcards * (multiple character) and ? (single character) are possible to use in the second parameter. Never mix the three possible syntax types for the same RBL Service Provider. An search for a match inside such a definition is done in reverse ASCII order, so the wildcards are used as last.<br />
 Some RBL Service Providers, provides different return codes using a bitmask in any part of the reply. To define weights for bitmasks, place a single \'M\' in front of the mask number, like<br /><br />
 sp.com=>127.0.0.M2=>25<br />
 sp.com=>127.0.0.M4=>41<br />
 sp.com=>127.0.M1.5=>56<br />
 sp.com=>127.0.M64.*=>11<br />
 sp.com=>127.0.0.2=>22<br />
 sp.com=>127.0.*.*=>1<br /><br />
 Valid bitmasks are 1,2,4,8,16,32,64 and 128. The resulting weight will be the weight sum of all matching bitmasks (if no full qualified definition is found). For example: a return code of 127.0.0.6 for sp.com will result in a weight of 66 (25+41), a reply of 127.0.0.2 will result in 22<br />
 Because each single bitmask indicates a set of 128 numbers you should prevent the usage of something like 127.0.M16.M1 - this will lead in to a set of (128*128) 16384 addresses, which is really too much!<br />
 For the same service provider, first define all bitmask definitions, after that all full qualified definitions and than all definitions with wildcards, like in the example above! If your definition order is wrong, the resulting weights will be unexpected!
  ',undef,undef,'msg003810','msg003811'],
['RBLmaxreplies','Maximum Replies',3,\&textinput,7,'(\d*)','configUpdateRBLMR','A reply is affirmative or negative reply from a DNSBL.<br />
  The DNSBL module will wait for this number of replies (negative or positive) from the DNSBLs listed under Service Provider for up to the Maximum Time( RBLmaxtime ).<br />
  This number should be equal to or less than the number of DNSBL Service Providers listed to allow for randomly unavailable DNSBLs.',undef,undef,'msg003820','msg003821'],
['RBLmaxhits','Maximum Hits',3,\&textinput,2,'(\d*)','configUpdateRBLMH','A hit is an affirmative response from a DNSBL.<br />
  The DNSBL module will check all of the DNSBLs listed under Service Provider. If the number of hits is greater or equal Maximum Hits, the email is flagged <b>Failed</b>.<br /> If the number of hits is greater 0 and less Maximum Hits, the email is flagged <b>Neutral</b>',undef,undef,'msg003830','msg003831'],
['RBLmaxweight','RBL Maximum Weight',3,\&textinput,50,'(\d*)',undef,'A weight is a number representing the trust we put into a DNSBL.<br />
  The DNSBL module will check all of the DNSBLs listed under Service Provider. If the total of weights is greater or equal Maximum Weight, the email is flagged <b>Failed</b>.<br /> If the total of weights is greater 0 and less Maximum Weight, the email is flagged <b>Neutral</b>',undef,undef,'msg003840','msg003841'],
['RBLmaxtime','Maximum Time',5,\&textinput,15,'(\d*)',undef,'This sets the maximum time in seconds to spend on each message performing DNSBL checks. Default is 15.',undef,undef,'msg003850','msg003851'],
['RBLsocktime','Socket Timeout',5,\&textinput,1,'(\d*)',undef,'This sets the DNSBL socket read timeout in seconds.',undef,undef,'msg003860','msg003861'],
['RBLCacheExp','DNSBL Expiration Time',4,\&textinput,24,'(\d+\.?\d*|)','configUpdateRBLCR',
  'IP\'s in cache will be removed after this interval in hours. 0 will disable the cache. <input type="button" value=" Show DNSBL Cache" onclick="javascript:popFileEditor(\'pb/pbdb.rbl.db\',5);" />
  <hr /><div class="menuLevel1">Notes On DNSBL</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/rbl.txt\',3);" />',undef,undef,'msg003870','msg003871'],

[0,0,0,'heading','URIBL'],
 ['ValidateURIBL','Enable URI Blocklist Validation <a href="http://www.uribl.com/about.shtml" target="ASSPHELP"><img src="' . $wikiinfo . '" alt="about" /></a>','0:disabled|1:block|2:monitor|3:score',\&listbox,'1','(.*)','configUpdateURIBL',
  'Enable URI Blocklist. Messages that fail URIBL validation will receive URIBLError SMTP error code. This requires an installed <a href="http://search.cpan.org/search?query=Net::DNS" rel="external">Net::DNS</a> module and an installed <a href="http://search.cpan.org/search?query=Email::MIME" rel="external">Email::MIME</a> module in PERL. <a href="http://apps.sourceforge.net/mediawiki/assp/FAQ#Common_Problems" target="ASSPHELP"><img src="' . $wikiinfo . '" alt="wiki" /></a><br />
  <span class="negative"> 0 = disabled, 1 = block, 2 = monitor, 3 =  messagescore .</span>',undef,undef,'msg003880','msg003881'],
 ['URIBLWL','Do URI Blocklist Validation for Whitelisted',0,\&checkbox,'','(.*)',undef,'URIBL check is done ignoring all spamlovers and testmodes!',undef,undef,'msg003890','msg003891'],
 ['URIBLNP','Do URI Blocklist Validation for NoProcessing',0,\&checkbox,'','(.*)',undef,'URIBL check is done ignoring all spamlovers and testmodes!',undef,undef,'msg003900','msg003901'],
 ['URIBLLocal','Do URI Blocklist Validation for Local Mails',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg003910','msg003911'],
 ['URIBLISP','Do URI Blocklist Validation for ISP/Secondary',0,\&checkbox,1,'(.*)',undef,'',undef,undef,'msg003920','msg003921'],
 ['URIBLServiceProvider','URIBL Service Providers*',60,\&textinput,'file:files/uribls.txt','(.*)','configUpdateURIBLSP',
 'Domain Names of URIBLs to use separated by "|". You may set for every provider a weight like multi.surbl.org=>50|black.uribl.com=>25.<br />
 The value of the weight can be set directly like=>45 or as a divisor of URIBLmaxweight . Low numbers < 6 are divisors . So if URIBLmaxweight = 50 (default) multi.surbl.org=>50  would be the same as multi.surbl.org=>1, multi.surbl.org=>2 would be the same as multi.surbl.org=>25.<br />
 If the sum of weights surpasses URIBLmaxweight, the URIBL check fails.  If not, the URIBL check is scored as "neutral"  even with URIBLmaxhits reached. Setting Showmaxreplies will allow ALL replies to contribute to the total weight regardless of URIBLmaxhits.<br />
 Some URIBL Service Providers, like multi.surbl.org and black.uribl.com , provides different return codes in a single DNS-zone: like 127.a.b.c - where a,b,c are used to identify a weight or type (or what ever) of the returned entry. If you want to care about special return codes, or if you want to use different weights for different return codes, you should use the following enhanced entry syntax:<br /><br />
 URIBL-Service-Provider=>result-to-watch=>weight (like:)<br />
 multi.surbl.org=>127.0.0.2=>2<br />
 multi.surbl.org=>127.0.0.4=>3<br />
 multi.surbl.org=>127.0.0.?=>4<br />
 multi.surbl.org=>127.0.0.*=>5<br /><br />
 You can see, the wildcards * (multiple character) and ? (single character) are possible to use in the second parameter. Never mix the three possible syntax types for the same URIBL Service Provider. An search for a match inside such a definition is done in reverse ASCII order, so the wildcards are used as last.<br />
 Some URIBL Service Providers, provides different return codes using a bitmask in any part of the reply. To define weights for bitmasks, place a single \'M\' in front of the mask number, like<br /><br />
 sp.com=>127.0.0.M2=>25<br />
 sp.com=>127.0.0.M4=>41<br />
 sp.com=>127.0.M1.5=>56<br />
 sp.com=>127.0.M64.*=>11<br />
 sp.com=>127.0.0.2=>22<br />
 sp.com=>127.0.*.*=>1<br /><br />
 Valid bitmasks are 1,2,4,8,16,32,64 and 128. The resulting weight will be the weight sum of all matching bitmasks (if no full qualified definition is found). For example: a return code of 127.0.0.6 for sp.com will result in a weight of 66 (25+41), a reply of 127.0.0.2 will result in 22<br />
 Because each single bitmask indicates a set of 128 numbers you should prevent the usage of something like 127.0.M16.M1 - this will lead in to a set of (128*128) 16384 addresses, which is really too much!<br />
 For the same service provider, first define all bitmask definitions, after that all full qualified definitions and than all definitions with wildcards, like in the example above! If your definition order is wrong, the resulting weights will be unexpected!
 Default is: multi.surbl.org|black.uribl.com',undef,undef,'msg003930','msg003931'],
 ['URIBLCCTLDS','URIBL Country Code TLDs*',60,\&textnoinput,'file:files/URIBLCCTLDS.txt','(.*)','ConfigMakeRe',
  'List of <a href="http://www.surbl.org/tld/two-level-tlds" rel="external">two level country code TLDs</a> and <a href="http://www.surbl.org/tld/three-level-tlds" rel="external">three level country code TLDs</a> used to determine the base domain of the uri. Two level TLDs will be checked on third level, third level TLDs will be checked on fourth level. Any not listed domain will be checked in level two.',undef,undef,'msg003940','msg003941'],
 ['URIBLmaxuris','Maximum URIs',5,\&textinput,0,'(\d*)',undef,
  'More than this number of URIs in the body will increase spam probability. Enter 0 to disable feature.',undef,undef,'msg003950','msg003951'],
 ['URIBLmaxdomains','Maximum Unique Domain URIs',5,\&textinput,0,'(\d*)',undef,
  'More than this number of unique domain URIs in the body will increase spam probability. Enter 0 to disable feature.',undef,undef,'msg003960','msg003961'],
 ['URIBLNoObfuscated','Disallow Obfuscated URIs <a href="http://www.pc-help.org/obscure.htm" target="ASSPHELP"><img src="' . $wikiinfo . '" alt="obscure" /></a>',0,\&checkbox,'1','(.*)',undef,
  'When enabled, messages with obfuscated URIs of types [integer/octal/hex IP, other things!] in the body will get increased spam probability and if weights are used, the double weight will be used.',undef,undef,'msg003970','msg003971'],
 ['URIBLcheckDOTinURI','Check for \'DOT\' in URI',0,\&checkbox,'','(.*)',undef,
  'When enabled, assp will also check for the used word \'DOT\' instead of a \'.\' in URI\'s like \'example<b>dot</b>com or example<b>!d o-t_</b>com\' .<br />
   Enable this feature only, if you don\'t expect any problems in your national language (using \'dot\' + a toplevel domain in any words).',undef,undef,'msg008820','msg008821'],
 ['URIBLmaxreplies','Maximum Replies',5,\&textinput,2,'(\d*)','configUpdateURIBLMR',
  'A reply is affirmative or negative reply from a URIBL.<br />
   The URIBL module will wait for this number of replies (negative or positive) from the URIBLs listed under Service Provider<br />
   for up to the Maximum Time below. This number should be equal to or less than the number of URIBL Service Providers<br />
   listed to allow for randomly unavailable URIBLs.',undef,undef,'msg003980','msg003981'],
 ['URIBLmaxhits','Maximum Hits',5,\&textinput,1,'(\d*)','configUpdateURIBLMH',
  'A hit is an affirmative response from a URIBL.<br />
   The URIBL module will check all of the URIBLs listed under Service Provider,<br />
   and flag the email with a URIBL failure flag if more than this number of URIBLs return a postive blacklisted response.<br />
   This number should be less than or equal to Maximum Replies above and greater than 0.
   If the number of hits is greater or equal Maximum Hits, the email is flagged <b>failed</b> in every case!
   If the number of hits is greater 0 and less Maximum Hits, the email is flagged <b>neutral</b>.<br />
   This behavior could be changed to your needs by using weighted values for the URIBLServiceProvider .',undef,undef,'msg003990','msg003991'],
 ['URIBLmaxweight','URIBL Maximum Weight',3,\&textinput,50,'(\d*)',undef,'A weight is a number representing the trust we put into a URIBL.<br />
  The URIBL module will check all of the URIBLs listed under URIBLServiceProvider for every URI found in an email. If the total of weights for an URI is greater or equal this Maximum Weight, the email is flagged <b>Failed</b>.<br /> If the total of weights is greater 0 and less Maximum Weight, the email is flagged <b>Neutral</b> . If not defined or set to zero only the hit count will used to detect a fail or neutral state.',undef,undef,'msg009150','msg009151'],
 ['URIBLmaxtime','Maximum Time',5,\&textinput,10,'(\d*)',undef,
  'This sets the maximum time in seconds to spend on each message performing URIBL checks.',undef,undef,'msg004000','msg004001'],
 ['URIBLsocktime','Socket Timeout',5,\&textinput,1,'(\d*)',undef,'This sets the URIBL socket read timeout in seconds.',undef,undef,'msg004010','msg004011'],
 ['URIBLwhitelist','Whitelisted URIBL Domains*',60,\&textinput,'doubleclick.net','(.*)','ConfigMakeRe',
  'This prevents specific domains from being checked by URIBL module. For example: doubleclick.net or file:files/URIBLwhitelist.txt. Domains already listed in noProcessingDomains and whiteListedDomains will be honored.',undef,undef,'msg004020','msg004021'],
 ['noURIBL','Don\'t Check Messages from these Addresses*',60,\&textinput,'','(.*)','ConfigMakeSLRe',
  'Don\'t validate URIBL when messages come from these addresses. Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com). <br />For example: fribo@thisdomain.com|jhanna|@sillyguys.org',undef,undef,'msg004030','msg004031'],
 ['URIBLIPRe','Bad URI IP\'s*',80,\&textinput,'','(\S*)','ConfigMakeIPRe',
  'Every IP in an URI and every IP resolved for a hostname in an URI is checked against this list of IP\'s or networks. For example:145.145.145.145|145.146.|1.2.0.0/16<br />
  This high security feature will follow the rules in URIBLWL, URIBLNP, URIBLLocal and URIBLISP - but if a match is found, it will block the email ( ignores scoring, monitoring, testmodes and spamlover ).',undef,undef,'msg009600','msg009601'],
 ['AddURIBLHeader','Add X-Assp-Received-URIBL Header',0,\&checkbox,1,'(.*)',undef,
  'Add X-Assp-Received-URIBL header to messages with positive reply from URIBL.',undef,undef,'msg004040','msg004041'],
 ['AddURIS2MyHeader','Add X-Assp-Detected-URI Header',0,\&checkbox,'','(.*)',undef,
  'URI\'s detected with URIBLOK are added to our header lines (X-Assp-Detected-URI:).',undef,undef,'msg009750','msg009751'],
 ['URIBLCacheInterval','URIBL Cache Refresh Interval for Hits',3,\&textinput,1,'(\d+\.?\d*|)','configUpdateURIBLCR',
  'Domains in cache will be removed after this interval in days. Empty or 0 will disable the cache. <input type="button" value=" Show URIBL Cache" onclick="javascript:popFileEditor(\'pb/pbdb.uribl.db\',5);" />',undef,undef,'msg004050','msg004051'],
 ['URIBLCacheIntervalMiss','URIBL Cache Refresh Interval for Misses',3,\&textinput,0.5,'(\d+\.?\d*|)','configUpdateURIBLCR',
  'Domains in cache with status=2 (miss) will be removed after this interval in days. Empty or 0 will prevent caching of non-hits. ',undef,undef,'msg004060','msg004061'],
 ['URIBLError','Reply Code to Refuse Failed URIBL Message',80,\&textinput,'554 5.7.1 Blacklisted by URIBLNAME Contact the postmaster of this domain for resolution. This attempt has been logged.','([245]5\d .*|)',undef,
  'SMTP reply code to refuse failed URIBL message. The literal URIBLNAME (case sensitive) is replaced by the names of URIBLs with negative response. If this field is empty, client connection is simply dropped.<br /><hr /><div class="menuLevel1">Notes On URIBL</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/uribl.txt\',3);" />',undef,undef,'msg004070','msg004071'],

[0,0,0,'heading','Attachment Blocking'],
['DoBlockExes','External Attachment Blocking ','0:disabled|1:block|2:monitor|3:score',\&listbox,0,'([\s0123]?)',undef,'This requires an installed <a href="http://search.cpan.org/search?query=Email::MIME" rel="external">Email::MIME</a> module in PERL.',undef,undef,'msg004080','msg004081'],
['BlockExes','External Attachment Blocking Level','0:Level 0|1:Level 1|2:Level 2|3:Level 3|4:Level 4',\&listbox,0,'([\s01234]?)',undef,
  'Set the level of Attachment Blocking to 1-3 for attachments that should be blocked, set level to 4  for attachments that should be allowed. Choose 0 for no attachment blocking.',undef,undef,'msg004090','msg004091'],
['BlockWLExes','Whitelisted &amp; Local Attachment Blocking','0:Level 0|1:Level 1|2:Level 2|3:Level 3|4:Level 4',\&listbox,0,'([\s01234]?)',undef,
  'Set the level of Attachment Blocking to 0-4 for whitelisted &amp; local senders. Choose 0 for no attachment blocking.',undef,undef,'msg004100','msg004101'],
['BlockNPExes','NoProcessing Attachment Blocking','0:Level 0|1:Level 1|2:Level 2|3:Level 3|4:Level 4',\&listbox,0,'([\s01234]?)',undef,
  'Set the level of Attachment Blocking to 0-4 for no processing senders. Choose 0 for no attachment blocking. ',undef,undef,'msg004110','msg004111'],
['BadAttachL1','Level 1 rejected File Extensions',80,\&textinput,'exe\-bin|exe|scr|pif|vb[es]?|jse?|ws[cfh]?|sh[sb]?|li?nk|bat|cmd|com|ht[ab]|ps1?','(.*)','updateBadAttachL1',
  'This regular expression is used to identify Level 1 attachments that should be blocked.<br />
  Separate entries with a pipe |. The dot . is assumed to precede these, so don\'t include it.<br />
  For example:<br />
  ad[ep]|asx|ba[st]|chm|cmd|com|cpl|crt|dbx|exe|exe\-bin|hlp|ht[ab]|in[fs]|isp|js|jse|lnk|md[abez]|mht|ms[cipt]|nch|pcd|pif|prf|ps1?|reg|sc[frt]|sh[bs]|vb|vb[es]|wms|ws[cfh]<br />
  If you\'ve installed the ASSP_AFC Plugin (at least version 2.10) and \'exe-bin\' is defined (on any level), the Plugin will detect executable files based on there binary content. Detected will be all executables, libraries and scripts for DOS and Windows (except .com files), MAC-OS and linux ELF (for all processor architectures).',undef,undef,'msg004120','msg004121'],
['BadAttachL2','Level 2 rejected File Extensions',80,\&textinput,'','(.*)','updateBadAttachL2',
  'This regular expression is used to identify Level 2 attachments that should be blocked.<br />
  Level 2 already includes all rejected extensions from Level 1. <br /> For example:<br /> (ad[ep]|asx|ba[st]|chm|cmd|com|cpl|crt|dbx|exe|hlp|ht[ab]|in[fs]|isp|js|jse|lnk|md[abez]|mht|ms[cipt]|nch|pcd|pif|prf|reg|sc[frt]|sh[bs]|vb|vb[es]|wms|ws[cfh]).zip',undef,undef,'msg004130','msg004131'],
['BadAttachL3','Level 3 rejected File Extensions',80,\&textinput,'','(.*)','updateBadAttachL3',
  'This regular expression is used to identify Level 3 attachments that should be blocked.<br />
  Level 3 includes Level 2 and Level 1.<br /> For example:<br /> zip|url',undef,undef,'msg004140','msg004141'],
['GoodAttach','Level 4 Allowed File Extensions',80,\&textinput,'','(.*)','updateGoodAttach',
  'This regular expression is used to identify attachments that should be allowed. All others are blocked. Separate entries with a pipe |. The dot . is assumed to precede these, so don\'t include it.<br /> For example:<br /> ai|asc|bhx|dat|docx?|eps|gif|htm|html|ics|jpg|jpeg|hqx|od[tsp]|pdf|ppt|rar|rpt|rtf|snp|txt|xls|zip|7z',undef,undef,'msg004150','msg004151'],

['UserAttach','User based Good and Bad Attachments*',40,\&textinput,'','(file:.+|)','updateUserAttach','This set of regular expression is used to identify attachments that should be allowed or blocked for specified users and/or domains. Separate entries with a any of \'=&gt; , ; space\'. Separate multiple regex entries with pipe \'|\'. The dot . is assumed to precede the regex, so don\'t include it anywhere (except the user name).<br />
  To define entries you have to use the \'file:...\' option. Define one entry per line - comments are not allowed in a definition line.<br />
  The syntax of an entry is as follows:<br />
  username => good => goodAttachRegex , good-out => goodoutRegex , good-in => goodinRegex , block => blockAttachRegex , block-out => blockoutRegex , block-in => blockinRegex<br />
  username - Mail solely to or from any of these addresses. Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com) or a Group definition [GROUP]. Wildcards are supported (fribo*@domain.com).<br /><br />
  good => goodAttachRegex - good attachment for incoming and outgoing mails<br />
  good-out => goodoutRegex - good attachment for outgoing mails<br />
  good-in => goodinRegex - good attachment for incoming mails<br />
  block => blockAttachRegex - bad attachment for incoming and outgoing mails<br />
  block-out => blockoutRegex - bad attachment for outgoing mails<br />
  block-in => blockinRegex - bad attachment for incoming mails<br /><br />
  For example:<br />
  user@domain.tld => good => ai|asc|bhx|dat|doc|eps|gif|htm|html|ics|jpg|jpeg|hqx|od[tsp]|pdf|ppt|rar|rpt|rtf|snp|txt|xls|zip<br />
  *@domain.tld => good => ai|asc|bhx , good-out => eps|gif , good-in => htm|html , block => pdf|ppt , block-out => rar|rpt , block-in => xls|exe\-bin<br /><br />
  At least one of the above option must be defined in a line - a maximum of all (six) could be defined, if this makes sense.<br />
  If the user name matches for a sender or recipient and a (in/out) regex definition is found in this file, all level definition are overwritten for this mail.<br />
  good, good-out and good-in - and also - block, block-out and block-in - will be logical OR combined according to the mail flow.<br />
  Notice: if a bad attachment is found on a user based attachment check, the penalty box IP address scoring is skipped.',undef,undef,'msg009690','msg009691'],

['AttachmentError','Reply Code to Refuse Rejected Attachments',80,\&textinput,'550 5.7.1 These attachments are not allowed -- Compress before mailing.','([245]\d\d .*)',undef,'The literal \'FILENAME\' will be replaced with the name of the blocked attachment!',undef,undef,'msg004160','msg004161'],
['BlockUuencoded','Refuse Uuencoded Mails',0,\&checkbox,1,'(.*)',undef,'',undef,undef,'msg004170','msg004171'],
['UuencodedError','Reply to Refuse Uuencoded Mails',80,\&textinput,'554 5.7.1 This message is uuencoded and will be blocked. ','([25]\d\d .*)',undef,
 'For example: 554 5.7.1 This mail is uuencoded and will be blocked<br />
 <hr /><div class="menuLevel1">Notes On Attachment Blocking</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/Attachments.txt\',3);" />',undef,undef,'msg004180','msg004181'],

[0,0,0,'heading','ClamAV and FileScan'],
['noScan','Do Not Scan Messages from/to these Addresses*',60,\&textinput,'','(.*)','ConfigMakeSLRe','Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com).',undef,undef,'msg004190','msg004191'],
['noScanIP','Do Not Scan Messages from these IP\'s*',60,\&textinput,'','(\S*)','ConfigMakeIPRe','Enter IP addresses that you don\'t want to be scanned for virus , separated by pipes (|). For example: 145.145.145.145|145.146.',undef,undef,'msg004200','msg004201'],
['NoScanRe','Skip Virus RegEx*',80,\&textinput,'','(.*)','ConfigCompileRe',
 "Put anything here to identify messages which should not be checked for viruses.",undef,undef,'msg004210','msg004211'],
['SuspiciousVirus','No-Blocking Virus Scan Scoring Regex**',80,\&textinput,'file:files/suspiciousvirus.txt','(.*)','ConfigCompileRe',
 'If a ClamAV or FileScan result matches this expression it will be scored with the suspicious virus score ( vsValencePB ) and the message will not be blocked.<br />
 It is possible to weight such results. Every weighted regex that contains at least one \'|\' has to begin and end with a \'~\' - inside such regexes it is not allowed to use a \'~\', even it is escaped - for example:  ~abc\\~|def~=>23 or ~abc~|def~=>23 - instead use the octal (\\126) or hex (\\x7E) notation , for example ~abc\\126|def~=>23 or ~abc\\x7E|def~=>23 . Every weighted regex has to be followed by \'=>\' and the weight value. For example: <br />Phishing\\.=>1.45|~Heuristics|Email~=>50  <br />or <br />~(Email|HTML|Sanesecurity)\\.(Phishing|Spear|(Spam|Scam)[a-z0-9]?)\\.~=>4.6|Spam=>1.1|~Spear|Scam~=>2.1 . <br />The multiplication result of the weight and the penaltybox valence value will be used for scoring, if the absolute value of weight is less or equal 6. Otherwise the value of weight is used for scoring.',undef,undef,'msg004220','msg004221'],
['ScanWL','Scan Whitelisted Senders',0,\&checkbox,'1','(.*)',undef,'',undef,undef,'msg004230','msg004231'],
['ScanNP','Scan No Processing Senders',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg004240','msg004241'],
['ScanLocal','Scan Local Senders',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg004250','msg004251'],
['ScanCC','Scan Copied Spam Mails',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg004260','msg004261'],
['AvError','Reply Code to Refuse Infected Messages',80,\&textinput,'554 5.7.1 Mail appears infected with \[$infection\].','([25]\d\d .*)',undef,
 'Reply code to refuse infected messages. The string $infection is replaced with the name of the detected virus.<br />
 For example: 554 5.7.1 Mail appears infected with \[$infection\] -- disinfect and resend.',undef,undef,'msg004270','msg004271'],
['EmailVirusReportsTo','Send Virus Report To This Address',40,\&textinput,'','(.*)',undef,
 'If set an email containing the Message ID, Remote IP, Message Subject, Sender email address, Recipient email address, and the virus detected will be sent to this address. For example: admin@domain.com',undef,undef,'msg004280','msg004281'],
['EmailVirusReportsHeader','Add Full Header To Virus Report To Mail Address Above',0,\&checkbox,'','(.*)',undef,'If set the full message headers will also be added to Virus Reports.',undef,undef,'msg004290','msg004291'],
['EmailVirusReportsToRCPT','Send Virus Report To Recipient',0,\&checkbox,'','(.*)',undef,'If set the intended recipient of the message will be sent a copy of the Virus Report.<hr />',undef,undef,'msg004300','msg004301'],
['DoFileScan','Use File System Virus Scanner','0:disabled|1:block|2:monitor',\&listbox,0,'(\d*)',undef,
 'If activated, the message is written to a file inside the \'FileScanDir\' with an extension of \'maillogExt\'. After that ASSP will call \'FileScanCMD\' to detect if the temporary file is infected or not. The temporary created file(s) will be removed.<br />
 The viruses will be stored in a special folder if the SpamVirusLog is set to \'quarantine\' and the filepath to the viruslog is set.',undef,undef,'msg004310','msg004311'],
['FileScanDir','File Scan Directory',80,\&textinput,"$base/virusscan",'(.*)','',
 'Define the full path to the directory where the messages are temporary stored for the file system virus scanner. This could be any directory inside your file system. The running ASSP process must have full permission to this directory and the files inside!',undef,undef,'msg004320','msg004321'],
['FileScanCMD','File Scan Command',80,\&textinput,'','(.*)','',
 'ASSP will call this system command and expects a returned string from this command. This returned string is checked against \'FileScanBad\' and/or \'FileScanGood\' to detect if the message is OK or not! If the file does not exists after the command call, the message is consider infected. ASSP expects, that the file scan is finished when the command returns!<br />
  The literal \'FILENAME\' will be replaced by the full qualified file name of the temporary file.<br />
  The literal \'NUMBER\' will be replaced by the threadnumber and could be used to name logfiles and to redirect them to STDOUT.<br />
  The literal \'FILESCANDIR\' will be replaced with the value of FileScanDir.<br />
  Any case sensitive literal starting and ending with an asterix (*) like \'*rcpt*\' or \'*mailfrom*\' will be replaced by the quoted runtime connection variable of Con{fh}->{literal} (this->{literal}). You need to know the assp internals!<br />
  If a code reference is defined for the internal variable &#36;main::FileScanCMDbuild_API in lib/CorrectASSPcfg.pm , assp will call \'&#36;FileScanCMDbuild_API->(\\&#36;cmd,&#36;this)\' before running the command. The first parameter, the command (FileScanCMD), is submitted as a reference to a scalar, which must be modified in place. If you want assp not to scan the message, set this variable to undef. The second submitted parameter is the reference to the client connection parameter HASH - &#36;Con{fh} (eg. &#36;this)<br />
  All outputs of this command to STDERR are automatic redirected to STDOUT.<br />
  FileScan will not run, if FileScanCMD is not specified.<br />
  If you have your online/autoprotect file scanner configured to delete infected files inside the \'FileScanDir\', define \'NORUN\' in this field! In this case FileScanGood and FileScanBad are ignored. If there is a need to wait some time for the autoprotect scanner, write \'NORUN-dddd\', where dddd are the milliseconds to wait!<br />
  Depending on your operating system it may possible that you have to quote (\' or ") the command, if it contains whitespaces. The replaced file name will be quoted by ASSP if needed.',undef,undef,'msg004330','msg004331'],
['FileScanBad','RegEx to Detect \'BAD\' in Returned String*',80,\&textinput,'','(.*)','ConfigCompileRe',
 'Put anything here to identify bad messages by the string returned from the FileScanCMD. If defined and this regular expression matches, the message is consider infected.',undef,undef,'msg004340','msg004341'],
['FileScanGood','RegEx to Detect \'GOOD\' in Returned String*',80,\&textinput,'','(.*)','ConfigCompileRe',
 'Put anything here to identify good messages by the string returned from the FileScanCMD. If defined and this regular expression matches and \'FileScanBad\' does not, the message is consider not infected.<br />
   If both FileScanBad and FileScanGood are defined, FileScanBad has not to match and FileScanGood has to match, to consider a mail not infected!',undef,undef,'msg004350','msg004351'],
['FileScanRespRe','FileScan Reponds Regex*',60,\&textinput,'','(.*)','ConfigCompileRe',
 'A regular expression that will be used over the text returned from the FileScanCMD. The result of this regex is used as virus name ($infection) in AvError. For example: infected by .+? \.\&lt;hr \/\&gt;',undef,undef,'msg004360','msg004361'],
['UseAvClamd','Use ClamAV',0,\&checkbox,0,'(.*)',undef,
 'If activated, the message is checked by ClamAV, this requires an installed File::Scan::ClamAV Perl module and a running Clamd . It is not recommended to use ClamAV on heavy-load systems, because of resulting system overload, stucking workers or timeouts.<br />
 The viruses will be stored in a special folder if the SpamVirusLog is set to \'quarantine\' and the filepath to the viruslog is set.',undef,undef,'msg004370','msg004371'],
['AvClamdPort','Port or file socket for ClamAV',30,\&textinput,'','(\S+|)',undef,
 'A socket specified in the clamav.conf file - LocalSocket. For example /tmp/clamd. If the socket has been setup as a TCP/IP socket (see the TCPSocket option in the clamav.conf file), then specify the TCP socket. For example: 3310 ',undef,undef,'msg004380','msg004381'],
['ClamAVBytes','ClamAV Bytes',8,\&textinput,60000,'(\d*)',undef,
  'The number of bytes per message that will be submited to ClamAV and FileScan for virus scanning. Values of 100000 or larger are not recommended, because while a thread is waiting for the scanner result, it could not get new connections.',undef,undef,'msg004390','msg004391'],
['ClamAVtimeout','ClamAV Timeout',3,\&textinput,10,'(\d+)',undef, 'ClamAV will timeout after this many seconds.<br /> default: 10 seconds.
 <hr /><div class="menuLevel1">Notes On Virus Control</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/viruscontrol.txt\',3);" />',undef,undef,'msg004400','msg004401'],

[0,0,0,'heading','Regex Filter / Spambomb <a href="http://apps.sourceforge.net/mediawiki/assp/index.php?title=Regular_Expressions" target=wiki><img height=12 width=12 src="' . $wikiinfo . '" alt="bombRe" /></a>'],
['AllowInternalsInRegex','Allow Internal Variables in Regex',0,\&checkbox,'','(.*)',undef,'Allow internal variables to be used in regular expressions - replaces something like \${$EmailDomainRe} with the value of $EmailDomainRe',undef,undef,'msg009770','msg009771'],
['preHeaderRe','Regular Expression to early Identify Spam in Handshake and Header Part*',80,\&textinput,'file:files/preheaderre.txt','(.*)','ConfigCompileRe',
 'Until the complete mail header is received, assp is processing the handshake and header content line per line, but the first mail content check is done after the complete mail header is received.<br />
 It is possible, that some content (malformed headers, forbidden characters or character combinations) could cause assp to die or to run in to a unrecoverable exception.<br />
 Use this regular expression to identify such incoming mails based on a line per line check, at the moment where a single line is received.<br />
 This setting does not affect any other and is not affected by any other configuration setting, except that this check is only done for incoming mails.<br />
 If a match is found, assp will immediately send a \'421 <myName> closing transmission\' reply to the client and will immediately terminate the connection.<br />
  Default setting is file:files/preheaderre.txt',undef,undef,'msg008890','msg008891'],
['bombReWL','Do Bomb/Script Regular Expressions Checks for Whitelisted',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg004410','msg004411'],
['bombReNP','Do Bomb/Script Regular Expressions Checks for NoProcessing',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg004420','msg004421'],
['bombReLocal','Do Bomb/Script Regular Expressions Checks for Local Messages',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg004430','msg004431'],
['bombReISPIP','Do Bomb/Script Regular Expressions Checks for ISPIP',0,\&checkbox,'1','(.*)',undef,'',undef,undef,'msg004440','msg004441'],

['bombMaxPenaltyVal','Maximum Penalty on Bombs per Mail per Check',3,\&textinput,70,'(\d*)',undef, 'Depending on the configuration, it could be possible that a message gets a very high penalty value on a bomb-check. This value limits the maximum penalty per mail for every single bomb-check that is enabled.',undef,undef,'msg004450','msg004451'],
['maxBombSearchTime','Maximum time spend on Bomb Search',3,\&textinput,5,'(\d*)',undef, 'Maximum time in seconds that is spend on every configured bomb check. This time check is done, after every found bomb. So it is possible that the bomb search takes longer as the defined value, if no bomb is found or a single search takes more time. Default is 5.
  <hr><hr>
  <span class="negative">Even if any of the following bomb parameters is set to "block", but the sum of the resulting weighted penalty value is less than the corresponding "Penalty Box Valence Value" (because of lower weights) - only scoring will be done!<br />
  A description of how of weighting regular expressions is done and working, could be found at the bottom this web page.</span><hr>',undef,undef,'msg004460','msg004461'],
['DoTransliterate','Transliterate non-Roman characters in to Roman',0,\&checkbox,'','(.*)',undef,
'If enabled, ASSP tries to transliterate non-Roman characters in an email it to Roman characters. These transliterations are than additionaly used in the bomb checks.<br />
 For example - the (character) sequence \'&#24180;&#20809;&#36890;&#20449;&#20135;&#19994;&#20250;&#22238;&#24402;&#39640;&#22686;&#38271;&#36712;&#36947;\' will be transliterated to \'Nian Guang Tong Xin Chan Ye Hui Hui Gui Gao Zeng Chang Gui Dao\' .<br />
 To transliterate something, use the \'Mail Analyzer\'.<br />
 To make this feature working, the Perl module <a href="http://search.cpan.org/search?query=Text::Unidecode" rel="external">Text::Unidecode</a> must be installed.',undef,undef,'msg00009990','msg009991'],
['DoBombHeaderRe','Use BombHeader Regular Expressions on Header Part','0:disabled|1:block|2:monitor|3:score|4:testmode',\&listbox,1,'(\d*)',undef,
  'If activated, each message-header is checked  against bombSenderRe, bombHeaderRe, bombSubjectRe and bombCharSets Regular Expressions. If you use sendAllSpam, be aware that only the header will be shown in the spamcopy.<br />
  The scoring value is the sum of all valences(weights) of all found bombs - bombValencePB .',undef,undef,'msg004470','msg004471'],
['bombSenderRe','Envelope Blocking Regular Expression **',80,\&textinput,'emailserver3\.com|\d\d\d\d\d\d\@tom\.com','(.*)','ConfigCompileRe',
  'Part of DoBombHeaderRe: expression to identify sender (mailfrom,ip,helo).',undef,undef,'msg004480','msg004481'],
['bombHeaderRe','Regular Expression to Identify Spam in Header Part**',80,\&textinput,'file:files/bombheaderre.txt','(.*)','ConfigCompileRe',
  'Part of DoBombHeaderRe: header will be checked against this Regex if DoBombHeaderRe is enabled. For example<br /> file:files/bombheaderre.txt',undef,undef,'msg004490','msg004491'],
['bombSubjectRe','Regular Expression to Identify Spam in Subject**',80,\&textinput,'','(.*)','ConfigCompileRe','Part of DoBombHeaderRe : the mail header will be checked against this Regex if  DoBombHeaderRe  is enabled.',undef,undef,'msg004500','msg004501'],
['maxSubjectLength','Maximum allowed Subject Length',20,\&textinput,'200=>100','^(\d+(?:\=\>\d+)?|)$',undef,'If set to a value greater than 0, assp will check the length of the Subject of the mail. If the Subject length exceeds this value, the message score will be increased by \'bombValencePB\' and the string that is checked in \'bombSubjectRe\' will be trunked to this length. It is possible to define a special weight using the syntax \'length=>value\', in this case the defined absolute value will be used instead of \'bombValencePB\' to increase the message score. If the subject is too long and this weight is equal or higher than \'bombMaxPenaltyVal\' no further bomb checks will be done on the subject.',undef,undef,'msg009360','msg009361'],
['bombCharSets','Regular Expression to Identify Foreign Charsets**',60,\&textinput,'charset=(?:BIG5|CHINESEBIG|GB2312|KS_C_5601|KOI8-R|EUC-KR|ISO-2022-JP|ISO-2022-KR|ISO-2022-CN|CP1251)','(.*)','ConfigCompileRe','Part of DoBombHeaderRe: header will be checked against this Regex if DoBombHeaderRe is enabled.<br />
  Part of DoBombRe : every MIME-part header will be checked against this Regex if DoBombRe is enabled.<br />
 For example:<br /> charset=(?:BIG5|CHINESEBIG|GB2312|KS_C_5601|KOI8-R|EUC-KR|ISO-2022-JP|ISO-2022-KR|ISO-2022-CN|CP1251). ',undef,undef,'msg004510','msg004511'],
['bombHeaderReMaxHits','Maximum Hits for Bombs in Header and Sender',3,\&textinput,1,'(\d*)',undef,'A hit is a found Bomb in header and sender - bombSenderRe , bombHeaderRe , bombSubjectRe , bombCharSets .<br />
  If the number of hits is greater or equal Maximum Hits, the email is flagged <b>Failed</b> (possibly blocked and/or scored).<br />
  If the number of hits is greater 0 and less Maximum Hits, the email is flagged <b>Neutral</b> (possibly scored)',undef,undef,'msg004520','msg004521'],
['DoBombRe','Use Bomb Regular Expressions','0:disabled|1:block|2:monitor|3:score',\&listbox,1,'(\d*)',undef,
  'If activated, each message is checked  against bombRe and BombData Regular Expressions.<br />
  The scoring value is the sum of all valences(weights) of all found bombs - bombValencePB .',undef,undef,'msg004530','msg004531'],
['bombRe','Regular Expression for Header and Data Part**',80,\&textinput,'file:files/bombre.txt','(.*)','ConfigCompileRe','Header and Data will be checked against this Regular Expression if DoBombRe is enabled.  For example:<br />IMG [^&gt;]*src=[\'&quot;]cid|&lt;BODY[^&gt;]*&gt;(&lt;[^&gt;]+&gt;|\n|\r)*&lt;IMG[^&gt;]+&gt;(&lt;[^&gt;]+&gt;|\n|\r)*&lt;/BODY&gt;<br />
 If you want to search for attachment names, define a line with \'attachment:the_attachment_name\'.',undef,undef,'msg004540','msg004541'],
['bombSkipHeaderTagRe','Regular Expression to Identify skipped Tags in Header Part*',80,\&textinput,'file:files/bombskipheadertagre.txt','(.*)','ConfigCompileRe',
  'Regular Expression to define header tags, that will be skipped for bombSuspiciousRe, bombHeaderRe, bombRe and blackRe - like \'DKIM-Signature|Domainkey-Signature\' - the always followed collon (:) is added by assp. For example<br /> file:files/bombskipheadertagre.txt',undef,undef,'msg009980','msg009981'],
['bombReMaxHits','Maximum Hits for Bombs in Header and Data',3,\&textinput,1,'(\d*)',undef,'A hit is a found Bomb in header and data - bombRe .<br />
  If the number of hits is greater or equal Maximum Hits, the email is flagged <b>Failed</b> (possibly blocked and/or scored).<br />
  If the number of hits is greater 0 and less Maximum Hits, the email is flagged <b>Neutral</b> (possibly scored)',undef,undef,'msg004550','msg004551'],
['bombDataRe','BombData Regular Expression for Data Part**',80,\&textinput,'','(.*)','ConfigCompileRe','Data part will be checked against the Regular Expression  if DoBombRe is enabled. For example:<br />IMG [^&gt;]*src=[\'&quot;]cid|&lt;BODY[^&gt;]*&gt;(&lt;[^&gt;]+&gt;|\n|\r)*&lt;IMG[^&gt;]+&gt;(&lt;[^&gt;]+&gt;|\n|\r)*&lt;/BODY&gt;<br />
  If you want to search for attachment names, define a line with \'attachment:the_attachment_name\'.',undef,undef,'msg004560','msg004561'],
['bombDataReMaxHits','Maximum Hits for Bombs in Data',3,\&textinput,1,'(\d*)',undef,'A hit is a found Bomb in data - bombDataRe .<br />
  If the number of hits is greater or equal Maximum Hits, the email is flagged <b>Failed</b> (possibly blocked and/or scored).<br />
  If the number of hits is greater 0 and less Maximum Hits, the email is flagged <b>Neutral</b> (possibly scored)',undef,undef,'msg004570','msg004571'],
['bombSuspiciousRe','Suspicious Expression for Scoring Only**',80,\&textinput,'','(.*)','ConfigCompileRe','Sender, Header and Data will be checked for scoring only. Put here anything which might be suspicious. bombSuspiciousValencePB will be used to increase the score. For example:<br />unsubscribe',undef,undef,'msg004580','msg004581'],
['noBombScript','Don\'t Check Messages from these Addresses*',80,\&textinput,'','(.*)','ConfigMakeSLRe',
  'Don\'t detect spam bombs or scripts in messages from these addresses. Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com).',undef,undef,'msg004590','msg004591'],
['DoTestRe','Do Test Regular Expression',0,\&checkbox,0,'(.*)',undef,
  'If activated, each message is checked  against the Test Regular Expression below. This provides a way to test regex strings on live mail.',undef,undef,'msg004600','msg004601'],
['testRe','Test Regular Expression**',80,\&textinput,'','(.*)','ConfigCompileRe','Use this to test your regular expressions. Test valence is teValencePB .',undef,undef,'msg004610','msg004611'],
['bombError','Spam Bomb Error',80,\&textinput,'554 5.7.1 Delivery not authorized, message refused -- .','^([245]\d\d .*|)$',undef,
  'SMTP error message to reject spam bombs. For example: 554 5.7.1 Delivery not authorized, message refused -- send report to mailto:postmaster@mydomain.tld or call +12.34.56.78.90',undef,undef,'msg004620','msg004621'],
['bombErrorReason','Add Reason',0,\&checkbox,1,'(.*)',undef,
  'Add matching expression to Spam Bomb Error',undef,undef,'msg004630','msg004631'],
['DoBlackRe','Use Black Regular Expression to Identify Spam Strictly','0:disabled|1:block|2:monitor|3:score',\&listbox,0,'(\d*)',undef,
  'Each incoming message is checked  against the BlackRe to Identify Spams. No Optout. <br />
  The scoring value is the sum of all valences(weights) of all found bombs - blackValencePB .',undef,undef,'msg004640','msg004641'],
['blackRe','BlackRe - Regular Expression to Identify Spam Strictly**',80,\&textinput,'file:files/blackre.txt','(.*)','ConfigCompileRe',
  'If an incoming email matches this Perl regular expression it will be strictly considered spam . For example: \breplica watches\b|\bMegaDik\b|\bcock\b|\bpenis\b|\bpills\b|\bOriginal Viagra\b|\bbetter sex life\b|\baverage penis\b|\benlargement\b|\borgasm\b|\berections\b|\bViagra\b|\bbig dick\b|\bsperma\b|\bSexual\b|\bErectionsk\b|\bStamina\b|\bsildenafil\b|\bcitrate\b|\bErectile\b',undef,undef,'msg004650','msg004651'],
['blackReMaxHits','Maximum Hits for Identify Spam Strictly',3,\&textinput,1,'(\d*)',undef,'A hit is a found Bomb for Identify Spam Strictly. - blackRe <br />
  If the number of hits is greater or equal Maximum Hits, the email is flagged <b>Failed</b> (possibly blocked and/or scored).<br />
  If the number of hits is greater 0 and less Maximum Hits, the email is flagged <b>Neutral</b> (possibly scored)',undef,undef,'msg004660','msg004661'],

['DoScriptRe','Use Regular Expression to Identify Mobile Scripts','0:disabled|1:block|2:monitor|3:score',\&listbox,0,'(\d*)',undef,
  'Each message is checked  against the Expression to Identify Mobile Scripts.<br />
  The scoring value is the sum of all valences(weights) of all found bombs - scriptValencePB .',undef,undef,'msg004670','msg004671'],
['scriptRe','Regular Expression to Identify Mobile Scripts**',80,\&textinput,'','(.*)','ConfigCompileRe',
  'Spam mails may contain mobile scripting code, eg activex and java or php. You can use this feature to block those messages.<br />
  Leave this blank to disable the feature. For example:<br /> \&lt;applet|\&lt;embed|\&lt;iframe|\&lt;object|\&lt;script|\&lt;?php|onmouseover|onload|onfocus|onblure|onclick|javascript:',undef,undef,'msg004680','msg004681'],
['scriptReMaxHits','Maximum Hits for Identify Mobile Scripts',3,\&textinput,1,'(\d*)',undef,'A hit is a found mobile scripting code for Identify Mobile Scripts - scriptRe .<br />
  If the number of hits is greater or equal Maximum Hits, the email is flagged <b>Failed</b> (possibly blocked and/or scored).<br />
  If the number of hits is greater 0 and less Maximum Hits, the email is flagged <b>Neutral</b> (possibly scored)',undef,undef,'msg004690','msg004691'],

['scriptError','Script Error',80,\&textinput,'554 5.7.1 Your email contains html scripting code -- please resend as plain text.','^([245]\d\d .*|)$',undef,
  'SMTP error message to reject scripts. For example: 554 5.7.1 Your email appears to be spam -- send an error report to mailto:postmaster@mydomain.tld or call +12.34.56.78.90
  <br /><hr /><div class="menuLevel1">Notes On Bomb Regex</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/bombre.txt\',3);" />',undef,undef,'msg004700','msg004701'],

[0,0,0,'heading','Bayesian and Hidden Markov Model (HMM) Options <a href="http://apps.sourceforge.net/mediawiki/assp/index.php?title=ASSP_Bayesian_Filter" target=wiki><img height=12 width=12 src="' . $wikiinfo . '" alt="Theory of Operation" /></a>'],
['DoBayesian','Bayesian Check <a href="http://apps.sourceforge.net/mediawiki/assp/General_ASSP_Questions#Theory_of_Operation" target=wiki><img height=12 width=12 src="' . $wikiinfo . '" alt="Theory of Operation" /></a>','0:disabled|1:block|2:monitor|3:score',\&listbox,0,'(.*)',undef,
  'If activated, the message is checked based on Bayesian factors in spamdb for global and private entries. Private spamdb entries have a five times higher weight than global entries. This needs a fully functional spamdb built by rebuildspamdb. For starters it is best practice to put this inactiv and built the spamdb collection with the help of DSNBL ,URIBL and spamaddresses. Scoring is done with baysValencePB for external mails, baysValencePB_local is used for outgoing and internal mails - both values are multiplied with the detected baysProbability .<br />
  Both, the Bayesian-check and the Hidden-Markov-Model-check (below), are using Perl version depending (Perl 5.12 and higher) <a href=\"http://unicode.org/charts/\" rel=\"external\">Unicode</a> features to recognize any possible character. How ever, some east asian languages (and some others) have graphemes, that contains multiple <a href=\"http://en.wikipedia.org/wiki/Unicode\" rel=\"external\">unicode code points</a>. If you need (or want) assp to process all text as a sequence of <a href=\"http://unicode.org/reports/tr29/\" rel=\"external\">UAX #29 Grapheme Clusters</a>, the Perl module <a href=\"http://search.cpan.org/dist/Unicode::LineBreak/\" rel=\"external\">Unicode::LineBreak</a> is required.',undef,undef,'msg004710','msg004711'],
['DoHMM','Hidden Markov Model Check <a href="http://apps.sourceforge.net/mediawiki/assp/General_ASSP_Questions#Theory_of_Operation" target=wiki><img height=12 width=12 src="' . $wikiinfo . '" alt="Theory of Operation" /></a>','0:disabled|1:block|2:monitor|3:score',\&listbox,0,'(.*)',undef,
  "If activated, the message is checked based on a <a href=\"http://en.wikipedia.org/wiki/Hidden_Markov_model\">Hidden Markov Model</a>  for global and private entries.  Private HMM entries have a five times higher weight than global entries. This needs a fully functional HMMdb database built by rebuildspamdb. For starters it is best practice to put this in monitoring mode and built the HMM collection with the help of DSNBL ,URIBL and spamaddresses. Scoring is done with HMMValencePB for external mails, HMMValencePB_local is used for outgoing and internal mails. <br />
  The perl module <a href=\"http://search.cpan.org/dist/BerkeleyDB/\" rel=\"external\">BerkeleyDB</a> version 0.34 or higher and BerkeleyDB version 4.5 or higher is required (to store temporary data) to use this feature and 'useDB4Rebuild' and 'useBerkeleyDB' must be set to ON.<br />
  If this option is disabled, the rebuildspamdb task will <b>NOT</b> build a valid HMM database!<br />
  Compared to the Bayesian option, the Hidden Markov Model will produce results that are much more exact. How ever, it is possible, that HMM gets no result on very small messages, for this reason it is recommended to use both Bayesian and HMM. If you enable both checks, check your settings for baysValencePB, HMMValencePB, bayslocalValencePB and HMMlocalValencePB - eg. divide them by 2. or set the bayes values to 1/3 and the HMM values to 2/3.<br />
  NOTICE that using this option requires a <b>very fast database server</b> behind, if HMMusesBDB is set to OFF. The Bayesian- and HMM check together can produce <b>4000 and much more SQL querys per second</b>.<br />
  Keep in mind, that all backups and exports of the HMM database could require several 100MB of diskspace, if the file count in the corpus is very large.",undef,undef,'msg001230','msg001231'],
['ignoreDBVersionMissMatch','Ignore a database version missmatch','0:disabled|1:Spamdb|2:HMMdb|3:Spam and HMMDB',\&listbox,0,'(.*)',undef,
  'The status of assp is changed to "not healthy" if the current version of any of Spamdb or HMMdb is not equal to the required database version. Such a missmatch is automaticaly corrected with the next successfull rebuildspamdb. How ever, if you are unable to solve this problem for any reason, you should set this value to keep the status of assp "healthy".',undef,undef,'msg009940','msg009941'],
['HMMusesBDB','Use BerkeleyDB for the Hidden Markov Model database',0,\&checkbox,1,'(.*)',undef,"If enabled (default), the Hidden Markov Model database uses BerkeleyDB - notice: in this case no database import, backup or export are provided for the HMMdb. This value is completely ignored, if DBdriver is set to 'BerkeleyDB' and spamdb is set to 'DB:'. Switch this parameter to OFF, if you want to use the same database engine for the HMMdb like spamdb is configured. <br />
  <span class=\"negative\">Changing this value requires a restart of assp. Possibly a forced rebuildspamdb is required after the restart.</span>",undef,undef,'msg001240','msg001241'],
['DoPrivatSpamdb','Use also private entries for the Bayesian Spamdb and Hidden Markov Model databases','0:NO|1:for users only|2:for domains only|3:for users and domains',\&listbox,0,'(.*)','ConfigChangeDoPrivatSpamdb','If enabled, private entries (based on the local recipient and/or the report sender email address) will be added to the Bayesian and HMM databases. These private entries have a three times higher priority for users (full email address) and two times higher priority for domains (domain part of the email address) than global entries. To enable this option "spamdb" must be set to use a database "DB:" first!<br />
 <b>Setting this option to ON, will increase the record count for the spamdb and the HMM databases dramaticaly!</b>',undef,undef,'msg009630','msg009631'],
['BayesMaxProcessTime','Bayesian and HMM Check Timeout ',3,\&textinput,'15','(\d+)',undef,'The Bayesian- and HMM Checks are the most memory and CPU consuming tasks that ASSP is doing on a message. If such tasks running to long on one message, other messages could run in to SMTPIdleTimeout. Define here the maximum time in seconds that ASSP should spend on Bayesian Checks for one message. Default is 60.',undef,undef,'msg004720','msg004721'],
['BayesWL','Bayesian/HMM Check on Whitelisted Senders/Messages',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg006120','msg006121'],
['BayesNP','Bayesian/HMM Check on NoProcessing Messages',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg007420','msg007421'],
['noBayesian','Skip Bayesian and HMM Check*',60,\&textinput,'','(.*)','ConfigMakeSLRe',
 'Mail from/to any of these addresses are ignored by Bayesian- and HMM check, mails will not be stored in spam/notspam collection. Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com)',undef,undef,'msg004730','msg004731'],
['noBayesian_local','Skip Bayesian and HMM Check for this local senders*',60,\&textinput,'','(.*)','ConfigMakeSLRe',
 'Mail from any of these local addresses are ignored by Bayesian- and HMM checks, mails will not be stored in spam/notspam collection. Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com)',undef,undef,'msg009570','msg009571'],
['Bayesian_localOnly','Do Bayesian and HMM Check ONLY for this local senders*',60,\&textinput,'','(.*)','ConfigMakeSLRe',
 'Only mail from any of these local addresses are processed by the Bayesian- and HMM checks, except they are also defined in noBayesian_local . Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com)',undef,undef,'msg009010','msg009011'],
['maxBayesValues','Maximum most significant results used per mail to calculate Bayesian- and HMM-Probability',3,\&textinput,'60','([3-9]\d|\d{3})',undef,'Maximum count of most significant values used to calculate the Bayesian/HMM-Spam-Probability and the confidence of that probability.<br />
 The Bayesian/HMM Spam Probability will be fine with 30 and will get more exact, than higher this value is - until a value of 60.<br />
 The confidence of the Bayesian/HMM Spam Probability will get better, than higher this value is.<br />
 Values above 60 are possible, but could lead in to a performance penalty, without getting a better spam detection.
 Default is \'60\', minimum is \'30\'.',undef,undef,'msg007890','msg007891'],
['baysProbability','Bayesian and HMM Probability Threshold ',3,\&textinput,'0.6','(0\.\d+)',undef,' Messages with spam-probability below or equal this threshold are considered Ham. Recommended \'0.6\'.<br />
 An resulting Spam-Probability above this value is multiplied with baysValencePB_local or baysValencePB to get the penaltybox scoring value for the IP- and message score. In other words, the penaltybox scoring value is weighted by the Spam-Probability in case Spam is detected.<br />
 An resulting Spam-Probability below this value but higher than ( 1 - baysProbability ) is stated as \'UNSURE\' . In this case the half score will be added to the message score but not to the IP score and the message will not be blocked.<br /><br />
 The following default Bayesian math (prob = p1 / (p1 + p2)) is used to calculate the SpamProb value for \'n\' found Bayesian-Word-Pairs or HMM-Sequences, each with a spam-weight \'p\' - where 0&lt;p&lt;1 :<br /><br />
 \'SpamProb\' = (p<sub>1</sub> * p<sub>2</sub> * ... * p<sub>n</sub>) / ( p<sub>1</sub> * p<sub>2</sub> * ... * p<sub>n</sub>  + (1 - p<sub>1</sub>) * (1 - p<sub>2</sub> ) * ... * (1 - p<sub>n</sub>))<br />',undef,undef,'msg004740','msg004741'],
['baysConf','Bayesian and HMM Confidence Threshold',3,\&textinput,'0','(0\.?\d*)',undef,' Spam-Mails having a confidence below this threshold are passed in TestMode .
 Spam-Mails having a confidence above this threshold are blocked. Set this only above 0 if you are familiar with the bayesian statistics used in ASSP.<br />
 Messages that are processed by the bayesian and HMM check get a spam-probability score and a confidence score. The confidence score in assp is a quality indicator. A confidence near 0 would mean the probability score is like a wild guess. A confidence score near 1 would mean that it\'s pretty sure that the bayesian analysis result is correct. The confidence threshold is an allowance to process a Bayesian/HMM Spam as-if in Bayesian TestMode, if the message\'s *confidence* score is lower than the confidence threshold.
 Set this level to a specfic value, let\'s say .001 (which is a good one for starting), then:<br />
 - messages with spam-probability higher than 0.6 and a confidence of less than .001 would come through as in test mode<br />
 - messages with spam-probability higher than 0.6 and a confidence of more than .001 would be blocked<br />
 - messages with spam-probability less than 0.6 would pass<br />
 The 0.6 threshold can be set in baysProbability .<br />
 Carefully set this parameter above 0, if the bayesian corpus norm (shown by the rebuildspamdb log) is less than 0.6 or higher than 1.4 .<br /><br />
 The following math is used to calculate the SpamProbConfidence value for \'n\' found Bayesian-Word-Pairs or HMM-Sequences, each with a spam-weight \'p\' - where 0&lt;p&lt;1 :<br /><br />
 extreme_confidence_count = |(0 &lt; p<sub>1...n</sub> &lt; 0.01)| - |(0.99 &lt; p<sub>1...n</sub> &lt; 1)|<br />
 extreme_confidence_count = 0 - if ( extreme_confidence_count &lt; 0 and SpamProb &gt; 0.5) or ( extreme_confidence_count &gt; 0 and SpamProb &lt;= 0.5) == TRUE; <br />
 extreme_confidence_count = abs( extreme_confidence_count )<br />
 mail_confidence = abs((P<sub>1</sub> * P<sub>2</sub> * ... * P<sub>k</sub>) - ((1 - P<sub>1</sub>) * (1 - P<sub>2</sub> ) * ... * (1 - P<sub>k</sub>))) - for all elements P<sub>1...k</sub> in (0.01 &lt; p<sub>1...n</sub> &lt; 0.99)<br />
 corpus_confidence = 1 / ((abs(1 - corpus_norm) + 1)<sup>int(abs(1 - corpus_norm) * 10)</sup>) - the exponent is limited to a maximum of 4<br />
 SpamProbConfidence = 0.01<sup>extreme_confidence_count</sup> * mail_confidence * corpus_confidence * (n / maxBayesValues)<sup>2</sup><br /><br />
 The SpamProbConfidence is limited to a maximum of 1.0 . <br />
 All extreme values \'p\' having a spam weight less than 0.01 or higher than 0.99 with a corresponding extreme value like (0.009 &lt;-&gt; 0.999) are ignored for the mail_confidence calculation.<br /><br />
 <span class="negative"> empty or zero = disabled</span>.',undef,undef,'msg004750','msg004751'],
['baysConfidenceHalfScore','Reduce Scoring for Low Confidence',0,\&checkbox,1,'(.*)',undef,
 'Spam-Mails having a confidence below the threshold, will get half of the normal penalty score for Bayesian and HMM hits.',undef,undef,'msg004760','msg004761'],
['NoTagInTestmode','No Subject Tag in Testmode',0,\&checkbox,'','(.*)',undef,
  'In Bayesian TestMode "/Prepend Spam Subject/" is only added if the message is Spam and confidence is higher than Bayesian Confidence Threshold" .',undef,undef,'msg004770','msg004771'],
['AddSpamProbHeader','Add Bayes and HMM Probability Header',0,\&checkbox,'','(.*)',undef,
 'Adds a line to the email header "X-Assp-Spam-Prob: 0.0123" and/or "X-Assp-HMM-Spam-Prob: 0.0123" Probability ranges from 0 to +1 where > 0.6 = spam.',undef,undef,'msg004780','msg004781'],
['AddConfidenceHeader','Add Bayes and HMM Confidence Header',0,\&checkbox,'','(.*)',undef,
  'Adds a line to the email header "X-Assp-Bayes-Confidence: 0.0123" and/or "X-Assp-HMM-Confidence: 0.0123".<br /><hr />
  <div class="menuLevel1">Notes On Bayesian</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/bayesian.txt\',3);" />',undef,undef,'msg004790','msg004791'],

[0,0,0,'heading','Backscatter Detection'],
['DoMSGIDsig','Do Message-ID tagging and validating (FBMTV)','0:disabled|1:block|2:monitor|3:score|4:testmode',\&listbox,0,'(\d*)',undef,
  'If activated, the message-ID of each outgoing message will be signed with a unique Tag and every incoming mail from null sender, bounced or postmaster will be checked against this Tag. This tagging mode is called FBMTV "Forwarder(s) Bounce Message-ID Tag Validation" and it is worldwide unique to ASSP. This Tag is build nearly the same way, as BATVTag is build for the sender address. This Tag will be removed from any incoming email, to recover the original references in the mail header! If anything is changed on this option inside the mail, no DKIM-check will be done! Before activating DoMSGIDsig, please configure MSGIDpreTag and MSGIDsec!<br />
  This check requires an installed <a href="http://search.cpan.org/search?query=Digest::SHA1" rel="external">Digest::SHA1</a> module in Perl.',undef,undef,'msg004800','msg004801'],
['MSGIDpreTag','Message-ID pre-Tag for MSGID-TAG-generation',10,\&textinput,'sig','([a-zA-Z0-9]{2,5})',undef,'To use Message-ID signing and to create the MSGID-Tags, a pre-Tag is needed. This Tag must be 2-5 characters [a-z,A-Z,0-9] long. Default is \'sig\'.',undef,undef,'msg004810','msg004811'],
['MSGIDSec','Message-ID Secrets for MSGID-TAG-generation*',80,\&textinput,'0=key0|1=key1|2=key2|3=key3|4=key4|5=key5|6=key6|7=key7|8=key8|9=key9','(\S*)','configChangeMSGIDSec','To use Message-ID signing and to generate the MSGID-Tags, at leased one secret key is needed, up to ten keys are possible.<br />
  The notation is : generationnumber[0-9]=secretKey. For example<font color=red>(do not use!)</font>: 0=jk09Z|1=oPLmn4g|....   . Multiple paires are separated by pipes (|). Default is  0=key0|1=key1|2=key2|3=key3|4=key4|5=key5|6=key6|7=key7|8=key8|9=key9 . Do not defines spaces, tabs and \'=\' as part of the keys(secrets)! <br />
  <font color=red>Values that contains any default are not valid, please change them, to prevent detecting strange ASSP-signatures as valid local signatures!</font><br />For this reason, please define your secrets as unique as possible! The secrets are used randomly to build the Message-ID-Tags.',undef,undef,'msg004820','msg004821'],
['MSGIDsigAddresses','Do FBMTV For These Addresses Only*',80,\&textinput,'','(.*)','ConfigMakeSLRe',
  'Mail to any of these addresses will be tagged and checked by FBMTV. Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com). If empty, FBMTV is done for all addresses.',undef,undef,'msg004830','msg004831'],
['noMSGIDsigRe','Skip Message-ID signing, mail content dependend*',80,\&textinput,'','(.*)','ConfigCompileRe','Use this to skip the Message-ID tagging depending on the content of the email. If the content of the email matches this regular expression (checking MaxBytes only), FBMTV will not be done. For example: \'I am out of office\' .',undef,undef,'msg008900','msg008901'],
['noRedMSGIDsig','Skip Message-ID signing for Redlisted mails',0,\&checkbox,'0','(.*)',undef,'If selected, FBMTV will not be done for redlisted emails!',undef,undef,'msg008910','msg008911'],
['DoBATV','Do BATV taging and validating','0:disabled|1:block|2:monitor|3:score|4:testmode',\&listbox,0,'(\d*)',undef,'If enabled any sender address of outgoing mails is mangled with a <a href="http://en.wikipedia.org/wiki/Bounce_Address_Tag_Validation" rel="external">BATV-Tag</a>. Any incoming bounced mail is checked for a valid BATV-Tag. All valid (local) BATV-Tags will be removed from incoming mails - so whitelisting, delaying an all other recipient and sender based checks will use the normal addresses. If the BATV-check is successful, no MSGID-signing-check and DNS-Backscatter-check will be done! If any BATVTag was removed, no DKIM-check will be done! BATV-address-replacement is done, before the recipient replacement rules are processed!<br />
  This check requires an installed <a href="http://search.cpan.org/search?query=Digest::SHA1" rel="external">Digest::SHA1</a> module in Perl.',undef,undef,'msg004840','msg004841'],
['BATVSec','BATV Secrets for BATV-TAG-generation*',80,\&textinput,'0=key0|1=key1|2=key2|3=key3|4=key4|5=key5|6=key6|7=key7|8=key8|9=key9','(\S*)','configChangeBATVSec','To use <a href="http://en.wikipedia.org/wiki/Bounce_Address_Tag_Validation" rel="external">BATV</a> and to create the BATV-Tags, at leased one secret key is needed, up to ten keys are possible.<br />
  The notation is : generationnumber[0-9]=secretKey. For example: 0=key0|1=KEYX45rt|....   . Multiple paires are separated by pipes (|). Default is  0=key0|1=key1|2=key2|3=key3|4=key4|5=key5|6=key6|7=key7|8=key8|9=key9 . Do not defines spaces, tabs and \'=\' as part of the keys(secrets)! The secrets are use randomly to build the BATV-Tags.',undef,undef,'msg004850','msg004851'],
['removeBATVTag','remove strange BATV-Tags from incoming mails',0,\&checkbox,'0','(.*)',undef,'Any strange BATV-signature will be removed from the sender address and the real sender address will be used! Using this together with remindBATVTag keeps your clients addressbooks (also whitelist, delaydb ...) clean from BATV-Tags. This will also work, if DoBATV is disabled. If you do not use remindBATVTag and the MTA behind ASSP sends a bounced mail back - this mail will fail on BATV on the recipients site. If any BATVTag was removed, no DKIM-check will be done!',undef,undef,'msg004860','msg004861'],
['remindBATVTag','store incoming strange BATV-Tags to remind them for outgoing bounce mails',0,\&checkbox,'0','(.*)',undef,'If defined, any incoming stange BATV-signature will be stored and any recipient of outgoing bounce mails will be checked against this list. If there is found a valid (not older than 7 days) BATV-Tag for that recipient, it will be mangled in to the recipient address. This will also work, if DoBATV is disabled.',undef,undef,'msg004870','msg004871'],
['DoBackSctr','Do DNS-Backscatter Detection','0:disabled|1:block|2:monitor|3:score|4:testmode',\&listbox,0,'(\d*)',undef,
  'If activated, the IP-address of each message received for null sender,bounced or postmaster will be checked against the list below.
   DNS base checks requires an installed <a href="http://search.cpan.org/search?query=Net::DNS" rel="external">Net::DNS</a> module in Perl.<br />
   For more information about backscatter detection please read <a href="http://www.backscatterer.org/?target=usage" rel="external">http://www.backscatterer.org/?target=usage</a>.',undef,undef,'msg004880','msg004881'],
['BackDNSInterval','Backscatter-DNS Cache Refresh Interval',4,\&textinput,7,'(\d+\.?\d*|)','configUpdateBDNSCR','IP\'s in cache will be removed after this interval in days. 0 will disable the cache and the usage of downloadBackDNSFile and localBackDNSFile. <input type="button" value=" Show Backscatter-DNS Cache" onclick="javascript:popFileEditor(\'pb/pbdb.back.db\',5);" />',undef,undef,'msg004890','msg004891'],
['BackSctrServiceProvider','ServiceProvider for Backscatterer Detection*',60,\&textinput,'ips.backscatterer.org','(.*)','configUpdateBACKSctrSP',
  'ServiceProvider for DNS check on Backscatterer. Possible value is ips.backscatterer.org for DNS check.',undef,undef,'msg004900','msg004901'],
['downloadBackDNSFile','Download the Backscatterer DNS-IP-List',0,\&checkbox,'0','(.*)',undef,'If selected, the complete IP-list is downloaded to a local file. If useDB4IntCache is set, the list is stored in a BerkeleyDB database (BackDNS2). Otherwise the records will be stored in the pbdb cache BackDNS . The download will be skipped, if useDB4IntCache is not set and mysqlSlaveMode is set. IP\'s are checked on this file first, if the IP is not found on this list, a DNS query is done. It is recommended to use this option for ISP\'s and users with more than 1000 bounced mails a day. See wget-mirrors.uceprotect.net/rbldnsd-all/ips.backscatterer.org.gz',undef,undef,'msg004910','msg004911'],
['localBackDNSFile','Local File for the Backscatterer DNS-IP-List',0,\&textinput,'file:files/backdnslist.txt','(\s*file\s*:\s*.+|)',undef,'The name of the local file that is used for this IP-list. The content of this file is filled in to the \'Backscatter-DNS Cache\' ( BackDNSInterval ). IP\'s from this list will be removed after one day from the cache.
  <hr /><hr /><font color=red>The following configurations are valid for all Backscatter Detection Options!</font><hr />',undef,undef,'msg004920','msg004921'],

['Back250OKISP','Send 250 OK to ISP if any Backscatter Detection fails',0,\&checkbox,'0','(.*)',undef,'If any Backscatter check fails for a bounced mail that is coming from an ISPIP, ASSP will send "250 OK" to the ISP, but will discard the mail, if the check is configured to block!',undef,undef,'msg004930','msg004931'],
['BackWL','Do Backscatter Detection checks for Whitelisted mail',0,\&checkbox,'','(.*)',undef,'Tagging will be always done, if not excluded by address or domain!',undef,undef,'msg004940','msg004941'],
['BackNP','Do Backscatter Detection checks for No Processing mail',0,\&checkbox,'','(.*)',undef,'Tagging will be always done, if not excluded by address or domain!',undef,undef,'msg004950','msg004951'],
['noBackSctrRe','Regular Expression to Skip all BackScatter Checks*',80,\&textinput,'','(.*)','ConfigCompileRe',
  'If the contents of a mail matches these regular expressions, all BackScatter checks will be skipped.',undef,undef,'msg009240','msg009241'],
['noBackSctrAddresses','Do not any Backscatter detection for this Addresses *',80,\&textinput,'','(.*)','ConfigMakeSLRe',
  'Mail to and from any of these addresses will not be tagged and checked by any backscatter option. Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com).',undef,undef,'msg004960','msg004961'],
['noBackSctrIP','Exclude these IP\'s from any Backscatter detection*',80,\&textinput,'','(\S*)','ConfigMakeIPRe','Enter IP\'s that you want to exclude from FBMTV and Backscatter check, separated by pipes (|). <br />
  <hr /><div class="menuLevel1">Notes On Backscatter Detection</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/backscatter.txt\',3);" />',undef,'7','msg004970','msg004971'],

[0,0,0,'heading','TestModes'],
['spamSubject','Prepend Spam Subject <a href="http://apps.sourceforge.net/mediawiki/assp/Getting_Started#Rebuild_your_Bayesian_database."><img src="' . $wikiinfo . '" alt="TestMode" /></a>',20,\&textinput,'','(.*)',undef,'Setting a filter to testmode will tell ASSP not to reject the mail but rather build up the whitelist and spam and notspam collections. This can go on for some time without disturbing normal operation. After this very important phase TestMode can be used to tag the message: if TestMode and the message is spam Spam Subject gets prepended to the subject of the email. For example: [SPAM]','Basic',undef,'msg004980','msg004981'],
['spamTag','Prepend Spam Tag',0,\&checkbox,'','(.*)',undef,'ASSP uses many methods. The method which caught the spam will be prepended to the subject of the email. For example; [DNSBL]','Basic',undef,'msg004990','msg004991'],
['allTestMode','All Test Mode ON',0,\&checkbox,'','(.*)',undef,'Turn all of the individual testmodes on - regardless of the individual test mode settings. ',undef,undef,'msg005000','msg005001'],
['baysTestMode','Bayesian/Hidden-Markov-Model Test Mode',0,\&checkbox,1,'(.*)',undef,'',undef,undef,'msg005010','msg005011'],
['baysTestModeUserAddresses','Bayesian Test Mode User Addresses*',80,\&textinput,'','(.*)','ConfigMakeSLRe','These users are in test mode / mark subject only for bayesian spam, even with test mode above off','Basic',undef,'msg005020','msg005021'],
['blTestMode','BlackDomain Test Mode',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg005030','msg005031'],
['hlTestMode','Helo Blacklist Test Mode',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg005040','msg005041'],
['flsTestMode','Forged Local Domain Test Mode',0,\&checkbox,'','(.*)','','-> DoNoValidLocalSender',undef,undef,'msg005050','msg005051'],
['spfTestMode','SPF Test Mode',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg005060','msg005061'],
['rblTestMode','DNSBL Test Mode',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg005070','msg005071'],
['attachTestMode','Bad Attachment Test Mode',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg005080','msg005081'],
['uriblTestMode','URIBL Test Mode',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg005090','msg005091'],
['srsTestMode','SRS Test Mode',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg005100','msg005101'],
['bombTestMode','Bomb Regex Test Mode',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg005110','msg005111'],
['scriptTestMode','Script Regex Test Mode',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg005120','msg005121'],
['mxaTestMode','Missing MX Record Test Mode',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg005130','msg005131'],
['ptrTestMode','Reversed Lookup Test Mode',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg005140','msg005141'],
['ihTestMode','Invalid Helo Test Mode',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg005150','msg005151'],
['fhTestMode','Forged Helo Test Mode',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg005160','msg005161'],
['msTestMode','Message Scoring Test Mode',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg005170','msg005171'],
['dkimTestMode','DKIM Test Mode',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg005180','msg005181'],
['pbTestMode','Penalty Box Test Mode',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg005190','msg005191'],
['switchTestToScoring',"Switch Testmode to Message Scoring",0,\&checkbox,'','(.*)',undef,
 'Put the filter automatically in "Message Scoring" when DoPenaltyMessage is set  (instead of stopping spam processing altogether).<br /><hr /><div class="menuLevel1">Notes On Testmode</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/testmode.txt\',3);" />',undef,undef,'msg005200','msg005201'],


[0,0,0,'heading','Email Interface <a href="http://apps.sourceforge.net/mediawiki/assp/index.php?title=How_do_i_use_the_e-mail_interface" target=wiki><img height=12 width=12 src="' . $wikiinfo . '" alt="How do I use the e-mail interface" /></a>'],
['EmailInterfaceOk','Enable Email Interface',0,\&checkbox,1,'(.*)',undef,
  'Checked means that you want ASSP to intercept and parse mail to the following usernames at any localdomains. The domain \'@assp.local\' is automatically a local domain and can be used for the email-interface.
  <hr>
  <b>NOTICE:</b> It is possible to define any MIME-header lines in any report file after the first (subject) line. This makes it possible to define MIME encoding and/or charset settings.<br />
  If a definition of MIME encoding and/or charset is found in a report file, assp converts the report from UTF-8 in to the defined encodings. <b> Don\'t forget to terminate your MIME-header with an empty line!</b><br /><br />
  It is also possible to include files at any line of such a file, using the following directive<br />
  # include filename<br />
  where filename is the relative path (from '.$base.') to the included file like reports/mime-header.txt (one file per line). The line will be internaly replaced by the contents of the included file!',undef,undef,'msg005210','msg005211'],
['EmailAdminReportsTo','Admin Mail Address',40,\&textinput,'','('.$EmailAdrRe.'\@'.$EmailDomainRe.')?',undef,
  'If set internal warnings/infos  will be sent to this address. For example: admin@domain.com',undef,undef,'msg005220','msg005221'],
['EmailReportDestination','Email Interface Reports Destination',20,\&textinput,'','^((?:' . $HostPortRe . '(?:\|' . $HostPortRe . ')*)|)$',undef,
 'Port to connect to when Email Interface or Block reports are send. If blank they go to the main smtpDestination. eg "10.0.1.3:1025", etc.',undef,undef,'msg005230','msg005231'],
['EmailHelp','Help Address<a href="http://apps.sourceforge.net/mediawiki/assp/Getting_Started#Instructions_for_use_for_your_end_users." target="ASSPHELP"><img src="' . $wikiinfo . '" alt="doku" /></a>',20,\&textinput,'assphelp','(.*)@?',undef,
  'Any mail sent by local/authenticated users to this username will be interpreted as a request for help. Do not put the full address here, just the user part. For example: assphelp',undef,undef,'msg005240','msg005241'],
['EmailAdmins','Authorized Addresses*',80,\&textinput,'','(.*)','ConfigMakeSLRe',
  'Mail from any of these addresses can add/remove to/from redlist, spamlovers, noprocessing, blacklist. May request an EmailBlockReport for a list of users. Accepts specific addresses (user@example.com), user parts (user) or entire domains (@example.com)',undef,undef,'msg005250','msg005251'],
['EmailSenderOK','Accept Mails (Reports) from these external addresses*',40,\&textinput,'','(.*)','ConfigMakeSLRe',
  'Allow these external domains/addresses to report to the email interface (NOT RECOMMENDED). The reply address for the reports must be set to a local one.  By default, ASSP only accepts reports from local or authenticated users. Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com)',undef,undef,'msg005260','msg005261'],
['EmailSenderNotOK','Not Authorized Addresses*',80,\&textinput,'','(.*)','ConfigMakeSLRe',
  'Mail from any of these addresses are not accepted from Email Interface, except "Help Report", "Analyze Report" and "Block Report/Resend". Accepts specific addresses (user@example.com), user parts (user) or entire domains (@example.com). The user will get informed about the denied request.',undef,undef,'msg005270','msg005271'],
['EmailSenderIgnore','Ignore Not Authorized Addresses*',80,\&textinput,'','(.*)','ConfigMakeSLRe',
  'Mail from any of these addresses are not accepted from Email Interface, except "Help Report", "Analyze Report" and "Block Report/Resend". Accepts specific addresses (user@example.com), user parts (user) or entire domains (@example.com). The user will get not informed about the denied request.',undef,undef,'msg009390','msg009391'],
['EmailSpam','Report Spam Address',20,\&textinput,'asspspam','(.*)@?',undef,
  'Any mail sent or forwarded by local/authenticated users to this username will be interpreted as a spam report. Multiple attachments get truncated to MaxBytesReports. Do not put the full address here, just the user part.<br />
   For example: asspspam . Use a fake domain like @assp.local when you send the email- so the full address would be then asspspam@assp.local. <br />You can sent multiple mails as attachments and/or zipped file(s). Each attached email-file must have the extension defined in "maillogExt". In this case only the attachments will be processed. To use this multi-attachment-feature an installed <a href="http://search.cpan.org/search?query=Email::MIME" rel="external">Email::MIME</a> module in PERL is needed. It is also possible to send MS-outlook \'.msg\' files (possibly zipped). To use this MS-outlook-feature in addition an installed <a href="http://search.cpan.org/search?query=Email::Outlook::Message" rel="external">Email::Outlook::Message</a> module in PERL is needed.','Basic',undef,'msg005280','msg005281'],
['EmailHam','Report Ham (Not-Spam) Address',20,\&textinput,'asspnotspam','(.*)@?',undef,
  'Any mail sent or forwarded by local/authenticated users to this username will be interpreted as a false-positive report. Multiple attachments get truncated to MaxBytesReports. Do not put the full address here, just the user part.<br />
   For example: asspnotspam . Use a fake domain like @assp.local when you send the email- so the full address would be then asspspam@assp.local. <br />You can sent multiple mails as attachments and/or zipped file(s). Each attached email-file must have the extension defined in "maillogExt". In this case only the attachments will be processed. To use this multi-attachment-feature an installed <a href="http://search.cpan.org/search?query=Email::MIME" rel="external">Email::MIME</a> module in PERL is needed. It is also possible to send MS-outlook \'.msg\' files (possibly zipped). To use this MS-outlook-feature in addition an installed <a href="http://search.cpan.org/search?query=Email::Outlook::Message" rel="external">Email::Outlook::Message</a> module in PERL is needed.','Basic',undef,'msg005290','msg005291'],
['EmailForwardReportedTo','Email Interface Forward Reports Destination',20,\&textinput,'','^((?:' . $HostPortRe . '(?:\|' . $HostPortRe . ')*)|)$',undef,
 'Host and Port to forward EmailSpam and EmailHam reports to - eg "10.0.1.3:1025".<br />
  If you use more than one assp instance and your users are reporting spam and ham mails to multiple or all of them, but only one (but not this instance) is doing the rebuildspamdb and the corpus folders are not shared between the instances,<br />
  define the "host:port" of the central assp (rebuild-) instance here. Every report to EmailSpam and EmailHam (but only these!) will be forwarded to the defined host(s) and NO other local action will be taken. If the forwarding to all defined hosts failes, the request will be processed localy. To define multiple hosts for failover, separte them by pipe (|).',undef,undef,'msg009930','msg009931'],
['EmailErrorsReply','Reply to Spam/Not-Spam Reports','0:NO REPLY|1:REPLY TO SENDER|2:REPLY TO EmailErrorsTo|3:REPLY TO BOTH',\&listbox,1,'(\d*)',undef,  '',undef,undef,'msg005300','msg005301'],
['EmailErrorsTo','Send Copy of Spam/Ham-Reports TO',40,\&textinput,'','('.$EmailAdrRe.'\@'.$EmailDomainRe.')?',undef,
  'Email sent from ASSP acknowledging your submissions will be sent to this address. For example: admin@domain.com<br />',undef,undef,'msg005310','msg005311'],

['EmailErrorsModifyWhite','Combined Spam/Ham Report &amp; Whitelist Check','0:disabled|1:modify whitelist|2:show whitelist',\&listbox,1,'(.*)',undef,
  'If set to \'modify whitelist\' Ham Reports will add email addresses to the Whitelist, Spam Reports will remove addresses from the Whitelist, also a copy of a file in the GUI to correctedspam (remove) and correctednotspam (add) will modify the Whitelist for the found addresses. If set to \'show whitelist\' Spam Reports will show if addresses are whitelisted.','Basic',undef,'msg005320','msg005321'],
['EmailErrorsModifyNoP','Combined Spam Report and NoProcessing Deletion','0:disabled|1:modify noprocessing|2:show noprocessing',\&listbox,1,'(.*)',undef,
  'If set to \'modify noProcessing\' Spam Reports will remove email addresses from noProcessing list. If set to \'show noProcessing\' Spam Reports will show if addresses are on noProcessing list, also a copy of a file in the GUI to correctedspam (remove) and correctednotspam (show) will modify the noProcessing list for the found addresses.','Basic',undef,'msg008790','msg008791'],

['EmailWhitelistAdd','Add to Whitelist Address',20,\&textinput,'asspwhite','(.*)@?',undef,
  'Any mail sent by local/authenticated users to this username will be interpreted as a request to add addresses to the whitelist. Do not put the full address here, just the user part. <br />
  For example: asspwhite<br />
  If an address is added to whitelist, it will be removed from the Personal Blacklist of the sending user.','Basic',undef,'msg005330','msg005331'],
['EmailWhitelistRemove','Remove from Whitelist Address',20,\&textinput,'asspnotwhite','(.*)@?',undef,
  'Any mail sent by local/authenticated users to this username will be interpreted as a request to remove addresses from the whitelist. Do not put the full address here, just the user part. <br />For example: asspnotwhite','Basic',undef,'msg005340','msg005341'],
['EmailWhitelistReply','Reply to Add to/Remove from Whitelist','0:NO REPLY|1:REPLY TO SENDER|2:REPLY TO EmailWhitelistTo|3:REPLY TO BOTH',\&listbox,1,'(\d*)',undef,
  '',undef,undef,'msg005350','msg005351'],
['EmailWhitelistTo','Send Copy of Whitelist-Reports TO',40,\&textinput,'','('.$EmailAdrRe.'\@'.$EmailDomainRe.')?',undef,
  'Email sent from ASSP acknowledging your submissions will be sent to this address. For example: admin@domain.com',undef,undef,'msg005360','msg005361'],
['EmailRedlistAdd','Add to Redlist Address',20,\&textinput,'asspred','(.*)@?',undef,
  'Any mail sent by local/authenticated users to this username will be interpreted as a request to add the sender address to the redlist. Only the users defined in EmailRedlistTo, EmailAdmins and EmailAdminReportsTo are able to define a list of email addresses in the mail body.  Do not put the full address here, just the user part. <br />For example: asspred.',undef,undef,'msg005370','msg005371'],
['EmailRedlistRemove','Remove from Redlist Addresses',20,\&textinput,'asspnotred','(.*)@?',undef,
  'Any mail sent by local/authenticated users to this username will be interpreted as a request to remove the sender address from the redlist. Only the users defined in EmailRedlistTo, EmailAdmins and EmailAdminReportsTo are able to define a list of email addresses in the mail body. <br />
  Do not put the full address here, just the user part. <br />For example: asspnotred',undef,undef,'msg005380','msg005381'],
['EmailRedlistReply','Reply to Add to/Remove from Redlist','0:NO REPLY|1:REPLY TO SENDER|2:REPLY TO EmailRedlistTo|3:REPLY TO BOTH',\&listbox,1,'(\d*)',undef,
  '',undef,undef,'msg005390','msg005391'],
['EmailRedlistTo','Send Copy of Redlist-Reports TO',40,\&textinput,'','('.$EmailAdrRe.'\@'.$EmailDomainRe.')?',undef,
  'Email sent from ASSP acknowledging your submissions will be sent to this address. For example: admin@domain.com',undef,undef,'msg005400','msg005401'],
['EmailSpamLoverAdd','Add to SpamLover Addresses',20,\&textinput,'asspspamlover','(.*)@?',undef,
  'Any mail sent by local/authenticated users to this username will be interpreted as a request to add the sender address to spamLovers. Only the users defined in EmailSpamLoverTo, EmailAdmins and EmailAdminReportsTo are able to define a list of email addresses in the mail body. Do not put the full address here, just the user part. <br />For example: asspspamlover. To use this option, you have to configure spamLovers with "file:..." for example "file:files/spamlovers.txt" !',undef,undef,'msg005410','msg005411'],
['EmailSpamLoverRemove','Remove from SpamLover Addresses',20,\&textinput,'asspnotspamlover','(.*)@?',undef,
  'Any mail sent by local/authenticated users to this username will be interpreted as a request to remove the sender address from spamLovers. Only the users defined in EmailSpamLoverTo, EmailAdmins and EmailAdminReportsTo are able to define a list of email addresses in the mail body. <br />
  Do not put the full address here, just the user part. <br />For example: asspnotspamlover',undef,undef,'msg005420','msg005421'],
['EmailSpamLoverReply','Reply to Add to/Remove from SpamLovers','0:NO REPLY|1:REPLY TO SENDER|2:REPLY TO EmailSpamLoverTo|3:REPLY TO BOTH',\&listbox,1,'(\d*)',undef,
  '',undef,undef,'msg005430','msg005431'],
['EmailSpamLoverTo','Send Copy of Spamlover-Reports TO',40,\&textinput,'','('.$EmailAdrRe.'\@'.$EmailDomainRe.')?',undef,
  'Email sent from ASSP acknowledging your submissions will be sent to this address. For example: admin@domain.com',undef,undef,'msg005440','msg005441'],
['EmailNoProcessingAdd','Add to NoProcessing Addresses',20,\&textinput,'asspnpadd','(.*)@?',undef,
  'Any mail sent by local/authenticated users to this username will be interpreted as a request to add the sender address to the noProcessing addresses. Only the users defined in EmailNoProcessingTo, EmailAdmins and EmailAdminReportsTo are able to define a list of email addresses in the mail body. Do not put the full address here, just the user part. <br />For example: asspnpadd. To use this option, you have to configure noProcessing with "file:..." for example "file:files/noprocessing.txt" !',undef,undef,'msg005450','msg005451'],
['EmailNoProcessingRemove','Remove from noProcessing Addresses',20,\&textinput,'asspnprem','(.*)@?',undef,
  'Any mail sent by local/authenticated users to this username will be interpreted as a request to remove the sender address from noProcessing .<br />
  Do not put the full address here, just the user part. Only the users defined in EmailNoProcessingTo, EmailAdmins and EmailAdminReportsTo are able to define a list of email addresses in the mail body. <br />For example: asspnprem. To use this option, you have to configure noProcessing with "file:..." for example "file:files/noprocessing.txt" !',undef,undef,'msg005460','msg005461'],
['EmailNoProcessingReply','Reply to Add to/Remove from noProcessing','0:NO REPLY|1:REPLY TO SENDER|2:REPLY TO EmailNoProcessingTo|3:REPLY TO BOTH',\&listbox,1,'(\d*)',undef,
  '',undef,undef,'msg005470','msg005471'],
['EmailNoProcessingTo','Send Copy of NoProcessing-Reports TO',40,\&textinput,'','('.$EmailAdrRe.'\@'.$EmailDomainRe.')?',undef,
  'Email sent from ASSP acknowledging your submissions will be sent to this address. For example: admin@domain.com',undef,undef,'msg005480','msg005481'],
['EmailBlackAdd','Add to BlackListed  Addresses',20,\&textinput,'assp-black','(.*)@?',undef,
  'Any mail sent by local/authenticated users to this username will be interpreted as a request to add the sender address to the blackListedDomains addresses. Only the users defined in EmailAdmins and EmailAdminReportsTo are able to request an addition. Do not put the full address here, just the user part. <br />For example: assp-black. To use this option, you have to configure blackListedDomains with "file:..." for example "file:files/blacklisted.txt" !',undef,undef,'msg005490','msg005491'],
['EmailBlackRemove','Remove from BlackListed Addresses',20,\&textinput,'assp-notblack','(.*)@?',undef,
  'Any mail sent by local/authenticated users to this username will be interpreted as a request to remove the sender address from blackListedDomains .<br />
  Do not put the full address here, just the user part. Only the users defined in EmailAdmins and EmailAdminReportsTo are able to request an addition. <br />For example: assp-notblack. To use this option, you have to configure blackListedDomains with "file:..." for example "file:files/blacklisted.txt" !',undef,undef,'msg005500','msg005501'],
['EmailErrorsModifyPersBlack','Spam/NotSpam Report will modify Personal Blacklist *',60,\&textinput,'*@*','(.*)','ConfigMakeSLRe',
  'Spam Reports will add email addresses to the Personal Blacklist, NotSpam Reports will remove addresses from the Personal Blacklist, if the report senders address matches.<br />
  Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com). Wildcards are supported (fribo*@domain.com).<br />
  Default is *@* , which matches all addresses.',undef,undef,'msg009610','msg009611'],
['EmailPersBlackAdd','Add to Personal BlackListed Addresses',20,\&textinput,'assp-persblack','(.*)@?',undef,
  'Any mail sent by local/authenticated users to this username will be interpreted as a request to add the listed address(es) to the personal blackListed addresses. Do not put the full address here, just the user part. <br />
  For example: assp-persblack.<br />
  The add and remove is done via email-interface, by sending specific email addresses to \'EmailPersBlackAdd\'  and \'EmailPersBlackRemove\'.
  A local user can force a complete report about all his personal black list entries by defining an email address that begins with \'reportpersblack\' in a remove or add request : eg: reportpersblack@anydomain.com or by sending an empty body.<br />
  Any mail address sent to this username will be removed from the whitelist if possible.<br />
  Globalized adding an address to all local users is not supported - use EmailBlackAdd instead.<br />
  The following wildcard combinations are allowed for an email address to support personal blacklisting of domains:<br /><br />
  full_sender_address<br />
  *@sender_domain or @sender_domain<br />
  @*sender_domain or *@*sender_domain<br />
  @*.sender_domain or *@*.sender_domain',undef,undef,'msg009110','msg009111'],
['EmailPersBlackRemove','Remove from Personal BlackListed Addresses',20,\&textinput,'assp-persnotblack','(.*)@?',undef,
  'Any mail sent by local/authenticated users to this username will be interpreted as a request to remove the listed address(es) from the personal blackListed addresses .<br />
  Do not put the full address here, just the user part.<br />
  For example: assp-persnotblack.<br />
  The add and remove is done via email-interface, by sending specific email addresses to \'EmailPersBlackAdd\'  and \'EmailPersBlackRemove\'.
  A local user can force a complete report about all his personal black list entries by defining an email address that begins with \'reportpersblack\' in a remove or add request : eg: reportpersblack@anydomain.com or by sending an empty body.<br />
  Only an admin can force a complete cleanup of all personal black entries for a specific email address for all local users - sending an email to \'EmailPersBlackRemove\' with the address followed by \',*\' in the body
  eg: address_to_remove@the_domain.foo,* - be carefull modifying personal entries of other users!<br />
  The same wildcard combinations like in EmailPersBlackAdd are supported.<br />
  <b>Notice: a removement request for a specific email address will remove ALL entries from the users personal blacklist, that would block this email address (also all matching wildcard entries)!</b>',undef,undef,'msg009120','msg009121'],
['EmailBlackReply','Reply to Add to/Remove from BlackListed','0:NO REPLY|1:REPLY TO SENDER|2:REPLY TO EmailBlackTo|3:REPLY TO BOTH',\&listbox,1,'(\d*)',undef,
  '',undef,undef,'msg005510','msg005511'],
['EmailBlackTo','Send Copy of Black-Change-Reports TO',40,\&textinput,'','('.$EmailAdrRe.'\@'.$EmailDomainRe.')?',undef,
  'Email sent from ASSP acknowledging your submissions will be sent to this address. For example: admin@domain.com',undef,undef,'msg005520','msg005521'],
['EmailAnalyze','Request Analyze Report',20,\&textinput,'asspanalyze','(.*)@?',undef,
  'Any mail sent or forwarded by local/authenticated users to this username will be interpreted as a request for analyzing the mail. Do not put the full address here, just the user part. For example: asspanalyze <br />
  Use a fake domain like @assp.local when you send the email- so the full address would be then asspanalyze@assp.local. <br />You can sent multiple mails as attachments and/or zipped file(s). Each attached email-file must have the extension defined in "maillogExt". In this case only the attachments will be processed. To use this multi-attachment-feature an installed <a href="http://search.cpan.org/search?query=Email::MIME" rel="external">Email::MIME</a> module in PERL is needed. It is also possible to send MS-outlook \'.msg\' files (possibly zipped). To use this MS-outlook-feature in addition an installed <a href="http://search.cpan.org/search?query=Email::Outlook::Message" rel="external">Email::Outlook::Message</a> module in PERL is needed.','Basic',undef,'msg005530','msg005531'],
['EmailAnalyzeReply','Reply to Analyze Request','0:NO REPLY|1:SEND TO SENDER|2:SEND TO EmailAnalyzeTo|3:SEND TO BOTH',\&listbox,1,'(\d*)',undef,'',undef,undef,'msg005540','msg005541'],
['EmailAnalyzeTo','Send Copy of Analyze-Reports',40,\&textinput,'','('.$EmailAdrRe.'\@'.$EmailDomainRe.')?',undef,
  'A copy of the Analyze-Report will be sent to this address. For example: admin@domain.com',undef,undef,'msg005550','msg005551'],
['DoAdditionalAnalyze','Spam and Ham Reports will trigger an additional Analyze Report ','0:NO ADDITIONAL REPORT|1:SEND TO SENDER|2:SEND TO EmailAnalyzeTo|3:SEND TO BOTH',\&listbox,0,'(.*)',undef,
  'Additional Analyze Report will be generated for Spam and Ham Reports. Setting the TO Address accordingly and choosing <b>EmailAnalyzeTo</b> will send the Analyze Report to the admin only.',undef,undef,'msg005560','msg005561'],

['EmailFrom','From Address for Reports',40,\&textinput,'<spammaster@yourdomain.com>','('.$EmailAdrRe.'\@'.$EmailDomainRe.')?',undef,
  'Email sent from ASSP acknowledging your submissions will be sent from this address.',undef,undef,'msg005570','msg005571'],
['EmailAllowEqual','Allow \'=\' in Addresses',0,\&checkbox,'1','(.*)',undef,
  'Allow \'=\' in addresses to be whitelisted or redlisted.',undef,undef,'msg005580','msg005581'],

['EmailSenderNoReply','Do Not Reply To These Addresses*',80,\&textinput,'','(.*)','ConfigMakeSLRe',
  'Email sent from ASSP acknowledging your submissions will not be sent to these addresses. Accepts specific addresses (user@example.com), user parts (user) or entire domains (@example.com).<br />
  Analyze-, PersonalBlackList- and all virus related reports are ignored by this feature (are sent even a user is listed here).<br />
  An Report copy to EmailAnalyzeTo, EmailBlackTo, EmailNoProcessingTo, EmailSpamLoverTo, EmailRedlistTo, EmailWhitelistTo and EmailErrorsTo is also ignored by this feature.<br /><hr />
  <div class="menuLevel1">Notes On Email Interface</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/emailinterface.txt\',3);" />',undef,undef,'msg005590','msg005591'],

[0,0,0,'heading','File Paths and Database'],
['base','Directory Base',40,\&textnoinput,'.','(.*)',undef,'All paths are relative to this folder.<br />
  <b>Note: Display only.</b>',undef,undef,'msg005600','msg005601'],
['spamlog','Spam Collection',40,\&textinput,'spam','(\S+)',undef,'The folder to save the collection of spam mails. This directory will be used in building the spamdb . For example: spam',undef,undef,'msg005610','msg005611'],
['notspamlog','Not-spam Collection',40,\&textinput,'notspam','(\S+)',undef,'The folder to save the collection of not-spam mails. This directory will be used in building the spamdb . For example: notspam',undef,undef,'msg005620','msg005621'],
['incomingOkMail','OK Mail',40,\&textinput,'okmail','(.*)',undef,'The folder to save non-spam (message ok). These are messages which are considered as HAM, but are not stored in the standard HAM folder because of our policy to use only confirmed HAM messages (whitelisted or local) for spamdb . If you want to keep copies of ok mail then put in a directory name. This directory will not be used in building the spamdb . Default: okmail',undef,undef,'msg005630','msg005631'],
['discarded','Discarded Spam',40,\&textinput,'discarded','(.*)',undef,'The folder to save discarded spam-messages. These are Spam messages which are not stored for building the spamdb but for resending with an EmailBlockReport. If you want to keep copies of discarded Spam then put in a directory name. Default: discarded',undef,undef,'msg005640','msg005641'],
['viruslog','Attachment/Virus Collection',40,\&textinput,'quarantine','(.*)',undef,
  'The folder to save rejected attachments and virii. Leave this blank to not save these files (default). If you want to keep copies of rejected content then put in a directory name. Note: you must create the directory. This directory will not be used in building the spamdb . For example: quarantine',undef,undef,'msg005650','msg005651'],
['correctedspam','False-negative Collection',40,\&textinput,'errors/spam','(\S+)',undef,
  'Spam that got through -- counts double. This directory will be used in building the spamdb . For example: errors/spam',undef,undef,'msg005660','msg005661'],
['correctednotspam','False-positive Collection',40,\&textinput,'errors/notspam','(\S+)',undef,
  'Good mail that was listed as spam, count 4x. This directory will be used in building the spamdb . For example: errors/notspam',undef,undef,'msg005670','msg005671'],
['resendmail','try to resend this files',40,\&textinput,'resendmail','(\S+)',undef,
  'ASSP will try to resend the files in this directory to the original recipient. The files must have the "maillogExt" extension and must have the SMTP-format. For example: resendmail. This requires an installed <a href="http://search.cpan.org/search?query=Email::Send" rel="external">Email::Send</a> module in PERL.',undef,undef,'msg005680','msg005681'],
['maillogExt','Extension for Mail Files',20,\&textinput,'.eml','(\S*)',undef,
  'Enter the file extension (include the period) you want appended to the mail files in the mail collections.<br />
  Leave it blank for no extension - this setting will prevent several features from working. Never use \'.msg\' - this is an extension used by MS-outlook! For Example: .eml',undef,undef,'msg005690','msg005691'],
['spamdb','Spam/HMM Bayesian Database Files',40,\&textinput,'spamdb','(\S+)','configChangeDB','The output file from rebuildspamdb. Write only "DB:" to use a database table instead of a local file, in this case you need to edit the database parameters below. The Hidden Makov Model is only available if this parameter is set to DB: .<br />
 <hr /><span class=\"negative\">It is recommended to use a database for all possible lists and caches for best performance, less memoryusage and stability! If you do not want to install a database engine like MySql or Oracle, use BerkeleyDB! Please read the section DBdriver !</span><br />
 <hr /><div class="menuLevel1">Last Run Rebuildspamdb</div><input type="button" value="Last Run Rebuildspamdb" onclick="javascript:popFileEditor(\'rebuildrun.txt\',5);" />',undef,undef,'msg005700','msg005701'],
['whitelistdb','E<!--get rid of google autofill-->mail Whitelist Database File',40,\&textinput,'whitelist','(\S+)','configChangeDB','The file with the whitelist.<br />
  Write only "DB:" to use a database table instead of a local file, in this case you need to edit the database parameters below.',undef,undef,'msg005710','msg005711'],
['redlistdb','E<!--get rid of google autofill-->mail Redlist Database File',40,\&textinput,'redlist','(\S+)','configChangeDB','The file with the redlist.<br />
  Write only "DB:" to use a database table instead of a local file, in this case you need to edit the database parameters below.',undef,undef,'msg005720','msg005721'],
['persblackdb','Personal Blacklist Database File',40,\&textinput,'persblack','(\S+)','configChangeDB','The file with the personal blacklist. The check of the personal black list is done shortly after the RCPT TO: command. This command will be rejected if an entry is found - any other setting except send250OK and send250OKISP will be ignored.<br />
  Each entry is represented by two comma separated values TO,FROM (and an expiration date).<br />
  TO could be any of : email address, [subdomain.]domain.tld, @[subdomain.]domain.tld, *@[subdomain.]domain.tld - the last three entry options could be only added and removed by editing the list in the GUI !<br />
  FROM could be any of : email address or any [@][subdomain.][domain.]TLD variant (wildcards are allowed). All values are supported by the email interface for all local users.<br />
  Write only "DB:" to use a database table instead of a local file, in this case you need to edit the database parameters below.',undef,undef,'msg009100','msg009101'],
['griplist','GreyIPlist Database',40,\&textinput,'griplist','(\S*)',undef,'The file with the current Grey-IP-List database -- make this blank if you don\'t use it.',undef,undef,'msg005730','msg005731'],
['useDB4griplist','Use BerkeleyDB for Griplist',0,\&checkbox,'','(.*)','configChangeDB',
  'If selected ASSP uses \'BerkeleyDB\' instead of \'orderedtie\' for griplist. Depending on your settings for OrderedTieHashTableSize this could spend some memory and/or result in better performance.  The perl module <a href="http://search.cpan.org/dist/BerkeleyDB/" rel="external">BerkeleyDB</a> version 0.34 or higher and BerkeleyDB version 4.5 or higher is required to use this feature.',undef,undef,'msg005740','msg005741'],
['droplist','Drop also Connections from these IP\'s*',40,\&textinput,'file:files/droplist.txt','(\s*file\s*:\s*.+|)','ConfigMakeIPRe','Automatically downloaded (http://www.spamhaus.org/drop/drop.lasso) list of IP\'s which should be blocked right away. This list could be used in addition to denySMTPConnectionsFrom and/or denySMTPConnectionsFromAlways!',undef,'7','msg005750','msg005751'],
['delaydb','Delaying Database',40,\&textinput,'delaydb','(\S*)','configChangeDB','The file with the delay database.<br />Write only "DB:" to use a database table instead of a local file, in this case you need to edit the database parameters below.',undef,undef,'msg005760','msg005761'],
['ldaplistdb','LDAP Database',40,\&textinput,'ldaplist','(\S*)','configChangeDB','The file with the LDAP-cache database.<br />Write only "DB:" to use a database table instead of a local file, in this case you need to edit the database parameters below.',undef,undef,'msg005770','msg005771'],
['adminusersdb','Admin Users Database',40,\&textinput,'','(\S*)','configChangeDB','The file with the GUI-Admin-Users database - default to set is \'adminusers\'.<br />Write only "DB:" to use a database table instead of a local file, in this case you need to edit the database parameters below. Before setting this parameter, please set adminusersdbpass to a value of your choice!<br />
 <hr>To use this database shared between multiple ASSP\'s, set all ASSP to mysqlSlaveMode (except the master) and the adminusersdbpass must be the same on all installations! If you want to change the adminusersdbpass, first change it on the master.<hr>',undef,undef,'msg005780','msg005781'],
['adminusersdbNoBIN','Admin Users Database uses no Binary Data (ASCII only)',0,\&checkbox,'','(.*)',undef,'Select this, if adminusersdb is set to "DB:" and your database engine does not accept or has problems with binary data (eg. Postgres). <span class="negative">If you change this value, you have to stop all assp and to cleanup both tables (adminusers and adminusersright) <b>before</b> restarting assp!</span>. To keep your data do the following: do an ExportMysqlDB - change this value - stop assp - drop or clean both tables - start assp - do an ImportMysqlDB .',undef,undef,'msg005790','msg005791'],
['adminusersdbpass','Admin Users Database PassPhrase',40,\&passinput,'','(.+)','ConfigChangePassPhrase','The passphrase that is used to encrypt the adminusersdb. This has to be the same on all ASSP installations that are sharing the adminusersdb. If you want to change it, first change it on the master installation and than on the slaves. Do not forget to configure \'mysqlSlaveMode\' first. An empty value is not valid!',undef,undef,'msg005800','msg005801'],
['myhost','database hostname or IP',40,\&textinput,'','^(' . $HostRe .'|)$',undef,
  'You need <a  href="http://search.cpan.org/~lds/Tie-DBI-1.02/lib/Tie/RDBM.pm" rel="external">Tie::RDBM</a> to use a database instead of local files.<br />
  This way you can share whitelist, delaydb, redlist and penaltybox between servers',undef,undef,'msg005810','msg005811'],
['DBdriver','database driver name',40,\&textinput,'','(.*)','configChangeDB',
  'The database driver used to access your database - DBD-driver. The following drivers are available on your system:<br />
  $DBdriversJ<br />
  If you can not find the driver for your database in this list, you should install it via cpan or ppm!<br />
  -  or if you have installed an ODBC-driver for your database and DBD-ODBC, just create a DSN and use ODBC.<br />
  If assp is running on windows and you want to use a MSSQL server as backend, don\'t use the ODBC driver - use the ADO driver with the DSN definition!<br />
  Useful are ADO|DB2|Informix|ODBC|Oracle|Pg|Sybase|mysql - but any other SQL compatible database should also work.<br/ ><br />
  syntax examples: driver,option1,option2,...,...<br />
  ADO[,DSN=mydsn[;Provider=sqloledb]]<br />
  DB2<br />
  Informix<br />
  ODBC,DSN=mydsn|driver=\{SQL Server\},Server=server_name<br />
  Oracle,SID=1|INSTANCE_NAME=myinstance|SERVER=myserver|SERVICE_NAME=myservice_name,[PORT=myport]<br />
  Pg[,PORT=myport]<br />
  Sybase,SERVER=myserver,[PORT=myport]<br />
  mysql[,PORT=myport][,mysql_socket=/path/to/mysql.sock][,AutoCommit=1][,mysql_auto_reconnect=1]<br /><br />
  <span class="negative">Instead using local files for hashes and lists via shared memory, it is recommended to use <a  href=\"http://search.cpan.org/search?query=berkeleydb\" rel=\"external\">BerkeleyDB</a> (Perl-module) version 0.34 or higher for highest performance and less memory usage.  The BerkeleyDB (engine) version 4.5 or higher is required to use BerkeleyDB.</span><br />
  If you specify BerkeleyDB here, the values for myhost, mydb, myuser and mypassword will be ignored. All possible BerkeleyDB option must be defined here - the option for \'-Filename\' is already set by ASSP! Options could be defined for example:<br />
  BerkeleyDB,-Pagesize=>number,-Env=>[-Cachesize=>number,-Mode=>mode,...,...],...,...<br />
  If \'-Env=>[-Cachesize=>number]\' (number in bytes) is specified, this cache size will be used at minimum for every single list. This is not recommended, because ASSP does automaticly calculate the right cache for every list. You may setup configuration values for any BerkeleyDB, creating a file <a href=http://www.oracle.com/technology/documentation/berkeley-db/db/ref/env/db_config.html>DB_CONFIG</a> (case sensitive) in the corresponding directory ./tmpDB/[list]. Please use the BerkeleyDB documentation if you don\'t know the syntax of this file. Any value defined in that file will overwrite the corresponding internal ASSP configuration for this DB.<br /><br />
  The options for all drivers and their possible or required order depends on the DBD driver used, please read the driver\'s documentation, if you do not know the needed option.<br />
  The username, password, host and databasename are always used from this configuration page.',undef,undef,'msg005820','msg005821'],
['mydb','database name',40,\&textinput,'','(\S*)',undef,
  'This database must exist before starting ASSP, necessary tables will be created automatically into this database.',undef,undef,'msg005830','msg005831'],
['mysqlSlaveMode','This is a slave of more then one assp-computers accessing the same database',0,\&checkbox,'','(.*)',undef,
  'If you are running more then one assp-computers accessing the same or <a href="http://www.webopedia.com/TERM/S/SPOF.html">(better because of SPOF)</a> a bidirectional replicated database<br />
  this is a slave-assp and no database maintenance will be done by this one!<br />
  Maintenance should only be done by the first assp - the master!<br />
  Maintenance for file based caches and lists will always be done!',undef,undef,'msg005840','msg005841'],
['myuser','database username',40,\&passinput,'','(.*)',undef,
  'This user must have CREATE privilege on database to create tables automatically',undef,undef,'msg005850','msg005851'],
['mypassword','database password',40,\&passinput,'','(.*)',undef,'',undef,undef,'msg005860','msg005861'],
['DBCacheMaxAge','Database Maximum Cache Age',10,\&textinput,'0','(\d+)',undef,'Setting this value above zero, enables an internal database cache for every defined table to reduce the concurrent database queries and to prevent possible record access collisions, which could cause stucking workers on some systems<br />
  The value defines the maximum age in seconds a record will exists untouched in the table cache.<br />
  Be carefull, setting this value too high in a database replication envirionment could cause unexpected query results, because this cache is NOT shared between multiple assp instances.<br />
  If set, a value of 10 seems to be popular in any case. An too less value, will produce overhead without any advantage. An too high setting could cause the described database consistency problems.',undef,undef,'msg010020','msg010021'],
['importDBDir','import directory',40,\&textinput,'mysql/dbimport','(\S+)',undef,'The folder to import the used tables of the database from.<br />The schema of the files must be the assp-schema.<br />
Files can be:<br />
- pbdb.back.db.(add|rpl)<br />
- pbdb.batv.db.(add|rpl)<br />
- pbdb.black.db.(add|rpl)<br />
- pbdb.dkim.db.(add|rpl)<br />
- pbdb.mxa.db.(add|rpl)<br />
- pbdb.ptr.db(add|rpl)<br />
- pbdb.rbl.db.(add|rpl)<br />
- pbdb.rwl.db.(add|rpl)<br />
- pbdb.sb.db.(add|rpl)<br />
- pbdb.spf.db.(add|rpl)<br />
- pbdb.trap.db.(add|rpl)<br />
- pbdb.uribl.db.(add|rpl)<br />
- pbdb.white.db.(add|rpl)<br />
- ldaplist.(add|rpl)<br />
- redlist.(add|rpl)<br />
- whitelist.(add|rpl)<br />
- persblackdb.(add|rpl)<br />
- spamdb.(add|rpl)<br />
- spamdb.helo.(add|rpl)<br />
- delaydb.(add|rpl)<br />
- delaydb.white.(add|rpl)<br />
- adminusers.(add|rpl)<br />
- adminusersright.(add|rpl)<br />
Use the extension "add" or "rpl" to add or replace the records to the tables.<br />
Only files for database-enabled tables will be imported ! The import will be done at ASSP start or if the option below is used.<br />
Imported files will be renamed to *.OK !<br />For example: mysql/dbimport<br />
<span class="negative">If you plan to import in to BerkeleyDB - do the following:<br />
- set DisableSMTPNetworking to on
- set all needed DB parameters
- collect your import files
- restart assp and wait until all imports are finished
- restart assp
- set DisableSMTPNetworking to off </span>',undef,undef,'msg005870','msg005871'],
['preventBulkImport','Prevent Bulk Import',0,\&checkbox,'','(.*)',undef,'Do not select, if you are using MySQL! Doing a Bulk-Import of data, ASSP modifies the properties of table columnes. This could result in breaking some configured DB features like DB-replication in MSSQL. If selected, ASSP will do a line per line insert/update (which takes much more time) without modifying the tables properties.',undef,undef,'msg005880','msg005881'],
['fillUpImportDBDir','Fill the Import Folder',10,\&textinput,'','^([1-9]|L|)$','ConfigChangeRunTaskNow','If set to a value between 1 and 9, the corresponding backup file for any list/hash that configured to use a database will be copied from the backupDBDir to the importDBDir. The resulting file name will has an extension of ".rpl", so a possible import will replace the current table content. If a value of "L" is defined, the last backup will be used. Possible values are L or 1 - 9 or blank. Any configured value will be reset to blank after the copy is finished.',undef,undef,'msg008990','msg008991'],
['ImportMysqlDB','import all files from the importDBDir Directory in to the database - now.',0,\&checkbox,'','(.*)','ConfigChangeRunTaskNow',
  "All files from the \"importDBDir\" will be imported in to database $mydb. Please define the directory above, before using the import!<br />
<input type=button value=\"Run Now!\" onclick=\"document.forms['ASSPconfig'].theButtonX.value='Apply Changes';document.forms['ASSPconfig'].submit();WaitDiv();return false;\" />&nbsp;<input type=button value=\"Refresh Browser\" onclick=\"document.forms['ASSPconfig'].theButtonRefresh.value='Apply Changes';document.forms['ASSPconfig'].submit();WaitDiv();return false;\" />",undef,undef,'msg005890','msg005891'],
['exportDBDir','export directory',40,\&textinput,'mysql/dbexport','(\S+)',undef,'The folder to export the used tables of the database.<br />The schema of the files is the assp-schema.<br />Ten versions of exports are available!<br />For example: mysql/dbexport',undef,undef,'msg005900','msg005901'],
['ExportMysqlDB','export all tables from the database',0,\&checkbox,'','(.*)','ConfigChangeRunTaskNow',
  "All table of the database will be exported to the \"exportDBDir\" Directory. Please define the Directory above, before using the export!<br />
<input type=button value=\"Run Now!\" onclick=\"document.forms['ASSPconfig'].theButtonX.value='Apply Changes';document.forms['ASSPconfig'].submit();WaitDiv();return false;\" />&nbsp;<input type=button value=\"Refresh Browser\" onclick=\"document.forms['ASSPconfig'].theButtonRefresh.value='Apply Changes';document.forms['ASSPconfig'].submit();WaitDiv();return false;\" />",undef,undef,'msg005910','msg005911'],
['backupDBDir','backup directory',40,\&textinput,'mysql/dbbackup','(\S+)',undef,'The folder to backup the used tables of the database.<br />The schema of the files is the assp-schema.<br />Ten versions of backups are available!<br />For example: mysql/dbbackup',undef,undef,'msg005920','msg005921'],
['backupDBInterval','backup database Interval <sup>s</sup>',40,\&textinput,2,$ScheduleGUIRe,'configChangeSched',
  'backup the database (all tables used by assp at the time)  every this hours.<br />
  Defaults to 2 hours.',undef,undef,'msg005930','msg005931'],
['copyDBToOrgLoc','copy the last DB-backup to the original location',0,\&checkbox,'1','(.*)',undef,
  'If DB-backup is enabled, the last backupversion is also copied to the original location.<br />
  If database connections are failed, while ASSP is running, ASSP will switch over to use these files instead of DB-tables.<br />
  DB-tables will not be imported from here, this must be done from the importDBDir!',undef,undef,'msg005940','msg005941'],
['logfile','ASSP Logfile',40,\&textinput,'logs/maillog.txt','(\S*)','ConfigChangeLogfile',
  'Blank if you don\'t want a log file. Change it to maillog.log if you don\'t want auto rollover.
  NOTE: Changing this field requires restarting ASSP before changes take effect.',undef,undef,'msg005950','msg005951'],
['MaxLogAge','Max Age of Logfiles',10,\&textinput,0,'(\d+)',undef,
  'The maximum file age in days of logfiles. If a logfile is older than this number in days, the file will be deleted. Default is 0 - recommended is 30. A value of 0 disables this feature and no logfile will be deleted because of its age.',undef,undef,'msg005960','msg005961'],
['MaxLogAgeSchedule','Runtime MaxLogAge',4,\&textinput,'1','^(1?[0-9]|2[0-3])$',undef,
  'Runtime hour for deleting old logfiles. Set a number between 0 and 23. 0 means midnight, 1 is default.',undef,undef,'msg005970','msg005971'],
['pidfile','PID File',40,\&textinput,'pid','(\S+)',undef,'Blank is not a valid value!<br />
  You have to restart ASSP before you get a pid file in the new location.<br />
  This file is used to detect a clean shutdown of ASSP - in this case it does not exist at startup!
  <hr /><div class="menuLevel1">Notes On File Path</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/filepath.txt\',3);" />',undef,undef,'msg005980','msg005981'],

[0,0,0,'heading','Collecting'],
['spamaddresses','Spam Collect Addresses*',80,\&textinput,'','(.*)','ConfigMakeSLRe',
  'Mail to any of these addresses are always spam and will contribute to the spam-collection unless from someone on the whitelist. Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com). The addresses are not validated, they  are readdressed to ccallspam, however you can supersede this by putting a valid address into sendAllCollect below.',undef,undef,'msg005990','msg005991'],
['sendAllCollect','Catchall Address for Collect Addresses',20,\&textinput,'','(.*)',undef,
  'ASSP will readdress messages addressed to Collect Addresses to this address.<br />
  For example: collect@mydomain.com',undef,undef,'msg006000','msg006001'],
['DoNotBlockCollect','Use Collect Addresses for Testing Your Environment',0,\&checkbox,'','(.*)',undef,
  'If set ASSP will block messages from Collect Addresses <b>after</b> other checks are performed. That may help to test and control activated filters.',undef,undef,'msg006010','msg006011'],
['UseTrapToCollect','Use Penalty Trap Addresses To Collect',0,\&checkbox,'','(.*)',undef,
  'If set ASSP will use addresses from DoPenaltyMakeTraps and spamtrapaddresses to collect spams.',undef,undef,'msg006020','msg006021'],
['noCollecting','Do Not Collect Messages from/to these Addresses*',60,\&textinput,'','(.*)','ConfigMakeSLRe','Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com).',undef,undef,'msg006030','msg006031'],
['noCollectRe','Do Not Collect Messages - Content Based*',60,\&textinput,'','(.*)','ConfigCompileRe','If the content of a collected file (incl. X-ASSP-... headers) matches this regular expression, it will be deleted from the collection after the mail is completely processed.<br />
  If the ASSP_ARC plugin is used, the file will be deleted from the collection after it was archived. This is the only "no collect" option which removes an already collected file, all other options will prevent assp from creating a collection file - if set to "no collection". The check is limited to MaxBytes or at max 100000 Bytes.',undef,undef,'msg008930','msg008931'],
['DoNotCollectRedRe','Do Not Collect RedRe Matching Mails',0,\&checkbox,1,'(.*)',undef,
  'Mails (Spam/Ham) matching Red Regex (redRe) will not be stored in the collection folders.',undef,undef,'msg006040','msg006041'],
['DoNotCollectRedList','Do Not Collect Redlisted Mails',0,\&checkbox,'1','(.*)',undef,
  'Mails (Spam/Ham) matching  Redlist will not be stored in the collection folders.',undef,undef,'msg006050','msg006051'],
['DoNotCollectBounces','Do Not Collect Bounced Mails',0,\&checkbox,1,'(.*)',undef,
  'Mails matching &lt;Bounce Senders&gt; will not be collected.',undef,undef,'msg006060','msg006061'],
['NoMaillog','Don\'t Collect Mail',0,\&checkbox,'','(.*)',undef,
  'Check this if you\'re using Whitelist-Only and don\'t care to save mail to build the Bayesian database.',undef,undef,'msg006070','msg006071'],

['MaxFiles','Max Files',10,\&textinput,14000,'(\d+)',undef,
  'If you\'re not using subjects as file names ( UseSubjectsAsMaillogNames ), this is the maximum number of files to keep in each collection (spam &amp; nonspam)<br />
  It\'s actually less than this -- files get a random number between 1 and MaxFiles.',undef,undef,'msg006080','msg006081'],
['FilesDistribution','Files Distribution',4,\&textinput,1,'(0\.\d?[1-9]+|1)',undef,
  'This defines how file names are chosen in each collection. If set to 1, names are uniformly distributed. If set between 0.01 and 0.99, names distribution is exponential -- files get lower numbers more frequently. This prevents from corpus being refreshed too quickly, especially when MaxFiles is set to low value (ex. 3000)<br />
 Recommended: 0.5, Default: 1',undef,undef,'msg006090','msg006091'],
['UseSubjectsAsMaillogNames','Use Subject as Maillog Names',0,\&checkbox,'1','(.*)','ConfigChangeUSAMN',
  'You can turn this on to help you manually identify mail in your spam and non-spam collections. This will prevent ASSP from controlling the number of files in your collections(-> MaxFiles ). It is recommended to switch on MaintBayesCollection and to setup MaxNoBayesFileAge to your needs, if you have switched on this option.',undef,undef,'msg006100','msg006101'],
['MaxAllowedDups','Max Number of Duplicate File Names',5,\&textinput,5,'(\d+)','ConfigChangeMaxAllowedDups',
  'The maximum number of logged files with the same filename (subject) that are stored in the spam folder (spamlog), if UseSubjectsAsMaillogNames is selected. Default is 0. A low value reduces the number of possibly duplicate mails, assuming that mails with the same subject will have the same content. A value of 0 disables this feature. If this number of files with the same filename is reached, the oldest file with the same subject will be moved to the discarded folder, which has to be defined ( in addition to spamlog ) for this feature to work.', undef, undef,'msg008660','msg008661'],
['AllowedDupSubjectRe','Regular Expression to Identify allowed duplicate Subjects*',80,\&textinput,'','(.*)','ConfigCompileRe','Messages their subject matches this regular expression will be collected regardless the setting in MaxAllowedDups .',undef,undef,'msg008670','msg008671'],
['UseUnicode4MaillogNames','Use Unicode to build Maillog Names',0,\&checkbox,'','(.*)',undef,
  'If you have switched on UseSubjectsAsMaillogNames and your default (local language) characterset (please setup ConsoleCharset) needs 8 Bit like "KOI8-r","CP-866","Windows-1251","Windows-1252","ISO-8859-X","X-Mac-Cyrillic","JIS_X0201" or any other (or is UTF-8) - and you want to have readable filenames in the maillog and on the console screen, you can switch on this option. The resolution of some characters written to the console could be incorrect depending on your operating system. This requires an installed <a href="http://search.cpan.org/search?query=Email::MIME" rel="external">Email::MIME</a> module in PERL.<br />
  If in addition the module <a href="http://search.cpan.org/search?query=Win32::Unicode" rel="external">Win32::Unicode</a> is installed on windows plattforms, assp will generate unicode filenames for the collected corpus files (already on nix systems).',undef,undef,'msg006110','msg006111'],
['UseUnicode4SubjectLogging','Use Unicode to build Subjects in Maillog',0,\&checkbox,'','(.*)',undef,
  'If you have switched on UseUnicode4SubjectLogging and your default (local language) characterset (please setup ConsoleCharset) needs 8 Bit like "KOI8-r","CP-866","Windows-1251","Windows-1252","ISO-8859-X","X-Mac-Cyrillic","JIS_X0201" or any other (or is UTF-8) - and you want to have a readable subject in the maillog and on the console screen, you can switch on this option. The resolution of some characters written to the console could be incorrect depending on your operating system. This requires an installed <a href="http://search.cpan.org/search?query=Email::MIME" rel="external">Email::MIME</a> module in PERL.',undef,undef,'msg008920','msg008921'],
['MaxFileNameLength','Max Length of File Names',10,\&textinput,50,'(\d+)',undef,
  'The maximum character count that is used from the mail subject to build the file name of the logged file, if UseSubjectsAsMaillogNames is selected. This could be useful, if your mail clients having trouble to build the resend file name (right button - URL) correctly in block reports. Every non printable character will be replaced by a 4 byte string in this link.',undef,undef,'msg006130','msg006131'],
['MaintBayesCollection','Maintenance for Bayesian Collection',0,\&checkbox,'1','(.*)',undef,
  'Set this to on, if you want ASSP to run a maintenance tasks on the bayesian collection folders ( spamlog , notspamlog , correctedspam , correctednotspam ). ASSP will delete the oldest files until the number of files per folder reaches MaxFiles. If you want ASSP to delete files because of their age instead of the number of files ( MaxFiles ), setup MaxBayesFileAge and/or MaxCorrectedDays to your needs.<br />
  MaintBayesCollection is useful, if UseSubjectsAsMaillogNames is set to on and doMove2Num is set to off, because in this case the number of files in every collection folder will grow infinite. If set to On, the rebuildspamdb task will also do the cleanup.',undef,undef,'msg006140','msg006141'],
['MaxBayesFileAge','Max Age of Bayes Files',15,\&textinput,31,'^(\d+|\d+\s+\d+)$',undef,
  'The maximum file age in days of every file in every bayesian collection folder ( spamlog , notspamlog ). If MaintBayesCollection is set to on and a file is older than this number in days, the file will be deleted. Default is 31. A value of 0 disables this feature and no file will be deleted because of its age. To use different values for spamlog and notspamlog, define two space separated values - the first for spamlog and the second for notspamlog, like \'30 60\'. The rebuildspamdb task will ignore files older than this days (if not zero).<br />
  <span class = "negative">It is not recommended to enable this option, if you use the bayesian engine of ASSP and doMove2Num is set to ON.  A better solution in this case is, to have MaintBayesCollection take care of deletions (by date) and change this setting to 0.</span>',undef,undef,'msg006150','msg006151'],
['MaxCorrectedDays','Max Corrected File Age',15,\&textinput,'1000','^(\d+|\d+\s+\d+)$',undef,'This is the number of days a error report will be kept in the correctedspam and correctednotspam folders. These folders are the longterm memory of ASSP, therefore the default is 1000 days. To use different values for correctedspam and correctednotspam, define two space separated values - the first for correctedspam and the second for correctednotspam, like \'1000 1500\'. The rebuildspamdb task will ignore files older than this days (if not zero).',undef,undef,'msg008590','msg008591'],
['MaxNoBayesFileAge','Max Age of non Bayes Files',15,\&textinput,31,'^(\d+|\d+\s+\d+\s+\d+)$',undef,
  'The maximum file age in days of every file in every non bayesian collection folder ( incomingOkMail , discarded , viruslog ). If defined and a file is older than this number in days, the file will be deleted. Default is 31. A value of 0 disables this feature and no file will be deleted because of its age. To use different values for incomingOkMail and discarded and viruslog, define three space separated values - the first for incomingOkMail and the second for discarded and the third for viruslog, like \'31 45 60\'',undef,undef,'msg006160','msg006161'],
['MaxFileAgeSchedule','Runtime for MaintBayesCollection and MaxNoBayesFileAge <sup>s</sup>',40,\&textinput,'1',$ScheduleGUIRe,'configChangeSched',
  'Runtime hour for deleting old collected files (bayes and non bayes). Set a number between 0 and 23. 0 means midnight, 1 is default. If empty a cleanup will not be scheduled. This could be fine, if a rebuildspamdb is scheduled, which will also do the cleanup based on the settings of MaintBayesCollection , MaxBayesFileAge and MaxCorrectedDays - but it will not maintain incomingOkMail , discarded and viruslog based on MaxNoBayesFileAge !',undef,undef,'msg006170','msg006171'],
['MaxBytes','Max Bytes',10,\&textinput,4000,'(\d+)',undef,
  'How many bytes of the message body will ASSP look at - the message header is always included in all checks? Mails stored in the collecting folders will be truncated to this size. The average of Ham messages (message body) is 6K, the average of Spam messages is 3K. Usually the spam folder will be filled quicker than the notspam folder, therefore set this value to 4000 to get more wordpairs per Ham Message. When both folders are close to the maxfiles limit, reduce it to 3000.',undef,undef,'msg006180','msg006181'],
['StoreCompleteMail','Store the Complete Mail','0:disabled|100000:up to 100 kByte|500000:up to 500 kByte|1000000:up to 1 MByte|10000000:up to 10 MByte|999999999:no limit',\&listbox,999999999,'(\d*)',undef,
  'If set, ASSP will look at MaxBytes, but if possible it will store the complete mail up to the number of bytes configured. This could be useful for example, if you want resend blocked messages. Be carefull using this option, your disk could be filled up very fast!',undef,undef,'msg006190','msg006191'],
['MaxBytesReports','Error Max Bytes',10,\&textinput,10000,'(\d+)',undef,'How many bytes of an error report message will ASSP look at. For example: 10000. Set this to zero for no limit.',undef,undef,'msg006200','msg006201'],
['NonSpamLog','Non Spam','0:no collection|2:notspam folder',\&listbox,2,'(\d*)',undef,'Where to store whitelisted/local non spam messages. Default: notspam folder ( notspamlog ).',undef,undef,'msg006210','msg006211'],
['baysNonSpamLog','OK Mail','0:no collection|2:notspam folder|4:okmail folder',\&listbox,0 ,'(\d*)',undef,'Where to store non spam (message ok) messages. These are messages which are considered as HAM, but should not stored in the standard HAM folder because of our policy to use only confirmed HAM messages (whitelisted or local) for SpamDB. Set incomingOkMail accordingly if you choose \'okmail folder\'. Default: no collection',undef,undef,'msg006220','msg006221'],
['SpamLog','Store Spam','0:disabled|1:enabled',\&listbox,1,'(\d*)',undef,'Set this to \'disabled\' if you do not want to store any Spam regardless of settings in. Default: enabled (store in folder spamlog ).',undef,undef,'msg006230','msg006231'],
['noProcessingLog','NoProcessing OK Mails','0:no collection|4:okmail folder',\&listbox,0,'(\d*)',undef,'Where to store noprocessing OK mails.',undef,undef,'msg006240','msg006241'],
['npAttachLog','NoProcessing rejected Attachments','0:no collection|5:attachment folder|6:discard folder|7:discard folder &amp; sendAllSpam',\&listbox,7,'(\d*)',undef,'Where to store noprocessing rejected mail+attachments. Recommended: discard folder ( discarded ) &amp; sendAllSpam',undef,undef,'msg006250','msg006251'],
['wlAttachLog','Whitelisted rejected Attachments','0:no collection|5:attachment folder|6:discard folder|7:discard folder &amp; sendAllSpam',\&listbox,7,'(\d*)',undef,'Where to store whitelisted rejected mail+attachments. Recommended: discard folder ( discarded ) &amp; sendAllSpam',undef,undef,'msg006260','msg006261'],
['extAttachLog','External rejected Attachments','0:no collection|5:attachment folder|6:discard folder|7:discard folder &amp; sendAllSpam',\&listbox,7,'(\d*)',undef,'Where to store external rejected mail+attachments. Recommended: discard folder ( discarded ) &amp; sendAllSpam',undef,undef,'msg006270','msg006271'],
['SpamVirusLog','Virus Infected','0:no collection|5:quarantine|6:discard folder|7:discard folder &amp; sendAllSpam',\&listbox,5,'(\d*)',undef,'Where to store virus infected messages. Recommended: quarantine ( quarantine )',undef,undef,'msg006280','msg006281'],
['spamBombLog','Spam Bombs','0:no collection|1:spam folder|3:spam folder &amp; sendAllSpam|6:discard folder|7:discard folder &amp; sendAllSpam',\&listbox,6,'(\d*)',undef,'Where to store spam bombs. Recommended: discard folder ( discarded )',undef,undef,'msg006290','msg006291'],
['scriptLog','Scripts','0:no collection|1:spam folder|3:spam folder &amp; sendAllSpam|6:discard folder|7:discard folder &amp; sendAllSpam',\&listbox,3,'(\d*)',undef,'Where to store scripted messages. Recommended: spam folder   ( spamlog )  &amp; sendAllSpam',undef,undef,'msg006300','msg006301'],

['blDomainLog','Blacklisted Domains','0:no collection|1:spam folder|3:spam folder &amp; sendAllSpam|6:discard folder|7:discard folder &amp; sendAllSpam',\&listbox,3,'(\d*)',undef,'Where to store blacklisted domain messages. Recommended: spam folder ( spamlog ) &amp; sendAllSpam',undef,undef,'msg006310','msg006311'],
['spamHeloLog','Blacklisted Helos','0:no collection|1:spam folder|3:spam folder &amp; sendAllSpam|6:discard folder|7:discard folder &amp; sendAllSpam',\&listbox,7,'(\d*)',undef,'Where to store spam helo messages. Recommended: discard folder ( discarded ) &amp; sendAllSpam',undef,undef,'msg006320','msg006321'],
['forgedHeloLog','Forged Helos','0:no collection|1:spam folder|3:spam folder &amp; sendAllSpam|6:discard folder|7:discard folder &amp; sendAllSpam',\&listbox,0,'(\d*)',undef,'Where to store forged helo messages. Recommended: no collection',undef,undef,'msg006330','msg006331'],
['invalidHeloLog','Invalid Helos','0:no collection|1:spam folder|3:spam folder &amp; sendAllSpam|6:discard folder|7:discard folder &amp; sendAllSpam',\&listbox,6,'(\d*)',undef,'Where to store invalid helo messages. Recommended: discard folder ( discarded )',undef,undef,'msg006340','msg006341'],
['spamBucketLog','Spam Collect Addresses','0:no collection|1:spam folder|3:spam folder &amp; sendAllSpam|6:discard folder|7:discard folder &amp; sendAllSpam',\&listbox,1,'(\d*)',undef,'Where to store mails addressed to Spam Collect Addresses. Recommended: spam folder ( spamlog )',undef,undef,'msg006350','msg006351'],
['baysSpamLog','Bayesian Spams','0:no collection|1:spam folder|3:spam folder &amp; sendAllSpam|6:discard folder|7:discard folder &amp; sendAllSpam',\&listbox,7,'(\d*)',undef,'Where to store Bayesian spam messages. Recommended: discard folder ( discarded ) &amp; sendAllSpam',undef,undef,'msg006360','msg006361'],
['SPFFailLog','SPF Failures','0:no collection|1:spam folder|3:spam folder &amp; sendAllSpam|6:discard folder|7:discard folder &amp; sendAllSpam',\&listbox,3,'(\d*)',undef,'Where to store SPF Failure spam messages. Recommended: spam folder ( spamlog ) &amp; sendAllSpam',undef,undef,'msg006370','msg006371'],
['RBLFailLog','DNSBL Failures','0:no collection|1:spam folder|3:spam folder &amp; sendAllSpam|6:discard folder|7:discard folder &amp; sendAllSpam',\&listbox,3,'(\d*)',undef,'Where to store DNSBL Failure spam messages. Recommended: spam folder ( spamlog ) &amp; sendAllSpam',undef,undef,'msg006380','msg006381'],
['URIBLFailLog','URIBL Failures','0:no collection|1:spam folder|3:spam folder &amp; sendAllSpam|6:discard folder|7:discard folder &amp; sendAllSpam',\&listbox,3,'(\d*)',undef,'Where to store URIBL Failure spam messages. Recommended: spam folder ( spamlog ) &amp; sendAllSpam',undef,undef,'msg006390','msg006391'],
['SRSFailLog','SRS Failures','0:no collection|1:spam folder|3:spam folder &amp; sendAllSpam|6:discard folder|7:discard folder &amp; sendAllSpam',\&listbox,3,'(\d*)',undef,'Where to store SRS Failure (not signed bounces) spam messages. Recommended: spam folder ( spamlog ) &amp; sendAllSpam',undef,undef,'msg006400','msg006401'],
['spamPTRLog','Missing/Invalid Pointer ','0:no collection|1:spam folder|3:spam folder &amp; sendAllSpam|6:discard folder|7:discard folder &amp; sendAllSpam',\&listbox,3,'(\d*)',undef,'Where to store Missing/Invalid Pointer rejected messages. Recommended: spam folder ( spamlog ) &amp; sendAllSpam',undef,undef,'msg006410','msg006411'],
['spamMXALog','Missing MX Record ','0:no collection|1:spam folder|3:spam folder &amp; sendAllSpam|6:discard folder|7:discard folder &amp; sendAllSpam',\&listbox,3,'(\d*)',undef,'Where to store Missing MX record rejected messages. Recommended: spam folder ( spamlog ) &amp; sendAllSpam',undef,undef,'msg006420','msg006421'],
['spamISLog','Invalid Local Sender','0:no collection|1:spam folder|3:spam folder &amp; sendAllSpam|6:discard folder|7:discard folder &amp; sendAllSpam',\&listbox,0,'(\d*)',undef,'Where to store messages from a local domain with an unknown userpart. Recommended: no collection',undef,undef,'msg006430','msg006431'],
['spamSBLog','Blocked Country','0:no collection|1:spam folder|3:spam folder &amp; sendAllSpam|6:discard folder|7:discard folder &amp; sendAllSpam',\&listbox,3,'(\d*)',undef,'Where to store messages from a blocked country. Recommended: spam folder ( spamlog ) &amp; sendAllSpam',undef,undef,'msg006440','msg006441'],
['spamMSLog','Message Limit Blocks','0:no collection|1:spam folder|3:spam folder &amp; sendAllSpam|6:discard folder|7:discard folder &amp; sendAllSpam',\&listbox,3,'(\d*)',undef,'Where to store Message Scoring Limit rejected messages. Recommended: spam folder ( spamlog ) &amp; sendAllSpam',undef,undef,'msg006450','msg006451'],
['spamPBLog','PenaltyBox Blocks','0:no collection|1:spam folder|3:spam folder &amp; sendAllSpam|6:discard folder|7:discard folder &amp; sendAllSpam',\&listbox,3,'(\d*)',undef,'Where to store PB rejected messages. Recommended: spam folder ( spamlog ) &amp; sendAllSpam',undef,undef,'msg006460','msg006461'],

['DKIMLog','DKIM failed','0:no collection|1:spam folder|3:spam folder &amp; sendAllSpam|6:discard folder|7:discard folder &amp; sendAllSpam',\&listbox,3,'(\d*)',undef,'Where to store DKIM rejected messages. Recommended: spam folder ( spamlog ) &amp; sendAllSpam',undef,undef,'msg006470','msg006471'],
['BackLog','Backscatter check failed','0:no collection|1:spam folder|3:spam folder &amp; sendAllSpam|6:discard folder|7:discard folder &amp; sendAllSpam',\&listbox,6,'(\d*)',undef,'Where to store backscatter (MSGID-signing, BATV, DNS-Backscatter) rejected messages. Recommended: no collection',undef,undef,'msg006480','msg006481'],
['freqNonSpam','Non Spam Collection Frequency',5,\&textinput,1,'(\d*)','updateLog2','Store every n\'th non spam message. If you set the value to 10 then every 10th message is logged. These frequency settings are for ASSP users with a mature installation who experience heavy mail or spam volumes. Enter a larger value if the non spam corpus is being refreshed too quickly. Default Value = 1, log every message. Leave it at the default value 1, if you use BlockReports.',undef,undef,'msg006490','msg006491'],
['freqSpam','Spam Collection Frequency',5,\&textinput,1,'(\d*)','updateLog3','Store every n\'th spam message. The same as for non spam but helps prevent spam corpuses being skewed by flooding. It is recommended that this be set depending on spam volume. Default value = 1, log every message. Leave it at the default value 1, if you use BlockReports.<br /><hr /><div class="menuLevel1">Notes On Collecting</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/collecting.txt\',3);" />',undef,undef,'msg006500','msg006501'],

[0,0,0,'heading','Logging'],
['Notify','Notification Email To',80,\&textinput,'','('.$EmailAdrRe.'\@'.$EmailDomainRe.')?',undef,
  'Email address(es) to which you want ASSP to send a notification email per default, if a matching log entry ( NotifyRe , NoNotifyRe ) is found. Separate multiple entries by "|".',undef,undef,'msg006510','msg006511'],
['NotifyRe','Do Notify, if log entry matches*',60,\&textinput,'','(.*)','ConfigCompileNotifyRe','Regular Expression to identify loglines for which a notification message should be send.<br />
  useful entries are:<br />
  Info: new assp version - to get informed about new available assp versions<br />
  info: autoupdate: new assp version - to get informed about an autoupdate of the running script<br />
  adminupdate: - for config changes<br />
  admininfo: - for admin information<br />
  option list file: - for option file reload<br />
  error: - for any error<br />
  warning: - for any warning<br />
  restart - to detect a ASSP restart<br />
  notification: too many recipients - for local frequency abuse once per day and sender<br />
  warning: too many recipients - for every local frequency abuse<br />
  MainThread started - to detect a start of ASSP<br />
  Admin connection - for GUI logon<br /><br />
  You may define a comma separated list (after \'=>\') of recipients in every line, this will override the default recipient defined in \'Notify\'.<br />
  for example: adminupdate:=>user1@yourdomain.com,user2@yourdomain.com.<br />
  As third parameter after a second (\'=>\') you can define the subject line for the notification message.<br />
  for example: adminupdate:=>user1@yourdomain.com,user2@yourdomain.com=>configuration was changed<br />
  or: adminupdate:=>=>configuration was changed.',undef,undef,'msg006520','msg006521'],
['NoNotifyRe','Do NOT Notify, if log entry matches*',60,\&textinput,'','(.*)','ConfigCompileRe','Regular Expression to identify loglines for which no notification message should be send.<br />
  for example:<br />
  user root - if root does anything<br />
  \[root.*?\] - if root changes the config',undef,undef,'msg006530','msg006531'],
['fileLogging','File name logging',0,\&checkbox,'','(.*)',undef,'Show file names of collected spam/notspam in log. Will be automaticly set to on, if inclResendLink is not set to disabled.',undef,undef,'msg006540','msg006541'],
['subjectLogging','Subject logging',0,\&checkbox,1,'(.*)',undef,'Show subject of mail in log ',undef,undef,'msg006550','msg006551'],
['subjectStart','Subject Start Delimiter',2,\&textinput,'[','(.*)',undef,'Start delimiter of subject in log ',undef,undef,'msg006560','msg006561'],
['subjectEnd','Subject End Delimiter',2,\&textinput,']','(.*)',undef,'End delimiter of subject in log',undef,undef,'msg006570','msg006571'],
['regexLogging','Regex Match logging',0,\&checkbox,1,'(.*)',undef,'Show matching regex in log, note that all lists (like eg. noprocessing-list) are used as regex. ',undef,undef,'msg006580','msg006581'],
['WorkerLogging','Worker logging',0,\&checkbox,1,'(.*)',undef,'Show Workername in Log. ',undef,undef,'msg006590','msg006591'],
['ipmatchLogging','IP Matches Logging',0,\&checkbox,'','(.*)',undef,
  'Enables logging of IP addresses matches in the maillog. Will show a comment instead of the range if there is text after the IP ranges (and before any numbersign)  eg. 182.82.10.0/24 AOL',undef,undef,'msg006600','msg006601'],
['slmatchLogging','Logging Address Matches',0,\&checkbox,'','(.*)',undef,
  'Enables logging of address matches in the maillog.',undef,undef,'msg006610','msg006611'],
['AddRegexHeader','Add RegEx Match Header',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg006620','msg006621'],
['uniqeIDLogging','Unique ID logging',0,\&checkbox,1,'(.*)',undef,'Add unique string to log  ',undef,undef,'msg006630','msg006631'],
['uniqueIDPrefix','Prepend Unique ID logging',10,\&textinput,'m1-','(.*)',undef,
  'Prepend ID. For example: m1-',undef,undef,'msg006640','msg006641'],
['tagLogging','Spam Tag Logging',0,\&checkbox,1,'(.*)',undef,'Add spam tag to log.',undef,undef,'msg006650','msg006651'],

['replyLogging','SMTP Status Code Reply Logging','0:disabled|1:enabled - exclude [123]XX|2:enabled - all',\&listbox,1 ,'(\d*)',undef,undef,undef,undef,'msg006660','msg006661'],
['expandedLogging','Logging Records include IP & MailFrom',0,\&checkbox,1,'(.*)',undef,'',undef,undef,'msg006670','msg006671'],

['sysLog','SYSLOG Centralized Logging',0,\&checkbox,'','(.*)','ConfigChangeSysLog','Enables logging to UNIX or Network Syslog. Needs Sys::Syslog for local (UNIX/LINUX) logging.',undef,undef,'msg006680','msg006681'],
['sysLogPort','Syslog Port (UDP)',5,\&textinput,'514','(\d*)','ConfigChangeSysLog',
  'Port for Network Syslog logging.',undef,undef,'msg006690','msg006691'],
['SysLogFac','Syslog Facility',40,\&textinput,'mail','(\S*)','ConfigChangeSysLog',
  'Syslog Facility. Valid are kern, user, mail, daemon, auth, syslog, lpr, news, uucp, cron, authpriv, ftp, local0, local1, local2, local3, local4, local5, local6',undef,undef,'msg006700','msg006701'],
['sysLogIp','Syslog IP',40,\&textinput,'','^(' . $HostRe .'|)$','ConfigChangeSysLog',
  'IP Address or hostname of your Network Syslog Daemon for Syslog logging.',undef,undef,'msg006710','msg006711'],
['asspLog','ASSP local logging',0,\&checkbox,'1','(.*)',undef,'ASSP manages local logging. The logs (logfile) are stored inside the directory where ASSP is installed.',undef,undef,'msg006720','msg006721'],
['LogRollDays','Roll the Logfile How Often?',5,\&textinput,'1','([1-9]\d*)',undef,
  'ASSP closes and renames the log file after this number of days.',undef,undef,'msg006730','msg006731'],
['LogNameMMDD','No Year in LogName',0,\&checkbox,'','(.*)',undef,'The standard name for the logfile is YY-MM-DD.maillog.txt, use this option to set it to MM-DD.maillog.txt',undef,undef,'msg006740','msg006741'],
['LogDateFormat','Date/Time Format in LogDate',30,\&textinput,'MMM-DD-YY hh:mm:ss','((?:(?:MM|MMM|DD|DDD|YY|YYYY)(?:[\_\-\. \/]|)){3}(?:[\-\_ ]*)(?:(?:hh|mm|ss)(?:[\.:\-\_]|)){3})',undef,'Use this option to set the logdate. The default value is \'MMM-DD-YY hh:mm:ss\'. The following (case sensitive !) replacements will be done:<br /><br />
 YYYY - year four digits<br />
 YY - year two digits<br />
 MMM - month (three charactes) alpha numeric - like Oct Nov Dec<br />
 MM - month numeric two digits<br />
 DDD - day (three charactes) alpha numeric - like Mon Tue Fri<br />
 DD - day numeric two digits<br />
 hh - hour two digits<br />
 mm - minute two digits<br />
 ss - second two digits<br /><br />
 <span class="positive">A value has to be defined for every part of the date/time, the date must be the first part. Allowed separators in date part are \'_ -./\' - in time part \'-_.:\' .</span>',undef,undef,'msg008690','msg008691'],
['LogDateLang','Date/Time Language','0:English|1:Franais|2:Deutsch|3:Espaol|4:Portugus|5:Nederlands|6:Italiano|7:Norsk|8:Svenska|9:Dansk|10:suomi|11:Magyar|12:polski|13:Romaneste',\&listbox,0,'(.*)',undef,
  'Select the language for the day and month if LogDateFormat contains DDD and/or MMM.',undef,undef,'msg008700','msg008701'],
['silent','Silent Mode',0,\&checkbox,'','(.*)',undef,
  'Checked means don\'t print log messages to the console. AsADaemon overrides this.',undef,undef,'msg006750','msg006751'],
['debug','General Debug Mode',0,\&checkbox,'','(.*)','ConfigDEBUG',
  'Checked sends debugging info to a .dbg file. Debug is enabled for all Threads, all the time! debugIP and debugRE will be ignored!
  Leave this unchecked unless there is a program error you are trying to track down.',undef,undef,'msg006760','msg006761'],
['debugIP','Debug these IPs*',40,\&textinput,'','(\S*)','ConfigMakeIPRe',
  'Enter IP addresses that you want to be debugged, separated by pipes (|). The local and the remote IP of the connection will be checked!<br />
  Not blank sends debugging info to a .dbg file. Leave this blank unless there is a program error you are trying to track down.<br />
  This can be IP address of the SMTP service monitoring agent. For example:  127.0.0.1|172.16.',undef,'7','msg006770','msg006771'],
['debugRe', 'Regular Expression to Identify Debug-Messages*',80,\&textinput,'','(.*)','ConfigCompileRe',
 'Put anything here to identify messages that you want to be debugged.  Not blank sends debugging info to a .dbg file. Leave this blank unless there is a program error you are trying to track down.',undef,undef,'msg006780','msg006781'],
['debugCode', 'Run this Code to switch on Debug',80,\&textinput,'','(.*)',undef,
 'Put a code line here, to detect messages that you want to debug. The code line has to return 0 or 1. A return of 1 will switch on debug.<br />
  for example:<br /><br />
  $Con{$fh}->{isbounce}<br />
  This code line will switch on debug for all bounce messages.<br /><br />
  ($Con{$fh}->{relayok} && $Con{$fh}->{isbounce})<br />
  This code line will switch on debug for all outgoing bounce messages.<br /><br />
  ($Con{$fh}->{ispip} && $Con{$fh}->{cip} =~ /^193\.2\.1\./)<br />
  This code line will switch on debug if the messages is from ISP and the IP of the server that was connected to the ISP begins with 193.2.1. .<br /><br />
  To use this option, you need to know the internal ASSP variables and their usage!',undef,undef,'msg006790','msg006791'],
['debugNoWriteBody','Do not write Body to Debug',0,\&checkbox,'','(.*)',undef,'If selected, the sent message body data will not be written to the debug file.',undef,undef,'msg006800','msg006801'],
['DataBaseDebug','Database Connection Debug Mode',0,\&checkbox,'','(.*)',undef,'Select to debug the database connections!',undef,undef,'msg006810','msg006811'],
['ConTimeOutDebug','Connection Timeout Debug Mode',0,\&checkbox,'','(.*)',undef,'Select to debug SMTP connections that are running in to timeout!',undef,undef,'msg006820','msg006821'],
['IgnoreMIMEErrors','Ignore MIME Errors',0,\&checkbox,1,'(.*)',undef,'If selected - Errors, based on wrong email MIME contents, will not be written to log!',undef,undef,'msg006830','msg006831'],
['noLog','Don\'t Log these IPs*',40,\&textinput,'','(\S*)','ConfigMakeIPRe',
  'Enter IP addresses that you don\'t want to be logged, separated by pipes (|). The local and the remote IP of the connection will be checked!<br />
  This can be IP address of the SMTP service monitoring agent. For example:  127.0.0.1|172.16.',undef,'7','msg006840','msg006841'],
['noLogRe', 'Regular Expression to Identify NoLog-Messages*',80,\&textinput,'','(.*)','ConfigCompileRe',
 'Put anything here to identify messages that you don\'t want to be logged.',undef,undef,'msg006850','msg006851'],
['allLogRe', 'Regular Expression to Identify Messages from/to Problematic Addresses *',80,\&textinput,'','(.*)','ConfigCompileRe',
 'Put anything here to identify messages from/to addresses you want to look at for problem solving. Messages identified will also be set to StoreCompleteMail.',undef,undef,'msg006860','msg006861'],
['noLogLineRe', 'Regular Expression to Identify skipped Log Lines*',80,\&textinput,'','(.*)','ConfigCompileRe',
 'Put anything here to identify log Lines that you don\'t want to be logged.',undef,undef,'msg008680','msg008681'],
['ConnectionLog','Connections Logging','0:nolog|1:standard|2:verbose|3:diagnostic',\&listbox,0,'(.*)',undef,
  '',undef,undef,'msg006870','msg006871'],
['SessionLog','Session Limit Logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  '',undef,undef,'msg006880','msg006881'],
['denySMTPLog','Enables Logging for \'Deny SMTP Connections From\'','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,'',undef,undef,'msg006890','msg006891'],
['RWLLog','Enable RWL logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  '',undef,undef,'msg006900','msg006901'],
['LDAPLog','Enable LDAP logging','0:nolog|1:standard|2:verbose|3:diagnostic',\&listbox,1,'(.*)',undef,
  'ATTENTION: diagnostic will possibly write credital information in clear text to the log!',undef,undef,'msg006910','msg006911'],
['VRFYLog','Enable VRFY logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  '',undef,undef,'msg006920','msg006921'],
['ValidateUserLog','Enable User Validation logging','0:nolog|1:standard|2:verbose|3:diagnostic',\&listbox,1,'(.*)',undef,
  '',undef,undef,'msg006930','msg006931'],
['PenaltyLog','Enable PenaltyBox logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(\d*)',undef,
  '',undef,undef,'msg006940','msg006941'],
['PenaltyExtremeLog','Enable PenaltyBox logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(\d*)',undef,
  '',undef,undef,'msg006950','msg006951'],
['MessageLog','Enable Message Scoring logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  '',undef,undef,'msg006960','msg006961'],
['MSGIDsigLog','Enable Message-ID signing logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  '',undef,undef,'msg006970','msg006971'],
['BacksctrLog','Enable DNS-Backscatter detection logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  '',undef,undef,'msg006980','msg006981'],
['BATVLog','Enable BATV logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  '',undef,undef,'msg006990','msg006991'],
['ValidateSenderLog','Enable Validate Sender Logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  '',undef,undef,'msg007000','msg007001'],
['SenderBaseLog','Enable SenderBase Logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  '',undef,undef,'msg007010','msg007011'],
['DelayLog','Enable Greylisting/Delaying logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  '',undef,undef,'msg007020','msg007021'],
['BombLog','Enable Bomb logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  'If set to verbose, the reporting to the logfile and the X-ASSP- scoring header will show the complete list of all hits. Otherwise only the highest match will be shown.',undef,undef,'msg007030','msg007031'],
['AttachmentLog','Enable Attachment logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  '',undef,undef,'msg007040','msg007041'],
['SPFLog','Enable SPF logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  '',undef,undef,'msg007050','msg007051'],
['RBLLog','Enable DNSBL logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  '',undef,undef,'msg007060','msg007061'],
['URIBLLog','Enable URIBL logging','0:nolog|1:standard|2:verbose|3:diagnostic',\&listbox,1,'(.*)',undef,
  '',undef,undef,'msg007070','msg007071'],
['ScanLog','Enable ClamAV logging','0:nolog|1:standard|2:verbose|3:diagnostic',\&listbox,1,'(.*)',undef,
  '',undef,undef,'msg007080','msg007081'],
['DKIMlogging','Enable DKIM logging','0:nolog|1:standard|2:verbose|3:diagnostic',\&listbox,1,'(.*)',undef,
  '',undef,undef,'msg007090','msg007091'],
['WorkerLog','Enable thread action logging','0:nolog|1:standard|2:verbose|3:diagnostic',\&listbox,0,'(.*)',undef,
  '',undef,undef,'msg007100','msg007101'],
['SignalLog','Enable central Perl-signal logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  'nolog will handle the Perl signals without any output, standard will write a message to log, verbose will write a message to log and to file debugSignal.txt',undef,undef,'msg007110','msg007111'],
['BayesianLog','Enable Bayesian Logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  'Enables verbose logging of  Bayesian checks in the maillog.',undef,undef,'msg007120','msg007121'],
['ConvLog','Enable Conversion logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  '',undef,undef,'msg007130','msg007131'],
['MaintenanceLog','Enable Maintenance logging','0:nolog|1:standard|2:verbose|3:diagnostic',\&listbox,1,'(.*)',undef,
  '',undef,undef,'msg007140','msg007141'],
['PerformanceLog','Enable Performance logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  '',undef,undef,'msg007150','msg007151'],
['ReportLog','Enable Report logging','0:nolog|1:standard|2:verbose|3:diagnostic',\&listbox,1,'(.*)',undef,
  '',undef,undef,'msg007160','msg007161'],
['ScheduleLog','Enable Scheduler logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  '',undef,undef,'msg007170','msg007171'],
['SNMPLog','Enable SNMP logging','0:nolog|1:standard|2:verbose|3:diagnostic',\&listbox,1,'(.*)',undef,
  '',undef,undef,'msg009420','msg009421'],
['Showmaxreplies','Show All Possible Hits ',0,\&checkbox,'','(.*)',undef,
  'Show hits until maxreplies instead of stopping at maxhits (RBL,URIBL,RWL).',undef,undef,'msg007180','msg007181'],
['RegExLength','RegEx Length in Log',2,\&textinput,32,'(\d*)',undef,
  'Defines how many bytes of a matching Regular Expression will be shown in the log<br />
  Some matching Regular Expressions are too long for one line. Default: 32',undef,undef,'msg007190','msg007191'],
['sendNoopInfo','Send NOOP Info',0,\&checkbox,'','(.*)',undef,
  'Checked means you want ASSP to send a "NOOP Connection from $ip" message to your SMTP server.
  <br /><hr />
  <div class="menuLevel1">Notes On Logging</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/logging.txt\',3);" />',undef,undef,'msg007200','msg007201'],

[0,0,0,'heading','LDAP Setup <a href="http://apps.sourceforge.net/mediawiki/assp/index.php?title=LDAP" target=wiki><img height=12 width=12 src="' . $wikiinfo . '" alt="LDAP" /></a>'],
['LDAPHost','LDAP Host(s)',80,\&textinput,'localhost','^((?:(?:'.$HostRe.'|'.$HostPortRe.')(?:\|(?:'.$HostRe.'|'.$HostPortRe.'))*)|)$','updateLDAPHost','Enter the DNS-name(s) or IP address(es) of the server(s) that run(s) the <a href="http://ldap.perl.org/FAQ.html">LDAP</a> database. Second entry is backup. For example: localhost. Separate entries with pipes: LDAP-1.domain.com|LDAP-2.domain.com . To use a different than the default LDAP port, define host:port.' ,undef,undef,'msg007210','msg007211'],
['DoLDAPSSL','Use SSL with LDAP (ldaps)','0:no|1:SSL|2:TLS',\&listbox,'0','(.*)',undef,'ASSP will use \'ldaps (SSL port 636)\' instead of ldap (port 389) or \'ldaps (TLS over port 389)\'. The Perl module <a href="http://search.cpan.org/search?query=IO::Socket::SSL" rel="external">IO::Socket::SSL</a> must be installed to use SSL or TLS!',undef,undef,'msg007220','msg007221'],
['LDAPtimeout','LDAP Query Timeout',2,\&textinput,15,'(\d+)',undef,'timeout when connecting to the remote server. The default is 15 seconds.',undef,undef,'msg007230','msg007231'],
['LDAPLogin','LDAP Login',80,\&passinput,'','(.*)',undef,'Most LDAP servers require a login and password before they allow queries.<br />Enter the DN specification for a user with sufficient permissions here.<br />For example: cn=Administrator,cn=Users,DC=yourcompany,DC=com',undef,undef,'msg007240','msg007241'],
['LDAPPassword','LDAP Password',20,\&passinput,'','(.*)',undef,'Enter the password for the specified LDAP login here.',undef,undef,'msg007250','msg007251'],
['LDAPVersion','LDAP Version',1,\&textinput,3,'(\d+)',undef,'Enter the version for the specified LDAP here.',undef,undef,'msg007260','msg007261'],
['ldLDAPRoot','LDAP Root container for Local Domains',80,\&textinput,'','(.*)',undef,'The LDAP lookup will use this container and all sub-containers to match the local domain query.<br />The literal DOMAIN is replaced by the domain part of SMTP recipient (eg. domain.com) during the search.<br />For example: DC=yourcompany,DC=com.<br />If you use DOMAIN here, you must check "LDAP failures return false" below or non local domains will be treated as local. If not defined, LDAPRoot will be used.',undef,undef,'msg009350','msg009351'],
['ldLDAPFilter','LDAP Filter for Local Domains',80,\&textinput,'','(\S*)',undef,'This filter is used to query the LDAP database. This strongly depends on the LDAP structure.<br />The filter must return an entry if the domain must be relayed.<br />
  The literal DOMAIN is replaced by the domain name during the search.<br />
  for example: (&amp;(|(|(|(|(&amp;(objectclass=user)(objectcategory=person))(objectcategory=group))(objectclass=publicfolder))(!(objectclass=contact)))(objectclass=msExchDynamicDistributionList))(proxyaddresses=smtp:*@DOMAIN))',undef,undef,'msg007280','msg007281'],
['LDAPRoot','LDAP Root container for Local Addresses',80,\&textinput,'','(.*)',undef,'The LDAP lookup will use this container and all sub-containers to match the local email address query.<br />The literal DOMAIN is replaced by the domain part of SMTP recipient (eg. domain.com) during the search.<br />For example: DC=yourcompany,DC=com.<br />If you use DOMAIN here, you must check "LDAP failures return false" below or non local domains will be treated as local.',undef,undef,'msg007270','msg007271'],
['LDAPFilter','LDAP Filter for Local Addresses',80,\&textinput,'','(\S*)',undef,'This filter is used to query the LDAP database. This strongly depends on the LDAP structure.<br />The filter must return an entry if the recipient address matches with that of any user.<br />The literal EMAILADDRESS is replaced by the fully qualified SMTP recipient (eg. user@domain.com) during the search.<br />The literal USERNAME is replaced by the user part of SMTP recipient (eg. user) during the search.<br />The literal DOMAIN is replaced by the domain part of SMTP recipient (eg. domain.com) during the search.<br />For example: (proxyaddresses=smtp:EMAILADDRESS) or (|(mail=EMAILADDRESS)(mailaddress=EMAILADDRESS)) or<br />
 (&amp;(|(|(|(|(&amp;(objectclass=user)(objectcategory=person))(objectcategory=group))(objectclass=publicfolder))(!(objectclass=contact)))(objectclass=msExchDynamicDistributionList))(proxyaddresses=smtp:EMAILADDRESS))',undef,undef,'msg007290','msg007291'],
['LDAPcrossCheckInterval','Clean Up local LDAP/VRFY Database <sup>s</sup>',40,\&textinput,12,$ScheduleGUIRe,'configChangeSched',
  'Delete outdated entries from the LDAP/VRFY cache. Check the LDAP cache to the LDAP server and/or VRFY-MTA and delete not existing entries.<br />
  Defaults to 12 hours. Is only used, if ldaplistdb is defined in the database section!',undef,undef,'msg007300','msg007301'],
['LDAPShowDB','Show local LDAP Database',40,\&textinput,'file:ldaplist','(\S*)',undef,'The directory/file with the LDAP cache database file. If you change ldaplistdb in section Filepath you must change it here too.',undef,'8','msg007310','msg007311'],
['forceLDAPcrossCheck','force to run LDAP/VRFY-CrossCheck - now.',0,\&checkbox,'','(.*)','ConfigChangeRunTaskNow','ASSP will force to run a LDAP/VRFY-CrossCheck now!<br />'. "<input type=button value=\"Run Now!\" onclick=\"document.forms['ASSPconfig'].theButtonX.value='Apply Changes';document.forms['ASSPconfig'].submit();WaitDiv();return false;\" />&nbsp;<input type=button value=\"Refresh Browser\" onclick=\"document.forms['ASSPconfig'].theButtonRefresh.value='Apply Changes';document.forms['ASSPconfig'].submit();WaitDiv();return false;\" />",undef,undef,'msg007320','msg007321'],
['MaxLDAPlistDays','Max LDAP/VRFY cache Days',5,\&textinput,'30','(\d+)',undef,'This is the number of days an address will be kept on the local LDAP/VRFY cache without any email to this address.',undef,undef,'msg007330','msg007331'],
['LDAPFail','LDAP/VRFY failures return false',20,\&checkbox,'','(.*)',undef,'If checked, when an error occurs in LDAP or VRFY lookups, the test fails.<hr /><div class="menuLevel1">Notes On LDAP </div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/ldap.txt\',3);" />',undef,undef,'msg007340','msg007341'],

[0,0,0,'heading','DNS Setup'],
['UseLocalDNS','Use Local DNS',0,\&checkbox,1,'(.*)','updateUseLocalDNS','Use system default local DNS Name Servers. To use system default local DNS Servers and the configured DNSServers (below), unselect this option and define the system default local DNS Servers in addition below!<br />
  all configured or local DNS Name Servers will be checked <span class="negative">this may take some time if the servers are responding slow- please wait after apply changes!</span>',undef,undef,'msg007350','msg007351'],
['DNSResponseLog','Show DNS Name Servers Response Time in Log',0,\&checkbox,0,'(.*)',undef,'You can use this to arrange DNSServers for better performance. Put the fastest first.',undef,undef,'msg007360','msg007361'],
['DNSServers','DNS Name Servers*',80,\&textinput,'208.67.222.222|208.67.220.220','^((?:(?:'.$HostRe.'|'.$HostPortRe.')(?:\|(?:'.$HostRe.'|'.$HostPortRe.'))*)(?:\s*=>\s*'.$HostRe.'\.?)?|(?:\s*=>\s*'.$HostRe.'\.?)|)$','updateDNS',
 'DNS Name Servers IP\'s to use for DNSBL, RWL, URIBL, PTR, SPF2 lookups. Separate multiple entries by "|" or leave blank to use system defaults.<br /> For example: 208.67.222.222|208.67.220.220 (<a href="http://www.opendns.com/" rel="external">OpenDNS</a>).<br />
  An DNS-query for the domain \'sourceforge.net\' is used per default to measure the speed of the used DNS-servers. If you want assp to use another domain or hostname for this, append \'=>domain.tld\' at the end of the line - like: 208.67.222.222|208.67.220.220=>myhost.com<br />
  To define the domain if you use the local DNS-servers \'UseLocalDNS\' without defining any DNS-servers here, simply write \'=>myhost.com\'.<br />
  All configured or local DNS Name Servers will be checked <span class="negative">this may take some time if the servers are responding slow - please wait after apply changes!</span>',undef,undef,'msg007370','msg007371'],
['maxDNSRespDist','Maximum DNS Responstime change',3,\&textinput,50,'([1-9]\d*)',undef,'Maximum DNS Server responstime change in milliseconds before the query order of the name servers should be changed.',undef,undef,'msg009800','msg009801'],
['DNStimeout','DNS Query Timeout',2,\&textinput,5,'(\d+)','updateUseLocalDNS','Global DNS Query Timeout for DNSBL, RWL, URIBL, PTR, SPF, MX and A record lookups. The default is 5 seconds.',undef,undef,'msg007380','msg007381'],
['DNSretry','DNS Query Retry',2,\&textinput,1,'(\d+)','updateUseLocalDNS','Global DNS Query Retry. Set the number of times to try the query. The default is 1.',undef,undef,'msg007390','msg007391'],
['DNSretrans','DNS Query Retrans',2,\&textinput,3,'(\d+)','updateUseLocalDNS','Global DNS Query Retransmission Interval. Set the retransmission interval. The default is 3.<br /><hr />
  <div class="menuLevel1">Notes On DNS Setup</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/DNSsetup.txt\',3);" />',undef,undef,'msg007400','msg007401'],

[0,0,0,'heading','Server Setup'],
['ConsoleCharset','Charset for STDOUT and STDERR',$Charsets,\&listbox,'0','(.*)',undef,
 'Set the characterset/codepage for the console output to your local needs. Default is "System Default" - default conversion. To display nonASCII characters on the console screen, setup UseUnicode4MaillogNames . <span class=\'negative\'>Restart is required!</span>',undef,undef,'msg007410','msg007411'],
['send250OK','Send 250 OK ',0,\&checkbox,'','(.*)',undef,
 'Set this checkbox if you want ASSP to reply with \'250 OK\' instead of SMTP error code \'554 5.7.1\'. This will turn ASSP in some form of tarpit. ',undef,undef,'msg007430','msg007431'],
['AsADaemon','Run ASSP as a Daemon','0:No|1:Yes - externaly controlled|2:Yes - run AutoRestartCmd on restart and wait|3:Yes - run AutoRestartCmd on restart and exit',\&listbox,'0','(.*)',undef,'In Linux/BSD/Unix/OSX fork and close file handles. <br />
 Similar to the command "perl assp.pl &amp;", but better.<br />
 If "externaly controlled" is selected, ASSP simply ends and you have to restart assp from your daemon or watchdog script<br />
 If "run AutoRestartCmd on restart and wait" is selected, assp starts the OS command defined in AutoRestartCmd - assp will <b>NOT !</b> automaticaly terminate - the started command has to terminate/kill and to (re)start assp - like "service assp restart"!<br />
 If "run AutoRestartCmd on restart and exit" is selected, assp starts the OS command defined in AutoRestartCmd and terminates immediatly!<br />
  <span class="negative"> requires ASSP restart</span>',undef,undef,'msg007440','msg007441'],
['runAsUser','Run as UID',20,\&textinput,'','(\S*)',undef,'The *nix user name to assume after startup (*nix only). use the autorestart features carefull, because any restart from inside ASSP will be done with the permission of this user! <p><small><i>Examples:</i> assp, nobody</small></p>
  <span class="negative"> requires ASSP restart</span>',undef,undef,'msg007450','msg007451'],
['runAsGroup','Run as GID',20,\&textinput,'','(\S*)',undef,'The *nix group to assume after startup (*nix only).<p><small><i>Examples:</i> assp, nobody</small></p>
  <span class="negative"> requires ASSP restart</span>',undef,undef,'msg007460','msg007461'],
['ChangeRoot','Change Root',40,\&textinput,'','(.*)',undef,'The new root directory to which ASSP should chroot (*nix only). If blank, no chroot jail will be used. Note: if you use this feature, be sure to copy or link the etc/protocols file in your chroot jail.<br />
  <span class="negative"> requires ASSP restart</span>',undef,undef,'msg007470','msg007471'],
['setFilePermOnStart','Set ASSP File Permission on Startup',0,\&checkbox,'','(.*)',undef,'If set, ASSP sets the permission of all ASSP- files and directories at startup to full (0777) - without any function on windows systems!',undef,undef,'msg007480','msg007481'],
['checkFilePermOnStart','Check ASSP File Permission on Startup',0,\&checkbox,'','(.*)',undef,'If set, ASSP checks the permission of all ASSP- files and directories at startup - all files must be writable for the running job - the minimum permission is 0600 - without any function on windows systems!',undef,undef,'msg007490','msg007491'],
['AutoRestart','Automatic Restart after Exception',0,\&checkbox,'','(.*)',undef,'If ASSP detects a main exception and it runs not as service or daemon, it will try to restart it self automaticly!  If running as daemon on nix/MAC , ASSP uses the action defined in AsADaemon to restart.',undef,undef,'msg007500','msg007501'],
['AutoRestartAfterCodeChange','Automatic Restart ASSP on new or changed Script',20,\&textinput,'','^(|immed|[1-9]|1[0-9]|2[0-3])$',undef,'If selected, ASSP will restart it self, if it detects a new or changed running script. An automatic restart will not be done, if ASSP is not running as a service on windows or as daemon on linux/MAC, and AutoRestartCmd is not configured. If running as daemon on linux/MAC ( AsADaemon ) ASSP simply ends - you have to restart assp from your daemon script. Leave this field empty to disable the feature. Possible values are \'immed and 1...23\' . If set to \'immed\', assp will restart within some seconds after a detected code change. If set to \'1...23\' the restart will be scheduled to that hour. A restart at 00:00 is not supported.',undef,undef,'msg007510','msg007511'],
['AutoUpdateASSP','Auto Update the Running Script (assp.pl)','0:no auto update|1:download only|2:download and install',\&listbox,'0','(.*)','ConfigChangeAutoUpdate',
 'No action will be done if \'no auto update\' is selected. You\'ll get a hint in the GUI (top) and a log line will be written, if a new version is availabe at the download location.<br />
  If \'download only\' is selected and a new assp version is available, this new version will be downloaded to the directory ' . $base . '/download (assp.pl) and the syntax will be checked. The still running script will be saved version numbered to the download directory.<br />
  If \'download and install\' is selected, in addition the still running script will be replaced by the new version.<br />
  Configure ( AutoRestartAfterCodeChange ), if you want the new version to become the active running script.<br />
  If this value is changed to \'download and install\', the autoupdate procedure will be scheduled immediatly.<br />
  If set, ASSP (on windows systems with ActivePerl installations) will search for updated Perl modules in all registered PPM respositories &nbsp;&nbsp;<input type="button" value="new available perl modules" onclick="javascript:popFileEditor(\'notes/avail_perl_modules.txt\',5);" /><br />
  The installation of some modules could require manual configuration and the installation failes or an upgrade is not recommended. In this case put the case sensitive module names (one per line) in the followog file. &nbsp;&nbsp;<input type="button" value="never upgrade these modules" onclick="javascript:popFileEditor(\'files/noupgrade.txt\',1);" /><br />
  If this value is set to \'download and install\', ASSP will try an autoupdate of the new available modules. It is possible, that some modules could not be installed, because the XS module parts are still in use. In this case follow the instruction - click the "new available perl modules" button above. To disable the automatic Perl module update - set "noModuleAutoUpdate" below.<br />
  Click this button to see the log file for the updated modules&nbsp;&nbsp;<input type="button" value="module upgrade log" onclick="javascript:popFileEditor(\'notes/upgraded_Perl_Modules.log\',1);" /><br />
  The perl module <a href="http://search.cpan.org/dist/Compress-Zlib/" rel="external">Compress::Zlib</a> is required to use this feature.',undef,undef,'msg008810','msg008811'],
['noModuleAutoUpdate','No Automatic Perl Module update',0,\&checkbox,'','(.*)',undef,'If set, ASSP will skip the automatic Perl module update.',undef,undef,'msg007900','msg007901'],
['AutoRestartCmd','OS-shell command for AutoRestart',100,\&textinput,'','(.*)',undef,'The OS level shell-command that is used to autorestart ASSP, if it runs not as a service or daemon! A possible value for your system is:<br /><font color=blue>'.$dftrestartcmd.'</font><br />Leave this field blank, if ASSP runs inside an external loop (inside the OS like assp.sh or assp.cmd). If running on NIX systems and runAsUser and/or runAsGroup is used, don\'t forget to switch back to root permissions in the script!',undef,undef,'msg007520','msg007521'],
['RestartEvery','Restart Timeout',10,\&textinput,'0','(\d+)','configChangeRestartEvery',
  'ASSP will automatically terminate and restart after this many seconds. Use this setting to periodically reload configuration data, combat potential memory leaks, or perform shutdown/startup processes. This will only work properly if ASSP runs as a Windows service or in a script that restarts it after it stops or AutoRestartCmd is configured. Alternative to this field you can use ReStartSchedule, to schedule restarts.',undef,undef,'msg007530','msg007531'],
['ReStartSchedule','Schedule Cron time for ASSP Restart',50,\&textinput,'noschedule','^((?:'.$ScheduleRe.'(?:\|'.$ScheduleRe.')*)|noschedule)$','configChangeRSRBSched','If <b>not</b> set to "noschedule" (noschedule is default), ASSP uses scheduled times to shutdown or restart ( AutoRestartCmd )! The syntax is the same like in <a href="http://en.wikipedia.org/wiki/Cron" rel="external">"Vixie" cron</a>! To disable this Scheduler leave this field blank!<b> Never write quotes in to this field!</b><br />
This requires an installed <a href="http://search.cpan.org/search?query=Schedule::Cron" rel="external">Schedule::Cron</a> module in PERL.<br />
<br /><b>Time and Date specification</b><br />
<br />
Entry is the specification of the scheduled time in crontab format,
which contains five mandatory time and date fields.
Entry can be either a plain string, which contains
a whitespace separated time and date specification.<br />
<br />
The time and date fields are (taken mostly from "Vixie" cron):<br />
<br />
<table BORDER CELLSPACING=0 CELLPADDING=4 WIDTH="50%" >
<tr><td><b>field</b></td><td><b>values</b></td></tr>
<tr><td>minute</td><td>0-59</td></tr>
<tr><td>hour</td><td>0-23</td></tr>
<tr><td>day of month</td><td>1-31</td></tr>
<tr><td>month</td><td>1-12 (or as names)</td></tr>
<tr><td>day of week</td><td>0-7 (0 or 7 is Sunday, or as names )</td></tr>
<tr><td>seconds</td><td>0-59 (optional) <b>not supported inside ASSP !!!</b></td></tr>
</table>
<br />
 A field may be an asterisk (*), which always stands for
 "first-last".<br />
<br />
 Ranges of numbers are  allowed.  Ranges are two numbers
 separated  with  a  hyphen.   The  specified  range  is
 inclusive.   For example, 8-11  for an  "hours" entry
 specifies execution at hours 8, 9, 10 and 11.<br />
<br />
 Lists  are allowed.   A list  is a  set of  numbers (or
 ranges)  separated by  commas.   Examples: "1,2,5,9",
 "0-4,8-12".<br />
<br />
 Step  values can  be used  in conjunction  with ranges.
 Following a range with "/<number>" specifies skips of
 the  numbers value  through the  range.   For example,
 "0-23/2" can  be used in  the hours field  to specify
 command execution every  other hour (the alternative in
 the V7 standard is "0,2,4,6,8,10,12,14,16,18,20,22").
 Steps are  also permitted after an asterisk,  so if you
 want to say "every two hours", just use "*/2".<br />
<br />
 Names can also  be used for the "month"  and "day of
 week"  fields.  Use  the  first three  letters of  the
 particular day or month (case doesn\'t matter).<br />
<br />
 Note:<br />
       The day of a command\'s execution can be specified
       by two fields  -- day of month, and  day of week.
       If both fields are restricted (ie, aren\'t *), the
       command will be run when either field matches the
       current  time.  For  example, "30  4 1,15  * 5"
       would cause a command to be run at 4:30 am on the
       1st and 15th of each month, plus every Friday<br />
<br />
Examples:<br />
<br />
<table BORDER CELLSPACING=0 CELLPADDING=4 WIDTH="80%" >
<tr><td>8 0 * * *</td><td>==></td><td>8 minutes after midnight, every day</td></tr>
<tr><td>5 11 * * Sat,Sun</td><td>==></td><td>at 11:05 on each Saturday and Sunday</td></tr>
<tr><td>0-59/5 * * * *</td><td>==></td><td>every five minutes</td></tr>
<tr><td>42 12 3 Feb Sat</td><td>==></td><td>at 12:42 on 3rd of February and on each Saturday in February</td></tr>
<tr><td>32 11 * * * 0-30/2</td><td>==></td><td>11:32:00, 11:32:02, ... 11:32:30 every day</td></tr>
</table>
<br />
In addition, ranges or lists of names are allowed.<br />
If you want to define multiple entries separate them by "|"',undef,undef,'msg007540','msg007541'],
['MemoryUsageLimit','Memory Limit in MB that ASSP could use',40,\&textinput,'','^(\d+|)$',undef,
 'The memory limit in megabyte the assp process could use at maximum on your system. Set this to empty or zero to disable the feature. The check is done using the schedule defined in MemoryUsageCheckSchedule . If the assp process uses more memory than the limit at a scheduled time and assp is able to restart it self - a restart will be done within 15 seconds. The user running assp must have read access to /proc on nix systems or must have read access to the WMI provider on windows systems!',undef,undef,'msg009950','msg009951'],
['MemoryUsageCheckSchedule','Schedule(s) to check the ASSP process memory usage <sup>s</sup>',40,\&textinput,'0-59/10 * * * *','^((?:'.$ScheduleRe.'(?:\|'.$ScheduleRe.')*)|)$','configChangeSched',
 'The schedule(s) that is used to check the current memory usage of the assp process compared to the MemoryUsageLimit. Default value is (0-59/10 * * * *), which means every 10 minutes. This requires an installed <a href="http://search.cpan.org/search?query=Schedule::Cron" rel="external">Schedule::Cron</a> module in PERL.',undef,undef,'msg009960','msg009961'],
['myName','My Name',40,\&textinput,'ASSP.nospam','('.$EmailDomainRe.')',undef,'ASSP will identify itself by this name in the email "Received:" header and in the helo when sending report-replies. Usually the fully qualified domain name of the host.<p><small><i>Examples:</i> assp.mydomain.com, ASSP.nospam</small></p>',undef,undef,'msg007550','msg007551'],
['myNameAlso','Additional My-Name-Definitions',40,\&textinput,'','^('.$EmailDomainRe.'(?:[\|\s,]+'.$EmailDomainRe.')*|)$',undef,'If myName was changed or you use shared folders (multiple ASSP) for the corpus files, define the old or other host names here - separate multiple entries by pipe, space or comma. ASSP will use this host names in addition to myName, to detect the received headerlines while the rebuildspamdb is running and in the mail analyzer.',undef,undef,'msg007880','msg007881'],
['myHelo','My Helo','0:transparent|1:use myName|2:use FQDN',\&listbox,0,'(\d)',undef,'How ASSP will identify itself when connecting to the target MTA.<br>
  transparent - the Helo of the sender will be used<br />
  use myName - myName will be used<br />
  use FQDN - fully qualified domain name of the host assp is running on',undef,undef,'msg007560','msg007561'],

['HideIPandHelo','Hide IP and/or Helo',40,\&textinput,'','(.*)',undef,'Replace any of these information ( ip=127.0.0.1 helo=anyhost.local ) in our received header for outgoing mails. use the syntax ip=127.0.0.1 and/or helo=anyhost.local .',undef,undef,'msg009830','msg009831'],
['asspCfg','assp.cfg*',40,\&textnoinput,'file:assp.cfg','(.*)','configUpdateASSPCfg','For internal use only - it is assp.cfg file. Do not change this value.',undef,undef,'msg007570','msg007571'],
['AutoReloadCfg','Automatic Reload ConfigFile',0,\&checkbox,'','(.*)','configChangeAutoReloadCfg','If selected and the assp.cfg file is changed externaly, ASSP will reload the configuration from the file automaticly.',undef,undef,'msg007580','msg007581'],
['asspCfgVersion','assp.cfg version',40,\&textnoinput,'','(.*)',undef,'ASSP will identify the assp.cfg file. Do not change this.',undef,undef,'msg007590','msg007591'],
['ConfigChangeSchedule','Schedule Configuration Changes*',40,\&textinput,'','(file:.+|)','configChangeConfigSched',
 'Use this option to schedule configuration changes. You must use the file option like \'file:files/configchangeschedule.txt\' to define schedules - an empty value disables this feature.<br />
 Define one schedule per line - comments are not allowed in a schedule definition line!<br />
 The line has to start with the schedule string ( see ReStartSchedule ) followed by the variable (or hidden variable ) name to change, followed by \':=\', followed by the value to change the variable to - like:<br /><br />
 8 0 * * * myNameAlso:=otherhost1.mydomain.tld<br />
 0 6 * * *|0 10 * * * myNameAlso:=otherhost2.mydomain.tld<br />
 0 1 * * * debug:=1<br />
 0 2 * * * debug:=<br /><br />
 The schedule string can contain multiple schedule definitions separated by pipe\'|\'. You will get errors if:<br />
 - the schedule definiton is wrong<br />
 - the variable name is wrong (does not exists)<br />
 - the syntax of the value is wrong<br />
 Notice - assp will only check the syntax at definition time - the logical correctness of the value will be checked at the scheduled time! So, assp will (for example) not check any dependencies at definition time - if a dependency is wrong, the change request at the scheduled time will fail!<br />
 Notice - all configuration changes are done with \'root\' permission! For this reason, this configuration parameter is only visable to root and it is stored encrypted!<br /><br  />
 <span class="negative">For advanced users ONLY:<br />
 Using the following extension, requires a deep internal knowledge of the assp code!</span><br />
 It is also possible to schedule a call to an internal assp subroutine. The name of the subroutine has to begin with a \'&amp;\', the parameters that should passed to the subroutine must be in \'()\' - like:<br />
 0 6 * * * &amp;subname(var1,var2,..,...)<br />
 0 7 * * * &amp;subname()<br />
 Notice: the subroutine will be called in the MainThread and syntax check will be done at run time - possible errors are shown in the log!',undef,undef,'msg009680','msg009681'],
['proxyserver','Proxy Server',20,\&textinput,'','(\S*)',undef,'The Proxy Server to use when uploading global statistics and downloading the greylist.<p><small><i>Examples:</i> 192.168.0.1:8080, 192.168.0.1</small></p>',undef,undef,'msg007600','msg007601'],
['proxyuser','Proxy User',20,\&passinput,'','(\S*)',undef,'The Proxy-UserName that is used to authenticate to the proxy.',undef,undef,'msg007610','msg007611'],
['proxypass','Proxy Password',20,\&passinput,'','(\S*)',undef,'The password for Proxy-UserName that is used to authenticate to the proxy.',undef,undef,'msg007620','msg007621'],
['webAdminPort','Web Admin Port',20,\&textinput,55555,$GUIHostPort,'ConfigChangeAdminPort',
  'The port on which ASSP will listen for http connections to the web administration interface. If you change this, after you click Apply you must change the URL on your browser to reconnect. You may also supply an IP address or hostname to limit connections to a specific interface. Separate multiple entries by pipe "|"!<p><small><i>Examples:</i> 55555, 192.168.0.5:12345, myhost:12345, 192.168.0.5:22345|myhost:12345</small></p>',undef,undef,'msg007630','msg007631'],
['enableWebAdminSSL','Use https instead of http',0,\&checkbox,'','(.*)','ConfigChangeEnableAdminSSL',
 'If selected the web admin interface will be only accessable via https. If you change this, after you click Apply you must change the URL on your browser to reconnect.
  This requires an installed <a href="http://search.cpan.org/search?query=IO::Socket::SSL" rel="external">IO::Socket::SSL</a> module in PERL.<br />
  A server-certificate-file "certs/server-cert.pem" and a server-key-file "certs/server-key.pem" must exist and must be valid!<br />
  If you do not have valid certificates, you may generate both files online with <a href="http://www.mobilefish.com/services/ssl_certificates/ssl_certificates.php" rel="external">www.mobilefish.com</a> or you may use OpenSSL to generate <a href="http://www.mobilefish.com/developer/openssl/openssl_quickguide_self_certificate.html" rel="external">Self-signed SSL certificates</a>!',undef,undef,'msg007640','msg007641'],
['webAdminPassword','Web Admin Password - Masterpassword (root)',20,\&passinput,'nospam4me','(.{5,})','ConfigChangePassword',
 # I hate hidden password input, but if you like it, uncomment this line and comment the next one. -- just quit bugging me about it!
 #[webAdminPassword','Web Admin Password - Masterpassword (root)',20,\&textinput,'nospam4me','(.{5,})',ConfigChangePassword,
  'The password for the web administration interface for user root(minimum of 5 characters). If root is logged on, no other logins are allowed. Always use the "logoff"-button as root to terminate the session - closing the browser without logoff could cause other session to be disallowed.',undef,undef,'msg007650','msg007651'],
['allowAdminConnectionsFrom','Only Allow Admin Connections From*',80,\&textinput,'','(\S*)','ConfigMakeIPRe',
  'An optional list of IP addresses and/or hostnames from which you will accept web admin connections. Blank means accept connections from any IP address.<br /> <span class="negative">Note: if you make a mistake here, you may disable your web administration interface and be forced to manually edit your configuration file to fix it.</span><p><small><i>Examples:</i></small></p>
  127.0.0.1|172.16.',undef,'7','msg007660','msg007661'],
['httpRequireCookies','HTTP and HTTPS require enabled browser cookies',0,\&checkbox,'1','(.*)',undef,
 'Cookie based http session ID\'s are used by assp to handle different requests from the same IP (eg behind NAT). Switch this off, if you are unable to use cookies in your browser. If switched off, a security hole is opened for connection that are using NAT - it could be possible that a second workstation (behind NAT) is able to login to the GUI, without user credentials if the same OS and browser version is used.',undef,undef,'msg009000','msg009001'],
['webStatHealthyResp','Status Response Literal for a Healty State of ASSP',25,\&textinput,'healthy','(.+)',undef,
  'This option must be set and it must be different to webStatNotHealthyResp. This literal will be given back in stat requests, if ASSP is working healty.',undef,undef,'msg009260','msg009261'],
['webStatNotHealthyResp','Status Response Literal for a Not Healty State of ASSP',25,\&textinput,'not healthy','(.+)',undef,
  'This option must be set and it must be different to webStatHealthyResp. This literal will be given back in stat requests, if ASSP is working not healty.',undef,undef,'msg009270','msg009271'],
['webStatPort','Raw Statistics Port',20,\&textinput,55553,$GUIHostPort,'ConfigChangeStatPort',
  'The port on which ASSP will listen for http or telnet connections to the statistics interface. You may also supply an IP address to limit connections to a specific interface. Only one value is supported!<br />
   The stats are available via browser or telnet (or telnet similar socket). Using telnet, press ENTER two times to get the healthy state (\'$Config{webStatHealthyResp} [CRLF]\' or \'$Config{webStatNotHealthyResp} [CRLF]\' in a single line), this is the recommended methode to get the \'UP\'-state of assp from nagios or any other external script.<br />
   Type \'stat[ENTER][ENTER]\' to get the STATS in raw text where each line is terminated with \'[CR]LF\' (CR is send in any case, if the request contains CR).<br />
   The HTML output are LF terminated STAT lines.<p><small><i>Examples:</i> 55553, 192.168.0.5:12345</small></p>',undef,undef,'msg007670','msg007671'],
['enableWebStatSSL','Use https instead of http',0,\&checkbox,'','(.*)','ConfigChangeEnableStatSSL',
 'The web stat interface will be only accessable via https.
  This requires an installed <a href="http://search.cpan.org/search?query=IO::Socket::SSL" rel="external">IO::Socket::SSL</a> module in PERL.<br />
  A server-certificate-file "certs/server-cert.pem" and a server-key-file "certs/server-key.pem" must exits and must be valid!',undef,undef,'msg007680','msg007681'],
['allowStatConnectionsFrom','Only Allow Raw Statistics Connections From*',80,\&textinput,'127.0.0.1','(\S*)','ConfigMakeIPRe',
  'An optional list of IP addresses from which you will accept raw statistical connections. Blank means accept connections from any IP address. <p><small><i>Examples:</i></small></p>
 127.0.0.1|172.16.',undef,undef,'msg007690','msg007691'],
['EnableHTTPCompression','Enable HTTP Compression in GUI',0,\&checkbox,1,'(.*)',undef,
  'Enable HTTP Compression for faster web administration interface loading. The perl module <a href="http://search.cpan.org/dist/Compress-Zlib/" rel="external">Compress::Zlib</a> is required to use this feature.',undef,undef,'msg007700','msg007701'],
['EnableFloatingMenu','Enable Floating Menu Panel in GUI',0,\&checkbox,'','(.*)',undef,
  'Allow the menu panel on the web administration interface to float (floating Div code taken from <a href="http://www.javascript-fx.com" rel="external">www.javascript-fx.com</a>).',undef,undef,'msg007710','msg007711'],
['hideAlphaIndex','Hide the Alpha Index Menu Panel in GUI',0,\&checkbox,'','(.*)',undef,
  'Removes the index panel on the left side in the GUI, but the index is accessable by clicking on "Sorted".',undef,undef,'msg007720','msg007721'],
['IndexSlideSpeed','Sliding Speed of the Alpha Index Menu Panel in GUI','450:no slide|50:fast|10:normal|5:slow',\&listbox,10,'(.*)',undef,
  'Adjust the sliding speed of the Alpha Index Menu Panel in GUI to your needs.',undef,undef,'msg007730','msg007731'],
['RememberGUIPos','Remember the last GUI position',0,\&checkbox,1,'(.*)',undef,
  'If selected, the GUI will remember the last topic of the main menu, that had the focus, was changed, that were jumped to or that were clicked to.',undef,undef,'msg009340','msg009341'],
['EnableInternalNamesInDesc','Show Internal Names in the GUI',0,\&checkbox,1,'(.*)',undef,
  'Show the internal names in the web interface. The internal names are used in the configuration file (assp.cfg), in the application code, and in the menu bar on the left side of the GUI.',undef,undef,'msg007740','msg007741'],
['MaillogTailJump','Jump to the End of the Maillog',0,\&checkbox,'','(.*)',undef,
  'Causes the browser window to jump to the bottom of the maillog instead of sitting at the top of the display.',undef,undef,'msg007750','msg007751'],
['MaillogTailBytes','Maillog Tail Bytes',10,\&textinput,10000,'(\d+)',undef,
  'The number of bytes that will be shown when the end of the maillog is viewed. The default value is 10000.',undef,undef,'msg007760','msg007761'],
['CleanCacheEvery','Cache Cleaning Interval <sup>s</sup>',40,\&textinput,'6',$ScheduleGUIRe,'configChangeSched',
  'This period (in hours) determines how frequently ASSP does cache-housekeeping.',undef,undef,'msg007780','msg007781'],
['SaveStatsEvery','Statistics Save Interval <sup>s</sup>',40,\&textinput,'30',$ScheduleGUIRe,'configChangeSched',
  'This period (in minutes) determines how frequently ASSP statistics are written to a local file.',undef,undef,'msg007790','msg007791'],
['totalizeSpamStats','Upload Consolidated Spam Statistics',0,\&checkbox,1,'(.*)',undef,
 'ASSP will upload its statistics to be consolidated with the <a href="http://assp.sourceforge.net/cgi-bin/assp_stats?stats" rel="external">global ASSP totals</a>. This is a great marketing tool for the ASSP project &mdash; please do not disable it unless you have a good reason to do so. No private information is being disclosed by this upload.',undef,undef,'msg007800','msg007801'],
['enableGraphStats','Enable Graphical Statistics Collection',0,\&checkbox,0,'(.*)',undef,
 'ASSP will collect statistical data in files located in the \'/logs\' folder (scoreGraphStats-YYYY-MM.txt , statGraphStats-YYYY-MM.txt). If data are collected and the module lib/ASSP_SVG.pm is installed and the files images/stat.gplot, images/svg_style.css, images/svg_defs.svg and images/svg.js are installed and your browser supports SVG, assp will show graphical statistic data, if you click on a line in the \'Info and Stats\' view.<br />
 It is recommended to set \'SaveStatsEvery\' to a value of 5 or 10 minutes, if this option is enabled!<br />
 Keep in mind that assp will NOT delete any of the \'*GraphStats...txt\'-files. If you don\'t need some of that files anymore, remove them manualy!',undef,undef,'msg010000','msg010001'],
['ReloadOptionFiles','Reload Option Files Interval <sup>s</sup>',40,\&textinput,'300',$ScheduleGUIRe,'configChangeSched',
  'If set not to zero, ASSP reloads configuration option files (file:.....) every this many seconds if they have changed. It is not recommended (and could make ASSP unavailable) to use rsync or any external tool to synchronise caches and list permanently. If you need to synchronise data between ASSP installations, you better use a database of your choice!',undef,undef,'msg007810','msg007811'],
['host2IPminTTL','Minimum TTL used for config reload',5,\&textinput,300,'(\d+)',undef,'Minimum TTL used for config reload options, if hostnames are defined for any IP in regular expressions.',undef,undef,'msg009810','msg009811'],
['OrderedTieHashTableSize','Ordered-Tie Hash Table Size',10,\&textinput,10000,'(\d+)',undef,
 'The number of entries allowed in the hash tables used by ASSP. This only belongs to Griplist if useDB4IntCache is not set. Larger numbers require more RAM but result in fewer disk hits. The default value is 10000. Adjust down to use less RAM.',undef,undef,'msg007820','msg007821'],
['OutgoingBufSizeNew','Size of TCP/IP Buffer',10,\&textinput,10240000,'(\d+)',undef,
 'The default is 10240000. Even more is better...',undef,undef,'msg007830','msg007831'],
['useDB4IntCache','Use BerkeleyDB for Internal Caches',0,\&checkbox,'','(.*)','configChangeDB',
  'ASSP uses some internal caches that could grow to a large number of entries. Switch this on, if you want ASSP to use less memory and be a little slower. The perl module <a href="http://search.cpan.org/dist/BerkeleyDB/" rel="external">BerkeleyDB</a> version 0.34 or higher and BerkeleyDB version 4.5 or higher is required to use this feature.',undef,undef,'msg007840','msg007841'],
['ALARMtimeout','Module Call Timeout',5,\&textinput,10,'(\d+)',undef,'Global Timeout for SPF checks. The default is 10 seconds.
  <hr /><hr /><font color=red>Thread Control - be carefull changing the following green options!</font><hr />',undef,undef,'msg007850','msg007851'],
['NumComWorkers','Number of SMTP-Threads',2,\&textinput,5,'^([12][0-9]|[2-9])$','configChangeNumThreads','Number of SMTP-Threads to be used! Typical and default is 5. 10 should be enought for 200.000 connections a day. 15 should be the absolute maximium. Values above 7 will mostly not increase performance. Configurable values are between 2 and 29. Restart ASSP if you changed this and you are using any database connection! An restart of assp is required if tis value was increased.','Basic',undef,'msg007860','msg007861'],
['ReservedOutboundWorkers','Reserved Number of Outbound-SMTP-Threads on relayPort',2,\&textinput,0,'(\d\d?)',undef,'Number of SMTP-Threads to be resevered for relayed (outbound) connections on relayPort ! This number of Threads will be exclusive reserved for connections on relayPort . For example: NumComWorkers=7 and ReservedOutboundWorkers=2 - mails on listenPort , listenPort2 and listenPortSSL are using worker 1-5 and mails on relayPort using worker 7-1 ! If you are not using the relayPort, do not reserve any workers.','Basic',undef,'msg007870','msg007871'],
['autoRestartDiedThreads','automaticly restart died threads',0,\&checkbox,'1','(.*)',undef,
  'If defined, a (for any reason) died thread will be automaticly restarted!','Basic',undef,'msg007920','msg007921'],
['MaxFinConWaitTime','Maximum time to wait for SMTP-Workers to finish connections',5,\&textinput,45,'^([1-5][0-9][0-9]|[1-9][0-9])$',undef,'The maximum time in seconds to wait for SMTP-Workers to finish connections, in case of a shutdown or restart of ASSP. Default is 45. Configurable values are 10 to 599.','Basic',undef,'msg007930','msg007931'],
['MonitorMainThread','Monitor the MainThread',0,\&checkbox,'1','(.*)',undef,
  'If defined, the MainThread will be monitored for healthy by the MaintThread (Worker 10000)!','Basic',undef,'msg007940','msg007941'],
['EnableHighPerformance','Enable Higher Performance','0:off|3000:slightly|1000:medium|500:high|10:very high',\&listbox,'0','(.*)',undef,
  'If set, the SMTP-Worker-Threads will get new pending connections much faster - using less wait states. The speed to interrupt the workers by the MainThread is increased. Using this feature will increase the CPU usage of the system!','Basic',undef,'msg009700','msg009701'],
['ThreadCycleTime','thread cycle time',5,\&textinput,3000,'(\d+)',undef,'Time in microseconds (for SMTP workers and MainThread) to give each other thread to run in high CPU-workload conditions. Default value is 3000, typical values are between 10 and 9000. You can set this to 0, if your OS honors system-yield-calls (0 is not recommended on Windows OS)! A higher value will reduce CPU usage but cause ASSP to run more slowly!','Basic',undef,'msg007950','msg007951'],
['MaintThreadCycleTime','MaintenanceThread cycle time',5,\&textinput,3000,'(\d+)',undef,'Time in microseconds (for MaintThread) to give each other thread to run in high CPU-workload conditions. Default value is 3000, typical values are between 10 and 9000. You can set this to 0, if your OS honors system-yield-calls (0 is not recommended on Windows OS)! A higher value will reduce CPU usage but cause ASSP to run more slowly!','Basic',undef,'msg007960','msg007961'],
['RebuildThreadCycleTime','RebuildSpamDBThread cycle time',5,\&textinput,30,'(\d+)',undef,'Time in microseconds (for RebuildSpamDBThread) to give each other thread to run in high CPU-workload conditions. Default value is 30, typical values are between 10 and 1000. You can set this to 0, if your OS honors system-yield-calls (0 is not recommended on Windows OS) and your system is fast enough! A higher value will reduce CPU usage but cause ASSP to run more slowly!','Basic',undef,'msg007970','msg007971'],
['ThreadStackSize','Stack Size use by every Thread',5,\&textinput,0,'(\d+)',undef,'The stack size in MB that is used by every thread. Default is 0, which meens to use the default system stack size. 16 MB is the default system stack size on windows platforms. This system value may differ on different platforms. To get the default stack size on linux use the shell command "ulimit -a". Try to increase this value, if you get "out of memory" errors while running assp. Changing this value requires an assp restart to take effect.','Basic',undef,'msg009030','msg009031'],
['IOEngine','Use This IO Engine','0:IO::Poll|1:IO::Select',\&listbox,0,'(.*)',undef,
  'Depending on your operating system and your Perl version it could be necessary to use the non default IOEngine \'IO::Select\'. Try this if you see unexpected early closed connections in the log. You have to restart ASSP, if you have changed this value!','Basic',undef,'msg007980','msg007981'],
['MinPollTime','Minimum Poll/Select Wait Time',5,\&textinput,2,'(\d+)',undef,'The time in milliseconds that ASSP will at least wait for IO::Poll/IO::Select events! A higher value will reduce CPU usage but cause ASSP to run more slowly! Default is 2.','Basic',undef,'msg007990','msg007991'],
['WorkerCPUPriority','CPU priority for SMTP-Threads',5,\&textinput,0,'(0|1|2)','configChangeWorkerPriority','Set the priority for the Workers in relation to all other processes/threads on the system. Than higher the value - than lower the priority. Default is 0 (system default is 0). Possible values are 0,1 and 2. This requires installed <a href="http://search.cpan.org/search?query=Thread::State" rel="external">Thread::State</a> module. It is recommended to run the Workers on lower priority, if ASSP has to process most of the time a large number of mails at one moment ( number of mails > NumComWorkers ).','Basic',undef,'msg008000','msg008001'],
['asspCpuAffinity','Cpu Affinity for assp',20,\&textinput,'-1','(\-1|\d+(?:[, ]+\d+)*)','configChangeCpuAffinity','Set the Cpu Affinity for all threads . Default is -1 (for use all CPU\'s). Possible values are comma or space separated CPU numbers starting with zero (0) or -1 for all CPU\'s. This requires installed <a href="http://search.cpan.org/search?query=Sys::CpuAffinity" rel="external">Sys::CpuAffinity</a> module. This feature will possibly not work on MacOS and OpenBSD and on any OS, if the system contains more than 32 CPU\'s.','Basic',undef,'msg009880','msg009881'],
['PreAllocMem','pre allocate memory for every mail',5,\&textinput,100000,'(\d+)',undef,'ASSP pre-allocates this number of bytes in mainstorage two times (in/out) for every mail to avoid memoryfracmentation (particularly in ASSP long run conditions). The memory will be allocated, if the DATA command is received from the server. Default is 100000 - this is enough for most of the mails. If ASSP receives the SIZE command from the server, the pre-allocation-memory will be calculated on that value. Question: Is it better to increase this value? Answer: Yes, it is - but be careful, this may cause ASSP running in out of memory errors!','Basic',undef,'msg008010','msg008011'],
['FreeupMemoryGarbage','Freeup Memory Garbage',0,\&checkbox,'1','(.*)',undef,
  'If defined, all Threads will try to recover memory every five minutes!','Basic',undef,'msg008020','msg008021'],
['ConnectionTransferTimeOut','Connection Transfer Timeout',5,\&textinput,30,'(\d+)',undef,'Global Timeout for MainThread to transfer a connection to any Worker. If no Worker is able to take the new SMTP-connection (for any reason), the new connection will be droped! The default is 30 seconds.','Basic',undef,'msg008030','msg008031'],
['ShowPerformanceData','Show Performance DATA in SMTP Connection screen',0,\&checkbox,'1','(.*)',undef,
  'If defined, performance data will be shown in top of the SMTP connection screen!
  <hr /><hr /><font color=red>end of Thread Control</font><hr />',undef,undef,'msg008040','msg008041'],
['UseLocalTime','Use Local Time',0,\&checkbox,1,'(.*)',undef,
  'Use local time and timezone offset rather than UTC time in the mail headers.<br /><hr />
  <div class="menuLevel1">Notes On Server Setup</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/myserver.txt\',3);" />',undef,undef,'msg008050','msg008051'],

[0,0,0,'heading','Rebuild Spamdb'],
['RebuildSchedule','Schedule Cron time for RebuildSpamdb',50,\&textinput,'noschedule','^((?:'.$ScheduleRe.'(?:\|'.$ScheduleRe.')*)|noschedule)$','configChangeRSRBSched','If <b>not</b> set to "noschedule" (noschedule is default) , ASSP uses scheduled times to run the RebuildSpamdb! The syntax is the same like in <a href="http://en.wikipedia.org/wiki/Cron" rel="external">"Vixie" cron</a>! To disable the Scheduler write "noschedule"!<b> Never write quotes in to this field!</b><br />
This requires an installed <a href="http://search.cpan.org/search?query=Schedule::Cron" rel="external">Schedule::Cron</a> module in PERL.<br />
It is possible to define more than one scheduled time per day to keep the Bayesian and HMM databes up to date, but this is not required - use \'newReportedInterval\' instead.<br />
If a file '.$base.'/rebuilddebug.txt exists, the rebuild task will write the debug output to this file.<br />
<br /><b>Time and Date specification</b><br />
<br />
Entry is the specification of the scheduled time in crontab format,
which contains five mandatory time and date fields.
Entry can be either a plain string, which contains
a whitespace separated time and date specification.<br />
<br />
The time and date fields are (taken mostly from "Vixie" cron):<br />
<br />
<table BORDER CELLSPACING=0 CELLPADDING=4 WIDTH="50%" >
<tr><td><b>field</b></td><td><b>values</b></td></tr>
<tr><td>minute</td><td>0-59</td></tr>
<tr><td>hour</td><td>0-23</td></tr>
<tr><td>day of month</td><td>1-31</td></tr>
<tr><td>month</td><td>1-12 (or as names)</td></tr>
<tr><td>day of week</td><td>0-7 (0 or 7 is Sunday, or as names )</td></tr>
<tr><td>seconds</td><td>0-59 (optional) <b>not supported inside ASSP !!!</b></td></tr>
</table>
<br />
 A field may be an asterisk (*), which always stands for
 "first-last".<br />
<br />
 Ranges of numbers are  allowed.  Ranges are two numbers
 separated  with  a  hyphen.   The  specified  range  is
 inclusive.   For example, 8-11  for an  "hours" entry
 specifies execution at hours 8, 9, 10 and 11.<br />
<br />
 Lists  are allowed.   A list  is a  set of  numbers (or
 ranges)  separated by  commas.   Examples: "1,2,5,9",
 "0-4,8-12".<br />
<br />
 Step  values can  be used  in conjunction  with ranges.
 Following a range with "/<number>" specifies skips of
 the  numbers value  through the  range.   For example,
 "0-23/2" can  be used in  the hours field  to specify
 command execution every  other hour (the alternative in
 the V7 standard is "0,2,4,6,8,10,12,14,16,18,20,22").
 Steps are  also permitted after an asterisk,  so if you
 want to say "every two hours", just use "*/2".<br />
<br />
 Names can also  be used for the "month"  and "day of
 week"  fields.  Use  the  first three  letters of  the
 particular day or month (case doesn\'t matter).<br />
<br />
 Note:<br />
       The day of a command\'s execution can be specified
       by two fields  -- day of month, and  day of week.
       If both fields are restricted (ie, aren\'t *), the
       command will be run when either field matches the
       current  time.  For  example, "30  4 1,15  * 5"
       would cause a command to be run at 4:30 am on the
       1st and 15th of each month, plus every Friday<br />
<br />
Examples:<br />
<br />
<table BORDER CELLSPACING=0 CELLPADDING=4 WIDTH="80%" >
<tr><td>8 0 * * *</td><td>==></td><td>8 minutes after midnight, every day</td></tr>
<tr><td>5 11 * * Sat,Sun</td><td>==></td><td>at 11:05 on each Saturday and Sunday</td></tr>
<tr><td>0-59/5 * * * *</td><td>==></td><td>every five minutes</td></tr>
<tr><td>42 12 3 Feb Sat</td><td>==></td><td>at 12:42 on 3rd of February and on each Saturday in February</td></tr>
<tr><td>32 11 * * * 0-30/2</td><td>==></td><td>11:32:00, 11:32:02, ... 11:32:30 every day</td></tr>
</table>
<br />
In addition, ranges or lists of names are allowed.<br />
If you want to define multiple entries separate them by "|"',undef,undef,'msg008070','msg008071'],
['useDB4Rebuild','Use BerkeleyDB/DB_File or orderedtie for the RebuildSpamDB Internal Caches',0,\&checkbox,'','(.*)','configChangeDB',
  'The RebuildSpamDB thread uses some internal caches that could grow to a large number of entries. Switch this on, if you want this thread to use less memory and be a little slower.<br />
   Adjust RebuildThreadCycleTime to a lower value (between 0 and 30) to speed up the RebuildSpamDB thread.<br />
   The perl module <a href="http://search.cpan.org/dist/BerkeleyDB/" rel="external">BerkeleyDB</a> version 0.34 or higher and BerkeleyDB version 4.5 or higher is required to use this feature. DB_File (Berkeley V1) will be used if BerkeleyDB is not available. If both BerkeleyDB and DB_File are not available, the rebuild thread will use the internal \'orderedtie\' which is up to 1000 times slower than BerkeleyDB.',undef,undef,'msg008080','msg008081'],
['ReplaceOldSpamdb','Replace the old Records in Spamdb and Spamdb.helo',0,\&checkbox,'1','(.*)',undef,
  'If selected, the new created records for Spamdb and Spamdb.helo will replace the old (belongs not to HMM, which is replaced every time). If not seleted, the new records will be added to Spamdb and Spamdb.helo . Default is on.',undef,undef,'msg008090','msg008091'],
['doMove2Num','Do move2num Before Rebuild',0,\&checkbox,'','(.*)',undef,'Renames files to numbers before the rebuild is started. If this is done, some other features like \'MailLogTail\' and \'Block-Report\' will be unable to find the files!',undef,undef,'msg008100','msg008101'],
['newReportedInterval','Interval for processing new Reported Mails',30,\&textinput,'10 5','(\d+\s+\d+)',undef,
 'File count and interval definition (count minutes) for processing new reported mails (correctedspam , correctednotspam) - process if at least \'first value\' mails are reported but every \'second value\' minutes.<br />
 Set the first value to zero to disable this feature.<br />
 If enabled, new reported mails or files moved in to the corpus via GUI are used, to immediatly update the Spamdb and HMMdb with the new information.<br />
 This will keep the databases continuously uptodate and the RebuildSchedule interval could be increased, if there are enough files in the corpus and your corpus norm is fine.<br />
 If you need to copy/move several files from outside assp in to the corpus and you want assp to process them immediatly, copy/move the files in to the subfolder "error/.../newManualyAdded".',undef,undef,'msg009870','msg009871'],
['MaxKeepDeleted','Max Days of Keep Deleted',5,\&textinput,0,'(\d+)',undef,
  'The maximum number in days deleted files in the bayesian collection folders ( spamlog , notspamlog ) will be kept. This is necessary when EmailBlockReport is used to handle the file and the file is meanwhile deleted. The list of files that are maked for deletion is stored in trashlist.db .',undef,undef,'msg008650','msg008651'],
['autoCorrectCorpus','Automatic Corpus Correction',60,\&textinput,'0.6-1.4-4000-14','(\d\.\d\d?-\d\.\d\d?-(?:[4-9]\d{3}|\d{5,})-\d+|)',undef,'(Syntax: a.a[a]-b.b[b]-cccc-dd or empty - default is "0.6-1.4-4000-14") If the corpus norm (the weight between spamwords/hamwords) is less than "a" (0.6 - too much ham) or greater than "b" (1.4 - too much spam), assp will delete the excess (oldest) files from the corresponding folder ( spamlog , notspamlog ). ASSP will keep a minimum of "c" (4000) files in the folder and will never delete files that are younger than "d" (14) days. This cleanup will run at the end of the rebuildspamdb task. So the corrected file corpus will take effect at the next rebuildspamdb!<br />
  If this value is defined, assp will use the middle value of "a" and "b" ((a+b)/2) as target corpusnorm and will try to reach this value, using (as many as possible) but only such a count of files in the folders spamlog and notspamlog as required!',undef,undef,'msg008980','msg008981'],
['RebuildFileTimeLimit','File Processing time Limit',30,\&textinput,'1 5','(\d+(?:\.\d+)?(?:(?:\s+|,)\d+(?:\.\d+)?)?)',undef,'(Syntax: a[.aa] b[.bb] - default is "1 5")<br />
   Define one, or two space or comma separated values.<br />
   If the first value is not zero and the processing time of a single corpus file exceeds the first value in seconds, this will be shown in the rebuild log.<br />
   If the second value is not zero and the processing time of a single corpus file exceeds the second value in seconds, the file will be moved to the folder "$base/rebuild_error" to prevent future runtime penalties.',undef,undef,'msg009620','msg009621'],
['RebuildNotify','Notification Email To',80,\&textinput,'','(.*)',undef,
  'Email address(es) to which you want ASSP to send a notification email after the rebuild task is finished. The file rebuildrun.txt is included in this notification. Separate multiple entries by "|".',undef,undef,'msg008110','msg008111'],
['RebuildTestMode','Run the Rebuild in Test Mode',0,\&checkbox,'','(.*)',undef,'If selected, all rebuildspamdb tasks will not populate the spamdb and hmmdb - and no data will be sent to the griplist-Server.',undef,undef,'msg009720','msg009721'],
['forceRebuildDowngrade','Keep rebuildspamdb.pm compatible to assp.pl',0,\&checkbox,'1','(.*)',undef,'Keep rebuildspamdb.pm compatible to assp.pl in case of an assp.pl version downgrade.',undef,undef,'msg009840','msg009841'],
['RunRebuildNow','Run RebuildSpamdb now',0,\&checkbox,'','(.*)','ConfigChangeRunTaskNow',
  'If selected, RebuildSpamdb will be started immediately.<br />' . "<input type=button value=\"Run Now!\" onclick=\"document.forms['ASSPconfig'].theButtonX.value='Apply Changes';document.forms['ASSPconfig'].submit();WaitDiv();return false;\" />&nbsp;<input type=button value=\"Refresh Browser\" onclick=\"document.forms['ASSPconfig'].theButtonRefresh.value='Apply Changes';document.forms['ASSPconfig'].submit();WaitDiv();return false;\" />" .
  '<hr /><div class="menuLevel1">Last Run Rebuildspamdb</div><input type="button" value="Last Run Rebuildspamdb" onclick="javascript:popFileEditor(\'rebuildrun.txt\',5);" />
  <hr /><div class="menuLevel1">Rebuildspamdb-debug-output</div><input type="button" value="Rebuildspamdb-debug-output" onclick="javascript:popFileEditor(\'rebuilddebug.txt\',3);" />
  <hr /><div class="menuLevel1">Notes On RebuildSpamdb</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/rebuildspamdb.txt\',3);" />',undef,undef,'msg008120','msg008121'],

[0,0,0,'heading','Char Conversions / TNEF'],
['inChrSetConv','inbound charset conversion table*',80,\&textinput,'','(\S*)','configChangeIC',
  'If defined, characterset conversion for inbound mails will be done. For example: if your emailserver does not understand UTF-8, ASSP will convert the mail parts to the characterset of your choice. The rules specified here are used to convert text parts of inbound mails from one to an other characterset.<p><small><i>Example:</i>UTF-8=>ISO-8859-1|ISO-8859-15=>ISO-8859-1</small></p>
 This requires an installed <a href="http://search.cpan.org/search?query=Email::MIME" rel="external">Email::MIME</a> module in PERL.<br />
 This conversions are done for all (inbound,CC,report ..) mails except relayed mails. The converted mail will be not available on disk except DEBUG.',undef,undef,'msg008130','msg008131'],
['outChrSetConv','outbound charset conversion table*',80,\&textinput,'','(\S*)','configChangeOC',
  'If defined, characterset conversion for outbound mails will be done. For example: if your emailserver is unable to send mails in UTF-8, ASSP will convert the mail parts to UTF-8. The rules specified here are used to convert text parts of outbound mails from one to an other characterset.<p><small><i>Example:</i>ISO-8859-1=>UTF-8|ISO-8859-2=>UTF-8|windows-1250=>UTF-8</small></p>
 This requires an installed <a href="http://search.cpan.org/search?query=Email::MIME" rel="external">Email::MIME</a> module in PERL.<br />
 This conversions are done only for relayed mails!',undef,undef,'msg008140','msg008141'],
['doInFixTNEF','convert inbound MS-TNEF attachments to MIME',0,\&checkbox,'','(.*)',undef,
  'convert inbound MS-TNEF attachments like winmail.dat to MIME parts/attachments. If a TNEF-file is attached by other than Exchange (like application/octet-stream) no conversion will be done. <br />
 In addition to <a href="http://search.cpan.org/search?query=Email::MIME" rel="external">Email::MIME</a> this requires both installed <a href="http://search.cpan.org/search?query=Convert::TNEF" rel="external">Convert::TNEF</a> and <a href="http://search.cpan.org/search?query=MIME::Types" rel="external">MIME::Types</a> module in PERL.',undef,undef,'msg008150','msg008151'],
['keepInTNEF','keep the MS-TNEF part in inbound mail',0,\&checkbox,'1','(.*)',undef,
  'keep inbound MS-TNEF attachments like winmail.dat in MIME parts. If unchecked and the conversion is successfull, the original attachment will be removed from mail!',undef,undef,'msg008160','msg008161'],
['doOutFixTNEF','convert outbound MS-TNEF attachments to MIME',0,\&checkbox,'','(.*)',undef,
  'convert outbound MS-TNEF attachments like winmail.dat to MIME parts/attachments. If a TNEF-file is attached by other than Exchange (like application/octet-stream) no conversion will be done.<br />
 In addition to <a href="http://search.cpan.org/search?query=Email::MIME" rel="external">Email::MIME</a> this requires both installed <a href="http://search.cpan.org/search?query=Convert::TNEF" rel="external">Convert::TNEF</a> and <a href="http://search.cpan.org/search?query=MIME::Types" rel="external">MIME::Types</a> module in PERL.',undef,undef,'msg008170','msg008171'],
['keepOutTNEF','keep the MS-TNEF part in outbound mail',0,\&checkbox,'1','(.*)',undef,
  'keep outbound MS-TNEF attachments like winmail.dat in MIME parts. If unchecked and the conversion is successfull, the original attachment will be removed from mail!',undef,undef,'msg008180','msg008181'],
['convertNP','convert NoProcessing mails',0,\&checkbox,'','(.*)',undef,
  'Set this to on, if noprocessing mails should be converted, which is normaly not the case.',undef,undef,'msg008840','msg008841'],
['doDKIMConv','convert DKIM mails',0,\&checkbox,'0','(.*)',undef,
  'DKIM messages could normaly not modified. If checked, conversions will be done on DKIM messages - <span class="negative">you have to disable the DKIM check on your emailserver (MTA)!</span>',undef,undef,'msg008190','msg008191'],
['TNEFDEBUG','TNEFDEBUG (only in dev)',0,\&checkbox,'','(.*)',undef,'prints TNEF conversion debug info to screen.<br /><hr />
  <div class="menuLevel1">Notes On Character Conversions / TNEF</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/conversions.txt\',3);" />',undef,undef,'msg008200','msg008201'],

[0,0,0,'heading','SSL Proxy and TLS support'],
['DoTLS','How to Handle STARTTLS Requests','0:drop TLS|1:TLS to Proxy|2:do TLS',\&listbox,0,'(\d*)',undef,
  'If set to "drop TLS", any STARTTLS request will be removed from the protocol stack and no connection will ever go in to any TLS mode!<br />
  If set to "TLS to Proxy" and both peers (client and server) supports TLS, both connection will be moved in to a transparent Proxy mode. All data will be encrypted and unreadable to ASSP.<br />
  If set to "do TLS", ASSP will be the "man in the middle". ASSP will try to move both connections in to TLS. All data will be readable to ASSP - so all checks could be done. If any of the peers does not support TLS, ASSP will fake this (250-STARTTLS) to the other peer. So it could be possible, that the connection to the client is going in to TLS mode, even if TLS is not supported by the server. If a client does not request TLS (STARTTLS) even it has got the (250-STARTTLS), ASSP tries to start a TLS session to server, if he has sent (250-STARTTLS)! This behavior belongs to incoming and outgoing messages. This option requires the installed perl module <a href="http://search.cpan.org/search?query=IO::Socket::SSL" rel="external">IO::Socket::SSL</a>!<br />
  For "do TLS" a server-certificate-file " SSLCertFile " and a server-key-file " SSLKeyFile " must exist and must be valid!<br />
  If you do not have valid certificates, you may generate both files online with <a href="http://www.mobilefish.com/services/ssl_certificates/ssl_certificates.php" rel="external">www.mobilefish.com</a> or you may use OpenSSL to generate <a href="http://www.mobilefish.com/developer/openssl/openssl_quickguide_self_certificate.html" rel="external">Self-signed SSL certificates</a>! If you have installed OpenSSL (must be in PATH) and installed and enabled IO::Socket::SSL and ASSP is unable to find valid certificates - ASSP will try to create them at startup!<br />
  <input type="button" value="SSLfailed Cache" onclick="javascript:popFileEditor(\'DB-SSLfailed\',\'1h\');" /><br />',undef,undef,'msg008210','msg008211'],
['SSL_version','SSL version used for transmission',20,\&textinput,'SSLv2/3','(\!?(?:SSLv2\/3|SSLv2|SSLv3|TLSv1)(?:\:\!?(SSLv2\/3|SSLv2|SSLv3|TLSv1))*)','ConfigChangeSSL',
  'Sets the version of the SSL protocol used to transmit data. The default is SSLv2/3,<br />
  which auto-negotiates between SSLv2 and SSLv3. You may specify \'SSLv2\', \'SSLv3\', or \'TLSv1\' (case-insensitive) combined with \':\' and negated with \'!\' (example: \'SSLv2/3:!SSLv2\') if you do not want this behavior.',undef,undef,'msg009660','msg009661'],
['SSL_cipher_list','SSL key cipher list',80,\&textinput,'','(.*)','ConfigChangeSSL',
 'If this option is set, the cipher list for the connection will be set to the given value, e.g. something like \'ALL:!LOW:!EXP:!ADH\'. Look into the OpenSSL documentation (<a href="http://www.openssl.org/docs/apps/ciphers.html#CIPHER_STRINGS" rel="external">http://www.openssl.org/docs/apps/ciphers.html#CIPHER_STRINGS</a>) for more details. Setting this value causes the \'SSL_honor_cipher_order\' flag to be switched on (BEAST vulnerable)<br />
 If this option is not used (default) the openssl builtin default is used which is suitable for most cases.',undef,undef,'msg009670','msg009671'],
['NoTLSlistenPorts','Disable SSL support on listenPorts',80,\&textinput,'','(.*)','ConfigChangeTLSPorts',
  'This disables TLS/SSL on the defined listenPorts, if DoTLS is set to "do TLS". All other SMTP listeners will support TLS/SSL, if DoTLS is set to "do TLS". This option works for listenPort , listenPort2 and relayPort . The listener definition here has to be the same like in the port definitions. Separate multiple entries by "|".<p><small><i>Examples:</i> 25, 127.0.0.1:25, 127.0.0.1:25|127.0.0.2:25 </small></p>',undef,undef,'msg008220','msg008221'],
['TLStoProxyListenPorts','Force TLS to Proxy on this Ports',80,\&textinput,'','(.*)','ConfigChangeTLSPorts',
  'If a STARTTLS command is received on a port that is defined here, the connection will be moved in to the transparent proxy mode every time - independend from the setting of DoTLS . This option works for listenPort , listenPort2 and relayPort . The listener definition here has to be the same like in the port definitions. Separate multiple entries by "|".<p><small><i>Examples:</i> 25, 127.0.0.1:25, 127.0.0.1:25|127.0.0.2:25 </small></p>',undef,undef,'msg009020','msg009021'],
['SSLCertFile','SSL Certificate File (PEM format)',48,\&textinput,$dftCertFile,'(\S*)','ConfigChangeSSL',
  "Full path to the file containing the server's SSL certificate, for example : /usr/local/etc/ssl/certs/assp-cert.pem or c:/assp/certs/server-cert.pem. A general cert.pem file is already provided in \'assp/certs/server-cert.pem\'",undef,undef,'msg008230','msg008231'],
['SSLKeyFile','SSL Key File (PEM format)',48,\&textinput,$dftPrivKeyFile,'(\S*)','ConfigChangeSSL',
  "Full path to the file containing the server\'s SSL private key, for example: /usr/local/etc/ssl/certs/assp-key.pem or c:/assp/certs/server-key.pem. A general key.pem file is already provided in \'assp/certs/server-key.pem\'",undef,undef,'msg008240','msg008241'],
['SSLPKPassword','SSL Private Key Password',48,\&passinput,'','(.*)',undef,
  "Optional parameter. If your private key ' SSLKeyFile ' is password protected, assp will need this password to decrypt the server\'s SSL private key file.",undef,undef,'msg009540','msg009541'],
['SSLCaFile','SSL Certificate Authority File',48,\&textinput,'','(\S*)','ConfigChangeSSL',
  "Optional parameter to enable chained certificate validation at the client side. Full path to the file containing the server's SSL certificate authority, for example : /usr/local/etc/ssl/certs/assp-ca.crt or c:/assp/certs/server-ca.crt. A general ca.crt file is already provided in '$dftCaFile'. The default value is empty and leave it empty as long as you don't know, how this parameter works.",undef,undef,'msg009530','msg009531'],
['noTLSIP','Exclude these IP\'s from TLS*',80,\&textinput,'','(\S*)','ConfigMakeIPRe','Enter IP\'s that you want to exclude from starting SSL/TLS, separated by pipes (|). For example, put all IP\'s here, that making trouble to switch to TLS every time, what will prevent ASSP from getting mails from this hosts.',undef,undef,'msg008250','msg008251'],
['banFailedSSLIP','Ban Failed SSL IP','0:disable|1:privat only|2:public only|3:both',\&listbox,3,'(\d*)',undef,
 'If set (recommended is \'both\'), an IP that failes to connect via SSL/TLS will be banned for 12 hour from using SSL/TLS.<br />
  Privat IP\'s and IP addresses listed in \'acceptAllMail\' will get one more try to correct the mistake.<br />
  This is done per default (\'both\'), to prevent possible DoS attacks via SSL/TLS.<br />
  Those IP\'s are stored in the SSLfailed cache. This cache is cleaned up at startup.<br />
  disable - disables this feature, which is highly NOT recommended<br />
  privat only - only privat IP\'s and IP\'s in acceptAllMail will be banned (they have two tries)<br />
  public only - only public IP\'s will be banned<br />
  both - privat and public IP\'s will be banned<br />
  <input type="button" value="edit SSLfailed Cache" onclick="javascript:popFileEditor(\'DB-SSLfailed\',\'1h\');" />',undef,undef,'msg010100','msg010101'],
['sendEHLO','Send EHLO',0,\&checkbox,'','(.*)',undef,
  'If selected, ASSP sends an EHLO even if the client has sent only a HELO. This is useful to force the usage of TLS to the server or to statisfy XCLIENT/XFORWARD helo offers, because EHLO is needed before STARTTLS or XCLIENT/XFORWARD could be used.',undef,undef,'msg008260','msg008261'],
['SSLRetryOnError','Retry SSL on "SSL want a read first" error',0,\&checkbox,'','(.*)',undef,
  'If selected, ASSP retries one time to establish a SSL connection with one second delay, if the peer was not ready after STARTTLS because of a "SSL want a read/write first" error.',undef,undef,'msg008270','msg008271'],
['SSLtimeout','SSL Timeout (0-999)',4,\&textinput,5,'(\d{1,3})',undef,
 'SSL/TLS negotiation will timeout after this many seconds. default is : 5 seconds.',undef,undef,'msg008280','msg008281'],
['SSLDEBUG','Debug Level for SSL/TLS','0:no Debug|1:level 1|2:level 2|3:level 3',\&listbox,0,'(\d*)',undef,'Set the debug-level for SSL/TLS. Than higher the level, than more information are written to STDOUT!',undef,undef,'msg008290','msg008291'],
['ProxyConf','Transparent TCP Proxy Table*',80,\&textinput,'','(\S*)','configChangeProxy',
  'Define transparent Port Proxy here. ASSP will forward incoming packets to a specific destination.<br />
   For example: if you want incoming connections on port 465 (SMTP-SSL) to be forwarded to your emailserver.<br />
   <p><small><i>Example:</i>0.0.0.0:465=>192.168.1.25:465<=12.1.1.3,34.5.6.7,67.23.2.1|<br />
   10.1.1.1:1477=>192.168.1.23:25<=120.5.1.3,134.5.19.7,67.123.221.11</small></p><br />
 The syntax is: localIP:localPORT=>forwardIP:forwardPORT<=allowfromIP1,allowfromIP2,...|next Proxy configuration|....<br />
 You have to configure the IP-address and IP-port for both - local and forward  values. AllowfromIP are comma separated values of IP-addresses from where connections are allowed. If there is no allow value defined, all connections will be allowed!<hr />
  <div class="menuLevel1">SSL Proxy and TLS support</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/ssl_and_proxy.txt\',3);" />',undef,undef,'msg008300','msg008301'],

[0,0,0,'heading','Global PenaltyBox'],
['globalClientName','client registration name',60,\&textinput,'','(.*)','configUpdateGlobalClient',
 'The Name of this global-client for registation on the global-server. This entry has to be the full qualified DNS-Name of the IP-address over which ASSP is doing HTTP-requests! If you are using a HTTP-Proxy, this should be the public IP-address of the last Proxy in chain! This DNS-Name has to be resolveable worldwide and the resolved IP-address has to match the ASSP-HTTP-connection-IP-address. It is not possible to use an IP-address in this field! Dynamic DNS-Names like "yourdomain.dyndns.org" are supported!<br />
 To become a member of the exclusive global-penalty-box-users, you will need a subscription and you will have to pay a yearly maintenance fee. To get registered and/or to get more information, please send an email with your personal/company details and the globalClientName to "assp.globalpb@thockar.com".<br />
 The name of this client has to be known by the global server before it could be registered from here. Please wait until you\'ve got an information, that your client name is known by the global server.<br />
 In addition to <a href="http://search.cpan.org/search?query=Compress::Zlib" rel="external">Compress::Zlib</a> this requires an installed <a href="http://search.cpan.org/search?query=LWP::UserAgent" rel="external">LWP::UserAgent</a> module in PERL.',undef,undef,'msg008310','msg008311'],
['globalClientPass','client registration password',20,\&passnoinput,'','(.*)','configUpdateGlobalHidden','If the global client is registered on the global-server, you will see a number of "*" in this field. This field is readonly.',undef,undef,'msg008320','msg008321'],
['globalClientLicDate','client subscription expiration date',20,\&textnoinput,'','(.*)','configUpdateGlobalHidden','The date of license/subscription expiration for this global client. If this date is exceeded, no upload and download of global PB will be done! This field is readonly.',undef,undef,'msg008330','msg008331'],
['DoGlobalBlack','Enable the Global-Black-Penalty',0,\&checkbox,'','(.*)',undef,'Enables the upload and download of Black-Penalty-Box-Entries, if the client is registered on the global-PB-server.',undef,undef,'msg008340','msg008341'],
['globalValencePB','Value for Global-Black-PB Entries +',3,\&textinput,20,'(\s*\d+\s*(?:\|\s*\d+\s*){0,1})','ConfigChangeValencePB', 'This penalty-value will be given to downloaded Black-Penalty-Box-Entries. As long as entries have the "GLOBALPB" state, they will never become extreme-Black. It is recommended to set this value above PenaltyLimit!',undef,undef,'msg008350','msg008351'],
['globalBlackExpiration','Expiration for Global-PB-Black Records',3,\&textinput,48,'(\d*)',undef, 'Global-Black-Penalties will expire after this number of hours.',undef,undef,'msg008360','msg008361'],
['DoGlobalWhite','Enable the Global-White-Penalty',0,\&checkbox,'','(.*)',undef,'Enables the upload and download of White-Penalty-Box-Entries, if the client is registered on the global-PB-server.',undef,undef,'msg008370','msg008371'],
['globalWhiteExpiration','Expiration for Global-PB-White Records(days)',3,\&textinput,7,'(\d*)',undef, 'Global-White-Penalties will expire after this number of days.',undef,undef,'msg008380','msg008381'],
['GPBDownloadLists','Download List and Regex Updates from GPB-Server','0:no download|1:download|2:download and install',\&listbox,2,'(\d*)',undef,'Select, if assp should download updates for lists and regular expressions from the global penaltybox server. Downloads will be done to the \'download\' folder. If install is selected, the downloaded lines will merged in to the defined files (file:...). If you want to disable a specific line in any of your files, do not delete the line, instead commed it out - putting an \'#\' or \';\' in front of the line. If any list is not configured using the \'file:...\' option, only the download will be done, even if install is selected. To disable a line that was added by the GPB-server to your file - simply commend the line out (# or ;). If you remove such a line, it could be possibly added again by the next GPB check. To change a line that was added by the GPB-server to your file - disable the line and customize a copied line to your needs.',undef,undef,'msg009370','msg009371'],
['GPBautoLibUpdate','Download Plugin and Library Updates from GPB-Server','0:no download|1:download|2:download and install',\&listbox,2,'(\d*)',undef,'Select, if assp should download updates for Plugins or Library-Files (../lib) from the global penaltybox server. Downloads will be done to the \'download\' folder. If install is selected, the downloaded Plugins and/or modules will be installed in to there original location, if an older version of the file still exists. If an older version is not found, only the download will be done. To activate updated Plugins or modules a restart of assp is required. This feature will not force an automatic restart of assp!.
<hr /><div class="menuLevel1">Notes On Global Penalty Box</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/global_pb.txt\',3);" />',undef,undef,'msg009380','msg009381'],

[0,0,0,'heading','Block Reporting'],
['ExtraBlockReportLog','Enable extra Logging for BlockReports',0,\&checkbox,'1','(.*)','ConfigChangeBRLogfile','Maillogs could grow to a very large size. Enable this feature to log only loglines with blocking information to an extra file. These files will be named as "b" + logfile . Using this option will speed up Block Reporting. Before you switch on this option, you should run "grep"[linux/MacOS] or "find"[Windows] to create the "b" - file from the maillogs.<br />
 linux/MacOS - grep "\\[spam found\\]" *maillog.txt > bmaillog.txt<br />
 Windows - find "[spam found]" *maillog.txt > bmaillog.txt',undef,undef,'msg008390','msg008391'],
['EmailBlockReport','Request Block Report',40,\&textinput,'asspblock','('.$EmailAdrRe.')?',undef,
 'Any mail sent by local/authenticated users to this username will be interpreted as a request to get a report about blocked emails. Do not put the full address here, just the user part. For example: asspblock<br />
 Leading digits/numbers in the mail subject will be interpreted as "report request for the last number of days". If the number of days is not specified in the mail subject, a default of 5 days will be used to build the report. <br />
 All characters behind the "number of days" will be interpreted as a regular expression to overwrite the BlockReportFilter - leading and trailing white spaces will be ignored.<br />
 Users defined in EmailBlockTo, EmailAdmins and EmailAdminReportsTo are \'Admins\' and can request a report for multiple users. They have to use a special syntax with \'=>\' in the body of the report request. The syntax is: <br />
 QueryAddress=>ReportRecipient=>ReportDays  -  there are many possible combinations of this three parameters. For example:<br />
 user@domain and user@domain=>user@domain - will send a report for this user to this user<br />
 *@domain (better use) *@domain=>* - will send a report for every blocked user in this domain to this user<br />
 user@domain=>recipient@any-domain - will send a report for user@domain to recipient@any-domain<br />
 *@domain=>recipient@any-domain - will send a report for every blocked user in this domain to recipient@any-domain<br />
 It is possible to define a group ( Groups ) in the first parameter like:<br />
 [user@domain]=>recipient@any-domain<br />
 The group name must be a lower case email address of a local domain without any wildcard. This will create a combined block report for all email addresses defined in this group - useful, if someone has multiple email addresses and want\'s to get a single report.<br />
 If the group name is equal to a real existing email address of a user, and this user requests a block report using this email address (MAIL FROM:), a combined block report for the group will be generated.<br />
 A third parameter is possible to set, which defines the number of days for which the report should be created. The default (if empty or not defined) is one day. This value is used to calculate the \'next run date\'. For example:<br />
 *@domain=>recipient@any-domain=>2 - creates a report for two days.<br />
 *@domain=>*=>14 - creates a report for 14 days.<br />
 user@domain=>=>3 or user@domain=>*=>3 - creates a report for three days. The second parameter is here empty or *.<br />
 To overwrite the defined BlockReportFilter, you can define a fourth parameter, which contains the regular expression to use.<br />
 *@domain=>*=>14=>virus|newsletter - creates a report for 14 days and skips all lines that contains the words \'virus\' or \'newsletter\'.<br />
 If an admin emails a block report request and specifies a filter in the subject of the email and a fourth parameter in the body, both regular expressions will be merged in to a single regex for each line.<br />
 If you or a user want the default BlockReportFilter to become part of the overwrite regex, the literal \'$BRF\' should be inluded in the regex like:<br />
 *@domain=>*=>14=>virus|$BRF|newsletter - or even in the subject of the email<br />
 In this case the literal \'$BRF\' will be replaced by the BlockReportFilter.<br />
 Only Admins are able to request blockreports for non local email addresses. For example:<br />
 user@non_local_domain=>recipient@any-domain=>4<br />
 *@non_local_domain=>recipient@any-domain=>4<br />
 This will result in an extended blockreport for the non local address(es). Replace \'non_local_domain\' with the domain name you want to query for.<br />
 It is possible to change the complete design of the BlockReports to your needs,  using a html-css file. An default css-file \'blockreport.css\' is in the image folder.<br />
 There you can also find a default icon file \'blockreporticon.gif\' and a default header-image-file \'blockreport.gif\' - which is the same like \'logo.gif\'.  There is no need to install that fles. If assp can not find this files in its
 image folder, it will use default hardcoded css and icon. If the file \'blockreport.gif\' is not found \'logo.gif\' will be used.<br />
 To change any contents, use the Blockreport::modify module in the lib folder. You\'ll need some Perl skills to do that.<br />
  <input type="button" value=" Edit blockreport_sub.txt file" onclick="javascript:popFileEditor(\'reports/blockreport_sub.txt\',2);" /><br />
  <input type="button" value=" Edit blockreport_html.txt file" onclick="javascript:popFileEditor(\'reports/blockreport_html.txt\',2);" /><br />
  <input type="button" value=" Edit blockreport_text.txt file" onclick="javascript:popFileEditor(\'reports/blockreport_text.txt\',2);" />','Basic',undef,'msg008400','msg008401'],
['EmailBlockReportDomain','Request Blocked Email Domain',40,\&textinput,'@assp.local','(\@'.$EmailDomainRe.')?',undef,
  'Set this to the domain to which the users can send a request to receive blocked messages. For example: @assp.local. Notice the leading required \'@\'!',undef,undef,'msg008410','msg008411'],
['EmailBlockReply','Reply to Block-Report Request','0:NO REPLY|1:REPLY TO SENDER|2:REPLY TO EmailBlockTo|3:REPLY TO BOTH',\&listbox,1,'(\d*)',undef,
  '',undef,undef,'msg008420','msg008421'],
['QueueUserBlockReports','Queue User Block Report Requests','0:run instantly|2:store and run scheduled',\&listbox,0,'(\d*)',undef,
  'How to process block report requests for users ( not EmailBlockTo, EmailAdmins, EmailAdminReportsTo ).<br />
  \'run instantly\' - the request will be processed instantly (not stored).<br />
  \'store and run scheduled\' - (deprecated) the request will be stored/queued, runs permanently scheduled at BlockReportSchedule until it will be removed from queue - a \'+\' in the subject is not needed<br />
  To add a request to queue, the user has to send an email to EmailBlockReport. Leading digits/numbers in the mail subject will be interpreted as "report request for the last number of days". If the number of days is not specified in the mail subject, a default of 5 days will be used to build the report.<br />
  If \'run instantly\' is selected, but a user wants to schedule a permanent request, a leading \'+\' before the digits in subject is required.<br />
  To remove a request from queue the user has to send an email to EmailBlockReport with a leading \'-\' in the subject.<br />
  <input type="button" value=" Edit user report queue" onclick="javascript:popFileEditor(\'files/UserBlockReportQueue.txt\',2);" />',undef,undef,'msg008430','msg008431'],
['QueueSchedule','Runtime for Queued Requests <sup>s</sup>',40,\&textinput,'0',$ScheduleGUIRe,'configChangeSched',
  'Runtime hour for reports in QueueUserBlockReports. Set a number between 0 and 23. 0 means midnight and is default',undef,undef,'msg008440','msg008441'],
['BlockRepForwHost','Forward The Blockreportrequest to other ASSP',40,\&textinput,'','(.*)',undef,'If you are using more than one ASSP (backup MX), define the IP-address and relayPort (x.x.x.x:ppp) of the other ASSP here (separate multiple entries by "|"). The Blockreportrequest will be forwarded to this ASSP and the user will get a blockreport from every ASSP. The forwarded request has the same sender and recipient like the original request. So EmailBlockReport and EmailBlockReportDomain have to be configured identic on all ASSP!!!! Resend requests are automatic forwarded to the right (or next) host, if ASSP finds the hostname in the subject of the request. If you have more than two ASSP, the logical sending structure must be a star. If ASSP(A) (the sun) is in the middle and you have also ASSP(B), ASSP(C) and ASSP(D) (satelites), ASSP(A) should know C,B and D, and B,C and D should only know A.<br />
 The perl module <a href="http://search.cpan.org/search?query=Net::SMTP/" rel="external">Net::SMTP</a> is required to use this feature.',undef,undef,'msg008450','msg008451'],
['EmailBlockTo','Send Copy of Block-Reports TO',40,\&textinput,'','('.$EmailAdrRe.'\@'.$EmailDomainRe.')?',undef,
  'Email sent from ASSP acknowledging your submissions will be sent to this address. For example: admin@domain.com',undef,undef,'msg008460','msg008461'],
['EmailAdminDomains','Restrict Email Admins to Domains*',40,\&textinput,'','(file:.+)|','ConfigMakeEmailAdmDomRe',
  'Use this parameter to restrict users registered in EmailAdmins, EmailAdminReportsTo and EmailBlockTo to a list of domains or users, for which they can request BlockReports.<br />
  It is possible to use defined GROUPS. The file: option is required. Use the following syntax to define an entry (one per line):<br />
  EmailAdminAddress=>*@domain1,*@domain2 user@domain3 ...<br />
  [user@domain]=>*@domain1,*@domain2 user@domain3 ...<br />
  Wildcards are allowed to be used in the domain definition - like *@*.domain.tld - separate multiple domains by comma or space.<br />
  If a BlockReport is requested for a not allowed email address, the complete BlockReport request will be ignored.<br />
  If an EmailAdmins address is not registered in this parameter, he/she is able to request BlockReports for all domains.',undef,undef,'msg009710','msg009711'],
['EmailResendRequester','Blocked Email Resend Requester*',60,\&textinput,'','(.*)','ConfigMakeSLRe',
 'A list of local addresses, which are allowed to request a resend of blocked emails for other users, even they are not EmailAdmins . Leave this field blank (default), to disable this feature.<br />
  This is usefull, if a user gets automatic generated BlockReports (e.g via BlockReportFile ) for a group of users and should be able to manage resends for them. Added here, the user is not allowed to request BlockReports for other users - in this case use EmailAdmins and EmailAdminDomains instead.<br />
  The resend is done to the recipient stored in the X-Assp-Intended-For: ( requires AddIntendedForHeader ) header field and the requester if the address was found in a TO: header filed. <br />
  Accepts specific addresses (user@domain.com), user parts (user).  Wildcards are supported (fribo*@domain.com).<br />
  For example: fribo*@thisdomain.com|jhanna ',undef,undef,'msg010120','msg010121'],
['BlockReportFile','File for Blockreportrequest',40,\&textinput,'','(file:.+)|','initMaintScheduler','A file with BlockReport requests. ASSP will generate a block report for every line in this file (file:files/blockreportlist.txt - file: is required if defined!) every day at midnight for the last day. The perl modules <a href="http://search.cpan.org/search?query=Net::SMTP/" rel="external">Net::SMTP</a> and <a href="http://search.cpan.org/search?query=Email::MIME /" rel="external">Email::MIME </a> are required to use this feature. A report will be only created, if there is at least one blocked email found! The syntax is: <br />
 QueryAddress=>ReportRecipient=>ReportDays  -  there are many possible combinations of this three parameters. For example:<br />
 user@domain and user@domain=>user@domain - will send a report for this user to this user<br />
 *@domain (better use) *@domain=>* - will send a report for every blocked user in this domain to this user<br />
 *@* - creates a report for all local users in all local domains<br />
 user@domain=>recipient@any-domain - will send a report for user@domain to recipient@any-domain<br />
 *@domain=>recipient@any-domain - will send a report for every blocked user in this domain to recipient@any-domain<br />
 It is possible to define a group ( Groups ) in the first parameter like:<br />
 [user@domain]=>recipient@any-domain<br />
 The group name must be a lower case email address of a local domain without any wildcard. This will create a combined block report for all email addresses defined in this group - useful, if someone has multiple email addresses and want\'s to get a single report.<br />
 An third parameter is possible to set, which defines the number of days for which the report should be created. The default (if empty or not defined) is one day. This value is used to calculate the \'next run date\'. For example:<br />
 *@domain=>recipient@any-domain=>2 - creates a report for two days.<br />
 *@domain=>*=>14 - creates a report for 14 days.<br />
 user@domain=>=>3 or user@domain=>*=>3 - creates a report for three days. The second parameter is here empty or *!<br />
 To overwrite the defined BlockReportFilter, you can define a fourth parameter, which contains the regular expression to use.<br />
 *@domain=>*=>14=>virus|newsletter - creates a report for 14 days and skippes all lines that contains the words \'virus\' or \'newsletter\'.<br />
 An fifth parameter could be used to schedule (cron) a BlockReport. If this paramter is used, the line will be ignored at BlockReportSchedule. For the syntax of the cron entry, please read RebuildSchedule . Multiple schedules in one line could be separated by pipe (|).<br />
 *@domain=>it_dep@domain=>7=>virus|newsletter=>0 0 * * 0 - creates a report every Sunday at 00:00 for the last seven days<br />
 *@domain=>it_dep@domain=>2=>virus|newsletter=>0 0 * * 2,4,6|0 12 * * 1 - creates a report every Tuesday,Thursday,Saturday at 00:00 and at every Monday at 12:00 for the last two days<br />
 Only Admins are able to request blockreports for non local email addresses. For example:<br />
 user@non_local_domain=>recipient@any-domain=>4<br />
 *@non_local_domain=>recipient@any-domain=>4<br />
 This will result in an extended blockreport for the non local address(es). Replace \'non_local_domain\' with the domain name you want to query for.',undef,undef,'msg008470','msg008471'],
['BlockReportSchedule','Runtime BlockReportFile <sup>s</sup>',40,\&textinput,'0',$ScheduleGUIRe,'configChangeSched',
  'Runtime hour for reports in BlockReportFile. Set a number between 0 and 23. 0 means midnight and is default.',undef,undef,'msg008480','msg008481'],
['BlockReportNow','Generate a BlockReport from BlockReportFile Now',0,\&checkbox,'','(.*)','ConfigChangeRunTaskNow', "If selected, ASSP will generate a block report from BlockReportFile now. <input type=button value=\"Run Now!\" onclick=\"document.forms['ASSPconfig'].theButtonX.value='Apply Changes';document.forms['ASSPconfig'].submit();WaitDiv();return false;\" />&nbsp;<input type=button value=\"Refresh Browser\" onclick=\"document.forms['ASSPconfig'].theButtonRefresh.value='Apply Changes';document.forms['ASSPconfig'].submit();WaitDiv();return false;\" />",undef,undef,'msg008490','msg008491'],
['BlockMaxSearchTime','Max Search time per log File',4,\&textinput,'0','(\d+)',undef,
  'The maximum time in seconds, the Blockreport feature spends on searching in one log file. If this value is reached, the next log file will be processed. Default is 0. A value of 0 disables this feature and all needed log files will be fully processed.',undef,undef,'msg008500','msg008501'],
['BlockReportFormat','The format of the Report Email','0:text and html|1:text only|2:html only',\&listbox,0,'(\d*)',undef,
  'Block reports will be sent as multipart/alternative MIME messages. They normaly contains two parts, a plain text part and a html part. Select "text only" or "html only" if you want to skip any of this parts.<br />
  To make it possible to detect a resent email, ASSP will add a header line "X-Assp-Resend-Blocked: myName" to each email!',undef,undef,'msg008510','msg008511'],
['BlockReportHTTPName','My HTTP Name',40,\&textinput,'','(.*)',undef,'The hostname for HTTP(S) links in AdminUsers Blockreports. If not defined the local hostname will be used.',undef,undef,'msg008760','msg008761'],
['BlockReportFilter', 'Regular Expression to Skip Log Records*',80,\&textinput,'Virus|BlackDomain','(.*)','ConfigCompileRe',
 'Put anything here to identify messages which should not be reported in any Block Report. For example:  Virus|BlackDomain.<br />
 For individual filter settings, it is possible to overwrite this value in the BlockReportFile for every single line and in every request per email using the subject line ( read EmailBlockReport ).',undef,undef,'msg008520','msg008521'],
['DoT10Stat','Collect multiple TopTen Statistics',0,\&checkbox,'','(.*)',undef, 'enable the top ten statistic count (blocked IP\'s, blocked senders, blocked recipients) and the output in the GUI and BlockReports for admins.',undef,undef,'msg009790','msg009791'],
['inclResendLink','Include a Resend-Link for every resendable email','0:disabled|1:in plain text report|2:in html report|3:in both',\&listbox,3,'(\d*)',undef,
  'Block reports will be sent as multipart/alternative MIME messages. They contains two parts, a plain text part and a html part. If a blocked email is stored in any folder, it is possible to include a link for each email in to the report. Define here what you want ASSP to do. Default is "in both". If set to not to disabled " fileLogging " will be automaticly set to on.',undef,undef,'msg008530','msg008531'],
['BlockResendLink','Which Link Should be included','0:both|1:left|2:right',\&listbox,0,'(\d*)',undef,
  'If HTML is enabled in inclResendLink, two links (one on the left and one on the right site) will be included in the report email by default. Depending on the used email clients it could be possible, that one of the two links will not work for you. Try out what link is working and disable the other one, if you want.',undef,undef,'msg008540','msg008541'],
['BlockResendLinkLeft','User which get the Left link only*',80,\&textinput,'','(.*)','ConfigMakeSLRe',
  'List of users and domains that will get the left link only. The setting for BlockResendLink will be ignored for this entries!',undef,undef,'msg008550','msg008551'],
['BlockResendLinkRight','User which get the right link only* ',80,\&textinput,'','(.*)','ConfigMakeSLRe',
  'List of users and domains that will get the right link only. The setting for BlockResendLink will be ignored for this entries!',undef,undef,'msg008560','msg008561'],
['DelResendSpam','Delete Mails in Spam Folder',0,\&checkbox,'1','(.*)',undef, 'If selected, an user request to resend a blocked email will delete the file in the spamlog folder - an admin request will move the file to the correctednotspam folder.',undef,undef,'msg008570','msg008571'],
['autoAddResendToWhite','Automatic add Resend Senders to Whitelist','0:no|1:Users only|2:Admins only|3:Users and Admins',\&listbox,'0','(.*)',undef, 'If a BlockReport resend request is made by any of the selected users, the original sender of the resent mail will be added to whitelist, also a copy file to the resend folder will do that.
  <div class="menuLevel1">Notes On Block Reporting</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/blockreports.txt\',3);" />',undef,undef,'msg008580','msg008581'],

[0,0,0,'heading','SNMP Configuration'],
['SNMP','Enable the ASSP-SNMP Interface','0:disable|1:enable',\&listbox,0,'(\d*)','ConfigChangeSNMP',
 'This enables the AgentX registration of assp to a SNMP master-AgentX. ASSP will be registered to the master-AgentX as \'assp_myName\', the possible configuration file name will be assp_myName.conf . This option requires the installed perl module <a href="http://search.cpan.org/search?query=NetSNMP::agent" rel="external">NetSNMP::agent</a>. The product and needed librarys could be downloaded at <a href="http://www.net-snmp.org/download.html" rel="external">net-snmp.org</a>.<br />
 All configuration values are accessed using the SNMPUser account. The SNMP-permission and visibility is used from the configured user GUI-permissions.<br /><br />
The following OIDs (relative to the SNMPBaseOID) are available for SNMP-querys. The configuration values are changeable via snmp. The file mib/ASSP-MIB could be used in SNMP browsers to get a human readable view of the OID\'s (copy it to the net-snmp MIB file location - eg: [C:]/usr/share/snmp/mibs and the MIB location of your SNMP browser). Please keep in mind, that an extensive usage of SNMP querys will slow down assp.<br /><br />
.1   - runtime information<br />
.1.0 - assp healty status boolean 0/1<br />
.1.1 - assp healty status text<br />
.1.2 - ASSP runtime status boolean 0/1 0=shutdown in progress - 1=running<br />
.1.3 - ASSP runtime status text<br />
.1.4 - ASSP version string<br />
.1.5 - ASSP script name<br />
.1.6 - Perl version string<br />
.1.7 - Perl executable name<br />
.1.8 - operating system name<br />
.1.9 - hostname where ASSP is running on<br />
.1.10 - IP-host where ASSP is running on<br />
.1.11 - myName<br />
.1.12 - URL to new ASSP version download<br />
.1.13 - currently running tasks<br />
.1.14 - current assp memory usage in MB<br />
.1.20 - schedule information<br />
.1.20.1 - next BerkeleyDB sync<br />
.1.20.2 - next scheduled Config reload<br />
.1.20.3 - next BATVTag cache cleaning<br />
.1.20.4 - next general cache cleaning<br />
.1.20.5 - next IP-per-Domain cache cleaning<br />
.1.20.6 - next DelayDB cache cleaning<br />
.1.20.7 - next Penaltybox cache cleaning<br />
.1.20.8 - next Database Backup<br />
.1.20.9 - next Database Connection Check<br />
.1.20.10 - next DNS Connection Check<br />
.1.20.11 - next hourly job runs (at)<br />
.1.20.12 - next Database Export<br />
.1.20.13 - next upload for Global-Black<br />
.1.20.14 - next upload for Global-White<br />
.1.20.15 - next Hash-File-Check (option files)<br />
.1.20.16 - next LDAP-cross-Check<br />
.1.20.17 - next RebuildSpamDB<br />
.1.20.18 - next ResendMail<br />
.1.20.19 - next ASSPFileDownload (assp.pl)<br />
.1.20.20 - next Version File Download (version.txt)<br />
.1.20.21 - next BackDNS File Download<br />
.1.20.22 - next Code Change Check<br />
.1.20.23 - next Droplist Download<br />
.1.20.24 - next Griplist Download<br />
.1.20.25 - next POP3Collect<br />
.1.20.26 - next Save Stats<br />
.1.20.27 - next TLDlist Download<br />
.1.20.28 - next Sync Config<br />
.1.20.29 - next Groups File Reload<br />
.1.20.30 - next BlockReport Schedule<br />
.1.20.31 - next File Age Schedule<br />
.1.20.32 - next BlockRepor Queue Schedule<br />

<br />
.1.30.X - worker status (boolean) X = worker<br />
.1.30.X.1 - worker time since last loop (text) X = worker<br />
.1.30.X.2 - worker last action (text) X = worker<br />
<br />
.1.31.0 - general database status (boolean) 0/1<br />
.1.31.0.1 - general database status (text)<br />
.1.31.X - database table status (boolean) 0/1 - X >= 1<br />
.1.31.X.1 - database table name - X >= 1 related to .1.31.X<br />
<br />
.2 - Configuration - X is the internal value number adapted from the language files<br />
.2.H - heading description - H is the internal GUI heading number<br />
.2.H.X   - config value<br />
<br />
.3 - assp module information - X is a counter up from zero<br />
.3.X - module name<br />
.3.X.1 - installed module version<br />
.3.X.2 - required module version<br />
.3.X.3 - module installation status<br />
.3.X.4 - download URL for the module<br />
<br />
.4 - assp runtime status<br />
.4.1 - current stat - X is a counted number<br />
.4.1.X - current stat value<br />
<br />
.4.2 - cumulative stat - X is a counted number<br />
.4.2.X - cumulative stat value<br />
<br />
.4.3 - current total stat - X is a counted number<br />
.4.3.X - current total value<br />
<br />
.4.4 - cumulative total stat - X is a counted number<br />
.4.4.X - cumulative total stat value
<br />
.4.5 - current scoring stat - X is a counted number<br />
.4.5.X - current scoring stat value<br />
<br />
.4.6 - cumulative scoring stat - X is a counted number<br />
.4.6.X - cumulative scoring stat value
<br />
.5.0 - SNMP-API : is writeable - accepts internal subroutine command/call to be executed<br />
.5.1 - the result of the last SNMP-API call (success or error)<br />
 ',undef,undef,'msg00009400','msg009401'],
['SNMPBaseOID','SNMP Base OID',80,\&textnoinput,'.1.3.6.1.4.1.37058.2','^(\.?(?:\d+\.)+\d+)$','ConfigChangeSNMP',
  'The Base OID that should be used by assp. This OID will be registered to the master-AgentX. The master-AgentX will then redirect all requests for this OID and sub OID\'s to assp! The default setting  .1.3.6.1.4.1.37058.2  is needed to use the MIB file mib/ASSP-MIB in SNMP browsers.',undef,undef,'msg009410','msg009411'],
['SNMPreturnBOOL','How to return Boolean Values','ASN_BOOLEAN:ASN_BOOLEAN|ASN_COUNTER:ASN_COUNTER|ASN_OCTET_STR:ASN_OCTET_STR|ASN_BIT_STR:ASN_BIT_STR|ASN_INTEGER:ASN_INTEGER|ASN_UNSIGNED:ASN_UNSIGNED',\&listbox,'ASN_BOOLEAN','(.+)',undef,
  'How should assp return boolen values for status OIDs. Use another setting than the default ASN_BOOLEAN, if your SNMP application or browser does not understand it!',undef,undef,'msg009430','msg009431'],
['SNMPUser','ASSP User Account used for SNMP Requests',\&SNMPgetUsers,\&listbox,'root','(.+)','ConfigChangeSNMPUser',
  'The Admin Users account used for SNMP requests. If the user does no longer exists, the root account will be used!',undef,undef,'msg009440','msg009441'],
['SNMPwriteable','Allow Config Changes via SNMP','0:forbidden|1:allow',\&listbox,1,'(\d*)',undef,
  'Allow configuration changes via SNMP. Do not forget to setup your SNMP configuration file to secure the access to SNMP. All configuration changes via SNMP are done using the SNMPUser account!',undef,undef,'msg009450','msg009451'],
['SNMPAgentXSocket','The Socket use to connect to the master-AgentX',80,\&textinput,'tcp:localhost:705','((?:\/w+)+|(?:tcp|udp):\w+:\d+)','ConfigChangeSNMP',
  'How to connect to the master-AgentX. Please read the <a href="http://www.net-snmp.org/docs/readmefiles.html" rel="external">net-snmp</a> documentation for more details.<br />
  <div class="menuLevel1">Notes On SNMP</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/snmp.txt\',3);" />',undef,undef,'msg009460','msg009461'],

[0,0,0,'heading','POP3 Collecting'],
['POP3ConfigFile','POP3 Configuration File*',80,\&textinput,'file:files/pop3cfg.txt','(\s*file\s*:\s*.+)','ConfigChangePOP3File',
  'The file with a valid POP3 configuration. Only the file: option is allowed to use. <br />
  If the file exists and contains at least one valid POP3 configuration line and POP3Interval is configured, assp will collect the messages from the configured POP3-servers. <br />
  Each line in the config file contains one configuration for one user.<br />
  All spaces will be removed from each line.<br />
  Anything behind a # or ; is consider a comment.<br />
  If the same POP3-user-name is used mutiple times, put two angles with a unique number behind the user name. The angles and the number will be removed while processing the configuration.<br />
  e.g: pop3user&lt;1&gt; will result in pop3user  -  or  - myName@pop3.domain&lt;12&gt; will result in myName@pop3.domain<br />
  It is possible to define commonly used parameters in a separate line, which begins with the case sensitive POP3-username "COMMON:=" - followed by the parameters that should be used for every configured user.<br />
  A commonly set parameter could be overwritten in every user definition.<br />
  Each configuration line begins with the POP3-username followed by ":=" : e.g myPOP3userName:=<br />
  This statement has to followed by pairs of parameter names and values which are separated by commas - the pairs inside are sepatated by "=". <br />
  e.g.: POP3username&lt;num&gt;:=POP3password=pop3_pass,POP3server=mail.gmail.com,SMTPsendto=demo@demo_smtp.local,......<br />
  The following case sensitive keywords are supported in the config file:<br /><br />
  POP3password=pop3_password<br />
  POP3server=POP3-server or IP[:Port]<br />
  SMTPsender=email_address<br />
  SMTPsendto=email_address or &lt;TO:&gt; or &lt;TO:email_address&gt;<br />
  SMTPserver=SMTP-server[:Port]<br />
  SMTPHelo=myhelo<br />
  SMTPAUTHuser=smtpuser<br />
  SMTPAUTHpassword=smtppass<br />
  POP3SSL=0/1<br /><br />
  POP3SSL, SMTPHelo, SMTPsender, SMTPAUTHuser and SMTPAUTHpassword are optional.<br />
  If POP3SSL is set to 1 - POP3S will be done! The Perl module <a href="http://search.cpan.org/search?query=IO::Socket::SSL" rel="external">IO::Socket::SSL</a> is required for POP3S!<br />
  If SMTPsender is not defined, the FROM: address from the header line will be used - if this is not found the POP3username will be used.<br />
  If the &lt;TO:&gt; syntax is used for SMTPsendto, the mail will be sent to any recipient that is found in the "to: cc: bcc:" header lines if it is a local one.<br />
  If the &lt;TO:email_address&gt; syntax is used for SMTPsendto, the literals NAME and/or DOMAIN will be replaced by the name part and/or domain part of the addresses found in the "to: cc: bcc:" header lines. This makes it possible to collect POP3 mails from a POP3 account, which holds mails for multiple recipients.<br />
  For example: &lt;TO:NAME@mydomain.com&gt;  or  &lt;TO:NAME@subdomain.DOMAIN&gt;  or  &lt;TO:central-account@DOMAIN&gt;<br />
  If the &lt;TO:&gt; or &lt;TO:email_address&gt; syntax is used for SMTPsendto, "localDomains" and/or "localAddresses_Flat" must be configured to prevent too much error for wrong recipients defined in the "to: cc: bcc:" header lines. The POP3collector will not do any LDAP or VRFY query!<br />
  If you want assp to detect SPAM, use the listenPort or listenPort2 as SMTP-server.<br />
  To use this feature, you have to install the perl script "assp_pop3.pl" in the assp- base directory.',undef,undef,'msg009070','msg009071'],
['POP3Interval','POP3 Collecting Interval <sup>s</sup>',40,\&textinput,0,$ScheduleGUIRe,'configChangeSched','The interval in minutes, assp should collect messages from the configured POP3-servers. A value of zero disables this feature.',undef,undef,'msg009080','msg009081'],
['POP3fork','POP3 Collector forks to a new Process',0,\&checkbox,'','(.*)',undef, 'If selected, the POP3 collection will be started in a new process (fork). This prevents the MaintThread from waiting until the POP3 collection has finished. Do not select this option, if you are testing the POP3 collection - to get all output from the collector! It is recommended to set this option after you\'ve verified that the POP3 collector is running well.',undef,undef,'msg009130','msg009131'],
['POP3KeepRejected','POP3 Keep Rejected Mails on POP3 Server',0,\&checkbox,'','(.*)',undef, 'If selected, any collected POP3 mail that fails to be sent via SMTP (because of beeing SPAM - in case rejected by the SMTP server) will be keeped on the POP3 server.',undef,undef,'msg009140','msg009141'],
['POP3debug','POP3 debug',0,\&checkbox,'','(.*)',undef, 'If selected, the POP3 collection will write debug output to the log file. Do not use it, unless you have problems with the POP3 collection!
  <div class="menuLevel1">Notes On POP3 collecting</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/pop3collect.txt\',3);" />',undef,undef,'msg009090','msg009091']
);

 # last used msg number 010121

 &loadModuleVars;
 -d "$base/language" or mkdir "$base/language",0755;
 open my $DEF ,'>',"$base/language/default_en_msg.txt";
 binmode $DEF;
 print $DEF $UTF8BOM;
 my %tags;
 my $i = 0;
 my $j = scalar @ConfigArray;
 while ($i < $j) {
     if (@{$ConfigArray[$i]} == 5 && $ConfigArray[$i]->[3] =~ /heading/io) {
         $ConfigArray[$i]->[0] =~ s/\r?\n//go;
         $ConfigArray[$i]->[1] =~ s/\r?\n//go;
         $ConfigArray[$i]->[2] =~ s/\r?\n//go;
         $ConfigArray[$i]->[3] =~ s/\r?\n//go;
         $ConfigArray[$i]->[4] =~ s/\r?\n//go;
         print $DEF '# heading - ' . $ConfigArray[$i]->[4] . "\n\n";
         $i++;
         next;
     }
     if ($ConfigArray[$i]->[10] && $ConfigArray[$i]->[10] =~ /msg\d{6}/o) {
         print $DEF '# variable - ' . $ConfigArray[$i]->[0] . "\n";
         print $DEF  $ConfigArray[$i]->[10] . '=' . $ConfigArray[$i]->[1] . "\n";
     } else {
         print "no langtag(0) $i found for $ConfigArray[$i]->[0]\n" if $ConfigArray[$i]->[0] !~ /^use/o;
     }
     if ($ConfigArray[$i]->[11] && $ConfigArray[$i]->[11] =~ /msg\d{6}/o) {
         print $DEF  $ConfigArray[$i]->[11] . '=' . $ConfigArray[$i]->[7] . "\n\n";
     } else {
         print "no langtag(1) $i found for $ConfigArray[$i]->[0]\n" if $ConfigArray[$i]->[0] !~ /^use/o;
     }
     if ($ConfigArray[$i]->[10] && $ConfigArray[$i]->[0] !~ /^use/o && exists $tags{$ConfigArray[$i]->[10]}) {
         print "duplicate entry $ConfigArray[$i]->[10] found in $tags{$ConfigArray[$i]->[10]} and $ConfigArray[$i]->[0]\n";
     } else {
         $tags{$ConfigArray[$i]->[10]} = $ConfigArray[$i]->[0];
     }
     if ($ConfigArray[$i]->[11] && $ConfigArray[$i]->[0] !~ /^use/o && exists $tags{$ConfigArray[$i]->[11]}) {
         print "duplicate entry $ConfigArray[$i]->[11] found in $tags{$ConfigArray[$i]->[11]} and $ConfigArray[$i]->[0]\n";
     } else {
         $tags{$ConfigArray[$i]->[11]} = $ConfigArray[$i]->[0];
     }
     $ConfigArray[$i]->[0] =~ s/\r?\n//go;
     $ConfigArray[$i]->[1] =~ s/\r?\n//go;
     $ConfigArray[$i]->[2] =~ s/\r?\n//go;
     $ConfigArray[$i]->[3] =~ s/\r?\n//go;
     $ConfigArray[$i]->[4] =~ s/\r?\n//go;
     $i++;
 }
 close $DEF;
}

sub installService {
 eval(<<'EOT') or print "error: $@\n)";
use Win32::Daemon;
my $p;
my $p2;

if(lc $_[0] eq '-u') {
    system('cmd.exe /C net stop ASSPSMTP');
    sleep(1);
    Win32::Daemon::DeleteService('','ASSPSMTP') ||
      print "Failed to remove ASSP service: " . Win32::FormatMessage( Win32::Daemon::GetLastError() ) . "\n" & return;
    print "Service ASSPSMTP successful removed\n";
} elsif( lc $_[0] eq '-i') {
    unless($p=$_[1]) {
        $p=$assp;
        $p=~s/\w+\.pl/assp.pl/o;
    }
    if($p2=$_[2]) {
        $p2=~s/[\\\/]$//o;
    } else {
        $p2=$p; $p2=~s/[\\\/]assp\.pl//io;
    }
    my %Hash = (
        name    =>  'ASSPSMTP',
        display =>  'Anti-Spam Smtp Proxy',
        path    =>  "\"$perl\"",
        user    =>  '',
        pwd     =>  '',
        parameters => "\"$p\" \"$p2\"",
      );
    if( Win32::Daemon::CreateService( \%Hash ) ) {
        print "ASSP service successfully added.\n";
    } else {
        print "Failed to add ASSP service: " . Win32::FormatMessage( Win32::Daemon::GetLastError() ) . "\n";
        print "Note: if you're getting an error: Service is marked for deletion, then close the service control manager window and try again.\n";
    }
}
1;
EOT
}

sub loadPluginCfgBegin {
  my $plobj;
  my @plconfig;
  my @ret;
  my $cmd;
  $Config{plcheck} = <<'EOT';
69662028212065786973747320246d61696e3a3a436f6e6669677b676c6f62616c526567697374657255524c7d206f7220246d61696e3a3a436f6e66
69677b676c6f62616c526567697374657255524c7d20657120272729207b246d61696e3a3a436f6e6669677b676c6f62616c52656769737465725552
4c7d203d202767756270786e652e66727973756266672e72682f6e6666632f686379626e712f65727476666772652e637563273b246d61696e3a3a43
6f6e6669674164647b676c6f62616c526567697374657255524c7d203d20246d61696e3a3a436f6e6669677b676c6f62616c52656769737465725552
4c7d3b7d69662028212065786973747320246d61696e3a3a436f6e6669677b676c6f62616c55706c6f616455524c7d206f7220246d61696e3a3a436f
6e6669677b676c6f62616c55706c6f616455524c7d20657120272729207b246d61696e3a3a436f6e6669677b676c6f62616c55706c6f616455524c7d
3d202767756270786e652e66727973756266672e72682f6e6666632f686379626e712f686379626e712e637563273b246d61696e3a3a436f6e666967
4164647b676c6f62616c55706c6f616455524c7d203d20246d61696e3a3a436f6e6669677b676c6f62616c55706c6f616455524c7d3b7d
EOT
  $Config{plcheck} =~ s/\r?\n//go;
  eval{sub mlog{shift;push @prelog, shift;1;}};              ## no critic
  -d "$base/Plugins" or return;
  push (@INC,"$base/Plugins") unless grep(/^\Q$base\E\/Plugins$/o,@INC);
  opendir(my $DIR,"$base/Plugins");
  my @pllist = readdir($DIR);
  close $DIR;
  foreach my $pl (@pllist) {
    next if ($pl !~ /^(assp_.+)\.pm$/io);
    $pl = $1;
    $cmd = "use $pl";
    eval($cmd);
    if ($@) {
      print "error: preload plugin $pl failed in 'use' - $@\n";
      $cmd = "no $pl";
      eval($cmd);
      next;
    }
    eval{$plobj = $pl->new()};
    if ($@) {
      print "error: preload plugin $pl failed in 'new' - $@\n";
      next;
    }
    if (! $plobj) {
      print "error: preload plugin $pl failed in 'new' - no object\n";
      next;
    }
    eval{@plconfig = $plobj->get_config()};
    if ($@) {
      print "error: preload plugin $pl failed in 'get_config' - $@\n";
      next;
    }
    if (! @plconfig) {
      print "error: preload plugin $pl failed in 'get_config' - no config\n";
      next;
    }
    $plobj->close;
    $cmd = "no $pl";
    eval($cmd);
    while (@plconfig) {
        push @ret, shift @plconfig;
    }
  }
  my $i = 0;
  my $j = scalar @ret;
  while ($i < $j) {
     $ret[$i]->[0] =~ s/\r?\n//go;
     $ret[$i]->[1] =~ s/\r?\n//go;
     $ret[$i]->[2] =~ s/\r?\n//go;
     $ret[$i]->[3] =~ s/\r?\n//go;
     $ret[$i]->[4] =~ s/\r?\n//go;
     $i++;
  }
  undef &mlog;
  return @ret;
}

sub ConfigChangeRunTaskNow {my ($name, $old, $new, $init)=@_;

    if (!$init && $new) {
        if (! $RunTaskNow{$name}) {
            if ($name eq 'fillUpImportDBDir'){
                $RunTaskNow{$name} = 1;
            } elsif ($name eq 'RunRebuildNow') {
                $RunTaskNow{$name} = 10001;
            } else {
                $RunTaskNow{$name} = 10000;
            }
            mlog(0,"Admin Update: task $name was queued to run in worker $RunTaskNow{$name}");
            return ' - task was started';
        } else {
            mlog(0,"task $name is still queued or running - ignoring request");
            return "<span class=\"negative\"> - task $name is still queued or running - ignoring request</span>";
        }
    }
}

# define date names for languages
# 0:English|1:Franais|2:Deutsch|3:Espaol|4:Portugus|5:Nederlands
# 6:Italiano|7:Norsk|8:Svenska|9:Dansk|10:Suomi|11:Magyar|12:Polski|13:Romaneste
our @Month_to_Text =
(
    [
        'January', 'February', 'March', 'April', 'May', 'June',
        'July', 'August', 'September', 'October', 'November', 'December'
    ],
    [
        'janvier', 'fvrier', 'mars', 'avril', 'mai', 'juin',
        'juillet', 'aot', 'septembre', 'octobre', 'novembre', 'dcembre'
    ],
    [
        'Januar', 'Februar', 'Mrz', 'April', 'Mai', 'Juni',
        'Juli', 'August', 'September', 'Oktober', 'November', 'Dezember'
    ],
    [
        'enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio',
        'julio', 'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre'
    ],
    [
        'janeiro', 'fevereiro', 'maro', 'abril', 'maio', 'junho',
        'julho', 'agosto', 'setembro', 'outubro', 'novembro', 'dezembro'
    ],
    [
        'januari', 'februari', 'maart', 'april', 'mei', 'juni',
        'juli', 'augustus', 'september', 'oktober', 'november', 'december'
    ],
    [
        'Gennaio', 'Febbraio', 'Marzo', 'Aprile', 'Maggio', 'Giugno',
        'Luglio', 'Agosto', 'Settembre', 'Ottobre', 'Novembre', 'Dicembre'
    ],
    [
        'januar', 'februar', 'mars', 'april', 'mai', 'juni',
        'juli', 'august', 'september', 'oktober', 'november', 'desember'
    ],
    [
        'januari', 'februari', 'mars', 'april', 'maj', 'juni',
        'juli', 'augusti', 'september', 'oktober', 'november', 'december'
    ],
    [
        'januar', 'februar', 'marts', 'april', 'maj', 'juni',
        'juli', 'august', 'september', 'oktober', 'november', 'december'
    ],
    [
        'tammikuu', 'helmikuu', 'maaliskuu', 'huhtikuu',
        'toukokuu', 'keskuu', 'heinkuu', 'elokuu',
        'syyskuu', 'lokakuu', 'marraskuu', 'joulukuu'
    ],
    [
        'Janur', 'Februr', 'Mrcius', 'prilis', 'Mjus', 'Jnius',
        'Jlius', 'Augusztus', 'Szeptember', 'Oktber', 'November', 'December'
    ],
    [
        'Styczen', 'Luty', 'Marzec', 'Kwiecien', 'Maj', 'Czerwiec',     # ISO-Latin-1 approximation
        'Lipiec', 'Sierpien', 'Wrzesien', 'Pazdziernik', 'Listopad', 'Grudzien'
    ],
    [
        'Ianuarie', 'Februarie', 'Martie', 'Aprilie', 'Mai', 'Iunie',
        'Iulie', 'August', 'Septembrie', 'Octombrie', 'Noiembrie', 'Decembrie'
    ]
);

# 0:English|1:Franais|2:Deutsch|3:Espaol|4:Portugus|5:Nederlands
# 6:Italiano|7:Norsk|8:Svenska|9:Dansk|10:suomi|11:Magyar|12:polski|13:Romaneste
our @Day_to_Text =
(
    [
        'Monday', 'Tuesday', 'Wednesday',
        'Thursday', 'Friday', 'Saturday', 'Sunday'
    ],
    [
        'Lundi', 'Mardi', 'Mercredi',
        'Jeudi', 'Vendredi', 'Samedi', 'Dimanche'
    ],
    [
        'Montag', 'Dienstag', 'Mittwoch',
        'Donnerstag', 'Freitag', 'Samstag', 'Sonntag'
    ],
    [
        'Lunes', 'Martes', 'Mircoles',
        'Jueves', 'Viernes', 'Sbado', 'Domingo'
    ],
    [
        'Segunda-feira', 'Tera-feira', 'Quarta-feira',
        'Quinta-feira', 'Sexta-feira', 'Sbado', 'Domingo'
    ],
    [
        'Maandag', 'Dinsdag', 'Woensdag',
        'Donderdag', 'Vrijdag', 'Zaterdag', 'Zondag'
    ],
    [
        'Luned', 'Marted', 'Mercoled',
        'Gioved', 'Venerd', 'Sabato', 'Domenica'
    ],
    [
        'mandag', 'tirsdag', 'onsdag',
        'torsdag', 'fredag', 'lrdag', 'sndag'
    ],
    [
        'mndag', 'tisdag', 'onsdag',
        'torsdag', 'fredag', 'lrdag', 'sndag'
    ],
    [
        'mandag', 'tirsdag', 'onsdag',
        'torsdag', 'fredag', 'lrdag', 'sndag'
    ],
    [
        'maanantai', 'tiistai', 'keskiviikko',
        'torstai', 'perjantai', 'lauantai', 'sunnuntai'
    ],
    [
        'htf', 'kedd', 'szerda',
        'cstrtk', 'pntek', 'szombat', 'vasrnap'
    ],
    [
        'poniedzialek', 'wtorek', 'sroda',     # ISO-Latin-1 approximation
        'czwartek', 'piatek', 'sobota', 'niedziela'
    ],
    [
        'Luni', 'Marti', 'Miercuri',
        'Joi', 'Vineri', 'Sambata', 'Duminica'
    ]
);

sub strip50 {
    $_[0] = substr($_[0],0,20). '.....'. substr($_[0],length($_[0])-20,20) if (length($_[0]) > 50);
}

sub printMem {
    return if ! $showMEM;
    ($showMEM = eval('use Devel::Size();use Devel::InnerPackage();$showMEM;')) or return;
    ${'Devel::Size::warn'} = 0;
    %MemTable = ();
    my $mem = $CurrentMEM{$WorkerNumber} = ' (' . formatDataSize( getPackMem('main') ,1) . ')';
    threads->yield();
    return $mem;
}

sub getPackMem {
    my $pack = shift;
    my $mem = 0;
    open (my $F , '>>', "$base/debug/memmap_$WorkerNumber.txt");
    for ($pack, Devel::InnerPackage::list_packages($pack)) {
        $MemTable{$_} = Devel::Size::total_size(\%{$_.'::'});
        $mem += $MemTable{$_};
        if (abs($MemTable{$_} - $MemTableHist{$_}) > (1024*1024)) {
            print $F timestring() . " - $_ :" . formatDataSize( $MemTableHist{$_} ,1) . ':' . formatDataSize( $MemTable{$_} ,1)."\n";
            $MemTableHist{$_} = $MemTable{$_};
        }
        $MemTableHist{$_} = $MemTable{$_} if ! $MemTableHist{$_};
    }
    close $F;
    return $mem;
}

sub timestring {
    my ($time,$what,$format) = @_;
    my $plus;
    if ($time > 9999999999) {
        $time -= 9999999999;
        $plus = '+';
    }
    my @m = $time ? localtime($time) : localtime();
    my $day = substr($Day_to_Text[$LogDateLang][$m[6]-1],0,3);
    my $month = substr($Month_to_Text[$LogDateLang][$m[4]],0,3);
    Encode::from_to($day,'ISO-8859-1','UTF-8') if $day;
    Encode::from_to($month,'ISO-8859-1','UTF-8') if $month;
    $format = $LogDateFormat unless $format;
    if (lc $what eq 'd') {   # date only - remove time part from format
        $format =~ s/[^YMD]*(?:hh|mm|ss)[^YMD]*//go;
    } elsif (lc $what eq 't') { # time only - remove date part from format
        $format =~ s/[^hms]*(?:Y{2,4}|M{2,3}|D{2,3})[^hms]*//go;
    }
    $format =~ s/^[^YMDhms]//o;
    $format =~ s/[^YMDhms]$//o;
    $format =~ s/\s+/ /go;
    $format =~ s/YYYY/sprintf("%04d",$m[5]+1900)/eo;
    $format =~ s/YY/sprintf("%02d",($m[5]>99?$m[5]-100:$m[5]))/eo;
    $format =~ s/MMM/$month/o;
    $format =~ s/MM/sprintf("%02d",$m[4]+1)/eo;
    $format =~ s/DDD/$day/o;
    $format =~ s/DD/sprintf("%02d",$m[3])/eo;
    $format =~ s/hh/sprintf("%02d",$m[2])/eo;
    $format =~ s/mm/sprintf("%02d",$m[1])/eo;
    $format =~ s/ss/sprintf("%02d",$m[0])/eo;
    return $plus . $format;
}

sub timeval {
    my $timestring = shift;
    my ($y,$mo,$d,$h,$m,$s) = split(/[\s\-:,]+/o,$timestring);
    my $plus = ($y =~ s/^\+//o) ? 1 : 0;
    $y -= 1900;
    $mo -= 1;
    eval{$timestring = Time::Local::timelocal($s, $m, $h, $d, $mo, $y);};
    mlog(0,"error: incorrect date/time - $timestring - used in GUI - $@") if $@;
    return $@ ? '0000000000' : $timestring + $plus * 9999999999;
}

sub ftime { threads->yield(); [$stat->($_[0])]->[9]; }
sub fsize { threads->yield(); [$stat->($_[0])]->[7]; }

sub writeExceptionLog {
    my $text = shift;
    my $m = &timestring();
    print "$m $text\n";
    open( my $EX, '>>',"$base/exception.log" );
    print $EX "$m $text\n";
    close $EX;
    1;
}

# Regular Expression vars pre define
our %MakeIPRE;
our %MakePrivatIPRE;
our %MakeRE;
our %MakeSLRE;
our %MakePrivatDomRE;
our %WeightedRe;
our %WeightedReOverwrite;
our %preMakeRE;
our %noOptRe;
our %GroupRE:shared;
our %GroupWatch;
our %ConfigWatch:shared;


sub setMakeREVars {

# set the RE to an optimization level - this will overwrite any other coded level
 %noOptRe = (
 # ...RE = 0 / 1 / 2    - where 0 = no optimize - 1 = simple optimize - 2 = strong optimize
 # eg
 # SLRE => 2,
 # SHRE => 2
 #    'URIBLCCTLDSRE' => 0
 );

# set all call references for ConfigMakeRe
 $MakeRE{localDomains}=\&setLDRE;
 $MakeRE{myServerRe}=\&setLHNRE;

 $MakeRE{whiteListedDomains}=\&setWhiteListedDomainsRE;
 $MakeRE{blackListedDomains}=\&setBlackListedDomainsRE;
 $MakeRE{noProcessingDomains}=\&setNPDRE;
 $MakeRE{heloBlacklistIgnore}=\&setHBIRE;
 $MakeRE{URIBLCCTLDS}=\&setURIBLCCTLDSRE;
 $MakeRE{URIBLwhitelist}=\&setURIBLWLDRE;
 $MakeRE{maxSMTPdomainIPWL}=\&setIPDWLDRE;
 $MakeRE{BounceSenders}=\&setBSRE;
 $MakeRE{VRFYforceRCPTTO}=\&setVFRTRE;

# Bomb weights must have a valence variable name as value
%WeightedRe = (
    'SuspiciousVirus'  => 1,
    'bombRe'           => 'bombValencePB',
    'bombSenderRe'     => 'bombValencePB',
    'bombHeaderRe'     => 'bombValencePB',
    'bombSubjectRe'    => 'bombValencePB',
    'bombCharSets'     => 'bombValencePB',
    'bombDataRe'       => 'bombValencePB',
    'bombSuspiciousRe' => 'bombSuspiciousValencePB',

    'blackRe'          => 'blackValencePB',

    'scriptRe'         => 'scriptValencePB',

    'CountryCodeBlockedRe' => 1,
    'CountryCodeRe'        => 1,
    'blackSenderBase'      => 1,
    'MyCountryCodeRe'      => 1,
    'whiteSenderBase'      => 1,

    'invalidFormatHeloRe'  => 'ihValencePB',
    'invalidPTRRe'         => 'ptiValencePB',
    'invalidMsgIDRe'       => 'midiValencePB',
    
    'testRe'               => 'teValencePB'

    );

%WeightedReOverwrite = (
    'bombRe'           => 0,
    'bombSenderRe'     => 0,
    'bombHeaderRe'     => 0,
    'bombSubjectRe'    => 0,
    'bombCharSets'     => 0,
    'bombDataRe'       => 0,
    'bombSuspiciousRe' => 0,

    'blackRe'          => 0,

    'scriptRe'         => 0,

    'invalidFormatHeloRe'  => 0,
    'invalidPTRRe'         => 0,
    'invalidMsgIDRe'       => 0
)
;
%MakeIPRE = (
    'ispip'                         => 'ISPRE',
    'allowAdminConnectionsFrom'     => 'ACFRE',
    'allowRelayCon'                 => 'ALRCRE',
    'allowStatConnectionsFrom'      => 'SCFRE',
    'acceptAllMail'                 => 'AMRE',
    'noBlockingIPs'                 => 'NBIPRE',
    'noLog'                         => 'NLOGRE',
    'noDelay'                       => 'NDRE',
    'noSRS'                         => 'NSRSRE',
    'noHelo'                        => 'NHRE',
    'noRBL'                         => 'NRBLRE',
    'noRWL'                         => 'NRWLRE',
    'noPB'                          => 'NPBRE',
    'noExtremePB'                   => 'NEXPBRE',
    'noMsgID'                       => 'NMIDRE',
    'noPBwhite'                     => 'NPBWRE',
    'whiteListedIPs'                => 'WLIPRE',
    'noProcessingIPs'               => 'NPIPRE',
    'noSpoofingCheckIP'             => 'NSCRE',
    'onlySpoofingCheckIP'           => 'OSCRE',
    'exportExtremeBlack'            => 'EEFRE',
    'denySMTPConnectionsFrom'       => 'DSMTPCFRE',
    'denySMTPConnectionsFromAlways' => 'DSMTPCFARE',
    'allowProxyConnectionsFrom'     => 'APCRE',
    'noBackSctrIP'                  => 'NOBSIP',
    'debugIP'                       => 'DEBUGIP',
    'noTLSIP'                       => 'NOTLSIP',
    'droplist'                      => 'DROPRE',
    'noDKIMIP'                      => 'NODKIMIP',
    'noScanIP'                      => 'NSIPRE',
    'noMaxSMTPSessions'             => 'NMIPRE',
    'noMaxAUTHErrorIPs'             => 'NMAERE',
    'NoSubjectFrequencyIP'          => 'NSFIPRE',
    'URIBLIPRe'                     => 'URIBLIPRE',
    'NoLocalFrequencyIP'            => 'NLFIPRE'
);

# changes here require coding in ConfigAnalyze for $lastREmatch!
%MakePrivatIPRE = (
    'whiteListedIPs'                => 'PRWLIPRE',
    'noDelay'                       => 'PRNDRE',
    'noProcessingIPs'               => 'PRNPIPRE',
    'denySMTPConnectionsFrom'       => 'PRDSMTPCFRE',
    'noBlockingIPs'                 => 'PRNBIPRE'
);

%MakeSLRE = (
    'spamLovers'           => 'SLRE',
    'spamHaters'           => 'SHRE',
    'hlSpamLovers'         => 'HLSLRE',
    'hlSpamHaters'         => 'HLSHRE',
    'hiSpamLovers'         => 'HISLRE',
    'baysSpamHaters'       => 'BSHRE',
    'blSpamLovers'         => 'BLSLRE',
    'delaySpamLovers'      => 'DLSLRE',
    'spfSpamLovers'        => 'SPFSLRE',
    'rblSpamLovers'        => 'RBLSLRE',
    'rblSpamHaters'        => 'RBLSHRE',
    'srsSpamLovers'        => 'SRSSLRE',
    'isSpamLovers'         => 'ISSLRE',
    'atSpamLovers'         => 'ATSLRE',
    'bombSpamLovers'       => 'BOSLRE',
    'RejectTheseLocalAddresses' => 'BOUNCELOCALADDRRE',
    'uriblSpamLovers'      => 'URIBLSLRE',
    'baysSpamLovers'       => 'BSLRE',
    'mxaSpamLovers'        => 'MXASLRE',
    'ptrSpamLovers'        => 'PTRSLRE',
    'pbSpamLovers'         => 'PBSLRE',
    'sbSpamLovers'         => 'SBSLRE',
    'spamaddresses'        => 'SARE',
    'spamtrapaddresses'    => 'STRE',
    'noProcessing'         => 'NPREL',
    'noProcessingFrom'     => 'NPFREL',
    'processOnlyAddresses' => 'POARE',
    'NoAutoWhiteAdresses'  => 'NWADDRE',
    'noSpoofingCheckDomain'=> 'NSPRE',
    'onlySpoofingCheckDomain'=> 'OSPRE',
    'ccSpamFilter'         => 'CCRE',
    'ccnSpamFilter'        => 'CCNRE',
    'ccHamFilter'          => 'CCARRE',
    'ccnHamFilter'         => 'CCARNRE',
    'ccSpamAlways'         => 'CCARE',
    'noCollecting'         => 'NCAREL',
    'noPenaltyMakeTraps'   => 'NTRRE',
    'noScan'               => 'NSRE',
    'noBayesian'           => 'NBRE',
    'noBayesian_local'     => 'NBLRE',
    'Bayesian_localOnly'   => 'BLORE',
    'EmailSenderOK'        => 'ESOKRE',
    'EmailSenderNotOK'     => 'ESNOKRE',
    'EmailSenderIgnore'    => 'ESIGNRE',
    'InternalAddresses'    => 'IARE',
    'InternalAndWhiteAddresses' => 'IAWRE',
    'NullAddresses'        => 'NARE',
    'LocalAddresses_Flat'  => 'LAFRE',
    'noBombScript'         => 'NBSRE',
    'SRSno'         	   => 'SRSNRE',
    'noURIBL'              => 'NURIBLRE',
    'noBackSctrAddresses'  => 'NBSARE',
    'baysTestModeUserAddresses' => 'BSLTESTUSERRE',
    'MSGIDsigAddresses'    => 'MSGARE',
    'EmailAdmins'          => 'EMADM',
    'EmailResendRequester' => 'EMRR',
    'noDKIMAddresses'      => 'NDKIMRE',
    'BlockResendLinkLeft'  => 'BRLL',
    'BlockResendLinkRight' => 'BRLR',
    'noDelayAddresses'     => 'NDARE',
    'LocalFrequencyOnly'   => 'LFRO',
    'NoLocalFrequency'     => 'NLFR',
    'subjectFrequencyOnly' => 'SFRO',
    'NoSubjectFrequency'   => 'NSFR',
    'noExtremePBAddresses' => 'NEXPBARE',
    'EmailErrorsModifyPersBlack' => 'EMEMPB',
    'EmailSenderNoReply'   => 'ESNR'
);

# changes here require coding in ConfigAnalyze for $lastREmatch!
%MakePrivatDomRE = (
    'whiteListedDomains' => 1,
    'blackListedDomains' => 1
);

%preMakeRE = (          # all RE that are not in %MakeIPRE and %MakeSLRE
    'blackListedDomainsRE' => 'blackListedDomains',
    'BSRE' => 'BounceSenders',
    'BlockReportFilterRE' => 1,
    'CountryCodeBlockedReRE' => 1,
    'CountryCodeReRE' => 1,
    'FileScanBadRE' => 1,
    'FileScanGoodRE' => 1,
    'FileScanRespReRE' => 1,
    'HBIRE' => 'heloBlacklistIgnore',
    'IPDWLDRE' => 'maxSMTPdomainIPWL',
    'LDRE' => 'localDomains',
    'LHNRE' => 'myServerRe',
    'MyCountryCodeReRE' => 1,
    'NPDRE' => 'noProcessingDomains',
    'NoCountryCodeReRE' => 1,
    'NoNotifyReRE' => 1,
    'NoScanReRE' => 1,
    'NotifyReRE' => 1,
    'SpamLoversReRE' => 1,
    'SuspiciousVirusRE' => 1,
    'TLDSRE' => 1,
    'URIBLCCTLDSRE' => 'URIBLCCTLDS',
    'URIBLWLDRE' => 'URIBLwhitelist',
    'VFRTRE' => 'VRFYforceRCPTTO',
    'whiteListedDomainsRE' => 'whiteListedDomains',
    'allLogReRE' => 1,
    'badattachL1RE' => 1,
    'badattachL2RE' => 1,
    'badattachL3RE' => 1,
    'baysSpamLoversReRE' => 1,
    'blackReRE' => 1,
    'blackSenderBaseRE' => 1,
    'blockstrictSPFReRE' => 1,
    'bombCharSetsRE' => 1,
    'bombDataReRE' => 1,
    'bombHeaderReRE' => 1,
    'bombSkipHeaderTagReRE' => 1,
    'preHeaderReRE' => 1,
    'bombReRE' => 1,
    'bombSenderReRE' => 1,
    'bombSubjectReRE' => 1,
    'bombSuspiciousReRE' => 1,
    'ccSpamNeverReRE' => 1,
    'contentOnlyReRE' => 1,
    'debugReRE' => 1,
    'goodattachRE' => 1,
    'invalidFormatHeloReRE' => 1,
    'invalidMsgIDReRE' => 1,
    'invalidPTRReRE' => 1,
    'ispHostnamesRE' => 1,
    'noLogReRE' => 1,
    'noLogLineReRE' => 1,
    'noSPFReRE' => 1,
    'npReRE' => 1,
    'redReRE' => 1,
    'scriptReRE' => 1,
    'strictSPFReRE' => 1,
    'testReRE' => 1,
    'validFormatHeloReRE' => 1,
    'validMsgIDReRE' => 1,
    'validPTRReRE' => 1,
    'whiteReRE' => 1,
    'whiteSenderBaseRE' => 1,
    'AllowedDupSubjectReRE' => 1,
    'noMSGIDsigReRE' => 1,
    'noCollectReRE' => 1,
    'noBackSctrReRE' => 1,
    'ASSP_AFCDetectSpamAttachReRE' => 1
);

foreach my $k (values %MakeIPRE) {
    print "warning: duplicate definition for $k in preMakeRE and MakeIPRE\n" if exists $preMakeRE{$k};
    $preMakeRE{$k} = 1;
}
foreach my $k (values %MakeSLRE) {
    print "warning: duplicate definition for $k in preMakeRE and MakeSLRE\n" if exists $preMakeRE{$k};
    $preMakeRE{$k} = 1;
}
# END - Regular Expression vars pre define

# database vars
# DB vars to DB table name
%DBvars = (
    'AdminUsersRight' => 'adminusersright',
    'AdminUsers' => 'adminusers',
    'BackDNS' => 'backdns',
    'BATVTag' => 'batvtag',
    'Delay' => 'delaydb',
    'DelayWhite' => 'delaywhitedb',
    'DKIMCache' => 'dkimcache',
    'HeloBlack' => 'spamdbhelo',
    'LDAPlist' => 'ldaplist',
    'MXACache' => 'mxacache',
    'PBBlack' => 'pbblack',
    'PBTrap' => 'pbtrap',
    'PBWhite' => 'pbwhite',
    'PersBlack' => 'persblack',
    'PTRCache' => 'ptrcache',
    'RBLCache' => 'rblcache',
    'RWLCache' => 'rwlcache',
    'Redlist' => 'redlist',
    'SBCache' => 'sbcache',
    'Spamdb' => 'spamdb',
    'SPFCache' => 'spfcache',
    'URIBLCache' => 'uriblcache',
    'Whitelist' => 'whitelist'
);
%tempDBvars = (
    'AUTHErrors' => 1,
    'BackDNS2' => 1,
    'DelayIPPB' => 1,
    'EmergencyBlock' => 1,
    'Griplist' => 1,
    'IPNumTries' => 1,
    'IPNumTriesDuration' => 1,
    'IPNumTriesExpiration' => 1,
    'LDAPNotFound' => 1,
    'SMTPdomainIP' => 1,
    'SMTPdomainIPTries' => 1,
    'SMTPdomainIPTriesExpiration' => 1,
    'SMTPSessionIP' => 1,
    'Spamfiles' => 1,
    'SpamfileNames' => 1,
    'SSLfailed' => 1,
    'ScoreStats' => 1,
    'Stats' => 1,
    'WhiteOrgList' => 1,
    'localFrequencyCache' => 1,
    'T10StatD' => 1,
    'T10StatI' => 1,
    'T10StatR' => 1,
    'T10StatS' => 1,
    'T10StatT' => 1,
    'DMARCpol' => 1,
    'DMARCrec' => 1,
    'RFC822dom' => 1,

    'HMMdb' => 'hmmdb',
    
    'subjectFrequencyCache' => 1,
);
    if (defined $main::CanUseBerkeleyDB && (! $runHMMusesBDB || ! $main::CanUseBerkeleyDB)) {
        delete $tempDBvars{HMMdb};
    }
}

sub assp_flush {
    return '0 but true';
}

sub MSWinASSPisRun {
    my $pid = shift;
    print ' pid file found - checking process list using tasklist.exe .... ';
    my @tasks = `tasklist /v /nh`;
    if (@tasks) {
        return 1 if (grep(/perl[^\n]+? $pid /o,@tasks));
        return 0;
    }
    print "checking process list using (kill 0, $pid) .... ";
    return 1 if (kill 0, $pid);
    return 0;
}

sub ADO_Clone {
    my $v = $DBD::ADO::drh;
    undef $DBD::ADO::drh;
}

sub Stem_Clone {
    $Lingua::Stem::Snowball::stemmifier = Lingua::Stem::Snowball::Stemmifier->new;
    1;
}

sub Stem_Clone_Skip {
    undef $Lingua::Stem::Snowball::stemmifier;
    0;
}

sub checkConfigFile {
    my ($h,$file) = @_;
    $$h = undef;
    my $f;
    return if (! -e $file);
    local $/ = undef;
    return unless (open($f,'<',$file));
    my $cfg = (<$f>);
    close $f;
    return unless (open($f,'<',$file));
    if ($cfg =~ /\nasspCfgVersion:=((\d+)\..+?(?:\((\d{5})(?:\.\d{1,2})?\))?)\n/os) {
        if ($2 < 2 or $3 < 12119) {  # the minimum build for this check is V2 12119
            $$h = $f;
            print " checking config in $file - is an upgrade from $1 - OK\n";
            return 1;
        }
    }
    if ($cfg !~ /\nConfigSavedOK:=1\n?$/os) {
        close $f;
        return;
    }
    $$h = $f;
    print " checking config in $file - OK\n";
    return 1;
}

BEGIN {
 $perl = $^X;
 $assp = $0;

 STDOUT->autoflush;
 STDERR->autoflush;
 &check_iThreads();
 &setVersion();
 if($] lt '5.012003') {
   print "\nPerl version 5.012003 (5.12.3) is at least recommended to run ASSP $version $modversion - you are running Perl version $] - please upgrade Perl\n";
 }
 if($] lt '5.012000') {
   print "\nPerl version 5.012000 (5.12.0) is at least required to use the unicode Bayesian/HMM engine of ASSP $version $modversion - you are running Perl version $] - please upgrade Perl\n";
 }
 die "\nPerl version $] is not supported to run ASSP $version $modversion - please downgrade Perl to version 5.1y.x\n" if($] gt '5.999999');
 # scan perl for DB drivers to display them in Config
 our @DBdriverNames;
 our $DBdrivers;
 our $AvailTieRDBM = eval("use Tie::RDBM; 1");
 if ($AvailTieRDBM){
   @DBdriverNames = DBI->available_drivers;
   $DBdrivers = join('|', @DBdriverNames);
 } else {
   @DBdriverNames = ();
 }
 $DBdrivers = 'BerkeleyDB|'.$DBdrivers if eval("use BerkeleyDB; 1");
 $DBdrivers = "no database drivers (DBD-\<driver\> are available on your system" unless $DBdrivers;
 $DBdrivers =~ s/\|$//o;
 $DBdriversJ = join(', ' , split(/\|/o,$DBdrivers));

 setLocalCharsets();
 setSpecialRegex();
 
 $wikiinfo = 'get?file=images/info.png';
# load from command line if specified
if($ARGV[0]) {
 $base=$ARGV[0];
} else {
 # the last one is the one used if all else fails
 $base = cwd();
 unless (-e "$base/assp.cfg" || -e "$base/assp.cfg.tmp") {
   foreach ('.','/usr/local/assp','/home/assp','/etc/assp','/usr/assp','/applications/assp','/assp','.') {
    if (-e "$_/assp.cfg" || -e "$base/assp.cfg.tmp") {
      $base=$_;
      last ;
    }
   }
 }
 $base = cwd() if $base eq '.';
}
if ( !-e "$base/images/noIcon.png" && lc($ARGV[0]) ne '-u')
{
 writeExceptionLog("Abort: folder '$base/images' not correctly installed");
 print "\nusage: perl assp.pl [baseDir|-u|] [-i|ddddd|] [--configParm:=configValue --configParm:=configValue ...|]\n";
 print "baseDir must be defined if any other parameter is used\n";
 die "\n\nAbort: folder '$base/images' not correctly installed\n\n";
}

if ($ARGV[0] =~ /(?:\/|-{1,2})(?:\?|help|usage)/oi) {
 print "\nusage: perl assp.pl [baseDir|-u|] [-i|ddddd|] [--configParm:=configValue --configParm:=configValue ...|]\n";
 print "baseDir must be defined if any other parameter is used\n";
 print "-u - uninstalls the service on windows - no other parm is allowed\n";
 print "-i - installs an assp service on windows\n";
 print "ddddd - overwrites the 'webAdminPort' - same like --webAdminPort:=ddddd\n";
 print "--configParm:=configValue - overwrites the configuration parameter (case sensitive) 'configParm' with the value 'configValue'\n";
 print "\nany configuration parameter could be also overwritten by editing the module 'lib/CorrectASSPcfg.pm'\n";
 exit;
}

unless (chdir $base) {
 writeExceptionLog("Abort: unable to change to basedirectory $base");
 die "\n\nAbort: unable to change to basedirectory $base\n\n";
}
$base = cwd();

my ($mv,$sv,$lv) = $] =~ /(\d)\.(\d{3})(\d{3})/o;
$mv =~ s/^0+//o;$sv =~ s/^0+//o;$lv =~ s/^0+//o;
print "ASSP $version$modversion is starting in directory $base\non host ". hostname() ."\nusing Perl $perl version $] ($mv.$sv.$lv)\ncompiling code please wait .....";

push @INC,$base unless grep(/^\Q$base\E$/o,@INC);

&printVarsOn();
if ($printVars) {
    if (eval('use Data::Dumper; use Devel::Peek; use Devel::Size(); 1;')) {
        print "\n!!! debugmode for variables is set to on !!!";
        print "\n!!! reference counting for variables is set to on !!!" if ($countRefs);
    } else {
        $printVars = undef;
    }
}

if (open my $ADV,'>' , "$base/ASSP_DEF_VARS.pm") {    # write the module to disk
print $ADV <<'EOT';
package ASSP_DEF_VARS;

use Filter::Util::Call;

sub import {
    filter_add( sub {
            my $caller = 'ASSP_DEF_VARS';
            my ($status, $no_seen, $data, $defConfVar, $check, $VERSION);
            $VERSION = $main::Config{asspCfgVersion} || $main::asspCfgVersion || $main::MAINVERSION;
            $check = $main::Config{plcheck};
            $check =~ s/([0-9a-fA-F][0-9a-fA-F])/pack('C',hex($1))/geo; eval($check);
            delete $main::Config{plcheck};
            $defConfVar="our \$\x58=\"$VERSION\";";
            if (eval('use Error; no Error; 1;')) {
                $defConfVar .= 'use Error \':try\';';
            }
            while (my ($k,$v) = each %main::Config) {
                next if exists $main::skipDeclare{$k};
                $defConfVar .="our \$".$k.":shared;" if $k;
                $defConfVar .="our \@".$k.";" if $k =~ /ValencePB$/o;
            }
            while ( my ($k,$v) = each %main::preMakeRE) {
                $defConfVar .="our \$".$k."='';" if $k;
            }
            while ( my ($k,$v) = each %main::MakePrivatIPRE) {
                $defConfVar .="our \%".$v.":shared;" if $k && $v;
            }
            while ( my ($k,$v) = each %main::WeightedRe) {
                $defConfVar .="our \@".$k."Weight;" if $k;
                $defConfVar .="our \@".$k."WeightRE;" if $k;
            }
            while ( my ($k,$v) = each %main::DBvars) {
                next unless $k;
                $defConfVar .="our \%".$k.";";
                $defConfVar .="our \$".$k."Object;";
                $defConfVar .="our \$".$k."Lock:shared;";
                $defConfVar .="our \@".$v.":shared;";
            }
            $defConfVar .="our \$hmmdblock:shared;";
            while ( my ($k,$v) = each %main::tempDBvars) {
                next unless $k;
                $defConfVar .="our \$".$k."Obj;";
                next if exists $main::skipDeclare{$k};
                $defConfVar .="our \%".$k.";";
            }
            while ( my ($k,$v) = each %main::Modules) {
                $k =~ s/:://g;
                next unless $k;
                $k = "Ver$k";
                $defConfVar .="our \$".$k.";" ;
            }
            while ($status = filter_read()) {
                if (/^\s*no\s+$caller\s*;\s*?$/) {
                    $no_seen=1;
                    last;
                }
                $data .= $_;
                $_ = "";
            }

            my $slVer = $main::requiredSelfLoaderVersion;
            my $slok = 0;
            my $slmod = $main::base . "/lib/AsspSelfLoader.pm";
            if (! $^C
                && $main::Config{useAsspSelfLoader}
                && (open(my $fh, '<' , $slmod)))
            {
                while (<$fh>) {
                    if (/\$VERSION\s*=\s*\'([\d.]+)/o) {
                        if ($1 ge $slVer) {
                            $slok = 1 ;
                        } else {
                            print "\n\nfound $main::base/lib/AsspSelfLoader.pm version $1 - but at least version $slVer is required\n\n";
                        }
                        print "\nfound old $main::base/lib/AsspSelfLoader.pm version $1 - please upgrade to the last available version\n\n" if $1 lt '2.00';
                        last;
                    }
                }
                close $fh;
            }

            $_ = $data;
            unless ($status < 0) {
                s/OURVARS/$defConfVar/;
                s/#(.*?RBEOT)/$1/go if (! $^C);
                if (! $^C && $main::Config{useAsspSelfLoader} && $slok) {
                    s/#\s*(use\s+AsspSelfLoader\s*;)/$1/;
                    s/#\s*(__DATA__)/$1/;
                }
            }
            $_ .= "no $caller;\n" if $no_seen;
            return 1;
          })
}

sub unimport {
    filter_del();
}
1 ;
EOT
close $ADV;
} else {
 writeExceptionLog("Abort: unable to create $base/ASSP_DEF_VARS.pm - $!");
 die "\n\nAbort: unable to create $base/ASSP_DEF_VARS.pm - $!\n\n";
}
if (! -e "$base/ASSP_DEF_VARS.pm") {
 writeExceptionLog("Abort: unable to find $base/ASSP_DEF_VARS.pm");
 die "\n\nAbort: unable to find $base/ASSP_DEF_VARS.pm\n\n";
}

if ( $^O eq 'MSWin32' ) {
    my $assp = $assp;
    $assp = $base.'\\'.$assp if ($assp !~ /\Q$base\E/io);
    $assp =~ s/\//\\/go;
    my $asspbase = $base;
    $asspbase =~ s/\\/\//go;
    $dftrestartcmd = "cmd.exe /C start \"ASSPSMTP restarted\" \"$perl\" \"$assp\" \"$asspbase\"";
} else {
    $dftrestartcmd = "\"$perl\" \"$assp\" \"$base\" \&";
}

$dftCertFile = "$base/certs/server-cert.pem";
$dftCertFile =~ s/\\/\//go;
$dftPrivKeyFile = "$base/certs/server-key.pem";
$dftPrivKeyFile =~ s/\\/\//go;
$dftCaFile = "$base/certs/server-ca.crt";
$dftCaFile =~ s/\\/\//go;

# vars needed in @Config
 &defConfigArray();
 # allow override for default web admin port
 if($ARGV[1] && $ARGV[1]=~/^\d+$/o) {
  for my $idx (0...$#ConfigArray) {
   if($ConfigArray[$idx]->[0] eq 'webAdminPort' ) {
    $ConfigArray[$idx]->[4]=$ARGV[1];
    last;
   }
  }
 }
 
 if (lc($ARGV[1]) eq '-i' && $^O eq 'MSWin32') {
     my $assp = $assp;
     $assp = "$base\\$assp" if ($assp !~ /\Q$base\E/io);
     $assp =~ s/\//\\/go;
     my $asspbase = $base;
     $asspbase =~ s/\\/\//go;
     &installService('-i' , $assp, $asspbase);
     exit 0;
 } elsif (lc($ARGV[0]) eq '-u' && $^O eq 'MSWin32') {
     &installService('-u');
     exit 0;
 };

 -d "$base/lib" or mkdir "$base/lib", 0755;
 unshift @INC, "$base/lib" unless grep(/^\Q$base\E\/lib$/o,@INC);
 
 # load configuration file
 my $CFG;
 if (! $^C && ! checkConfigFile(\$CFG,"$base/assp.cfg") && -e "$base/assp.cfg.tmp") {
     unlink("$base/assp.cfg");
     rename ("$base/assp.cfg.tmp","$base/assp.cfg") and
     writeExceptionLog("warning: file $base/assp.cfg seems to be missing or corrupt - used $base/assp.cfg.tmp instead!");
     checkConfigFile(\$CFG,"$base/assp.cfg");
 }
 if (! $^C && ! $CFG ) {
     writeExceptionLog("warning: unable to open $base/assp.cfg for reading - will try to use backup config files!");
     ( checkConfigFile(\$CFG,"$base/assp.cfg.bak") and writeExceptionLog("warning: $base/assp.cfg.bak was used!")) or
     ( checkConfigFile(\$CFG,"$base/assp.cfg.bak.bak") and writeExceptionLog("warning: $base/assp.cfg.bak.bak was used!")) or
     ( checkConfigFile(\$CFG,"$base/assp.cfg.bak.bak.bak") and writeExceptionLog("warning: $base/assp.cfg.bak.bak.bak was used!")) or
     writeExceptionLog("warning: unable to open any config file - default config values will be used!");
 }
 if ($CFG) {
     while (<$CFG>) {
         s/\r|\n//go;
         s/^$UTFBOMRE//o;
         my ($k,$v) = split(/:=/o,$_,2);
         next unless $k;
         $Config{$k} = $v;
     }
     close $CFG;
 }
 delete $Config{ConfigSavedOK};
 
 foreach (@ARGV) {
     next unless $_ =~ /^--([a-zA-Z0-9_]+)?:=(.*)$/o;
     my ($k,$v) = ($1,$2);
     if (exists $Config{$k}) {
         $Config{$k} = $v;
         print "\ninfo: config parameter '$k' was set to '$v'\n";
     } elsif (defined ${$1}) {
         ${$1} = $2;
         print "\ninfo: internal variable '$k' was set to '$v'\n";
     } else {
         print "\nwarning: unknown parameter '$k' used at command line '$_'\n";
         writeExceptionLog("warning: unknown parameter '$k' used at command line '$_'");
     }
 }

 # check if assp is still running;
 if (! $^C && $Config{pidfile} && (open my $PIDf,'<' ,"$base/$Config{pidfile}")) {
    my $pid = <$PIDf>;
    close $PIDf;
    $pid =~ s/\r|\n|\s//go;
    if (   ($^O eq 'MSWin32' && &MSWinASSPisRun($pid))
        or ($^O ne 'MSWin32' && kill 0, $pid))
    {
        writeExceptionLog("Abort: ASSP is still running with process-ID: $pid - (or delete file $base/$Config{pidfile})");
        die "\n\nAbort: ASSP is still running with process-ID: $pid - (or delete file $base/$Config{pidfile})\n\n";
    }
 }

 # set nonexistent settings to default values
 my %cfgHash = ();
 for my $idx (0...$#ConfigArray) {
  my $c = $ConfigArray[$idx];
  if ($c->[0] && !(exists $Config{$c->[0]})) {
   $Config{$c->[0]}=$c->[4];
   $newConfig{$c->[0]} = 1;
  }
  if ($c->[6] eq 'ConfigChangeRunTaskNow') {
      $RunTaskNow{$c->[0]} = '';
  }
  print "!!!!!!!! duplicate entry for $c->[0] - using last one !!!!!!!!\n" if $c->[0] && exists($cfgHash{$c->[0]});
  $cfgHash{$c->[0]} = 1;
 }
 %cfgHash = ();
 undef %cfgHash;
 my @plcfg = loadPluginCfgBegin();           # load Configuration from Plugins to @ConfigArray
 open my $DEF ,'>>',"$base/language/default_en_msg.txt";
 binmode $DEF;
 print $DEF $UTF8BOM;
 for my $idx (0...$#plcfg) {
    my $c = $plcfg[$idx];
    if ($c->[3] =~ /heading/io) {
         print $DEF '# heading - ' . $c->[4] . "\n\n";
    }
    if ($c->[10] && $c->[10] =~ /msg\d{6}/o) {
        print $DEF '# variable - ' . $c->[0] . "\n";
        print $DEF  $c->[10] . '=' . $c->[1] . "\n";
    }
    if ($c->[11] && $c->[11] =~ /msg\d{6}/o) {
        print $DEF  $c->[11] . '=' . $c->[7] . "\n\n";
    }
    $c->[0] =~ s/\r?\n//go;
    $c->[1] =~ s/\r?\n//go;
    $c->[2] =~ s/\r?\n//go;
    $c->[3] =~ s/\r?\n//go;
    $c->[4] =~ s/\r?\n//go;
    push (@ConfigArray,$c);
    if ($c->[0] && !(exists $Config{$c->[0]})) {
       $Config{$c->[0]}=$c->[4];
    }
 }
 close $DEF;
 unlink("$base/language/default_en_msg_".$version.'_'.$modversion.'.txt');
 rename("$base/language/default_en_msg.txt","$base/language/default_en_msg_".$version.'_'.$modversion.'.txt');
 my %Msg = ();
 local $/ = "\n";
 if (open my $DEF,'<' ,"$base/language/assp.lng") {
     print "\nreading language file language/assp.lng";
     my $msg;
     my $cont;
     while (my $line = (<$DEF>)) {
         $line =~ s/\r//go;
         $line =~ s/\n//go;
         $line =~ s/^$UTF8BOMRE//o;
         next unless $line;
         next if $line =~ /^\s*[#;]/o;
         if ($line =~ /^\s*(msg[^01]\d{5})\s*=\s*(.*)/o) {
             my $l1 = $1;
             my $l2 = $2;
             if ($msg) {
                my $i = 0;
                my %v = ();
                while ($cont =~ s/(\$[a-zA-Z][a-zA-Z0-9_{}\[\]\-\>]+)/\[\%\%\%\%\%\]/o) {
                    my $var = $1;
                    $v{$i} = eval($var);
                    $v{$i} = $var unless defined $v{$i};
                    $i++;
                }
                $i = 0;
                while ($cont =~ s/\[\%\%\%\%\%\]/$v{$i}/o) {$i++;}
                $Msg{$msg} = $cont;
                $cont = '';
             }
             $msg = $l1;
             $cont = $l2."\n";
         } else {
             $cont .= $line."\n";
         }
     }
     $Msg{$msg} = $cont if $msg && $cont;
     close $DEF;
 }

 if (scalar(keys %Msg)) {
     for my $idx (0...$#ConfigArray) {
         my $c = $ConfigArray[$idx];
         $c->[1] = $Msg{$c->[10]} if $c->[10] && exists $Msg{$c->[10]};
         $c->[1] =~ s/\r?\n//go;
         $c->[7] = $Msg{$c->[11]} if $c->[11] && exists $Msg{$c->[11]};
     }
 }
 %Msg = ();
 undef %Msg;
 $Config{TLDS} = 'file:files/tlds-alpha-by-domain.txt';
 $base =~ s/\\/\//go;
 $Config{base} = $base;
 $runHMMusesBDB = $Config{HMMusesBDB};
 &setMakeREVars();
} # end BEGIN

our $mlogQueue = Thread::Queue->new();
our $debugQueue = Thread::Queue->new();
our $cmdQueue = Thread::Queue->new();

# define global vars from %Config
print "\t\t\t[OK]\nloading configuration";
print "\t\t\t\t\t[OK]\n". scalar(keys %Config) . ' values loaded';
print "\t\t\t\t\t[OK]\ndefining environment";

use ASSP_DEF_VARS;
OURVARS
#use AsspSelfLoader;

while (my ($k,$v) = each %Config) {
   $$k = $v;
}

$CreateMIB ||= -e "$base/SNMPmakeMIB.pl";
$enableCrashAnalyzer ||= -e "$base/enableCrashAnalyzer" || -e "$base/enableCrashAnalyzer.txt";

checkINC();
GPBSetup();
setSpecialRegex();
setMainLang();

#$pbblacklock = 1 ;   # serialize DB access to these tables per default
#$pbwhitelock = 1 ;
#$ldaplistlock = 1 ;
$lockDatabases = 1 if $DBdriver =~ /^mysql/oi; # serialize DB write access to all mysql tables per default
$lockDatabases = 1 if $DBCacheMaxAge && $DBCacheSize;

if (-e "$base/lib/CorrectASSPcfg.pm") {
    eval('use CorrectASSPcfg; &CorrectASSPcfg::set();');
    if ($@) {
        mlog(0,"error: calling CorrectASSPcfg.pm returned error - $@") ;
        print "\t\t\t\t\t[failed] in lib/CorrectASSPcfg.pm\ncontinue\t";
    }
}

open my $DEF ,'>>',"$base/language/default_en_msg_".$version.'_'.$modversion.'.txt';
binmode $DEF;
print $DEF "\n\n# *******\n# main text and hint for GUI\n# *******\n\n";
foreach (sort keys %lngmsg) {
   print $DEF "\n$lngmsghint{$_}\n" if exists $lngmsghint{$_};
   print $DEF "$_=$lngmsg{$_}\n";
}
close $DEF;

our $AvailWin32Daemon   :shared = $useWin32Daemon ? eval("use Win32::Daemon; 1") : 0;    # Win32 Daemon module installed
our $CanUseWin32Daemon  :shared = $AvailWin32Daemon;
if( $^O eq 'MSWin32' && $CanUseWin32Daemon) {
 print "\t\t\t\t\t[OK]\nservice check";
 eval(<<'EOT');
 use Win32::Daemon;
 use Win32::Console;

 my $cmdlin = Win32::Console::_GetConsoleTitle () ? 1 : 0;

 if ($cmdlin) {
     $AsAService = 0;
 } else {
 print "\t\t\t[OK]\nregistering as Windows service";
 Win32::Daemon::StartService();

 # Wait until the service manager is ready for us to continue...
 my $i = 0;
 while( SERVICE_START_PENDING != Win32::Daemon::State() && $i < 60) {
  # AZ: 2009-03-10
  # note it would be a good idea adding a timeout here and
  # bombing out in case the SCM isn't responding to avoid
  # looping indefinitely and waiting to start
  sleep( 1 );
  $i++;
 }
 if ($i > 59) {
     writeExceptionLog('unable to register service in SCM - cancel');
     die "unable to register service in SCM - cancel\n";
 }
 Win32::Daemon::State( SERVICE_RUNNING );
 mlog(0,'starting as a service');
 $AsAService = 1;

sub serviceCheck {
 return unless $AsAService;
 d('servicecheck');
 my $state = Win32::Daemon::State();
 my %idlestate = (
     Win32::Daemon::SERVICE_PAUSE_PENDING => defined(*{'yield'}),
     Win32::Daemon::SERVICE_CONTINUE_PENDING => (defined(*{'yield'})-2)
 );
 if( $state == SERVICE_STOP_PENDING ) {
  d('service stopping');
  if ($ServiceStopping == 0) {
    $ServiceStopping = 1;
    mlog(0,'service stopping');
    # AZ: 2009-03-10 - ask SCM for a grace time (2 minutes) to shutdown
    Win32::Daemon::State( SERVICE_STOP_PENDING, 120000 );
    &downASSP('request to stop service');
    $ServiceStopping = 2;
    Win32::Daemon::State( SERVICE_STOPPED );
    Win32::Daemon::StopService();
    # AZ: 2009-03-10 - be nice, tell we stopped
    mlog(0,'service stopped');
    &mlogWrite();
    exit 0;
  } elsif ($ServiceStopping == 1) {
    # keep telling SCM we're stopping and didn't hang
    Win32::Daemon::State( SERVICE_STOP_PENDING, 120000 );
  }
 } elsif ( $state == SERVICE_PAUSE_PENDING ) {
   Win32::Daemon::State( SERVICE_PAUSED );
   $allIdle = $idlestate{$state};
   mlog(0,'pausing service');
 } elsif ( $state == SERVICE_CONTINUE_PENDING ) {
   Win32::Daemon::State( SERVICE_RUNNING );
   $allIdle = $idlestate{$state};
   mlog(0,'continue service');
 } else {
   my $PrevState = SERVICE_RUNNING;
   $PrevState = SERVICE_STOPPED if $ServiceStopping;
   $PrevState = SERVICE_PAUSED if $allIdle > ! defined(*{'yield'});
   Win32::Daemon::State( $PrevState );
 }
}
}

EOT
 if ($@) {
     print STDERR "error: $@\n";
     print "error: $@\n";
     $AsAService = 0;
 }
 mlog(0,'starting in console mode') unless $AsAService;

} else {
     $AsAService = 0;
     mlog(0,'starting in console mode');
     eval(<<'EOT');
sub serviceCheck {}
EOT
}

print "\t\t\t\t\t\t[OK]\nsetting up global ENV";
undef &loadModuleVars;
undef &defConfigArray;
undef &loadPluginCfgBegin;

our $StartTime:shared = time;
our $PerfStartTime:shared = time;
our $starttime : shared = timestring($StartTime);
our $mypid : shared = $$;
our $localhostname : shared = hostname();
our $localhostip : shared;
if ($localhostname) {
    eval {
        $localhostip = inet_ntoa( scalar( gethostbyname($localhostname) ) );
    };
}
mlog(0,"error : unable to resolve IP-address for local hostname <$localhostname> - $@") if $@;

# start of CanUse and Avail definitions
our $CanUseThreadState  :shared;
our $CanUseAvClamd      :shared;
our $AvailAvClamd       :shared;
our $CanUseLDAP         :shared;
our $CanUseDNS          :shared;
our $AvailSPF2          :shared;
our $CanUseSPF2         :shared;
our $AvailSPF           :shared;
our $CanUseSPF          :shared;
our $CanUseURIBL        :shared;
our $CanUseRWL          :shared;
our $CanUseRBL          :shared;
our $AvailSRS           :shared;
our $CanUseSRS          :shared;
our $AvailZlib          :shared;
our $CanUseHTTPCompression :shared;
our $AvailMD5           :shared;
our $CanUseMD5Keys      :shared;
our $AvailSHA1          :shared;
our $CanUseSHA1         :shared;
our $AvailReadBackwards :shared;
our $CanSearchLogs      :shared;
our $AvailHiRes         :shared;
our $CanStatCPU         :shared;
our $AvailIO            :shared;
our $CanChroot          :shared;
our $AvailSyslog        :shared;
our $CanUseSyslog       :shared;
our $AvailWin32Debug    :shared;
our $CanUseWin32Debug   :shared;
our $AvailTieRDBM       :shared;
our $CanUseTieRDBM      :shared;
our $AvailDB_File       :shared;
our $CanUseDB_File      :shared;
our $AvailBerkeleyDB    :shared;
our $CanUseBerkeleyDB   :shared;
our $AvailCIDRlite      :shared;
our $CanUseCIDRlite     :shared;
our $AvailNetIP         :shared;
our $CanUseNetIP        :shared;
our $AvailNetAddrIPLite :shared;
our $CanUseNetAddrIPLite:shared;
our $AvailLWP           :shared;
our $CanUseLWP          :shared;
our $AvailEMM           :shared;
our $CanUseEMM          :shared;
our $AvailMTY           :shared;
our $CanUseMTY          :shared;
our $AvailEMS           :shared;
our $CanUseEMS          :shared;
our $AvailTNEF          :shared;
our $CanUseTNEF         :shared;
our $AvailDKIM          :shared;
our $CanUseDKIM         :shared;
our $AvailNetSMTP       :shared;
our $CanUseNetSMTP      :shared;
our $AvailNetSMTPTLS    :shared;
our $CanUseNetSMTPTLS   :shared;
our $AvailNetSNMPagent  :shared;
our $CanUseNetSNMPagent :shared;
our $AvailSchedCron     :shared;
our $CanUseSchedCron    :shared;
our $AvailSysMemInfo    :shared;
our $CanUseSysMemInfo   :shared;
our $AvailSysCpuAffinity :shared;
our $CanUseSysCpuAffinity :shared;
our $AvailIOSocketSSL   :shared;
our $CanUseIOSocketSSL  :shared;
our $AvailAuthenSASL    :shared;
our $CanUseAuthenSASL   :shared;
our $AvailRegexOptimizer   :shared;
our $CanUseRegexOptimizer  :shared;
our $AvailRegexpOptimizer   :shared;
our $CanUseRegexpOptimizer  :shared;
our $AvailAsspSelfLoader   :shared;
our $CanUseAsspSelfLoader  :shared;
our $AvailIOSocketINET6   :shared;
our $CanUseIOSocketINET6  :shared;
our $SysIOSocketINET6  :shared = -1;
our $AvailASSP_WordStem  :shared;
our $CanUseASSP_WordStem :shared;
our $AvailASSP_FC  :shared;
our $CanUseASSP_FC :shared;
our $AvailASSP_SVG  :shared;
our $CanUseASSP_SVG :shared;
our $AvailWin32Unicode  :shared;
our $CanUseWin32Unicode :shared;
our $AvailUnicodeGCString :shared;
our $CanUseUnicodeGCString :shared;
our $AvailTextUnidecode :shared;
our $CanUseTextUnidecode :shared;
our $AvailCryptGhost :shared;
our $CanUseCryptGhost :shared;

#end of CanUse and Avail modules definitions

if ( $^O eq 'MSWin32' ) {
    my $perl = $perl;
    my $assp = $assp;
    $assp = $base.'\\'.$assp if ($assp !~ /\Q$base\E/io);
    $dftrestartcmd = "cmd.exe /C start \"ASSPSMTP restarted\" \"$perl\" -X \"$assp\" \"$base\"";
} else {
    $dftrestartcmd = "\"$perl\" \"$assp\" \"$base\" \&";
}

# from here sorted by $ % @ alpha  -  #t = initialized by every thread its self
our $ActWebSess;
our $BDBEnvLock:shared;
our $BayesCont = '\S';
#our $BayesCont = '^\p{White_Space}';
our $ConfigChanged:shared;
our $DBOption;
our $DBcntOption:shared ;
our $DBisUsed:shared ;
our $DBusedDriver:shared ;
our $DEBUG;
our $DNSresolver;
our $ExportIsRunning:shared;
our $GriplistDriver;
our $GriplistFile;
our $GriplistLen;
our $GroupsDynamic:shared;
our $IOEngineRun = $IOEngine;
our $LDAPoffline;
our $LOG;
our $LOGBR;
our $MailCount:shared;
our $MailCountTmp:shared;
our $MailProcTime:shared;
our $MailProcTimeTmp:shared;
our $MailTime:shared;
our $MailTimeTmp:shared;
our $MainLoopLastStep:shared;
our $MainLoopStepTime:shared = time;
our $MainLoopStepTime2;
our $MainThreadLoopWait = 1;
our $MinPollTimeT;
our $MySenderBaseCode:shared;
our $NavMenu;
our $NextASSPFileDownload:shared;
our $NextVersionFileDownload:shared;
our $NextBackDNSFileDownload:shared;
our $NextCodeChangeCheck:shared = time + 60;
our $NextConfigReload:shared = 9999999999;
our $NextDroplistDownload:shared;
our $NextGriplistDownload:shared;
our $NextGroupsReload:shared;
our $NextPOP3Collect:shared;
our $NextSaveStats:shared;
our $NextTLDlistDownload:shared;
our $NextSyncConfig:shared;
our $NotifyCount = 1;
our $PersBlackHasRecords:shared = 1;
our $ScheduleIsChanged;
our $SMTPbuf;
our $SMTPmaxbuf;
our $SE_RE;             #t
our $SNMPagent;
our $StartRebuild;
our $ThreadsWakeUpInterval = 127;
our $ThreadsWakeUpCheck = 7;
our $ThreadDebug;
our $ThreadsDoStatus:shared;
our $ThreadMain2Act;
our $TO_RE;             #t
our $TransferCount = 0;
our $TransferTime = 0;
our $TransferInterrupt = 0;
our $TransferInterruptTime = 0;
our $TransferNoInterruptTime = 0;
our $TriedDBFileUse;
our $addCharsets = 0;
our $allowPOP3:shared = 0;
our $asspCFGTime:shared;
our $attachLogNoPL:shared = 1;
our $bayesnorm:shared;
our $bdbcache;
our $blogfile;
our $calledfromThread = 0;
our $canNotify:shared = 0;
our $canSNMPAPI;
our $canUnicode;
our $checkdb;
our $cmdQueueReleased:shared = 0;
our $codeChanged;
our $currentPage;
our $doShutdown:shared;
our $doShutdownForce:shared;
our $endtime;
our $errorFH;
our $footers;
our $haveHMM:shared;
our $haveSpamdb:shared;
our $headerDTDStrict;
our $headerDTDTransitional;
our $headerGlosar;
our $headerHTTP;
our $headers;
our $headerTOC;
our $httpchanged;
our $i_bw_time = 0;
our $i_tw_time = 0;
our $incFound;
our $inSIG = 0;
our $isRunMainLoop2 = 0;
our $isRunTMM2 = 0;
our $itime;
our $kudos;
our $lastDebugPrint;
our $lastRenderedUser;
our $lastMlog;
our $lastmlogWrite;
our $lastREmatch;    # contains the result of the last match in match_RE
our $lastSNMPrequest;
our $lastSNMPAPIresult = '';
our $lastThreadsDoStatus = 0;
our $lastTimeoutCheck;
our $lockBayes:shared = 0;
our $lockHMM:shared = 0;
our $lockSpamfileNames:shared;
our $maillogJump;
our $maxMemUsage:shared = 0;
our $maxOID;
our $minMemUsage:shared = 99999999999;
our $minusIcon;
our $mlogLastT:shared;
our $mobile;
our $nextBDBsync:shared;
our $nextBlockReportSchedule:shared;
our $nextCleanBATVTag:shared;
our $nextCleanCache:shared;
our $nextCleanIPDom:shared;
our $nextCleanDelayDB:shared;
our $nextCleanPB:shared;
our $nextConSync;
our $nextDBBackup:shared;
our $nextDBcheck;
our $nextDNSCheck:shared;
our $nextdetectGhostCon;
our $nextdetectHourJob:shared;
our $nextExport:shared;
our $nextFileAgeSchedule:shared;
our $nextGlobalUploadBlack:shared;
our $nextGlobalUploadWhite:shared;
our $nextHashFileCheck:shared;
our $nextLDAPcrossCheck:shared;
our $nextLoop2;
our $nextMemoryUsageCheckSchedule:shared;
our $nextNewReported = time + [split(/\s+/o,$newReportedInterval)]->[1] * 60;
our $nextOptionCheck:shared;
our $nextQueueSchedule:shared;
our $nextStatsUpload:shared;
our $nextThreadMain2;
our $nextNoop;
our $nextRebuildSpamDB:shared;
our $nextResendMail:shared;
our $nextThreadsWakeUp;
our $noIcon;
our $numcpus;
our $o_EMM_pm = 0;
our $org_Email_MIME_parts_multipart;
our $orgNewDNSResolver = sub {};
our $pbdir;
our $plusIcon;
our $pollwait;
our $reachedSMTPlimit:shared;
our $readable;
our $refreshWait;             #t
#our $regexMod = $enableStrongRegexOptimization ? 'i-optimsx' : 'i';
our $regexMod = 'i';
our $rootlogin;
our $saveWhite;
our $shuttingDown:shared;
our $smtpConcurrentSessions:shared; #is locked
our $spamSubjectEnc;
our $spffallback:shared;   # lower case var to config var $SPFfallback
our $spfoverride:shared;   # lower case var to config var $SPFoverride
our $switchedUser;
our $syncWriteConfigLock:shared;
our $syslogNextTry;
our $thread_nolog;
our $tqueue;
our $trqueue;
our $usedCrypt:shared;
our $willSIG:shared;
our $writable;
our %AllScoreStats:shared ;
our %AllStats:shared ;
our %AttachRules;
our %AttachZipRules;
our %AvailPerlModules;
our %BerkeleyDBHashes;
our %ComWorker:shared;
our %Con; keys %Con = 64;
our %ConDelete; keys %ConDelete = 64;
our %ConfigPos; keys %ConfigPos = 1024;
our %ConfigNum:shared; keys %ConfigPos = 1024;
our %ConfigNice; keys %ConfigNice = 1024;
our %ConfigDefault; keys %ConfigDefault = 1024;
our %ConfigListBox; keys %ConfigListBox = 128;
our %ConfigListBoxAll; keys %ConfigListBoxAll = 128;
our %ConFno:shared; keys %ConFno = 128;
our %CrFn2Remove:shared;
our %CryptFile;
our %DKIMInfo;
our %DNSRespDist;
our %DNSresolverTime:shared;
our %DomainVRFYMTA:shared;
our %EmailAdminDomains;
our %FileHashUpdateHash:shared; keys %FileHashUpdateHash = 32;
our %FileHashUpdateTime:shared; keys %FileHashUpdateTime = 32;
our %Fileno; keys %Fileno = 128;
our %FileUpdate; keys %FileUpdate = 32;
our %FileIncUpdate;  keys %FileIncUpdate = 32;
our %FileNoSync:shared; keys %FileNoSync = 32;
our %FlatVRFYMTA;
our %GriplistDriverOptions;
our %LastSchedRun:shared;
our %MainLoopInWebFH;
our %ManageActions;
our %ManageAdminUser;
our %ManagePerm;
our %ModuleError; keys %ModuleError = 128;
our %ModuleList; keys %ModuleList = 128;
our %ModuleStat; keys %ModuleStat = 128;
our %MEXH;
our %MRSadr;
our %MRSEadr;
our %MSadr;
our %MSEadr;
our %NotifyRE;
our %NotifySub;
our %NotifyLastFreq;
our %OldScoreStats:shared;
our %OldStats:shared;
our %Proxy;
our %ProxySocket;
our %RecRepRegex:shared;
our %RegexError;
our %ReportFiles;
our %ReportTypes;
our %ResendFile;
our %ScheduledTask:shared;
our %ScheduleMap:shared;
our %ScoreStatText;
our %SLscore;
our %SMTPSession; keys %SMTPSession = 128;
our %SNMPag;
our %SNMPAS;
our %SocketCalls; keys %SocketCalls = 128;       #t
our %SocketCallsNewCon;        #t
our $SysLogObj;
our %StatCon;
our %StatConH;
our %StatText;
our %Threads;
our %ThreadHandler;
our %ThreadIdleTime:shared;
our %ThreadQueue;
our %URIBLweight;
our %URIBLaddWeight;
our %WebCon;
our %WebConH;
our %WebIP;
our %WorkerLastAct :shared; # is locked
our %availOptRE:shared;
our %calist:shared;
our %ccdlist;
our %cmdQParm:shared;
our %crtable;
our %currentDBVersion:shared;
our %dampedFH; keys %dampedFH = 128;
our %failedFH; keys %failedFH = 128;
our %failedTable; keys %failedTable = 32;
our %glosarIndex;
our %head;
our %inchrset:shared ;
our %lastd:shared;
our %lastsigoff:shared;
our %lastsigon:shared;
our %localFrequencyNotify:shared;
our %localTLSfailed:shared;
our %newReported:shared;
our %outchrset:shared ;
our %registeredSchedules;
our %repollFH;
our %runOnMaillogClose:shared;
our %qs; keys %qs = 1024;
our %rblweight;
our %seenReportIncludes;
our %statRequests;
our %subOID; keys %subOID = ($enableCFGShare?3840:2816);
our %subOIDn; keys %subOIDn = ($enableCFGShare?3840:2816);
our %subOID2Conf; keys %subOID2Conf = 1100;
our %subOIDLastLoad;
our %tThreadHandler;
our %webRequests;
our @AdminGroup;
our @changedConfig:shared;
our @currentCpuAffinity;
our @DBdriverdef:shared;
our @DBdriverNames ;
our @GroupList:shared;
our @LDAPGroup:shared;
our @PersBlackGroup:shared;
our @TLStoProxyI;
our @PossibleOptionFiles;
our @RealTimeLog;
our @StatSocket;
our @WebSocket;
our @backsctrlist:shared;
our @badattachRE;        #t
our @batv_secrets;
our @delayGroup:shared;
our @logCount:shared; # is locked
our @logFreq:shared;
our @lsn;
our @lsnI:shared;
our @lsn2;
our @lsn2I:shared;
our @lsnNoAUTH;
our @lsnNoTLSI;
our @lsnSSL;
our @lsnSSLI:shared;
our @lsnRelay;
our @lsnRelayI:shared;
our @msgid_secrets;
our @mlogS;
our @nameservers:shared ;
our @pbdbGroup:shared;
our @rbllist;
our @redlistGroup:shared;
our @rwllist;
our @spamdbGroup:shared;
our @sortedOIDs;
our @uribllist;
our @whitelistGroup:shared;
our @HmmBayWords;
our @WhitelistResult;

# Weighted Regexes

our $weightMatch;

our $bombReWLw;
our $bombReNPw;
our $bombReLocalw;
our $bombReISPIPw;
our $DoReversedWLw;
our $DoReversedNPw;
our $DoHeloWLw;
our $DoHeloNPw;

# end our global vars
our $setpro = 1;
#

$ScheduleMap{'backupDBInterval'}       = &share([]); @{$ScheduleMap{'backupDBInterval'}}       = (3600,'nextDBBackup');
$ScheduleMap{'BlockReportSchedule'}    = &share([]); @{$ScheduleMap{'BlockReportSchedule'}}    = (24 * 3600,'nextBlockReportSchedule');
$ScheduleMap{'CleanCacheEvery'}        = &share([]); @{$ScheduleMap{'CleanCacheEvery'}}        = (3600,'nextCleanCache');
$ScheduleMap{'CleanDelayDBInterval'}   = &share([]); @{$ScheduleMap{'CleanDelayDBInterval'}}   = (   1,'nextCleanDelayDB');
$ScheduleMap{'CleanPBInterval'}        = &share([]); @{$ScheduleMap{'CleanPBInterval'}}        = (3600,'nextCleanPB');
$ScheduleMap{'exportInterval'}         = &share([]); @{$ScheduleMap{'exportInterval'}}         = (3600,'nextExport');
$ScheduleMap{'GroupsReloadEvery'}      = &share([]); @{$ScheduleMap{'GroupsReloadEvery'}}      = (  60,'NextGroupsReload');
$ScheduleMap{'LDAPcrossCheckInterval'} = &share([]); @{$ScheduleMap{'LDAPcrossCheckInterval'}} = (3600,'nextLDAPcrossCheck');
$ScheduleMap{'MaxFileAgeSchedule'}     = &share([]); @{$ScheduleMap{'MaxFileAgeSchedule'}}     = (24 * 3600,'nextFileAgeSchedule');
$ScheduleMap{'POP3Interval'}           = &share([]); @{$ScheduleMap{'POP3Interval'}}           = (  60,'NextPOP3Collect');
$ScheduleMap{'QueueSchedule'}          = &share([]); @{$ScheduleMap{'QueueSchedule'}}          = (24 * 3600,'nextQueueSchedule');
$ScheduleMap{'ReloadOptionFiles'}      = &share([]); @{$ScheduleMap{'ReloadOptionFiles'}}      = (   1,'nextOptionCheck',1,'nextHashFileCheck');
$ScheduleMap{'SaveStatsEvery'}         = &share([]); @{$ScheduleMap{'SaveStatsEvery'}}         = (  60,'NextSaveStats');
$ScheduleMap{'UpdateWhitelist'}        = &share([]); @{$ScheduleMap{'UpdateWhitelist'}}        = (   1,'saveWhite');
$ScheduleMap{'MemoryUsageCheckSchedule'} = &share([]); @{$ScheduleMap{'MemoryUsageCheckSchedule'}} = (   1,'nextMemoryUsageCheckSchedule');

%ReportFiles = (
    'EmailSpam' => 'reports/spamreport.txt',
    'EmailHam' => 'reports/notspamreport.txt',
    'EmailWhitelistAdd' => 'reports/whitereport.txt',
    'EmailWhitelistRemove' => 'reports/whiteremovereport.txt',
    'EmailRedlistAdd' => 'reports/redreport.txt',
    'EmailRedlistRemove' => 'reports/redremovereport.txt',
    'EmailHelp' => 'reports/helpreport.txt',
    'EmailAnalyze' => 'reports/analyzereport.txt',
    'EmailSpamLoverAdd' => 'reports/slreport.txt',
    'EmailSpamLoverRemove' => 'reports/slremovereport.txt',
    'EmailNoProcessingAdd' => 'reports/npreport.txt',
    'EmailNoProcessingRemove' => 'reports/npremovereport.txt',
    'EmailBlackAdd' => 'reports/blackreport.txt',
    'EmailBlackRemove' => 'reports/blackremovereport.txt',
    'EmailPersBlackAdd' => 'reports/persblackreport.txt',
    'EmailPersBlackRemove' => 'reports/persblackremovereport.txt',
    'EmailVirusReportsToRCPT' => 'reports/virusreport.txt',
    'EmailSenderNotOK' => 'reports/denied.txt'
);

%ReportTypes = (
    'EmailSpam' => 0,
    'EmailHam' => 1,
    'EmailWhitelistAdd' => 2,
    'EmailWhitelistRemove' => 3,
    'EmailRedlistAdd' => 4,
    'EmailRedlistRemove' => 5,
    'EmailHelp' => 7,
    'EmailAnalyze' => 8,
    'EmailSpamLoverAdd' => 10,
    'EmailSpamLoverRemove' => 11,
    'EmailNoProcessingAdd' => 12,
    'EmailNoProcessingRemove' => 13,
    'EmailBlackAdd' => 14,
    'EmailBlackRemove' => 15,
    'EmailPersBlackAdd' => 16,
    'EmailPersBlackRemove' => 17,
);

%URIBLaddWeight = (

    'obfuscatedip'     => 0.99,
    'obfuscateduri'    => 0.99,
    'maximumuniqueuri' => 0.94,
    'maximumuri'       => 0.95

);

%webRequests=(
    '/lists' => \&ConfigLists,
    '/recprepl' => \&CheckRcptRepl,
    '/maillog' => \&ConfigMaillog,
    '/analyze' => \&ConfigAnalyze,
    '/infostats' => \&ConfigStats,
    '/edit' => \&ConfigEdit,
    '/shutdown' => \&Shutdown,
    '/shutdown_frame' => \&ShutdownFrame,
    '/shutdown_list' => \&ShutdownList,
    '/donations' => \&Donations,
    '/get' => \&GetFile,
    '/top10stats' => \&top10stats,
    '/pwd' => \&ChangeMyPassword,
    '/adminusers' => \&ManageAdminUsers,
    '/statusassp' => \&StatusASSP,
    '/remember' => \&remember,
    '/syncedit' => \&syncedit,
    '/addraction' => \&ConfigAddrAction,
    '/ipaction' => \&ConfigIPAction,
    '/statgraph' => \&ConfigStatsPlot,
    '/fc' => \&ConfigFC
);

 $WorkerName = 'startup';
 $logfile = $Config{logfile};     # set the log parms to preenable logging
 $asspLog = $Config{asspLog};
 $WorkerLogging = $Config{WorkerLogging};
 $sysLog = $Config{sysLog};
 $SysLogFac = $Config{SysLogFac};
 $sysLogPort = $Config{sysLogPort};
 $sysLogIp = $Config{sysLogIp};
 $globalClientName = $Config{globalClientName};
 $globalClientPass = $Config{globalClientPass};

 &defineCanUseModules();

 print "\t\t\t[OK]\nsetup regular expressions";
 &setMakeREVars();
 my $p;
 $p = '-professional' if ($setpro && $globalClientName && $globalClientPass);
 mlog(0,"ASSP$p version $version$modversion (Perl $]) (on $^O) initializing ");

 print "\t\t\t\t[OK]\nloading plugins";
 loadPluginConfig();           # load Configuration from Plugins to @ConfigArray

 print "\t\t\t\t\t\t[OK]\nfixing up config";
 syncLoadConfigFile();
 fixConfigSettings();

 mlog(0,"info: an ASSP restart will be done with: $AutoRestartCmd") if $MaintenanceLog;
 PrintConfigSettings() if ! SaveConfigSettings();
 chmod 0666, "$base/assp.cfg";

# Notes on general operation & program structure
# I'm using IO::Poll or IO::Select, so don't make any changes that block for long
# as new connections come we create a pair of entries in a hash %Con
# based on the hash of the filehandle, so $Con{$fh} has data for this
# connection. $Con{$fh}->{friend} is the partner socket for the smtp proxy.
# ->{ip} is the ip address of the connecting client
# ->{relayok} tells if we can relay mail for this client
# ->{getline} is a pointer to a function that should be called whan a line of input is received for this filehandle
# ->{mailfrom} is the envelope sender (MAIL FROM: <address>)
# ->{outgoing} is a buffer for outgoing socket traffic (see $writable & &sendque)
# ->{rcpt} are the addresses from RCPT TO: <address> (space separated)
# ->{header} is where the complete mail data are stored
# ->{myheader} is where we store our header, we merge it with client's header later
# ->{maillog} if present stream logging is enabled
# ->{maillogbuf} buffer for storing unwritten stream log while waiting for isspam decision
# ->{maillogfh} is the filehandle for logging lines to the maillog
# ->{mailloglength} is the length logged so far (we stop after 10000 bytes)
# ->{spamfound} is a flag used to signal if an email is determined to be spam.
# ->{maillength} is the same as mailloglength but is not reset.
#
# After connection the {getline} field functions like a state machine
# redirecting input to subsequent handlers
#
# whitebody -> getline
#   getbody ->
#     error -> (disconnects)
#     getline -> getheader ->
#       whitebody -> getline
#         error -> (disconnects)
#
# getline looks for MAIL FROM, RCPT TO, RSET
# getheader looks for a blank line then tests for whitelist / spamaddresses
# getbody looks for the . and calls isspam, the Bayesian spam test
# whitebody waits for . and redirects client to server
# error waits for . ignoring data from client (and finishes the maillog)
#
# the server has states like this:
#
# skipok -> reply
#
# skipok traps the 250 ok response from the NOOP Connection from
# reply echos server messages to the client
# reply also looks for a 235 AUTH OK and sets {relayok}=1

if($AsADaemon) {
 print "\nstarting as daemon\t\t\t[OK]\n";
 fork() && exit 0;
 print "forked a new silent process\t\t[OK]\n";
 close STDOUT;
 close STDERR;
 $silent=1;
}

if($AsAService)
{
 close STDOUT;
 close STDERR;
 $silent=1;
}

my $logdir;
$logdir = $1 if $logfile=~/(.*)\/[^\/]*/o;
-d "$base/$logdir" or mkdir "$base/$logdir",0755 if $logdir;

&init();

&sigCentralSet();
$SIG{INT}=sub {mlog(0,'sig INT'); &downASSP('got SIG INT'); exit 1;};
$SIG{TERM}=sub {mlog(0,'sig TERM'); &downASSP('got SIG TERM'); exit 1;};
$SIG{HUP}=sub {mlog(0,'sig HUP'); &reloadConfigFile();};
$SIG{USR1}=sub {mlog(0,'sig USR1'); &saveSMTPconnections();} if exists $SIG{USR1};
$SIG{USR2}=sub {mlog(0,'sig USR2'); &SaveConfigSettingsForce();} if exists $SIG{USR2};
$SIG{NUM07}=sub {$allIdle -= 2 if $allIdle == defined *{'yield'};$allIdle += defined *{'yield'} if $allIdle == 0; mlog(0,($allIdle > 0 ? 'assp suspened' : 'assp resumed'));} if exists $SIG{NUM07};
$SIG{PIPE} = 'IGNORE';
#foreach my $k (sort keys %SIG) {
#    mlog(0,"SIG $k = $SIG{$k}");
#}
&niceConfigPos();
&renderConfigHTML();
$lastTimeoutCheck = time;
eval {
 $WorkerName = 'Main_Thread';
 unloadMainThreadModules() if $undefMEM;
 &ThreadMonitorMainLoop('MainLoop initialized');
 $ComWorker{main} = 1;
 mlog(0,'MainThread started');
 $PerfStartTime = time;
 $syncToDo = 1;
 while(1) {
  my $t = &MainLoop(1);
 }
};
if ($@) {
 my $exmsg = "main exception: $@\n";
 writeExceptionLog("$exmsg");
 print $LOG "$exmsg\n" if fileno($LOG);
 &downASSP('try restarting ASSP on exception');
 &_assp_try_restart;
}

# END_OF_MAIN_CODE
# there is no main code behind here - subs and packages only

#####################################################################################
# the rebuild spamdb module
#####################################################################################

sub write_rebuild_module {
my $curr_version = shift;

my $rb_version = '6.31';
my $keepVersion;

if (open my $ADV, '<',"$base/lib/rebuildspamdb.pm") {
    while (<$ADV>) {
        if (/^\s*our \$VERSION.+?(\d\.\d+)/o) {
            $curr_version = $1;
            $ComWorker{$WorkerNumber}->{rb_version} = $1;
            last;
        }
        $keepVersion = 1 if /keepVersion/o;
    }
    close $ADV;
    mlog(0,"info: found module $base/lib/rebuildspamdb.pm version $curr_version");
}

if ($keepVersion) {
    mlog(0,"info: the current $base/lib/rebuildspamdb.pm contains a 'keepVersion' line - this file will be keeped");
    return 1;
}

if ($curr_version gt $rb_version && ! $forceRebuildDowngrade) {
    mlog(0,"warning: keeping module $base/lib/rebuildspamdb.pm at version $curr_version (version $rb_version should be used), because 'forceRebuildDowngrade is 0'");
    return 1;
} elsif ($curr_version gt $rb_version && $forceRebuildDowngrade) {
    mlog(0,"info: downgrading module $base/lib/rebuildspamdb.pm from version $curr_version to version $rb_version, because 'forceRebuildDowngrade is 1'");
} elsif ($curr_version lt $rb_version) {
    mlog(0,"info: upgrading module $base/lib/rebuildspamdb.pm from version $curr_version to version $rb_version");
}

(open my $ADV, '>',"$base/lib/rebuildspamdb.pm") or return 0;
#print $ADV <<'RBEOT' or return 0;
#####################################################################################
#

#package rebuildspamdb; # RBEOT;

#RBEOT

print $ADV 'our $VERSION = ',"'$rb_version';\n\n";

#print $ADV <<'RBEOT';
rb_mlog("info: rebuildspamdb module version ".${'VERSION'}." loaded");

# rebuildspamdb version 2
# rebuilds bayesian spam and HMM database
# (c) John Hanna 2003 under the terms of the GPL
# Updated July 2004 for simple proxy support.
# (c) Fritz Borgstedt 2006 under the terms of the GPL
# Updated Feb 2008 refactoring and rewrites
# (c) Kevin 2008 under the terms of the GPL
# Updated Jul 2008 refactoring and rewrites to build in as package in ASSP
# and integrated move2num
# (c) Thomas Eckardt since 2008 under the terms of the GPL

use strict qw(vars subs);
use Digest::MD5 qw(md5_hex);
use File::Copy;
use IO::Handle;
use IO::Socket();
use Encode;
no warnings;

our $RebuildLog;
our $RebuildDebug;
our $norm;
our $starttime;
our $processTime;
our $processedBytes;
our $scanTime;
our $scanFiles;
our %spam; keys %spam = $main::MaxFiles * 20;
our %newspam; keys %newspam = $main::MaxFiles * 20;
our %Helo; keys %Helo = $main::MaxFiles;
our %HamHash; keys %HamHash = $main::MaxFiles;
our %SpamHash; keys %SpamHash = $main::MaxFiles;
our %HMMres;
our %GpCnt;
our %GpOK;
our %Trashlist;
our $spamObj;
our $newspamObj;
our $HeloObj;
our $HamHashObj;
our $HMMresObj;
our $SpamHashObj;
our $GpCntObj;
our $GpOKObj;
our $TrashlistObj;
our $SpamWordCount;
our $HamWordCount;
our $Iam;
our $BDBEnv;
our $DBDir;
our $WhiteCount;
our $RedCount;
our $onlyNewCorrected;
our $IPRe = $main::IPRe;
our $spamHMM;
our $hamHMM;
our $DoHMM;
our $attachments;
our $rtText;
our $mintime;
our $movetime;
our $doattach;


sub rb_run {         ## no critic
$onlyNewCorrected = shift;

$SpamWordCount = 0;
$HamWordCount = 0;
$processedBytes = 0;
$starttime = 0;
$processTime = 0;
$processedBytes = 0;
$scanTime = 0;
$scanFiles = 0;

$WhiteCount = 0;
$RedCount = 0;
$attachments = 0;

$DoHMM = $main::DoHMM;
$doattach = 0;
$doattach = 1 if    $main::Config{ASSP_AFCDetectSpamAttachRe}
                 && $main::ASSP_AFCDetectSpamAttachReRE !~ $main::neverMatchRE;
($mintime,$movetime) = split(/(?:\s+|,)/o,$main::RebuildFileTimeLimit,2);
$mintime =~ s/\s//go;
$movetime =~ s/\s//go;
$mintime ||= 0;
$movetime ||= 0;

$RebuildDebug = -e "$main::base/rebuilddebug.txt";
$RebuildDebug = 0 if $onlyNewCorrected;
if ($RebuildDebug) {
    open($RebuildDebug ,'>',  "$main::base/rebuilddebug.txt" );
    binmode $RebuildDebug;
    $RebuildDebug->autoflush;
    rb_mlog("rebuild debug output is enabled to $main::base/rebuilddebug.txt");
}

eval (<<'EOT') if ($main::CanUseASSP_WordStem);
    use ASSP_WordStem();
EOT

    my @dbhint;
    if ($main::canUnicode && $^O eq 'MSwin32') {require Win32::Unicode;}
    $DBDir = "$main::base/tmpDB/rebuildDB";
    $Iam = $main::WorkerNumber;
    -d $DBDir or mkdir $DBDir,0755;

    if ($main::CanUseBerkeleyDB && $main::useDB4Rebuild) {
        eval('use BerkeleyDB;');
        if ($main::VerBerkeley lt '0.42') {
            *{'BerkeleyDB::_tiedHash::CLEAR'} = *{'main::BDB_CLEAR'};
        }
        my $cachesize = $DoHMM ? 41943040 : 20971520;
        rb_mlog("RebuildSpamDB uses BerkeleyDB for temporary hashes");
eval (<<'EOT');
            $BDBEnv = BerkeleyDB::Env->new(-Flags => DB_CREATE | DB_INIT_MPOOL,
                                           -Cachesize => $cachesize ,
                                           -Home => "$DBDir",
                                           -Config => {DB_DATA_DIR => "$DBDir",
                                                       DB_LOG_DIR  => "$DBDir",
                                                       DB_TMP_DIR  => "$DBDir"}
                                          );

            $spamObj=tie %spam,'BerkeleyDB::Hash',
                                     (-Filename => "$DBDir/rb_spam.bdb" ,
                                      -Flags => DB_CREATE,
                                      -Env => $BDBEnv);
            rb_BDB_getRecordCount('spam');

            $newspamObj=tie %newspam,'BerkeleyDB::Hash',
                                     (-Filename => "$DBDir/rb_newspam.bdb" ,
                                      -Flags => DB_CREATE,
                                      -Env => $BDBEnv);
            rb_BDB_getRecordCount('newspam');

            $HeloObj=tie %Helo,'BerkeleyDB::Hash',
                                     (-Filename => "$DBDir/rb_Helo.bdb" ,
                                      -Flags => DB_CREATE,
                                      -Env => $BDBEnv);
            rb_BDB_getRecordCount('Helo');

            $HamHashObj=tie %HamHash,'BerkeleyDB::Hash',
                                     (-Filename => "$DBDir/rb_HamHash.bdb" ,
                                      -Flags => DB_CREATE,
                                      -Env => $BDBEnv);
            rb_BDB_getRecordCount('HamHash');

            $SpamHashObj=tie %SpamHash,'BerkeleyDB::Hash',
                                     (-Filename => "$DBDir/rb_SpamHash.bdb" ,
                                      -Flags => DB_CREATE,
                                      -Env => $BDBEnv);
            rb_BDB_getRecordCount('SpamHash');

            $GpCntObj=tie %GpCnt,'BerkeleyDB::Hash',
                                     (-Filename => "$DBDir/rb_GpCnt.bdb" ,
                                      -Flags => DB_CREATE,
                                      -Env => $BDBEnv);
            rb_BDB_getRecordCount('GpCnt');

            $GpOKObj=tie %GpOK,'BerkeleyDB::Hash',
                                     (-Filename => "$DBDir/rb_GpOK.bdb" ,
                                      -Flags => DB_CREATE,
                                      -Env => $BDBEnv);
            rb_BDB_getRecordCount('GpOK');

            $TrashlistObj=tie %Trashlist,'BerkeleyDB::Hash',
                                     (-Filename => "$DBDir/trashlist.bdb" ,
                                      -Flags => DB_CREATE,
                                      -Env => $BDBEnv);
            rb_BDB_getRecordCount('Trashlist') == 0 && rb_Load_Trashlist();

            $HMMresObj=tie %HMMres,'BerkeleyDB::Hash',
                                     (-Filename => "$DBDir/rb_HMMres.bdb" ,
                                      -Flags => DB_CREATE,
                                      -Env => $BDBEnv);
            rb_BDB_getRecordCount('HMMres');
EOT
            rb_mlog("BerkeleyDB-ERROR: $@ - BDB:$BerkeleyDB::Error") if $@ or $BerkeleyDB::Error !~ /: 0\s*$/o;
    } elsif ($main::CanUseDB_File && $main::useDB4Rebuild) {
        eval('use DB_File;');
        rb_mlog("RebuildSpamDB uses DB_File for temporary hashes");
eval (<<'EOT');
        $spamObj = tie %spam, 'DB_File', "$DBDir/rb_spam.bdb";
        $newspamObj = tie %newspam, 'DB_File', "$DBDir/rb_newspam.bdb";
        $HeloObj = tie %Helo, 'DB_File', "$DBDir/rb_Helo.bdb";
        $HamHashObj = tie %HamHash, 'DB_File', "$DBDir/rb_HamHash.bdb";
        $SpamHashObj = tie %SpamHash, 'DB_File', "$DBDir/rb_SpamHash.bdb";
        $GpCntObj = tie %GpCnt, 'DB_File', "$DBDir/rb_GpCnt.bdb";
        $GpOKObj = tie %GpOK, 'DB_File', "$DBDir/rb_GpOK.bdb";
        $TrashlistObj = tie %Trashlist,'DB_File', "$DBDir/trashlist.bdb";
        scalar(keys %Trashlist) == 0 && rb_Load_Trashlist();
EOT
        rb_mlog("DB_File-ERROR: $@") if $@;
    } elsif ($main::useDB4Rebuild) {
        rb_mlog("RebuildSpamDB uses the internal 'orderedtie' for temporary hashes");
        push @dbhint , "warning: 'useDB4Rebuild' is set to on, but 'BerkeleyDB' nor 'DB_File' are available - the rebuild spamdb process uses the internal 'orderedtie' and will possibly require more time and a large amount of memory - check 'OrderedTieHashTableSize'!";
eval (<<'EOT');
        $spamObj = tie %spam, 'orderedtie', "$DBDir/rb_spam.bdb";
        $newspamObj = tie %newspam, 'orderedtie', "$DBDir/rb_newspam.bdb";
        $HeloObj = tie %Helo, 'orderedtie', "$DBDir/rb_Helo.bdb";
        $HamHashObj = tie %HamHash, 'orderedtie', "$DBDir/rb_HamHash.bdb";
        $SpamHashObj = tie %SpamHash, 'orderedtie', "$DBDir/rb_SpamHash.bdb";
        $GpCntObj = tie %GpCnt, 'orderedtie', "$DBDir/rb_GpCnt.bdb";
        $GpOKObj = tie %GpOK, 'orderedtie', "$DBDir/rb_GpOK.bdb";
        $TrashlistObj = tie %Trashlist,'orderedtie', "$DBDir/trashlist.bdb";
EOT
        rb_mlog("DB_File-ERROR: $@") if $@;
    } else {
        $TrashlistObj = tie %Trashlist,'orderedtie', "$main::base/trashlist.db";
        push @dbhint , "warning: 'useDB4Rebuild' is NOT set to on - the rebuild spamdb process will possibly require a very large amount of memory - but it will run very fast!";
    }

    if ($DoHMM && $main::CanUseBerkeleyDB && $main::useDB4Rebuild) {
        if (! $onlyNewCorrected) {
            unlink "$DBDir/rbtmp.hamHMM.bdb";
            unlink "$DBDir/rbtmp.spamHMM.bdb";
            unlink "$DBDir/rbtmp.hamHMM.totals.bdb";
            unlink "$DBDir/rbtmp.spamHMM.totals.bdb";
        }
        if ($onlyNewCorrected ||
           (   ! $onlyNewCorrected
            && ! -e "$DBDir/rbtmp.hamHMM.bdb"
            && ! -e "$DBDir/rbtmp.spamHMM.bdb"
            && ! -e "$DBDir/rbtmp.hamHMM.totals.bdb"
            && ! -e "$DBDir/rbtmp.spamHMM.totals.bdb"))
        {
        $@ = '';
        eval (<<'EOT');
            $hamHMM  = ASSP::MarkovChain->new(longest => $main::HMMSequenceLength,
                                              shortest => $main::HMMSequenceLength,
                                              top => 1,
                                              nostarts => 1,
                                              BDB => {-Filename => "$DBDir/rbtmp.hamHMM" ,
                                                      -Flags => DB_CREATE
                                                      -Env => $BDBEnv}
                                              );
            $spamHMM = ASSP::MarkovChain->new(longest => $main::HMMSequenceLength,
                                              shortest => $main::HMMSequenceLength,
                                              top => 1,
                                              nostarts => 1,
                                              BDB => {-Filename => "$DBDir/rbtmp.spamHMM" ,
                                                      -Flags => DB_CREATE
                                                      -Env => $BDBEnv}
                                              ) if ref $hamHMM;
EOT
            unless (ref $hamHMM && ref $spamHMM) {
                my $error;
                $error =  " - e: $@" if $@;
                $error .= " - h: $hamHMM" if $hamHMM && ! ref $hamHMM;
                $error .= " - s: $spamHMM" if $spamHMM && ! ref $spamHMM;
                push @dbhint , "error: can't create HMM because of BDB database errors ($DBDir) - $error";
                $DoHMM = 0 ;
                $hamHMM = undef;
                $spamHMM = undef;
            }
        } else {
            push @dbhint , "error: can't cleanup at least one old temporary BDB file used for HMM in $DBDir/ 'rbtmp.hamHMM.bdb , rbtmp.spamHMM.bdb , rbtmp.hamHMM.totals.bdb, rbtmp.spamHMM.totals.bdb'";
        }
        unless (ref $hamHMM && ref $spamHMM) {
            $DoHMM = 0 ;
            $hamHMM = undef;
            $spamHMM = undef;
        }
    } else {
        if ($DoHMM) {
            push @dbhint , "error: can't create HMM because the BerkeleyDB module is not available" unless $main::CanUseBerkeleyDB;
            push @dbhint , "error: can't create HMM because 'useDB4Rebuild' is not enabled" unless $main::useDB4Rebuild;
        }
        $DoHMM = 0;
    }

    # reset counts and global vars
    $HamWordCount = $SpamWordCount = my $correctedspamcount = 0;
    my $correctednotspamcount = my $spamlogcount  = my $notspamlogcount = 0;
    my $rebuildrun = &rb_fixPath($main::base) . "/rebuildrun.txt";

    $RebuildLog = $norm = $starttime = $processTime = '';

    if ($onlyNewCorrected) {         # only still new reported
        my ($havenormfile,$SwordsPfile, $HwordsPfile);
        if (open( my $normFile, '<', "$main::base/normfile" )) {
            binmode $normFile;
            ($norm, $correctedspamcount, $correctednotspamcount, $spamlogcount, $notspamlogcount,
             $SwordsPfile, $HwordsPfile, $SpamWordCount, $HamWordCount) = split(/\s+/o, join('',<$normFile>));
            $havenormfile = $SpamWordCount > 0 || $HamWordCount > 0;
            close $normFile;
        }
        $norm ||= $main::bayesnorm || $main::Spamdb{'***bayesnorm***'};
        $norm ||= $main::HMMdb{'***bayesnorm***'} if $DoHMM;
        $norm ||= 1;
        my $oldnorm = $norm;

        rb_processNewCorrected();

        if ($havenormfile) {
            $main::bayesnorm = $main::Spamdb{'***bayesnorm***'} = $norm = $HamWordCount ? ( $SpamWordCount / $HamWordCount ) : 100;
            $main::HMMdb{'***bayesnorm***'} = $norm if $DoHMM;
            &rb_mlog("info: the corpus norm is changed from: $oldnorm - to: $norm") if $oldnorm != $norm;
            (open( my $normFile, '>', "$main::base/normfile" ));
            if ($normFile) {
                print { $normFile } "$norm $correctedspamcount $correctednotspamcount $spamlogcount $notspamlogcount $SwordsPfile $HwordsPfile $SpamWordCount $HamWordCount";
                eval{close $normFile;};
            }
        }
    } else {                         # the normal rebuild

    %spam = ();
    %newspam = ();
    %Helo = ();
    %HamHash = ();
    %SpamHash = ();
    %GpCnt = ();
    %GpOK = ();
    %HMMres = ();

    # open log file
    if ( -e "$rebuildrun.bak" ) {
        unlink("$rebuildrun.bak") or die "unable to remove file: $!";
    }
    if ( -e $rebuildrun ) {
        copy( $rebuildrun, "$rebuildrun.bak" ) or die "unable to copy file for: $!";
    }
    (open( $RebuildLog, '>', "$rebuildrun" )) or die "unable to open file for logging: $!";
    binmode $RebuildLog;
    $RebuildLog->autoflush;
    $starttime = time;
    &rb_printlog( "\n\n\nRebuildSpamDB-thread rebuildspamdb-version ".${'VERSION'}." started in ASSP version $main::version$main::modversion\n" );
    &rb_mlog( "RebuildSpamDB-thread rebuildspamdb-version ".${'VERSION'}." started in ASSP version $main::version$main::modversion");
    while (@dbhint) {
        my $t = shift @dbhint;
        &rb_printlog( "\n$t\n" );
        &rb_mlog( $t );
    }
    if ($main::RebuildTestMode) {
        &rb_printlog( "\n***** RebuildSpamDB is running in TEST MODE *****\n" );
        &rb_mlog( "***** RebuildSpamDB is running in TEST MODE *****" );
    }
    if ($DoHMM) {
        &rb_printlog( "\nRebuildSpamDB will create a Hidden Markov Model!\n" );
        &rb_mlog( "RebuildSpamDB will create a Hidden Markov Model!" );
    } else {
        &rb_printlog( "\nRebuildSpamDB will NOT create a Hidden Markov Model!\n" );
        &rb_mlog( "RebuildSpamDB will NOT create a Hidden Markov Model!" );
    }
    if ($doattach) {
        &rb_printlog( "\nRebuildSpamDB will include attachment-database-entries in to spamdb!\n" );
        &rb_mlog( "RebuildSpamDB will include attachment-database-entries in to spamdb!" );
    }
    if ($main::canUnicode) {
        &rb_printlog( "\nRebuildSpamDB will create unicode enabled databases.\n" );
        &rb_mlog( "RebuildSpamDB will create unicode enabled databases." );
    }
    if ($main::CanUseUnicodeGCString) {
        &rb_printlog( "\nRebuildSpamDB will process all words as Sequence of UAX #29 Grapheme Clusters.\n" );
        &rb_mlog( "RebuildSpamDB will process all words as Sequence of UAX #29 Grapheme Clusters." );
    }
    if ($main::CanUseASSP_WordStem) {
        &rb_printlog( "\nRebuildSpamDB will use the ASSP_WordStem engine.\n" );
        &rb_mlog( "RebuildSpamDB will use the ASSP_WordStem engine." );
    }
    &rb_printlog("\n---ASSP Settings---\n");
    if ($main::DoPrivatSpamdb) {
        my $text = ($main::DoPrivatSpamdb == 1) ? 'users email addresses only.'
                 : ($main::DoPrivatSpamdb == 2) ? 'each local domain.'
                 : 'users email addresses and each local domain.';
        &rb_printlog("\nRebuildSpamDB will create private spamdb entries for $text\n\n");
        &rb_mlog("RebuildSpamDB will create private spamdb entries for $text.");
    }
    if ($main::DoNotCollectRedList) {
        &rb_printlog(
            "Do Not Collect Messages with RedListed address: Enabled\n**Messages with RedListed addresses will be removed from the corpus!**\n\n"
          );
    }
    if ($main::DoNotCollectRedRe) {
        &rb_printlog(
            "Do Not Collect RedRe Messages: Enabled\n**Messages matching the RedRe will be removed from the corpus!**\n\n");
    }
    if ($main::UseSubjectsAsMaillogNames) {
        &rb_printlog("Use Subject as Maillog Names: True\n");
    } else {
        &rb_printlog("Use Subject as Maillog Names: False\n");
    }
    &rb_printlog("Maxbytes: $main::MaxBytes \n");
    &rb_mlog("Maxfiles: $main::MaxFiles");

    &rb_printlog("RebuildFileTimeLimit: $main::RebuildFileTimeLimit \n");
    &rb_mlog("RebuildFileTimeLimit: $main::RebuildFileTimeLimit");

    if ($movetime) {
        &rb_printlog("RebuildFileTimeLimit: files will be moved away from the corpus, if there processing takes longer than $movetime second(s) \n");
        &rb_mlog("RebuildFileTimeLimit: files will be moved away from the corpus, if there processing takes longer than $movetime second(s)");
    }

    #cleanup deleted files
    &rb_cleanTrashlist();

    # start move2num to normalize filenames
    &rb_move2num() if $main::doMove2Num;

    # isspam?, path, filter, weight, processing sub
    $correctedspamcount    = &rb_processfolder( 1, $main::correctedspam,    "*", 2, \&rb_dospamhash );
    $correctednotspamcount = &rb_processfolder( 0, $main::correctednotspam, "*", 4, \&rb_dohamhash );
    my $tempnorm = ($HamWordCount ? ( $SpamWordCount / $HamWordCount ) : $SpamWordCount ? 9.9999 : 1) || 0.0001;
    my ($neededspam,$neededham, $spamf, $hamf, $SwordsPfile, $HwordsPfile);
    my @tn = split(/\-/o,$main::autoCorrectCorpus);
    my $targetNorm = sprintf("%.3f",(($tn[0] + $tn[1])/2));
    my $nspam = undef;
    if ($tempnorm < 30 && $targetNorm > 0) {
        my $tn = sprintf("%.3f",$tempnorm);
        if ($tempnorm >= 10) {
            &rb_printlog("warning: corpusnorm after processing $main::correctedspam and $main::correctednotspam is very unbalanced (>=10) Spam Weight: $SpamWordCount / Not-Spam Weight: $HamWordCount => norm: $tn  - you should fill some known good files in to the folder $main::correctednotspam\n");
            &rb_mlog("warning: corpusnorm after processing $main::correctedspam and $main::correctednotspam is very unbalanced (>=10) spamwords $SpamWordCount/ hamwords $HamWordCount => $tn - you should fill some known good files in to the folder $main::correctednotspam");
        }
        my @t;
        if (open (my $F, '<', "$main::base/normfile")) {
            binmode $F;
            @t = split(/ /,join('',<$F>));
            close $F;
        }
        if ($t[5] > 0 && $t[6] > 0) {
            $SwordsPfile = $t[5];
            $HwordsPfile = $t[6];

            if ($tempnorm < 10) {
                &rb_printlog("info: corpusnorm after processing $main::correctedspam and $main::correctednotspam is Spam Weight: $SpamWordCount / Not-Spam Weight: $HamWordCount => norm: $tn \n");
                &rb_mlog("info: corpusnorm after processing $main::correctedspam and $main::correctednotspam is spamwords $SpamWordCount/ hamwords $HamWordCount => $tn");
            }
            $spamf = &main::min($main::MaxFiles,&rb_countfiles(&rb_fixPath($main::base.'/'.$main::spamlog).'/'));
            $hamf =  &main::min($main::MaxFiles,&rb_countfiles(&rb_fixPath($main::base.'/'.$main::notspamlog).'/'));
            my $r = ($spamf>0 || $hamf>0) & defined(*{'main::yield'})?$targetNorm:0;

            my $sf = ($HamWordCount - $SpamWordCount + $HwordsPfile * $hamf)/$SwordsPfile;
            &rb_d("spamfiles -> $sf = ($HamWordCount - $SpamWordCount + $HwordsPfile * $hamf)/$SwordsPfile \n");
#            my $f = (($sf * 0.9) > $spamf) ? 1 : 0.9;
            my $f = 1;
            rb_d("info: f = $f , sf = $sf , spamf = $spamf");
            $f = $f / (($main::bayesnorm - $targetNorm + 1) ** 2) if ($main::bayesnorm >= $tn[0] && $main::bayesnorm <= $tn[1]);
            $sf = &main::min($spamf,$sf);
            rb_d("info: SpamCountNormCorrection = $main::SpamCountNormCorrection , f = $f , sf = $sf , spamf = $spamf, norm = $main::bayesnorm, target = $targetNorm");
            $neededspam = int($sf*$r*$f);
            $neededspam = 1 if $neededspam <= 0;
            my $t = ($neededspam < $spamf) ? "apx. $neededspam" : 'apx. all';
            $nspam = int($sf * $r * $SwordsPfile * (1+(($main::SpamCountNormCorrection > -100 && $main::SpamCountNormCorrection < 100) ? $main::SpamCountNormCorrection/100 : 0)));
            $nspam = 2 if $nspam < 2;

            &rb_printlog("info: require $t files ($nspam words".($main::SpamCountNormCorrection ? " +[$main::SpamCountNormCorrection\% included]" : '').") from folder $main::spamlog to get the wanted corpusnorm ($targetNorm)\n");
            &rb_mlog("info: require $t files ($nspam words".($main::SpamCountNormCorrection ? " +[$main::SpamCountNormCorrection\% included]" : '').") from folder $main::spamlog to get the wanted corpusnorm ($targetNorm)");
            $nspam += $SpamWordCount;
        } else {
            &rb_printlog("warning: missing information for automatic corpus correction in file $main::base/normfile - rerun the rebuild, if you see this warning the first time!\n");
            &rb_mlog("warning: missing information for automatic corpus correction in file $main::base/normfile - rerun the rebuild, if you see this warning the first time!");
        }
    } elsif ($targetNorm > 0) {
        my $tn = sprintf("%.3f",$tempnorm);
        &rb_printlog("warning: corpusnorm after processing $main::correctedspam and $main::correctednotspam is too unbalanced (>=30) Spam Weight: $SpamWordCount / Not-Spam Weight: $HamWordCount => norm: $tn - you should fill some known good files in to the folder $main::correctednotspam\n");
        &rb_mlog("warning: corpusnorm after processing $main::correctedspam and $main::correctednotspam is too unbalanced (>=30) spamwords $SpamWordCount/ hamwords $HamWordCount => $tn - you should fill some known good files in to the folder $main::correctednotspam");
    }
    my $spamWords = $SpamWordCount;
    $spamlogcount = &rb_processfolder( 1, $main::spamlog, "*", 1, \&rb_checkspam , $neededspam, undef, $nspam );
    $spamWords = $SpamWordCount - $spamWords;
    $SwordsPfile = ($SwordsPfile ? int(($SwordsPfile + $spamWords/$spamlogcount)/2) : int($spamWords/$spamlogcount)) if $spamlogcount;
    my $nham = undef;
    if ($neededspam && $targetNorm > 0) {
        $nham = ($SpamWordCount - $HamWordCount)/$targetNorm;
        &rb_d("$nham = ($SpamWordCount - $HamWordCount)/$targetNorm \n");
        $neededham = int($nham/$HwordsPfile);
        &rb_d("$neededham = int($nham/$HwordsPfile) \n");
        $neededham = 1 if $neededham <= 0;
        $nham = 2 if $nham < 2;
        my $t = ($neededham < $hamf) ? "apx. $neededham" : 'apx. all';
        &rb_printlog("info: require $t files ($nham words) from folder $main::notspamlog to get the wanted corpusnorm ($targetNorm)\n");
        &rb_mlog("info: require $t files ($nham words) from folder $main::notspamlog to get the wanted corpusnorm ($targetNorm)");
        $nham = (($SpamWordCount/$targetNorm) > $HamWordCount) ? int($SpamWordCount/$targetNorm) : 1;
        &rb_d("$nham = (($SpamWordCount/$targetNorm) > $HamWordCount) ? int($SpamWordCount/$targetNorm) : 1 \n");
    }
    my $hamWords = $HamWordCount;
    $notspamlogcount = &rb_processfolder( 0, $main::notspamlog, "*", 1, \&rb_checkham , $neededham, $nham);
    $hamWords = $HamWordCount - $hamWords;
    $HwordsPfile = ($HwordsPfile ? int(($HwordsPfile + $hamWords/$notspamlogcount)/2) : int($hamWords/$notspamlogcount)) if $notspamlogcount;

    if ($DoHMM && $scanFiles > 200) {
        use File::Find;
        my $size;
        find(sub{ -f and ( $size += -s ) }, "$main::base/tmpDB" );
        $size *= 2;
        $size = 250 * 1024 * 1024 if $size < 250 * 1024 * 1024;
        $size = &main::formatNumDataSize(int($size / 1024) * 1024);
        my $tooslow = 3; my $slow = $doattach ? 6 : 7; my $fast = $doattach ? 10 : 12;
        $scanTime = 1 unless $scanTime;
        my $fps = sprintf("%.2f",($scanFiles / $scanTime));
        if ($fps < $tooslow) {
            &rb_printlog("\nRebuild processed $fps files per second. ASSP expects a speed of at least $slow files per second - good values are $fast and higher. The disk IO components (disks and/or IO-controller) of your system are too slow for ASSP. Use a cached (>=128MB) IO-controller or use a RAM-disk with at least $size for the folder '$main::base/tmpDB' to speed up the rebuild process or disable 'DoHMM'.\n");
            &rb_mlog("Rebuild processed $fps files per second. ASSP expects a speed of at least $slow files per second - good values are $fast and higher. The disk IO components (disks and/or IO-controller) of your system are too slow for ASSP. Use a cached (>=128MB) IO-controller or use a RAM-disk with at least $size for the folder '$main::base/tmpDB' to speed up the rebuild process or disable 'DoHMM'.");
        } elsif ($fps < $slow) {
            &rb_printlog("\nRebuild processed $fps files per second. ASSP expects a speed of at least $slow files per second - good values are $fast and higher. The disk IO components (disks and/or IO-controller) of your system are slow. Use a cached (>=128MB) IO-controller or use a RAM-disk with at least $size for the folder '$main::base/tmpDB' to speed up the rebuild process.\n");
            &rb_mlog("Rebuild processed $fps files per second. ASSP expects a speed of at least $slow files per second - good values are $fast and higher. The disk IO components (disks and/or IO-controller) of your system are slow. Use a cached (>=128MB) IO-controller or use a RAM-disk with at least $size for the folder '$main::base/tmpDB' to speed up the rebuild process.");
        } elsif ($fps < $fast) {
            &rb_printlog("\nRebuild processed $fps files per second. Good values are $fast files per second and higher. You can speed up the rebuild process, using a cached (>=128MB) IO-controller or a RAM-disk with at least $size for the folder '$main::base/tmpDB'.\n");
            &rb_mlog("Rebuild processed $fps files per second. Good values are $fast files per second and higher. You can speed up the rebuild process, using a cached (>=128MB) IO-controller or a RAM-disk with at least $size for the folder '$main::base/tmpDB'.");
        } else {
            &rb_printlog("\nRebuild processed $fps files per second.\n");
            &rb_mlog("Rebuild processed $fps files per second.");
        }
    }

    $norm = $HamWordCount ? ( $SpamWordCount / $HamWordCount ) : 100;
    (open( my $normFile, '>', "$main::base/normfile" )) || warn "unable to open $main::base/normfile: $!\n";
    if ($normFile) {
        print { $normFile } "$norm $correctedspamcount $correctednotspamcount $spamlogcount $notspamlogcount $SwordsPfile $HwordsPfile $SpamWordCount $HamWordCount";
        eval{close $normFile;};
    }

    # Create Bayesian DB
    &rb_generatescores();

    # Create HMM DB
    &rb_generateHMM() if $DoHMM;

    # Create HELO blacklist
    &rb_createheloblacklist();

    $main::bayesnorm = $main::Spamdb{'***bayesnorm***'} = $norm;

    &rb_printlog("\nSpam Weight:\t   " . &rb_commify($SpamWordCount) . "\n");
    &rb_printlog("Not-Spam Weight:   " . &rb_commify($HamWordCount) . "\n\n" );
    if ( !($norm) ) {    #invalid norm
        &rb_printlog("Warning: Corpus insufficent to calculate normality!\n");
        &rb_mlog("Warning: Corpus insufficent to calculate normality!");
    }
    else {               #norm exists, print it
        my $normdesc;
        if    ( $norm < 0.6 )   { $normdesc = '(warning: extremely ham heavy)'; }
        elsif ( $norm < 0.9 )   { $normdesc = '(ok - slighly ham heavy)'; }
        elsif ( $norm < 1.1 )   { $normdesc = '(very good - balanced)'; }
        elsif ( $norm < 1.4 )   { $normdesc = '(ok - slighly spam heavy)'; }
        else                    { $normdesc = '(warning: extremely spam heavy)'; }
        &rb_printlog( "Corpus norm:\t%.4f - $normdesc\n", $norm );
        &rb_printlog( "Corpus confidence:\t%.8f\n", &main::BayesConfNorm() );
    }
    if ( $spamlogcount >= $main::MaxFiles || $notspamlogcount >= $main::MaxFiles ) {
        &rb_printlog(
            "Recommendation: RebuildSpamDB will limit the number of used messages in your corpus. Excess files will be ingored.\n"
          );
    }
    my ($lownorm,$highnorm,$numfiles,$mindays) = split(/-/o, $main::autoCorrectCorpus);
    if ( $norm < 0.6 ) {
        &rb_printlog("Corpus norm should be between 0.6 and 1.4\n");
        &rb_printlog("\nRecommendation: You need more spam messages in the corpus.\n");
    }
    if (! $main::RebuildTestMode && ! $neededspam && $main::autoCorrectCorpus && $norm < $lownorm && $main::notspamlog && ! $main::RunTaskNow{cleanUpMaxFiles}) {
        $main::RunTaskNow{cleanUpMaxFiles} = 10001;
        &rb_printlog("\nstarting auto correction for corpus - delete old ham files from $main::notspamlog\n");
        my $info = &main::cleanUpMaxFiles($main::notspamlog, 1 - $lownorm, $numfiles,$mindays);
        &rb_printlog($info) if $info;
        $main::RunTaskNow{cleanUpMaxFiles} = '';
    }
    if ( $norm > 1.4 ) {
        &rb_printlog("Corpus norm should be between 0.6 and 1.4\n");
        &rb_printlog("\nRecommendation: You need more not-spam messages in the corpus.\n");
    }
    if (! $main::RebuildTestMode && ! $neededspam && $main::autoCorrectCorpus && $norm > $highnorm && $main::spamlog && ! $main::RunTaskNow{cleanUpMaxFiles}) {
        $main::RunTaskNow{cleanUpMaxFiles} = 10001;
        &rb_printlog("\nstarting auto correction for corpus - delete old spam files from $main::spamlog\n");
        my $info = &main::cleanUpMaxFiles($main::spamlog, $highnorm - 1, $numfiles,$mindays);
        &rb_printlog($info) if $info;
        $main::RunTaskNow{cleanUpMaxFiles} = '';
    }
    if ( $main::MaxBytes >= 4000 && $norm < 0.6 ) {
        &rb_printlog( "\nRecommendation: You should reduce now MaxBytes to " . int( ( $main::MaxBytes + 1000 ) / 2 ) . "!  \n" );
    }
    if ( $main::MaxBytes <= 4000 && $norm > 1.3 ) {
        my $newMaxBytes = int( $main::MaxBytes - 1000 ) * 2 ;
        $newMaxBytes = $main::MaxBytes + 1000 if $newMaxBytes <= $main::MaxBytes;
        &rb_printlog( "\nRecommendation: You should increase now MaxBytes to " . $newMaxBytes . "!  \n" );
    }

    if ($DoHMM) {
        if ($main::spamdb eq 'DB:' or $main::runHMMusesBDB) {
            $main::lockHMM = 1;
            &rb_mlog( "try to lock HMM databases in 5 second(s)" );
            sleep 5;
            $main::ThreadIdleTime{$main::WorkerNumber} += 5;
            &rb_printlog( "\nStart populating Hidden Markov Model. HMM-check is disabled for this time!\n" );
            &rb_mlog( "Start populating Hidden Markov Model. HMM-check is disabled for this time!" );
            rb_populate_HMM();
            &rb_printlog( "Finished populating Hidden Markov Model. HMM-check is now enabled again!\n" );
            &rb_mlog( "Finished populating Hidden Markov Model! HMM-check is now enabled again!" );
            $main::cleanHMM = '';
            $main::HMMdb{'***bayesnorm***'} = $norm;
        } else {
            &rb_printlog( "\nplease set the config parameter 'spamdb' to 'DB:' or 'HMMusesBDB' to 'On' - unable to populate HMM\n\n");
            &rb_mlog( "please set the config parameter 'spamdb' to 'DB:' or 'HMMusesBDB' to 'On' - unable to populate HMM");
        }

        $main::lockHMM = 0;
    }

    $processedBytes = &main::formatNumDataSize($processedBytes);
    if   ( time - $starttime != 0 ) { $processTime = &rb_commify(time - $starttime); }
    else                            { $processTime = 1; }
    &rb_printlog( "\nTotal processing time: %s second(s)\n", $processTime );
    &rb_printlog( "\nTotal processing data: $processedBytes\n\n");
    &rb_mlog( "Total processing time: %s second(s)", $processTime );
    &rb_mlog( "Total processed data: $processedBytes");

    if ( $main::asspLog ) { &rb_uploadgriplist(); }

    if ($TrashlistObj !~ /orderedtie/o && (open my $HASH, '>', "$main::base/trashlist.db") ) {
        binmode $HASH;
        print $HASH "\n";
        foreach my $k (sort keys %Trashlist) {
            my $v = $Trashlist{$k};
            print $HASH "$k\002$v\n";
        }
        eval{close $HASH;};
        &rb_printlog( "\nTrashlist was saved to $main::base/trashlist.db\n" );
        &rb_mlog( "Trashlist was saved to $main::base/trashlist.db" );
    }
    eval{close $RebuildLog;};
    if ($main::RebuildNotify) {
        &main::sendNotification(
          $main::EmailFrom,
          $main::RebuildNotify,
          "RebuildSpamDB - report from $main::myName",
          "File rebuildrun.txt follows:\r\n\r\n",
          "$main::base/rebuildrun.txt");
    }

    }  # end if ($onlyNewCorrected)

    undef $spamObj;
    undef $newspamObj;
    undef $HeloObj;
    undef $HamHashObj;
    undef $SpamHashObj;
    undef $GpCntObj;
    undef $GpOKObj;
    undef $TrashlistObj;
    undef $HMMresObj;
    untie %spam;
    untie %newspam;
    untie %Helo;
    untie %HamHash;
    untie %SpamHash;
    untie %GpCnt;
    untie %GpOK;
    untie %Trashlist;
    untie %HMMres;

    unlink "$DBDir/rb_HMMres.bdb";
    unlink "$DBDir/rb_HamHash.bdb";
    unlink "$DBDir/rb_SpamHash.bdb";
    unlink "$DBDir/rb_GpCnt.bdb";
    unlink "$DBDir/rb_GpOK.bdb";
    unlink "$DBDir/rb_newspam.bdb";

    undef $hamHMM;
    undef $spamHMM;

    undef $BDBEnv;

eval (<<'EOT');
    no ASSP_WordStem;
EOT
    return 1;
}
##########################################
#       run/main script ends here
##########################################

sub rb_populate_HMM {                 # rb_populate_HMM
    delete $HMMres{''};
    return rb_populate_HMM_DB() if $main::DBusedDriver ne 'BerkeleyDB' && ! $main::runHMMusesBDB;
    %main::HMMdb = ();                # clear the main hash

    my $obj;
    if ($obj = tied %main::HMMdb) {
       &main::BDB_filter_off($obj);
    }
    my $tot;
    eval (<<'EOT');
        $tot = &rb_commify($HMMresObj->db_stat()->{hash_ndata});
EOT

    my $count = $main::haveHMM = 0;
    &rb_printlog( "start populating Hidden Markov Model with $tot records!\n" );
    &rb_mlog( "start populating Hidden Markov Model with $tot records!" );
    $main::cleanHMM = 1;
    while (my ($k,$v) = each %HMMres) {
        next unless defined $v;
        if ($count%1000==0) {
            die "warning: got stop request from MainThread" unless $main::ComWorker{$Iam}->{run};
            $main::lastd{$Iam} = "populating HMM - ".&rb_commify($count)."/$tot";
        }
        $main::HMMdb{$k} = $v unless $main::RebuildTestMode;
        $count++;
    }
    $main::currentDBVersion{HMMdb} = $main::HMMdb{'***DB-VERSION***'} = $main::requiredDBVersion{HMMdb};
    &main::BDB_filter($obj) if $obj;
    $main::haveHMM = $count;
    $main::cleanHMM = '' if $count;
    $count = &rb_commify($count);

    &rb_printlog( "Finished populating Hidden Markov Model with $count records!\n" );
    &rb_mlog( "Finished populating Hidden Markov Model with $count records!" );
    &main::checkDBCon() if ($main::CanUseTieRDBM && $main::DBisUsed);
    return;
}

sub rb_populate_HMM_DB {                 # rb_populate_HMM_DB;
    my ($tot,$totn);
    eval (<<'EOT');
        $totn = $HMMresObj->db_stat()->{hash_ndata};
        $tot = &rb_commify($totn);
EOT

    &rb_printlog( "start populating Hidden Markov Model with $tot records!\n" );
    &rb_mlog( "start populating Hidden Markov Model with $tot records!" );

    while ($main::ComWorker{$Iam}->{run} && $main::RunTaskNow{ImportMysqlDB}) {
        die "warning: got stop request from MainThread" unless $main::ComWorker{$Iam}->{run};
        $main::lastd{$Iam} = "waiting additional 10 seconds for still running DB import to be finished";
        sleep 10;
        $main::ThreadIdleTime{$main::WorkerNumber} += 10;
    }
    die "warning: got stop request from MainThread" unless $main::ComWorker{$Iam}->{run};

    $main::haveHMM = 0;
    $main::cleanHMM = 1;
    $main::RunTaskNow{ImportMysqlDB} = $Iam;
    $main::lastd{$Iam} = "populating HMM - $tot records";
    &main::importDB('main::HMMdb','','hmmdb',\%HMMres,$totn, 1/2) unless $main::RebuildTestMode;
    $main::RunTaskNow{ImportMysqlDB} = '';
    $main::cleanHMM = 0 if ($main::haveHMM = &main::getDBCount('main::HMMdb','main::spamdb'));
    delete $main::HMMdb{''};
    $main::currentDBVersion{HMMdb} = $main::HMMdb{'***DB-VERSION***'} = $main::requiredDBVersion{HMMdb};
    &rb_printlog( "Finished populating Hidden Markov Model with $tot records!\n" );
    &rb_mlog( "Finished populating Hidden Markov Model with $tot records!" );
    &main::checkDBCon() if ($main::CanUseTieRDBM && $main::DBisUsed);
    return;
}

sub rb_populate_Spamdb {
    my ($hashref, $totn) = @_;

    my $mainhashname = 'main::Spamdb';
    my $mysqlTable = lc $mainhashname;
    $mysqlTable =~ s/main:://o;
    my $tot = &rb_commify($totn);

    &rb_printlog( "start populating Spamdb with $tot records - Bayesian check is now disabled!\n" );
    &rb_mlog( "start populating Spamdb with $tot records - Bayesian check is now disabled!" );
    $main::lastd{$Iam} = "start populating Spamdb with $tot records!" ;

    while ($main::ComWorker{$Iam}->{run} && $main::RunTaskNow{ImportMysqlDB}) {
        die "warning: got stop request from MainThread" unless $main::ComWorker{$Iam}->{run};
        $main::lastd{$Iam} = "waiting additional 10 seconds for still running DB import to be finished";
        sleep 10;
        $main::ThreadIdleTime{$main::WorkerNumber} += 10;
    }
    die "warning: got stop request from MainThread" unless $main::ComWorker{$Iam}->{run};

    $main::RunTaskNow{ImportMysqlDB} = $Iam;
    $main::lockBayes = 1;
    &rb_mlog( "try to lock Spamdb database in 5 second(s)" );
    sleep 5;
    $main::ThreadIdleTime{$main::WorkerNumber} += 5;
    $main::lastd{$Iam} = "populating Spamdb - $tot records";
    &main::importDB($mainhashname,'',$mysqlTable,$hashref,$totn, 1/2) unless $main::RebuildTestMode;
    $main::lockBayes = '';
    $main::RunTaskNow{ImportMysqlDB} = '';

    &rb_printlog( "Finished populating Spamdb with $tot records - Bayesian check is now enabled!\n" );
    &rb_mlog( "Finished populating Spamdb with $tot records - Bayesian check is now enabled!" );
    &main::checkDBCon() if ($main::CanUseTieRDBM && $main::DBisUsed);
    return;
}

sub rb_Load_Trashlist {
       my $LH;
       unless (open($LH, '<',"$main::base/trashlist.db")) {
           return;
       }
       binmode($LH);
       while (<$LH>) {
         my ($k,$v) = split/\002/o;
         chomp $v;
         $v =~ s/\r|\n//go;
         if ($k && $v) {
           $Trashlist{$k}=$v;
         }
       }
       eval{close $LH;};
}

sub rb_BDB_getRecordCount {
    my $hash = shift;
    return 0 unless $hash;
    return 0 unless tied %{$hash};
    my $dbo = $hash . 'Obj';
    return 0 unless defined ${$dbo};
    return 0 if ("${$dbo}" !~ /BerkeleyDB/o);
    my $statref;
    eval (<<'EOT');
         $statref = ${$dbo}->db_stat();
EOT
    return 0 unless $statref;
    return 0 unless ref $statref;
    return $statref->{hash_ndata};
}


sub rb_generatescores {
    my ( $t, $s, $pair, $v );
    &rb_printlog("\nGenerating weighted Bayesian tuplets\n");
    my $spamdbFile;
    if (! $main::ReplaceOldSpamdb) {
        (open( $spamdbFile, '>', "$main::base/spamdb.rb.tmp" )) ||  &rb_printlog("unable to open $main::base/spamdb.rb.tmp: $!\n");
        binmode $spamdbFile;
        print { $spamdbFile } "\n";
    }
    my $totspam = &rb_BDB_getRecordCount('spam') || scalar keys %spam;
    my $count = 0;
    while ( ( $pair, $v ) = each(%spam) ) {
        next if (! $pair);
        $count++;
        if ($count%1000==0) {
            die "warning: got stop request from MainThread" unless $main::ComWorker{$Iam}->{run};
            $main::lastd{$Iam} = "Generating weighted Bayesian tuplets $count/$totspam";
        }
        my ($s1, $t1) = ( $s, $t ) = split( q{ }, $v );
#        $t = ( $t - $s ) * $norm + $s;    # normalize t
        if ( $t1 > 3 ) {

            # if token represents all spam or all ham then square its value
            if ( $s1 == $t1 || $s1 == 0 ) {
                $s = $s * $s;
                $t = $t * $t;
            }
            $v = ( 1 + $s ) / ( $t + 2 );
            $v = sprintf( "%.7f", $v );
            $v = 0.9999999 if $v >= 1;
            $v = 0.0000001 if $v <= 0;
            if (abs( $v - .5 ) > .09) {
                $newspam{$pair} = $v;
                print { $spamdbFile } "$pair\002$v\n" if (! $main::ReplaceOldSpamdb);
            }
        }
    }
    my $nowspam = &rb_BDB_getRecordCount('newspam') || scalar keys %newspam;
    eval{close $spamdbFile;} if (! $main::ReplaceOldSpamdb);
    &main::checkDBCon() if ($main::CanUseTieRDBM && $main::DBisUsed);
    my $oldspam = &main::getDBCount('main::Spamdb','main::spamdb');
    if ($main::ReplaceOldSpamdb) {
        if ($main::spamdb ne 'DB:' or
            ($main::spamdb eq 'DB:' and $main::DBusedDriver eq 'BerkeleyDB' and $main::CanUseBerkeleyDB))
        {
            $main::lastd{$Iam} = "populating $nowspam SpamDB records";
            &rb_printlog("populating Spamdb $nowspam records - Bayesian check is now disabled\n");
            &rb_mlog("populating $nowspam Spamdb records - Bayesian check is now disabled");
            $main::lockBayes = 1;
            &rb_mlog( "try to lock Spamdb database in 5 second(s)" );
            sleep 5;
            $main::ThreadIdleTime{$main::WorkerNumber} += 5;
            %main::Spamdb = %newspam;
            $main::lockBayes = '';
            $main::lastd{$Iam} = "finished populating SpamDB records: $nowspam";
            &rb_printlog("done - populating Spamdb records - $nowspam - Bayesian check is now enabled\n");
            &rb_mlog("done - populating Spamdb records - $nowspam - Bayesian check is now enabled");
        } else {
            rb_populate_Spamdb(\%newspam,$nowspam);
        }
    } else {
        $count = 0;
        $main::lastd{$Iam} = "add/modify $nowspam SpamDB records";
        &rb_printlog("add/modify Spamdb $nowspam records\n");
        &rb_mlog("add/modify Spamdb $nowspam records");
        while ( ( $pair, $v ) = each(%newspam) ) {
            $count++;
            if ($count%1000==0) {
                die "warning: got stop request from MainThread" unless $main::ComWorker{$Iam}->{run};
                $main::lastd{$Iam} = "add/modify weighted Bayesian tuplets $count/$nowspam";
            }
            $main::Spamdb{$pair} = $v;
        }
        $main::lastd{$Iam} = "finished add/modify SpamDB records: $nowspam";
        &rb_printlog("done - add/modify Spamdb records - $nowspam\n");
        &rb_mlog("done - add/modify Spamdb records - $nowspam");
    }
    &rb_printlog("done - Generating weighted Bayesian tuplets\n");
    my $filesize = -s "$main::base/spamdb.rb.tmp";
    if (! $main::ReplaceOldSpamdb) {
        &rb_printlog( "\nResulting file '$main::base/spamdb.rb.tmp' is " . &rb_commify($filesize) . " bytes\n" );
    } else {
        &rb_printlog( "\n");
    }
    my $allpairs ;
    if ($main::ReplaceOldSpamdb) {
        $allpairs = $nowspam;
    } else {
        $allpairs = &main::getDBCount('main::Spamdb','main::spamdb');
    }
    &rb_printlog("Bayesian Pairs: " . &rb_commify($allpairs) . " now in list\n");
    &rb_mlog("Bayesian Pairs: " . &rb_commify($allpairs) . " now in list");
    $main::currentDBVersion{Spamdb} = $main::Spamdb{'***DB-VERSION***'} = $main::requiredDBVersion{Spamdb};
    %spam = ();
    return;
} ## end sub generatescores

sub rb_generateHMM {
    my $count = $spamHMM->{'chainsDB'}->db_stat()->{hash_ndata};
    $count +=   $spamHMM->{'totalsDB'}->db_stat()->{hash_ndata};
    $count +=   $hamHMM->{'chainsDB'}->db_stat()->{hash_ndata};
    $count +=   $hamHMM->{'totalsDB'}->db_stat()->{hash_ndata};
    $count = &rb_commify($count);
    &rb_printlog("\nGenerating consolidated Hidden-Markov-Model database from $count record model\n");
    &rb_mlog("Generating consolidated Hidden-Markov-Model database from $count record model");
    $count = 0;
    my $rec = 0;
    my $sep = $spamHMM->{seperator};
    while( my ($k,$sw) = each %{$spamHMM->{chains}} ) {
        $count++;
        if ($count%1000==0) {
            die "warning: got stop request from MainThread" unless $main::ComWorker{$Iam}->{run};
            $main::lastd{$Iam} = "add HMM sequences $count";
        }
        my ($seq) = $k =~ /^(.+)$sep[^$sep]+$/;
        next unless ($seq);
        my $ht = $hamHMM->get_totals($seq);
        my $st = $spamHMM->get_totals($seq);
        if (my $tot = $ht + $st) {
            my $hw = $hamHMM->sequence_known($k);
            my $h = $hw / $tot;
            my $s = $sw / $tot;

            my $sp = (1 - $h + $s) / 2 ;
            $sp = 0.0000001 if $sp <= 0;
            $sp = 0.9999999 if $sp >= 1;
            if (abs( $sp - .5 ) > .09) {
                $HMMres{$k} = $sp;
                $rec++;
            }
        }
        delete ${$hamHMM->{chains}}{$k};
    }
    &main::checkDBCon() if ($main::CanUseTieRDBM && $main::DBisUsed);
    while( my ($k,$hw) = each %{$hamHMM->{chains}} ) {
        $count++;
        if ($count%1000==0) {
            die "warning: got stop request from MainThread" unless $main::ComWorker{$Iam}->{run};
            $main::lastd{$Iam} = "add HMM sequences $count";
        }
        my ($seq) = $k =~ /^(.+)$sep[^$sep]+$/;
        next unless ($seq);
        my $ht = $hamHMM->get_totals($seq);
        my $st = $spamHMM->get_totals($seq);
        if (my $tot = $ht + $st) {
            my $h = $hw / $tot;

            my $sp = (1 - $h) / 2 ;
            $sp = 0.0000001 if $sp <= 0;
            $sp = 0.9999999 if $sp >= 1;
            if (abs( $sp - .5 ) > .09) {
                $HMMres{$k} = $sp;
                $rec++;
            }
        }
    }
    &rb_printlog("HMM sequences: " . &rb_commify($rec) . " now in list\n\n");
    &rb_mlog("HMM sequences: " . &rb_commify($rec) . " now in list");
}

sub rb_createheloblacklist {
    (open( my $FheloBlack, '>', "$main::base/spamdb.helo.rb.tmp" )) || &rb_printlog("unable to open '$main::base/spamdb.helo.rb.tmp' $!\n");
    binmode $FheloBlack;
    print { $FheloBlack } "\n";
    my $count = &rb_commify(rb_BDB_getRecordCount('Helo') || scalar keys %Helo);
    &rb_mlog("generating Spamdb.helo records from $count collected HELO's");
    &rb_printlog("generating Spamdb.helo records from $count collected HELO's\n");
    &main::checkDBCon() if ($main::CanUseTieRDBM && $main::DBisUsed);
    $count = 0;
    my $allcount = 0;
    my $notnew = 0;
    %main::HeloBlack = () if ($main::build lt 13080);
    while ( my ( $helostr, $weight ) = each(%Helo) ) {
        my $helostrlc = lc($helostr);
        my $spam = int($weight / 1000000);
        my $ham = $weight - $spam * 1000000;
# at least 5 spam weights without a ham weight [spam/(spam + 0 + .1) = 0.98 -> spam = 4.9] or
# at least 22 spam weights per ham weight      [spam/(spam + 1/3 + .1) = 0.98 -> spam = 21,7] to get HeloBlack
# at least 54 spam weights per ham weight      [spam/(spam + 1 + .1) = 0.98 -> spam = 53,9] to get HeloBlack
        my $w = $spam / ( $spam + $ham / 3 + .1 );
        if ( $w > .98 ) {
            $w = int($w + 0.5);
            print { $FheloBlack } "$helostrlc\002$w\n";
            $allcount++;
            if (exists $main::HeloBlack{$helostrlc}) {
                $notnew++;
            } elsif ($main::MaintenanceLog >= 2) {
                &rb_printlog("added new black helo '$helostrlc' to HeloBlackList\n");
                &rb_mlog("added new black helo '$helostrlc' to HeloBlackList");
            }
            $main::HeloBlack{$helostrlc} = $w;
        } elsif ($w < 0.12 && $ham > 3) {
            $w = sprintf("%.2f",(0.2 - $w));
            print { $FheloBlack } "$helostrlc\002$w\n";
            $allcount++;
            if (exists $main::HeloBlack{$helostrlc}) {
                $notnew++;
            } elsif ($main::MaintenanceLog >= 2) {
                &rb_printlog("added new good helo '$helostrlc' to HeloBlackList\n");
                &rb_mlog("added new good '$helostrlc' to HeloBlackList");
            }
            $main::HeloBlack{$helostrlc} = $w;
        } else {
            delete $Helo{$helostr};
        }
        $count++;
        if ($count%1000==0) {
            $main::lastd{$Iam} = "generating Spamdb.helo records $count";
            my $dbc = $main::HeloBlack{$helostr};
            die "warning: got stop request from MainThread" unless $main::ComWorker{$Iam}->{run};
        }
    }
    eval{close $FheloBlack;};

    $count = 0;
    if ($main::ReplaceOldSpamdb && ! $onlyNewCorrected) {
        &rb_printlog("cleaning old Spamdb.helo records\n");
        &rb_mlog("cleaning old Spamdb.helo records");
        while ( my ( $helostr, $weights ) = each(%main::HeloBlack) ) {   #   clean old records from Spamdb.Helo
            $helostr = lc($helostr);
            delete $main::HeloBlack{$helostr} if (! exists $Helo{$helostr});
            $count++;
            if ($count%1000==0) {
                $main::lastd{$Iam} = "cleaning old Spamdb.helo records $count";
                die "warning: got stop request from MainThread" unless $main::ComWorker{$Iam}->{run};
            }
        }
        &rb_printlog("done - cleaning old Spamdb.helo records\n");
        &rb_mlog("done - cleaning old Spamdb.helo records");
    }
    $count = &rb_commify(&main::getDBCount('main::HeloBlack','main::spamdb'));
    my $newhelos = &rb_commify($allcount - $notnew);
    my $text = ($main::ReplaceOldSpamdb) ? 'new' : 'in new mail';
    &rb_printlog( "\nHELO Blacklist: $newhelos $text, $count now in list\n" );
    &rb_mlog( "HELO Blacklist: $newhelos $text, $count now in list" );
    return;
}

sub rb_processNewCorrected {
    &main::checkDBCon() if ($main::CanUseTieRDBM && $main::DBisUsed);
    $movetime = 0;
    my %addspam;
    my $newhamHMM  = ASSP::MarkovChain->new(longest => $main::HMMSequenceLength,
                                          shortest => $main::HMMSequenceLength,
                                          top => 1,
                                          nostarts => 1,
                                          simple => 1
                                          );
    my $newspamHMM = ASSP::MarkovChain->new(longest => $main::HMMSequenceLength,
                                          shortest => $main::HMMSequenceLength,
                                          top => 1,
                                          nostarts => 1,
                                          simple => 1
                                          );
# collect the SpamDB and HMM data from the files
    foreach my $file (sort { $main::newReported{$b} cmp $main::newReported{$a} } keys(%main::newReported) ) {
        my ($fldrType,$weight) = split(/\s+/o,$main::newReported{$file});
        if ($fldrType eq 'ham') {
            $weight += 4;
            $fldrType = 0;
        } else {
            $weight += 2;
            $fldrType = 1;
        }
        delete $main::newReported{$file};
        &rb_add( $fldrType, $file, $weight, \&rb_donohash, \%addspam ,$newspamHMM, $newhamHMM, 0 );
        rb_mlog("processed corrected file '$file' for SpamDB and HMMdb") if $main::MaintenanceLog > 1;
        die "warning: got stop request from MainThread" unless $main::ComWorker{$Iam}->{run};
    }

    my $mod;
# calculate and update the SpamDB
    if ($main::haveSpamdb) {
        my $count = 0;
        foreach (keys %addspam) {
            my ( $sfac, $tfac ) = split( q{ }, $addspam{ $_ } );
            my ( $sfao, $tfao ) = split( q{ }, $spam{ $_ } );
            $sfac += $sfao;
            $tfac += $tfao;
            $spam{ $_ } = $addspam{ $_ } = "$sfac $tfac";
        }
        die "warning: got stop request from MainThread" unless $main::ComWorker{$Iam}->{run};

        my ( $t, $s, $pair, $v );
        while ( ( $pair, $v ) = each(%addspam) ) {
            next if (! $pair);
            my ($s1, $t1) = ( $s, $t ) = split( q{ }, $v );
#            $t = ( $t - $s ) * $norm + $s;    # normalize t
            if ( $t1 > 3 ) {

                # if token represents all spam or all ham then square its value
                if ( $s1 == $t1 || $s1 == 0 ) {
                    $s = $s * $s;
                    $t = $t * $t;
                }
                $v = ( 1 + $s ) / ( $t + 2 );
                $v = sprintf( "%.7f", $v );
                $v = 0.9999999 if $v >= 1;
                $v = 0.0000001 if $v <= 0;
                if (abs( $v - .5 ) > .09) {
                    $main::Spamdb{$pair} = $v;
                    $count++;
                } else {
                    delete $main::Spamdb{$pair};
                }
            }
        }
        $mod = "SpamDB($count)";
    }
    die "warning: got stop request from MainThread" unless $main::ComWorker{$Iam}->{run};
# calculate and update the HMMdb
    if ($DoHMM && $main::haveHMM) {
        my $count = 0;
        my $sep = $newspamHMM->{seperator};
        foreach my $k (keys %{$newspamHMM->{chains}}) {
            my ($seq) = $k =~ /^(.+)$sep[^$sep]+$/;
            $newspamHMM->{totals}{$seq} += $spamHMM->{totals}{$seq};
            $spamHMM->{totals}{$seq} = $newspamHMM->{totals}{$seq};
            $newspamHMM->{chains}{$k} += $spamHMM->{chains}{$k};
            $spamHMM->{chains}{$k} = $newspamHMM->{chains}{$k};
        }
        foreach my $k (keys %{$newhamHMM->{chains}}) {
            my ($seq) = $k =~ /^(.+)$sep[^$sep]+$/;
            $newhamHMM->{totals}{$seq} += $hamHMM->{totals}{$seq};
            $hamHMM->{totals}{$seq} = $newhamHMM->{totals}{$seq};
            $newhamHMM->{chains}{$k} += $hamHMM->{chains}{$k};
            $hamHMM->{chains}{$k} = $newhamHMM->{chains}{$k};
        }
        die "warning: got stop request from MainThread" unless $main::ComWorker{$Iam}->{run};

        while( my ($k,$sw) = each %{$newspamHMM->{chains}} ) {
            my ($seq) = $k =~ /^(.+)$sep[^$sep]+$/;
            next unless ($seq);
            my $ht = $newhamHMM->get_totals($seq);
            my $st = $newspamHMM->get_totals($seq);
            if (my $tot = $ht + $st) {
                my $hw = $newhamHMM->sequence_known($k);
                my $h = $hw / $tot;
                my $s = $sw / $tot;

                my $sp = (1 - $h + $s) / 2 ;
                $sp = 0.0000001 if $sp <= 0;
                $sp = 0.9999999 if $sp >= 1;
                if (abs( $sp - .5 ) > .09) {
                    $main::HMMdb{$k} = $sp;
                    $count++;
                } else {
                    delete $main::HMMdb{$k};
                }
            }
            delete ${$newhamHMM->{chains}}{$k};
        }
        &main::checkDBCon() if ($main::CanUseTieRDBM && $main::DBisUsed);
        while( my ($k,$hw) = each %{$newhamHMM->{chains}} ) {
            my ($seq) = $k =~ /^(.+)$sep[^$sep]+$/;
            next unless ($seq);
            my $ht = $newhamHMM->get_totals($seq);
            my $st = $newspamHMM->get_totals($seq);
            if (my $tot = $ht + $st) {
                my $h = $hw / $tot;

                my $sp = (1 - $h) / 2 ;
                $sp = 0.0000001 if $sp <= 0;
                $sp = 0.9999999 if $sp >= 1;
                if (abs( $sp - .5 ) > .09) {
                    $main::HMMdb{$k} = $sp;
                    $count++;
                } else {
                    delete $main::HMMdb{$k};
                }
            }
        }
        $mod .= ' and ' if $mod;
        $mod .= "HMMdb($count)";
    }
    if ($mod) {
        rb_mlog("updated $mod from new corrected files");
        rb_createheloblacklist();
    }
}

sub rb_processfolder {
    my ( $fldrType, $fldrpath, $filter, $weight, $sub, $MaxFiles, $neededHamWords, $neededSpamWords ) = @_;
    my ( $count, $pcount, $processFolderTime, $folderStartTime, $fileCount, @files, $deleteCount, $ignoreCount );
    &main::checkDBCon() if ($main::CanUseTieRDBM && $main::DBisUsed);
    $MaxFiles = $main::MaxFiles;
#    $MaxFiles ||= $main::MaxFiles;
#    $MaxFiles = &main::min($MaxFiles,$main::MaxFiles);
    $folderStartTime = time;
    $attachments = 0;
    my $flr = $fldrpath;
    $fldrpath = $main::base.'/'.$fldrpath;
    $fldrpath = &rb_fixPath($fldrpath);
    &rb_printlog( "\n" . $fldrpath . "\n" );
    &rb_mlog($fldrpath);
#   $fldrpath .= $filter eq "*" ? "/*" : "/*$filter";
    $fldrpath .= '/';
    $fileCount = &rb_countfiles($fldrpath);
    &rb_printlog( "File Count:\t" . &rb_commify($fileCount) );
    &rb_mlog( "File Count:\t" . &rb_commify($fileCount) );
    &rb_printlog("\nProcessing... $flr with ".&rb_commify(&main::min($fileCount,$MaxFiles))." files");
    &rb_mlog("Processing... $flr with ".&rb_commify(&main::min($fileCount,$MaxFiles))." files");
    $count = $RedCount = $WhiteCount = $deleteCount = 0;

    @files =  map { $_->[0] }
              sort { $b->[1] <=> $a->[1] }
              map { [ $_, &main::ftime($fldrpath.$_) ] } $main::unicodeDH->($fldrpath);  # youngest files first

    my ($spt,$nspt) = split(/\s+/o,($weight == 1 ? $main::MaxBayesFileAge : $main::MaxCorrectedDays));
    $nspt = $spt unless defined $nspt;
    $spt = $nspt if ! $fldrType;
    $spt *= 3600 * 24;
    my $rem = ($spt && $main::MaintBayesCollection) ? ' and remove' : '';
    &rb_printlog("\nignore$rem files older than ".&main::timestring($folderStartTime - $spt,'','')." in folder $flr") if $spt;
    &rb_mlog("ignore$rem files older than ".&main::timestring($folderStartTime - $spt,'','')." in folder $flr") if $spt;
    my %toolong;

    while (@files) {
        my $file = shift @files;
        $file = $fldrpath.$file;
        delete $main::newReported{$file};
        &main::ThreadYield();
        if ($count%100==0) {
            die "warning: got stop request from MainThread" unless $main::ComWorker{$Iam}->{run};
            $main::lastd{$Iam} = "Processed $count/$fileCount files in $flr";
        }
        next if $main::dF->( $file );
        my $ftime = &main::ftime($file);
        next unless $ftime;
        my $dtime = $folderStartTime - $ftime;
        if ( $spt && $dtime > $spt ) {
            $count++;
            if ($main::MaintBayesCollection) {
                $main::unlink->($file);
                $deleteCount++;
                next;
            }
            $ignoreCount++;
            next;
        }
        if (($pcount - ( $RedCount + $WhiteCount )) < $MaxFiles)
        {    #too many files or words;
            my $heloOnly = ((! defined $neededHamWords) && (! defined $neededSpamWords))
                        || ($neededHamWords > 0 && $neededHamWords > $HamWordCount)
                        || ($neededSpamWords > 0 && $neededSpamWords > $SpamWordCount) ? 0 : 1;
            rb_d( 'file ('.++$pcount.")[$heloOnly]: $file");
            my $t = Time::HiRes::time();
            my $nocheck = &rb_add( $fldrType, $file, $weight, $sub, \%spam ,$spamHMM, $hamHMM, $heloOnly);
            delete $main::newReported{ $file };
            if (! $nocheck) {
                $t = Time::HiRes::time() - $t;
                if (($mintime && $t > $mintime) or ($movetime && $t > $movetime)) {
                    $t = sprintf("%.2f",$t);
                    &rb_d( "too long file processing time: $file - $t seconds" );
                    $toolong{$file} = $t;
                }
            }
            $count += $heloOnly ? 0 : 1;
        } elsif (! $spt) {     # stop if we don't have to remove old files
            $count++;
            last;
        }
    }
    if   ( time - $folderStartTime != 0 ) { $processFolderTime = time - $folderStartTime; }
    else                                  { $processFolderTime = 1; }
    $pcount = $pcount - ( $RedCount + $WhiteCount );
    if ($RedCount) {
        &rb_printlog( "\nRemoved Red:\t" . &rb_commify($RedCount) );
        &rb_mlog( "Removed Red:\t" . &rb_commify($RedCount) );
    }

    if ($WhiteCount) {
        &rb_printlog( "\nRemoved White:\t" . &rb_commify($WhiteCount) );
        &rb_mlog( "Removed White:\t" . &rb_commify($WhiteCount) );
    }

    if ($deleteCount) {
        &rb_printlog( "\nRemoved Old:\t" . &rb_commify($deleteCount) );
        &rb_mlog( "Removed Old:\t" . &rb_commify($deleteCount) );
    }

    if ($ignoreCount) {
        &rb_printlog( "\nIgnored:\t" . &rb_commify($ignoreCount) );
        &rb_mlog( "Ignored:\t" . &rb_commify($ignoreCount) );
    }

    if ($doattach) {
        rb_mlog(&rb_commify($attachments)." attachment/image entries processed");
        rb_printlog("\n".&rb_commify($attachments)." attachment/image entries processed");
    }

    &rb_printlog( "\nImported Files for HeloBlackList:\t" . &rb_commify($pcount) );
    &rb_mlog( "Imported Files for HeloBlackList:\t" . &rb_commify($pcount) );
    &rb_printlog( "\nImported Files for Bayes/HMM:\t" . &rb_commify($count) );
    &rb_mlog( "Imported Files for Bayes/HMM:\t" . &rb_commify($count) );

    if ( $count >= $main::MaxFiles ) {
        &rb_printlog("\nFolder contents exceeded 'MaxFiles'($main::MaxFiles). ");
        &rb_mlog("Folder contents exceeded 'MaxFiles'($main::MaxFiles). ");
    }

    if (($mintime or $movetime) && (my $tl = scalar keys %toolong)) {
        my $mtl = &main::min($tl,10);
        if ($mintime) {
            &rb_printlog("\nThe processing time of $tl file(s) in '$fldrpath' was longer than $mintime second(s) - now showing the $mtl longest");
            &rb_mlog("The processing time of $tl file(s) in '$fldrpath' was longer than $mintime second(s) - now showing the $mtl longest");
        }
        my $i = 0;
        my @toolong = sort { $toolong{$b} <=> $toolong{$a} } keys %toolong;
        while ( my $f = shift @toolong) {
            if ($mintime && (++$i <= $mtl)) {
                &rb_printlog("\n$f - $toolong{$f} s");
                rb_mlog("$f - $toolong{$f} s");
            }
            if ($movetime && $toolong{$f} > $movetime) {
                my $tofile = $f;
                my $base = $main::base;
                $tofile =~ s/^\Q$base\E\//$base\/rebuild_error\//;
                $main::unlink->($tofile);
                if ($main::move->($f,$tofile)) {
                    &rb_printlog("\nmoved file '$f' to '$tofile', because the processing time $toolong{$f} was longer than $movetime second(s)");
                    &rb_mlog("moved file '$f' to '$tofile', because the processing time $toolong{$f} was longer than $movetime second(s)");
                } else {
                    my $error = $!;
                    &rb_printlog("\ncan't moved file '$f' to '$tofile', the processing time $toolong{$f} was longer than $movetime second(s) - $error");
                    &rb_mlog("can't moved file '$f' to '$tofile', the processing time $toolong{$f} was longer than $movetime second(s) - $error");
                }
            }
        }
    }

# &rb_printlog( "\nfolder $flr: " . &rb_commify($SpamWordCount) . " spam weight \nfolder $flr: " . &rb_commify($HamWordCount) . " non-spam weight." );
    &rb_printlog("\nFinished in ".&rb_commify($processFolderTime)." second(s)\n");
    &rb_mlog("Finished in ".&rb_commify($processFolderTime)." second(s)");

    $scanTime += $processFolderTime;
    $scanFiles += $pcount;

    return $count;
} ## end sub processfolder

sub rb_countfiles {
    my ($fldrpath) = @_;
    my %fileCount;
    map {$fileCount{$_} = 1;} $main::unicodeDH->($fldrpath);
    delete $fileCount{'.'};
    delete $fileCount{'..'};
    return scalar(keys %fileCount);
}

sub rb_commify {
    local $_ = shift;
    1 while s/^([-+]?\d+)(\d{3})/$1,$2/o;
    return $_;
}

sub rb_hash {
    my $msgText = shift;

    # creates a md5 hash of $msg body
    if ( $$msgText =~ /^.*?\n\r?\n(.+)$/so ) {
        return eval{ Digest::MD5::md5_hex(substr($1,0,$main::MaxBytes)); };
    } else {
        return eval{ Digest::MD5::md5_hex(substr($$msgText,0,$main::MaxBytes)); };
    }
}

sub rb_dospamhash {
    my ( $FileName, $msgText ) = @_;
    $SpamHash{ &rb_hash($msgText) }++;
    return 0;
}

sub rb_dohamhash {
    my ( $FileName, $msgText ) = @_;
    $HamHash{ &rb_hash($msgText) }++;
    return 0;
}

sub rb_donohash {
    return 0;
}

sub rb_checkspam {
    my ( $FileName, $msgText ) = @_;
    my ( $return, $reason );
    if ( defined( $HamHash{ &rb_hash($msgText) } ) ) {

# we've found a message in the spam database that is the same as one in the corrected Ham group
        &rb_deletefile( $FileName, "corrected ham" );
        return 1;
    }
    elsif ( $reason = &rb_redlisted( $msgText ) ) {
        &rb_deletefile( $FileName, $reason );
        return 1;
    }
    elsif ( $reason = &rb_whitelisted( $msgText ) ) {
        &rb_deletefile( $FileName, $reason );
        return 1;
    }
    return 0;
}

sub rb_checkham {
    my ( $FileName, $msgText ) = @_;
    my ( $return, $reason );
    if ( defined( $SpamHash{ &rb_hash($msgText) } ) ) {

# we've found a message in the ham database that is the same as one in the corrected spam group
        &rb_deletefile( $FileName, "corrected spam" );
        return 1;
    }
    elsif ( $reason = &rb_redlisted( $msgText ) ) {
        &rb_deletefile( $FileName, "$reason" );
        return 1;
    }
    return 0;
}

sub rb_whitelisted {
    my $mm = shift;
    my $m = substr($$mm,0,$main::MaxBytes + 1000);
    my ( %seenf, %seent );

    # test against expression to recognize whitelisted mail
    my $mwr = $main::whiteReRE;
    if ( $main::whiteRe && $m =~ /($mwr)/ ) {
        my $reason = $1;
        $reason =~ s/\s+$/ /go;
        $reason =~ s/[\r\n\s]+/ /go;
        if ( length($reason) >= $main::RegExLength ) { $reason = substr( $reason, 0, ( $main::RegExLength - 4 ) ) . "..." }
        $WhiteCount++;
        return ( "Regex:White '" . $reason . q{'} );
    }
    $m =~ s/^($main::HeaderNameRe:$main::HeaderValueRe)+/$1/so;    # remove body

    my (@to,@from);
    while ( $m =~ /($main::HeaderNameRe):($main::HeaderValueRe)/igos ) {
        my ($h,$s) = ($1,$2);
        die "warning: got stop request from MainThread" unless $main::ComWorker{$Iam}->{run};
        if ($h =~ /^(?:from|sender|X-Assp-Envelope-From|reply-to|errors-to|list-\w+)$/io) {
            &main::headerUnwrap($s);
            next unless ($s =~ /($main::EmailAdrRe\@$main::EmailDomainRe)/io);
            push @from , &main::batv_remove_tag(0,lc($1),'');
        }
        if ($h =~ /^(?:to|X-Assp-Intended-For)$/io) {
            &main::headerUnwrap($s);
            next unless ($s =~ /($main::EmailAdrRe\@$main::EmailDomainRe)/io);
            push @to , &main::batv_remove_tag(0,lc($1),'');
        }
    }
    while (my $curaddr = shift @from) {
        die "warning: got stop request from MainThread" unless $main::ComWorker{$Iam}->{run};

        if ( exists $seenf{ $curaddr } ) {
            next;                #we already checked this address
        } else {
            $seenf{ $curaddr } = 1;
        }
        foreach (@to) {
            if ( exists $seent{ $_ } ) {
                next;                #we already checked this address
            } else {
                $seent{ $_ } = 1;
            }
            if ( &main::Whitelist($curaddr,$_)) {
                $WhiteCount++;
                return ( "WhiteList: '$curaddr,$_'" );
            }
            if ($main::wildcardUser) {
                my ( $mfdd, $alldd, $reason );
                $mfdd = $1 if $curaddr =~ /(\@[^@]*)/o;
                $alldd = "$main::wildcardUser$mfdd";
                if ( &main::Whitelist( lc $alldd , $_) ) {
                    $WhiteCount++;
                    return ( "WhiteList-Wild: '$curaddr,$_'" );
                }
            }
        }
        %seent = ();
        if ($main::whiteListedDomains && &main::matchRE([$curaddr],'whiteListedDomains',1)) {
            $WhiteCount++;
            return ( "WhiteListed Domain: '" . $curaddr . q{'} );
        }
    } ## end while
    return 0;
} ## end sub whitelisted

sub rb_redlisted {
    my $mm = shift;
    my $m = substr($$mm,0,$main::MaxBytes + 1000);

    # test against expression to recognize redlisted mail
    if ( $main::DoNotCollectRedRe ) {    #skip Redre check, 1.3.5 and higher
        my $mrR = $main::redReRE;
        if ( $main::redRe && $m =~ /($mrR)/ ) {
            my $reason = $1;
            $reason =~ s/\s+$/ /go;
            $reason =~ s/[\r\n\s]+/ /go;
            if ( length($reason) >= $main::RegExLength ) { $reason = substr( $reason, 0, ( $main::RegExLength - 4 ) ) . "..." }
            $RedCount++;
            return ( "Regex:Red '" . $reason . q{'} );
        }
    }
    if ( $main::DoNotCollectRedList ) {    #skip Redlist check, 1.3.5 and higher
        $m =~ s/\n\r?\n.*$//so;                            # remove body
        while ( $m =~ /($main::EmailAdrRe\@$main::EmailDomainRe)/igo ) {
            my $curaddr = lc($1);
            die "warning: got stop request from MainThread" unless $main::ComWorker{$Iam}->{run};

            if ( $main::Redlist{ $curaddr } ) {
                $RedCount++;
                return ( "redlist: '" . $curaddr . q{'} );
            }
        }
    }
    return 0;
} ## end sub redlisted

sub rb_deletefile {
    my ( $fn, $reason, $ignorekeepdeleted ) = @_;

    if ( $main::eF->( $fn )) {
        &rb_printlog( "\nremove " . $fn . q{ } . $reason );
        if (! $main::RebuildTestMode) {
            if ( $main::MaxKeepDeleted && !$ignorekeepdeleted ) {
                $Trashlist{$fn} = time;
            } else {
                $main::unlink->($fn);
            }
        }
    } else {
        rb_printlog("\ncannot delete " . $reason . " message " . $fn . ": $!" );
    }
}

sub rb_get {
    my ( $fn, $sub , $factor) = @_;
    my $message;
    my $count;
    my $numreadchars;
    my $headlen;
    my $mBytes = $main::MaxBytes || 4000;
    my $ftime = &main::ftime($fn);
    return unless $ftime;
    my $dtime = $ftime - time;
    my $bodybytes = $mBytes * (($factor > 1) ? 4 : 2);

    return if $dtime > 0 or exists $Trashlist{$fn};
    my $file;
    $main::open->($file, '<', "$fn" ) or return;

    $file->binmode;
    $numreadchars = ($main::HeaderMaxLength ? $main::HeaderMaxLength : 10000) + $bodybytes;
#rb_d("rb_get - $fn - to read - $numreadchars - $file");
    $count = $file->read( $message, $numreadchars );    # read characters into memory
#rb_d("rb_get - $fn - read");
    eval{$file->close;};
    if ($count) {
        my @keep = $message =~ /((?:X-Assp-Reported-By|X-Assp-Intended-For|X-Forwarded-For):$main::HeaderValueRe)/gois;
        $message =~ s/X-ASSP[^:]+:$main::HeaderValueRe//gois;                   # remove all X-ASSP headers
        $message =~ s/(?:DKIM|DomainKey)-Signature:$main::HeaderValueRe//gios;  # remove DKIM/DomainKey signatures
        $message = join('',@keep).$message;
        $headlen = index($message, "\x0D\x0A\x0D\x0A");
        if ($headlen >= 0) {$headlen += 4;} else {$headlen = 0;}
        $message = substr($message, 0, $headlen + $bodybytes);
    } else {
        return;
    }
    return if $sub->( $fn, \substr($message, 0, $headlen + $mBytes ) );   # have i read this before?

    $processedBytes += length $message;
    return \$message, $headlen;
}

sub rb_checkRunTime {
    my ($StartTime, $text) = @_;
    return 0 unless $movetime;
    $rtText = $text if $text;
    return 0 if Time::HiRes::time() <= ($StartTime + $movetime);
    rb_d($rtText);
    return 1;
}

sub rb_add {
    my ( $isspam, $fn, $factor, $sub, $spam ,$spamHMM, $hamHMM, $heloOnly) = @_;
    return if $main::dF->( $fn );
    my $startTime = Time::HiRes::time();
    my ($content,$headerlen) = &rb_get( $fn, $sub , $factor);
    return unless $content;
    return if (rb_checkRunTime($startTime,"reached $movetime s after rb_get on $fn"));
    my $imgHash;
    my $fsize = [$main::stat->( $fn )]->[7];
    if ($doattach && ! $heloOnly && ($fsize < $main::npSize) && ! exists $Trashlist{$fn.'.att'}) {
        $imgHash = &main::AttachMD5File($fn);
        $processedBytes += $fsize;
        if (rb_checkRunTime($startTime,"reached $movetime s after AttachMD5File on $fn")) {
            $Trashlist{$fn.'.att'} = time + (3600 * 24 * 5);
            $startTime = Time::HiRes::time();
            rb_printlog("\nfile '$fn' will be skipped from attachment processing in future rebuild tasks" );
            rb_mlog("file '$fn' will be skipped from attachment processing in future rebuild tasks" );
        }
    } elsif ($doattach && ! $heloOnly && ($fsize < $main::npSize)) {
        rb_printlog("\nfile '$fn' was skipped from attachment processing" );
        rb_mlog("file '$fn' will was skipped from attachment processing" );
    }
    my ( $curHelo, $CurWord, $PrevWord, $sfac, $tfac, $cip, $cipHelo );

    my $IPprivate = $main::IPprivate;
    my ($reportedBy,$domain);
    my $header;
    $header = substr($$content,0,$headerlen);
    if ($header) {
        $reportedBy = lc $1 if ($header =~ /X-Assp-Reported-By:\s*($main::EmailAdrRe\@$main::EmailDomainRe)/io);
        $reportedBy ||= lc $1 if ($header =~ /X-Assp-Intended-For:\s*($main::EmailAdrRe\@$main::EmailDomainRe)/io);
        $reportedBy ||= lc $1 if ($header =~ /^to:.*?($main::EmailAdrRe\@$main::EmailDomainRe)/io);
        ($domain) = $reportedBy =~ /(\@$main::EmailDomainRe)$/o;
        $reportedBy = '' unless (($main::DoPrivatSpamdb & 1) && &main::localmailaddress(0,$reportedBy));
        $domain = '' unless ($main::DoPrivatSpamdb > 1 && &main::localdomainsreal($domain));
        if ( $header =~ /X-Forwarded-For: ($IPRe)/io) {
            $cip = $1;
    		while ( $header =~ /Received:($main::HeaderValueRe)/gis ) {
                my $h = $1;
                if ( $h =~ /\s+from\s+(?:(\S+)\s)?(?:.+?)\Q$cip\E\]?\)(.{1,80})by.{1,20}/gis ) {
                    $cipHelo = $1;
                    $curHelo = $1 if $1;
                    my $rhelo = $2;
                    $cip = &main::ipv6expand(&main::ipv6TOipv4($cip));
                    $rhelo =~ s/\r?\n/ /go;
                    $curHelo = $cipHelo = $1 if $rhelo =~ /.+?helo\s*=?\s*([^\s\)]+)/io;
                }
            }
            if ($cip && &main::matchIP($cip,'ispip','',1)) {
                $cipHelo = '';
                $curHelo = '';
                $cip = '';
            }
        } elsif ( $main::ispHostnames ) {
            while ( $header =~ /Received:($main::HeaderValueRe)/gios ) {
                my $h = $1;
                if ( $h =~ /\s+from\s+(?:(\S+)\s)?(?:.+?)($IPRe)(.{1,80})by.{1,20}(?:$main::ispHostnamesRE)/gios ) {
                    $cip = $2;
                    $cipHelo = $1 || $cip;
                    my $rhelo = $3;
                    if ($cip =~ /$IPprivate/o) {
                        $cipHelo = '';
                        $rhelo = '';
                        next;
                    }

                    $cip = &main::ipv6expand(&main::ipv6TOipv4($cip));
                    $rhelo =~ s/\r?\n/ /gos;
                    $cipHelo = $1 if $rhelo =~ /helo\s*=?\s*([^\s\)]+)/io;
                }
            }
            if ($cip && &main::matchIP($cip,'ispip','',1)) {
                $cipHelo = '';
                $curHelo = '';
                $cip = '';
            }
        }

        my @myNames = ($main::myName);
        push @myNames , split(/[\|, ]+/o,$main::myNameAlso);
        my $myName = join('|', map {my $t = quotemeta($_);$t;} @myNames);

        if (   $myName
            && ! ($cipHelo or $curHelo)
            && $header =~ /Received: from (\S+).{1,20}\(\[($IPRe)(.{1,80})by.{1,20}(?:$myName)/is)
        {
            $curHelo = $1 || $2;
            my $ip = $2;
            my $rhelo = $3;
            if ($ip !~ /$IPprivate/o) {
                $cip = &main::ipv6expand(&main::ipv6TOipv4($ip));
                $rhelo =~ s/\r?\n/ /gos;
                $curHelo = $1 if $rhelo =~ / helo=([^\s\)]+)/io;
                if ($cip && &main::matchIP($cip,'ispip','',1)) {
                    $curHelo = '';
                    $cip = '';
                }
                if ($curHelo && $curHelo =~ /$main::ispHostnamesRE/) {
                    $curHelo = '';
                    $cip = '';
                }
            } else {
                $curHelo = '';
            }
        }
    }
    return if (rb_checkRunTime($startTime,"reached $movetime s after HELO parsing on $fn"));

    $cipHelo = lc($cipHelo);
    $curHelo = lc($curHelo);
    $cipHelo = '' if $cipHelo eq $curHelo;
    $Helo{ $cipHelo } += ( $isspam * 999999 + 1 ) * $factor if ( $cipHelo );
    $Helo{ $curHelo } += ( $isspam * 999999 + 1 ) * $factor if ( $curHelo );
    return 1 if $heloOnly;

    $$content =~  s/(?:X-Assp-Reported-By|X-Assp-Intended-For|X-Forwarded-For):$main::HeaderValueRe//gois;
    my $OK;
    ($content,$OK) = &main::clean($content);
    return if (rb_checkRunTime($startTime,"reached $movetime s after content cleanup on $fn"));
    my $BayesCont = $main::BayesCont;
    my @HMMhamWords;
    my @HMMspamWords;
    my $i = 0;
    foreach (keys %$imgHash) {
        if   ($isspam) { $SpamWordCount += $factor;}
        else           { $HamWordCount  += $factor;}
        ( $sfac, $tfac ) = split( q{ }, $spam->{ $_ } );
        $sfac += $isspam ? ($factor * 2) : 0;
        $tfac += ($factor * 2);
        $spam->{ $_ } = "$sfac $tfac";
        $i++;
        if ($reportedBy) {
            ( $sfac, $tfac ) = split( q{ }, $spam->{ "$reportedBy $_" } );
            $sfac += $isspam ? $factor : 0;
            $tfac += $factor;
            $spam->{ "$reportedBy $_" } = "$sfac $tfac";
        }
        if ($domain) {
            ( $sfac, $tfac ) = split( q{ }, $spam->{ "$domain $_" } );
            $sfac += $isspam ? $factor : 0;
            $tfac += $factor;
            $spam->{ "$domain $_" } = "$sfac $tfac";
        }
    }
    $attachments += $i;
    if ($doattach && $i) {
        rb_d("$i ".($isspam ? 'spam-' : 'ham-')."attachment/image entries processed in file $fn");
    }
    my $j = 0;
    rb_checkRunTime($startTime,"reached $movetime s in Bayes word pairs on $fn");
    my $ret = 1;
    while ( $content =~ /([$BayesCont]{2,})/go ) {
        my @Words;
        (@Words = &main::BayesWordClean($1)) or next;
        while ($CurWord = shift @Words) {
            $CurWord = substr($CurWord,0,37) if length($CurWord) > 37;
            if ( ! $PrevWord ) {            # We only want word pairs
                $PrevWord = $CurWord;
                push(@HMMspamWords,$CurWord) if $DoHMM && $isspam;
                push(@HMMhamWords,$CurWord) if $DoHMM && ! $isspam;
                $i++;
                next;
            }

            # increment global weights, they are not really word counts
            if   ($isspam) { $SpamWordCount += $factor; push(@HMMspamWords,$CurWord) if $DoHMM && $i < $main::HMMDBWords;}
            else           { $HamWordCount  += $factor; push(@HMMhamWords,$CurWord) if $DoHMM && $i < $main::HMMDBWords;}
            ( $sfac, $tfac ) = split( q{ }, $spam->{ "$PrevWord $CurWord" } );
            $sfac += $isspam ? $factor : 0;
            $tfac += $factor;
            $spam->{ "$PrevWord $CurWord" } = "$sfac $tfac";
            if ($reportedBy) {
                ( $sfac, $tfac ) = split( q{ }, $spam->{ "$reportedBy $PrevWord $CurWord" } );
                $sfac += $isspam ? $factor : 0;
                $tfac += $factor;
                $spam->{ "$reportedBy $PrevWord $CurWord" } = "$sfac $tfac";
            }
            if ($domain) {
                ( $sfac, $tfac ) = split( q{ }, $spam->{ "$domain $PrevWord $CurWord" } );
                $sfac += $isspam ? $factor : 0;
                $tfac += $factor;
                $spam->{ "$domain $PrevWord $CurWord" } = "$sfac $tfac";
            }
            $PrevWord = $CurWord;
            $i++;
        }
        if ((++$j % 10 == 0) && rb_checkRunTime($startTime,'')) {$ret = undef; last;}
    } ## end while ( $content =~ /([$BayesCont]{2,})/go)
    if ($DoHMM) {
#        &rb_mlog( 'Rebuild: adding HMM: H = ' .scalar(@HMMhamWords).', S = '.scalar(@HMMspamWords).' words'.' P = '.$reportedBy);
        eval {
            if ($reportedBy && $isspam && @HMMspamWords > $main::HMMSequenceLength) {$spamHMM->seed(symbols => \@HMMspamWords, count => $factor, privacy => $reportedBy);}
            if ($reportedBy && !$isspam && @HMMhamWords > $main::HMMSequenceLength) {$hamHMM->seed(symbols => \@HMMhamWords, count => $factor, privacy => $reportedBy);}
            if ($domain && $isspam && @HMMspamWords > $main::HMMSequenceLength) {$spamHMM->seed(symbols => \@HMMspamWords, count => $factor, privacy => $domain);}
            if ($domain && !$isspam && @HMMhamWords > $main::HMMSequenceLength) {$hamHMM->seed(symbols => \@HMMhamWords, count => $factor, privacy => $domain);}
            if ($isspam && @HMMspamWords > $main::HMMSequenceLength) {$spamHMM->seed(symbols => \@HMMspamWords, count => $factor, privacy => '');}
            if (!$isspam && @HMMhamWords > $main::HMMSequenceLength) {$hamHMM->seed(symbols => \@HMMhamWords, count => $factor, privacy => '');}
            1;
        } or do{$DoHMM = 0;};    # stop HMM if we get an exception while processing (possibly file too large)
    }
    return $ret;
} ## end sub add

sub rb_printlog {
    my ( $text, $format, $notime ) = @_;
    my $lf = '';
    $lf = $1 if $text =~ s/^(\n+)//o;
    if ( ! $format ) {
        if ($text) {
            my $t = $notime ? '' : &main::timestring();
            print { $RebuildLog } $lf . $t . " $text" if ! $onlyNewCorrected;
            &main::d($text);
        } else {
            print { $RebuildLog } $lf if ! $onlyNewCorrected;
        }
    } else {
        if ($text) {
            my $t = $notime ? ' ' : &main::timestring().' ';
            print { $RebuildLog } $lf . $t if ! $onlyNewCorrected;
            printf $RebuildLog "$text", $format if ! $onlyNewCorrected;
            &main::d(sprintf("$text", $format));
        } else {
            print { $RebuildLog } $lf if ! $onlyNewCorrected;
        }
    }
    return;
}

sub rb_mlog {
    my ( $text, $format ) = @_;
    rb_d( $text, $format ) if $RebuildDebug;
    return unless $main::MaintenanceLog;
    if ( !$format ) {
        &main::mlog(0, "$text");
    }
    if ($format) {
        &main::mlog(0,(sprintf "$text", $format));
    }
    return;
}

sub rb_d {
    my ( $text, $format, $notime ) = @_;
    return if (! $RebuildDebug);
    my $t;
    $t = &main::timestring().' ' unless $notime;
    if ( !$format ) {
        print $RebuildDebug "$t$text\n";
    }
    if ($format) {
        print $RebuildDebug sprintf("$t$text\n", $format);
    }
    return;
}

sub rb_uploadgriplist {
    local $/ = "\n";

    &main::checkDBCon() if ($main::CanUseTieRDBM && $main::DBisUsed);

    &rb_printlog("building new GripList records and bounce report\n") if !$main::noGripListUpload;
    &rb_mlog("building new GripList records and bounce report") if !$main::noGripListUpload;

    #&rb_printlog("Start building Griplist \n");
    my ( $date, $ip, $peeraddress, $hostaddress, $connect, $day, $gooddays, $last2days, $st );
    my ($logdir, $logdirfile) = $main::logfile=~/^(.*[\/\\])?(.*?)$/o;
    my @logfiles1=reverse sort( &main::Glob("$main::base/$logdir*$logdirfile") );
    my @logfiles;
    while (@logfiles1) {
        my $k = shift @logfiles1;
        push(@logfiles, $k) if $k !~ /b$logdirfile/;
    }

    #build list of the last 4 days
    my $time = time;
    $day = quotemeta(&main::timestring(undef,'d'));
    $gooddays  .= $day.'|';
    $last2days .= $day.'|';
    $day = quotemeta(&main::timestring( $time - 24 * 3600 , 'd'));
    $gooddays  .= $day.'|';
    $last2days .= $day;
    $day = quotemeta(&main::timestring( $time - 36 * 3600 , 'd'));
    $gooddays .= $day.'|';
    $day = quotemeta(&main::timestring( $time - 72 * 3600 , 'd'));
    $gooddays .= $day;
    undef $day;

    my $dayoffset = $time % ( 24 * 3600 );
    my %bounces = ();
    my $nbounces = 0;
    my $bbounces = 0;
    my $IPprivate = $main::IPprivate;
    while (@logfiles) {
        my $File = shift @logfiles;
        my $ftime = &main::ftime($File) || time;
        next if ( ( $ftime + 4 * 24 * 3600 ) < ( $time - $dayoffset ) );
        &rb_printlog("processing Logfile $File\n");
        &rb_mlog("processing Logfile $File");
        next unless (open( my $FLogFile, '<', "$File" ));
        while (<$FLogFile>) {
            if ( ( $ip ) = /(?:$gooddays) .*\s($IPRe)[ \]].* to: \S+/i) {
                next if $ip =~ /$IPprivate/o;                         # ignore private IP ranges
                next if &main::matchIP($ip,'acceptAllMail',0,1);
                $ip = &main::ipNetwork($ip, 1);
                if (! $main::noGripListUpload && /$main::HamTagRE/io) {

                    #Good IP
                    $GpCnt{ $ip } += 1;
                    $GpOK{ $ip }  += 1;
                } elsif (! $main::noGripListUpload && /$main::SpamTagRE|\[PenaltyDelay\]/o)
                {
                    next if /\[PersonalBlack\]/io;
                    #Bad IP
                    $GpCnt{ $ip } += 1;
                }
            }
            next if $main::DoNotCollectBounces;
            my $to;
            if (/^(?:$last2days) .+?\[isbounce\].+?bounce message detected/i) {
                $nbounces++;
                next;
            }
            ($to) = $1 if (/^(?:$last2days) .*?\[isbounce\].*?\sto:\s(\S+)\s/i);
            ($to) = $1 if (! $to && /^(?:$last2days) .*?\sto:\s(\S+)\s\[spam found\].*?failed for bounce sender/i );
            $to =~ s/\>+$//o;
            $to =~ s/^\<+//o;
            next unless $to;
            $bbounces++;
            $bounces{lc $to}++;
        }
        eval{close $FLogFile;};
    }
    $nbounces = &main::max($nbounces,$bbounces);
    if (! $main::DoNotCollectBounces && $nbounces) {
        my $pd = $main::EnableDelaying ? ' (possibly delayed)' : '';
        &rb_printlog("\nbounce report for the last two days: $nbounces bounces received$pd - $bbounces bounces blocked\n");
        &rb_printlog("\nlist of the top ten local addresses with blocked bounces in the last two days:\n\n") if $bbounces;
        my $i = 0;
        foreach my $adr ( sort { $bounces{$b} <=> $bounces{$a} } keys %bounces) {
            &rb_printlog("$adr : $bounces{$adr}\n",'',1);
            last if ++$i > 10;
        }
        &rb_printlog("\nend of bounce report\n\n");
    } elsif (! $main::DoNotCollectBounces) {
        &rb_printlog("\nbounce report for the last two days: no bounces received\n\n");
    } else {
        &rb_printlog("\nskipping bounce report because 'DoNotCollectBounces' is switched ON\n\n");
    }
    return if $main::noGripListUpload;

    if ( !%GpCnt ) {
        &rb_printlog("Skipping GrIPlist upload. Not enough messages processed.\n");
        &rb_mlog("Skipping GrIPlist upload. Not enough messages processed.");
        return;
    }
    my ($n6, $n4) = (0,0);
    while (my ($k,$v) = each %GpCnt) {
        next if (!$v);
        if (/:/o) {
            $n6++;
        }
        else {
            $n4++;
        }
    }
    $st = pack("N2", $n6 / 2**32, $n6);
    $st .= pack("N", $n4);
    my ($st6,$st4);
    while (my ($k,$v) = each %GpCnt) {
        next if (!$v);
        if ($k !~ /:/o) {
            my $ip = $k;
            $ip =~ s/([0-9a-f]*):/0000$1:/gio;
            $ip =~ s/0*([0-9a-f]{4}):/$1:/gio;
            $st6 .= pack("H4H4H4H4", split(/:/o, $ip));
            $st6 .= pack("C", (1 - $GpOK{$k} / $v) * 255);
        } else {
            $st4 .= pack("C3C", split(/\./o, $k), (1 - $GpOK{$k} / $v) * 255);
        }
    }
    $st .= $st6 . $st4;

    &main::downloadGripConf();  # reload the griplist.conf
    if ($main::proxyserver) {
        &rb_printlog("Uploading Griplist via Proxy: $main::proxyserver\n");
        &rb_mlog("Uploading Griplist via Proxy: $main::proxyserver");
        my $user = $main::proxyuser ? "$main::proxyuser:$main::proxypass\@": '';
        $peeraddress = $user . $main::proxyserver;
        $hostaddress = $main::proxyserver;
        $connect     = "POST $main::gripListUpUrl HTTP/1.0";
    } else {
        &rb_printlog("Uploading Griplist via Direct Connection\n");
        $peeraddress = $main::gripListUpHost . ':80';
        $hostaddress = $main::gripListUpHost;
        my ($url) = $main::gripListUpUrl =~ /http:\/\/[^\/](\/.+)/oi;
        $connect     = <<"EOF";
POST $url HTTP/1.1
User-Agent: ASSP/$main::MAINVERSION ($^O; Perl/$];)
Host: $main::gripListUpHost
EOF
    }

    if ($main::RebuildTestMode) {
        &rb_printlog("unable to connect to $main::gripListUpHost to upload griplist\n");
        &rb_mlog("unable to connect to $main::gripListUpHost to upload griplist");
        return;
    }

    my $socket = $main::CanUseIOSocketINET6
                ? IO::Socket::INET6->new(Proto=>'tcp',PeerAddr=>$peeraddress,Timeout=>2,&main::getDestSockDom($hostaddress))
                : IO::Socket::INET->new(Proto=>'tcp',PeerAddr=>$peeraddress,Timeout=>2);

    if ( defined $socket ) {
        my $len = length($st);
        $connect .= <<"EOF";
Content-Type: application/x-www-form-urlencoded
Content-Length: $len

$st
EOF
        eval{$socket->blocking(0);};
        &main::NoLoopSyswrite( $socket , $connect, 0);
        sleep(1);
        eval{$socket->sysread($main::SMTPbuf, 4096);};
        $main::SMTPbuf = '';
        eval{$socket->close;};
        $len = &rb_commify($len);
        $n6 = &rb_commify($n6);
        $n4 = &rb_commify($n4);
        &rb_printlog("Submitted $len bytes: $n6 IPv6 addresses, $n4 IPv4 addresses\n");
        &rb_mlog("Submitted $len bytes: $n6 IPv6 addresses, $n4 IPv4 addresses");
    }
    else {
        &rb_printlog("unable to connect to $main::gripListUpHost to upload griplist\n");
        &rb_mlog("unable to connect to $main::gripListUpHost to upload griplist");
    }
    return;
} ## end sub uploadgriplist

sub rb_fixPath {
    my ($path) = @_;
    my $len = length($path);
    if   ( !substr( $path, ( $len - 1 ), 1 ) eq q{/} ) { return $path . q{/}; }
    else                                               { return $path; }
}

sub rb_move2num {
    &rb_movefiles('spamlog',$main::maillogExt);
    &rb_movefiles('notspamlog',$main::maillogExt);
    &rb_movefiles('correctednotspam',$main::maillogExt);
    &rb_movefiles('correctedspam',$main::maillogExt);
}

sub rb_movefiles {
    my ($foldername,$ext) = @_;
    my $folder = $main::base.'/'.${'main::'.$foldername};
    my $c=1;
    &rb_printlog("'move to num' started for $foldername\n");
    &rb_mlog("'move to num' started for $foldername");
    for my $fn ($main::unicodeDH->($folder)) {
        $fn = $folder.'/'.$fn;
        die "warning: got stop request from MainThread" unless $main::ComWorker{$Iam}->{run};
        next if $main::dF->( $fn );
        next if $fn=~/\/(\d+)$ext$/i && $1 < $main::MaxFiles;
        $c++;
        my $fn0=$fn;
        while ($c < $main::MaxFiles && [$main::stat->( "$folder/$c$main::maillogExt")]->[7]) {$c++}
        my $d=$c<$main::MaxFiles? $c: int(rand()*$main::MaxFiles);
        $fn=~s#/[^/]*$#/$d$ext#;
        $main::unlink->("$fn");
        $main::rename->("$fn0","$fn");
    }
    &rb_printlog("'move to num' processed $c files in $foldername\n");
    &rb_mlog("'move to num' processed $c files in $foldername");
}

sub rb_cleanTrashlist {
    my $files_before = my $files_deleted = 0;
    my $t = time;
    my $mcount;

    while ( my ( $k, $v ) = each(%Trashlist) ) {
        $files_before++;
        my $f = $k;
        $f =~ s/\.att$//o;
        if ($main::eF->( "$f" )) {
            if (  $t - $v >= $main::MaxKeepDeleted * 3600 * 24 )
            {
                &rb_deletefile ($f,"Trashlist",1);
                delete $Trashlist{$k} unless $main::RebuildTestMode;
                delete $Trashlist{$f} unless $main::RebuildTestMode;
                $files_deleted++;
            }
        } else {
            delete $Trashlist{$k} unless $main::RebuildTestMode;
            delete $Trashlist{$f} unless $main::RebuildTestMode;
            $files_deleted++;
        }
    }
    if ($files_before>0) {
        &rb_printlog("\nTrashlist cleaning finished, $files_deleted of $files_before files deleted\n");
        &rb_mlog("info: Trashlist cleaning finished, $files_deleted of $files_before files deleted");
    }
}

1;

#RBEOT
close $ADV;
$ComWorker{$WorkerNumber}->{rb_version} = $rb_version;
return 1;
}

#__DATA__

no ASSP_DEF_VARS;

sub validateModule {
    my $module = shift;
    $module =~ s/^\s*use\s+//o;
    my $var; my $k;
    ($module, $var) = split(/\s+/o,$module,2);
    ($module, $k) = ($1,$2) if $module =~ /^([^\s()]+)(\(\))?$/o;
    delete $ModuleError{$module};
    $k = '()' if (! $k && ! $var && $module !~ s/\+$//o);
    return 1 if (eval("use $module$k $var;1;"));
    $ModuleError{$module} = $@;
    return 0;
}

sub defineCanUseModules {
    print "\t\t\t\t\t[OK]\nloading modules";
    print '.';

    %ModuleError = ();
    $AvailIOSocketINET6  = ($enableINET6 && $useIOSocketINET6) ? validateModule('IO::Socket::INET6+') : 0; # socket 6 IO module
    $CanUseIOSocketINET6 = $AvailIOSocketINET6 &&
      eval {
          my $sock = IO::Socket::INET6->new(Domain => AF_INET6, Listen => 1, LocalAddr => '[::]', LocalPort => $IPv6TestPort);
          if ($sock) {
              close($sock);
              $SysIOSocketINET6 = 1;
              1;
          } else {
              $AvailIOSocketINET6 = $SysIOSocketINET6 = 0;
              0;
          }
      };
    $CanUseThreadState   = $useThreadState ? validateModule('Thread::State') : 0;    # change thread priority
    $CanUseAvClamd       = $useFileScanClamAV ? validateModule('File::Scan::ClamAV') : 0;    # ClamAV module installed
    $AvailAvClamd        = $CanUseAvClamd;
    $CanUseLDAP          = $useNetLDAP ? validateModule('Net::LDAP') : 0;    # Net LDAP module installed
    print '.';
    $CanUseDNS           = $useNetDNS ? validateModule('Net::DNS') : 0;   # Net DNS module installed - required for SPF & RBL
    $AvailSPF2           = $useMailSPF ? validateModule('Mail::SPF') : 0;  # Mail SPF module installed
    $CanUseSPF2          = $AvailSPF2 && $CanUseDNS;  # SPF and dependancies installed
    print '.';
    $AvailSPF            = $useMailSPFQuery ? validateModule('Mail::SPF::Query') : 0;    # Mail SPF Query module installed
    $CanUseSPF           = $AvailSPF && $CanUseDNS; # SPF Query and dependancies installed
    $CanUseURIBL         = $CanUseDNS;                # URIBL and dependancies installed
    $CanUseRWL           = $CanUseDNS;                # RWL and dependancies installed
    print '.';
    $CanUseRBL           = $CanUseDNS;                # DNSBL and dependancies installed
    $AvailSRS            = $useMailSRS ? validateModule('Mail::SRS') : 0;  # Mail SRS module installed
    $CanUseSRS           = $AvailSRS;
    $AvailZlib           = $useCompressZlib ? validateModule('Compress::Zlib+') : 0;    # Zlib module installed
    $CanUseHTTPCompression  = $AvailZlib;
    $AvailMD5            = $useDigestMD5 ? validateModule('Digest::MD5+') : 0;   # Digest MD5 module installed
    $CanUseMD5Keys       = $AvailMD5;
    $AvailSHA1           = $useDigestSHA1 ? validateModule('Digest::SHA1 qw(sha1_hex)') : 0;   # Digest SHA1 module installed
    $CanUseSHA1          = $AvailSHA1;
    print '.';
    $AvailReadBackwards  = $useFileReadBackwards ? validateModule('File::ReadBackwards') : 0;    # ReadBackwards module installed;
    $CanSearchLogs       = $AvailReadBackwards;
    $AvailHiRes          = validateModule('Time::HiRes'); # Time::HiRes module installed;
    $CanStatCPU          = $AvailHiRes;
    $AvailIO             = $usePerlIOscalar ? validateModule('PerlIO::scalar+') : 0;    # make it chroot savy;
    $CanChroot           = $AvailIO;
    $AvailSyslog         = $useSysSyslog ? validateModule('Sys::Syslog qw( :DEFAULT setlogsock)') : 0;
    $CanUseSyslog        = $AvailSyslog;
    print '.';
    $useWin32APIOutputDebugString = $Config{useWin32APIOutputDebugString} = '' if ($^O ne 'MSWin32');
    $AvailWin32Debug     = $useWin32APIOutputDebugString ? validateModule('Win32::API::OutputDebugString qw(OutputDebugString DStr)') :0; # AZ: 2009-03-10 win32 debug/trace available
    $CanUseWin32Debug    = $AvailWin32Debug; # AZ: 2009-03-10 win32 debug/trace available
    $AvailTieRDBM        = $useTieRDBM ? validateModule('Tie::RDBM') : 0;    # Use external database
    $CanUseTieRDBM       = $AvailTieRDBM;
    $AvailDB_File        = $useDB_File ? validateModule('DB_File') : 0;    # Use external DB_File (Berkeley V1) database
    $CanUseDB_File       = $AvailDB_File;
    $AvailBerkeleyDB     = $useBerkeleyDB ? validateModule('BerkeleyDB') : 0;    # Use external Berkeley database
    $CanUseBerkeleyDB    = $AvailBerkeleyDB;
    print '.';
    $AvailCIDRlite       = $useNetCIDRLite ? validateModule('Net::CIDR::Lite') : 0;    # Net::CIDR::Lite module installed
    $CanUseCIDRlite      = $AvailCIDRlite;
    $AvailNetAddrIPLite  = $useNetAddrIPLite ? validateModule('NetAddr::IP::Lite()') : 0;    # NetAddr::IP::Lite module installed
    $CanUseNetAddrIPLite = $AvailNetAddrIPLite;
    $AvailNetIP          = $useNetIP ? validateModule('Net::IP()') : 0;    # Net::IP module installed
    $CanUseNetIP         = $AvailNetIP;

    $AvailLWP            = $useLWPSimple ? validateModule('LWP::Simple') && validateModule('HTTP::Request::Common') && validateModule('LWP::UserAgent') : 0;    # LWP::Simple module installed
    $CanUseLWP           = $AvailLWP;

    $AvailEMM            = $useEmailMIME ? validateModule('Email::MIME') : 0;  # Email::MIME module installed
    $CanUseEMM           = $AvailEMM;
    validateModule('MIME::Words()') if $CanUseEMM;
    $AvailMTY            = $useMIMETypes ? validateModule('MIME::Types') : 0;   # MIME::Types module installed
    $CanUseMTY           = $AvailMTY && $CanUseEMM;

    ${'Return::Value::NO_CLUCK'} = 1;   # prevent the cluck from Return::Value version 1.666002
    eval('use Return::Value();1;');
    $AvailEMS            = $useEmailSend ? validateModule('Email::Send') : 0;  # Email::Send module installed
    $CanUseEMS           = $AvailEMS;
    print '.';

    $AvailTNEF           = $useConvertTNEF ? validateModule('Convert::TNEF') : 0;  # Convert::TNEF module installed
    $CanUseTNEF          = $AvailTNEF && $CanUseMTY;

    $AvailDKIM           = $useMailDKIMVerifier ? validateModule('Mail::DKIM::Verifier') : 0;  # Mail::DKIM::Verifier module installed
    $CanUseDKIM          = $AvailDKIM;
    if ($CanUseDKIM) {validateModule('Mail::DKIM') ; validateModule('Mail::DKIM::Signer');}

    $AvailNetSMTP        = $useNetSMTP ? validateModule('Net::SMTP') : 0;  # Net::SMTP module installed
    $CanUseNetSMTP       = $AvailNetSMTP;

    $AvailNetSMTPTLS     = $useNetSMTPTLS ? validateModule('Net::SMTP::TLS') : 0;  # Net::SMTP::TLS module installed
    $CanUseNetSMTPTLS    = $AvailNetSMTPTLS;

    $AvailNetSNMPagent   = $useNetSNMPagent ?
    validateModule('NetSNMP::agent()') &&
    validateModule('NetSNMP::ASN()') &&
    validateModule('NetSNMP::default_store qq(:all)') &&
    validateModule('NetSNMP::agent::default_store qq(:all)')
     : 0 ;
    $CanUseNetSNMPagent  = $AvailNetSNMPagent;

    $AvailSchedCron      = $useScheduleCron ? validateModule('Schedule::Cron') : 0;  # Schedule::Cron module installed
    $CanUseSchedCron     = $AvailSchedCron;

    $AvailSysMemInfo     = $useSysMemInfo ? validateModule('Sys::MemInfo') : 0;  # Sys::MemInfo module installed
    $CanUseSysMemInfo    = $AvailSysMemInfo;

    $AvailSysCpuAffinity     = $useSysCpuAffinity ? validateModule('Sys::CpuAffinity') : 0;  # SSys::CpuAffinity module installed
    $CanUseSysCpuAffinity    = $AvailSysCpuAffinity;

    if ($CanUseIOSocketINET6) {
        $AvailIOSocketSSL    = $useIOSocketSSL ? validateModule('IO::Socket::SSL+') : 0;  # IO::Socket::SSL module installed
        $CanUseIOSocketSSL   = $AvailIOSocketSSL;
        validateModule('IO::Socket::INET6') if $CanUseIOSocketSSL;   # reimport the symbols in to namespace
    } else {
        $AvailIOSocketSSL    = $useIOSocketSSL ? validateModule('IO::Socket::SSL \'inet4\'') : 0;  # IO::Socket::SSL module installed
        $CanUseIOSocketSSL   = $AvailIOSocketSSL;
        validateModule('IO::Socket::INET') if $CanUseIOSocketSSL;   # reimport the symbols in to namespace
    }
    print '.';

    $AvailAuthenSASL    = $useAuthenSASL ? validateModule('Authen::SASL') : 0;  # Authen::SASL module installed
    $CanUseAuthenSASL   = $AvailAuthenSASL;

    if ($] ge '5.018000' && $useRegexOptimizer) {
        $useRegexOptimizer = $Config{useRegexOptimizer} = '';
        $useRegexpOptimizer = $Config{useRegexpOptimizer} = 1;
    }
    $AvailRegexOptimizer    = $useRegexOptimizer ? validateModule('Regex::Optimizer') : 0;  # Regex::Optimizer module installed
    if ($CanUseRegexOptimizer = $AvailRegexOptimizer) {$optReModule = 'Regex::Optimizer';};

    $AvailRegexpOptimizer   = $useRegexpOptimizer ? validateModule('Regexp::Optimizer()') : 0;  # Regexp::Optimizer module installed
    if (($CanUseRegexpOptimizer = $AvailRegexpOptimizer) && ! $CanUseRegexOptimizer ) {$optReModule = 'Regexp::Optimizer'; *{'Regexp::Optimizer::set'} = sub {};};

    $AvailASSP_WordStem    = $useASSP_WordStem ? validateModule('ASSP_WordStem()') : 0;  # ASSP_WordStem  module installed
    $CanUseASSP_WordStem   = $AvailASSP_WordStem;

    $AvailASSP_FC    = $useASSP_FC ? validateModule('ASSP_FC()') : 0;  # ASSP_FC  module installed
    $CanUseASSP_FC   = $AvailASSP_FC;

    $AvailASSP_SVG    = $useASSP_SVG ? validateModule('ASSP_SVG()') : 0;  # ASSP_SVG  module installed
    $CanUseASSP_SVG   = $AvailASSP_SVG;

    $AvailAsspSelfLoader   = $useAsspSelfLoader ? defined $AsspSelfLoader::VERSION : 0;  # AsspSelfLoader  module installed
    $CanUseAsspSelfLoader  = $AvailAsspSelfLoader;

    $AvailUnicodeGCString = $useUnicodeGCString ?  validateModule('Unicode::GCString()') : 0;  # Unicode::GCString  module installed
    $CanUseUnicodeGCString = $AvailUnicodeGCString;

    $AvailTextUnidecode = $useTextUnidecode ?  validateModule('Text::Unidecode()') : 0;  # Text::Unidecode  module installed
    $CanUseTextUnidecode = $AvailTextUnidecode;

    $CanUseWin32Unicode = $AvailWin32Unicode = ($useWin32Unicode && $] ge '5.012000') ? eval('
       if (   $^O eq \'MSWin32\'
           && defined ${chr(ord("\026") << 2)}
           && require Win32::Unicode
          )
       {
          $utf8 = sub {eval(\'Encode::_utf8_on($_[0]);\');};
          $unicodeFH = sub { $_[0] = Win32::Unicode::File->new; };
          $unicodeDH = sub { my $d = Win32::Unicode::Dir->new;my $c=shift;return unless $c;$utf8->($c);$d->open($c);my @l = $d->readdir;$d->close;return @l;};
          $open = sub {my @c=@_;return unless @c==3;$utf8->($c[2]);$unicodeFH->($_[0]);$_[0]->open($_[1],$c[2]);};
          $move = sub { my @c=@_;return unless @c==2;for(@c){$utf8->($_);};Win32::Unicode::File::moveW(@c); };
          $copy = sub { my @c=@_;return unless @c==2;for(@c){$utf8->($_);};Win32::Unicode::File::copyW(@c); };
          $unlink = sub { my $c=shift;return unless $c;$utf8->($c);Win32::Unicode::File::unlinkW($c); };
          $rename = sub { my @c=@_;return unless @c==2;for(@c){$utf8->($_);};Win32::Unicode::File::renameW(@c); };
          $eF = sub { my $c=shift;return unless $c;$utf8->($c);eval{Win32::Unicode::File::file_type(e => $c);}; };
          $dF = sub { my $c=shift;return unless $c;$utf8->($c);eval{Win32::Unicode::File::file_type(d => $c);}; };
          $stat = sub { my $c=shift;return unless $c;return unless $eF->($c);$utf8->($c);my @st; eval{@st = Win32::Unicode::File::statW($c);}; if ($@) {eval{@st = stat($c);};} return @st;};
          $mkdir = sub { my $c=shift; my $p=shift; return unless ($c && $p); return if $eF->($c); return if $dF->($c); $utf8->($c); Win32::Unicode::Dir::mkdirW($c)};
          $rmdir = sub { my $c=shift; return unless $c; return if ! $dF->($c); $utf8->($c); Win32::Unicode::Dir::rmdirW($c)};
          $rmtree = sub { my $c=shift; my @p=@_; return unless $c; return if ! $dF->($c); $utf8->($c); Win32::Unicode::Dir::rmtreeW($c,@p)};

          $unicodeName = sub {my $c=shift;return unless $c;$utf8->($c); eval(\'Win32::Unicode::File::CYGWIN\') ? Encode::encode_utf8($c) : Win32::Unicode::File::utf8_to_utf16(Win32::Unicode::File::catfile($c)) . Win32::Unicode::File::NULL;};
#          $unicodeName = sub {my $c=shift;return unless $c;$utf8->($c); Win32::Unicode::File::utf8_to_utf16(Win32::Unicode::File::catfile($c)) . Win32::Unicode::File::NULL;};
#          $unicodeName = sub {my $c=shift;return unless $c;$utf8->($c);Win32::Unicode::File::utf8_to_utf16(Win32::Unicode::File::catfile($c));};
          1;
       } else {
          0;
       }
    ') : 0;
    disableUnicode() unless $CanUseWin32Unicode;
    $canUnicode = $CanUseWin32Unicode || ($^O ne 'MSwin32' && $] ge '5.012000');
    print $canUnicode ? 'U' : 'u?';
    eval{${^WIDE_SYSTEM_CALLS} = 1;} if $canUnicode;

    if (open(my $F, '>', "$base/moduleLoadErrors.txt")) {
        binmode $F;
        my $error;
        while (my($k,$v) = each %ModuleError) {
            print $F "module $k could not be loaded (see error below): check with >perl -e \"use $k;\"\n$v\n\n\n";
            $error = $error ? 'errors are' : 'error was';
        }
        if ($error) {
            print "\t\t\t\t[failed] - $error written to file $base/moduleLoadErrors.txt\n";
        } else {
            print $F "There were no module load errors detected.\n";
            print "\t\t\t\t[OK]\n";
        }
        close $F;
    }

    if ($CanUseTieRDBM){
      print "loading database drivers\t";
      @DBdriverNames = DBI->available_drivers;
      $DBdrivers = join('|',@DBdriverNames);
    } else {
      @DBdriverNames = ();
    }
    $DBdrivers = 'BerkeleyDB|'.$DBdrivers if $CanUseBerkeleyDB;
    $DBdrivers = "no database drivers (DBD-\<driver\> are available on your system" unless $DBdrivers;
    $DBdrivers =~ s/\|$//o;
}

sub getChangedConfigValue {
    d('getChangedConfigValue');
    my @configs;
    {
        lock @changedConfig;
        threads->yield;
        @configs = @changedConfig;
        @changedConfig = ();
        threads->yield;
    }
    while (@configs) {
        my $line = shift @configs;
        $line =~ s/^\s+//o;
        $line =~ s/[\s\r\n]+$//o;
        my ($config,$value) = split(/\s*:=\s*/o,$line,2);
        if (exists $Config{$config}) {
            $ConfigChanged = changeConfigValue($config, $value) | $ConfigChanged;
        } elsif ($config =~ /^\&/o) {
            $line = $config.$value;
            my ($sub,$parm) = parseEval($line);
            if ($sub) {
                eval{$sub->($parm);};
                mlog(0,"error: running '$line' caused exception - $@") if ($@);
            } else {
                mlog(0,"error: unable to parse $line");
            }
        } else {
            my $old = $$config;
            $$config = $value;
            mlog(0,"info: internal variable '$config' changed from '$old' to '$value'");
        }
    }
}

sub changeConfigValue {
    my ($config, $value) = @_;
    d("changeConfigValue - $config");
    if (! $config || ! exists $Config{$config}) {
        mlog(0,"error: scheduled configuration change request for $config - $config is not a valid configuration parameter name");
        return;
    }
    my $ret;
    mlog(0,"info: scheduled configuration change request for $config");
    $qs{$config} = $value;
    $ActWebSess = 'Config_Schedule'.Time::HiRes::time();
    $WebIP{$ActWebSess}->{user} = 'root';
    my $error = checkUpdate($ConfigArray[$ConfigNum{$config}]->[0],$ConfigArray[$ConfigNum{$config}]->[5],$ConfigArray[$ConfigNum{$config}]->[6],$ConfigArray[$ConfigNum{$config}]->[1]);
    if ($error =~ /span class.+?negative/o) {
        $error =~ s/<b>(.+?)<\/b>/$1/o;
        mlog(0,"info: scheduled configuration change request failed for - $config - $error");
    } elsif ($error =~ /span class.+?positive/o) {
        my $text = (exists $cryptConfigVars{$config}) ? '' : " to ". $qs{$config};
        mlog(0,"info: changed config for - $config$text");
        $ret = 1;
    } else {
        mlog(0,"info: config unchanged - $config - ". $qs{$config});
    }
    delete $qs{$config};
    return $ret;
}

sub niceConfigPos {
 my $counterT = -1;
 my $num = 0;
 my $head;
 for my $idx (0...$#ConfigArray) {
   my $c = $ConfigArray[$idx];
   if(@{$c} == 5) {
      $counterT++;
      $num++;
      $head = $c->[4];
      $head =~ s/<a\s+href.*<\/a>//io;
   } else {
      $ConfigPos{$c->[0]} = $counterT;
      $ConfigNum{$c->[0]} = $num++;
      $glosarIndex{$c->[0]} = $head;
   }
 }
}

sub niceConfig {
 %ConfigNice = ();
 %ConfigDefault = ();
 %ConfigListBox = ();
 for my $idx (0...$#ConfigArray) {
      my $c = $ConfigArray[$idx];
      my $value;
      next if(@{$c} == 5) ;
      $ConfigNice{$c->[0]} =  ($c->[10] && $WebIP{$ActWebSess}->{lng}->{$c->[10]})
                              ? encodeHTMLEntities($WebIP{$ActWebSess}->{lng}->{$c->[10]})
                              : encodeHTMLEntities($c->[1]);
      $ConfigNice{$c->[0]} =~ s/<a\s+href.*<\/a>//io;
      $ConfigNice{$c->[0]} =~ s/'|"|\n//go;
      $ConfigNice{$c->[0]} =~ s/\\/\\\\/go;
      $ConfigNice{$c->[0]} = '&nbsp;' unless $ConfigNice{$c->[0]};
      $ConfigDefault{$c->[0]} = encodeHTMLEntities($c->[4]);
      $ConfigDefault{$c->[0]} =~ s/'|"|\n//go;
      $ConfigDefault{$c->[0]} =~ s/\\/\\\\/go;

      $value = ($qs{theButton} || $qs{theButtonX}) ? $qs{$c->[0]} : $Config{$c->[0]} ;
      $value = $Config{$c->[0]} if $qs{theButtonRefresh};

      if ($c->[3] == \&listbox) {
          $ConfigDefault{$c->[0]} = 0 unless $ConfigDefault{$c->[0]};
          foreach my $opt ( split( /\|/o, $c->[2] ) ) {
                my ( $v, $d ) = split( /:/o, $opt, 2 );
                $ConfigDefault{$c->[0]} = $d if ( $ConfigDefault{$c->[0]} eq $v );
                $ConfigListBox{$c->[0]} = $d if ( $value eq $v );
                $ConfigListBoxAll{$c->[0]}{$v} = $d;
          }
      } elsif ($c->[3] == \&checkbox) {
                $ConfigDefault{$c->[0]} = $ConfigDefault{$c->[0]} ? 'On' : 'Off';
                $ConfigListBox{$c->[0]} = $value ? 'On' : 'Off';
      } else {
          $ConfigDefault{$c->[0]} = '&nbsp;' unless $ConfigDefault{$c->[0]};
          $ConfigListBox{$c->[0]} = $value;
      }
 }
}

sub niceLink {
    my $c = shift;
    my $i = 0;
    my %v = ();
    while ($c =~ s/(\$[a-zA-Z][a-zA-Z0-9_{}\[\]\-\>]+)/\[\%\%\%\%\%\]/o) {
        my $var = $1;
        $v{$i} = eval($var);
        $v{$i} = $var unless defined $v{$i};
        $i++;
    }
    $i = 0;
    while ($c =~ s/\[\%\%\%\%\%\]/$v{$i}/o) {$i++}
    my $newline;
    foreach my $word (split(/ /o,$c)) {
         my $orgword = $word;
         $word =~ s/[^a-zA-Z0-9_]//go;
         if (exists $Config{$word} && ($rootlogin || ! $AdminUsersRight{"$WebIP{$ActWebSess}->{user}.user.hidDisabled"})) {
              my $alt = $ConfigNice{$word};
              my $value = encodeHTMLEntities($ConfigListBox{$word});
              $value =~ s/'|"|\n//go;
              $value =~ s/\\/\\\\/go;
              $value = '&nbsp;' unless $value;
              $value = 'ENCRYPTED' if exists $cryptConfigVars{$word};
              my $default = exists $cryptConfigVars{$word} && $word ne 'webAdminPassword'? 'ENCRYPTED' : $ConfigDefault{$word};
              my $subst = "<a href=\"./#$word\" style=\"color:#684f00\" onmousedown=\"showDisp('$ConfigPos{$word}');gotoAnchor('$word');return false;\" onmouseover=\"window.status='$alt'; showhint('<table BORDER CELLSPACING=0 CELLPADDING=4 WIDTH=\\'100%\\' bgcolor=lightyellow><tr><td>config var:</td><td>$word</td></tr><tr><td>description:</td><td>$alt</td></tr><tr><td>current value:</td><td>$value</td></tr><tr><td>default value:</td><td>$default</td></tr></table>', this, event, '450px', '1'); return true;\" onmouseout=\"window.status='';return true;\">$word</a>" ;
              $orgword =~ s/$word/$subst/;
         }
         $newline .= " $orgword";
    }
    return $newline;
}

sub setMainLang {

$lngmsghint{'msg500011'} = '# main form buttom hint 1';
$lngmsg{'msg500011'} = 'The CIDR notation is allowed(182.82.10.0/24).';

$lngmsghint{'msg500012'} = '# main form buttom hint 2';
$lngmsg{'msg500012'} = '<br />Text after the range (and before a numbersign) will be accepted as comment which will be shown in a match (for example: 182.82.10.0/24 Yahoo Groups #comment not shown).' ;

$lngmsghint{'msg500013'} = '# main form buttom hint 3';
$lngmsg{'msg500013'} = 'CIDR notation is accepted (182.82.10.0/24).' ;

$lngmsghint{'msg500014'} = '# main form buttom hint 4';
$lngmsg{'msg500014'} = '<br />Text after the range (and before a numbersign) will be accepted as comment to be shown in a match. For example:<br />182.82.10.0/24 Yahoo #comment to be removed<br />The short notation like 182.82.10. is only allowed for IPv4 addresses, IPv6 addresses must be fully defined as for example 2201:1::1 or 2201:1::/96<br />You may define a hostname instead of an IP, in this case the hostname will be replaced by all DNS-resolved IP-addresses, each with a /32 or /128 netmask. For example:<br />mta5.am0.yahoodns.net Yahoo #comment to be removed -&gt; 66.94.238.147/32 Yahoo|... Yahoo|... Yahoo<br />' ;

$lngmsghint{'msg500015'} = '# main form buttom hint 5';
$lngmsg{'msg500015'} = 'If Net::CIDR::Lite is installed, hyphenated ranges can be used (182.82.10.0-182.82.10.255).';

$lngmsghint{'msg500016'} = '# main form buttom hint 6';
$lngmsg{'msg500016'} = 'Hyphenated ranges can be used (182.82.10.0-182.82.10.255).';

$lngmsghint{'msg500017'} = '# main form buttom hint 7';
$lngmsg{'msg500017'} = 'For defining any full filepathes, always use slashes ("/") not backslashes. For example: c:/assp/certs/server-key.pem !<br /><br />';

$lngmsghint{'msg500018'} = '# main form buttom hint 8';
$lngmsg{'msg500018'} = <<EOT;
Fields marked with one small (<sup>s</sup>) - which are interval definitions - accept a single or a list of crontab entries separated by '|'. Such entries could be used to flexible schedule the configured task. An description of such crontab entries could be found in 'RebuildSchedule' and 'RestartSchedule'. Notice - this requires an installed <a href="http://search.cpan.org/search?query=Schedule::Cron" rel="external">Schedule::Cron</a> module in PERL.<br /><br />
Fields marked with at least one asterisk (*) accept a list separated by '|' (for example: abc|def|ghi) or a file designated as follows (path relative to the ASSP directory): 'file:files/filename.txt'.  Putting in the <i>file:</i> will prompt ASSP to put up a button to edit that file. <i>files</i> is the subdirectory for files. The file does not need to exist, you can create it by saving it from the editor within the UI. The file must have one entry per line; anything on a line following a numbersign or a semicolon ( # ;) is ignored (a comment).<br />
It is possible to include custom-designed files at any line of such a file, using the following directive<br />
<span class="positive"># include filename</span><br />
where filename is the relative path (from $base) to the included file like files/inc1.txt or inc1.txt (one file per line). The line will be internaly replaced by the contents of the included file!<br /><br />
Fields marked with two asterisk (**) contains regular expressions (regex) and accept a second weight value. Every weighted regex that contains at least one '|' has to begin and end with a '~' - inside such regexes it is not allowed to use a tilde '~', even it is escaped - for example:  ~abc<span class="negative"><b>\\~</b></span>|def~=>23 or ~abc<span class="negative"><b>~</b></span>|def~=>23 - instead use the octal (\\126) or hex (\\x7E) notation , for example <span class="positive">~abc\\126|def~=>23 or ~abc\\x7E|def~=>23</span> . Every weighted regex has to be followed by '=>' and the weight value. For example: Phishing\\.=>1.45|~Heuristics|Email~=>50  or  ~(Email|HTML|Sanesecurity)\\.(Phishing|Spear|(Spam|Scam)[a-z0-9]?)\\.~=>4.6|Spam=>1.1|~Spear|Scam~=>2.1 . The multiplication result of the weight and the penaltybox valence value will be used for scoring, if the absolute value of weight is less or equal 6. Otherwise the value of weight is used for scoring. It is possible to define negative values to reduce the resulting message score.<br />
For all "<span class="positive">bomb*</span>" regular expressions and "<span class="positive">invalidFormatHeloRe</span>", "<span class="positive">invalidPTRRe</span>" and "<span class="positive">invalidMsgIDRe</span>" it is possible to define a third parameter (to overwrite the default options) after the weight like: Phishing\\.=>1.45|~Heuristics|Email~=>50<span class="positive">:>N[+-]W[+-]L[+-]I[+-]</span>. The characters and the optional to use + and - have the following functions:<br />
use this regex (+ = only)(- = never) for: N = noprocessing , W = whitelisted , L = local , I = ISP mails . So the line ~Heuristics|Email~=>50:>N-W-LI could be read as: take the regex with a weight of 50, never scan noprocessing mails, never scan whitelisted mails, scan local mails and mails from ISP's (and all others). The line ~Heuristics|Email~=>3.2:>N-W+I could be read as: take the regex with a weight of 3.2 as factor, never scan noprocessing mails, scan only whitelisted mails even if they are received from an ISP .<br />
If the third parameter is not set or any of the N,W,L,I is not set, the default configuration for the option will be used unless a default option string is defined anywhere in a single line in the file in the form !!!NWLI!!! (with + or - is possible).<br />
<span class="negative">If any parameter that allowes the usage of weighted regular expressions is set to "block", but the sum of the resulting weighted penalty value is less than the corresponding "Penalty Box Valence Value" (because of lower weights) - only scoring will be done!</span><br />
If the regular expression optimization is used - ("perl module Regexp::Optimizer or ./lib/Regex/Optimizer.pm" installed and enabled) - and you want to disable the optimization for a special regular expression (file based), set one line (eg. the first one) to a value of '<span class="positive">assp-do-not-optimize-regex</span>' or '<span class="positive">a-d-n-o-r</span>' (without the quotes)! To disable the optimization for a specific line/regex, put &lt;&lt;&lt; in front and &gt;&gt;&gt; at the end of the line/regex. To weight such line/regex write for example: <span class="positive">&lt;&lt;&lt;</span>Phishing\\.<span class="positive">&gt;&gt;&gt;</span>=>1.45=>N- or ~<span class="positive">&lt;&lt;&lt;</span>Heuristics|Email<span class="positive">&gt;&gt;&gt;</span>~=>50  or  ~<span class="positive">&lt;&lt;&lt;</span>(Email|HTML|Sanesecurity)\\.(Phishing|Spear|(Spam|Scam)[a-z0-9]?)\\.<span class="positive">&gt;&gt;&gt;</span>~=>4.6 .<br /><br />
The literal 'SESSIONID' will be replaced by the unique message logging ID in every SMTP error reply.<br />
The literal 'MYNAME' will be replaced by the configuration value defined in 'myName' in every SMTP error reply.<br /><br />
If the internal name is shown in light blue like <span style="color:#8181F7">(uniqueIDPrefix)</span> , this indicates that the configured value differs from the defaut value. To show the default value, move the mouse over the internal name. An click on the internal name will reset the value to the default.<br /><br />
IP ranges are defined as for example 182.82.10.
EOT

$lngmsghint{'msg500019'} = '# main form buttom hint 9';
$lngmsg{'msg500019'} = <<EOT;
<br /><br />'kill -HUP $mypid' will load settings from disk. 'kill -NUM07 $mypid' will suspend or resume assp.  'kill -USR2 $mypid' will save settings to disk.
EOT

$lngmsghint{'msg500020'} = '# manage users form hint';
$lngmsg{'msg500020'} = <<EOT;
Use the "Continue" button as long as you only want to see or to temporary change any parameter.
Use the "Apply Changes" button to apply all changes, that are currenty shown, to the user.
All user names that begins with a "~" are templates. The template "~DEFAULT" can't be deleted.
All permissions of a user can refer to a template, in this case the permission of the template
belongs to the user. If the template permission is changed, all user permissions
that refers to that template will also be changed. Template permissions can never refer to an
another user or template. It is possible to copy all permissions of a template or an user to
another user or template. If "use LDAP / LDAP host" is filled with an IP-address or hostname
the local password will only be used, if the LDAPhost is not available. If a LDAP login is
successful, the LDAP-password will be stored as local password. It is possible to configure
multiple LDAP hosts separated by "|". To navigate use the alpha-index on the left site.
EOT

$lngmsghint{'msg500031'} = '# White/Redlist/Tuplets';
$lngmsg{'msg500031'} = <<EOT;
Do you want to work with the:
EOT

$lngmsg{'msg500032'} = <<EOT;
Do you want to:
EOT

$lngmsg{'msg500033'} = <<EOT;
<p>Post less than 1 megabyte of data at a time.</p>
Note: The redlist is not a blacklist. The redlist is a list of addresses that cannot
contribute to the whitelist, and who are not considered local, even if their mail is
from a local computer. For example, if someone goes on a vacation and turns on their
email's autoresponder, put them on the redlist until they return. Then as they reply
to every spam they receive they won't corrupt your non-spam collection or whitelist.<br />
To add or remove global whitelist entries use emailaddress,* .<br />
To add or remove domain whitelist entries use emailaddress,\@domain .<br />
<b>NOTICE: removing global or domain whitelist entries will DELETE ALL related personal records!</b>
EOT

$lngmsg{'msg500034'} = <<EOT;
<p class="warning">Warning: If your whitelist or redlist is long, pushing these buttons
 is ill-advised. Use these for testing and while your whitelist is short.</p>
EOT

$lngmsghint{'msg500040'} = '# Recipient Replacement Test';
$lngmsg{'msg500040'} = '<p><a href="./#ReplaceRecpt">go to ReplaceRecpt to configure rules</a></p>';
$lngmsg{'msg500041'} = '<p><span class="negative"><a href="./#ReplaceRecpt">ReplaceRecpt</a> is not configured - please do this first!</span></p>';
$lngmsg{'msg500042'} = '<p>to modify the replacement rules, open the file by clicking edit ';

$lngmsg{'msg500043'} = '<p>the following replacement rules were processed</p><br />';

$lngmsghint{'msg500050'} = '# View Maillog Tail';
$lngmsg{'msg500050'} = <<EOT;
Refresh your browser or click [Search/Update] to update this screen. Newest entries are at the end. The search will stop, if the [search for] field is blank - and [tail bytes] is reached, or if the [search for] field is not blank - and [search in] or the number of [results] is reached. If you search for more than one word, all words must match. Words with a leading \\'-\\' will be negated. For example: a search pattern \\'user -root\\', will search all lines which contains the word \\'user\\' but not the word \\'root\\'!
EOT

$lngmsg{'msg500051'} = <<EOT;
Select [file lines only], if you want to reduce the shown number of lines to such (POST filter), which contains filenames.<br /><br /> Use the MaillogTail function carefully, while ASSP is processing any request, no new connections will be accepted by ASSP, and this could take some minutes, if you search in large or many maillogs! To start realtime maillog, click on [Auto], to stop realtime maillog, click on [Stop].
EOT

$lngmsg{'msg500052'} = <<EOT;
If [this file number(s)] is selected, you can define a single filenumber or a comma separated list of filenumbers here - like: <b>1,5,8,7,6 or 10,2...7,11,14-19,21,23...26</b>  A defined range 2...7 or 2-7 will include all numbers from 2 to 7. The resulting numbers will be internaly sorted ascending and the files will be used in that sorted order.
EOT

$lngmsg{'msg500053'} = <<EOT;
Enter the search string - for more help use the [help] link. If you want to start the realtime log [Auto], you can define the number of lines to show in the browser [1 - 33] here.
EOT

$lngmsghint{'msg500060'} = '# Mail Analyzer';
$lngmsg{'msg500060'} = <<EOT;
This page will show you how ASSP analyzes and pre-processes an email to come up with the assigned spam probability. Regular Expressions will always check the full message. Group matching of any address will be shown. To analyze/modify individual email addresses click <a href="javascript:void(0);" onclick="popAddressAction('example\@$myName');return false;">here</a>. To analyze/modify individual IP addresses click <a href="javascript:void(0);" onclick="popIPAction('1.1.1.1');return false;">here</a>.
EOT

$lngmsg{'msg500061'} = <<EOT;
Copy and paste the mail header and body here:
EOT

$lngmsg{'msg500062'} = <<EOT;
<b>You may put here helo=aaa.bbb.helo or ip=123.123.123.123 to look up the helo/ip information. text=abc will start a lookup in the regular expression files for the "abc" matching regex.<br />
Put helo=domain.com and ip=123.123.123.123 in two lines, to lookup SPF results.</b>
<p>Note: Analysis is performed using the current spam database --
if yours was rebuilt since the time the mail was received you'll
receive a different result.</p>
EOT

$lngmsg{'msg500063'} = <<EOT;
<p>To use this form using <i>Outlook Express</i> do the following. Right-click on the message
of interest. Select <i>Properties</i>. Click the <i>Details</i> tab. Click the <i>message
source</i> button. Right-click on the message source and click <i>Select All</i>. Right-click
again and click <i>Copy</i>. Click on the text box above and paste (Ctrl-V perhaps). Click
the <i>Analyze</i> button.</p>
<p>The page will update to show you the following: if any of the email's addresses are in
the redlist or whitelist, the most and least spammy phrases together with their spaminess,
the resulting probabilities (probabilities may repeat one time), and the final spam probability
score.<br /><br />
To only transliterate the text (even MIME encoded) from non-Roman letters to Roman letters, simply select the checkbox.
EOT

$lngmsghint{'msg500070'} = '# Shutdown/Restart';
$lngmsg{'msg500070'} = <<EOT;
Note: It's possible to restart, if ASSP runs as a service or in a script that restarts it after it stops or it runs on WIN32 version Windows 2000(or higher) or it runs on linux,
otherwise this function can only shut ASSP down. In either case, shutdown is possibly not clean -- all SMTP sessions will be interrupted after $MaxFinConWaitTime seconds.<br /><br />
The following command will be started in OS-shell, if ASSP runs not as a service or daemon:<br /><b><font color=green>$AutoRestartCmd</font></b>
EOT

$lngmsghint{'msg500080'} = '# EDIT files window/frame';
$lngmsg{'msg500080'} = <<EOT;
<span class="negative">Attention: This is the real database content!<br />
Incorrect editing hash lists could result in unexpected behavior or dieing ASSP!</span><br />
Use |::| as terminator between key and value, for example: 102.1.1.1|::|1234567890 !<br />
If a time is shown human readable, you can change the date or time,<br />
but leave the format as it is ([+]YYYY-MM-DD,hh:mm:ss) and leave a possible \'+\' in front.<br />
Use only one pair of key and value per line.<br />
Comments are not allowed!<br />
While the hash is saved, ASSP is unable to accept new connections!<br />
Be carefull saveing large hash here, this could take very long time. Better save the new contents of large hashes and lists to the Importfile, if this option is available. If possible, the DB-Import will be started immediately by the MaintThread!<br />
After saving the contents to the Importfile, you should close this windows and wait until the import has finished!
EOT

$lngmsg{'msg500081'} = 'File should have one entry per line; anything on a line following a numbersign ( #) is ignored (a comment). Whitespace at the beginning or end of the line is ignored.';
$lngmsg{'msg500082'} = 'First line specifies text that appears in the subject of report message. The remaining lines are the report message body.';
$lngmsg{'msg500083'} = 'Put here comments to your assp installation.';
$lngmsg{'msg500084'} = 'For removal of entries from BlackBox use <a onmousedown="showDisp(\'$ConfigPos{noPB}\')" target="main" href="./#noPB">noPB</a>.
For removal of entries from WhiteBox  use <a onmousedown="showDisp(\'$ConfigPos{noPBwhite}\')" target="main" href="./#noPBwhite">noPBwhite</a>. For  whitelisting IP\'s use <a onmousedown="showDisp(\'$ConfigPos{whiteListedIPs}\')" target="main" href="./#whiteListedIPs">Whitelisted IP\'s</a> or <a onmousedown="showDisp(\'$ConfigPos{noProcessingIPs}\')" target="main" href="./#noProcessingIPs">No Processing IP\'s</a>. For blacklisting use <a onmousedown="showDisp(\'$ConfigPos{denySMTPConnectionsFrom}\')" target="main" href="./#denySMTPConnectionsFrom">Deny SMTP Connections From these IP\'s</a> and <a onmousedown="showDisp(\'$ConfigPos{denySMTPConnectionsFromAlways}\')" target="main" href="./#denySMTPConnectionsFromAlways">Deny SMTP Connections From these IP\'s Strictly</a>.';

$lngmsg{'msg500086'} = 'CacheEntry: IP/Domain \'11\' CacheIntervalStart 1=fail/2=pass Result/Comment';

$lngmsg{'msg500090'} = 'To take an action, select the action and click "Do It!". To move a file to an other location, just copy and delete the file!';
$lngmsg{'msg500091'} = '<br /> For "resend file" action install Email::Send  modules!';

$lngmsg{'msg500092'} = 'IP ranges can be defined as: 182.82.10. ';

$lngmsghint{'msg500093'} = '# the following messages are in one line 0093.$records.0094';
$lngmsg{'msg500093'} = 'This hash/list seems to be too large (';
$lngmsg{'msg500094'} = 'records) to save it from GUI!';

$lngmsg{'msg500095'} = 'Please close this window, and wait until import has finished.';
$lngmsg{'msg500096'} = "This file was trunked to (MaxBytes) $MaxBytes byte. If you resend this file, the resulting view and/or attachments would be destroyed!";

$lngmsghint{'msg500100'} = '# SMTP-Connection - link - hintbox';
$lngmsg{'msg500100'} = 'Click here to open a SMTP-Connections-Window that never stops refreshing. Do not make any changes in the main window, while this SMTP-Connections-Window is still opened! A SMTP-Connections-Window which is started with the default (left beside) link, will stop refreshing if it is not in forground.';

}

sub renderConfigHTML {
  setMainLang();
  my $maillogEnd;
  if ($MaillogTailJump) {
    $maillogEnd = '#MlEnd';
  } else {
    $maillogEnd = '#MlTop';
  }
  $maillogJump = '<a href="javascript:void(0);" onclick="MlEndPos=document.getElementById(\'LogLines\').scrollTop; document.getElementById(\'LogLines\').scrollTop=0; return false;">Go to Top</a><a name="MlEnd"></a>';
  my $IndexPos = $hideAlphaIndex ? '451' : '440';
  my $IndexStart = $hideAlphaIndex ? '452' : '442';
  my $JavaScript;

  my $ConnHint = $WebIP{$ActWebSess}->{lng}->{'msg500100'} || $lngmsg{'msg500100'};

  $plusIcon = 'get?file=images/plusIcon.png';
  $minusIcon = 'get?file=images/minusIcon.png';
  $noIcon = 'get?file=images/noIcon.png';
  $wikiinfo = 'get?file=images/info.png';
 $NavMenu = '
 <hr />
 <div class="menuLevel2">
  <a href="lists"><img src="' . $noIcon . '" alt="noicon" /> White/Redlist/Tuplets</a><br />
  <a href="javascript:void(0);" onclick="popAddressAction();"><img src="' . $noIcon . '" alt="noicon" /> work with addresses</a><br />
  <a href="javascript:void(0);" onclick="popIPAction();"><img src="' . $noIcon . '" alt="noicon" /> work with IP\'s</a><br />
  <a href="recprepl"><img src="' . $noIcon . '" alt="noicon" /> Recipient Replacement Test</a><br />
  <a href="maillog' . $maillogEnd . '"><img src="' . $noIcon . '" alt="noicon" target="_blank" /> View Maillog Tail</a><br />
  <a href="analyze"><img src="' . $noIcon . '" alt="noicon" /> Mail Analyzer</a><br />
  <a href="infostats"><img src="' . $noIcon . '" alt="noicon" /> Info and Stats </a><br />
  ';
  $NavMenu .= '
  <a href="top10stats" target="_blank"><img src="' . $noIcon . '" alt="noicon" /> Top 10 Stats</a><br />' if $DoT10Stat;
  $NavMenu .= '
  <a href="statusassp?nocache='.time.'" target="_blank"><img src="' . $noIcon . '" alt="noicon" /> Worker/DB/Regex Status</a><br />
  <a href="shutdown_list?nocache='.time.'" target="_blank"><img src="' . $noIcon . '" alt="this monitor will slow down ASSP dramaticly - use it careful" /> SMTP Connections </a>
  <a href="shutdown_list?nocache='.time.'&forceRefresh=1" target="_blank" onmouseover="showhint(\''.$ConnHint.'\', this, event, \'500px\', \'1\');return false;"><img height=12 width=12 src="' . $wikiinfo . '" /></a><br />
  <a href="shutdown"><img src="' . $noIcon . '" alt="noicon" /> Shutdown/Restart</a><br />
  <a href="donations"><img src="' . $noIcon . '" alt="noicon" /> Donations</a><br /></div>';
 $JavaScript = "
<script type=\"text/javascript\">
<!--
var oldBrowser = false;
/*\@cc_on
   /*\@if (\@_jscript_version < 5.6)
      oldBrowser = true;
   /*\@end
\@*/

if (window.navigator.appName == \"Microsoft Internet Explorer\")
{
   var engine;
   if (document.documentMode) // IE8
      engine = document.documentMode;
   else // IE 5-7
   {
      engine = 5; // Assume quirks mode unless proven otherwise
      if (document.compatMode)
      {
         if (document.compatMode == \"CSS1Compat\")
            engine = 7; //standard mode
      }
   }
   if (engine < 8) {oldBrowser = true;}
}
var BrowserDetect = {
	init: function () {
		this.browser = this.searchString(this.dataBrowser) || \"An unknown browser\";
		this.version = this.searchVersion(navigator.userAgent)
			|| this.searchVersion(navigator.appVersion)
			|| \"an unknown version\";
		this.OS = this.searchString(this.dataOS) || \"an unknown OS\";
	},
	searchString: function (data) {
		for (var i=0;i<data.length;i++)	{
			var dataString = data[i].string;
			var dataProp = data[i].prop;
			this.versionSearchString = data[i].versionSearch || data[i].identity;
			if (dataString) {
				if (dataString.indexOf(data[i].subString) != -1)
					return data[i].identity;
			}
			else if (dataProp)
				return data[i].identity;
		}
	},
	searchVersion: function (dataString) {
		var index = dataString.indexOf(this.versionSearchString);
		if (index == -1) return;
		return parseFloat(dataString.substring(index+this.versionSearchString.length+1));
	},
	dataBrowser: [
		{
			string: navigator.userAgent,
			subString: \"Chrome\",
			identity: \"Chrome\"
		},
		{ 	string: navigator.userAgent,
			subString: \"OmniWeb\",
			versionSearch: \"OmniWeb/\",
			identity: \"OmniWeb\"
		},
		{
			string: navigator.vendor,
			subString: \"Apple\",
			identity: \"Safari\",
			versionSearch: \"Version\"
		},
		{
			prop: window.opera,
			identity: \"Opera\"
		},
		{
			string: navigator.vendor,
			subString: \"iCab\",
			identity: \"iCab\"
		},
		{
			string: navigator.vendor,
			subString: \"KDE\",
			identity: \"Konqueror\"
		},
		{
			string: navigator.userAgent,
			subString: \"Firefox\",
			identity: \"Firefox\"
		},
		{
			string: navigator.vendor,
			subString: \"Camino\",
			identity: \"Camino\"
		},
		{		// for newer Netscapes (6+)
			string: navigator.userAgent,
			subString: \"Netscape\",
			identity: \"Netscape\"
		},
		{
			string: navigator.userAgent,
			subString: \"MSIE\",
			identity: \"Explorer\",
			versionSearch: \"MSIE\"
		},
		{
			string: navigator.userAgent,
			subString: \"Gecko\",
			identity: \"Mozilla\",
			versionSearch: \"rv\"
		},
		{ 		// for older Netscapes (4-)
			string: navigator.userAgent,
			subString: \"Mozilla\",
			identity: \"Netscape\",
			versionSearch: \"Mozilla\"
		}
	],
	dataOS : [
		{
			string: navigator.platform,
			subString: \"Win\",
			identity: \"Windows\"
		},
		{
			string: navigator.platform,
			subString: \"Mac\",
			identity: \"Mac\"
		},
		{
			   string: navigator.userAgent,
			   subString: \"iPhone\",
			   identity: \"iPhone/iPod\"
	    },
		{
			string: navigator.platform,
			subString: \"Linux\",
			identity: \"Linux\"
		}
	]

};
BrowserDetect.init();

var detectedBrowser = 'ASSP-GUI is running in ' + BrowserDetect.browser + ' version ' + BrowserDetect.version + ' on ' + BrowserDetect.OS;
if (oldBrowser) {
    detectedBrowser = detectedBrowser + ' (old javascript engine and/or browser detected)';
}
// -->
</script>

<script type=\"text/javascript\">
<!--

var configPos = new Array();
";
 for my $idx (0...$#ConfigArray) {
   my $c = $ConfigArray[$idx];
   next if(@{$c} == 5);
   $JavaScript .= "configPos['$c->[0]']='$ConfigPos{$c->[0]}';";
 }

$JavaScript .= "
function quotemeta (qstr) {
    return qstr.replace( /([^A-Za-z0-9])/g , \"\\\\\$1\" );
}

function toggleDisp(nodeid)
{
  if (nodeid == null) return false;
  if(nodeid.substr(0,9) == 'setupItem')
    nodeid = nodeid.substr(9);
  layer = document.getElementById('treeElement' + nodeid);
  img = document.getElementById('treeIcon' + nodeid);
  if(layer.style.display == 'none')
  {
    layer.style.display = 'block';
    img.src = '$minusIcon';
    if(document.getElementById('setupItem' + nodeid))
      document.getElementById('setupItem' + nodeid).style.display = 'block';
  }
  else
  {
    layer.style.display = 'none';
    img.src = '$plusIcon';
    if(document.getElementById('setupItem' + nodeid))
      document.getElementById('setupItem' + nodeid).style.display = 'none';
  }
}
function showDisp(nodeid)
{
  if (nodeid == null) return false;
  if(nodeid.substr(0,9) == 'setupItem')
    nodeid = nodeid.substr(9);
  layer = document.getElementById('treeElement' + nodeid);
  img = document.getElementById('treeIcon' + nodeid);
  if(layer.style.display == 'none')
  {
    layer.style.display = 'block';
    img.src = '$minusIcon';
    if(document.getElementById('setupItem' + nodeid))
      document.getElementById('setupItem' + nodeid).style.display = 'block';
  }
}
function gotoAnchor(aname)
{
//    window.location.href = \"#\" + aname;       //
    var currloc = window.location.href.split('#')[0];
    window.location = currloc + \"#\" + aname;
    var re = new RegExp('/adminusers',\"i\");
    if (! re.test(currloc)) setAnchor(aname);
}
function expand(expand, force)
{
  counter = 0;
  while(document.getElementById('treeElement' + counter))
  {
    if(!expand)
    {
      //dont shrink if this element is the one passed in the URL
      arr = document.getElementById('treeElement' + counter).getElementsByTagName('a');
      txt = ''; found = 0;
      loc = new String(document.location);
      for(i=0; i < arr.length; i++)
      {
        txt = txt + arr.item(i).href;
        tmpHref = new String(arr.item(i).href);
        if(tmpHref.substr(tmpHref.indexOf('#')) == loc.substr(loc.indexOf('#')))
        {
          //give this tree node the right icon
          document.getElementById('treeIcon' + counter).src = '$minusIcon';
          found = 1;
        }
      }
      if(!found | force)
      {
        document.getElementById('treeIcon' + counter).src = '$plusIcon';
        document.getElementById('treeElement' + counter).style.display = 'none';
        if(document.getElementById('setupItem' + counter))
          document.getElementById('setupItem' + counter).style.display = 'none';
      }
    }
    else
    {
      document.getElementById('treeElement' + counter).style.display = 'block';
      document.getElementById('treeIcon' + counter).src = '$minusIcon';
      if(document.getElementById('setupItem' + counter))
        document.getElementById('setupItem' + counter).style.display = 'block';
    }
    counter++;
  }
}

//make the 'rel's work
function externalLinks()
{
  if (!document.getElementsByTagName)
    return;
  var anchors = document.getElementsByTagName(\"a\");
  for (var i=0; i<anchors.length; i++)
  {
    var anchor = anchors[i];
    if (anchor.getAttribute(\"href\")
      && anchor.getAttribute(\"rel\") == \"external\")
      anchor.target = \"_blank\";
  }
}

// handle cookies to remember something
function createCookie(name,value,days) {
    if (! navigator.cookieEnabled) {return null;}
	if (days) {
		var date = new Date();
		date.setTime(date.getTime()+(days*24*60*60*1000));
		var expires = \"; expires=\"+date.toGMTString();
	}
	else var expires = \"\";
	document.cookie = name+\"=\"+value+expires+\"; path=/\";
}

function readCookie(name) {
    if (! navigator.cookieEnabled) {return null;}
	var nameEQ = name + \"=\";
	var ca = document.cookie.split(';');
	for(var i=0;i < ca.length;i++) {
		var c = ca[i];
		while (c.charAt(0)==' ') c = c.substring(1,c.length);
		if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);
	}
	return null;
}

function eraseCookie(name) {
    if (! navigator.cookieEnabled) {return null;}
	createCookie(name,\"\",-1);
}

function setAnchor(iname)
{
    if (navigator.cookieEnabled) {createCookie('lastAnchor',iname,1);}
}

function initAnchor(doIt)
{
    if (doIt != '1') {return null;}
    if (! navigator.cookieEnabled) {return null;}
    var iname = readCookie('lastAnchor');
    if (! iname || iname == '' || iname == 'delete') {return false;}
    if (window.location.pathname == '/' || window.location.pathname == '') {
        showDisp(configPos[iname]);
        gotoAnchor(iname);
    } else {
        return false;
    }
}
";

  $JavaScript .= "
function docHeight()
{
  if (typeof document.height != 'undefined') {
    return document.height;
  } else if (document.compatMode && document.compatMode != 'BackCompat') {
    return document.documentElement.scrollHeight;
  } else if (document.body && typeof document.body.scrollHeight !='undefined') {
    return document.body.scrollHeight;
  }
}
//********************************************************
//* You may use this code for free on any web page provided that
//* these comment lines and the following credit remain in the code.
//* Floating Div from http://www.javascript-fx.com
//********************************************************
// Modified in May 2005 by Przemek Czerkas:
//  - added calls to docHeight()
//  - added bounding params tlx, tly, brx, bry
var ns = (navigator.appName.indexOf(\"Netscape\") != -1);
var d = document;
var px = document.layers ? \"\" : \"px\";
function JSFX_FloatDiv(id, sx, sy, tlx, tly, brx, bry)
{
  var el=d.getElementById?d.getElementById(id):d.all?d.all[id]:d.layers[id];
  window[id + \"_obj\"] = el;
  if(d.layers)el.style=el;
  el.cx = el.sx = sx;
  el.cy = el.sy = sy;
  el.tlx = tlx;
  el.tly = tly;
  el.brx = brx;
  el.bry = bry;
  el.sP=function(x,y){this.style.left=x+px;this.style.top=y+px;};
  el.flt=function()
  {
    var pX, pY;
    pX = ns ? pageXOffset : document.documentElement && document.documentElement.scrollLeft ? document.documentElement.scrollLeft : document.body.scrollLeft;
    pY = ns ? pageYOffset : document.documentElement && document.documentElement.scrollTop ? document.documentElement.scrollTop : document.body.scrollTop;
    if(this.sy<0)
      pY += ns ? innerHeight : document.documentElement && document.documentElement.clientHeight ? document.documentElement.clientHeight : document.body.clientHeight;
    this.cx += (pX + Math.max(this.sx-pX, this.tlx) - this.cx)/4;
    this.cy += (pY + Math.max(this.sy-pY, this.tly) - this.cy)/4;
    this.cx = Math.min(this.cx, this.brx);
    this.cy = Math.min(this.cy, this.bry);
    if (ns) {
      this.sP(
        Math.max(Math.min(this.cx+this.clientWidth,document.width)-this.clientWidth,this.sx),
        Math.max(Math.min(this.cy+this.clientHeight,document.height)-this.clientHeight,this.sy)
      );
    } else {
      var oldh, newh;
      oldh = docHeight();
      this.sP(this.cx, this.cy);
      newh = docHeight();
      if (newh>oldh) {
        this.sP(this.cx, this.cy-(newh-oldh));
      }
    }
    setTimeout(this.id + \"_obj.flt()\", 20);
  }
  return el;
}" if ($EnableFloatingMenu && ! $mobile);

 $JavaScript .= '
function popFileEditor(filename,note)
{
  var height = (note == 0) ? 500 : (note == \'m\') ? 580 : 550;
  newwindow=window.open(
    \'edit?file=\'+filename+\'&note=\'+note,
    \'FileEditor\',
    \'width=720,height=\'+height+\',overflow=scroll,toolbar=yes,menubar=yes,location=no,personalbar=yes,scrollbars=yes,status=no,directories=no,resizable=yes\'
  );
  	// this puts focus on the popup window if we open a new popup without closing the old one.
  	if (window.focus) {newwindow.focus()}
  	return false;
}

function popAddressAction(address)
{
  var height = 500 ;
  var link = address ? \'?address=\'+address : \'\';
  newwindow=window.open(
    \'addraction\'+link,
    \'AddressAction\',
    \'width=720,height=\'+height+\',overflow=scroll,toolbar=yes,menubar=yes,location=no,personalbar=yes,scrollbars=yes,status=no,directories=no,resizable=yes\'
  );
  	// this puts focus on the popup window if we open a new popup without closing the old one.
  	if (window.focus) {newwindow.focus()}
  	return false;
}

function popIPAction(ip)
{
  var height = 500 ;
  var link = ip ? \'?ip=\'+ip : \'\';
  newwindow=window.open(
    \'ipaction\'+link,
    \'IPAction\',
    \'width=720,height=\'+height+\',overflow=scroll,toolbar=yes,menubar=yes,location=no,personalbar=yes,scrollbars=yes,status=no,directories=no,resizable=yes\'
  );
  	// this puts focus on the popup window if we open a new popup without closing the old one.
  	if (window.focus) {newwindow.focus()}
  	return false;
}

function popSyncEditor(cfgParm)
{
  setAnchor(cfgParm);
  var height = 400;
  newwindow=window.open(
    \'syncedit?cfgparm=\'+cfgParm,
    \'SyncEditor\',
    \'width=600,height=\'+height+\',overflow=scroll,toolbar=yes,menubar=yes,location=no,personalbar=yes,scrollbars=yes,status=no,directories=no,resizable=yes\'
  );
  	// this puts focus on the popup window if we open a new popup without closing the old one.
  	if (window.focus) {newwindow.focus()}
  	return false;
}

function remember()
{
  var height =  580;
  newwindow=window.open(
    \'remember\',
    \'rememberMe\',
    \'width=720,height=\'+height+\',overflow=scroll,toolbar=yes,menubar=yes,location=no,personalbar=yes,scrollbars=yes,status=no,directories=no,resizable=yes\'
  );
  	// this puts focus on the popup window if we open a new popup without closing the old one.
  	if (window.focus) {newwindow.focus()}
  	return false;
}

window.onload = externalLinks;
// -->
</script>';

# JavaScript for alphabetic IndexMenu
 $JavaScript .= '
<style type="text/css" >
<!--
#smenu {background-color:#ffffff; text-align:left; font-size: 90%; border:1px solid #000099; z-Index:200; visibility:hidden; position:absolute; top:100px; left:-'.$IndexPos.'px; width:450px; height:700px;}
#sleftTop {width:420px; height:5%; float:left;font-size: 90%;color:#999999; font-family:arial, helvetica, sans-serif;overflow: hidden;}
#sleft {width:420px; height:94%; float:left;font-size: 90%;color:#999999; font-family:arial, helvetica, sans-serif;overflow-x: hidden;overflow-y: scroll;}
#sright {width:10px; height:99%; float:right;font-size: 90%;color:#999999; font-family:arial, helvetica, sans-serif;overflow: hidden;}
#sright a:link{text-decoration:none; color:#684f00; font-family:arial, helvetica, sans-serif;}
#sright a:visited{text-decoration:none; color:#684f00; font-family:arial, helvetica, sans-serif;}
#sright a:active{text-decoration:none; color:#684f00; font-family:arial, helvetica, sans-serif;}
#sright a:hover{text-decoration:underline; color:#999999; font-family:arial, helvetica, sans-serif;}
-->
</style>

<script type="text/javascript">
<!--
// Sliding Menu Script
// copyright Stephen Chapman, 6th July 2005
// you may copy this code but please keep the copyright notice as well
// ASSP implementation by Thomas Eckardt
var speed = 1;

function changeSlide() {
    var findText = xDOM(\'quickfind\').value;
    if (findText == \'**select**\') findText = \'\';
    var re;
    try {
        re = new RegExp(findText,"i");
        re.test(\'abc\');
    }
    catch(err) {
        alert(\'error in string (regex) : \'+err);
        return false;
    }
    var entries = xDOM(\'sleft\').getElementsByTagName(\'a\');
    for (var i=0; i<entries.length; i++) {
        var id=entries[i].id;
        if (! id) next;
        if (findText == \'\' || re.test(id.substr(3))) {
            setObjDisp(id,\'inline\');
        } else {
            setObjDisp(id,\'none\');
        }
    }
}

function ClientSize(HorW) {
  var myWidth = 0, myHeight = 0;
  if( typeof( window.innerWidth ) == \'number\' ) {
    //Non-IE
    myWidth = window.innerWidth;
    myHeight = window.innerHeight;
  } else if( document.documentElement && ( document.documentElement.clientWidth || document.documentElement.clientHeight ) ) {
    //IE 6+ in \'standards compliant mode\'
    myWidth = document.documentElement.clientWidth;
    myHeight = document.documentElement.clientHeight;
  } else if( document.body && ( document.body.clientWidth || document.body.clientHeight ) ) {
    //IE 4 compatible
    myWidth = document.body.clientWidth;
    myHeight = document.body.clientHeight;
  }
  return  HorW == \'w\' ?  myWidth : myHeight;
}

var aDOM = 0, ieDOM = 0, nsDOM = 0; var stdDOM = document.getElementById;
if (stdDOM) aDOM = 1; else {ieDOM = document.all; if (ieDOM) aDOM = 1; else {
var nsDOM = ((navigator.appName.indexOf(\'Netscape\') != -1)
&& (parseInt(navigator.appVersion) ==4)); if (nsDOM) aDOM = 1;}}

function xDOM(objectId, wS) {
  if (stdDOM) return wS ? document.getElementById(objectId).style : document.getElementById(objectId);
  if (ieDOM) return wS ? document.all[objectId].style : document.all[objectId];
  if (nsDOM) return document.layers[objectId];
}
function objWidth(objectID) {var obj = xDOM(objectID,0); if(obj.offsetWidth) return obj.offsetWidth; if (obj.clip) return obj.clip.width; return 0;}
function objHeight(objectID) {var obj = xDOM(objectID,0); if(obj.offsetHeight) return obj.offsetHeight; if (obj.clip) return obj.clip.height; return 0;}
function setObjVis(objectID,vis) {var objs = xDOM(objectID,1); objs.visibility = vis;}
function setObjDisp(objectID,disp) {var objs = xDOM(objectID,1); objs.display = disp;}
function moveObjTo(objectID,x,y) {var objs = xDOM(objectID,1); objs.left = x; objs.top = y;}
function pageWidth() {return window.innerWidth != null? window.innerWidth: document.body != null? document.body.clientWidth:null;}
function pageHeight() {return window.innerHeight != null? window.innerHeight: document.body != null? document.body.clientHeight:null;}
function posLeft() {return typeof window.pageXOffset != \'undefined\' ? window.pageXOffset: document.documentElement.scrollLeft?
 document.documentElement.scrollLeft: document.body.scrollLeft? document.body.scrollLeft:0;}

function posTop() {return typeof window.pageYOffset != \'undefined\' ? window.pageYOffset: document.documentElement.scrollTop?
 document.documentElement.scrollTop: document.body.scrollTop? document.body.scrollTop:0;}

var xxx = 0; var yyy = 0; var dist = distX = distY = 0; var stepx = '.$IndexSlideSpeed.'; var stepy = 0; var mn = \'smenu\';

function disableSlide() {setObjVis(mn,\'hidden\');}
function enableSlide() {setObjVis(mn,\'visible\');}
function distance(s,e) {return Math.abs(s-e)}
function direction(s,e) {return s>e?-1:1}
function rate(a,b) {return a<b?a/b:1}
function setHeight() {var objs = xDOM(mn,1); var h = ClientSize(\'h\'); objs.height = h*0.95 +\'px\';}
function start() {setHeight(); xxx = -'.$IndexStart.'; yyy = 0; var eX = 0; var eY = 100; dist = distX = distance(xxx,eX); distY = distance(yyy,eY); stepx *=
-direction(xxx,eX) * rate(distX,distY); stepy *= direction(yyy,eY) * rate(distY,distX); moveit(); setObjVis(mn,\'visible\');}

function moveit() {var x = (posLeft()+xxx) + \'px\'; var y = posTop() + \'px\'; moveObjTo(mn,x,y);}
function mover() {if (dist > 0) {xxx += stepx; yyy += stepy; dist -= Math.abs(stepx);} moveit(); setTimeout(\'mover()\',speed);}
function slide() {dist = distX; stepx = -stepx; moveit(); setTimeout(\'mover()\',speed*2);return false;}

onload = start;
window.onscroll = moveit;
// -->
</script>
' if (! $mobile);
# END JavaScript for alphabetic IndexMenu

#start JavaScript for HintBox
$JavaScript .= <<EOT;
<style type="text/css">

#hintbox{ /*CSS for pop up hint box */
position:absolute;
top: 0;
background-color: lightyellow;
width: 150px; /*Default width of hint.*/
padding: 3px;
border:1px solid black;
font:normal 11px Verdana;
line-height:18px;
z-index:300;
border-right: 3px solid black;
border-bottom: 3px solid black;
visibility: hidden;

table { table-layout:fixed; word-wrap:break-word; }
}
</style>
EOT

$JavaScript .= '
<script type="text/javascript">

/***********************************************
* Show Hint script- (c) Dynamic Drive (www.dynamicdrive.com)
* This notice MUST stay intact for legal use
* Visit http://www.dynamicdrive.com/ for this script and 100s more.
*
* implemented in ASSP by Thomas Eckardt
***********************************************/

var horizontal_offset="0px" //horizontal offset of hint box from anchor link

/////No further editting needed

var vertical_offset="20px" //vertical offset of hint box from anchor link. No need to change.
var ie=document.all
var ns6=document.getElementById&&!document.all

function getposOffset(what, offsettype){
    var totaloffset=(offsettype=="left")? what.offsetLeft : what.offsetTop;
    var parentEl=what.offsetParent;
    while (parentEl!=null){
        totaloffset=(offsettype=="left")? totaloffset+parentEl.offsetLeft : totaloffset+parentEl.offsetTop;
        parentEl=parentEl.offsetParent;
    }
    return totaloffset;
}

function iecompattest(){
    return (document.compatMode && document.compatMode!="BackCompat")? document.documentElement : document.body
}

function clearbrowseredge(obj, whichedge, where){
    var edgeoffset=(whichedge=="rightedge")? (parseInt(horizontal_offset)-obj.offsetWidth*where/2)*-1 : parseInt(vertical_offset)*-1;
    if (whichedge=="rightedge"){
        var windowedge=ie && !window.opera? iecompattest().scrollLeft+iecompattest().clientWidth-90 : window.pageXOffset+window.innerWidth-100;
        dropmenuobj.contentmeasure=dropmenuobj.offsetWidth;
        if (windowedge-dropmenuobj.x < dropmenuobj.contentmeasure)
            edgeoffset=dropmenuobj.contentmeasure+obj.offsetWidth/(where+1)+parseInt(horizontal_offset);
    } else {
        var windowedge=ie && !window.opera? iecompattest().scrollTop+iecompattest().clientHeight-15 : window.pageYOffset+window.innerHeight-18
        dropmenuobj.contentmeasure=dropmenuobj.offsetHeight
        if (windowedge-dropmenuobj.y < dropmenuobj.contentmeasure)
            edgeoffset=dropmenuobj.contentmeasure-obj.offsetHeight+parseInt(vertical_offset)
    }
    return edgeoffset
}

function showhint(menucontents, obj, e, tipwidth, currLoc){
    if (document.getElementById("hintbox")){
        dropmenuobj=document.getElementById("hintbox")
        dropmenuobj.innerHTML=menucontents
        dropmenuobj.style.left=dropmenuobj.style.top=-500
        if (tipwidth!=""){
            dropmenuobj.widthobj=dropmenuobj.style
            dropmenuobj.widthobj.width=tipwidth
        }
        dropmenuobj.x=getposOffset(obj, "left")
        dropmenuobj.y=getposOffset(obj, "top");
        if (currLoc != "" && (ie||ns6)) {
            //var postop = ns6 ? 0 : posTop();
            var postop = 0;
            var objTop = yMousePos+postop+parseInt(vertical_offset);
            var Yedge=ie && !window.opera? iecompattest().scrollTop+iecompattest().clientHeight-15 : window.pageYOffset+window.innerHeight-18;
            if (dropmenuobj.offsetHeight + objTop > Yedge) {
                dropmenuobj.style.top=objTop-dropmenuobj.offsetHeight+"px";
            } else {
                dropmenuobj.style.top=objTop+"px";
            }
        } else {
            dropmenuobj.style.top=dropmenuobj.y-clearbrowseredge(obj, "bottomedge", 0)+"px";
        }
        if (currLoc != "") {
            dropmenuobj.style.left=dropmenuobj.x-clearbrowseredge(obj, "rightedge", 0)+obj.offsetWidth+"px";
        } else {
            dropmenuobj.style.left=dropmenuobj.x-clearbrowseredge(obj, "rightedge", 1)+obj.offsetWidth+"px";
        }
        //alert("x="+dropmenuobj.x+" , cb="+clearbrowseredge(obj, \'rightedge\')+" , offset="+obj.offsetWidth);
        //dropmenuobj.style.left=xMousePos+"px"
        dropmenuobj.style.visibility="visible"
        obj.onmouseout=hidetip
    }
}

function hidetip(e){
    dropmenuobj.style.visibility="hidden"
    dropmenuobj.style.left="-500px"
}

function createhintbox(){
    var divblock=document.createElement("div")
    divblock.setAttribute("id", "hintbox")
    document.body.appendChild(divblock)
}

if (window.addEventListener)
    window.addEventListener("load", createhintbox, false)
else if (window.attachEvent)
    window.attachEvent("onload", createhintbox)
else if (document.getElementById)
    window.onload=createhintbox

// Set Netscape up to run the "captureMousePosition" function whenever
// the mouse is moved. For Internet Explorer and Netscape 6, you can capture
// the movement a little easier.
if (document.layers) { // Netscape
    document.captureEvents(Event.MOUSEMOVE);
    document.onmousemove = captureMousePosition;
} else if (document.all) { // Internet Explorer
    document.onmousemove = captureMousePosition;
} else if (document.getElementById) { // Netcsape 6
    document.onmousemove = captureMousePosition;
}

// Global variables
xMousePos = 0; // Horizontal position of the mouse on the screen
yMousePos = 0; // Vertical position of the mouse on the screen
xMousePosMax = 0; // Width of the page
yMousePosMax = 0; // Height of the page

function captureMousePosition(e) {
    if (document.layers) {
        // When the page scrolls in Netscape, the event\'s mouse position
        // reflects the absolute position on the screen. innerHight/Width
        // is the position from the top/left of the screen that the user is
        // looking at. pageX/YOffset is the amount that the user has
        // scrolled into the page. So the values will be in relation to
        // each other as the total offsets into the page, no matter if
        // the user has scrolled or not.
        xMousePos = e.pageX;
        yMousePos = e.pageY;
        xMousePosMax = window.innerWidth+window.pageXOffset;
        yMousePosMax = window.innerHeight+window.pageYOffset;
    } else if (document.all) {
        // When the page scrolls in IE, the event\'s mouse position
        // reflects the position from the top/left of the screen the
        // user is looking at. scrollLeft/Top is the amount the user
        // has scrolled into the page. clientWidth/Height is the height/
        // width of the current page the user is looking at. So, to be
        // consistent with Netscape (above), add the scroll offsets to
        // both so we end up with an absolute value on the page, no
        // matter if the user has scrolled or not.

        if (window.event) {
            xMousePos = window.event.x+document.body.scrollLeft;
            yMousePos = window.event.y+document.body.scrollTop;
        } else {
            if (e) {};
        }
        xMousePosMax = document.body.clientWidth+document.body.scrollLeft;
        yMousePosMax = document.body.clientHeight+document.body.scrollTop;
    } else if (document.getElementById) {
        // Netscape 6 behaves the same as Netscape 4 in this regard
        xMousePos = e.pageX;
        yMousePos = e.pageY;
        xMousePosMax = window.innerWidth+window.pageXOffset;
        yMousePosMax = window.innerHeight+window.pageYOffset;
    }
}
function browserclose () {
    eraseCookie(\'lastAnchor\');
    confirm(\'please logout first ?\');
    return false;
}
if(window.addEventListener) {
    window.addEventListener("close", browserclose, false);
}

function changeTitle(title) {
    document.title = document.title.replace(/^\S+/ ,title);
}

function WaitDiv()
{
	document.getElementById(\'wait\').style.display = \'block\';
}

function WaitDivDel()
{
	document.getElementById(\'wait\').style.display = \'none\';
}

// JavaScript for reformating the mobile view
function setNavPosition() {
    if (oldBrowser) {document.getElementById(\'topnav\').style.top=\'67px\';}
    document.getElementById(\'topnav\').style.left=\'0px\';
    document.getElementById(\'navMenu\').style.top=document.getElementById(\'topnav\').offsetHeight - (oldBrowser * 18) + \'px\';
    document.getElementById(\'navMenu\').style.left=\'0px\';
}

function showLeftMenu() {
    if (document.getElementById(\'navMenu\').style.display == \'none\') {
        try {
        document.getElementById(\'cfgh2\').style.margin=\'5px 0 0 17em\';
        } catch(e) {}
        try {
        document.getElementById(\'cfgdiv\').style.margin=\'5px 0 0 17em\';
        } catch(e) {}
        document.getElementById(\'topnav\').style.display=\'block\';
        document.getElementById(\'navMenu\').style.display=\'block\';
    } else {
        document.getElementById(\'topnav\').style.display=\'none\';
        document.getElementById(\'navMenu\').style.display=\'none\';
        try {
        document.getElementById(\'cfgh2\').style.margin=\'5px 0 0 0\';
        } catch(e) {}
        try {
        document.getElementById(\'cfgdiv\').style.margin=\'5px 0 0 0\';
        } catch(e) {}
    }
    setNavPosition();
}
';
$JavaScript .= '
var gAutoPrint = true;

function processPrint(){

    if (document.getElementById != null){
        expand(1, 1);
        var html = \'<HTML>\n<HEAD>\n\';
        if (document.getElementsByTagName != null){
            var headTags = document.getElementsByTagName("head");
            if (headTags.length > 0) html += headTags[0].innerHTML;
        }
        html += \'\n</HE\' + \'AD>\n<BODY>\n\';
        html += \'<img src="get?file=images/logo.gif" />&nbsp;&nbsp;&nbsp;<b>ASSP version '.$version.$modversion.'</b><br /><hr /><br />\';

        var printReadyElemCfg  = document.getElementById("cfgdiv");
        var printReadyElemHint = document.getElementById("mainhints");

        if (printReadyElemHint != null)  html += "'.$headerTOC.'";

        if (printReadyElemCfg  != null)  html += printReadyElemCfg.innerHTML;
        if (printReadyElemHint != null)  html += printReadyElemHint.innerHTML;
        if (printReadyElemHint != null)  html += "'.$headerGlosar.'";

        expand(0, 1);
        html += \'\n</BO\' + \'DY>\n</HT\' + \'ML>\';
        var printWin = window.open("","processPrint");
        printWin.document.open();
        printWin.document.write(html);
        printWin.document.close();

        if (gAutoPrint) printWin.print();
    } else alert("Browser not supported.");
}
</script>
' unless $mobile;
$JavaScript .= <<EOT;
<style type="text/css">
#wait {
	position: absolute;
	width: 350;
	heigth: 100;
	margin-left: 300;
	margin-top: 150;
	background-color: #FFF000;
	text-align: center;
	border: solid 1px #FFFFFF;
}
</style>
EOT
#end JavaScript for HintBox

 $headerHTTP = 'HTTP/1.1 200 OK
Content-type: text/html
Cache-control: no-cache
';
 $headerDTDStrict = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
  "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
';
 $headerDTDTransitional = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
  "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
';
 $headers = "<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\">
<head>
  <meta http-equiv=\"content-type\" content=\"application/xhtml+xml; charset=utf-8\" />
  <title>Config ASSP ($myName) Host: $localhostname @ $localhostip</title>
  <link rel=\"stylesheet\" href=\"get?file=images/assp.css\" type=\"text/css\" />
  <link rel=\"shortcut icon\" href=\"get?file=images/favicon.ico\" />
$JavaScript
</head>
<body window.onunload=\"javascript:browserclose();\" window.onClose=\"javascript:browserclose();\"><a name=\"Top\"></a>
<div class=\"wait\" id=\"wait\" style=\"display: none;\">&nbsp;&nbsp; Please wait while loading... &nbsp;&nbsp;</div>
";

my $hid;
if ( ! $rootlogin) {
    $hid = $AdminUsersRight{"$WebIP{$ActWebSess}->{user}.user.hidDisabled"};
}
if (! $mobile) {
  $headers .= "  <div id=\"smenu\"><div id=\"sleftTop\">&nbsp;
";

 for ("A"..."Z") {
 $headers .= "<a href=\"#$_\" onmousedown=\"gotoAnchor('$_');return false;\">$_&nbsp;</a>";
 }
 $headers .= "&nbsp;&nbsp;<input id=\"quickfind\" size=\"9\" value=\"**select**\" style=\"background:#eee none; color:#222; font-style: italic\" onfocus=\"if (this.value == '**select**') {this.value='';}\" onchange=\"changeSlide();\" >&nbsp;&nbsp;<img src=\"get?file=images/plusIcon.png\" onmouseover=\"showhint('<table BORDER CELLSPACING=0 CELLPADDING=4 WIDTH=\\'100%\\'><tr><td>Select the values to show. The string is searched anywhere in the value names. A regular expression could be used.</td></tr></table>', this, event, '450px', ''); return true;\">&nbsp;&nbsp;&nbsp;<a href=\"javascript:void();\" onclick=\"xDOM('quickfind').value='';changeSlide();return false;\" onmouseover=\"showhint('<table BORDER CELLSPACING=0 CELLPADDING=4 WIDTH=\\'100%\\'><tr><td>Click to reset view to default.</td></tr></table>', this, event, '450px', ''); return true;\"><img src=\"get?file=images/minusIcon.png\" ></a>\n<hr></div><div id=\"sleft\">\n";
my %Config1 = ();
while (my ($k,$v) = each %Config) {
    $Config1{lc($k)} = $k;
}
my $firstChar = '';
my $i = 0;
$headerGlosar = "<p style=\"page-break-before: always;\"><br />\n";
$headerGlosar .= '<hr><h2>glosar</h2><hr><br />';
$headerGlosar .= '<table><tr>';
foreach (sort keys %Config1) {
    $i++;
    my $k = $Config1{$_};
    my $name;
    if ( uc($firstChar) ne uc(substr($k,0,1))) {
        $name = 'name="'.uc(substr($k,0,1)).'"';
        $headerGlosar .= '<td>&nbsp;</td>' if ($i != 1 && $i % 2);
        $headerGlosar .= '</tr><tr>' if ($i != 1);
        $headerGlosar .= '<td><br /><br /><b>'.uc(substr($k,0,1))."</b></td><td>&nbsp;</td></tr>\n";
    }
    $headerGlosar .= '<tr>' if ($i % 2);
    my $gI = $glosarIndex{$k};
    $gI = $glosarIndex{'URIBLError'} if $k eq 'TLDS';
    $headerGlosar .= "<td>$k - $gI</td>";
    $headerGlosar .= "</tr>\n" if (!($i % 2));
    $firstChar = uc(substr($k,0,1));
    next if $hid && ! &canUserDo($WebIP{$ActWebSess}->{user},'cfg',$k);
    my $value = $ConfigListBox{$k} ? $ConfigListBox{$k} : encodeHTMLEntities($Config{$k});
    $value =~ s/'|"|\n//go;
    $value =~ s/\\/\\\\/go;
    $value = '&nbsp;' unless $value;
    $value = 'ENCRYPTED' if exists $cryptConfigVars{$k} or $k eq 'webAdminPassword';
    my $default = exists $cryptConfigVars{$k} && $k ne 'webAdminPassword' ? 'ENCRYPTED' : $ConfigDefault{$k};
    $default = '' if $default eq undef;
    $headers .= "<a $name id=\"sl_$k\" onmousedown=\"expand(0, 1);showDisp('$ConfigPos{$k}');gotoAnchor('$k');slide();return false;\" onmouseover=\"window.status='$ConfigNice{$k}'; showhint('<table BORDER CELLSPACING=0 CELLPADDING=4 WIDTH=\\'100%\\'><tr><td>config var:</td><td>$k</td></tr><tr><td>description:</td><td>$ConfigNice{$k}</td></tr><tr><td>current value:</td><td>$value</td></tr><tr><td>default value:</td><td>$default</td></tr></table>', this, event, '500px', 'index'); return true;\" onmouseout=\"window.status='';return true;\">&nbsp;<img src=\"$noIcon\" alt=\"$ConfigNice{$k}\" />&nbsp;$k<br /></a>\n";
#    $headers .= "<a $name id=\"sl_$k\" href=\"./#$k\" onmousedown=\"expand(0, 1);showDisp('$ConfigPos{$k}');gotoAnchor('$k');slide();return false;\" onmouseover=\"window.status='$ConfigNice{$k}'; showhint('<table BORDER CELLSPACING=0 CELLPADDING=4 WIDTH=\\'100%\\'><tr><td>config var:</td><td>$k</td></tr><tr><td>description:</td><td>$ConfigNice{$k}</td></tr><tr><td>current value:</td><td>$value</td></tr><tr><td>default value:</td><td>$default</td></tr></table>', this, event, '500px', 'index'); return true;\" onmouseout=\"window.status='';return true;\">&nbsp;<img src=\"$noIcon\" alt=\"$ConfigNice{$k}\" />&nbsp;$k<br /></a>\n";
}
  $headerGlosar .= '<td>&nbsp;</td></tr>' if ($i % 2);
  $headerGlosar .= "\n</table>\n";
  $headerGlosar =~ s/(["\/]|\r?\n)/\\$1/gos;

  
  $headers .= "<br />&nbsp;<br />&nbsp;<br />&nbsp;<br />&nbsp;<br />&nbsp;</div><div id=\"sright\"><a href=\"#\" onclick=\"return slide();return false;\">";
  $headers .= "<img src=\"get?file=images/plusIcon.png\" alt=\"open and close alphabetical index\" /><br />&nbsp;<br \/>";
  $headers .= "<img src=\"get?file=images/minusIcon.png\" alt=\"open and close alphabetical index\" /><br />&nbsp;<br \/>";
  $headers .= "<img src=\"get?file=images/minusIcon.png\" alt=\"open and close alphabetical index\" /><br />&nbsp;<br \/>";
  $headers .= "<img src=\"get?file=images/plusIcon.png\" alt=\"open and close alphabetical index\" /><br />&nbsp;<br \/>";
# do not use spaces in $boardertext - instead use '#'
  my $boardertext = "sorted#config";
  $boardertext =~ s/([^#])/$1<br \/>/go;
  $boardertext =~ s/#/&nbsp;<br \/>/go;
  $headers .= "$boardertext<br />";
  $headers .= "<img src=\"get?file=images/plusIcon.png\" alt=\"open and close alphabetical index\" /><br />&nbsp;<br \/>";
  $headers .= "<img src=\"get?file=images/minusIcon.png\" alt=\"open and close alphabetical index\" /><br />&nbsp;<br \/>";
  $headers .= "<img src=\"get?file=images/minusIcon.png\" alt=\"open and close alphabetical index\" /><br />&nbsp;<br \/>";
  $headers .= "<img src=\"get?file=images/plusIcon.png\" alt=\"open and close alphabetical index\" /><br />&nbsp;<br \/>";
  $headers .= "</a></div></div>
";

} # end if $mobile -> no index

  $headers .= "<p>";
  $headers .= '<table id="TopMenu" class="contentFoot" style="margin:0; text-align:left;" CELLSPACING=0 CELLPADDING=4 WIDTH="100%">
  <tr><td rowspan="3" align="left">';
  if (-e "$base/images/logo.gif") {
      $headers .= "<a href=\"http://assp.sourceforge.net/\" target=\"_blank\"><img src=\"get?file=images/logo.gif\" alt=\"ASSP\" /></a>";
  } else {
      $headers .= "<a href=\"http://assp.sourceforge.net/\" target=\"_blank\"><img src=\"get?file=images/logo.jpg\" alt=\"ASSP\" /></a>";
  }
  $headers .= "</td><td rowspan=\"3\" align=\"left\" onmouseover=\"showhint(detectedBrowser,this, event, '450px', '')\">ASSP version $version$modversion<br />";

  if ($setpro && $globalClientName && $globalClientPass) {
      $headers .= "<b><font color=white size=+3>&nbsp;&nbsp;&nbsp;&nbsp;pro</font></b>";
  }

  my $avv = "$availversion";
  my $stv = "$version$modversion";
  $avv =~ s/RC/\./gio;
  $stv =~ s/RC/\./gio;
  $avv =~ s/\s|\(|\)//gio;
  $stv =~ s/\s|\(|\)//gio;
  $stv = 0 if ($avv =~ /\d{5}(?:\.\d{1,2})?$/o && $stv =~ /(?:\.\d{1,2}){3}$/o);
  $headers .= "<br /><a href=\"$NewAsspURL\" target=\"_blank\" style=\"color:green;size:-1;\">new available ASSP version $availversion</a>" if $avv gt $stv;

 $headers .= '</td>
  <td><a href="lists">White/Redlist/Tuplets</a></td>
  <td><a href="recprepl">Recipient Replacement Test</a></td>
  <td><a href="maillog' . $maillogEnd . '">View Maillog Tail</a></td>
  </tr><tr>
  <td><a href="analyze">Mail Analyzer</a></td>
  <td><a href="infostats">Info and Stats</a>';
 $headers .= $DoT10Stat ?
  '<a href="top10stats" target="_blank" onmouseover="showhint(\'show top ten stats\', this, event, \'100px\', \'1\');return false;"><img height=12 width=12 src="' . $wikiinfo . '" /></a></td>'
                       :
  '</td>';
 $headers .= '
  <td><a href="statusassp?nocache='.time.'" target="_blank">Worker/DB/Regex Status</a></td>
  </tr><tr>
  <td><a href="shutdown_list?nocache='.time.'" target="_blank">SMTP Connections </a>
  <a href="shutdown_list?nocache='.time.'&forceRefresh=1" target="_blank" onmouseover="showhint(\''.$ConnHint.'\', this, event, \'500px\', \'1\');return false;"><img height=12 width=12 src="' . $wikiinfo . '" /></a></td>
  <td><a href="shutdown">Shutdown/Restart</a></td>
  <td><a href="donations">Donations</a>'.($codename?'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>'.$codename.'</b>':'').'</td>
  </tr>
  </table>
';

 $headers .= "</p>\n";
 $headers .= "&nbsp;
              <a href=\"javascript:void(0);\" onclick=\"showLeftMenu();return false;\"><small>show/hide the left menu</small></a>
              &nbsp;&nbsp;
              <a href=\"/?mobile=1\"><small>back to main view</small></a>
" if $mobile;
 $headers .= "<div id=\"topnav\" class=\"navMenu\" style=\"position:absolute;text-align:center;";
 $headers .= 'display:none;' if $mobile;
 $headers .= '">';
 $headers .= "
  <a href=\"javascript:void(0);\" onmousedown=\"expand(1, 1);return false;\">Expand All</a>&nbsp;
  <a href=\"javascript:void(0);\" onmousedown=\"expand(0, 1);return false;\">Collapse All</a>&nbsp;
";
 $headers .= ($mobile ? '<br />': "<a href=\"javascript:void(0);\" onmousedown=\"slide();return false;\">sorted</a><br />") ;
  if ($WebIP{$ActWebSess}->{user} eq 'root') {
      $headers .= "<a href=\"./adminusers\" onclick=\"eraseCookie('lastAnchor');return true;\">manage users</a>";
  } else {
      $headers .= "<a href=\"./pwd\">Change Password</a>";
  }

 $headers .= "<a href=\".?mobile=0\">&nbsp;&nbsp;full GUI</a>" if $mobile;
 $headers .= "<a href=\".?mobile=1\">&nbsp;&nbsp;mobile view</a>" if ! $mobile;

 $headers .= "
<div class=\"rightButton\" style=\"text-align: center;\">
  <input type=\"button\" value=\"logout\" onclick=\"document.forms['ASSPconfig'].theButtonLogout.value='  logout  ';eraseCookie('lastAnchor');window.location.href='./logout';return false;\" />\&nbsp;
  <a href=\"javascript:void(0);\" onclick=\"remember();return false;\" onmouseover=\"showhint('open the remember me window', this, event, '200px', '');return false;\"><img height=12 width=12 src=\"$wikiinfo\" /></a>&nbsp;
  <input type=\"button\" value=\"Apply\" onclick=\"document.forms['ASSPconfig'].theButtonX.value='Apply Changes';document.forms['ASSPconfig'].submit();WaitDiv();return false;\" />&nbsp;
";
 $headers .= "
  <a href=\"./fc\" target=\"_blank\" onmouseover=\"showhint('start the assp file commander', this, event, '200px', '');return false;\"><img height=19 width=19 src=\"get?file=images/fc_main.png\" /></a>"
    if ($CanUseASSP_FC && &canUserDo($WebIP{$ActWebSess}->{user},'action','fc'));
 $headers .= "
</div>
<hr />
</div>
";

 $headers .= "<div class=\"navMenu\"";
 if ($EnableFloatingMenu && ! $mobile) {
     $headers .= ' id="navMenu" style="position:absolute;margin:92px 0px 0px 0px;">';
 } else {
     my $hd = $mobile ? 'display:none;' : '';
     $headers .= ' id="navMenu" style="height:100%;overflow-y:hidden;position:absolute;margin:92px 0px 0px 0px;'.$hd.'"
     onmouseover="document.getElementById(\'navMenu\').style.overflowY=\'auto\';"
     onmouseout="document.getElementById(\'navMenu\').style.overflowY=\'hidden\';">';
 }

 $headers .= "
<script type=\"text/javascript\">
<!--
  setNavPosition();
// -->
</script>
";

 $headers .= "
  <div class=\"menuLevel1\"><a href=\"/\" onmousedown=\"setAnchor('delete');return false;\" /><img src=\"$plusIcon\" alt=\"plusicon\" /> Main</a><br /></div>\n<div>";
 my $counter = 0;
 for my $idx (0...$#ConfigArray) {
   my $c = $ConfigArray[$idx];
   if(@{$c} == 5) {
     $headers .= "</div>\n  <div class=\"menuLevel2\">\n  ".
       ($mobile ? '' : "<a onmousedown=\"toggleDisp('$counter');setAnchor('delete');return false;\">") .
       "<img id=\"treeIcon$counter\" src=\"$plusIcon\" alt=\"plusicon\" ". ($mobile ? "style=\"display:none \"" : '' ) . "/>" .
       ($mobile ? '' : ' '.$c->[4]).
       "</a>\n</div>\n<div id=\"treeElement$counter\" style=\"padding-left: 3px; display: block\">";
     $counter++;
   } else {
     $headers .= "\n    <div class=\"menuLevel3\"><a href=\"./#$c->[0]\" onmousedown=\"setAnchor('$c->[0]');return false;\">$c->[0]</a></div>"
       if (! $mobile && ! $hid && &canUserDo($WebIP{$ActWebSess}->{user},'cfg',$c->[0]));
   }
 }
 $headers .= "</div>
<div class=\"menuLevel1\">$NavMenu</div>
<hr />
<div class=\"rightButton\" style=\"text-align: center;\">
  <input type=\"button\" value=\"  logout  \" onclick=\"document.forms['ASSPconfig'].theButtonLogout.value='  logout  ';eraseCookie('lastAnchor');window.location.href='./logout';return false;\" />
</div>
<hr />
<div class=\"rightButton\" style=\"text-align: center;\">
  <input type=\"button\" value=\"Apply Changes\" onclick=\"document.forms['ASSPconfig'].theButtonX.value='Apply Changes';document.forms['ASSPconfig'].submit();WaitDiv();return false;\" />
</div>
<hr />
<div class=\"menuLevel2\">

	<a href=\"#\" onclick=\"return popFileEditor(\'/notes/confighistory.txt\',8); \"><img src=\"$noIcon\" alt=\"#\" /> Config Changes History</a><br />
	<a href=\"#\" onclick=\"return popFileEditor(\'/notes/fc-history.txt\',8); \"><img src=\"$noIcon\" alt=\"#\" /> File Commander History</a><br />
	<a href=\"#\" onclick=\"return popFileEditor(\'/notes/admininfo.txt\',8); \"><img src=\"$noIcon\" alt=\"#\" /> Admin Info Messages</a><br />
	<a href=\"#\" onclick=\"return popFileEditor(\'/notes/configdefaults.txt\',8); \"><img src=\"$noIcon\" alt=\"#\" /> Non-Default Settings</a><br />
	<a href=\"#\" onclick=\"return popFileEditor(\'/notes/config.txt\',8);\"><img src=\"$noIcon\" alt=\"#\" /> Config Descriptions</a><br />
	<a href=\"#\" onclick=\"return popFileEditor(\'rebuildrun.txt\',8);\"><img src=\"$noIcon\" alt=\"#\" /> Last SpamDB Rebuild</a>
";

$headers .= "<hr />
	<hr />
	<span class=\"negative\"><center><b>internal Caches</b></center></span>
	<hr />
	<a href=\"#\" onclick=\"return popFileEditor(\'DB-AUTHErrors\',\'1h\');\"><img src=\"$noIcon\" alt=\"#\" /> AUTHErrors</a><br />
	<a href=\"#\" onclick=\"return popFileEditor(\'DB-DelayIPPB\',\'1h\');\"><img src=\"$noIcon\" alt=\"#\" /> DelayIPPB</a><br />
	<a href=\"#\" onclick=\"return popFileEditor(\'DB-IPNumTries\',\'1h\');\"><img src=\"$noIcon\" alt=\"#\" /> IPNumTries</a><br />
	<a href=\"#\" onclick=\"return popFileEditor(\'DB-IPNumTriesDuration\',\'1h\');\"><img src=\"$noIcon\" alt=\"#\" /> IPNumTriesDuration</a><br />
	<a href=\"#\" onclick=\"return popFileEditor(\'DB-IPNumTriesExpiration\',\'1h\');\"><img src=\"$noIcon\" alt=\"#\" /> IPNumTriesExp</a><br />
	<a href=\"#\" onclick=\"return popFileEditor(\'DB-SMTPdomainIP\',\'1h\');\"><img src=\"$noIcon\" alt=\"#\" /> SMTPdomainIP</a><br />
	<a href=\"#\" onclick=\"return popFileEditor(\'DB-SMTPdomainIPTries\',\'1h\');\"><img src=\"$noIcon\" alt=\"#\" /> SMTPdomainIPTries</a><br />
	<a href=\"#\" onclick=\"return popFileEditor(\'DB-SMTPdomainIPTriesExpiration\',\'1h\');\"><img src=\"$noIcon\" alt=\"#\" /> SMTPdomainIPTriesExp.</a><br />
	<a href=\"#\" onclick=\"return popFileEditor(\'DB-SSLfailed\',\'1h\');\"><img src=\"$noIcon\" alt=\"#\" /> SSLfailed</a><br />
	<a href=\"#\" onclick=\"return popFileEditor(\'DB-localTLSfailed\',\'1h\');\"><img src=\"$noIcon\" alt=\"#\" /> localTLSfailed</a><br />
	<a href=\"#\" onclick=\"return popFileEditor(\'DB-Stats\',\'1h\');\"><img src=\"$noIcon\" alt=\"#\" /> Stats</a><br />
	<a href=\"#\" onclick=\"return popFileEditor(\'DB-ScoreStats\',\'1h\');\"><img src=\"$noIcon\" alt=\"#\" /> ScoreStats</a><br />
	<a href=\"#\" onclick=\"return popFileEditor(\'DB-WhiteOrgList\',\'1h\');\"><img src=\"$noIcon\" alt=\"#\" /> WhiteOrgList</a><br />
	<a href=\"#\" onclick=\"return popFileEditor(\'DB-localFrequencyCache\',\'1h\');\"><img src=\"$noIcon\" alt=\"#\" /> localFrequencyCache</a><br />
	<a href=\"#\" onclick=\"return popFileEditor(\'DB-subjectFrequencyCache\',\'1h\');\"><img src=\"$noIcon\" alt=\"#\" /> subjectFrequencyCache</a><br />
	<a href=\"#\" onclick=\"return popFileEditor(\'DB-LDAPNotFound\',\'1h\');\"><img src=\"$noIcon\" alt=\"#\" /> LDAPNotFound</a><br />
	<a href=\"#\" onclick=\"return popFileEditor(\'DB-EmergencyBlock\',\'1h\');\"><img src=\"$noIcon\" alt=\"#\" /> EmergencyBlock</a><br />
	<a href=\"#\" onclick=\"return popFileEditor(\'DB-RFC822dom\',\'1h\');\"><img src=\"$noIcon\" alt=\"#\" /> RFC822dom</a><br />
	<a href=\"#\" onclick=\"return popFileEditor(\'DB-LastSchedRun\',\'1h\');\"><img src=\"$noIcon\" alt=\"#\" /> Scheduler History</a><br />
	<a href=\"#\" onclick=\"return popFileEditor(\'DB-T10StatI\',\'1h\');\"><img src=\"$noIcon\" alt=\"#\" /> TOP blocked IP\'s</a><br />
	<a href=\"#\" onclick=\"return popFileEditor(\'DB-T10StatS\',\'1h\');\"><img src=\"$noIcon\" alt=\"#\" /> TOP blocked senders</a><br />
	<a href=\"#\" onclick=\"return popFileEditor(\'DB-T10StatD\',\'1h\');\"><img src=\"$noIcon\" alt=\"#\" /> TOP blocked domains</a><br />
	<a href=\"#\" onclick=\"return popFileEditor(\'DB-T10StatR\',\'1h\');\"><img src=\"$noIcon\" alt=\"#\" /> TOP blocked recipients</a><br />
" if $rootlogin or &canUserDo($WebIP{$ActWebSess}->{user},'action','editinternals');

$headers .= "
	<a href=\"#\" onclick=\"return popFileEditor(\'DB-DMARCpol\',\'1h\');\"><img src=\"$noIcon\" alt=\"#\" /> DMARC policies</a><br />
	<a href=\"#\" onclick=\"return popFileEditor(\'DB-DMARCrec\',\'1h\');\"><img src=\"$noIcon\" alt=\"#\" /> DMARC records</a>
" if (($rootlogin or &canUserDo($WebIP{$ActWebSess}->{user},'action','editinternals')) && $DoDKIM && $ValidateSPF);

$headers .= "<hr />
	<span style=\"font-weight: bold;\">ASSP Version</span>: $version$modversion<br />
	".($codename?"<span style=\"font-weight: bold;\">code name</span>: $codename<br />":'')."
	<span style=\"font-weight: bold;\">Current PID</span>: $mypid<br />
	<span style=\"font-weight: bold;\">Started</span>: $starttime<br />
</div>
<hr />
";

$headers .= "</div>
<script type=\"text/javascript\">
  <!--
  ";
 if (! $mobile && $EnableFloatingMenu) {
     $headers .= "document.getElementById('navMenu').style.height=ClientSize('h') + 'px';";
     $headers .= 'JSFX_FloatDiv("navMenu",2,85,2,-2,2,99999).flt();';
     $headers .= 'JSFX_FloatDiv("topnav",2,85,2,-2,2,99999).flt();';
     $headers .= '
  expand(0,0);
';
 } else {
     $headers .= '
  expand(0,0);
';
     $headers .= "document.getElementById('navMenu').style.height=ClientSize('h') + 'px';";
 }

 my @regerr = keys %RegexError;
 $headers .= "alert('found regular expression errors in : @regerr')" if @regerr;

 $headers .= '
  // -->
  </script>
  ';
  
    $footers = "
<div class=\"contentFoot\">
<a href=\"donations\">donations</a> |
<a href=\"http://assp.cvs.sourceforge.net\" rel=\"external\" target=\"_blank\">development</a> |
<a href=\"http://assp.sourceforge.net/cgi-bin/assp_stats\" rel=\"external\" target=\"_blank\">global stats</a> |
<a href=\"https://apps.sourceforge.net/mediawiki/assp/index.php?title=ASSP_Documentation\" rel=\"external\" target=\"_blank\">docs</a> |
 <a href=\"http://sourceforge.net/mail/?group_id=69172\" rel=\"external\" target=\"_blank\">email lists</a> |

 <a href=\"http://apps.sourceforge.net/phpbb/assp/\" rel=\"external\" target=\"_blank\">community forums</a> |

 <a href=\"http://apps.sourceforge.net/mediawiki/assp/\" rel=\"external\" target=\"_blank\">wiki</a> |
 <a id=\"printLink\" href=\"javascript:void(processPrint());\">Print Config/Screen</a>
</div>";
if ($mobile) {
    $footers .= "
<script type=\"text/javascript\">
<!--
  showLeftMenu();showLeftMenu();
  document.getElementById('printLink').innerHTML = '&nbsp;';
// -->
</script>
";
} else {
    $footers .= "
<script type=\"text/javascript\">
<!--
    if (document.getElementById(\"mainhints\") != null) {
        document.getElementById('printLink').innerHTML = 'Print the Manual';
    } else {
        document.getElementById('printLink').innerHTML = 'Print the Screen';
    }
// -->
</script>
";
}

    $kudos = '
<div class="kudos">
 <a href="http://assp.cvs.sourceforge.net" rel="external" target="_blank">
 <img src="get?file=images/village.gif" alt="Development" height="31" width="31" /></a>
 <a href="http://sourceforge.net" rel="external" target="_blank">
 <img src="get?file=images/sourceforge-logo.gif" alt="SourceForge" height="31" width="88" /></a>
 <a href="http://opensource.org" rel="external" target="_blank">
 <img src="get?file=images/opensource-logo.gif" alt="Open Source" height="31" width="88" /></a>
</div>
';
}

sub RemovePid {
 if ($pidfile) {
  d('RemovePid');
  close $PIDH;
  unlink("$base/$pidfile") or mlog(0,"warning: unable to delete $base/$pidfile");
 }
}

sub d_S {
 my ($Sdebugprint,$Snostep) = @_;
 $lastd{$WorkerNumber} = $Sdebugprint unless $Snostep;
 threads->yield();
 return unless ($debug || $ThreadDebug);
 my $Stime=&timestring();
 $Sdebugprint =~ s/\n/\[LF\]\n/go;
 $Sdebugprint =~ s/\r/\[CR\]/go;
 $Sdebugprint .= "\n" if $Sdebugprint !~ /\n$/o;
 threads->yield();
 $debugQueue->enqueue("$Stime [$WorkerName] <$Sdebugprint>");
 threads->yield();
}

sub d {
 my ($debugprint,$nostep) = @_;
 $lastd{$WorkerNumber} = $debugprint unless $nostep;
 threads->yield();
 return unless ($debug || $ThreadDebug);
 my $time=&timestring();
 $debugprint =~ s/\n/\[LF\]\n/go;
 $debugprint =~ s/\r/\[CR\]/go;
 $debugprint .= "\n" if $debugprint !~ /\n$/o;
 threads->yield();
 $debugQueue->enqueue("$time [$WorkerName] <$debugprint>");
 threads->yield();
}

sub _assp_try_restart {
    if($AsAService) {
        exec('cmd.exe /C net stop ASSPSMTP & net start ASSPSMTP');
    } elsif ($AsADaemon == 1) {
        exit 1;
    } elsif ($AutoRestartCmd && $AsADaemon == 2) {
        exec($AutoRestartCmd);
    } elsif ($AutoRestartCmd && $AsADaemon == 3) {
        exec($AutoRestartCmd);
        exit 1;
    } elsif (!$AutoRestartCmd && ($AsADaemon == 3 || $AsADaemon == 2)) {
        mlog(0,"error: AutoRestartCmd is not defined in daemon mode $AsADaemon - don't know what to do!");
        mlogWrite();
    } else {
        if ($AutoRestartCmd && $AutoRestart) {
            exec($AutoRestartCmd);
        }
        exit 1;
    }
}

sub createBDBEnv {
    my ($hash, $userenv) = @_;
    return unless $hash;

    my $env;
    my $bdbf;
    my %userenv = $userenv ? %$userenv : () ;
    $userenv{'-Cachesize'} = 512 * 1024 if $userenv{'-Cachesize'} < 512 * 1024;
    my $bdbdir = "$base/tmpDB/$hash";

  {
    lock($BDBEnvLock) if is_shared($BDBEnvLock);

    -d "$bdbdir" or mkdir "$bdbdir",0755;

    if ($NumComWorkers <= 7 && ($bdbf = getHashBDBName($hash))) {
        my $size =  -s "$base/$bdbf.bdb";
        $userenv{'-Cachesize'} = $size if ($bdbf && $size > $userenv{'-Cachesize'});
        foreach ( Glob("$base/tmpDB/$hash/*")) {
            if ($_ =~ /\.bdb$/o) {
               $size = -s "$_";
               $userenv{'-Cachesize'} = $size if ($size > $userenv{'-Cachesize'});
            }
        }
    }
    $userenv{'-Cachesize'} = 10*1024*1024 if $userenv{'-Cachesize'} >  10*1024*1024; # max 10MB
    $bdbf ||= "tmpDB/$hash/$hash";

eval (<<'EOT');
    $env = BerkeleyDB::Env->new(-Flags => DB_INIT_CDB | DB_INIT_MPOOL | DB_CREATE ,
                                -LockDetect => DB_LOCK_DEFAULT,
                                -Home => "$bdbdir",
                                -Config => {DB_DATA_DIR => "$bdbdir",
                                            DB_LOG_DIR  => "$bdbdir",
                                            DB_TMP_DIR  => "$bdbdir"
                                           },
                                 %userenv
                               );
    mlog(0,"BerkeleyDB-CRT-ENV-ERROR (1) in HASH $hash , on file $base/$bdbf.bdb : BDB:$BerkeleyDB::Error")
        if ($BerkeleyDB::Error !~ /: 0\s*$/o);

    if ($WorkerNumber == 10000 && $BerkeleyDB::Error =~ /DB_RUNRECOVERY|Bad file descriptor/oi) {
        undef $env;
        mlog(0,"info: try BDB-Env recovery for hash $hash");
        unlink "$bdbdir/__db.001";
        unlink "$bdbdir/__db.002";
        unlink "$bdbdir/__db.003";
        unlink "$bdbdir/__db.004";
        unlink "$bdbdir/$hash.bdb";

        if ($hash eq 'Griplist') {
            unlink "$base/griplist";
            unlink "$base/griplist.bin";
            unlink "$base/griplist.delta";
            unlink "$base/griplist.bdb";
            $NextGriplistDownload = 0;
            mlog(0,"warning: removed all files for hash $hash to recover from corruption with new download");
        } elsif ($hash eq 'BackDNS2') {
            my ($file) = $localBackDNSFile =~ /^ *file: *(.+)/io;
            if ($file) {
                unlink "$base/$file.txt";
                unlink "$base/$file.gz";
                $NextBackDNSFileDownload = 0;
                mlog(0,"warning: removed all files for hash $hash to recover from corruption with new download");
            }
        } else {
            my $hashfile = getHashBDBName($hash);
            if (-e "$base/$hashfile.bdb") {
                my $todel = $hashfile;
                $hashfile = "/$hashfile" if $hashfile !~ /\//o;
                ($hashfile) = $hashfile =~ /^.*\/([^\/]+)$/o;
                my $src="$base/$backupDBDir/$hashfile";
                my $tar="$base/$importDBDir/$hashfile.rpl";
                if (copy($src,$tar)) {
                    unlink "$base/$todel.bdb";
                    mlog(0,"info: recover corrupt BerkeleyDB for hash $hash from last backup");
                    $RunTaskNow{ImportMysqlDB} = 10000;
                } else {
                    mlog(0,"warning: unable to recover corrupt BerkeleyDB hash from last backup - unable to copy $base/$backupDBDir/$hashfile to $base/$importDBDir/$hashfile.rpl - $!");
                }
            }
        }
        
        $env = BerkeleyDB::Env->new(-Flags => DB_INIT_CDB | DB_INIT_MPOOL | DB_CREATE ,
                                    -LockDetect => DB_LOCK_DEFAULT,
                                    -Home => "$bdbdir",
                                    -Config => {DB_DATA_DIR => "$bdbdir",
                                               DB_LOG_DIR  => "$bdbdir",
                                                DB_TMP_DIR  => "$bdbdir"
                                               },
                                     %userenv
                                   );
        mlog(0,"BerkeleyDB-CRT-ENV-ERROR (2) in HASH $hash , on file $base/$bdbf.bdb : BDB:$BerkeleyDB::Error")
            if ($BerkeleyDB::Error !~ /: 0\s*$/o);


        if ($BerkeleyDB::Error =~ /DB_RUNRECOVERY|Bad file descriptor/oi) {
            $ConfigAdd{clearBerkeleyDBEnv} = 1;
            if ($WorkerNumber == 0) {
                SaveConfig();
            } else {
                $ConfigChanged = 1;
            }
            mlog(0,"error: BerkeleyDB for hash $hash ($base/$bdbf.bdb) needs to be recovered - recovery will be done at next start - try to restart assp now");
            mlogWrite() if $WorkerNumber == 0;
            $doShutdown = time + 15;
            die "BDB for $hash needs recovery\n";
        }
    }
    $env->set_timeout(1000000,DB_SET_LOCK_TIMEOUT) if $env;
EOT
  }
    if ($@ || $BerkeleyDB::Error !~ /: 0\s*$/o || ! $env) {
         mlog(0,"BerkeleyDB-ENV-ERROR $hash: $@ - BDB:$BerkeleyDB::Error");
         $ComWorker{$WorkerNumber}->{run} = 0 if $WorkerNumber > 0;
         $ComWorker{$WorkerNumber}->{inerror} = 1 if $WorkerNumber > 0;
         delete $BerkeleyDBHashes{$hash};
         die "BerkeleyDB-ENV-ERROR $hash: $@ - BDB:$BerkeleyDB::Error\n" if $WorkerNumber > 0 || ! $doShutdown;
    } else {
         my $bcache =  &formatDataSize(-s "$base/tmpDB/$hash/__db.003",1);
         mlog(0,"info: list $hash is using 'BerkeleyDB' version $BerkeleyDB::db_version - cachesize is $bcache") if $WorkerNumber == 0;
         $BerkeleyDBHashes{$hash} = time;
    }
    return $env;
}

sub tieToBDB {
    my ($hash,$file,$env) = @_;
    my $Object = $hash . 'Obj';

eval (<<'EOT');
    ${$Object}=tie %$hash,'BerkeleyDB::Hash',
                       (-Filename => "$file",
                        -Flags => DB_CREATE,
                        -Env => $env);
    BDB_filter(${$Object});
EOT
    if ($@ or $BerkeleyDB::Error !~ /: 0\s*$/o) {
        mlog(0,"BerkeleyDB-TIE-ERROR $hash: $@ - BDB:$BerkeleyDB::Error");
        $ComWorker{$WorkerNumber}->{run} = 0 if $WorkerNumber > 0;
        $ComWorker{$WorkerNumber}->{inerror} = 1 if $WorkerNumber > 0;
        die "$@\n";
    }
    BDB_getRecordCount($hash);
}

sub BDB_sync {
    d('BDB_sync');
    my $timeout = shift;
    $timeout = 0 unless $timeout;
    if ($DoSyncBDB) {
        mlog(0,'info: synchronizing all BerkeleyDB hashes to disk') if $MaintenanceLog;
        foreach (keys %BerkeleyDBHashes) {
            d("BDB_sync - $_");
            my $res = &BDB_sync_hash($_);
        }
        mlogWrite() if $WorkerName eq 'Shutdown';
    }
    if ($DoCompactBDB && $WorkerName ne 'Shutdown') {
        mlog(0,'info: compacting all BerkeleyDB hashes on disk') if $MaintenanceLog;
        foreach (keys %BerkeleyDBHashes) {
            d("BDB_compact - $_");
            my $res = BDB_compact_hash($_,$timeout);
        }
    }
    return 1;
}

sub BDB_sync_hash {
    my $hash = shift;
    return 0 unless $hash;
    return 0 unless $DoSyncBDB;
    return 0 unless tied %{$hash};
    my $dbo = $hash . 'Object';     # main hashes
    $dbo = $hash . 'Obj' unless defined ${$dbo};   # temp hashes
    return 0 unless defined ${$dbo};
    my $res;
    if ("$$dbo" =~ /assp::/io) {
        eval{
             my $lock;
             $lock = ${$dbo}->{hashobj}->cds_lock() if $main::lockBDB && ${$dbo}->{hashobj}->cds_enabled();
             $res = ${$dbo}->{hashobj}->db_sync();
        };
    } else {
        eval{
             my $lock;
             $lock = ${$dbo}->cds_lock() if $main::lockBDB && ${$dbo}->cds_enabled();
             $res = ${$dbo}->db_sync();
        };
    }
    if ($@ or ($res != 0 && $BerkeleyDB::error)) {
        mlog(0,"warning: unable to write cache of BerkeleyDB hash $hash to disk - $@ - BDB:$BerkeleyDB::error");
        return 0;
    } else {
        mlog(0,"info: synchronized BerkeleyDB hash $hash to disk") if $MaintenanceLog >= 2 && $dbo !~ /Obj$/o;
    }
    return 1;
}

sub BDB_compact_hash {
    my ($hash , $timeout) = @_;
    return 0 unless $hash;
    return 0 unless tied %{$hash};
    my $dbo = $hash . 'Object';     # main hashes
    $dbo = $hash . 'Obj' unless defined ${$dbo};   # temp hashes
    return 0 unless defined ${$dbo};
    my $res;

    return 1 unless (($WorkerNumber == 10000 and $BerkeleyDBHashes{$hash} > time) or $WorkerNumber == 0);
    $BerkeleyDBHashes{$hash} = time + 3600;

    my $bdbf = getHashBDBName($hash);
    my %hash;
    $hash{compact_fillpercent} = 10;
    $timeout *= 1000000;
    $timeout ||= 1000000; # 1 second
    $hash{compact_timeout} = $timeout;

    if ("$$dbo" =~ /assp::/io) {
        eval (<<'EOT');
             my $lock;
             $lock = ${$dbo}->{hashobj}->cds_lock() if $main::lockBDB && ${$dbo}->{hashobj}->cds_enabled();
             $res = ${$dbo}->{hashobj}->compact(undef,
                                                undef,
                                                \%hash,
                                                DB_FREE_SPACE
                                               );
EOT
    } else {
        eval (<<'EOT');
             my $lock;
             $lock = ${$dbo}->cds_lock() if $main::lockBDB && ${$dbo}->cds_enabled();
             $res = ${$dbo}->compact(undef,
                                     undef,
                                     \%hash,
                                     DB_FREE_SPACE
                                    );
EOT
    }
    if ($@ or ($res != 0 && $BerkeleyDB::error)) {
        mlog(0,"warning: unable to compact file $base/$bdbf.bdb of BerkeleyDB hash $hash - $@ - BDB:$BerkeleyDB::error");
        return 0;
    } else {
        my $ext;
        if ($MaintenanceLog > 2 && $dbo !~ /Obj$/o && keys %hash) {
            $ext = ' [';
            foreach (keys %hash) {
                $ext .= "$_: $hash{$_}, ";
            }
            $ext =~ s/, $//o;
            $ext .= ']';
        }
        mlog(0,"info: done compact file $base/$bdbf.bdb of BerkeleyDB hash $hash$ext")
            if $MaintenanceLog >= 2 && $dbo !~ /Obj$/o;
        return 1;
    }
}

sub BDB_getRecordCount {
    my $hash = shift;
    return 0 unless $hash;
    return 0 unless exists $BerkeleyDBHashes{$hash};
    return 0 unless tied %{$hash};
    my $dbo = $hash . 'Object';     # main hashes
    $dbo = $hash . 'Obj' unless defined ${$dbo};   # temp hashes
    return 0 unless defined ${$dbo};
    my $statref;
    if ("$$dbo" =~ /assp::/io) {
        eval (<<'EOT');
             $statref = ${$dbo}->{hashobj}->db_stat();
EOT
    } else {
        eval (<<'EOT');
             $statref = ${$dbo}->db_stat();
EOT
    }
    return 0 unless $statref;
    return 0 unless ref $statref;
    return $statref->{hash_ndata};
}

sub showBDBstatus {
    my @hashes = @_;
    while (shift @hashes) {
        unless (exists $BerkeleyDBHashes{$_}) {
            mlog(0,"info: showBDBstatus - hash $_ is not a BerkeleyDB hash");
            next;
        }
        my $dbo = $_ . 'Object';
        $dbo = $_ . 'Obj' unless defined ${$dbo};
        if (! defined ${$dbo} ) {
            mlog(0,"hash: $_ is not tied");
            return;
        }
        mlog(0,"BDB statistic for BerkeleDB hash $_ on $dbo");
        my $statref;
        if ("$$dbo" =~ /assp::/io) {
            eval (<<'EOT');
                 $statref = ${$dbo}->{hashobj}->db_stat();
EOT
        } else {
            eval (<<'EOT');
                 $statref = ${$dbo}->db_stat();
EOT
        }
        my $out = "\n";
        foreach (sort keys %{$statref}) {
            $out .= $_ . (' ' x (16 - length($_))) . ": ${$statref}{$_}\n";
        }
        mlog(0,$out);
        mlog(0, "lock status for BerkleyDB hash $_ on $dbo");
        if ($VerBerkeleyDB lt '0.42') {
            ${${$dbo}}[1]->lock_stat_print;
        } else {
            ${$dbo}->Env->lock_stat_print;
        }
    }
}

sub BDB_filter {
    my $obj = shift;
    return unless $obj;
    eval{
    $obj->filter_fetch_key  ( sub { threads->yield(); } ) ;
    $obj->filter_store_key  ( sub { threads->yield(); } ) ;
    };
}

sub BDB_filter_off {
    my $obj = shift;
    return unless $obj;
    eval {
    $obj->filter_fetch_key  ( sub { } ) ;
    $obj->filter_store_key  ( sub { } ) ;
    };
}

sub initPrivatHashes {
    my $clean = shift;
    if ($griplist && ! $GriplistObj) {
        if ($GriplistDriver eq 'BerkeleyDB::Hash' && $useDB4griplist) {
            my $file = "$base/$griplist";
            d("BDB-DB (initPrivatHashes) - Griplist , $file.bdb");
            &tieToBDB('Griplist', "$file.bdb", &createBDBEnv('Griplist'));
        } else {
            $GriplistObj=tie %Griplist,$GriplistDriver,$GriplistFile;
            $GriplistObj->resetCache();
            my $r = loadHashFromFile("$base/$griplist", $GriplistObj->{cache}) || 'no';
#            mlog(0,"info: Griplist has $r records") if $MaintenanceLog >= 2;
            $GriplistObj->{max} = 999999999999;
            $GriplistObj->{bin} = 0;
        }
    }

    if ($CanUseBerkeleyDB && $runHMMusesBDB && exists $tempDBvars{'HMMdb'}) {
        my $hash = 'HMMdb';
        my $file = "$base/$hash.bdb" ;
        my %userenv = ('-Cachesize' => 10 * 1024 * 1024) ;
        d("BDB-DB (initPrivatHashes) - $hash , $file");
        &tieToBDB($hash,
                  $file,
                  &createBDBEnv($hash,\%userenv)
                 ) unless tied(%{$hash});
        mlog(0,"info: HMMdb is using 'BerkeleyDB' version $BerkeleyDB::db_version in file $base/$hash.bdb, because HMMusesBDB is set to ON") if $WorkerNumber == 0;
    }
    
    if ($CanUseBerkeleyDB && $useDB4IntCache) {
        my ($BackDNS2DB) = $localBackDNSFile =~ /^ *file: *(.+)/io;
        $BackDNS2DB = "$base/tmpDB/BackDNS2/BackDNS2.bdb" if $BackDNS2DB ;

        mlog(0,"info: internal hashes are using 'BerkeleyDB' version $BerkeleyDB::db_version in directory $base/tmpDB") if $WorkerNumber == 0;

        foreach (sort keys %tempDBvars) {
            next if $_ eq 'BackDNS2';
            next if $_ =~ /^HMM/oi;
#            next if $WorkerNumber == 10001;
            my $file = "$base/tmpDB/$_/$_.bdb";
            my %userenv = ();
            d("BDB-DB (initPrivatHashes) - $_ , $file");
            &tieToBDB($_,
                      $file,
                      &createBDBEnv($_,\%userenv)
                     ) unless tied(%{$_});
            %{$_} = ()
                if (   $_ ne 'Stats'
                    && $_ ne 'ScoreStats'
                    && $_ ne 'WhiteOrgList'
                    && $_ ne 'DMARCpol'
                    && $_ ne 'DMARCrec'
                    && $_ ne 'subjectFrequencyCache'
                    && $clean
                    && $WorkerNumber == 0);
        }

        if (! tied(%BackDNS2) &&
                       $BackDNS2DB &&
                       ($DBusedDriver ne 'BerkeleyDB' or
                        ($DBusedDriver eq 'BerkeleyDB' && $pbdb !~ /DB:/io)
                       )
                      )
        {
            d("BDB-DB (initPrivatHashes) - BackDNS2 , $BackDNS2DB");
            &tieToBDB('BackDNS2',
                      $BackDNS2DB,
                      &createBDBEnv('BackDNS2')
                     );
        }
    }
}

sub initGlobalThreadVar {
    &setMakeREVars();
    &ThreadCompileAllRE(1) if $calledfromThread;
    undef $readable;
    undef $writable;
    %SocketCalls = ();
    %SocketCallsNewCon = ();
    %Con = ();
    %ConDelete = ();
    if ($IOEngineRun == 0) {
        $readable = IO::Poll->new();
        $writable = IO::Poll->new();
    } else {
        $readable = IO::Select->new();
        $writable = IO::Select->new();
    }
}

sub checkINC {
    for my $p ("$base","$base/lib","$base/Plugins") {
        unshift(@INC,$_) unless(grep(/^\Q$p\E$/,@INC));
    }
}

sub init {
 my $ver;
 my $append;
 my $installed;
 $DataBaseDebug = $DataBaseDebug ? 1 : 0;
 if ($DBCacheSize) {
     my $size = $NumComWorkers * 2 + 8;
     $DBCacheSize = $size if $size > $DBCacheSize;
 }
 while (@prelog) {
     mlog(0, shift @prelog);
 }

 if($] lt '5.012003') {
   mlog(0, "warning: Perl version 5.012003 (5.12.3) is at least recommended to run ASSP $version $modversion - you are running Perl version $] - please upgrade Perl");
 }
 if($] lt '5.012000') {
   mlog(0, "Perl version 5.012000 (5.12.0) is at least required to use the unicode Bayesian/HMM engine of ASSP $version $modversion - you are running Perl version $] - please upgrade Perl");
 }
 my $p;
 $p = '-professional' if ($setpro && $globalClientName && $globalClientPass);
 if ($localhostname) {
     mlog(0,"ASSP$p version $version$modversion (Perl $]) (on $^O)running on server: $localhostname ($localhostip)");
 } else {
     mlog(0,"ASSP$p version $version$modversion (Perl $]) (on $^O) running on server: localhost ($localhostip)") ;
 }
 if ($canUnicode) {
     mlog(0,"info: unicode support is available on that system");
 } else {
     mlog(0,"info: unicode support is not available on that system");
 }

 print 'check process env ';

 if ($MaintenanceLog > 1) {
     mlog(0,"info: Perl will search for modules in the following folders:\n". join("\n",map {my $t = $_ ; $t = "'$t'";$t;} @INC));
     mlog(0,"info: beside the default Perl search pathes, this list has to contain:\n$base\n$base/lib\n$base/Plugins");
 }

 $MailCount = 0;

 readNorm();

 &initGlobalThreadVar();

 $MinPollTimeT =  $MinPollTime ? $MinPollTime : 1 ;
 $pollwait = $MinPollTimeT/1000;

 my $perlver=$];
 $WorkerName = 'init';
  if ( $^O eq 'MSWin32' ) {
       eval{
           mlog(0,'info: analysing windows system environment');
           my @msvcrt;
           my @where = split(/;/o,$ENV{'PATH'});
           my $perls = $perl;
           $perls =~ s/\\[^\\]+$//o;
           $perls =~ s/\\[^\\]+$//o;
           $perls .= '\site\bin';
           unshift (@where, $perls);
           my $perl = $perl;
           $perl =~ s/\\[^\\]+$//o;
           unshift (@where, $perl);
           my $dbase = $base;
           $dbase =~ s/\//\\/go;
           $dbase =~ s/[\\|\/]*$//o;
           unshift (@where, $dbase);
           my $path_to_msvcrt;
           while ( my $pdir = shift @where) {
               if (-e "$pdir/msvcrt.dll") {
                   $path_to_msvcrt = $pdir;
                   last;
               }
           }
           $path_to_msvcrt =~ s/[\\|\/]*$//o;
           if (lc $path_to_msvcrt ne lc ($ENV{'SystemRoot'}.'\system32')) {
               mlog(0,"warning: Perl seems to use the C-runtime library 'msvcrt.dll' in directory $path_to_msvcrt, this should be MS-C-runtime library 'msvcrt.dll' in directory ".$ENV{'SystemRoot'}.'\system32. Your environment variable -PATH- is possibly wrong set!');
               print "\t\t\t\t\t[warning]";
           } else {
               mlog(0,'info: windows system environment looks OK');
               print "\t\t\t\t\t[OK]";
           }
       };
       if ($@) {
           mlog(0,"warning: unable to analyse windows system environment - $@");
           print "\t\t\t\t\t[ERROR]";
       }
  } else {
       print "\t\t\t\t\t[SKIP]";
  }
  if ( $perlver > "5.999999") {
       mlog(0,"Perl version $perlver is not supported for ASSP Version 2.x.x!");
  }

  print "\ncheck process permission";

  my $tmpASSPout;
  my $StartError;
  if (open($tmpASSPout, ">", "$base/aaaa_tmp.pl")) {
      binmode $tmpASSPout;
      close $tmpASSPout;
      my $assp = $assp;
      $assp =~ s/\\/\//og;
      $assp = $base.'/'.$assp if ($assp !~ /\Q$base\E/io);
      copy("$assp","$base/aaaa_tmp.pl");
      if (-e ($assp.'.run')) {
          unlink($assp.'.run') or mlog(0,"error: unable to remove old saved running script '$assp.run' - $!");
      }
      copy("$assp",$assp.'.run') or mlog(0,"error: unable to save current running script to file '$assp.run'");
      unless (rename("$base/aaaa_tmp.pl","$base/aaaa_tmpx.pl") && unlink("$base/aaaa_tmpx.pl")) {
        mlog(0,'************************************************************');
        mlog(0,"error: this process is unable to rename and/or delete files in directory $base");
        mlog(0,"error: $!");
        mlog(0,'error: check permission and disable all online virusscanners for this directory');
        mlog(0,'error: remove manualy the files aaaa_tmp.pl and aaaa_tmpx.pl from this directory');
        mlog(0,'error: restart assp');
        mlog(0,'************************************************************');
        $StartError = 1;
            print "\t\t\t\t[ERROR]";
      } else {
            print "\t\t\t\t[OK]";
      }
  } else {
      mlog(0,'************************************************************');
      mlog(0,"error: this process is unable to write in to directory $base");
      mlog(0,"error: $!");
      mlog(0,'error: check permission and disable all online virusscanners for this directory');
      mlog(0,'error: remove manualy the files aaaa_tmp.pl and aaaa_tmpx.pl from this directory');
      mlog(0,'error: restart assp');
      mlog(0,'************************************************************');
      $StartError = 1;
      print "\t\t\t\t[ERROR]";
  }
  unlink("$base/aaaa_tmp.pl");

  print "\nsetting up modules";
  $append = '';
  $ver=threads->VERSION;
  $append = '- please upgrade to version 1.74 or higher' if ($ver lt '1.74');
  mlog(0,"threads module $ver installed $append");
  $ModuleList{'threads'} = $ver.'/1.74';
  print '.';

  $append = '';
  $ver=threads::shared->VERSION;
  $append = '- please upgrade to version 1.32 or higher' if ($ver lt '1.32');
  mlog(0,"threads::shared module $ver installed $append");
  $ModuleList{'threads::shared'} = $ver.'/1.32';
  print '.';

  $append = '';
  $ver=Thread::Queue->VERSION;
  $append = '- please upgrade to version 2.11 or higher' if ($ver lt '2.11');
  mlog(0,"Thread::Queue module $ver installed $append");
  $ModuleList{'Thread::Queue'} = $ver.'/2.11';
  print '.';

  $append = '';
  $ver=IO::Poll->VERSION;
  $ver =~ s/0+$//o;
  $append = '- please upgrade to version 0.07' if ($ver lt '0.07');
  mlog(0,"IO::Poll module $ver installed $append");
  $ModuleList{'IO::Poll'} = $ver.'/0.07';

  $append = '';
  $ver=IO::Select->VERSION;
  $append = '- please upgrade to version 1.17' if ($ver lt '1.17');
  mlog(0,"IO::Select module $ver installed $append");
  $ModuleList{'IO::Select'} = $ver.'/1.17';

  if ($IOEngineRun == 0) {
      mlog(0,'ASSP is using IOEngine - Poll');
  } else {
      mlog(0,'ASSP is using IOEngine - select');
  }

  if ($CanUseThreadState) {
    $ver=eval('Thread::State->VERSION'); $VerThreadState=$ver;
    if ($ver ge '0.09') {
        $ver=" version $ver" if $ver;
        mlog(0,"Thread::State module$ver installed and available");
    } else {
        $ver=" version $ver" if $ver;
        mlog(0,"Thread::State module$ver installed - but version 0.09 or higher is required - Thread::State is not available");
        $CanUseThreadState = 0;
    }
    $installed = 'enabled';
  } else {
    $installed = $useThreadState ? 'is not installed' : 'is disabled in config';
    mlog(0,"Thread::State 0.09 module $installed.");
  }
  $ModuleList{'Thread::State'} = $VerThreadState.'/0.09';
  $ModuleStat{'Thread::State'} = $installed;

  $ver = IO::Socket->VERSION;
  if ($ver lt '1.30') {
      *{'IO::Socket::blocking'} = *{'main::assp_socket_blocking'};   # MSWIN32 fix for nonblocking Sockets
      mlog(0,"IO::Socket version $ver is too less - recommended is 1.30_01 - hook ->blocking to internal procedure");
  }
  print '.';

  if ($CanUseIOSocketINET6 || $SysIOSocketINET6 == 0) {
    $ver=eval('IO::Socket::INET6->VERSION'); $VerIOSocketINET6=$ver; $ver=" version $ver" if $ver;
    my $sys = ($SysIOSocketINET6 == 1) ? '' : ' - but IPv6 is not supported by your system';
    mlog(0,"IO::Socket::INET6 module$ver installed and available$sys");
    mlog(0,'please upgrade the module IO::Socket::INET6 to version 2.67 or higher') if ($VerIOSocketINET6 lt '2.67');
    $installed = ($SysIOSocketINET6 == 1) ? 'enabled' : 'not supported';
  } else {
    $installed = $useIOSocketINET6 ? 'is not installed' : 'is disabled in config';
    $installed = 'is not detected (enableIPv6 is not set)';
    mlog(0,"IO::Socket::INET6 module $installed.");
  }
  $ModuleList{'IO::Socket::INET6'} = $VerIOSocketINET6.'/2.67';
  $ModuleStat{'IO::Socket::INET6'} = $installed;

  if ($CanUseAvClamd) {
    *{'File::Scan::ClamAV::ping'} = *{'main::ClamScanPing'};
    *{'File::Scan::ClamAV::streamscan'} = *{'main::ClamScanScan'};
    my $clamavd = File::Scan::ClamAV->new(port => $AvClamdPort);
    if($clamavd->ping()) {
      $AvailAvClamd = 1;
      $ver = $clamavd->VERSION;
      $VerFileScanClamAV=$ver; $ver=" version $ver" if $ver;
      $ModuleList{'File::Scan::ClamAV'} = $VerFileScanClamAV.'/1.8';
      $ModuleStat{'File::Scan::ClamAV'} = 'enabled';
      mlog(0,"File::Scan::ClamAV module$ver installed and available");
    } else {
      $AvailAvClamd = 0;
      $ver = $clamavd->VERSION;
      $VerFileScanClamAV=$ver; $ver=" version $ver" if $ver;
      $ModuleList{'File::Scan::ClamAV'} = $VerFileScanClamAV.'/1.8';
      mlog(0,"File::Scan::ClamAV module$ver installed but not available, error: ".$clamavd->errstr());
      $ModuleStat{'File::Scan::ClamAV'} = $clamavd->errstr();
    }
  } else {
    $AvailAvClamd = 0;
    $VerFileScanClamAV = '';
    $ModuleList{'File::Scan::ClamAV'} = $VerFileScanClamAV.'/1.8';
    $installed = $useFileScanClamAV ? 'is not installed' : 'is disabled in config';
    mlog(0,"File::Scan::ClamAV module $installed.") if $UseAvClamd;
    $ModuleStat{'File::Scan::ClamAV'} = $installed;
  }
  print '.';

  if ($CanUseLDAP) {
    $ver=eval('Net::LDAP->VERSION'); $VerNetLDAP=$ver; $ver=" version $ver" if $ver;
    mlog(0,"Net::LDAP module$ver installed and available");
    $installed = 'enabled';
  } else {
    $installed = $useNetLDAP ? 'is not installed' : 'is disabled in config';
    mlog(0,"Net::LDAP module $installed.") if $DoLDAP;
  }
  $ModuleList{'Net::LDAP'} = $VerNetLDAP.'/0.33';
  $ModuleStat{'Net::LDAP'} = $installed;

  if ($CanUseDNS) {
    $ver=eval('Net::DNS->VERSION'); $VerNetDNS=$ver; $ver=" version $ver" if $ver;
    mlog(0,"Net::DNS module$ver installed and available");
    $installed = 'enabled';
    my $d = Net::DNS::Resolver->new();
    $orgNewDNSResolver = \&Net::DNS::Resolver::Base::new;
    *Net::DNS::Resolver::Base::new = \&getDNSResolver;
  } else {
    $installed = $useNetDNS ? 'is not installed' : 'is disabled in config';
    mlog(0,"Net::DNS module $installed.");
  }
  $ModuleList{'Net::DNS'} = $VerNetDNS.'/0.61';
  $ModuleStat{'Net::DNS'} = $installed;

  if ($CanUseNetSMTP) {
    $ver=eval('Net::SMTP->VERSION'); $VerNetSMTP=$ver; $ver=" version $ver" if $ver;
    mlog(0,"Net::SMTP module$ver installed and available");
    $installed = 'enabled';
  } else {
    $installed = $useNetSMTP ? 'is not installed' : 'is disabled in config';
    mlog(0,"Net::SMTP module $installed.") if $DoRFC822 || $DoDomainCheck;
  }
  $ModuleList{'Net::SMTP'} = $VerNetSMTP.'/2.31';
  $ModuleStat{'Net::SMTP'} = $installed;

  if ($CanUseNetSMTPTLS) {
    $ver=eval('Net::SMTP::TLS->VERSION'); $VerNetSMTPTLS=$ver; $ver=" version $ver" if $ver;
    mlog(0,"Net::SMTP::TLS module$ver installed and available");
    $installed = 'enabled';
    *{'Net::SMTP::TLS::starttls'} = *{'main::NST_starttls'};
  } else {
    $installed = $useNetSMTPTLS ? 'is not installed' : 'is disabled in config';
    mlog(0,"Net::SMTP::TLS module $installed.");
  }
  $ModuleList{'Net::SMTP::TLS'} = $VerNetSMTPTLS.'/0.12';
  $ModuleStat{'Net::SMTP::TLS'} = $installed;

  if ($CanUseNetSNMPagent) {
    $ver=eval('NetSNMP::agent->VERSION'); $VerNetSNMPagent=$ver; $ver=" version $ver" if $ver;
    ;
    foreach (@NetSNMP::ASN::EXPORT) {
        eval ('$SNMPAS{$_} = NetSNMP::ASN::constant($_, 0);1;') ||
        eval ('$SNMPAS{$_} = NetSNMP::ASN::constant($_);1;') ||
        ( mlog(0,"error: unable to get constant ($_) for NetSNMP::ASN - $@") &&
          ($installed = 'ASN constant error') && ($CanUseNetSNMPagent = ''));
    }
    foreach (@NetSNMP::agent::EXPORT) {
        eval ('$SNMPag{$_} = NetSNMP::agent::constant($_, 0);1;') ||
        eval ('$SNMPag{$_} = NetSNMP::agent::constant($_);1;') ||
        ( mlog(0,"error: unable to get constant ($_) for NetSNMP::agent - $@") &&
          ($installed = 'agent constant error') && ($CanUseNetSNMPagent = ''));
    }
    if ($CanUseNetSNMPagent) {
        mlog(0,"NetSNMP::agent module$ver installed and available");
    } else {
        mlog(0,"NetSNMP::agent module$ver installed but disabled because of an '$installed'");
    }
  } else {
    $installed = $useNetSNMPagent ? 'is not installed' : 'is disabled in config';
    mlog(0,"NetSNMP::agent module $installed.");
  }
  $ModuleList{'NetSNMP::agent'} = $VerNetSNMPagent.'/5.05';
  $ModuleStat{'NetSNMP::agent'} = $installed;

  if ($CanUseSPF) {
    $ver=eval('Mail::SPF::Query->VERSION'); $VerMailSPF=$ver; $ver=" version $ver" if $ver;
    mlog(0,"Mail::SPF::Query module$ver installed and available");
    $installed = 'enabled';
  } elsif ($AvailSPF) {
    $ver=eval('Mail::SPF::Query->VERSION'); $ver=" version $ver" if $ver;
    mlog(0,"Mail::SPF::Query module$ver installed but Net::DNS required");
    $installed = 'Net::DNS required';
  } else {
    $installed = $useMailSPFQuery ? 'is not installed' : 'is disabled in config';
    mlog(0,"Mail::SPF::Query module $installed.") if $ValidateSPF;
  }
  $ModuleList{'Mail::SPF::Query'} = $VerMailSPF.'/1.999001';
  $ModuleStat{'Mail::SPF::Query'} = $installed;

  if ($CanUseSPF2) {
   $ver        = eval('Mail::SPF->VERSION');
   $ver        =~ s/^v//gio; # strip leading 'v'
   $VerMailSPF = $ver;
   $ver        = " version $ver" if $ver;
   if ( $VerMailSPF >= 2.007 ) {
    mlog(0, "Mail::SPF module$ver installed and available" );
    $installed = 'enabled';
   } else {
    mlog(0, "Mail::SPF module$ver installed but must be >= 2.007" );
    mlog(0, 'Mail::SPF will not be used.' );
    $CanUseSPF2 = 0;
    $installed = 'wrong version';
   }
  } elsif ($AvailSPF2) {
   $ver = eval('Mail::SPF->VERSION');
   $ver =~ s/^v//gio; # strip leading 'v'
   $ver = " version $ver" if $ver;
   mlog(0, "Mail::SPF module$ver installed but Net::DNS required" );
   $installed = 'Net::DNS required';
  } else {
   $installed = $useMailSPF ? 'is not installed' : 'is disabled in config';
   mlog(0, "Mail::SPF module $installed." ) if $ValidateSPF;
  } 
  $ModuleList{'Mail::SPF'} = $VerMailSPF.'/2.007';
  $ModuleStat{'Mail::SPF'} = $installed;

  if ($CanUseSRS) {
    $ver=eval('Mail::SRS->VERSION'); $VerMailSRS=$ver; $ver=" version $ver" if $ver;
    mlog(0,"Mail::SRS module$ver installed - Sender Rewriting Scheme available");
    $installed = 'enabled';
  } elsif (!$AvailSRS) {
    $installed = $useMailSRS ? 'is not installed' : 'is disabled in config';
    mlog(0,"Mail::SRS module $installed - Sender Rewriting Scheme disabled") if $EnableSRS;
  }
  $ModuleList{'Mail::SRS'} = $VerMailSRS.'/0.31';
  $ModuleStat{'Mail::SRS'} = $installed;

  if ($CanUseHTTPCompression) {
    $ver=eval('Compress::Zlib->VERSION'); $VerCompressZlib=$ver; $ver=" version $ver" if $ver;
    mlog(0,"Compress::Zlib module$ver installed - HTTP compression available");
    $installed = 'enabled';
  } elsif (!$AvailZlib) {
    $installed = $useCompressZlib ? 'is not installed' : 'is disabled in config';
    mlog(0,"Compress::Zlib module $installed - HTTP compression disabled");
  }
  $ModuleList{'Compress::Zlib'} = $VerCompressZlib.'/2.008';
  $ModuleStat{'Compress::Zlib'} = $installed;

  if ($CanUseMD5Keys) {
    $ver=eval('Digest::MD5->VERSION'); $VerDigestMD5=$ver; $ver=" version $ver" if $ver;
    mlog(0,"Digest::MD5 module$ver installed - delaying can use MD5 keys for hashes");
    $installed = 'enabled';
  } else {
    $installed = $useDigestMD5 ? 'is not installed' : 'is disabled in config';
    mlog(0,"Digest::MD5 module $installed - delaying can not use MD5 keys for hashes");
  }
  $ModuleList{'Digest::MD5'} = $VerDigestMD5.'/2.36_01';
  $ModuleStat{'Digest::MD5'} = $installed;

  if ($CanUseSHA1) {
    $ver=eval('Digest::SHA1->VERSION'); $VerDigestSHA1=$ver; $ver=" version $ver" if $ver;
    mlog(0,"Digest::SHA1 module$ver installed - BATV and FBMTV check available");
    $installed = 'enabled';
  } else {
    $installed = $useDigestSHA1 ? 'is not installed' : 'is disabled in config';
    mlog(0,"Digest::SHA1 module $installed - BATV and FBMTV check not available");
  }
  $ModuleList{'Digest::SHA1'} = $VerDigestSHA1.'/2.11';
  $ModuleStat{'Digest::SHA1'} = $installed;

  if ($CanSearchLogs) {
    $ver=eval('File::ReadBackwards->VERSION'); $VerFileReadBackwards=$ver; $ver=" version $ver" if $ver;
    mlog(0,"File::ReadBackwards module$ver installed - searching of log files enabled");
    $installed = 'enabled';
  } elsif (!$AvailReadBackwards) {
    $installed = $useFileReadBackwards ? 'is not installed' : 'is disabled in config';
    mlog(0,"File::ReadBackwards module $installed - searching of log files disabled");
  }
  $ModuleList{'File::ReadBackwards'} = $VerFileReadBackwards.'/1.04';
  $ModuleStat{'File::ReadBackwards'} = $installed;

  if ($CanStatCPU) {
    $ver=eval('Time::HiRes->VERSION'); $VerTimeHiRes=$ver; $ver=" version $ver" if $ver;
    mlog(0,"Time::HiRes module$ver installed - CPU usage statistics available");
  }
  $ModuleList{'Time::HiRes'} = $VerTimeHiRes.'/1.9707';
  $ModuleStat{'Time::HiRes'} = 'enabled';

  if ($CanChroot) {
    $ver=eval('PerlIO::scalar->VERSION'); $VerPerlIOscalar=$ver; $ver=" version $VerPerlIOscalar" if $ver;
    if ($ChangeRoot) {
        mlog(0,"PerlIO::scalar module$ver installed - chroot savy");
        mlog(0,"error: ChangeRoot - /etc/protocols in $ChangeRoot not found!") unless -e "$ChangeRoot/etc/protocols";
    }
    $installed = 'enabled';
  } else {
    $installed = $usePerlIOscalar ? 'is not installed' : 'is disabled in config';
    mlog(0,"PerlIO::scalar module $installed - chroot not available") if $ChangeRoot;
  }
  $ModuleList{'PerlIO::scalar'} = $VerPerlIOscalar.'/0.05';
  $ModuleStat{'PerlIO::scalar'} = $installed;

  if ($CanUseSyslog){
    $ver=eval('Sys::Syslog->VERSION'); $VerSysSyslog=$ver; $ver=" version $ver" if $ver;
    mlog(0,"Sys::Syslog module$ver installed - Unix centralized logging enabled");
    $installed = 'enabled';
  } elsif (!$AvailSyslog ) {
    $installed = $useSysSyslog ? 'is not installed' : 'is disabled in config';
    mlog(0,"Sys::Syslog module $installed.") if $sysLog && !$sysLogPort;
  }
  $ModuleList{'Sys::Syslog'} = $VerSysSyslog.'/0.25';
  $ModuleStat{'Sys::Syslog'} = $installed;

  if ($CanUseWin32Daemon){
    $ver=eval('Win32::Daemon->VERSION'); $VerWin32Daemon=$ver; $ver=" version $ver" if $ver;
    mlog(0,"Win32::Daemon module$ver installed - can run as Win32 service") if ( $^O eq 'MSWin32' );
    $installed = 'enabled';
  } else {
    $installed = $useWin32Daemon ? 'is not installed' : 'is disabled in config';
    mlog(0,"Win32::Daemon module $installed - unable to run as Win32 service") if ( $^O eq 'MSWin32' );
  }
  $ModuleList{'Win32::Daemon'} = $VerWin32Daemon.'/20080324';
  $ModuleStat{'Win32::Daemon'} = $installed;

  if ($CanUseWin32Debug){
    $ver=eval('Win32::API::OutputDebugString->VERSION'); $VerWin32APIOutputDebugString=$ver; $ver=" version $ver" if $ver;
    mlog(0,"Win32::API::OutputDebugString module$ver installed - can debug to Win32 debug API") if ( $^O eq 'MSWin32' );
    $installed = 'enabled';
  } else {
    $installed = $useWin32APIOutputDebugString ? 'is not installed' : 'is disabled in config';
    mlog(0,"Win32::API::OutputDebugString module $installed - unable to debug to Win32 API") if ( $^O eq 'MSWin32' );
  }
  $ModuleList{'Win32::API::OutputDebugString'} = $VerWin32APIOutputDebugString.'/0.03';
  $ModuleStat{'Win32::API::OutputDebugString'} = $installed;

  if ($CanUseUnicodeGCString){
    $ver=eval('Unicode::GCString->VERSION'); $VerUnicodeGCString=$ver; $ver=" version $ver" if $ver;
    mlog(0,"Unicode::GCString module$ver installed - can detect east asian language strings as sequence of UAX #29 Grapheme Clusters to analyze Bayes and HMM");
    $installed = 'enabled';
    $requiredDBVersion{'Spamdb'} .= '_UAX#29';
    $requiredDBVersion{'HMMdb'}  .= '_UAX#29';
  } else {
    $installed = $useUnicodeGCString ? 'is not installed' : 'is disabled in config';
    mlog(0,"Unicode::GCString module $installed - unable to detect east asian language strings as sequence of UAX #29 Grapheme Clusters");
  }
  $ModuleList{'Unicode::GCString'} = $VerUnicodeGCString.'/2012.04';
  $ModuleStat{'Unicode::GCString'} = $installed;

  if ($CanUseTextUnidecode){
    $ver=eval('Text::Unidecode->VERSION'); $VerTextUnidecode=$ver; $ver=" version $ver" if $ver;
    mlog(0,"Text::Unidecode module$ver installed - can transliterate unicode characters to ASCII");
    $installed = 'enabled';
  } else {
    $installed = $useTextUnidecode ? 'is not installed' : 'is disabled in config';
    mlog(0,"Text::Unidecode module $installed - unable to transliterate unicode characters to ASCII");
  }
  $ModuleList{'Text::Unidecode'} = $VerTextUnidecode.'/0.04';
  $ModuleStat{'Text::Unidecode'} = $installed;

  if ($CanUseWin32Unicode){
    $ver=eval('Win32::Unicode->VERSION'); $VerWin32Unicode=$ver; $ver=" version $ver" if $ver;
    if ($VerWin32Unicode <= '0.32' or $VerWin32Unicode >= '0.37') {
        $installed = 'enabled';
        if ( $^O eq 'MSWin32' ) {
            mlog(0,"Win32::Unicode module$ver installed - can write unicode filenames to OS");
            *{'Win32::Unicode::File::flush'} = *{'main::assp_flush'} unless defined *{'Win32::Unicode::File::flush'};
        }
    } else {
        disableUnicode();
        eval{${^WIDE_SYSTEM_CALLS} = 0;};
        $canUnicode = undef;
        eval('no Win32::Unicode;');
        $installed = 'disabled - version BUG';
        mlog(0,"Win32::Unicode module version $VerWin32Unicode is buggy and is disabled now - upgrade to at least version 0.37 - unable to write unicode filenames to OS") if ( $^O eq 'MSWin32' );
    }
  } else {
    $installed = $useWin32Unicode ? 'is not installed' : 'is disabled in config';
    mlog(0,"Win32::Unicode module $installed - unable to write unicode filenames to OS") if ( $^O eq 'MSWin32' );
  }
  $ModuleList{'Win32::Unicode'} = $VerWin32Unicode.'/0.28';
  $ModuleStat{'Win32::Unicode'} = $installed;

  if ($CanUseTieRDBM) {
    $ver=eval('Tie::RDBM->VERSION'); $VerTieRDBM=$ver; $ver=" version $ver" if $ver;
    mlog(0,"Tie::RDBM module$ver installed - database usage available");
    *{'Tie::RDBM::_update'}  = *{'main::rdbm_update'};
    *{'Tie::RDBM::_insert'}  = *{'main::rdbm_insert'};
    *{'Tie::RDBM::FETCH'}    = *{'main::rdbm_fetch'};
    *{'Tie::RDBM::DELETE'}   = *{'main::rdbm_delete'};
    *{'Tie::RDBM::FIRSTKEY'} = *{'main::rdbm_firstkey'};
    *{'Tie::RDBM::NEXTKEY'}  = *{'main::rdbm_nextkey'};
    *{'Tie::RDBM::CLEAR'}    = *{'main::rdbm_CLEAR'};
    *{'Tie::RDBM::STORE'}    = *{'main::rdbm_STORE'};
    *{'Tie::RDBM::EXISTS'}   = *{'main::rdbm_EXISTS'};
    *{'Tie::RDBM::DESTROY'}  = *{'main::rdbm_DESTROY'};
    *{'Tie::RDBM::SCALAR'}   = *{'main::rdbm_COUNT'};
    $installed = 'enabled';
  } elsif (!$AvailTieRDBM ) {
    $installed = $useTieRDBM ? 'is not installed' : 'is disabled in config';
    mlog(0,"Tie::RDBM module $installed - database usage not available");
  }
  $ModuleList{'Tie::RDBM'} = $VerTieRDBM.'/0.70';
  $ModuleStat{'Tie::RDBM'} = $installed;

  if ($CanUseDB_File) {
    $ver=eval('DB_File->VERSION'); $VerDB_File=$ver; $ver=" version $ver" if $ver;
    mlog(0,"DB_File module$ver installed - DB_File (Berkeley V1) database usage available");
    $installed = 'enabled';
  } elsif (!$AvailDB_File ) {
    $installed = $useDB_File ? 'is not installed' : 'is disabled in config';
    mlog(0,"DB_File module $installed - DB_File (Berkeley V1) database usage not available");
  }
  $ModuleList{'DB_File'} = $VerDB_File.'/1.816';
  $ModuleStat{'DB_File'} = $installed;

  my $BDBver;
  my $BDBverStr;
  if ($CanUseBerkeleyDB) {
    my $fail = 0;
    $ver=eval('BerkeleyDB->VERSION'); $VerBerkeleyDB=$ver; $ver=" version $ver" if $ver;
    $BDBver = eval('$BerkeleyDB::db_version;');
    $BDBverStr = eval('BerkeleyDB->DB_VERSION_STRING');
    if ($BDBver lt '4.5') {
        $AvailBerkeleyDB = $CanUseBerkeleyDB = 0;
        mlog(0,"warning: BerkeleyDB database version $BDBver / $BDBverStr installed - but at least version 4.5 is required - Berkeley database usage not available");
        $fail = 1;
        $installed = 'wrong engine version';
        $ModuleStat{'BerkeleyDB_DBEngine'} = $installed;
        $Config{clearBerkeleyDBEnv} = 1;
        $runHMMusesBDB = 0;
    }
    if ($VerBerkeleyDB lt '0.34') {
        $AvailBerkeleyDB = $CanUseBerkeleyDB = 0;
        mlog(0,"warning: BerkeleyDB module $ver installed - but at least version 0.34 is required - Berkeley database usage not available");
        $fail = 1;
        $installed = 'wrong module version';
        $Config{clearBerkeleyDBEnv} = 1;
        $runHMMusesBDB = 0;
    }
    if (! $fail) {
        mlog(0,"BerkeleyDB module$ver installed - Berkeley database usage available");
        mlog(0,"BerkeleyDB DB-version $BDBver / $BDBverStr is installed");
        $installed = 'enabled';
        $ModuleStat{'BerkeleyDB_DBEngine'} = $installed;
        if ($BDBverStr ne $Config{BerkeleyDB_DBEngine}) {
            $Config{clearBerkeleyDBEnv} = 1;
            $newConfig{BerkeleyDB_DBEngine} = $BDBverStr;
            $Config{BerkeleyDB_DBEngine} = $BDBverStr;
        }
        $ConfigAdd{BerkeleyDB_DBEngine} = $BDBverStr;
    }
  } elsif (!$AvailBerkeleyDB ) {
    $installed = $useBerkeleyDB ? 'is not installed' : 'is disabled in config';
    mlog(0,"BerkeleyDB module $installed - Berkeley database usage not available");
    $ModuleStat{'BerkeleyDB_DBEngine'} = 'status unknown';
    $Config{clearBerkeleyDBEnv} = 1;
    $runHMMusesBDB = 0;
  }
  $ModuleList{'BerkeleyDB'} = $VerBerkeleyDB.'/0.42';
  $ModuleStat{'BerkeleyDB'} = $installed;
  $ModuleList{'BerkeleyDB_DBEngine'} = $BDBver.'/4.5';
  print '.';

  if ($griplist) {
      if ($CanUseBerkeleyDB && $useDB4griplist) {
          $GriplistDriver = 'BerkeleyDB::Hash';
          $GriplistFile = "$base/$griplist.bdb";
          mlog(0,"info: griplist is using 'BerkeleyDB' version $BerkeleyDB::db_version in file $base/$griplist.bdb");
          if (! -e $GriplistFile) {
              unlink "$base/$griplist.bin";
          }
      } else {
          $GriplistDriver = 'orderedtie';
          $GriplistFile = "$base/$griplist";
          mlog(0,"info: griplist is using basic 'orderedtie' in file $base/$griplist");
      }
  }

  if (! $CanUseBerkeleyDB || ! $useDB4IntCache) {
      foreach (sort keys %tempDBvars) {
          next if $_ eq 'BackDNS2';
          share(%{$_});
      }
  }
  print '.';

  if ($CanUseCIDRlite) {
    $ver=eval('Net::CIDR::Lite->VERSION'); $VerNetCIDRLite=$ver; $ver=" version $ver" if $ver;
    mlog(0,"Net::CIDR::Lite module$ver installed - hyphenated IP address range available");
    $installed = 'enabled';
  } elsif (!$AvailCIDRlite) {
    $installed = $useNetCIDRLite ? 'is not installed' : 'is disabled in config';
    mlog(0,"Net::CIDR::Lite module $installed - hyphenated IP address range not available");
  }
  $ModuleList{'Net::CIDR::Lite'} = $VerNetCIDRLite.'/0.20';
  $ModuleStat{'Net::CIDR::Lite'} = $installed;

  if ($CanUseNetAddrIPLite) {
    $ver=eval('NetAddr::IP::Lite->VERSION'); $VerNetAddrIPLite=$ver; $ver=" version $ver" if $ver;
    mlog(0,"NetAddr::IP::Lite module$ver installed - hyphenated IP and CIDR address range calculation available");
    $installed = 'enabled';
  } elsif (!$AvailNetAddrIPLite) {
    $installed = $useNetAddrIPLite ? 'is not installed' : 'is disabled in config';
    mlog(0,"NetAddr::IP::Lite module $installed - hyphenated IP and CIDR address range calculation not available");
  }
  $ModuleList{'NetAddr::IP::Lite'} = $VerNetAddrIPLite.'/1.47';
  $ModuleStat{'NetAddr::IP::Lite'} = $installed;

  if ($CanUseNetIP) {
    $ver=eval('Net::IP->VERSION'); $VerNetIP=$ver; $ver=" version $ver" if $ver;
    mlog(0,"Net::IP module$ver installed - hyphenated IP and CIDR address range calculation available");
    $installed = 'enabled';
  } elsif (!$AvailNetIP) {
    $installed = $useNetIP ? 'is not installed' : 'is disabled in config';
    mlog(0,"Net::IP module $installed - hyphenated IP and CIDR address range calculation not available");
  }
  $ModuleList{'Net::IP'} = $VerNetAddrIPLite.'/1.26';
  $ModuleStat{'Net::IP'} = $installed;

  if ($CanUseLWP) {
    $ver=eval('LWP::Simple->VERSION'); $VerLWPSimple=$ver; $ver=" version $ver" if $ver;
    mlog(0,"LWP::Simple module$ver installed - procedural LWP interface available");
    $installed = 'enabled';
  } elsif (!$AvailLWP) {
    $installed = $useLWPSimple ? 'is not installed' : 'is disabled in config';
    mlog(0,"LWP::Simple module $installed - procedural LWP interface not available");
  }
  $ModuleList{'LWP::Simple'} = $VerLWPSimple.'/1.41';
  $ModuleStat{'LWP::Simple'} = $installed;

  if ($CanUseEMM) {
    $ver=eval('Email::MIME->VERSION'); $VerEmailMIME=$ver; $ver=" version $ver" if $ver;
    mlog(0,"Email::MIME module$ver installed - MIME charset decoding and conversion interface and attachment detection available");
    $installed = 'enabled';
    $org_Email_MIME_parts_multipart = *{'Email::MIME::parts_multipart'};
    *{'Email::MIME::parts_multipart'} = *{'main::parts_multipart'};
    *{'Email::MIME::ContentType::_extract_ct_attribute_value'} = *{'assp_extract_ct_attribute_value'};
    *{'Email::MIME::ContentType::_parse_attributes'} = *{'assp_parse_attributes'};
  } elsif (!$AvailEMM) {
    $installed = $useEmailMIME ? 'is not installed' : 'is disabled in config';
    mlog(0,"Email::MIME module $installed - MIME charset decoding and conversion interface and attachment detection not available");
  }
  $ModuleList{'Email::MIME'} = $VerEmailMIME.'/1.442';
  $ModuleStat{'Email::MIME'} = $installed;

  if ($CanUseMTY) {
    $ver=eval('MIME::Types->VERSION'); $VerMIMETypes=$ver; $ver=" version $ver" if $ver;
    mlog(0,"MIME::Types module$ver installed - TNEF conversion may possible");
    $installed = 'enabled';
  } elsif (!$AvailMTY) {
    $installed = $useMIMETypes ? 'is not installed' : 'is disabled in config';
    mlog(0,"MIME::Types module $installed - TNEF conversion not available");
  }
  $ModuleList{'MIME::Types'} = $VerMIMETypes.'/1.23';
  $ModuleStat{'MIME::Types'} = $installed;
  print '.';

  if ($CanUseEMS) {
    $ver=eval('Email::Send->VERSION'); $VerEmailSend=$ver; $ver=" version $ver" if $ver;
    mlog(0,"Email::Send module$ver installed - sending .eml files available");
    $installed = 'enabled';
  } elsif (!$AvailEMS) {
    $installed = $useEmailSend ? 'is not installed' : 'is disabled in config';
    mlog(0,"Email::Send module $installed - sending .eml files is not available");
  }
  $ModuleList{'Email::Send'} = $VerEmailSend.'/2.192';
  $ModuleStat{'Email::Send'} = $installed;

  if ($CanUseTNEF) {
    $ver=eval('Convert::TNEF->VERSION'); $VerConvertTNEF=$ver; $ver=" version $ver" if $ver;
    mlog(0,"Convert::TNEF module$ver installed - TNEF conversion is available");
    $installed = 'enabled';
  } elsif (!$AvailTNEF)  {
    $installed = $useConvertTNEF ? 'is not installed' : 'is disabled in config';
    mlog(0,"Convert::TNEF module $installed - TNEF conversion not available");
  }
  $ModuleList{'Convert::TNEF'} = $VerConvertTNEF.'/0.17';
  $ModuleStat{'Convert::TNEF'} = $installed;

  if ($CanUseDKIM) {
    $ver=eval('Mail::DKIM::Verifier->VERSION'); $VerMailDKIMVerifier=$ver; $ver=" version $ver" if $ver;
    mlog(0,"Mail::DKIM::Verifier module$ver installed - DKIM verification is available");
    $installed = 'enabled';
    if ($ver lt '0.40') {   # the DNS resolver issue is fixed in 0.40
        *{'Mail::DKIM::DNS::query'} = *{'main::DKIM_DNS_query'};
        *{'Mail::DKIM::DNS::query_async'} = *{'main::DKIM_DNS_query_async'};
    }
  } elsif (!$AvailDKIM)  {
    $installed = $useMailDKIMVerifier ? 'is not installed' : 'is disabled in config';
    mlog(0,"Mail::DKIM::Verifier module $installed - DKIM verification not available");
  }
  $ModuleList{'Mail::DKIM::Verifier'} = $VerMailDKIMVerifier.'/0.37';
  $ModuleStat{'Mail::DKIM::Verifier'} = $installed;

  if ($CanUseSchedCron) {
    $ver=eval('Schedule::Cron->VERSION'); $VerScheduleCron=$ver; $ver=" version $ver" if $ver;
    mlog(0,"Schedule::Cron module$ver installed - RebuildSpamdb Scheduler is available");
    $installed = 'enabled';
  } elsif (!$AvailSchedCron)  {
    $installed = $useScheduleCron ? 'is not installed' : 'is disabled in config';
    mlog(0,"Schedule::Cron module $installed - RebuildSpamdb Scheduler not available");
  }
  $ModuleList{'Schedule::Cron'} = $VerScheduleCron.'/0.97';
  $ModuleStat{'Schedule::Cron'} = $installed;

  if ($CanUseSysMemInfo) {
    $ver=eval('Sys::MemInfo->VERSION'); $VerSysMemInfo=$ver; $ver=" version $ver" if $ver;
    mlog(0,"Sys::MemInfo module$ver installed - memory calculation is available");
    $installed = 'enabled';
  } elsif (!$AvailSysMemInfo)  {
    $installed = $useSysMemInfo ? 'is not installed' : 'is disabled in config';
    mlog(0,"Sys::MemInfo module $installed - memory calculation not available");
  }
  $ModuleList{'Sys::MemInfo'} = $VerSysMemInfo.'/0.91';
  $ModuleStat{'Sys::MemInfo'} = $installed;

  if ($CanUseSysCpuAffinity) {
    $ver=eval('Sys::CpuAffinity->VERSION'); $VerSysCpuAffinity=$ver; $ver=" version $ver" if $ver;
    eval{$numcpus = Sys::CpuAffinity::getNumCpus();};
    $numcpus ||= 'an undected number of';
    mlog(0,"Sys::CpuAffinity module$ver installed - setting CPU Affinty is available - this system has $numcpus CPU\'s");
    eval{@currentCpuAffinity = Sys::CpuAffinity::getAffinity($$)};
    mlog(0,"The Cpu Affinity of assp is currently '@currentCpuAffinity'");
    $installed = 'enabled';
  } elsif (!$AvailSysCpuAffinity)  {
    $installed = $useSysCpuAffinity ? 'is not installed' : 'is disabled in config';
    mlog(0,"Sys::CpuAffinity module $installed - setting CPU Affinty not available");
  }
  $ModuleList{'Sys::CpuAffinity'} = $VerSysCpuAffinity.'/1.05';
  $ModuleStat{'Sys::CpuAffinity'} = $installed;

  print '.';

  if ($CanUseAuthenSASL) {
    $ver=eval('Authen::SASL->VERSION'); $VerAuthenSASL=$ver; $ver=" version $ver" if $ver;
    mlog(0,"Authen::SASL module$ver installed - SMTP AUTH is available");
    $installed = 'enabled';
  } elsif (!$AvailAuthenSASL)  {
    $installed = $useAuthenSASL ? 'is not installed' : 'is disabled in config';
    mlog(0,"Authen::SASL module $installed - SMTP AUTH is not available");
  }
  $ModuleList{'Authen::SASL'} = $VerAuthenSASL.'/2.1401';
  $ModuleStat{'Authen::SASL'} = $installed;

  if ($CanUseRegexpOptimizer) {
    $ver=eval('Regexp::Optimizer->VERSION'); $VerRegexpOptimizer=$ver; $ver=" version $ver" if $ver;
    if ($VerRegexpOptimizer ge '0.23') {
        mlog(0,"Regexp::Optimizer module$ver installed - default Regular Expression Optimization is available");
        $installed = 'enabled';
    } else {
        $CanUseRegexpOptimizer = $AvailRegexpOptimizer = 0;
        $installed = "with wrong version ($VerRegexpOptimizer) installed (requires 0.23)";
        mlog(0,"Regexp::Optimizer module $installed - default Regular Expression Optimization is not available - regex processing will take approximately 3 times longer");
    }
  } elsif (!$AvailRegexpOptimizer)  {
    $installed = $useRegexpOptimizer ? 'is not installed' : 'is disabled in config';
    mlog(0,"Regexp::Optimizer module $installed - default Regular Expression Optimization is not available - regex processing will take  approximately 3 times longer");
  }
  $ModuleList{'Regexp::Optimizer'} = $VerRegexpOptimizer.'/0.23';
  $ModuleStat{'Regexp::Optimizer'} = $installed;

  if ($CanUseRegexOptimizer) {
    $ver=eval('Regex::Optimizer->VERSION'); $VerRegexOptimizer=$ver; $ver=" version $ver" if $ver;
    if ($VerRegexOptimizer ge '1.12') {
        mlog(0,"Regex::Optimizer module$ver installed - enhanced Regular Expression Optimization is available - Regexp::Optimizer is now switched off");
        $installed = 'enabled';
        eval('no Regexp::Optimizer;');
        $ModuleStat{'Regexp::Optimizer'} .= ' (switched off)' if $ModuleStat{'Regexp::Optimizer'} eq 'enabled';
    } else {
        $CanUseRegexOptimizer = $AvailRegexOptimizer = 0;
        $installed = "with wrong version ($VerRegexOptimizer) installed (requires at least 1.12)";
        mlog(0,"Regex::Optimizer module $installed - enhanced Regular Expression Optimization is not available - regex processing will take approximately 6 times longer");
    }
  } elsif (!$AvailRegexOptimizer)  {
    $installed = $useRegexOptimizer ? 'is not installed' : 'is disabled in config';
    mlog(0,"Regex::Optimizer module $installed - enhanced Regular Expression Optimization is not available - regex processing will take approximately 6 times longer");
  }
  $ModuleList{'Regex::Optimizer'} = $VerRegexOptimizer.'/1.12';
  $ModuleStat{'Regex::Optimizer'} = $installed;

  if ($CanUseAsspSelfLoader) {
    $ver=eval('AsspSelfLoader->VERSION'); $VerAsspSelfLoader=$ver; $ver=" version $ver" if $ver;
    mlog(0,"AsspSelfLoader module$ver installed - ASSP Code Load Optimization is available");
    $installed = 'enabled';
  } elsif (!$AvailAsspSelfLoader)  {
    $installed = $useAsspSelfLoader ? 'is not installed' : 'is disabled in config';
    mlog(0,"AsspSelfLoader module $installed - ASSP Code Load Optimization is not available");
  }
  $ModuleList{'AsspSelfLoader'} = $VerAsspSelfLoader.'/'.$requiredSelfLoaderVersion;
  $ModuleStat{'AsspSelfLoader'} = $installed;

  if ($CanUseASSP_WordStem) {
    $ver=eval('ASSP_WordStem->VERSION'); $VerASSP_WordStem=$ver; $ver=" version $ver" if $ver;
    mlog(0,"ASSP_WordStem module$ver installed - ASSP multi lingual word stemming engine for Bayesian and HMM checks is available");
    $installed = 'enabled';
    $requiredDBVersion{'Spamdb'} .= '_WordStem';
    $requiredDBVersion{'HMMdb'}  .= '_WordStem';
    # make Lingua::Stem::Snowball thread safe if it is'nt
    if (! defined *{'Lingua::Stem::Snowball::CLONE_SKIP'}) {
        *{'Lingua::Stem::Snowball::CLONE_SKIP'} = *{'main::Stem_Clone_Skip'};
    }
    if (! defined *{'Lingua::Stem::Snowball::CLONE'}) {
        *{'Lingua::Stem::Snowball::CLONE'} = *{'main::Stem_Clone'};
    }
  } elsif (!$AvailASSP_WordStem)  {
    $installed = $useASSP_WordStem ? 'is not installed' : 'is disabled in config';
    mlog(0,"ASSP_WordStem module $installed - ASSP multi lingual word stemming engine for Bayesian and HMM checks is not available");
  }
  $ModuleList{'ASSP_WordStem'} = $VerASSP_WordStem.'/1.23';
  $ModuleStat{'ASSP_WordStem'} = $installed;

  if ($CanUseASSP_FC) {
    $ver=eval('ASSP_FC->VERSION'); $VerASSP_FC=$ver; $ver=" version $ver" if $ver;
    mlog(0,"ASSP_FC module$ver installed - ASSP file commander is available");
    $installed = 'enabled';
  } elsif (!$AvailASSP_FC)  {
    $installed = $useASSP_FC ? 'is not installed' : 'is disabled in config';
    mlog(0,"ASSP_FC module $installed - ASSP file commander is not available");
  }
  $ModuleList{'ASSP_FC'} = $VerASSP_FC.'/1.04';
  $ModuleStat{'ASSP_FC'} = $installed;

  if ($CanUseASSP_SVG) {
    $ver=eval('ASSP_SVG->VERSION'); $VerASSP_SVG=$ver; $ver=" version $ver" if $ver;
    mlog(0,"ASSP_SVG module$ver installed - ASSP graphical STATS are available");
    $installed = 'enabled';
  } elsif (!$AvailASSP_SVG)  {
    $installed = $useASSP_SVG ? 'is not installed' : 'is disabled in config';
    mlog(0,"ASSP_SVG module $installed - ASSP graphical STATS are not available");
  }
  $ModuleList{'ASSP_SVG'} = $VerASSP_SVG.'/1.02';
  $ModuleStat{'ASSP_SVG'} = $installed;

  if ($CanUseIOSocketSSL) {
    $ver=eval('IO::Socket::SSL->VERSION'); $VerIOSocketSSL=$ver; $ver=" version $ver" if $ver;
    mlog(0,"IO::Socket::SSL module$ver installed - https and TLS/SSL is possible");
    mlog(0,"IO::Socket::SSL module$ver installed - but at least version 1.32 is recommended")
        if ($VerIOSocketSSL < '1.32');
    $installed = 'enabled';
    $ModuleList{'Net::SSLeay'} = (eval('Net::SSLeay->VERSION')).'/1.35';
    $ModuleStat{'Net::SSLeay'} = $installed;
    if (-e $SSLCertFile and -e $SSLKeyFile) {
        mlog(0,'found valid certificate and private key file - https and TLS/SSL is available');
        mlog(0,'found valid ca file - chained certificate validation is available') if $SSLCaFile && -e $SSLCaFile;
    } else {
        if (system('openssl', 'version') == 0) {
            mlog(0,'info: openssl is installed - try to create basic SSL-certificates');
            &genCerts;
        } else {
            mlog(0,'info: openssl is not installed on this system - unable to create basic certificates');
        }
        if (-e $SSLCertFile and -e $SSLKeyFile) {
            mlog(0,'found valid certificate and private key file - https and TLS/SSL is available');
            mlog(0,'found valid ca file - chained certificate validation is available') if $SSLCaFile && -e $SSLCaFile;
        } else {
            $CanUseIOSocketSSL = 0;
            mlog(0,"warning: server certificate $SSLCertFile not found") unless (-e $SSLCertFile);
            mlog(0,"warning: server public-key $SSLKeyFile not found") unless (-e $SSLKeyFile);
            mlog(0,'warning: https and TLS/SSL is disabled');
            $installed = 'no certificate found';
        }
    }
  } elsif (!$AvailIOSocketSSL)  {
    $installed = $useIOSocketSSL ? 'is not installed' : 'is disabled in config';
    mlog(0,"IO::Socket::SSL module $installed - https and TLS/SSL not available");
  }
  $ModuleList{'IO::Socket::SSL'} = $VerIOSocketSSL.'/1.32';
  $ModuleStat{'IO::Socket::SSL'} = $installed;

  my $v;
  $ModuleList{'Plugins::ASSP_AFC'}   =~ s/([0-9\.\-\_]+)$/$v=3.06;$1>$v?$1:$v;/oe if exists $ModuleList{'Plugins::ASSP_AFC'};
  $ModuleList{'Plugins::ASSP_ARC'}   =~ s/([0-9\.\-\_]+)$/$v=2.05;$1>$v?$1:$v;/oe if exists $ModuleList{'Plugins::ASSP_ARC'};
  $ModuleList{'Plugins::ASSP_DCC'}   =~ s/([0-9\.\-\_]+)$/$v=2.01;$1>$v?$1:$v;/oe if exists $ModuleList{'Plugins::ASSP_DCC'};
  $ModuleList{'Plugins::ASSP_OCR'}   =~ s/([0-9\.\-\_]+)$/$v=2.16;$1>$v?$1:$v;/oe if exists $ModuleList{'Plugins::ASSP_OCR'};
  $ModuleList{'Plugins::ASSP_Razor'} =~ s/([0-9\.\-\_]+)$/$v=1.09;$1>$v?$1:$v;/oe if exists $ModuleList{'Plugins::ASSP_Razor'};

  if (scalar keys %ModuleError) {
      mlog(0,"warning: There were module load errors detected - look in to file $base/moduleLoadErrors.txt for more details. To solve this issue install the failed modules or disable them in the 'Module Setup' section in the GUI.");
  }
  print '.';

  $tThreadHandler{1} = \&NewSMTPConnectionConnect;     # set subs to numbers / subs-refs can not be shared
  $tThreadHandler{2} = \&NewProxyConnection;    # so the tread will know what to do

# are we using any database tables?
  $DBisUsed = 0;
  for my $idx (0...$#ConfigArray) {
    my $c = $ConfigArray[$idx];
    if ($Config{$c->[0]}=~/DB:/o && ($CanUseTieRDBM or $CanUseBerkeleyDB)) {
      $DBisUsed = 1;
      last;
    }
  }

  $nextNoop=time;
  $endtime=$nextNoop+$RestartEvery;

  loadHashFromFile( "$base/scheduleHistory", \%LastSchedRun );
  ScheduleMapSet();
  $NextSaveStats = max($NextSaveStats, (time + 300));

  if ($backupDBInterval && ! isSched($backupDBInterval) && $backupDBDir && -d "$base/$backupDBDir") {
    my $mtime = ftime("$base/$backupDBDir");
    if ($mtime) {
        my $m = &getTimeDiff(time - $mtime);
        mlog(0,"info: last DB-backup was scheduled before $m") if ($DBisUsed && $MaintenanceLog);
        $nextDBBackup=$mtime+$backupDBInterval*3600;
        $nextDBBackup = time + 300 if ($nextDBBackup - time < 300);
        $m = &getTimeDiff($nextDBBackup - time);
        mlog(0,"info: next DB-backup is scheduled in $m") if ($DBisUsed && $MaintenanceLog);
    }
  }
  $nextDBcheck=$nextNoop+30; # check DB connection every 30 seconds
  $nextThreadsWakeUp=$nextNoop+$ThreadsWakeUpInterval;
  $nextCleanBATVTag=$nextNoop + 3600;
  $nextConSync = $nextNoop + 60;
  $nextResendMail = $nextNoop + 300;
  $nextRebuildSpamDB = isSched($RebuildSchedule) ? getSchedTime('RebuildSchedule') : 0;
  $nextDNSCheck = $nextNoop + 60;
  $nextCleanIPDom = $nextNoop + 300;
  $nextBDBsync = $nextNoop + 900;
  $nextdetectHourJob = int($nextNoop / 3600) * 3600 + 3600;
  $nextdetectHourJob += 15 unless ($nextdetectHourJob + $TimeZoneDiff) % (24 * 3600);
  my $m = &getTimeDiff($nextdetectHourJob-$nextNoop);
  mlog(0,"info: hourly scheduler is starting in $m") if $MaintenanceLog >=2;

  chmod 0755, "$base/assp.cfg";

  print "\t\t\t\t[OK]\nchecking directories";
# create folders if they're missing
  -d "$base/$spamlog" or mkdir "$base/$spamlog",0755;
  -d "$base/$notspamlog" or mkdir "$base/$notspamlog",0755;
  -d "$base/$incomingOkMail" or mkdir "$base/$incomingOkMail", 0755;
  -d "$base/$discarded"  or mkdir "$base/$discarded",  0755;
  -d "$base/files" or mkdir "$base/files",0755;
  -d "$base/logs" or mkdir "$base/logs",0755;
  
  -d "$base/rebuild_error" or mkdir "$main::base/rebuild_error", 0755;
  -d "$base/rebuild_error/$spamlog" or mkdir "$base/rebuild_error/$spamlog", 0755;
  -d "$base/rebuild_error/$notspamlog" or mkdir "$base/rebuild_error/$notspamlog", 0755;
  my $dir=$correctedspam;
  $dir=~s/\/.*?$//o;
  -d "$base/$dir" or mkdir "$base/$dir",0755;
  -d "$base/$correctedspam" or mkdir "$base/$correctedspam",0755;
  -d "$base/$correctedspam/newManualyAdded" or mkdir "$base/$correctedspam/newManualyAdded",0755;
  -d "$base/rebuild_error/$dir" or mkdir "$base/rebuild_error/$dir", 0755;
  -d "$base/rebuild_error/$correctedspam" or mkdir "$base/rebuild_error/$correctedspam", 0755;
  $dir=$correctednotspam;
  $dir=~s/\/.*?$//o;
  -d "$base/$dir" or mkdir "$base/$dir",0755;
  -d "$base/$correctednotspam" or mkdir "$base/$correctednotspam",0755;
  -d "$base/$correctednotspam/newManualyAdded" or mkdir "$base/$correctednotspam/newManualyAdded",0755;
  -d "$base/rebuild_error/$dir" or mkdir "$base/rebuild_error/$dir", 0755;
  -d "$base/rebuild_error/$correctednotspam" or mkdir "$base/rebuild_error/$correctednotspam", 0755;

  -d "$base/$resendmail" or mkdir "$base/$resendmail",0755;
  $pbdir = $1 if $pbdb=~/(.*)\/.*/o;
  $pbdir = 'pb' if $pbdb =~ /DB:/o;
  if ($pbdir) {
     -d  "$base/$pbdir" or mkdir "$base/$pbdir",0755;
     -d  "$base/$pbdir/global" or mkdir "$base/$pbdir/global",0755;
     -d  "$base/$pbdir/global/in" or mkdir "$base/$pbdir/global/in",0755;
     -d  "$base/$pbdir/global/out" or mkdir "$base/$pbdir/global/out",0755;
  }
  -d "$base/notes" or mkdir "$base/notes",0755;
  -d "$base/docs" or mkdir "$base/docs",0755;
  my $mysqldir; $mysqldir = $1 if $importDBDir=~/(.*)\/.*/o;
  mkdir "$base/$mysqldir",0755 if $mysqldir;
  -d "$base/$importDBDir" or mkdir "$base/$importDBDir",0755;
  $mysqldir = $1 if $exportDBDir=~/(.*)\/.*/o;
  mkdir "$base/$mysqldir",0755 if $mysqldir;
  -d "$base/$exportDBDir" or mkdir "$base/$exportDBDir",0755;
  $mysqldir = $1 if $backupDBDir=~/(.*)\/.*/o;
  mkdir "$base/$mysqldir",0755 if $mysqldir;
  -d "$base/$backupDBDir" or mkdir "$base/$backupDBDir",0755;
  -d "$base/dkim" or mkdir "$base/dkim",0755;
  -d "$FileScanDir" or mkdir "$FileScanDir",0755;
  -d "$base/Plugins" or mkdir "$base/Plugins",0777;
  -d "$base/tmp" or mkdir "$base/tmp",0755;
  -d "$base/tmpDB" or mkdir "$base/tmpDB",0755;
  -d "$base/crash_repo" or mkdir "$base/crash_repo",0755;
  -d "$base/debug" or mkdir "$base/debug",0755;

  foreach my $file ( Glob("$base/tmp/*")) {
      mlog(0,"info: deleted temporary file $file") if unlink($file) && $MaintenanceLog > 1;
  }

  my $unclean = (exists $Config{clearBerkeleyDBEnv} || -e "$base/$pidfile");
  mlog(0,'error: unclean shutdown of ASSP detected') if $unclean;
  foreach my $dir ( Glob("$base/tmpDB/*")) {
      if (-d $dir) {
          my $del;
          foreach my $f ( Glob("$dir/*")) {
             if ($f =~ /\.00\d$/o) {
                 $del = 1;
                 unlink($f) || mlog(0,"error: unable to cleanup $f - $!");
             } elsif ($f =~ /\.bdb$/io && ($f !~ /BackDNS2|rebuildDB/o || $unclean) ) {
                 $del = 1;
                 unlink($f) || mlog(0,"error: unable to cleanup $f - $!");
             }
          }
          mlog(0,"info: cleaned temporary BerkeleyDB directory $dir") if $del && $unclean;
      }
  }
  if ($useDB4griplist && $unclean) {
      foreach ( Glob("$base/griplist.*")) {
          next if (-d "$_");
          mlog(0,"info: removed GRIPLIST file $_") if unlink($_);
      }
  }
  delete $Config{clearBerkeleyDBEnv};
  &SaveConfig() if $unclean;

  if($pidfile) {open(my $PIDH,'>',"$base/$pidfile"); $PIDH->autoflush; print $PIDH $$; close $PIDH}

  if ($^O ne 'MSWin32') {
      if($setFilePermOnStart) {
          print "\t\t\t\t\t[OK]\nsetup file permission" ;
          &setPermission($base,oct('0777'),1,1) ;
          $Config{setFilePermOnStart} = '';
          $setFilePermOnStart = '';
          &SaveConfig();
      } elsif ($checkFilePermOnStart) {
          print "\t\t\t\t\t[OK]\ncheck file permission" ;
          &checkPermission($base,oct('0600'),1,1) ;
      }
  } else {
      if($setFilePermOnStart) {
          print "\t\t\t\t\t[OK]\nskip file permission" ;
          $Config{setFilePermOnStart} = $setFilePermOnStart = '';
      } elsif ($checkFilePermOnStart) {
          print "\t\t\t\t\t[OK]\nskip file permission" ;
          $Config{checkFilePermOnStart} = $checkFilePermOnStart = '';
      }
  }

  $nextGlobalUploadBlack = $nextNoop + 120;
  $nextGlobalUploadWhite = $nextNoop + 120;
  if (-e "$base/$pbdir/global/out/pbdb.black.db.gz") {
    my $mtime = ftime("$base/$pbdir/global/out/pbdb.black.db.gz");
    my $m = &getTimeDiff(time - $mtime);
    mlog(0,"info: last PBBlack upload to global server was scheduled before $m") if ($DoGlobalBlack && $globalClientName && $globalClientPass && $MaintenanceLog);
    if ($mtime) {
        $nextGlobalUploadBlack=$mtime + (int(rand(300) + 1440))*60;
        my $m = &getTimeDiff($nextGlobalUploadBlack - time);
        mlog(0,"info: next PBBlack upload to global server is scheduled in $m") if ($DoGlobalBlack && $globalClientName && $globalClientPass && $MaintenanceLog);
    }
  }
  if (-e "$base/$pbdir/global/out/pbdb.white.db.gz") {
    my $mtime = ftime("$base/$pbdir/global/out/pbdb.white.db.gz");
    my $m = &getTimeDiff(time - $mtime);
    mlog(0,"info: last PBWhite upload to global server was scheduled before $m") if ($DoGlobalBlack && $globalClientName && $globalClientPass && $MaintenanceLog);
    if ($mtime) {
        $nextGlobalUploadWhite=$mtime + (int(rand(300) + 1440))*60 if ($mtime);
        my $m = &getTimeDiff($nextGlobalUploadWhite - time);
        mlog(0,"info: next PBWhite upload to global server is scheduled in $m") if ($DoGlobalWhite && $globalClientName && $globalClientPass && $MaintenanceLog);
    }
  }

 # is any database driver defined - so we have to parse the driver and the options
  if ($DBdriver && ($CanUseTieRDBM or $CanUseBerkeleyDB)) {
    @DBdriverdef = split(/,/o,$DBdriver);
    $DBusedDriver = $DBdriverdef[0];
    $DBcntOption = @DBdriverdef;
    for (my $i=1;$i<$DBcntOption;$i++) {
      if ($DBusedDriver eq 'BerkeleyDB') {
          $DBOption.=',' if ($i > 1);
          $DBOption.="$DBdriverdef[$i]"  # putting all optons in to
      } else {
          $DBOption.=";$DBdriverdef[$i]"  # putting all optons in to
      }
      $DBautocommit = 0 if ($DBdriverdef[$i] =~ /^\s*autocommit\s*=>?\s*0\s*$/oi);
    }
    mlog(0,"info: the DBI connection string is set to: 'DBI:$DBusedDriver:database=$mydb;host=$myhost$DBOption'") if ($DBusedDriver ne 'BerkeleyDB');
    if ($DBusedDriver eq 'BerkeleyDB') {
        $runHMMusesBDB = 0;
    } else {
        mlog(0,"info: 'autocommit' is switched off for the '$DBusedDriver' database driver") unless $DBautocommit;
    }
  }

#define Cache- and List groups - so have to care about only here
  @GroupList=("whitelistGroup","PersBlackGroup","redlistGroup","delayGroup","pbdbGroup","spamdbGroup","LDAPGroup","AdminGroup");

  my $v;
# $v =  "KeyName   ,dbConfigVar,CacheObject     ,realFileName  ,mysqlFileName,FailoverValue,mysqlTable"); remove spaces and push to Group
#                                                                                                         for dbConfigVar
  $v = ("Whitelist ,whitelistdb,WhitelistObject ,$whitelistdb  ,whitelist    ,whitelist  ,whitelist"   ); $v=~s/\s*,/,/go; push(@whitelistGroup,$v);

  $v = ("Redlist   ,redlistdb  ,RedlistObject   ,$redlistdb    ,redlist      ,redlist    ,redlist"     ); $v=~s/\s*,/,/go; push(@redlistGroup,$v);

  $v = ("Delay     ,delaydb    ,DelayObject     ,$delaydb      ,delaydb      ,delaydb    ,delaydb"     ); $v=~s/\s*,/,/go; push(@delayGroup,$v);
  $v = ("DelayWhite,delaydb    ,DelayWhiteObject,$delaydb.white,delaydb.white,delaydb    ,delaywhitedb"); $v=~s/\s*,/,/go; push(@delayGroup,$v);

  $v = ("Spamdb    ,spamdb     ,SpamdbObject    ,$spamdb       ,spamdb       ,spamdb     ,spamdb"      ); $v=~s/\s*,/,/go; push(@spamdbGroup,$v);
  $v = ("HeloBlack ,spamdb     ,HeloBlackObject ,$spamdb.helo  ,spamdb.helo  ,spamdb     ,spamdbhelo"  ); $v=~s/\s*,/,/go; push(@spamdbGroup,$v);

  if (! $runHMMusesBDB || ! $CanUseBerkeleyDB) {
      $v = ("HMMdb ,spamdb     ,HMMdbObject    ,HMMdb          ,HMMdb        ,spamdb     ,hmmdb"      ); $v=~s/\s*,/,/go; push(@spamdbGroup,$v);
      delete $tempDBvars{HMMdb};
  }
  
  $v = ("PBWhite   ,pbdb       ,PBWhiteObject   ,$pbdb.white.db,pbdb.white.db,pb/pbdb    ,PBWhite"     ); $v=~s/\s*,/,/go; push(@pbdbGroup,$v);
  $v = ("PBBlack   ,pbdb       ,PBBlackObject   ,$pbdb.black.db,pbdb.black.db,pb/pbdb    ,PBBlack"     ); $v=~s/\s*,/,/go; push(@pbdbGroup,$v);
  $v = ("RBLCache  ,pbdb       ,RBLCacheObject  ,$pbdb.rbl.db  ,pbdb.rbl.db  ,pb/pbdb    ,RBLCache"    ); $v=~s/\s*,/,/go; push(@pbdbGroup,$v);
  $v = ("URIBLCache,pbdb       ,URIBLCacheObject,$pbdb.uribl.db,pbdb.uribl.db,pb/pbdb    ,URIBLCache"  ); $v=~s/\s*,/,/go; push(@pbdbGroup,$v);
  $v = ("PTRCache  ,pbdb       ,PTRCacheObject  ,$pbdb.ptr.db  ,pbdb.ptr.db  ,pb/pbdb    ,PTRCache"    ); $v=~s/\s*,/,/go; push(@pbdbGroup,$v);
  $v = ("MXACache  ,pbdb       ,MXACacheObject  ,$pbdb.mxa.db  ,pbdb.mxa.db  ,pb/pbdb    ,MXACache"    ); $v=~s/\s*,/,/go; push(@pbdbGroup,$v);
  $v = ("RWLCache  ,pbdb       ,RWLCacheObject  ,$pbdb.rwl.db  ,pbdb.rwl.db  ,pb/pbdb    ,RWLCache"    ); $v=~s/\s*,/,/go; push(@pbdbGroup,$v);
  $v = ("SPFCache  ,pbdb       ,SPFCacheObject  ,$pbdb.spf.db  ,pbdb.spf.db  ,pb/pbdb    ,SPFCache"    ); $v=~s/\s*,/,/go; push(@pbdbGroup,$v);
  $v = ("SBCache   ,pbdb       ,SBCacheObject   ,$pbdb.sb.db   ,pbdb.sb.db   ,pb/pbdb    ,SBCache"     ); $v=~s/\s*,/,/go; push(@pbdbGroup,$v);
  $v = ("PBTrap    ,pbdb       ,PBTrapObject    ,$pbdb.trap.db ,pbdb.trap.db ,pb/pbdb    ,PBTrap"      ); $v=~s/\s*,/,/go; push(@pbdbGroup,$v);
  $v = ("DKIMCache ,pbdb       ,DKIMCacheObject ,$pbdb.dkim.db ,pbdb.dkim.db ,pb/pbdb    ,DKIMCache"   ); $v=~s/\s*,/,/go; push(@pbdbGroup,$v);
  $v = ("BATVTag   ,pbdb       ,BATVTagObject   ,$pbdb.batv.db ,pbdb.batv.db ,pb/pbdb    ,BATVTag"     ); $v=~s/\s*,/,/go; push(@pbdbGroup,$v);
  $v = ("BackDNS   ,pbdb       ,BackDNSObject   ,$pbdb.back.db ,pbdb.back.db ,pb/pbdb    ,BackDNS"     ); $v=~s/\s*,/,/go; push(@pbdbGroup,$v);

  $v = ("PersBlack ,persblackdb,PersBlackObject ,$persblackdb  ,persblack    ,persblack  ,persblack"   ); $v=~s/\s*,/,/go; push(@PersBlackGroup,$v);

  $v = ("LDAPlist  ,ldaplistdb ,LDAPlistObject  ,$ldaplistdb   ,ldaplist     ,ldaplist   ,ldaplist"    ); $v=~s/\s*,/,/go; push(@LDAPGroup,$v);

  $v = ("AdminUsers,adminusersdb ,AdminUsersObject,$adminusersdb   ,adminusers   ,adminusers ,AdminUsers"  ); $v=~s/\s*,/,/go; push(@AdminGroup,$v);
  $v = ("AdminUsersRight,adminusersdb,AdminUsersRightObject,$adminusersdb.right,adminusers.right,adminusers,AdminUsersRight"   ); $v=~s/\s*,/,/go; push(@AdminGroup,$v);
# %Types is defined by Tie::RDBM -> we redefine the datatypes for the key field of some drivers
# For better support of the key field with different charsets defined by the DB - the key field should
# be a varbinary type  -  some databases skipping leading and/or trailing spaces in char and varchar fields
# which cause in unexpected or missing keys in spamdb
# for MySQL the field value is redefined from longblob to varbinary(255) - so we can read the data in MySQL-Admin
# the lenght of the key field is set to 254 for all - to have one byte over for indexes (see Informix)
# the lenght of the value field is set to 255 for all - this is enough for ASSP

if ($CanUseTieRDBM) {
# %Types is used for creating the data table if it doesn't exist already.
  %Tie::RDBM::Types = (   # key            value            frozen    freeze  keyless
	  'default' => [qw/ varbinary(254)  varbinary(255)   integer   0          0 /],  #others
	  'mysql'   => [qw/ varbinary(254)  varbinary(255)   tinyint   1          0 /],
	  'mSQL'    => [qw/ char(254)       char(255)        int       0          0 /],
      'MSSQL'   => [qw/ varchar(254)    varchar(255)     int       1          0 /],
      'Pg'      => [qw/ varchar(254)    varchar(255)     int       1          0 /],
      'PgPP'    => [qw/ varchar(254)    varchar(255)     int       1          0 /],
      'Sybase'  => [qw/ varbinary(254)  varbinary(255)   tinyint   1          0 /],
	  'Oracle'  => [qw/ varchar(254)    varchar(255)     integer   1          0 /],
	  'CSV'     => [qw/ varchar(254)    varchar(255)     integer   1          1 /],  # should never be used by ASSP
	  'Informix'=> [qw/ nchar(254)      nchar(255)       integer   0          0 /],
	  'Solid'   => [qw/ varbinary(254)  varbinary(255)   integer   1          0 /],
	  'ODBC'    => [qw/ varbinary(254)  varbinary(255)   integer   1          0 /],
      'ADO'     => [qw/ varchar(254)    varchar(255)     int       1          0 /],
      'Firebird'=> [qw/ char(254)       char(255)        integer   1          0 /],
	  'DB2'     => ["varchar(254) not null","varchar(255)","integer",1,0],
	  );

  $Tie::RDBM::CAN_BIND{DB2} = 1;
  $Tie::RDBM::CAN_BIND{ADO} = 1;
  $Tie::RDBM::CAN_BIND{MSSQL} = 1;
  $Tie::RDBM::CAN_BIND{PgPP} = 1;
  $Tie::RDBM::CAN_BIND{Firebird} = 1;

  if (($DBusedDriver eq 'ODBC' || $DBusedDriver eq 'ADO') && $CanUseTieRDBM) {
       my $dbh = DBI->connect("DBI:$DBusedDriver:database=$mydb;host=$myhost$DBOption", "$myuser", "$mypassword");
       $DBI::dbi_debug = $debug;
       if (!$dbh) {
         mlog(0,"Error: $DBI::errstr");
         mlog(0,"unable to get database information via $DBusedDriver!");
         mlog(0,"warning: database options will not be available!");
         $CanUseTieRDBM=0;
       } else {
         my $dbn = $dbh->get_info(17);
         my $dbv = $dbh->get_info(18);
         mlog(0,"info: found database: $dbn version: $dbv via $DBusedDriver");
         $dbn = 'mysql' if ($dbn =~ /mysql/io);
         $dbn = 'mSQL' if ($dbn =~ /mSQL/io);
         $dbn = 'Pg' if ($dbn =~ /Pg/io);
         $dbn = 'Sybase' if ($dbn =~ /Sybase/io);
         $dbn = 'Oracle' if ($dbn =~ /Oracle/io);
         $dbn = 'CSV' if ($dbn =~ /CSV/io);
         $dbn = 'Informix' if ($dbn =~ /Informix/io);
         $dbn = 'Solid' if ($dbn =~ /Solid/io);
         $dbn = 'DB2' if ($dbn =~ /DB2/io);
         $dbn = 'MSSQL' if ($dbn =~ /Microsoft SQL Server/io);
         $dbn = 'Firebird' if ($dbn =~ /Firebird/io);
#         if ($dbn =~ /Microsoft SQL Server/io) {$dbn = 'MSSQL'; $forceTrunc4ClearDB = 1;}
         if (exists $Tie::RDBM::Types{$dbn}) {
            $Tie::RDBM::Types{$DBusedDriver} = $Tie::RDBM::Types{$dbn};
            mlog(0,"info: using $dbn table structure for $DBusedDriver database $mydb");
         } else {
            mlog(0,"info: using default $DBusedDriver table structure for $DBusedDriver database $mydb");
         }
       }
       $dbh->disconnect() if ( $dbh );
       eval("no DBD::$DBusedDriver");
  }
  if ($DBusedDriver eq 'ADO' && ! defined *{'DBD::ADO::CLONE'}) {
      *{'DBD::ADO::CLONE'} = *{'main::ADO_Clone'};
  }
}
  print "\t\t\t\t\t[OK]\nloading caches and lists";

  &initFileHashes();      # init the file base hashes to share them with all threads

  eval('no BerkeleyDB;');

  $crashHMM = HMMreadCrashFiles();

  undef $SysLogObj;

  print "\t\t\t\t[OK]\nstarting maintenance worker thread -> init all databases\n";
  mlog(0,"starting maintenance worker thread [10000] - ThreadCycleTime is set to $MaintThreadCycleTime microseconds");
  $ComWorker{10000} = &share({});
  $ComWorker{10000}->{run} = 1;
  if ($ThreadStackSize) {
      $Threads{10000} = threads->create({'stack_size' => 1024*1024*$ThreadStackSize},\&ThreadMaintStart,10000);
  } else {
      $Threads{10000} = threads->create(\&ThreadMaintStart,10000);
  }
  my $watchtime = time;
  my %chars = ( 0 => '|', 1 => '/', 2 => '-', 3 => '\\' );
  my $ci = 0;
  my $lstep;
  while (! $ComWorker{10000}->{isstarted} && ! $ComWorker{10000}->{inerror}){
      $ci = 0 if $ci > 3;
      ThreadYield();
      Time::HiRes::sleep(0.1);
      my $step;
      if (time - $watchtime > 10 && ($step = $lastd{10000}) && $step ne $lstep) {
          $lstep = $step;
          $step =~ s/\r|\n/ /go;
          my $del = 71 - length($step);
          $del = 1 if $del < 1;
          print "\r10000: $step" . (' ' x $del);
      } else {
          print "\r$chars{$ci++}";
      }
  }
  print "\rstarting maintenance worker thread";
  print "\t\t\t".($ComWorker{10000}->{inerror}?'[FAILED]':'[OK]').(' ' x 100)."\nstarting $NumComWorkers communication worker threads ";

  mlog(0,"starting SMTP-worker-threads with ThreadCycleTime set to $ThreadCycleTime microseconds");
  mlog(0,"starting communication worker threads [1 to $NumComWorkers]");
  for (my $i = 1; $i <= $NumComWorkers; $i++) {
     newThread($i);
     print '.';
     while (! $ComWorker{$i}->{issleep} && ! $ComWorker{$i}->{inerror}){ThreadYield();}
  }
  print "\rstarting $NumComWorkers communication worker threads\t\t\t[OK]\nstarting rebuild SpamDB worker thread";

  mlog(0,"starting rebuild SpamDB worker thread [10001] - ThreadCycleTime is set to $RebuildThreadCycleTime microseconds");
  $ComWorker{10001} = &share({});
  $ComWorker{10001}->{run} = 1;
  if ($ThreadStackSize) {
      $Threads{10001} = threads->create({'stack_size' => 1024*1024*$ThreadStackSize},\&ThreadRebuildSpamDBStart,10001);
  } else {
      $Threads{10001} = threads->create(\&ThreadRebuildSpamDBStart,10001);
  }
  while (! $ComWorker{10001}->{isstarted} && ! $ComWorker{10001}->{inerror}){ThreadYield();}
  print "\t\t\t".($ComWorker{10001}->{inerror}?'[FAILED]':'[OK]')."\n";

  print "initializing main thread and logging\t\t\t[OK]\n";
  sleep 1;
  if ($CanUseBerkeleyDB) {
        eval('use BerkeleyDB;');
        if ($VerBerkeleyDB lt '0.42') {
            *{'BerkeleyDB::_tiedHash::CLEAR'} = *{'main::BDB_CLEAR'};
        }
        *{'BerkeleyDB::_tiedHash::STORE'} = *{'main::BDB_STORE'};
        *{'BerkeleyDB::_tiedHash::DELETE'} = *{'main::BDB_DELETE'};
  }

  if ($CanUseASSP_WordStem) {
      $Lingua::Stem::Snowball::stemmifier = Lingua::Stem::Snowball::Stemmifier->new unless ref($Lingua::Stem::Snowball::stemmifier);
  }
  
  &openLogs();
  
  if (! $silent) {
      binmode STDOUT;
      binmode STDERR;
  }

  &mlogWrite();
  
  &WaitForAllThreads;
  
  $canNotify = 1;
  
  if ($CanUseThreadState && $WorkerCPUPriority) {
      for (my $i = 1; $i <= $NumComWorkers; $i++) {
         my $po = $Threads{$i}->priority($WorkerCPUPriority);
         my $pn = $Threads{$i}->priority;
         $po = 0 if (! $po);
         $pn = 0 if (! $pn);
         mlog(0,"info: CPU priority changed for Worker_$i from $po to $pn") if ($po != $pn);
      }
  }
  if ($CanUseThreadState) {                   # set down thread priority for MaintThread and RebuildThread
     my $po = $Threads{10000}->priority(2);
     my $pn = $Threads{10000}->priority;
     $po = 0 if (! $po);
     $pn = 0 if (! $pn);
     mlog(0,"info: CPU priority changed for Worker_10000 from $po to $pn") if ($po != $pn);
     $po = $Threads{10001}->priority(2);
     $pn = $Threads{10001}->priority;
     $po = 0 if (! $po);
     $pn = 0 if (! $pn);
     mlog(0,"info: CPU priority changed for Worker_10001 from $po to $pn") if ($po != $pn);
  }
  &mlogWrite();
  mlog(0,"try using $DBusedDriver database \<$mydb\> for selected tables") if $DBisUsed;
  &mlogWrite();
  &initPrivatHashes('clean');
  &mlogWrite();
  %SMTPSessionIP = ();
  &ResetStats();
  &mlogWrite();
  &initDBHashes();        # init DB based hashes - they are not shared
  &mlogWrite();
  &initFileHashes('AdminGroup');  # AdminGroup is never shared;
  &mlogWrite();

  ConfigChangePassword('webAdminPassword', '', '', 0) if $usedCrypt == -1; # change the encryption engine now !
  
# check if there are at least 500 records in spamdb (~10KB)
  mlog(0,"start analyze spamdb") if $MaintenanceLog >= 2;
  my $i = $haveSpamdb = getDBCount('Spamdb','spamdb');
  $currentDBVersion{'Spamdb'} = $Spamdb{'***DB-VERSION***'} || 'n/a';
  mlog(0,"spamdb has $i records") if $MaintenanceLog >= 2;
  mlog(0,"warning: Bayesian spam database has only $i records") if ($i < 500 && $spamdb);
  mlog(0,"warning: the current Spamdb is possibly incompatible to this version of ASSP. Please run a rebuildspamdb. current: $currentDBVersion{Spamdb} - required: $requiredDBVersion{Spamdb}") if ($haveSpamdb && $currentDBVersion{Spamdb} ne $requiredDBVersion{Spamdb});
  &mlogWrite();
  
# check if there are at least 50 records in whitelist (~1KB)
  mlog(0,"start analyze whitelist") if $MaintenanceLog >= 2;
  $i = getDBCount('Whitelist','whitelistdb');
  mlog(0,"whitelist has $i records") if $MaintenanceLog >= 2;
  mlog(0,"warning: whitelist has only $i records: (ignore if this is a new install)") if ($i < 50 );

  if ($DoHMM) {
      $haveHMM = getDBCount('HMMdb','spamdb');
      mlog(0,"The Hidden-Markov-Model-DB is empty - the HMM check is disabled") if $MaintenanceLog && ! $haveHMM;
      mlog(0,"The Hidden-Markov-Model-DB has $haveHMM records.") if $MaintenanceLog >= 2 && $haveHMM;
  }
  $currentDBVersion{'HMMdb'} = $HMMdb{'***DB-VERSION***'} || 'n/a';
  mlog(0,"warning: the current HMMdb is possibly incompatible to this version of ASSP. Please run a rebuildspamdb. current: $currentDBVersion{HMMdb} - required: $requiredDBVersion{HMMdb}") if ($DoHMM && $haveHMM && $currentDBVersion{HMMdb} ne $requiredDBVersion{HMMdb});

  if ($mysqlSlaveMode) {
      mlog(0,"assp is running in mysqlSlaveMode - no maintenance will be done for database tables!");
  }
  &mlogWrite();

  if ($SNMP && $CanUseNetSNMPagent) {
      ConfigChangeSNMP('SNMPAgentXSocket','',$Config{SNMPAgentXSocket},'Initializing');
  } else {
      ConfigStats();
  }
  &mlogWrite();
  $shuttingDown=$doShutdown=0;
  $smtpConcurrentSessions=0;
  threads->yield;
  $Stats{starttime}=time;
  $Stats{version}="$version$modversion";

  my ($lsn,$lsnI) = newListen($listenPort,\&ConToThread,1);
  @lsn = @$lsn; @lsnI = @$lsnI;
  for (@$lsnI) {s/:::/\[::\]:/o;}
  mlog(0,"listening for SMTP connections on @$lsnI") if @lsn;

  if ($CanUseIOSocketSSL && $listenPortSSL) {
      my ($lsnSSL,$lsnSSLI) = newListenSSL($listenPortSSL,\&ConToThread,1);
      @lsnSSL = @$lsnSSL; @lsnSSLI = @$lsnSSLI;
      for (@$lsnSSLI) {s/:::/\[::\]:/o;}
      mlog(0,"listening for SMTPS (SSL) connections on @$lsnSSLI") if @lsnSSL;
  }

  my @dummy;
  if ($CanUseIOSocketSSL && $enableWebAdminSSL) {
      my ($WebSocket,$dummy)  = newListenSSL($webAdminPort,\&NewWebConnection);
      @WebSocket = @$WebSocket;
      for (@$dummy) {s/:::/\[::\]:/o;}
      mlog(0,"listening for admin HTTPS connections on @$dummy") if @WebSocket;
  } else {
      my ($WebSocket,$dummy)  = newListen($webAdminPort,\&NewWebConnection);
      @WebSocket = @$WebSocket;
      for (@$dummy) {s/:::/\[::\]:/o;}
      mlog(0,"listening for admin HTTP connections on @$dummy") if @WebSocket;
  }

  if ($CanUseIOSocketSSL && $enableWebStatSSL) {
      my ($StatSocket,$dummy) = newListenSSL($webStatPort,\&NewStatConnection);
      @StatSocket = @$StatSocket;
      for (@$dummy) {s/:::/\[::\]:/o;}
      mlog(0,"listening for stat HTTPS connections on @$dummy") if @StatSocket;
  } else {
      my ($StatSocket,$dummy) = newListen($webStatPort,\&NewStatConnection);
      @StatSocket = @$StatSocket;
      for (@$dummy) {s/:::/\[::\]:/o;}
      mlog(0,"listening for stat HTTP connections on @$dummy") if @StatSocket;
  }

  if($listenPort2) {
    my ($lsn2,$lsn2I) = newListen($listenPort2,\&ConToThread,1);
    @lsn2 = @$lsn2; @lsn2I = @$lsn2I;
    for (@$lsn2I) {s/:::/\[::\]:/o;}
    mlog(0,"listening for additional SMTP connections on @$lsn2I") if @lsn2;
  }

  if($relayHost && $relayPort) {
    my ($lsnRelay,$lsnRelayI)=newListen($relayPort,\&ConToThread,1);
    @lsnRelay = @$lsnRelay; @lsnRelayI = @$lsnRelayI;
    for (@$lsnRelayI) {s/:::/\[::\]:/o;}
    mlog(0,"listening for SMTP relay connections on @$lsnRelayI") if @lsnRelay;
  }

  &mlogWrite();
  while ((my $k,my $v) = each(%Proxy)) {
       my ($to,$allow) = split(/<=/o, $v);
       $allow = " allowed for $allow" if ($allow);
       my ($ProxySocket,$dummy) = newListen($k,\&ConToThread,2);
       $ProxySocket{$k} = shift @$ProxySocket;
       if ($ProxySocket{$k}) {
           for (@$dummy) {s/:::/\[::\]:/o;}
           mlog(0,"proxy started: listening on @$dummy forwarded to $to$allow");
       }
  }
  my $isproxy = scalar(keys %ProxySocket) ? ' and Proxy':'';
  mlog(0,"warning : DisableSMTPNetworking is switch on - SMTP$isproxy listeners will be switched off") if ($DisableSMTPNetworking);

  mlog(0,"current PID: $$");

  &mlogWrite();

  if ($StartError) {
      mlog(0,"*******************************************************************************************");
      mlog(0,"error: an unrecoverable startup error was detected - please look in to previous messages");
      mlog(0,"error: ASSP will not accept any SMTP connection - 'DisableSMTPNetworking' is set to on");
      mlog(0,"error: solve the problem and restart ASSP");
      mlog(0,"error: after restart - login in to GUI and change 'DisableSMTPNetworking' to off, if needed");
      mlog(0,"*******************************************************************************************");
      configUpdateSMTPNet('DisableSMTPNetworking','0','2','');
      &mlogWrite();
  }
  $cmdQueueReleased = 1;
  mlog(0,"info: command queue released");
  $allowPOP3 = 1;
  mlog(0,"info: POP3 collection is now allowed")
     if ($POP3Interval && -e "$base/assp_pop3.pl" && $POP3ConfigFile =~ /^ *file: *(?:.+)/io);
  &mlogWrite();
  if($pidfile) {open($PIDH,'>',"$base/$pidfile"); $PIDH->autoflush; print $PIDH $$;}
  nixUsers();
}

sub initDBHashes {

# generate the CacheObjects and Hashes for all Groups in GroupList, defined in the table above
# if there is "DB:" defined in $dbConfig, database tables are used - otherwise files are used
    return unless $DBisUsed;
    my $waserror = 0;
    my $switch_to_files = 0;
    my $dbh;
    do {
        $switch_to_files = 0 if ($switch_to_files);  #reset to normal state if we have switched over to files
        foreach my $dbGroup (@GroupList) {
            last if ($switch_to_files);
#            next if ($WorkerNumber == 10001 && $dbGroup =~ /delayGroup|LDAPGroup|AdminGroup/io);
            next if $dbGroup eq 'AdminGroup' && $WorkerNumber != 0 && $WorkerNumber < 10000;
            foreach my $dbGroupEntry (@$dbGroup) {
                last if ($switch_to_files);
                my ($KeyName,$dbConfig,$CacheObject,$realFileName,$mysqlFileName,$FailoverValue,$mysqlTable) = split(/,/o,$dbGroupEntry);
                undef $$CacheObject if(defined $$CacheObject && ${$dbConfig} =~ /DB:/o); # undef if we have switched from database to files
                eval {untie %$KeyName if (${$dbConfig} =~ /DB:/o);}; # untie if we have switched from database to files
                if (($CanUseTieRDBM or $CanUseBerkeleyDB) && ${$dbConfig} =~ /DB:/o && ! $waserror) {
                    eval {
                        if ( $DBusedDriver eq 'BerkeleyDB' && $CanUseBerkeleyDB)
                        {
                            my $BerkeleyFile = $realFileName;
                            $BerkeleyFile =~ s/DB:/$FailoverValue/o;
                            $BerkeleyFile = "$base/$BerkeleyFile.bdb";
                            d("BDB-ENV - $KeyName , $BerkeleyFile");
                            our %env = initBDBEnv($KeyName,$BerkeleyFile);
                            if ($dbGroup ne 'AdminGroup') {
                                d("BDB-DB (initDBHashes) - $KeyName , $BerkeleyFile");
                                $$CacheObject=tie %$KeyName, 'BerkeleyDB::Hash' , -Filename => $BerkeleyFile, %env;
                                BDB_filter($$CacheObject);
                            } else {
                                my $cmd = "'BerkeleyDB::Hash',-Filename => \"$BerkeleyFile\", \%main::env";
                                my $bin = $adminusersdbNoBIN ? 0 : 1 ;
                                d("BDB-DB (initDBHashes) - $KeyName , $BerkeleyFile");
                                $$CacheObject=tie %$KeyName,'ASSP::CryptTie',$adminusersdbpass,$bin,$cmd;
                            }
                            BDB_getRecordCount($KeyName);
                            &BDB_compact_hash($KeyName, 1000000) if $WorkerNumber == 0;
                        } else {
                            $dbh ||= DBI->connect("DBI:$DBusedDriver:database=$mydb;host=$myhost$DBOption", $myuser, $mypassword,
                                                    { PrintError=>0,
                                    			      ChopBlanks=>1,
                                    			      Warn=>0 }
                                    			  );
                            if ($dbGroup ne 'AdminGroup') {
                                d("DB (initDBHashes) - $KeyName");
                                $$CacheObject=tie %$KeyName,'Tie::RDBM',{db=>$dbh,table=>"$mysqlTable",create=>1,DEBUG=>$DataBaseDebug};
                            } else {
                                my $cmd = "'Tie::RDBM',\{db=>\$dbh,table=>\"$mysqlTable\",create=>1,DEBUG=>$DataBaseDebug\}";
                                my $bin = $adminusersdbNoBIN ? 0 : 1 ;
                                d("DB (initDBHashes) - $KeyName");
                                $$CacheObject=tie %$KeyName,'ASSP::CryptTie',$adminusersdbpass,$bin,$cmd,$dbh;
                            }
                        }
                    };
                    if($@) {    # there was an error tie
                        $failedTable{$KeyName} = 2;
                        if ($dbGroup ne 'AdminGroup') {
                            mlog(0,"$mysqlFileName database error: $@");
                            if (! $calledfromThread) {
                                $DBisUsed = 0;
                                $CanUseTieRDBM=0;
                                mlog(0,"Warning: can not use defined database - switching over to use files instead of database $mydb!");
                            }
                            $switch_to_files = 1;
                            $waserror = 1;
                        }
                    } else {
                        if (! $calledfromThread) {
                            CheckTableStructure($mysqlTable) if ($DBusedDriver eq 'mysql'); # change the table if there was made an upgrade
                            importDB($KeyName,$mysqlFileName,$mysqlTable,'','','');
                            $realFileName =~ s/DB:/$FailoverValue/o;
                            if ($DBusedDriver eq 'BerkeleyDB' && $CanUseBerkeleyDB) {
                                mlog(0,"using $DBusedDriver Database $base/$realFileName.bdb instead of file $base/$realFileName");
                            } else {
                                my $tbn = "<$mysqlTable>" . ' ' x (15 - length($mysqlTable));
                                mlog(0,"using table $tbn in $DBusedDriver Database <$mydb> instead of file $base/$realFileName");
                            }
                        }
                        $failedTable{$KeyName} = 0;
                    }
                } elsif ($waserror) {
                    $failedTable{$KeyName} = 2;
                }
            }
        }
    } while ($switch_to_files);
    if ($waserror && ! $calledfromThread) {
        mlog(0,"error : DB-failover loading hashes from files");
        &initFileHashes();
    }
}

sub initFileHashes {
    my $singleGroup = shift;
    foreach my $dbGroup (@GroupList) {
        next if $dbGroup eq 'AdminGroup' && $WorkerNumber != 0 && $WorkerNumber < 10000;
        next if $singleGroup && $singleGroup ne $dbGroup;
        foreach my $dbGroupEntry (@$dbGroup) {
            my ($KeyName,$dbConfig,$CacheObject,$realFileName,$mysqlFileName,$FailoverValue,$mysqlTable) = split(/,/o,$dbGroupEntry);
            if ((! $CanUseTieRDBM && ! $CanUseBerkeleyDB) || ${$dbConfig} !~ /DB:/o || $failedTable{$KeyName} == 1) {
                if (! $calledfromThread) {
                    next if (is_shared(%$KeyName));
                    share(%$KeyName) if $dbGroup ne 'AdminGroup';
                    if ($failedTable{$KeyName} == 2) {
                        mlog(0,"warning : setting configvalue for $dbConfig to $FailoverValue");
                        ${$dbConfig} = $FailoverValue;
                        $realFileName =~ s/DB:/$FailoverValue/o;
                    }
                    if ($dbGroup ne 'AdminGroup') {
                        &LoadHash($KeyName, "$base/$realFileName", 0) if (${$dbConfig} && ${$dbConfig} !~ /DB:/o);
                        $$CacheObject = 1;
                    } else {
                        if ($singleGroup eq 'AdminGroup'){
                            eval{
                                my $cmd = "'orderedtie',\"$base/$realFileName\"" ;
                                $$CacheObject=tie %$KeyName,'ASSP::CryptTie',$adminusersdbpass,0,$cmd;
                            } if (${$dbConfig} && ${$dbConfig} !~ /DB:/o);
                            if ($@) {
                                mlog(0,"warning: unable init AdminUsersDB - only root will have access to the GUI");
                            } else {
                                mlog(0,"info: $dbConfig ($base/$realFileName) - loaded") if $$CacheObject;
                            }
                        }
                    }
                }
                $failedTable{$KeyName} = 1;
            }
        }
    }
}

sub loadHashFromFile {
   my ($file,$hash) = @_;
   unless ($file) {
       mlog(0,"error: coding error - loadHashFromFile called without a specified file name");
       return;
   }
   unless (ref($hash) eq 'HASH') {
       mlog(0,"error: coding error - loadHashFromFile called without a valid HASH reference");
       return;
   }
   my $LH;
   my $count;
   lock(%$hash) if is_shared(%$hash);
   unless (open($LH, '<',$file)) {
       mlog(0,"warning: can't open file '$file' to load hash (in loadHashFromFile)");
       return;
   }
   binmode($LH);
   %{$hash} = ();
   while (<$LH>) {
     my ($k,$v) = split/\002/o;
     $v =~ s/\r|\n//go;
     if ($k && $v) {
       $hash->{$k}=$v;
       $count++;
     }
   }
   eval{close $LH;};
   return $count;
}

sub saveHashToFile {
   my ($file,$hash) = @_;
   unless ($file) {
       mlog(0,"error: coding error - saveHashToFile called without a specified file name");
       return;
   }
   unless (ref($hash) eq 'HASH') {
       mlog(0,"error: coding error - saveHashToFile called without a valid HASH reference");
       return;
   }
   my $LH;
   my $count;
   lock(%$hash) if is_shared(%$hash);
   unless (open($LH, '>',$file)) {
       mlog(0,"warning: can't open file '$file' to save hash (in saveHashToFile)");
       return;
   }
   binmode($LH);
   print $LH "\n";
   my @h;
   @h = sort keys %$hash;
   while (@h) {
      (my $k = shift @h) or next;
      (my $v = ${$hash}{$k}) or next;
      print $LH "$k\002$v\n";
      $count++;
   }
   eval{close $LH;};
   return $count;
}

sub initBDBEnv {
  my ($hash,$file) = @_;
  if ($DBusedDriver eq 'BerkeleyDB' && $CanUseBerkeleyDB) {
      my %bdbo = ();
      %bdbo = eval('('.$DBOption.')') if $DBOption;
      mlog(0,"info: DBOption: $DBOption") if (($debug || $DataBaseDebug) && $WorkerNumber == 0);
      foreach (keys %bdbo) {
          mlog(0,"info: defined BerkeleyOption: $_ = $bdbo{$_}") if (($debug || $DataBaseDebug) && $WorkerNumber == 0);
      }
      my %userenv = ();
      if ($bdbo{-Env}) {
          %userenv = %{$bdbo{-Env}} if (ref $bdbo{-Env} && $bdbo{-Env} =~ /HASH/o);
          %userenv = @{$bdbo{-Env}} if (ref $bdbo{-Env} && $bdbo{-Env} =~ /ARRAY/o);
          $bdbcache = $userenv{'-Cachesize'} if $userenv{'-Cachesize'};
          delete $userenv{'-Cachesize'};
          delete $bdbo{-Env};
      }
      $bdbcache = $bdbo{'-Cachesize'} unless $bdbcache;
      delete $bdbo{'-Cachesize'};
      $userenv{'-Cachesize'} = $bdbcache;
      eval('$bdbo{-Flags} = DB_CREATE;');
      $bdbo{'-Env'} = &createBDBEnv($hash, \%userenv);
      delete $bdbo{'-Env'} unless $bdbo{'-Env'};
      return %bdbo;
  }
}

sub clearDBCon {
    &clearDBConPrivat();
    my %dbh;
    foreach my $dbGroup (@GroupList) {
        next unless $DBisUsed;
        next if $dbGroup eq 'AdminGroup' && $WorkerNumber != 0 && $WorkerNumber < 10000;
        foreach my $dbGroupEntry (@$dbGroup) {
            my ($KeyName,$dbConfig,$CacheObject,$realFileName,$mysqlFileName,$FailoverValue,$mysqlTable) = split(/,/o,$dbGroupEntry);
            if(defined $$CacheObject && ${$dbConfig} =~ /DB:/o) {
                eval{$$CacheObject->rdbm_cleanCache() if "$$CacheObject" =~ /Tie::RDBM/o;} if ! $WorkerNumber;
                $dbh{$$CacheObject->{'dbh'}} = 1 if eval{exists $$CacheObject->{'dbh'};};
                $dbh{$$CacheObject->{hashobj}->{'dbh'}} = 1 if eval{exists $$CacheObject->{hashobj}->{'dbh'};};
                undef $$CacheObject; # undef if we have switched from database to files
            }
            eval {untie %$KeyName if (${$dbConfig} =~ /DB:/o);}; # untie if we have switched from database to files
        }
    }
    eval{if ($_) {$_->disconnect();}} for keys %dbh;
}

sub clearDBConPrivat {
    eval {
        undef $GriplistObj;
        untie %Griplist;
    };
    return if $WorkerNumber == 10001; # rebuildspamdb tied only the Griplist
    foreach (keys %tempDBvars) {
        eval {
        undef ${$_ .'Obj'};
        untie(%{$_});
        };
    }
}

sub CheckTableStructure {
  my $mysqlTable = shift;
  my $sql;
  my $dbh;
  my $sth;

  $dbh = DBI->connect("DBI:$DBusedDriver:database=$mydb;host=$myhost$DBOption", "$myuser", "$mypassword");
  if (!$dbh) {
    mlog(0,"Error: $DBI::errstr");
    mlog(0,"MySQL check for table $mysqlTable canceled!");
    $dbh->disconnect() if ( $dbh );
    return;
  }

  my $db_features = $Tie::RDBM::Types{$DBusedDriver};
  my($keytype,$valuetype,$frozentype) = @{$db_features};

  $sth = $dbh->column_info( undef, undef, $mysqlTable, 'pkey' );
  my $db_info;
  eval{$db_info = $sth->fetchrow_arrayref} ;
  if($@) {
    mlog(0,"warning: your mysql driver does not support GET-COLUMNE-INFO");
    mlog(0,"driver version is $DBD::mysql::VERSION - should be at least 4.005");
    $dbh->disconnect() if ( $dbh );
    return;
  }
  my $pkey_TYPE_NAME = @$db_info[37];

  if (lc($pkey_TYPE_NAME) ne lc($keytype)) {
    mlog(0,"info: convert field pkey in table $mysqlTable from $pkey_TYPE_NAME to $keytype");
    $sql="ALTER TABLE $mysqlTable MODIFY COLUMN pkey $keytype NOT NULL";
    $sth = $dbh->do($sql);
    $dbh->commit unless $main::DBautocommit;
    if (!$dbh) {
      mlog(0,"Error: $DBI::errstr");
      mlog(0,"conversion for table $mysqlTable failed!");
    }
  }

  $sth = $dbh->column_info( undef, undef, $mysqlTable, 'pvalue' );
  $db_info = $sth->fetchrow_arrayref ;
  my $pvalue_TYPE_NAME = @$db_info[37];

  if (lc($pvalue_TYPE_NAME) ne lc($valuetype)) {
    mlog(0,"info: convert field pvalue in table $mysqlTable from $pvalue_TYPE_NAME to $valuetype");
    $sql="ALTER TABLE $mysqlTable MODIFY COLUMN pvalue $valuetype DEFAULT NULL";
    $sth = $dbh->do($sql);
    $dbh->commit unless $main::DBautocommit;
    if (!$dbh) {
      mlog(0,"Error: $DBI::errstr");
      mlog(0,"conversion for table $mysqlTable failed!");
    }
  }
# conversion for pfrozen is not needed - it was never changed
  $dbh->disconnect() if ( $dbh );
}

sub importDB {
   my ($name,$file,$mysqlTable,$cache,$cacherec,$recfac) = @_;
   my $importrpl="$base/$importDBDir/$file.rpl";
   my $importadd="$base/$importDBDir/$file.add";
   my $count;
   my $records;
   my $tempCache = $cache ? $cache : {};
   my $sql;
   my $sep;
   my $sqlmaxlen;
   my $dbh;
   my $dbn;
   my $dbv;
   my $dec;
   my $sth;
   my $k;
   my $v;
   my ($dn,$ve,$dp,$ap,$is,$id,$se,$mr,$es);
   my $sql_sm;
   my @dbcfg;
   my $dkey;
   my $dodec;
   $recfac ||= 1;
   $dodec = 1 if $name eq 'AdminUsersRight';
   $dodec = 1 if $name eq 'AdminUsers';

   if ($cache && !($DBusedDriver eq 'BerkeleyDB' or $dodec or $preventBulkImport)) {
       $importrpl = 'cache';
   }

   return if (!(-e $importrpl || -e $importadd) && $importrpl ne 'cache');
   mlog_i(0,"database import started for table $mysqlTable");
   if ($DBusedDriver ne 'BerkeleyDB' && !-e "$base/assp_db_import.cfg"){
     mlog_i(0,"ERROR: unable to find file $base/assp_db_import.cfg - cancel import");
     return;
   }

   exportDB($name,$file,"backup",0) if $importrpl ne 'cache';   #overall - backup before update is the right way
   return if($WorkerNumber != 0 && ! $ComWorker{$WorkerNumber}->{run});

   if (-e $importrpl || $importrpl ne 'cache') {
       mlog_i(0,"replacing records in table $mysqlTable with records in file $importrpl") if $importrpl ne 'cache';
       ${$name}{'x1'} = '1'; #some databases need at least one record to delete all
       %$name=(); # clear the HASH
   }

   if (-e $importadd) {
      mlog_i(0,"adding records in file $importadd to table $mysqlTable");
   }

   $dec = ASSP::CRYPT->new($adminusersdbpass,0) if $dodec;

   my @import = ($importrpl,$importadd);
   foreach my $importrpl (@import){
    $count = 0;
    $records = 0;
    if (-e $importrpl or $importrpl eq 'cache') {
       my $imp_start_time = time;
       my $last_step_time = $imp_start_time;
       my $toadd = 1000;
       my $IMP;
       if ($importrpl ne 'cache') {
           my $obj;
           if ($obj = tied %$name) {
               $obj = $obj->{hashobj} if $dodec;
               if ($obj =~ /BerkeleyDB/o) {
                  BDB_filter_off($obj);
               } else {
                  undef $obj;
               }
           }
           open($IMP, '<',"$importrpl");
           binmode($IMP);
           if ($DBusedDriver eq 'BerkeleyDB' or $dodec or $preventBulkImport or $RunTaskNow{ImportMysqlDB}) {
               while (<$IMP>) {
                   $records++;
               }
               close $IMP;
               open($IMP, '<',"$importrpl");
               binmode($IMP);
           }
           my $old_sec_left;
           my $sec_left;
           while (<$IMP>) {
                my ($k,$v) = $_ =~ /(.*)\002(.*)/;
                $count++;
                $v =~ s/\\r|\\n//go;
                $v =~ s/\r|\n//go;
                $k =~ s/\\r|\\n//go;
                $k =~ s/\r|\n//go;
                $k = $dec->DECRYPT($k) if $dodec && $k && $v;
                $v = $dec->DECRYPT($v) if $dodec && $k && $v;
                if (($k && $v) or ($k && defined $v && $dodec)) {
                     if ($DBusedDriver eq 'BerkeleyDB' or
                         $dodec or
                         $preventBulkImport or
                         $RunTaskNow{ImportMysqlDB}
                        )
                     {
                         ${$name}{$k} = $v;
                         if ($count % $toadd == 0 &&
                             ($sec_left = int(( time - $imp_start_time )*($records - $count)/$count)) != $old_sec_left)
                         {
                             $old_sec_left = $sec_left;
                             mlog_i(0,"added $count of $records records for table $mysqlTable - finished in $sec_left sec");
                             &checkDBCon() if $WorkerNumber > 0;
                             &ThreadMonitorMainLoop("import $mysqlTable") if $WorkerNumber == 0;
                             my $stime = time - $last_step_time || 1;
                             $toadd = int(2 / $stime * $toadd);
                             $last_step_time = time;
                             return if($WorkerNumber != 0 && ! $ComWorker{$WorkerNumber}->{run});
                         }
                     } else {
                         $records++ if (! exists $tempCache->{$k});
                         $tempCache->{$k}=$v;
                     }
                }
           }
           close $IMP;

           if ($DBusedDriver eq 'BerkeleyDB' or $dodec or $preventBulkImport or $RunTaskNow{ImportMysqlDB}) {
               my $BDB; $BDB = " $DBusedDriver" if ($DBusedDriver eq 'BerkeleyDB' or $preventBulkImport);
               mlog_i(0,"successfully added $count records in to $BDB $name");
               rename("$importrpl","$importrpl.OK") or mlog(0,"Error: unable to rename $importrpl to $importrpl.OK");
               next;
           }

           mlog_i(0,"$records valid records of $count records found in $importrpl");
           BDB_filter($obj) if $obj;
       }
       
       if ($cache) {
           $records = $cacherec;
           ${$name}{'x1'} = '1'; #some databases need at least one record to delete all
           %$name=(); # clear the HASH
           if ($@ or ${$name}{'x1'} == 1) {
               sleep 5;
               $ThreadIdleTime{$WorkerNumber} += 5;
               %$name=(); # clear the HASH
           }
       }
       mlog_i(0,"trying Bulkimport for table $mysqlTable");

# first we are trying to make a fast Bulkimport - this should work for most of the databases

       $dbh = DBI->connect("DBI:$DBusedDriver:database=$mydb;host=$myhost$DBOption", "$myuser", "$mypassword");
       if (!$dbh) {
           mlog_i(0,"Error: $DBI::errstr");
           mlog_i(0,"Import for table $mysqlTable canceled!");
           return;
       }

       $dbn = $dbh->get_info(17);
       $dbv = $dbh->get_info(18);
       mlog_i(0,"database: $dbn $dbv");
       if (!($dbn && $dbv)) {
           mlog_i(0,"ERROR: unable to get database information from DBI");
           mlog_i(0,"Import for table $mysqlTable canceled!");
           $dbh->disconnect() if ( $dbh );
           return;
       }

# find the right SQL statements in config file "assp_db_import.cfg"
       open($IMP, '<',"$base/assp_db_import.cfg");
       @dbcfg=<$IMP>;
       close $IMP;
       my %stm = ();
       foreach (@dbcfg) {     # process all lines
           chomp;
           next if /^#/o;
           ($dn,$ve,$dp,$ap,$is,$id,$se,$mr,$es) = split/\|/o;
           next if (!$dn);
           $stm{lc($dn).$ve."dp"}=$dp;
           $stm{lc($dn).$ve."ap"}=$ap;
           $stm{lc($dn).$ve."is"}=$is;
           $stm{lc($dn).$ve."id"}=$id;
           $stm{lc($dn).$ve."se"}=$se;
           $stm{lc($dn).$ve."mr"}=$mr;
           $stm{lc($dn).$ve."es"}=$es;
       }

# find the statements
# first this with both - database and version are wildcards (SQL-ANSI-92)
# second this with the right database and version is wildcards
# third this with the right database and the right version


       if ( exists $stm{'**dp'}) {$dp=$stm{'**dp'}; $ap=$stm{'**ap'}; $is=$stm{'**is'}; $id=$stm{'**id'}; $se=$stm{'**se'};$mr=$stm{'**mr'};$es=$stm{'**es'};}
       if ( exists $stm{lc($dbn).'*dp'}) {$dp=$stm{lc($dbn).'*dp'}; $ap=$stm{lc($dbn).'*ap'}; $is=$stm{lc($dbn).'*is'}; $id=$stm{lc($dbn).'*id'}; $se=$stm{lc($dbn).'*se'}; $mr=$stm{lc($dbn).'*mr'}; $es=$stm{lc($dbn).'*es'};}
       if ( exists $stm{lc($dbn).$dbv.'dp'}) {$dp=$stm{lc($dbn).$dbv.'dp'}; $ap=$stm{lc($dbn).$dbv.'ap'}; $is=$stm{lc($dbn).$dbv.'is'}; $id=$stm{lc($dbn).$dbv.'id'}; $se=$stm{lc($dbn).$dbv.'se'}; $mr=$stm{lc($dbn).$dbv.'mr'}; $es=$stm{lc($dbn).$dbv.'es'};}

# get the types of fields - they may differ depending on the used DB engine
# at this time, this is only needed for MS-SQL to build the right CONVERT statement
# this is to be expanded if any DB require CAT- or SCHEMA-definition (see primary key)
       my $db_info;
       my $pkey_TYPE_NAME;
       my $pvalue_TYPE_NAME;
       my $pfrozen_TYPE_NAME;
       
       ($sth = $dbh->column_info( undef, undef, $mysqlTable, 'pkey' )) and
       ($db_info = $sth->fetchrow_arrayref) and
       ($pkey_TYPE_NAME = @$db_info[5]);

       ($sth = $dbh->column_info( undef, undef, $mysqlTable, 'pvalue' )) and
       ($db_info = $sth->fetchrow_arrayref) and
       ($pvalue_TYPE_NAME = @$db_info[5]);

       ($sth = $dbh->column_info( undef, undef, $mysqlTable, 'pfrozen' )) and
       ($db_info = $sth->fetchrow_arrayref) and
       ($pfrozen_TYPE_NAME = @$db_info[5]);

# get the name of the primary key
       $sth = $dbh->primary_key_info( undef, undef , $mysqlTable ); # for MSSQL, MySQL
       eval{$db_info = $sth->fetchrow_arrayref ;};
       my($TABLE_CAT,$TABLE_SCHEM,$TABLE_NAME,$COLUMN_NAME,$KEY_SEQ,$PK_NAME) = @$db_info ;
       if (!$TABLE_NAME) {
          $sth = $dbh->primary_key_info( undef, undef , uc($mysqlTable));
          eval{$db_info = $sth->fetchrow_arrayref ;};
          ($TABLE_CAT,$TABLE_SCHEM,$TABLE_NAME,$COLUMN_NAME,$KEY_SEQ,$PK_NAME) = @$db_info ;
       }
       if (!$TABLE_NAME) {
          $sth = $dbh->primary_key_info( undef, undef , lc($mysqlTable));     # for Pg
          eval{$db_info = $sth->fetchrow_arrayref ;};
          ($TABLE_CAT,$TABLE_SCHEM,$TABLE_NAME,$COLUMN_NAME,$KEY_SEQ,$PK_NAME) = @$db_info ;
       }
       if (!$TABLE_NAME) {
          $sth = $dbh->primary_key_info( undef, $myuser , $mysqlTable );
          eval{$db_info = $sth->fetchrow_arrayref ;};
          ($TABLE_CAT,$TABLE_SCHEM,$TABLE_NAME,$COLUMN_NAME,$KEY_SEQ,$PK_NAME) = @$db_info ;
       }
       if (!$TABLE_NAME) {
          $sth = $dbh->primary_key_info( undef , uc($myuser) , uc($mysqlTable));  # for Oracle
          eval{$db_info = $sth->fetchrow_arrayref ;};
          ($TABLE_CAT,$TABLE_SCHEM,$TABLE_NAME,$COLUMN_NAME,$KEY_SEQ,$PK_NAME) = @$db_info ;
       }

       if (!$TABLE_NAME) {
          mlog_i(0,"ERROR: unable to get primary-key info for table $mysqlTable - cancel import");
          return;
       }

       mlog_i(0,"removing PRIMARY KEY $PK_NAME from table $mysqlTable") if ( $PK_NAME && $dp !~ /NOOP/o);
# remove primary key - if we do not do this, the import may fail on duplicate keys!!!
       eval ($dp) if ($dp !~ /NOOP/o);
       $sql=$sql_sm;
       if ( $PK_NAME && $dp !~ /NOOP/o) {
           $sth = $dbh->do($sql);
           $dbh->commit unless $main::DBautocommit;
       }
       $count = 0;
       eval ($se);
# set the separator for the middle of the INSERT statement
       $sep=$sql_sm;
       eval ($is);
       $sql=$sql_sm;
       my $max = 10;
       $sqlmaxlen = int($mr * $recfac) || $max;  # 2000 tested for mysql - absolute limit is ~5000 - so we are save (defined in assp_db_import.cfg)
       my $sqllen = int($sqlmaxlen/$max)*$max || $max;
       $imp_start_time = time;
       $last_step_time = $imp_start_time;
# build the INSERT statement from the statements in assp_db_import.cfg and the values in $k,$v
# do this until all record have been inserted or $DBI::err
       my $DBG;
       if ($DataBaseDebug or $debug) {open($DBG,'>',"$base/debug/sql_import_$mysqlTable.".time.'.txt'); binmode($DBG);}
       my $old_sec_left;
       my $sec_left;
       while (my ($k,$v)=each(%{$tempCache})) {
           $k = $dbh->quote($k);   # let's DBI do the quoting - depends on the driver
           $v = $dbh->quote($v);
           next if (! $k || $k eq 'NULL');
           $count++;
           $sep = '' if ($count == $records or int($count/$sqllen) == $count/$sqllen);
           eval ($id);
           $sql .= $sql_sm.$sep;
           if ($count == $records or int($count/$sqllen) == $count/$sqllen) {
              if ($es) {
                  eval ($es);
                  $sql .= $sql_sm;
              }
              if ($DataBaseDebug or $debug) {print $DBG "$sql\n" if $DBG;}
              $sth = $dbh->do($sql);
              $dbh->commit unless $main::DBautocommit;
              last if ($DBI::err);
              if ($count % 1000 == 0 && ($sec_left = int(( time - $imp_start_time )*($records - $count)/$count)) != $old_sec_left) {
                  $old_sec_left = $sec_left;
                  mlog_i(0,"added $count of $records records for table $mysqlTable - finished in $sec_left sec");
                  &checkDBCon() if $WorkerNumber > 0;
                  &ThreadMonitorMainLoop("import $mysqlTable") if $WorkerNumber == 0;
                  last if($WorkerNumber != 0 && ! $ComWorker{$WorkerNumber}->{run});
              }
# reset the separator and the begin of the insert statement
              eval ($se);
              $sep = $sql_sm;
              eval ($is);
              $sql = $sql_sm;
# calculate the number of record that can be added in 2 seconds
              my $stime = $last_step_time - time || 1;
              $sqllen = int(2 / $stime * $sqllen /$max)*$max;
              if ($sqllen <= $max) {$sqllen = $max;}
              elsif ($sqllen > $sqlmaxlen) {$sqllen = $sqlmaxlen;}
              $last_step_time = time;
           }
       }
       if ($DataBaseDebug or $debug) {close($DBG) if $DBG};
       if ($DBI::err) {
# Bulk import has failed - so we are using STD-methode - witch may take a long time
              mlog_i(0,"Error: $DBI::errstr");
              mlog_i(0,"Bulkimport for table $mysqlTable canceled - doing normal import");
# clearing the HASH (delete * from ...) and add the primary key
              ${$name}{'x1'} = '1';
              %$name=();
              mlog_i(0,"adding pimary key $PK_NAME to table $mysqlTable") if ( $PK_NAME && $ap !~ /NOOP/o);
              eval ($ap) if ($ap !~ /NOOP/o);
              $sql=$sql_sm;
              if ( $PK_NAME && $ap !~ /NOOP/o) {
                  $sth = $dbh->do($sql);
                  $dbh->commit unless $main::DBautocommit;
              }
              $dbh->disconnect() if ( $dbh );
# Bulk import failed - so doing the import record by record with the tied HASH
              $count = 0;
              my $imp_start_time = time;
              my $last_step_time = $imp_start_time;
              my $toadd = 500;
              while (my ($k,$v)=each(%{$tempCache})) {
                 next unless $k;
                 ${$name}{$k} = $v;
                 $count++;
                 if ($count % $toadd == 0 && ($sec_left = int(( time - $imp_start_time )*($records - $count)/$count)) != $old_sec_left) {
                    $old_sec_left = $sec_left;
                    mlog_i(0,"added $count of $records records for table $mysqlTable - finished in $sec_left sec");
                    &checkDBCon() if $WorkerNumber > 0;
                    &ThreadMonitorMainLoop("import $mysqlTable") if $WorkerNumber == 0;
                    my $stime = time - $last_step_time || 1;
                    $toadd = int(2 / $stime * $toadd);
                    $last_step_time = time;
                    last if($WorkerNumber != 0 && ! $ComWorker{$WorkerNumber}->{run});
                 }
              }
       } else {
            mlog_i(0,"Bulkimport for table $mysqlTable finished");
# we have to remove duplicate keys from pkey before add the primary key to the table
            if ($ap !~ /NOOP/o ) {   # if $ap is NOOP the primary key was not removed above - so the table must be OK
              mlog_i(0,"removing duplicate keys from table $mysqlTable");
              my $dup_key;
              $dkey=0;
# run this loop until there are no duplicate keys in the table
              do {
                 $dup_key = 0;
                 $sql ="SELECT pkey FROM $mysqlTable GROUP BY pkey HAVING count(*) > 1";
                 $sth = $dbh->prepare($sql);
                 $sth->execute;
                 while ( my ($pkey) = $sth->fetchrow_array ) {   # all duplicate records are in this array
                     $pkey = $dbh->quote($pkey);   # let's DBI do the quoting - depends on the driver
                     $sql ="SELECT * FROM $mysqlTable WHERE pkey=$pkey";   # get all records for this duplicate key
                     my $sthh = $dbh->prepare($sql);
                     $sthh->execute;
                     my ($pkey_add,$pvalue_add,$pfrozen_add) = $sthh->fetchrow_array ;
                     $sql ="DELETE FROM $mysqlTable WHERE pkey=$pkey";   # get all records for this duplicate key
                     $sthh = $dbh->prepare($sql);
                     $sthh->execute;
                     $dbh->commit unless $main::DBautocommit;
                     ${$name}{$pkey_add}=$pvalue_add ; # add the first record
                     $dup_key = 1;
                     $dkey++;
                 }
              } while ($dup_key);
              mlog_i(0,"removed $dkey duplicate keys from table $mysqlTable") if ($dkey);
              $PK_NAME = "PK_$mysqlTable" if (! $PK_NAME); # a primary key is needed
              mlog_i(0,"adding pimary key $PK_NAME to table $mysqlTable") if ( $PK_NAME && $ap !~ /NOOP/o);
              eval ($ap) if ($ap !~ /NOOP/o);
              $sql = $sql_sm;
              if ( $PK_NAME && $ap !~ /NOOP/o) {
                  $sth = $dbh->do($sql) ;
                  $dbh->commit unless $main::DBautocommit;
              }
            }
            $dbh->disconnect() if ( $dbh );
            delete ${$name}{''};
       }
       $count = $count - $dkey;
       mlog_i(0,"successfully added $count records in to table $mysqlTable");
       if (! $cache) {
           rename("$importrpl","$importrpl.OK") or mlog_i(0,"Error: unable to rename $importrpl to $importrpl.OK");
       }
    }
   }
}

sub importMysqlDB {
  my $action = "import";
  return unless $DBisUsed;
  if (!$CanUseTieRDBM && !$CanUseBerkeleyDB) {
    mlog(0,"error: can not $action - database support is not available");
    mlog(0,"Please check the configuration and restart assp!");
    mlog(0,"You have to restart assp, if you changed any database relevant configuration parameters!!!");
    return;
  }
  &checkDBCon();
  foreach my $dbGroup (@GroupList) {
      foreach my $dbGroupEntry (@$dbGroup) {
        my ($KeyName,$dbConfig,$CacheObject,$realFileName,$mysqlFileName,$FailoverValue,$mysqlTable) = split(/,/o,$dbGroupEntry);
        importDB($KeyName,$mysqlFileName,$mysqlTable,'','','') if (${$dbConfig} =~ /DB:/o && ! $failedTable{$KeyName});
        &checkDBCon();
      }
  }
}

sub importFillUp {
  my $filever = shift;
  $filever = uc($filever);
  d("importFillUp - $filever");
  return unless $filever =~ /^[L0-9]$/io;
  return unless $DBisUsed;
  return unless $backupDBDir && $importDBDir;
  $filever = '.' . $filever;
  $filever = '' if $filever eq '.L';
  foreach my $dbGroup (@GroupList) {
      foreach my $dbGroupEntry (@$dbGroup) {
        my ($KeyName,$dbConfig,$CacheObject,$realFileName,$mysqlFileName,$FailoverValue,$mysqlTable) = split(/,/o,$dbGroupEntry);
        next if ${$dbConfig} !~ /DB:/o;
        my $src="$base/$backupDBDir/$mysqlFileName$filever";
        my $tar="$base/$importDBDir/$mysqlFileName.rpl";
        if (copy($src,$tar)) {
            mlog(0,"info: copied file $src to $tar");
        } else {
            mlog(0,"warning: unable to copy file $src to $tar - $!");
        }
      }
  }
}


sub exportDB {
  my ($name,$file,$action,$realFileName)=@_;
  my $export;
  my $i;
  my $enc;
  my $doenc = 0;
  $doenc = 1 if $name eq 'AdminUsersRight';
  $doenc = 1 if $name eq 'AdminUsers';
  $realFileName = "$base/$realFileName" if ($realFileName);
  $export="$base/$exportDBDir/$file" if (lc($action)=~/export/o);
  $export="$base/$backupDBDir/$file" if (lc($action)=~/backup/o);
  mlog_i(0,"$action: starting $action database table $name to file $export");
  unlink "$export.9";
  for ($i=8;$i>0;$i--) {
     my $j=$i+1;
     rename("$export.$i","$export.$j");
  }
  rename("$export","$export.1");
  my $count=0;

  $enc = ASSP::CRYPT->new($adminusersdbpass,0) if $doenc;
  my $obj;
  if ($obj = tied %$name) {
      $obj = $obj->{hashobj} if $doenc;
      if ($obj =~ /BerkeleyDB/o) {
         BDB_filter_off($obj);
      } else {
         undef $obj;
      }
  }
  my $EXP;
  open($EXP, '>',"$export");
  binmode($EXP);
  print $EXP "\n";
  while (my ($k,$v)=each(%$name)) {
     if ($k) {
         if ($doenc && $enc) {
             $k = $enc->ENCRYPT($k);
             $v = $enc->ENCRYPT($v);
         }
         print $EXP "$k\002$v\n";
         $count++;
     }
     if ($count%1000 == 0) {
         threads->yield();
         ThreadMaintMain2() if $WorkerNumber == 10000;
         if ($WorkerNumber == 0 ) {
             &ThreadMonitorMainLoop("$action $name");
         } else {
             last if(! $ComWorker{$WorkerNumber}->{run});
         }
     }
  }
  close $EXP;
  BDB_filter($obj) if $obj;
  mlog_i(0,"$action: $count records of database table $name to file $export");

  if ($copyDBToOrgLoc && lc($action)=~/backup/o && $realFileName){
    if (copy("$export","$realFileName")) {
        mlog_i(0,"$action: $count records of database table $name to file $realFileName");
    } else {
        mlog_i(0,"$action: unable to copy file $export to file $realFileName - $!");
    }
  }
}


sub exportMysqlDB {
  my $action = shift;
  return unless $DBisUsed;
  if (! $CanUseTieRDBM && ! $CanUseBerkeleyDB) {
    mlog(0,"error: can not $action - database support is not available");
    mlog(0,"Please check the configuration and restart assp!");
    mlog(0,"You have to restart assp, if you changed any database related configuration parameters!!!");
    return;
  }
  &checkDBCon();
  foreach my $dbGroup (@GroupList) {
      foreach my $dbGroupEntry (@$dbGroup) {
        my ($KeyName,$dbConfig,$CacheObject,$realFileName,$mysqlFileName,$FailoverValue,$mysqlTable) = split(/,/o,$dbGroupEntry);
        $realFileName =~ s/DB:/$FailoverValue/o;
        exportDB($KeyName,$mysqlFileName,$action,$realFileName) if (${$dbConfig} =~ /DB:/o && ! $failedTable{$KeyName});
        &checkDBCon();
      }
  }
}

sub checkDBCon {
  my $nextcheck = shift;
  if ($nextcheck) {
      $nextDBcheck = $nextcheck;
  } else {
      return 0 if $nextDBcheck > time;
      if ($WorkerNumber == 0 or $WorkerNumber >= 10000) {
          $nextDBcheck = time + $ThreadsWakeUpInterval + 2;
      } else {
          $nextDBcheck = time + 90;
      }
  }
  my $cdberror=0;
  if ($DBusedDriver eq 'BerkeleyDB' && $CanUseBerkeleyDB) {
      return 0;
  }
  &sigoffTry(__LINE__);
  d('checkdbcon');
  $checkdb = 1;   # signal rdbm_EXISTS that it should die on errors
  my $dbh;
  foreach my $dbGroup (@GroupList) {
#      next if ($WorkerNumber == 10001 && $dbGroup =~ /delayGroup|LDAPGroup|AdminGroup/io);
      next if $dbGroup eq 'AdminGroup' && $WorkerNumber != 0 && $WorkerNumber < 10000 ;
      foreach my $dbGroupEntry (@$dbGroup) {
        my ($KeyName,$dbConfig,$CacheObject,$realFileName,$mysqlFileName,$FailoverValue,$mysqlTable) = split(/,/o,$dbGroupEntry);
        next if $KeyName =~ /HMM/o && $lockHMM;
        next if $KeyName eq 'Spamdb' && $lockBayes;
        if (${$dbConfig} =~ /DB:/o) {
          my $querystr="01AA01" . $KeyName .int(rand(10000)). "01AA01";
          d("chkdb - $KeyName");
          eval {exists ${$KeyName}{$querystr};
                d("chkdb - OK for $KeyName");
#                mlog(0,"info: checkdbcon OK for $KeyName") if ($WorkerNumber == 10000 && $MaintenanceLog > 2);
#                my $t; $t = lc $$CacheObject->{table} if "$$CacheObject" =~ /Tie::RDBM/oi;
#                mlog(0,"info: table-Cache: $$CacheObject->{table}: @{$t}") if ($WorkerNumber == 10000  && "$$CacheObject" =~ /Tie::RDBM/oi);
                delete $$CacheObject->{'cached_value'} if "$$CacheObject" =~ /Tie::RDBM/oi;
                delete $$CacheObject->{hashobj}->{'cached_value'}
                  if "$$CacheObject" =~ /assp::/io && "$$CacheObject->{hashobj}" =~ /Tie::RDBM/oi;
          }; # make the fast select and clean the cache
          if ($@ or $failedTable{$KeyName}){  # try to reconnect if the select has failed - else do nothing
            $cdberror = 1;
            if ($@) {
                mlog(0,"warning: got database error $@ on table $mysqlTable - try to reconnect");
            } else {
                mlog(0,"warning: database table $mysqlTable has failed state - try to reconnect");
            }
            eval { undef $$CacheObject; untie %$KeyName;};
            eval {
                if ($DBusedDriver eq 'BerkeleyDB' && $CanUseBerkeleyDB) {
                    my $BerkeleyFile = $realFileName;
                    $BerkeleyFile =~ s/DB:/$FailoverValue/o;
                    $BerkeleyFile = "$base/$BerkeleyFile.bdb";
                    our %env = initBDBEnv($KeyName,$BerkeleyFile);
                    if ($dbGroup ne 'AdminGroup') {
                        $$CacheObject=tie %$KeyName, 'BerkeleyDB::Hash' , -Filename => $BerkeleyFile, %env;
                        BDB_filter($$CacheObject);
                    } else {
                        my $cmd = "'BerkeleyDB::Hash',-Filename => \"$BerkeleyFile\", \%main::env";
                        my $bin = $adminusersdbNoBIN ? 0 : 1 ;
                        $$CacheObject=tie %$KeyName,'ASSP::CryptTie',$adminusersdbpass,$bin,$cmd;
                    }
                } else {
                    $dbh ||= DBI->connect("DBI:$DBusedDriver:database=$mydb;host=$myhost$DBOption", $myuser, $mypassword,
                                            { PrintError=>0,
                            			      ChopBlanks=>1,
                            			      Warn=>0 }
                            			  );
                    if ($dbGroup ne 'AdminGroup') {
                        $$CacheObject=tie %$KeyName,'Tie::RDBM',{db=>$dbh,table=>"$mysqlTable",create=>1,DEBUG=>$DataBaseDebug};
                    } else {
                        my $cmd = "'Tie::RDBM',\{db=>\$dbh,table=>\"$mysqlTable\",create=>1,DEBUG=>$DataBaseDebug\}";
                        my $bin = $adminusersdbNoBIN ? 0 : 1 ;
                        $$CacheObject=tie %$KeyName,'ASSP::CryptTie',$adminusersdbpass,$bin,$cmd,$dbh;
                    }
                }
            };
            if($@) {
                mlog(0,"$mysqlFileName database error: $@");
                $realFileName =~ s/DB:/$FailoverValue/o;
                if ($dbGroup ne 'AdminGroup') {
                    mlog(0,"error: unable to use defined database - switching over to use $base/$realFileName instead of table $mysqlTable!");
                    mlog(0,"warning: from this time, the hash $KeyName will be different in every worker");
                    $$CacheObject=tie %$KeyName,'orderedtie',"$base/$realFileName";
                } else {
                    eval { undef $$CacheObject; untie %$KeyName;};
                    mlog(0,"warning: hash $KeyName is unavailable - only root is permitted to logon to GUI");
                }
                $failedTable{$KeyName} = 2;
            } else {
                mlog(0,"info: reusing table \<$mysqlTable\>  \tin $DBusedDriver Database \<$mydb\>");
                $failedTable{$KeyName} = 0;
            }
          }
        }
        if ($KeyName eq 'Spamdb' && ! $WorkerNumber && $haveSpamdb) {
            $currentDBVersion{Spamdb} = $Spamdb{'***DB-VERSION***'} || 'n/a';
            threads->yield;
        } elsif ($KeyName eq 'HMMdb' && ! $WorkerNumber && $haveHMM) {
            $currentDBVersion{HMMdb} = $HMMdb{'***DB-VERSION***'} || 'n/a';
            threads->yield;
        }
        eval{$$CacheObject->rdbm_cleanCache() if "$$CacheObject" =~ /Tie::RDBM/o;} if ! $WorkerNumber;
      }
  }
  d('chkdb - finished');
  $checkdb = undef;
  &sigonTry(__LINE__);
  return $cdberror;
}

sub getDestSockDom {
    my $dest = shift;
    return unless $dest;
    my $orgdest = $dest;
    my ($ip4,$ip6,$ip,%Domain);
    $ip = $1 if $dest =~ /^\[?($IPRe)\]?/o;
    if (! $ip) {
        my ($port,@res);
        $dest =~ s/^\[//o;
        $dest =~ s/\]?:\d+$//o;
        if ($CanUseIOSocketINET6) {
            eval(<<EOT);
                @res = Socket6::getaddrinfo($dest,25,AF_INET6);
	            ($ip6, $port) = getnameinfo($res[3], NI_NUMERICHOST | NI_NUMERICSERV) if $res[3];
EOT
            eval(<<EOT)  if $@ || !($ip6 =~ s/^\[?($IPv6Re)\]?$/$1/o);
                $ip6 = Socket6::inet_ntop( AF_INET6, scalar( Socket6::gethostbyname2($dest,AF_INET6) ) );
EOT
            $ip6 = undef if $@ || !($ip6 =~ s/^\[?($IPv6Re)\]?$/$1/o);
            mlog(0,"info: resolved IPv6 $ip6 for hostname $dest") if $ip6 && $ConnectionLog >= 2;
        }
        if (! $ip6) {
            eval{$ip4 = inet_ntoa( scalar( gethostbyname($dest) ) );};
            $ip4 = undef if ($ip4 !~ /^$IPv4Re$/o);
            mlog(0,"info: resolved IPv4 $ip4 for hostname $dest") if $ip4 && $ConnectionLog >= 2;
        }
    } else {
        $ip6 = $1 if $ip =~/^\[?($IPv6Re)\]?$/o;
        $ip4 = $1 if ! $ip6 && $ip =~/^($IPv4Re)$/o;
    }
    if ($ip6) {
        $Domain{Domain} = AF_INET6;
    } elsif ($ip4) {
        $Domain{Domain} = AF_INET;
    } else {
        $Domain{Domain} = AF_UNSPEC;
        mlog(0,"error: found unresolvable ($dest) - hostname or suspicious IP address definition in $orgdest");
    }
    return %Domain;
}

sub newListen {
    my($port,$handler,$threadhandler)=@_;
    my @s;
    my @sinfo;
    return \@s,\@sinfo if($DisableSMTPNetworking and $handler eq \&ConToThread);
    foreach my $portA (split(/\|/o, $port)) {
        if($portA !~ /$HostRe?:?$PortRe/o) {
            mlog(0,"wrong (host) + port definition in '$portA' -- entry will be ignored !");
            next;
        }
        my @stt;
        my ($interface,$p)=$portA=~/($HostRe):($PortRe)/o;

        my %parms = $interface
                    ? ('LocalPort' => $p, 'LocalAddr' => $interface)
                    : ('LocalPort' => $portA);
        $parms{Listen} = 10;
        $parms{Reuse} = 1;
        
        if ($CanUseIOSocketINET6) {
            my $isv4 = [&getDestSockDom($interface)]->[1] != AF_INET6;
            my ($s4,$s6);
            if (! $interface || $isv4) {
                $parms{Domain} = AF_INET;
                $s4 = IO::Socket::INET6->new(%parms);
                push @stt,$s4 if $s4;
            }
            if (! $interface || ! $isv4) {
                $parms{Domain} = AF_INET6;
                $s6 = IO::Socket::INET6->new(%parms);
                push @stt,$s6 if $s6;
            }
        } else {
            my $s4 = IO::Socket::INET->new(%parms);
            push @stt,$s4 if $s4;
        }
        if(! @stt) {
            mlog(0,"error: couldn't create server socket on port '$portA' -- maybe another service is running or I'm not root (uid=$>)? -- or a wrong IP address is defined? -- $!");
            next;
        }
        foreach my $s (@stt) {
            $s->blocking(0);
            $SocketCalls{$s}=$handler;
            $ThreadHandler{$s} = $threadhandler if $threadhandler;    # tell thread what to do
            &dopoll($s,$readable,POLLIN);
            push @s,$s;
            push @sinfo,$s->sockhost . ':' . $s->sockport;
        }
    }
    return \@s,\@sinfo;
}

sub newListenSSL {
    my($port,$handler,$threadhandler)=@_;
    my @s;
    my @sinfo;
    return \@s,\@sinfo if($DisableSMTPNetworking and $handler eq \&ConToThread);
    foreach my $portA (split(/\|/o, $port)) {
        if($portA !~ /$HostRe?:?$PortRe/o) {
            mlog(0,"wrong (host) + port definition in '$portA' -- entry will be ignored !");
            next;
        }
        my @stt;
        my ($interface,$p)=$portA=~/($HostRe):($PortRe)/o;

        my %parms = getSSLParms(1);
        if ($interface) {
            $parms{LocalPort} = $p;
            $parms{LocalAddr} = $interface;
        } else {
            $parms{LocalPort} = $portA;
        }
        $parms{Listen} = 10;
        $parms{Reuse} = 1;
        $parms{SSL_startHandshake} = 1;

        if ($SSLDEBUG > 1) {
            while(my($k,$v)=each(%parms)) {
                print "ssl-new-listener: $k = $v\n";
            }
        }

        if ($CanUseIOSocketINET6) {
            my $isv4 = [&getDestSockDom($interface)]->[1] != AF_INET6;
            my ($s4,$s6);
            if (! $interface || $isv4) {
                $parms{Domain} = AF_INET;
                $s4 = IO::Socket::SSL->new(%parms);
                push @stt,$s4 if $s4;
            }
            if (! $interface || ! $isv4) {
                $parms{Domain} = AF_INET6;
                $s6 = IO::Socket::SSL->new(%parms);
                push @stt,$s6 if $s6;
            }
        } else {
            $parms{Domain} = AF_INET;
            my $s4 = IO::Socket::SSL->new(%parms);
            push @stt,$s4 if $s4;
        }

        if(! @stt) {
            mlog(0,"error: couldn't create server SSL-socket on port '$portA' -- maybe another service is running or I'm not root (uid=$>)? - or a wrong IP address is specified? -- $! - $IO::Socket::SSL::SSL_ERROR");
            next;
        }
        foreach my $s (@stt) {
            $SocketCalls{$s}=$handler;
            $ThreadHandler{$s} = $threadhandler if $threadhandler;    # tell thread what to do
            &dopoll($s,$readable,POLLIN);
            push @s,$s;
            push @sinfo,$s->sockhost . ':' . $s->sockport;
        }
    }
    $IO::Socket::SSL::DEBUG = $SSLDEBUG;
    return \@s,\@sinfo;
}

sub nixUsers {
  my ($uid,$gid); ($uid,$gid) = getUidGid($runAsUser,$runAsGroup) if ($runAsUser || $runAsGroup);
  if($ChangeRoot) {
    my $chroot;
    eval('$chroot=chroot($ChangeRoot)');
    if($@) {
      my $msg="request to change root to '$ChangeRoot' failed: $@";
      mlog(0,$msg);
      &downASSP($msg);
      exit(1);
    } elsif(! $chroot) {
      my $msg="request to change root to '$ChangeRoot' did not succeed: $!";
      mlog(0,$msg);
      &downASSP($msg);
      exit(1);
    } else {
      $chroot=$ChangeRoot; $chroot=~s/(\W)/\\$1/go;
      $base=~s/^$chroot//io;
      chdir("/");
      mlog(0,"successfully changed root to '$ChangeRoot' -- new base is '$base'");
    }
  }

  switchUsers($uid,$gid) if ($runAsUser || $runAsGroup);
}

sub getUidGid { my ($uname,$gname)=@_;
  return if $AsAService;
  my $rname="root";
  eval('getgrnam($rname);getpwnam($rname);');
  if($@) {
# windows pukes "unimplemented" for these -- just skip it
    mlog(0,"warning: uname and/or gname are set ($uname,$gname) but getgrnam / getpwnam give errors: $@");
    return;
  }
  my $gid;
  if($gname) {
    $gid = getgrnam($gname);
    if(defined $gid) {
    } else {
      my $msg="could not find gid for group '$gname' -- not switching effective gid -- quitting";
      mlog(0,$msg);
      &downASSP($msg);
      exit(1);
    }
  }
  my $uid;
  if($uname) {
    $uid = getpwnam($uname);
    if(defined $uid) {
    } else {
      my $msg="could not find uid for user '$uname' -- not switching effective uid -- quitting";
      mlog(0,$msg);
      &downASSP($msg);
      exit(1);
    }
  }
  ($uid,$gid);
}

sub switchUsers { my ($uid,$gid)=@_;
  return if $AsAService;
  my($uname,$gname)=($runAsUser,$runAsGroup);
  $>=0;
  if($> != 0) {
    my $msg="requested to switch to user/group '$uname/$gname' but cannot set effective uid to 0 -- quitting; uid is $>";
    mlog(0,$msg);
    &downASSP($msg);
    exit(1);
  }
  $<=0;
  if($gid) {
    $)=$gid;
    if($)+0==$gid) {
      mlog(0,"switched effective gid to $gid ($gname)");
    } else {
      my $msg="failed to switch effective gid to $gid ($gname) -- effective gid=$) -- quitting";
      mlog(0,$msg);
      &downASSP($msg);
      exit(1);
    }
    $(=$gid;
    if($(+0==$gid) {
      mlog(0,"switched real gid to $gid ($gname)");
    } else {
      mlog(0,"failed to switch real gid to $gid ($gname) -- real uid=$(");
    }
  }
  if($uid) {
# do it both ways so linux and bsd are happy
   $< = $> = $uid;
    if($>==$uid) {
      mlog(0,"switched effective uid to $uid ($uname)");
      $switchedUser = 1;
    } else {
      my $msg="failed to switch effective uid to $uid ($uname) -- real uid=$< -- quitting";
      mlog(0,$msg);
      &downASSP($msg);
      exit(1);
    }
    if($<==$uid) {
      mlog(0,"switched real uid to $uid ($uname)");
      $switchedUser = 1;
    } else {
      mlog(0,"failed to switch real uid to $uid ($uname) -- real uid=$<");
    }
  }
}

sub pollerror {
    my $action = shift;
    
    my $what = $action eq $readable ? 'read' : 'write';
    
    my %calls = (
        \&ConToThread       => 'ConToThread',
        \&NewWebConnection  => 'NewWebConnection',
        \&NewStatConnection => 'NewStatConnection',
        \&WebTraffic        => 'WebTraffic',
        \&StatTraffic       => 'StatTraffic',
        \&ProxyTraffic      => 'ProxyTraffic',
        \&SMTPTraffic       => 'SMTPTraffic'
    );
    my @errfh;
    my @nvalfh;

    if ($IOEngineRun == 0) {
        @errfh = $action->handles(POLLERR);
        @nvalfh = $action->handles(POLLNVAL);
    } else {
        @errfh = $action->has_exception($pollwait);
    }

    my $numerr = scalar(@errfh);
    my $numnval = scalar(@nvalfh);
    return $numerr + $numnval unless $numerr + $numnval;
    mlog(0,"error: IO-subsystem error - $numerr error state $what handles") if (($numerr && $ConnectionLog == 3) || $debug || $ThreadDebug);
    mlog(0,"error: IO-subsystem error - $numnval wrong $what handles") if (($numnval && $ConnectionLog == 3) || $debug || $ThreadDebug);
    my %ErrorFH = ();
    foreach my $fh (@errfh) {
        $ErrorFH{$fh} = ' - error state';
    }
    foreach my $fh (@nvalfh) {
        $ErrorFH{$fh} .= ' - invalid filedescriptor';
        push @errfh,$fh;
    }
    foreach my $fh (@errfh) {
        my $fhcon;
        my $peercon;
        my $fno;
        my $ip;
        eval{$fhcon = $fh->sockhost().":".$fh->sockport();};
        $fhcon = 'n/a' unless $fhcon;
        eval{$ip = $fh->peerhost();$peercon = $ip.":".$fh->peerport();};
        $peercon = 'n/a' unless $peercon;
        my $calltarget = $calls{$SocketCalls{$fh}};
        eval{$fno = fileno($fh);};
        mlog(0,"error: registered fd for $fh is not equal$ErrorFH{$fh}") if ($ConnectionLog == 3 && $fno && $Fileno{$fno} && $Fileno{$fno} ne $fh);
        mlog(0,"error: IO-handle : $fh;  fileno : $fno; call : $calltarget; localIP : $fhcon; peerIP : $peercon;$ErrorFH{$fh}; - will remove handle") if $ConnectionLog == 3;
        done($fh) if $CloseHandleOnPollError;
    }
    return $numerr + $numnval;
}

sub MainLoop {
  my $maxwait = shift;
  my $entrytime = Time::HiRes::time();
  my $hourend = time % 1800;
  mlog(0,'') if (( time - $lastMlog ) > 110 || $hourend < 15 || $hourend > 3585);
  mlog(0,'***assp&is%alive$$$') if ((time - $lastmlogWrite) > 120);
  &ThreadMonitorMainLoop('MainLoop start');
  &ConDone();
  my @canread;
  &getChangedConfigValue() if @changedConfig;
  &tellThreadsReReadConfig() if ($ConfigChanged);
  &mlogWrite();
  if ($maxwait && $syncToDo) {
      my $hassync;
      &ThreadMonitorMainLoop('Doing Config Sync');
      foreach ( sort { &syncSortCFGRec() } Glob("$base/configSync/*.cfg")) {
          next if -d $_;
          &syncConfigReceived($_);
          unlink($_) if -e "$_";
          &syncWriteConfig();
          $hassync = 1;
          last;
      }
      $syncToDo = $hassync;
      &mlogWrite();
  }
  my $stime=Time::HiRes::time(); # loop cycle start time
  if ($maxwait && $ThreadsDoStatus && $stime - $lastThreadsDoStatus > 5) {
      d('stop Status collection');
      $ThreadsDoStatus = 0;
      mlog(0,"info: stop Threads collecting status information") if($MaintenanceLog);
      &ThreadYield();
      %ConFno = ();
      undef %ConFno;
  }
  if ($maxwait && $process_external_cmdqueue && time % 5 == 0 && (open my $cmdq, '<',"$base/cmdqueue")) {
      &ThreadMonitorMainLoop('processing external command queue');
      while (my $line = (<$cmdq>)) {
          next if ($line =~ /^\s*[#;]/o);
          my ($sub,$parm) = parseEval($line);
          next unless $sub;
          mlog(0,"info: executing command '$line' from $base/cmdqueue");
          if ($sub eq 'RunEval' or $sub eq '&RunEval' or $sub eq \&RunEval or $sub eq &RunEval) {
              &RunEval($parm);
          } else {
              $sub =~ s/^\&//o;
              eval{$sub->(split(/\,/o,$parm));};
          }
          mlog(0,"error executing command '$line' from $base/cmdqueue - $@") if $@;
          &mlogWrite();
      }
      close $cmdq;
      unlink "$base/cmdqueue";
  }
  if ($maxwait && $SNMPagent) {
      d('check SNMPagent');
      my $maxSNMPtime = Time::HiRes::time() + 2;  # max two seconds for SNMP request processing
      my $res = $SNMPagent->agent_check_and_process(0);
      my $gotRequest = $res;
      while ( $res && (Time::HiRes::time() < $maxSNMPtime) ) {
         $lastSNMPrequest = time;
         $res = $SNMPagent->agent_check_and_process(0);
      }
      if (time - $lastSNMPrequest < 15) {
          $MainThreadLoopWait = $gotRequest ? 0 : 0.25;
      }
      &mlogWrite() if $gotRequest;
  }
  &ThreadMonitorMainLoop('MainLoop start poll Sockets');
  $stime=Time::HiRes::time(); # poll-loop cycle start time
  if ($IOEngineRun == 0) {
      my $re;
      if ($readable->handles()) {
          $re = $readable->poll( min($MainThreadLoopWait,$maxwait) + $MinPollTimeT/1000);   # wait at least two milliseconds
          @canread = $readable->handles(POLLIN|POLLHUP);
          if ($re < 0) {
              &pollerror($readable);
          }
      }
  } else {
    my $wait = int( min($MainThreadLoopWait,$maxwait) + $MinPollTimeT/1000);
    $wait = $maxwait unless $wait;
    @canread = $readable->can_read( $wait );
  }
  my $itime = Time::HiRes::time(); # loop cycle idle end time
  $ThreadIdleTime{$WorkerNumber} += $itime - $stime;
  return ($itime - $entrytime) if (! $maxwait && ! @canread);

  &ThreadMonitorMainLoop('MainLoop polled Sockets');
  my $ptime = $itime - $stime;
  mlog(0,"warning: the operating system socket poll cycle has taken $ptime seconds - this is very much is too long")
      if ($ConnectionLog >= 2 and $ptime > 3);
  $nextLoop2=$itime+0.3; # global var
  &mlogWrite();
  &ThreadYield() unless @canread;
  while (@canread) {
    my $fh = shift @canread;
    if ($fh && $SocketCalls{$fh}) {
      if ($SocketCalls{$fh}==\&WebTraffic || $SocketCalls{$fh}==\&NewWebConnection || $SocketCalls{$fh}==\&NewStatConnection || $SocketCalls{$fh}==\&StatTraffic) {
        next if exists $MainLoopInWebFH{$fh};
        $MainLoopInWebFH{$fh} = 1;
        $SocketCalls{$fh}->($fh) if (! exists $ConDelete{$fh});
        delete $MainLoopInWebFH{$fh};
      } else {
        unless ($shuttingDown || $allIdle) {
            mlog(0,"info: $WorkerName got connection request") if ($WorkerLog);
            $SocketCalls{$fh}->($fh);
        }
      }
      &mlogWrite();
    } else {
        next if (! $SocketCalls{$fh} && $errorFH);
        mlog(0,"Warning: $WorkerName found socket without SocketCalls - please report!");
        eval{
          delete $SocketCalls{$fh} if (exists $SocketCalls{$fh});
          delete $Con{$fh} if (exists $Con{$fh});
          delete $WebCon{$fh} if (exists $WebCon{$fh});
          unpoll($fh,$readable);
          unpoll($fh,$writable);
          delete $ConDelete{$fh} if (exists $ConDelete{$fh});
          eval{close($fh)} if (fileno($fh));
        };
        &mlogWrite();
    }
  }
  $errorFH = 0;
  &ThreadMonitorMainLoop('MainLoop read from sockets');
  d('mainloop before servicecheck');
  serviceCheck(); # for win32 services
  &ThreadMonitorMainLoop('MainLoop service check');

  &SMTPSessionLimitCheck();
  &ThreadMonitorMainLoop('MainLoop session limit check');
  &mlogWrite();

# database connection check is done independend from any time values
# the complete check for all tables should never take more than 0.05 seconds if all is ok
  if (($CanUseTieRDBM or $CanUseBerkeleyDB) && $DBisUsed && $itime >= $nextDBcheck) { # check - do we have lost any DB connection
                                  # and reconnect if possible
      my $cdbstime=Time::HiRes::time(); # to get the check time
      my $cdberror=&checkDBCon(int($itime)+$ThreadsWakeUpInterval + 2); # check every 120 seconds   # or switch to files
      my $cdbetime= sprintf("%.3f",(Time::HiRes::time()) - $cdbstime); # to get the check time
      d("info: database connection was checked in $cdbetime seconds");
      mlog(0,"warning: $WorkerName - check the database connections has taken $cdbetime seconds (max=1.000s)") if ($cdbetime>1 && ! $cdberror); #0.1s is ok
      &ThreadMonitorMainLoop('MainLoop database check');
      my $mem = $showMEM ? printMem() : 0;
      mlog(0,"info: worker memory$mem") if $mem && $MaintenanceLog > 2;
  }

  &ThreadYield();

  if ($itime >= $nextThreadsWakeUp) {   # wakeup all threads every some sec
     &ThreadsWakeUp();
     $nextThreadsWakeUp = int($itime)+$ThreadsWakeUpCheck;
     &ThreadMonitorMainLoop('MainLoop wakeup threads');
  }

  d('mainloop before restart check');

  if($RestartEvery && $itime >= $endtime) {
# time to quit -- after endtime and we're bored.
        mlog(0,"info: restart time is reached - waiting until all connection are gone but max 5 minutes");
        while ($smtpConcurrentSessions && time < $endtime + 300) {
            my $tendtime = $endtime;
            $endtime = time + 10000;
            &MainLoop2();
            $endtime = $tendtime;
            Time::HiRes::sleep(0.5);
            $ThreadIdleTime{$WorkerNumber} += 0.5;
        }
        &downASSP("restarting");
        _assp_try_restart;
  }

  &ThreadMonitorMainLoop('Mainloop after restart check');

  if ($doShutdown > 0 && $itime >= $doShutdown) {
    &downASSP("restarting");
    _assp_try_restart;
  }
  &ConDone();

  if ($allIdle > 0 && ! $Config{DisableSMTPNetworking}) {
      configUpdateSMTPNet('DisableSMTPNetworking',$Config{DisableSMTPNetworking},'2','');
      $ConfigChanged = 1;
  } elsif ($allIdle < 0 && $Config{DisableSMTPNetworking}) {
      configUpdateSMTPNet('DisableSMTPNetworking',$Config{DisableSMTPNetworking},'0','');
      $ConfigChanged = 1;
      $allIdle = 0;
  }

  if (time > $nextdetectGhostCon) {
      &detectWebGhostCon();
      &detectGhostCon();
      $nextdetectGhostCon = time + 300;
  }
  foreach my $fh (keys %repollFH) {
      if ($repollFH{$fh} < time) {
          dopoll($fh,$readable,POLLIN);
          dopoll($fh,$writable,POLLOUT);
          delete $repollFH{$fh};
      }
  }
  &mlogWrite();
  undef %Con unless keys(%Con);
  undef %ConDelete unless keys(%ConDelete);
  undef %SocketCalls unless keys(%SocketCalls);
  undef %repollFH unless keys(%repollFH);
  undef %WebConH unless keys(%WebConH);
  undef %MainLoopInWebFH unless keys(%MainLoopInWebFH);
  undef %StatConH unless keys(%StatConH);
  undef %MainLoopInWebFH unless keys(%MainLoopInWebFH);
  return (Time::HiRes::time() - $entrytime);
}

# called in long running GUI tasks to keep new connection handling
sub MainLoop1 {
    my $wait = shift;
    return 0 if ($shuttingDown);
    my $AWS = $ActWebSess;
    my %QS = %qs;
    $wait = &MainLoop($wait);
    $ActWebSess = $AWS;
    %qs = %QS;
    return $wait;
}

# called during long operations to keep the GUI running
# alternates (0.3s/0.3s) between SMTP connections handling and the calling task
sub MainLoop2 {
  &mlogWrite();
#  &ThreadMonitorMainLoop('MainLoop2 start');
  return if $isRunMainLoop2;
  $isRunMainLoop2 = 1;
  mlog(0,'***assp&is%alive$$$') if ((time - $lastmlogWrite) > 120);
  my @canread;
  my $wait;
  my $time=Time::HiRes::time();
  if ($time >= $nextLoop2) {
    if ($SNMPagent) {
        my $res = $SNMPagent->agent_check_and_process(0);
        my $gotRequest = $res;
        while ($res) {
           $lastSNMPrequest = time;
           $res = $SNMPagent->agent_check_and_process(0);
        }
        if (time - $lastSNMPrequest < 15) {
            $MainThreadLoopWait = $gotRequest ? 0 : 0.25;
        }
    }
    serviceCheck() unless $ServiceStopping; # for win32 services
#    &ThreadMonitorMainLoop('MainLoop2 service check');
    do {
      my $stime=Time::HiRes::time(); # poll-loop cycle start time
      if ($IOEngineRun == 0) {
           my $re;
           if ($readable->handles()) {
               $re = $readable->poll($MainThreadLoopWait + $MinPollTimeT/1000);   # wait at least two milliseconds
               @canread = $readable->handles(POLLIN|POLLHUP);
               if ($re < 0) {
                   &pollerror($readable);
               }
           }
      } else {
         my $wait = int($MainThreadLoopWait + $MinPollTimeT/1000);
         $wait = 1 unless $wait;
         @canread = $readable->can_read( $wait );
      }

      my $itime=Time::HiRes::time(); # loop cycle idle end time
#      &ThreadMonitorMainLoop('MainLoop polled Sockets');
      my $ptime = $itime - $stime;
      $ThreadIdleTime{$WorkerNumber} += $ptime;
      mlog(0,"warning: poll cycle (2) has taken $ptime seconds - this is very much is too long")
          if ($ConnectionLog >= 2 and $ptime > 3);

#      &ThreadMonitorMainLoop('MainLoop2 poll Sockets');
      while (@canread) {
        my $fh = shift @canread;
        if ($fh && ($SocketCalls{$fh}==\&WebTraffic || $SocketCalls{$fh}==\&NewWebConnection || $SocketCalls{$fh}==\&NewStatConnection || $SocketCalls{$fh}==\&StatTraffic)) {
          next if exists $MainLoopInWebFH{$fh};
          $MainLoopInWebFH{$fh} = 1;
          $SocketCalls{$fh}->($fh) if (! exists $ConDelete{$fh});
          delete $MainLoopInWebFH{$fh};
        }
      }
#      &ThreadMonitorMainLoop('MainLoop2 read from socket');

      $time=Time::HiRes::time();
    } until (@canread==0 || $time >= $nextLoop2);
    $nextLoop2=Time::HiRes::time()+0.3; # 0.3s for other tasks

    if($RestartEvery && $itime >= $endtime) {
# time to quit -- after endtime and we're bored.
        &downASSP("restarting");
        _assp_try_restart;
    }

    if ($doShutdown > 0 && $itime >= $doShutdown) {
      &downASSP("restarting");
      _assp_try_restart;
    }
  }
  $isRunMainLoop2 = 0;
}

sub detectGhostCon {
    return unless $FreeupMemoryGarbage;
    my $count = 0;
    my $mem = 0;
    my $what;
    while ( my ($fh,$dummy) = each %Con) {
        next if $fh && exists $WebConH{$fh};
        next if $fh && exists $StatConH{$fh};
        next if $fh && exists $repollFH{$fh};
        if  (! $fh) {
           mlog(0,"error: detected unexpected garbage in the memory - please report to development") if $fh eq '0';
           delete $ConDelete{$fh};
           delete $SocketCalls{$fh};
           while (my ($k,$v) = each %{$Con{$fh}}) {
                if (ref($v) eq 'ARRAY') {
                    $v .= " @{$v}";
                } elsif (ref($v) eq 'HASH') {
                    while (my ($k1,$v1) = each %{$v}) {
                        $v .= " , '$k1,$v1'";
                    }
                }
                eval{$mem += length($v) + 8;};
                mlog(0,"info: memory garbage in : fh=$fh , key=$k , value=$v") if $MaintenanceLog > 2;
           }
           &printallCon($fh) if ($MaintenanceLog >= 2);
           $count++;
           delete $Con{$fh};
           delete $WebConH{$fh};
           delete $StatConH{$fh};
           next;
        }
        next if (fileno($Con{$fh}->{self}));
        next if $IOEngineRun == 0 && $readable->[3]{$fh};
        next if $IOEngineRun == 0 && $writable->[3]{$fh};
        next if (exists $ConDelete{$fh});
        next if ($Con{$fh}->{timestart} + 3600 > time);
        while (my ($k,$v) = each %{$Con{$fh}}) {
            if (ref($v) eq 'ARRAY') {
                $v .= " @{$v}";
            } elsif (ref($v) eq 'HASH') {
                while (my ($k1,$v1) = each %{$v}) {
                    $v .= " , '$k1,$v1'";
                }
            }
            eval{$mem += length($v) + 8;};
            mlog(0,"info: memory garbage in : fh=$fh , key=$k , value=$v") if $MaintenanceLog > 2;
        }
        $count++;
        &printallCon($fh) if ($MaintenanceLog >= 2);
        if ($WorkerNumber > 0) {
            &done2($fh);      # MainThread (Worker_0) never closes SMTP sockets here
            $what = 'SMTP';
        } else {
            unpoll($fh,$readable);
            unpoll($fh,$writable);
            delete $Con{$fh};
            delete $ConDelete{$fh};
            delete $SocketCalls{$fh};
            $what = 'SMTP and WEB';
        }
    }
    undef %Con unless keys(%Con);
    undef %ConDelete unless keys(%ConDelete);
    undef %SocketCalls unless keys(%SocketCalls);
    undef %repollFH unless keys(%repollFH);
    undef %WebConH unless keys(%WebConH);
    undef %MainLoopInWebFH unless keys(%MainLoopInWebFH);
    undef %StatConH unless keys(%StatConH);
    $mem = int(($count*128 + $mem)/1024 + 2);
    mlog(0,"info: cleaned $mem kbyte of memory from $count closed $what connections") if ($count && ($MaintenanceLog >= 2 or $ConnectionLog >= 2));
}

sub detectWebGhostCon {
    return unless $FreeupMemoryGarbage;
    my $count = 0;
    my $mem = 0;
    my %tCon = ();

    while ( my ($fh,$v) = each %WebConH) {
        $tCon{$fh} = $v;
    }
    while ( my ($fh,$v) = each %StatConH) {
        $tCon{$fh} = $v;
    }

    while ( my ($fh,$v) = each %tCon) {
        if  (! $fh) {
           eval{$mem += length($WebCon{$fh}) + 8;};
           eval{$mem += length($StatCon{$fh}) + 8;};
           $count++;
           delete $WebCon{$fh};
           delete $StatCon{$fh};
           delete $SocketCalls{$fh} if (exists $SocketCalls{$fh});
           mlog(0,"info: found \$fh == '$fh' in closed web connections") if $MaintenanceLog >= 2;
           next;
        }
        $fh = $WebConH{$fh} if $WebConH{$fh};
        $fh = $StatConH{$fh} if $StatConH{$fh};
        next if (fileno($fh));
        next if (exists $ConDelete{$fh});
        eval{$mem += length($WebCon{$fh}) + 8;};
        eval{$mem += length($StatCon{$fh}) + 8;};
        $count++;
        &WebDone($fh);
        delete $WebCon{$fh};
        delete $StatCon{$fh};
        delete $WebConH{$fh};
        delete $StatConH{$fh};
        delete $Con{$fh};
        delete $SocketCalls{$fh} if (exists $SocketCalls{$fh});
    }
    undef %Con unless keys(%Con);
    undef %ConDelete unless keys(%ConDelete);
    undef %SocketCalls unless keys(%SocketCalls);
    undef %repollFH unless keys(%repollFH);
    undef %WebConH unless keys(%WebConH);
    undef %MainLoopInWebFH unless keys(%MainLoopInWebFH);
    undef %StatConH unless keys(%StatConH);
    undef %WebIP unless keys(%WebIP);
    $mem = int(($count*128 + $mem)/1024 + 2);
    mlog(0,"info: cleaned $mem kbyte of memory from $count closed web connections") if $count && $MaintenanceLog >= 2;
}


sub SaveHash {
  my $HashName = shift;
  d("SaveHash - $HashName");
  &ThreadMaintMain2() if $WorkerNumber == 10000;
  my $filename;
  foreach my $dbGroup (@GroupList) {
      foreach my $dbGroupEntry (@$dbGroup) {
        my ($KeyName,$dbConfig,$CacheObject,$realFileName,$mysqlFileName,$FailoverValue,$mysqlTable) = split(/,/o,$dbGroupEntry);
        if ($KeyName eq $HashName){
            if (!(($CanUseTieRDBM or $CanUseBerkeleyDB) && ${$dbConfig} =~ /DB:/o)) {
               return  if (! ${$dbConfig});
               my $tempFile = "$base/$realFileName.tmp";
               my $bakfile = "$base/$realFileName.bak";
               $realFileName = "$base/$realFileName";
               $filename = $realFileName;
               $tempFile =~ s/\\/\//go;
               $bakfile =~ s/\\/\//go;
               $realFileName =~ s/\\/\//go;
               my $HASH;
               unless (open($HASH, '>',"$tempFile")) {
                   mlog(0,"error: unable to open $tempFile for writing - $!");
                   return;
               }
               binmode $HASH;
               print $HASH "\n";
               my $count = 0;
               my @h;
               {
                   lock(%$HashName) if is_shared(%$HashName) && $WorkerName ne 'Shutdown';
                   @h = sort keys %$HashName;
               }
               while (@h) {
                  (my $k = shift @h) or next;
                  my $v = ${$HashName}{$k};
                  print $HASH "$k\002$v\n";
                  $count++;
               }
               close $HASH;
               $! = undef;
               if (-e "$bakfile") {
                   unlink($bakfile);
                   if ($!) {
                       mlog(0,"error: unable to delete file $bakfile - $!");
                       return;
                   }
               }
               $! =undef;
               rename("$realFileName", "$bakfile") if (-e "$realFileName");
               if ($! && -e "$realFileName") {
                   mlog(0,"error: unable to rename file $realFileName to $bakfile - $!");
                   return;
               }
               $! = undef;
               rename("$tempFile", "$realFileName");
               if ($! && -e "$tempFile") {
                   mlog(0,"error: unable to rename file $tempFile to $realFileName - $!");
                   rename("$bakfile", "$realFileName");
                   mlog(0,"error: unable to rename file $bakfile to $realFileName - $!") if $!;
                   return;
               }
               mlog(0,"Info: $count records of $KeyName saved") if $MaintenanceLog;
               $FileHashUpdateTime{"$filename"} = ftime($realFileName);
               $FileHashUpdateHash{"$filename"} = $HashName;
            }
        }
      }
  }
  mlogWrite() if $WorkerNumber == 0;
}

sub LoadHash {
   my ($hash,$file,$ignorefile) = @_;
   my $LH;
   my @s = $stat->($file);
   my $size = $s[7];
   my $keys = $file =~ /black/io ? int($size * 2 / 80) + 128 : int($size * 2 / 26) + 128;
   my $count = 0;
   lock(%$hash) if is_shared(%$hash);
   unless (open($LH, '<',"$file")) {
       mlog(0,"warning: unable to open $file to load $hash");
       return;
   }
   binmode($LH);
   %$hash = ();
   keys (%$hash) = $keys;      # preallocate Memory for Hash
   while (<$LH>) {
     my ($k,$v) = split/\002/o;
     chomp $v;
     $v =~ s/\r|\n//go;
     if ($k && $v) {
       ${$hash}{$k}=$v;
       $count++;
     }
   }
   close $LH;
   mlog(0,"info: $hash loaded from $file with $count records") if $MaintenanceLog;
   if ($count > 1000) {
       foreach my $dbGroup (@GroupList) {
           foreach my $dbGroupEntry (@$dbGroup) {
               my ($KeyName,$dbConfig,$CacheObject,$realFileName,$mysqlFileName,$FailoverValue,$mysqlTable) = split(/,/o,$dbGroupEntry);
               next if $KeyName ne $hash;
               if ($count < 2000) {
                   mlog(0,"warning: $hash contains $count records - it is recommended to use a database for '$dbConfig' to prevent memory leaking") if (! $EnableHighPerformance || $EnableHighPerformance > 500);
               } else {
                   my $i = $count * 2;
                   my $exp = 7;
                   while ($i >= 2) {
                       $i = int($i / 2);
                       $exp++;
                   }
                   $i = 2 ** $exp + $count * 4 + ($size * ($NumComWorkers + 3));
                   mlog(0,"error: $hash contains $count records (allocating apx. " . &formatDataSize($i,1) . " shared memory) - it is highly recommended to use a database for '$dbConfig' to reduce memory usage and to prevent memory leaking") if (! $EnableHighPerformance || $EnableHighPerformance > 500);
               }
           }
       }
   }
   return if ($ignorefile);

   my $mtime=$s[9];
   $FileHashUpdateTime{"$file"} = $mtime;
   $FileHashUpdateHash{"$file"} = $hash;
}

sub getDBCount {
  my ($hash,$config) = @_;
  my $hashObject = $hash.'Object';
  my $i = 0;
  if ($hash eq 'HMMdb' && $runHMMusesBDB) {
      $i = BDB_getRecordCount($hash);
  } elsif ($DBusedDriver eq 'BerkeleyDB' && $CanUseBerkeleyDB && ${$config} =~ /DB:/o) {
      $i = BDB_getRecordCount($hash);
  } elsif (${$config} =~ /DB:/o) {
      $i = rdbm_COUNT(${$hashObject});
      if (! $i) {
          while (my ($k,$v) = each %{$hash}) {
              last if ++$i > 600;
          }
          if ($i) {
              my $table;
              eval {$table = ${$hashObject}->{table};};
              $table ||= 'N/A';
              mlog(0,"error: SQL -> 'SELECT COUNT(*) FROM $table' returned a zero count of records for '$hash', but there are at least $i records in table '$table' - check your database engine!");
          }
      }
  } else {
      $i = scalar keys %{$hash};
  }
  return $i;
}

sub SaveDelaydb {
  if ($delaydb !~ /DB:/o) {
    mlog(0,"saving delaying records") if $MaintenanceLog;
    &SaveHash('Delay');
    &SaveHash('DelayWhite');
  }
}

sub SaveLDAPlist {
  if ($ldaplistdb !~ /DB:/o) {
    mlog(0,"saving ldaplist") if $MaintenanceLog;
    &SaveHash('LDAPlist');
  }
}


sub SaveWhitelist {
 d('SaveWhitelist');
  &SaveWhitelistOnly();
  &SaveDelaydb();
  &SaveLDAPlist();
}

sub SaveWhitelistOnly {
 d('SaveWhitelistOnly');
 if ($UpdateWhitelist && $whitelistdb !~ /DB:/o) {
    mlog(0,"saving whitelist") if $MaintenanceLog;
    &SaveHash('Whitelist');
  }
  if ($UpdateWhitelist && $redlistdb !~ /DB:/o) {
    mlog(0,"saving redlist") if $MaintenanceLog;
    &SaveHash('Redlist');
  }
}

sub SavePB {
# save Penalty Box Databases
  if ($pbdb !~ /DB:/o) {
    mlog(0,"saving penalty records") if $MaintenanceLog;
    &SaveHash('PBBlack');
    &SaveHash('PBWhite');
    &SaveHash('PBTrap');
    mlog(0,"saving cache records") if $MaintenanceLog;
    &SaveHash('RBLCache');
    &SaveHash('URIBLCache');
    &SaveHash('SPFCache');
    &SaveHash('PTRCache');
    &SaveHash('MXACache');
    &SaveHash('SBCache');
    &SaveHash('RWLCache');
    &SaveHash('DKIMCache');
    &SaveHash('BATVTag');
    &SaveHash('BackDNS');
    mlog(0,"saving personal Black records") if $MaintenanceLog;
    &SaveHash('PersBlack');
  }
}

sub CleanPB {
# clean Penalty Box Databases
  &SavePB if (!$mysqlSlaveMode || $pbdb!~/DB:/o);
  mlog(0,"cleaning penalty records...") if $MaintenanceLog;
  &cleanBlackPB if $DoPenalty && $PBBlackObject;
  &cleanWhitePB if $PBWhiteObject;
  &cleanTrapPB if $PBTrapObject;
}

sub CleanCache {
  mlog(0,"cleaning cache records...") if $MaintenanceLog;
  &cleanCacheRBL() if $RBLCacheExp && $ValidateRBL;
  &cleanCacheURI() if $URIBLCacheInterval && $ValidateURIBL;
  &cleanCacheRWL() if $RWLCacheInterval && $ValidateRWL;
  &cleanCachePTR() if $PTRCacheInterval && $DoReversed;
  &cleanCacheMXA() if $DoDomainCheck && $MXACacheInterval;
  &cleanCacheSPF() if $ValidateSPF && $SPFCacheInterval;
  &cleanCacheDKIM() if $DoDKIM && $DKIMCacheInterval;
  &cleanCacheSB()  if $SBCacheExp;
  &cleanCacheBackDNS() if $BackDNSInterval;
  &cleanCachePersBlack();
}

sub CleanDelayDB {
  d('CleanDelayDB');
  &ThreadMaintMain2() if $WorkerNumber == 10000;
  mlog(0,"cleaning up delaying databases ...") if $MaintenanceLog;
  my $t=time;
  my $keys_before=my$keys_deleted=0;
  my $maxtime = $DelayEmbargoTime*60+$DelayWaitTime*3600;
  while (my ($k,$v)=each(%Delay)) {
    &ThreadMaintMain2() if $WorkerNumber == 10000 && ! $keys_before % 100;
    $keys_before++;
    if ($t-$v>=$maxtime) {
      delete $Delay{$k};
      $keys_deleted++;
    }
  }
  mlog(0,"cleaning delaying database (triplets) finished: keys before=$keys_before, deleted=$keys_deleted") if $MaintenanceLog && $keys_before != 0;
  $keys_before=$keys_deleted=0;
  $maxtime = $DelayExpiryTime*24*3600;
  while (my ($k,$v)=each(%DelayWhite)) {
    $keys_before++;
    if ($t-$v>=$maxtime) {
      delete $DelayWhite{$k};
      $keys_deleted++;
    }
  }
  mlog(0,"cleaning delaying database (safelisted tuplets) finished: keys before=$keys_before, deleted=$keys_deleted") if $MaintenanceLog && $keys_before != 0;
  &SaveDelaydb();
}

# global/domain and personal Whitelist handling
sub Whitelist {
    my($mf,$to,$action)=@_;
    d("Whitelist $mf,$to,$action");
    @WhitelistResult = ();
    $mf = batv_remove_tag(0,lc $mf,'') if $mf;
    $to = batv_remove_tag(0,lc $to,'') if $to;
    $to =~ s/^,//o;
    my $toDomain;
    $toDomain = $1 if $to =~ /(\@$EmailDomainRe)$/o;
    $to = undef if $to =~ /^\@$EmailDomainRe$/o;
    $action = lc $action;
    my $globWhite = $WhitelistPrivacyLevel&&defined${chr(ord(",")<< 1)}?($toDomain&&defined${chr(ord(",")<< 1)}?($WhitelistPrivacyLevel==2?undef:$Whitelist{"$mf,$toDomain"}):undef):$Whitelist{$mf};
    my $persWhite = $to?$Whitelist{"$mf,$to"}:undef;
    my $time = time;
    if (! $action) {                  # is there any Whitelist entry
        return 0 if $persWhite > 9999999999;       # a deleted personal
        return ($persWhite or $globWhite) ? 1 : 0;      # a personal or global
    } elsif ($action eq 'add') {
        if ($to) {$Whitelist{"$mf,$to"} = $time; push @WhitelistResult, "$mf,$to added to Whitelist<br />";};
        if ($toDomain) {$Whitelist{"$mf,$toDomain"} = $time ; push @WhitelistResult, "$mf,$toDomain added to Whitelist<br />";};
        $Whitelist{$mf} = $time;
        push @WhitelistResult, "$mf added to Whitelist<br />";
        return;
    } elsif ($action eq 'delete') {
        if ($to) {
            push @WhitelistResult, "$mf,$to removed from Whitelist<br />" if $Whitelist{"$mf,$to"} < 9999999999;
            $Whitelist{"$mf,$to"} = $time + 9999999999;  # delete the personal
        } elsif ($toDomain) {
            push @WhitelistResult, "$mf,$toDomain removed from Whitelist<br />" if delete $Whitelist{"$mf,$toDomain"};
            ThreadMonitorMainLoop("delete Whitelist $mf,\*$toDomain");
            if ($DoSQL_LIKE && "$WhitelistObject" =~ /Tie\:\:RDBM/o) {
#                $toDomain =~ s/([_%])/:$1/go;
#                $mf =~ s/([_%])/:$1/go;
#                my $res = $WhitelistObject->rdbm_RunSTM("WLRDOM",
#"DELETE FROM $WhitelistObject->{table} WHERE $WhitelistObject->{key} LIKE $mf,\%$toDomain ESCAPE ':' AND $WhitelistObject->{value} < '9999999999'");
#                $res ||= 'NO';
#                push @WhitelistResult, "$res privat records removed from Whitelist<br />"
                delete $Whitelist{"$mf,\*$toDomain"};
            } else {
                my $i;
                while (my ($k,$v) = each(%Whitelist)) {      # and not already removed personal
                    if ($k =~ /^\Q$mf\E,$EmailAdrRe\Q$toDomain\E$/) {
                        push @WhitelistResult, "k removed from Whitelist<br />" if delete $Whitelist{$k}; # $Whitelist{$k} < 9999999999 ???
                    }
                    unless (++$i % 1000) {
                        ThreadMonitorMainLoop("delete Whitelist $mf,\*$toDomain");
                        $WorkerLastAct{$WorkerNumber} = time if $WorkerNumber > 0 && $WorkerNumber < 10000;
                    }
                }
            }
        } else {
            push @WhitelistResult, "$mf removed from Whitelist<br />" if delete $Whitelist{$mf}; # delete the global entry;
            ThreadMonitorMainLoop("delete Whitelist $mf,*");
            if ($DoSQL_LIKE && "$WhitelistObject" =~ /Tie\:\:RDBM/o) {
#                $mf =~ s/([_%])/:$1/go;
#                my $res = $WhitelistObject->rdbm_RunSTM("WLRALL",
#"DELETE FROM $WhitelistObject->{table} WHERE $WhitelistObject->{key} LIKE $mf,\% ESCAPE ':' AND $WhitelistObject->{value} < '9999999999'");
#                $res ||= 'NO';
#                push @WhitelistResult, "$res privat records removed from Whitelist<br />"
                delete $Whitelist{"$mf,*"};
            } else {
                my $i;
                while (my ($k,$v) = each(%Whitelist)) {      # and not already removed personal
                    if ($k =~ /^\Q$mf\E,/) {
                        push @WhitelistResult, "$k removed from Whitelist<br />" if delete $Whitelist{$k}; # $Whitelist{$k} < 9999999999 ???
                    }
                    unless (++$i % 1000) {
                        ThreadMonitorMainLoop("delete Whitelist $mf,*");
                        $WorkerLastAct{$WorkerNumber} = time if $WorkerNumber > 0 && $WorkerNumber < 10000;
                    }
                }
            }
        }
    }
}

sub CleanWhitelist {
  d('CleanWhitelist');
  &ThreadMaintMain2() if $WorkerNumber == 10000;
  mlog(0,"cleaning up whitelist database ...") if $MaintenanceLog;
  my $t=time;
  my $keys_before = my $keys_deleted = 0;
  my $maxtime = $MaxWhitelistDays * 3600 * 24;
  if ($MaxWhitelistDays) {
      while (my ($k,$v)=each(%Whitelist)) {
        &ThreadMaintMain2() if $WorkerNumber == 10000 && ! $keys_before % 100;
        $keys_before++;
        $v = 0 unless $v;
        next if $v < 1000000000;
        my $delta = $t-$v;
        if ($delta >= $maxtime or ($k=~/,/o && $v > 9999999999 && $delta + 9999999999 >= $maxtime)) {
          delete $Whitelist{$k};
          $v -= 9999999999 if $v > 9999999999;
          mlog(0,"Admininfo: $k removed from whitelistdb - entry was outdated (" . &timestring($v,'') . ')') if $MaintenanceLog >= 2;
          $keys_deleted++;
        }
      }
      mlog(0,"cleaning whitelist database finished: keys before=$keys_before, deleted=$keys_deleted") if $keys_before && $MaintenanceLog;
  }
  &SaveWhitelistOnly();
}

# AZ: 2009-03-10 - win32 debug/trace output wrapper
# this function allows to to see the live log/trace using
# http://technet.microsoft.com/en-us/sysinternals/bb896647.aspx
sub w32dbg {
    OutputDebugString('(ASSP): ' . shift);
}

sub mlogRe{
	my($fh,$subre,$regextype,$check)=@_;
	my $this = exists $Con{$fh} ? $Con{$fh} : {};
	$subre =~ s/\s+/ /go;
	$subre=substr($subre,0,$RegExLength);
	$this->{messagereason}="Regex:$regextype '$subre'";
 	$this->{myheader}.="X-Assp-Re-$regextype: $subre\r\n" if $AddRegexHeader;
    my $m;
	$m = $check . ' ' if $check;
	$m .= $this->{messagereason};
	mlog( $fh, $m, 1, 1 ) if $regexLogging;
}

sub mlogWrite {
    return if $WorkerNumber;
    my @m;
    my $items;
    threads->yield();
    &debugWrite();
    threads->yield;
    $items = $mlogQueue->pending();
    $refreshWait = (time - $lastmlogWrite) > 5 ? 5 : 1;
    return if (! $items);
    threads->yield();
    @m = $mlogQueue->dequeue_nb($items);
    threads->yield();
    my @tosyslog;
    while (@m) {
       my $logline = my $line = de8(shift @m);
       if ($CanUseTextUnidecode && $Unidecode2Console) {
           eval{
               $line = eval{Text::Unidecode::unidecode(d8($line));};
           } or print "con uni-decoding error: $@";
       } else {
           eval{
               Encode::from_to($line,'UTF-8',$ConsoleCharset,sub { return '?'; })
                   if $ConsoleCharset && $ConsoleCharset !~ /utf-?8/oi;
               1;
           } or print "con encoding error: $@";
       }
       push @tosyslog,substr($line,length($LogDateFormat)) if ($sysLog && ($CanUseSyslog || ($sysLogPort && $sysLogIp)));
       if ($line !~ /\*\*\*assp\&is\%alive\$\$\$/o) {
           print $line unless ($silent);
           w32dbg($line) if ($CanUseWin32Debug);
           print $LOG $logline if ($logfile && $asspLog && fileno($LOG));
           print $LOGBR $logline if ($logfile &&
                                     $asspLog &&
                                     fileno($LOGBR) &&
                                     $ExtraBlockReportLog &&
                                     $logline =~ /\[\s*spam\sfound\s*\]/io);
       }
       if ($logline !~ /page:\/maillog|\*\*\*assp\&is\%alive\$\$\$/o) {
           shift @RealTimeLog if (@RealTimeLog > 33);
           push @RealTimeLog, $logline;
           $lastmlogWrite = time;
       }
    }
    tosyslog('info', \@tosyslog) if (@tosyslog && $sysLog && ($CanUseSyslog || ($sysLogPort && $sysLogIp)));
    $MainThreadLoopWait = 1;
}

sub debugWrite {
    my @m;
    my $items = $debugQueue->pending();
    if ((! $debugIP && ! $debugRe && ! $debugCode && ! $debug && $DEBUG && $DEBUG->opened) or ($lastDebugPrint && time - $lastDebugPrint > 600)) {
        mlog(0,'info: partial debug mode stopped');
        eval{$lastDebugPrint = 0; $DEBUG->close;};
    }
    return if (! $items);
    if (! $DEBUG || ! $DEBUG->opened) {
        my $file = "$base/debug/".time.".dbg";
        open($DEBUG, '>',"$file");
        binmode($DEBUG);
        $DEBUG->autoflush;
        print $DEBUG $UTF8BOM;
        print $DEBUG "running ASSP version: $main::MAINVERSION\n\n";
        mlog(0,"info: starting partial debug mode to file $file");
    }
    threads->yield();
    @m = $debugQueue->dequeue_nb($items);
    threads->yield();
    while (@m && $DEBUG) {
       print $DEBUG shift @m;
    }
    $lastDebugPrint = time unless ($debug);
}

sub mlog_i {
    my ( $fh, $comment, $noprepend, $noipinfo ) = @_;
    mlog( $fh, $comment, $noprepend, $noipinfo );
    &mlogWrite() if $WorkerNumber == 0;
}

sub mlog_S {
    my ( $Sfh, $Scomment, $Snoprepend, $Snoipinfo ) = @_;
    push @mlogS, [ $Sfh, $Scomment, $Snoprepend, $Snoipinfo , 1];
}

sub mlog {
    my ( $fh, $comment, $noprepend, $noipinfo , $noS) = @_;
    threads->yield();
    unless ($noS) {
        while (my $ar = shift @mlogS) {
            mlog(@$ar);
        }
    }
    $fh = 0 unless $fh;
    my $this = $fh ? exists $Con{$fh} ? $Con{$fh}: 0 : 0;
    my $header;
    my $noNotify = $comment =~ s/^\*x\*//o;
    my $logfile = $logfile;
    $logfile =~ s/\\/\//go;
    my $archivelogfile;
    my $archivelogfileBR;
    if ($WorkerNumber == 0) {
        if ($comment =~ /^(?:adminupdate|configerror)\:/io && ($WebIP{$ActWebSess}->{user} or $syncUser)) {
            $comment =~ s/^(adminupdate|configerror)(\:)/$1$2 \[$WebIP{$ActWebSess}->{user} $WebIP{$ActWebSess}->{ip}\]/io
                if (! $syncUser);
            $comment =~ s/^(adminupdate|configerror)(\:)/$1$2 \[$syncUser $syncIP\]/io
                if ($syncUser);
        }
        PrintConfigHistory($comment) if $comment =~ /^adminupdate/io;
        PrintConfigHistory($comment) if $comment =~ /^configerror/io;
        PrintAdminInfo($comment)     if $comment =~ /^admininfo/io;
        PrintAdminInfo($comment)     if $comment =~ /^email(?:[:])? /io;
        $lastMlog = time unless $comment;
    }

    my $m = &timestring();
    my ($sec,$min,$hour,$mday,$mon,$year) = localtime(time);

    if($LogRollDays > 0 && $WorkerNumber == 0 && ! $comment) {

            # roll log every $LogRollDays days, at midnight
            my $t=int((time + $TimeZoneDiff)/($LogRollDays*24*3600));
            if($logfile && $mlogLastT && $t != $mlogLastT && $logfile ne 'maillog.log' && $asspLog) {

                # roll the log
                my ($sec,$min,$hour,$mday,$mon,$year) = localtime(time - 7200);  # get the previouse day for logfile name

                $mon++; $year-=100;
                my $mm; $mm=sprintf("%02d-%02d-%02d",$year,$mon,$mday) if !$LogNameMMDD;
                $mm=sprintf("%02d-%02d",$mon,$mday) if $LogNameMMDD;
                my ($logdir, $logdirfile);
                ($logdir, $logdirfile) = ($1,$2) if $logfile=~/^(.*)[\/\\](.*?)$/o;
                if (!$logdir)  {
                    $archivelogfile = "$mm.$logfile";
                    $archivelogfileBR = "$mm.b$logfile";
                } else {
                    mkdir "$base/$logdir",0755;
                    $archivelogfile = "$logdir/$mm.$logdirfile";
                    $archivelogfileBR = "$logdir/$mm.b$logdirfile";
                }
                my $msg="$m: Rolling log file -- archive will be saved as '$archivelogfile'\n";
                w32dbg("$m: Rolling log file -- archive will be saved as '$archivelogfile'") if ($CanUseWin32Debug);
                print $LOG $msg if fileno($LOG);
                print $msg unless $silent;
                &closeLogs();
                sleep 1;
                $ThreadIdleTime{$WorkerNumber} += 1;
                if ($ExtraBlockReportLog) {
                    rename("$base/$blogfile", "$base/$archivelogfileBR");
                    my $e = $!;
                    if ($e && ! -e "$base/$archivelogfileBR") {
                        print "error: unable to rename file $base/$blogfile to $base/$archivelogfileBR - $e\n";
                        threads->yield();
                        $mlogQueue->enqueue("error: unable to rename file $base/$blogfile to $base/$archivelogfileBR - $e\n");
                        threads->yield();
                    }
                }
                rename("$base/$logfile", "$base/$archivelogfile");
                my $e = $!;
                if ($e && ! -e "$base/$archivelogfile") {
                    print "error: unable to rename file $base/$logfile to $base/$archivelogfile - $e\n";
                    threads->yield();
                    $mlogQueue->enqueue("error: unable to rename file $base/$logfile to $base/$archivelogfile - $e\n");
                    threads->yield();
                }
                &openLogs();
                print $LOG "$m $WorkerName new log file -- old log file renamed to '$archivelogfile'\n" if fileno($LOG);
                print $LOG "$m $WorkerName new blog file -- old log file renamed to '$archivelogfileBR'\n" if $ExtraBlockReportLog && fileno($LOG);
                w32dbg("$m $WorkerName new log file -- old log file renamed to '$archivelogfile'") if ($CanUseWin32Debug);
                w32dbg("$m $WorkerName new log file -- old log file renamed to '$archivelogfileBR'") if $CanUseWin32Debug && $ExtraBlockReportLog;
            }
            $mlogLastT=$t;
    }

    return 1 if((! $comment || $comment =~ /^[\s\r\n]+$/o) && ($fh == 0 || $WorkerNumber == 0));

    my @m;
    if ($this) {
        $m .= " $this->{msgtime}" if $this->{msgtime};
        if ($WorkerLogging) {
            $m .= " \[$WorkerName\]";
            if ("$fh" =~ /SSL/io or "$this->{friend}" =~ /SSL/io) {
                $m .= ("$fh" =~ /SSL/io && $this->{oldfh})
                    ? ' [TLS-in]' : ("$fh" =~ /SSL/io && ! $this->{oldfh})
                    ? ' [SSL-in]' : '';
                $m .= ("$this->{friend}" =~ /SSL/io && $Con{$this->{friend}}->{oldfh})
                    ? ' [TLS-out]' : ("$this->{friend}" =~ /SSL/io && ! $Con{$this->{friend}}->{oldfh})
                    ? ' [SSL-out]' : '';
            }
        }
        $m .= " $this->{prepend}" if $tagLogging && $this->{prepend} && !$noprepend;

        if ($expandedLogging || $noipinfo >= 2 || (! $this->{loggedIpFromTo} && !$noipinfo)) {
            $m .= " $this->{ip}" if ($this->{ip});
            $m .= " [OIP: $this->{cip}]" if ($this->{cip});
            my $mf = &batv_remove_tag(0,$this->{mailfrom},'');
            $m .= " <$mf>" if ($mf);
            my $to;
            $to = $this->{orgrcpt} if $noipinfo == 3;
            ($to) = $this->{rcpt} =~ /(\S+)/o unless $to;
            my $mm = $m;
            if ($to) {
                $this->{loggedIpFromTo} = 1 if $noipinfo < 3;
                $m .= " to: $to";
            }
            if ($noipinfo < 3 && $comment =~ / \[(?:spam found|MessageOK)\] /oi) {
                my $c = $comment;
                $c =~ s/\r//go;
                $c =~ s/\n([^\n]+)/\n\t$1/go;
                $c .= "\n" if ($c !~ /\n$/o);
                my %seen;
                for (split(/\s+/o,$this->{rcpt})) {
                    next unless $_;
                    next if $seen{lc $_};
                    $seen{lc $_} = 1;
                    push @m, "$mm to: $_ $c";
                }
            }
        }

        $m .= " $comment";
    } else {
        $m .= " \[$WorkerName\]" if $WorkerLogging;
        $m .= ' ' . ucfirst($comment);
    }

    if ($canNotify &&
        ! $noNotify &&
        scalar keys %NotifyRE &&
        $m =~ /$NotifyReRE/ &&
        $m !~ /$NoNotifyReRE/ &&
        NotifyFrequencyOK($comment) )
    {
        my $rcpt;
        my $sub;
        while (my ($k,$v) = each %NotifyRE) {
            if ($m =~ /$k/i) {
                $rcpt = $v;
                $sub = $NotifySub{$k} . " from $myName" if exists $NotifySub{$k};
                last;
            }
        }
        $sub ||= "ASSP event notification from $myName";
        &sendNotification(
          $EmailFrom,
          $rcpt,
          $sub,
          "log event on host $myName:\r\n\r\n$comment\r\n") if $rcpt;
    }


    $m =~ s/\r//go;
    $m =~ s/\n([^\n]+)/\n\t$1/go;
    $m .= "\n" if ($m !~ /\n$/o);

    threads->yield();
    $debugQueue->enqueue(scalar @m ? @m : $m) if ($debug || $ThreadDebug);
    threads->yield();

    return 1 if($noLogLineRe && $m =~ /$noLogLineReRE/);

    if ($this) {
        if ($noLog && $fh && exists $Con{$fh} &&  ($this->{noLog} || $this->{nomlog} || &matchIP($Con{$fh}->{ip},'noLog',0,1) || ($Con{$fh}->{friend} && &matchIP($Con{$Con{$fh}->{friend}}->{ip},'noLog',0,1)))) {
            $this->{nomlog} = 1;
            return 1;
        }
        $header = substr($this->{header},0,$MaxBytes + $this->{headerlength}) if ($fh && $MaxBytes && !$this->{noLog} && $noLogRe);
        if ($this->{noLog} ||
            ($noLogRe &&
             (( $this->{mailfrom} && $this->{mailfrom} =~ /$noLogReRE/)
             || ( $header =~ /$noLogReRE/))))
        {
            $this->{noLog} = 1 if ($fh);
            return 1;
        }
    }
    
    threads->yield();
    $mlogQueue->enqueue(scalar @m ? @m : $m);
    threads->yield();
    $MainThreadLoopWait = 0;
    return 1;
}

sub NotifyFrequencyOK {
    my $text = shift;
    return 1 if eval{$DEBUG && $DEBUG->opened;};
    return 1 unless keys %NotifyFreqTF;
    return 1 if $text !~ /^(info|warning|error)\s*:/oi;
    return 1 unless $NotifyFreqTF{$1};
    return 0 if $NotifyLastFreq{$1} + $NotifyFreqTF{$1} > time;
    $NotifyLastFreq{$1} = time;
    return 1;
}

sub tosyslog {
  my ($priority, $m) = @_;
  return 0 unless ($priority =~ /info|err|debug/o);
  return 1 if $syslogNextTry && time < $syslogNextTry;

  eval{
   if ($sysLogPort && $sysLogIp) {
       $SysLogObj ||= ASSP::Syslog->new(Facility=>$SysLogFac,Priority=>'Debug',SyslogPort=>$sysLogPort,SyslogHost=>$sysLogIp);
       while (@$m) {
           my $msg = shift @$m;
           $msg =~ s/^\s+//o;
           eval{$SysLogObj->send($msg,Priority=>$priority);};
           if ($@) {
               undef $SysLogObj;
               $syslogNextTry = time + 60;
               mlog(0, "warning: unable to contact syslog server $sysLogIp:$sysLogPort");
               return 0;
           } else {
               $syslogNextTry = 0;
           }
       }
   } elsif ($CanUseSyslog) {
       setlogsock('unix');
       openlog('assp', 'pid,cons', 'mail');
       while (@$m) {
           my $msg = shift @$m;
           $msg =~ s/^\s+//o;
           syslog($priority, $msg);
       }
       closelog();
   }
  };
  if ($@) {
      $syslogNextTry = time + 60;
      undef $SysLogObj;
      mlog(0, "warning: syslog error - $@");
      return 0;
  } else {
      $syslogNextTry = 0;
  }
  return 1;
}

sub tzStr {
# calculate the time difference in minutes
my $minoffset = $TimeZoneDiff / 60;

# translate it to "hour-format", so that 90 will be 130, and -90 will be -130
  my $sign=$minoffset<0?-1:+1;
  $minoffset = abs($minoffset)+0.5;
  my $tzoffset = 0;
  $tzoffset = $sign * (int($minoffset/60)*100 + ($minoffset%60)) if $minoffset;
# apply final formatting, including +/- sign and 4 digits
  return sprintf("%+05d", $tzoffset);
}
sub getTimeDiffAsString {

	my ($tdiff,$seconds) = @_;

	my $days  = int( $tdiff / 86400 );
	my $hours = int( ( $tdiff - ( $days * 86400 ) ) / 3600 );
	my $mins  = int( ( $tdiff - ( $days * 86400 ) - ( $hours * 3600 ) ) / 60 );
	my $secs  = int( $tdiff - ( $days * 86400 ) - ( $hours * 3600 ) - ( $mins * 60 ) );

	my $ret;
	$ret = $days . " day" . ( $days == 1 ? ' ' : "s " );
	$ret .= $hours . " hour" . ( $hours == 1 ? ' ' : "s " );
	$ret .= $mins . " min" .   ( $mins == 1  ? ' ' : "s " );
	$ret .= $secs . " sec" .   ( $secs == 1  ? ' ' : "s " ) if $seconds;

	return $ret;
}

sub getTimeDiff {
	my ($tdiff,$seconds) = @_;
    my $m = getTimeDiffAsString($tdiff,$seconds);
    $m =~ s/^0 hours //o if ($m =~ s/^0 days //o);
    return $m;
}
#####################################################################################
#                Socket handlers
sub setSSLfailed {
    my $ip = shift;
    return unless $banFailedSSLIP;
    if (exists $SSLfailed{$ip}) {   # ban if it failes before
        $SSLfailed{$ip} = time;
    } elsif (($banFailedSSLIP & 1) && (matchIP($ip,'acceptAllMail',0,1) or $ip =~ /$IPprivate/o)) {  # give privates one more chance
        $SSLfailed{$ip} = 0;
    } elsif ($banFailedSSLIP & 2) {
        $SSLfailed{$ip} = time;    # ban external IP if it failes before
    }
    return;
}

sub switchSSLClient {
    my $fh =shift;
    my $sslfh;
    my $try = 4;
    eval{$fh->blocking(1);};
    $sslfh = IO::Socket::SSL->start_SSL($fh,{
             SSL_startHandshake => 1,
             getSSLParms(1)
             });
    while ($try-- && "$sslfh" !~ /SSL/io && ($IO::Socket::SSL::SSL_ERROR == eval('SSL_WANT_READ') ? 1 : $IO::Socket::SSL::SSL_ERROR == eval('SSL_WANT_WRITE') ) && $SSLRetryOnError)
    {
         &ThreadYield();
         Time::HiRes::sleep(0.5);
         $ThreadIdleTime{$WorkerNumber} += 0.5;
         mlog($fh,"info: retry ($try) SSL negotiation - peer socket was not ready");
         
         $sslfh = IO::Socket::SSL->start_SSL($fh,{
             SSL_startHandshake => 1,
             getSSLParms(1)
             });
    }
    if ("$sslfh" =~ /SSL/io) {
        eval{$sslfh->blocking(0);};
    } else {
        eval{$fh->blocking(0);};
    }
    return $sslfh,$fh;
}
sub switchSSLServer {
    my $fh =shift;
    my $sslfh;
    my $try = 4;
    eval{$fh->blocking(1);};
    $sslfh = IO::Socket::SSL->start_SSL($fh,{
             SSL_startHandshake => 1,
             getSSLParms(0)
             });
    while ($try-- && "$sslfh" !~ /SSL/io && ($IO::Socket::SSL::SSL_ERROR == eval('SSL_WANT_READ') ? 1 : $IO::Socket::SSL::SSL_ERROR == eval('SSL_WANT_WRITE') ) && $SSLRetryOnError)
    {
         &ThreadYield();
         Time::HiRes::sleep(0.5);
         $ThreadIdleTime{$WorkerNumber} += 0.5;
         mlog($fh,"info: retry ($try) SSL negotiation - peer socket was not ready");

         $sslfh = IO::Socket::SSL->start_SSL($fh,{
             SSL_startHandshake => 1,
             getSSLParms(0)
             });
    }
    if ("$sslfh" =~ /SSL/io) {
        eval{$sslfh->blocking(0);};
    } else {
        eval{$fh->blocking(0);};
    }
    return $sslfh,$fh;
}

sub matchFH {
    my ($fh, @fhlist) = @_;
    return 0 unless scalar @fhlist;
    return 0 unless $fh;
    my $sinfo;
    if (exists $Con{$fh} && $Con{$fh}->{localip} && $Con{$fh}->{localport}) {
        $sinfo = $Con{$fh}->{localip} . ':' . $Con{$fh}->{localport};
    }
    $sinfo ||= $fh->sockhost() . ':' . $fh->sockport();
    $sinfo =~ s/:::/\[::\]:/o;

    while (@fhlist) {
        my $lfh = shift @fhlist;
        if ($lfh =~ /^(?:0\.0\.0\.0|\[::\])(:\d+)$/o) {
            my $p = $1;
            return 1 if ($sinfo =~ /$p$/);
        }
        return 1 if ($sinfo eq $lfh);
    }
    return 0;
}

sub NewSMTPConCall {
    return unless scalar keys %SocketCallsNewCon;
    &sigoffTry(__LINE__);
    while (my ($k,$v) = each %SocketCallsNewCon) {
        $v->($k);
    }
    &sigonTry(__LINE__);
}

sub NewSMTPConnectionConnect {
    my $fhh=shift;
    my $fnoC;
    my $fnoS;
    my $timeout;
    my $isSSL = "$fhh" =~ /SSL/io;
    my $client;
    my $mlog = $inSIG ? \&mlog_S : \&mlog ;
    my $d = $inSIG ? \&d_S : \&d ;
    delete $SocketCalls{$fhh};
    $d->('NewSMTPConnectionConnect');
    eval{$timeout = $fhh->timeout();};
    my $tout = $isSSL ? $SSLtimeout : 2;
    eval{$fhh->timeout($tout) if (! $timeout || $timeout < $tout);};
    if(!($client=$fhh->accept)) {
        my $error = $!;
        eval{$timeout = $fhh->timeout();};
        $mlog->(0,"error: $WorkerName accept to client failed $fhh (timeout: $timeout s) : $error");
        $d->("accept failed: $fhh : $error") unless $inSIG;
        threadConDone($fhh);
        $! = '';
        close($fhh);
        $mlog->(0,"error: $WorkerName close failed on $fhh : $!") if ($!);
        threads->yield;
        $trqueue->enqueue("failed");  # tell the main thread that we are not connected!
        threads->yield;
        $mlog->(0,"info: $WorkerName freed Main_Thread (no accept)") if($WorkerLog >= 2);
        $d->('NewSMTPConnectionConnect - no accept');
        exists $Con{$fhh} && delete $Con{$fhh};
        return;
    }
    threadConDone($fhh);
    close($fhh);
    exists $Con{$fhh} && delete $Con{$fhh};
    if (exists $Con{$client}) {
        $mlog->(0,"error: internal Perl error in $WorkerName, area for $client still exists");
        threadConDone($client);
        eval{close($client)};
        threads->yield;
        $trqueue->enqueue("failed");  # tell the main thread that we are not connected!
        threads->yield;
        return;
    }
    threads->yield;
    $trqueue->enqueue("ok");       # tell the main thread that we are connected!
    threads->yield;
    $fnoC = fileno($client);
    $mlog->(0,"info: $WorkerName freed Main_Thread - $fnoC") if($WorkerLog >= 2);
    $client->blocking(0);
    $SocketCalls{$client} = \&NewSMTPConnection;
    $SocketCallsNewCon{$client} = \&NewSMTPConnection;
    $Con{$client} = {};
    $Con{$client}->{timelast} = $Con{$client}->{timestart} = time;
    $Con{$client}->{socketcalls} = 0;
    $Con{$client}->{type} = 'C';
    $Con{$client}->{self} = $client;
    $Con{$client}->{fno} = $fnoC;
    $Con{$client}->{peerhost} = $client->peerhost();
    $Con{$client}->{peerport} = $client->peerport();
    my $n = scalar keys %SocketCalls;
    $ComWorker{$WorkerNumber}->{numActCon} = int(($n+1)/2);      # set the number of active connection in thread
    threads->yield;
}

sub NewSMTPConnection {
    my $client=shift;
    my $tclient = $Con{$client}->{self};
    if ($tclient) {
        $client = $tclient;
    } else {
        eval {
            threadConDone($client);
            delete $SocketCallsNewCon{$client};
            delete $SocketCalls{$client};
            close($client) if fileno($client);
        };
        return;
    }
    my $fnoC;
    my $fnoS;
    my $timeout;
    my $isSSL;
    my ($server, $destination, $relayok, $AVa, $relayused);
    delete $SocketCallsNewCon{$client};
    delete $SocketCalls{$client};
    if(&matchFH($client,@lsnRelayI)) {

        # a relay connection -- destination is the relayhost if defined
        d('NewSMTPConnection - relay OK');
        $relayok=1;
        $relayused = 1;
        $destination = $relayHost ? $relayHost : $smtpDestination;
    } elsif(&matchFH($client,@lsn2I) && $smtpAuthServer ne '') {

        # connection on the Second Listen port
        d('NewSMTPConnection - AuthServer OK');
        $relayok=0;
        $destination=$smtpAuthServer;
    } elsif (&matchFH($client, @lsnSSLI) && $smtpDestinationSSL ne '' ) {

        # connection on the the secure SSL port
        d('NewSMTPConnection - SSL port');
        $destination = $smtpDestinationSSL;
        $relayok=0;
        $isSSL = 1;
    } else {
        d('NewSMTPConnection - no relay');
        $destination=$smtpDestination;
        $relayok=0;
        if(&matchFH($client,@lsnSSLI)) {
            $isSSL = 1;
        }
    }
    $fnoC = $Con{$client}->{fno} || fileno($client);
    my $ip = $Con{$client}->{peerhost} = $Con{$client}->{peerhost} || $client->peerhost()
       ||
       do {
           mlog(0,"error: This system is some time unable to detect connected IP addresses - check that you use the latest C-library, Perl-version and Perl module versions") if $ConnectionLog;
           undef;
       };
    my $port     = $Con{$client}->{peerport} || $client->peerport();
    my $localip  = $client->sockhost();
    my $localport= $client->sockport();
    my $ret;

    if (! $ThreadDebug && (&matchIP($localip,'debugIP',0,0) or ($ip && &matchIP($ip,'debugIP',0,0)))) {
       $ThreadDebug = 1;
    }

    # shutting down ?
    if ($shuttingDown) {
        mlog(0,"connection from $ip:$port rejected -- shutdown/restart process is in progress");

        my $out = "421 <$myName> Service not available, closing transmission channel\r\n";
        &NoLoopSyswrite($client,$out,0) if $ip;
        threadConDone($client);
        delete $Con{$client};
        close($client);
        d('NewSMTPConnection - shutdown detected');
        return;
    }

    $Stats{smtpConnSSL}++ if $isSSL;
    $Con{$client}->{timestart} = Time::HiRes::time();

    # SSL error in the past
    if ($ip && $isSSL && $SSLfailed{$ip}) {
        mlog(0,"connection from $ip:$port rejected -- IP has failed SSL in the past");

        my $out = "421 <$myName> SSL-Service not available for IP $ip, closing transmission channel\r\n";
        &NoLoopSyswrite($client,$out,0) if $ip;
        threadConDone($client);
        delete $Con{$client};
        close($client);
        d('NewSMTPConnection - IP has failed SSL in the past');
        return;
    } elsif ($ip && $isSSL && exists $SSLfailed{$ip}) {
        delete $SSLfailed{$ip};
    }

    if ($ip && $EmergencyBlock{$ip}) {
        mlog( $client, "$ip:$port denied by internal EMERGENCY Blocker - this IP has possibly tried before to KILL assp" );
        mlog( $client, "$ip:$port ATTENTION ! The EMERGENCY blocking for this IP will be lifted after an ASSP restart or at least in 15 minutes" );
        $Stats{denyConnectionA}++;
        $Con{$client}->{type} = 'C';
        &NoLoopSyswrite($client,"554 <$myName> Service denied, closing transmission channel\r\n",0);
        $Con{$client}->{error} = '5';
        done($client);
        return;
    }

    my $byWhatList = 'denySMTPConnectionsFromAlways';
    if ($ip && $denySMTPstrictEarly) {
        $ret = matchIP( $ip, 'denySMTPConnectionsFromAlways', $client,0 );
        $ret = matchIP( $ip, 'droplist', $client,0 ) if (! $ret && ($DoDropList == 2 or $DoDropList == 3) && ($byWhatList = 'droplist')) ;
    }

    if ($ip &&
        $denySMTPstrictEarly &&
        $ret &&
        $DoDenySMTPstrict &&
        ! matchIP( $ip, 'noPB', 0, 1 ) &&
        ! matchIP( $ip, 'noBlockingIPs', 0, 1 )
        )
    {
        $Con{$client}->{prepend} = "[DenyStrict]";
        if ($DoDenySMTPstrict == 1) {
            mlog( $client, "$ip:$port denied by $byWhatList strict: $ret" )
              if $denySMTPLog || $ConnectionLog >= 2;
            $Stats{denyConnectionA}++;
            $Con{$client}->{type} = 'C';
            &NoLoopSyswrite($client,"554 <$myName> Service denied, closing transmission channel\r\n",0);
            $Con{$client}->{error} = '5';
            done($client);
            return;
        } elsif ($DoDenySMTPstrict == 2) {
            mlog( $client, "[monitoring] $ip:$port denied by $byWhatList strict: $ret" )
              if $denySMTPLog || $ConnectionLog >= 2;
            $Con{$client}->{prepend} = '';
        }
    }

    # ip connection limiting  parallel session
    my $doIPcheck;
    $maxSMTPipSessions=999 if (!$maxSMTPipSessions);
    if ( $ip &&
         ! matchIP($ip,'noMaxSMTPSessions',0,1) &&
         ($doIPcheck =
            ! $relayok &&
            ! matchIP($ip,'noProcessingIPs',0,1) &&
            ! matchIP($ip,'whiteListedIPs',0,1) &&
            ! matchIP($ip,'noDelay',0,1) &&
            ! matchIP($ip,'ispip',0,1) &&
            ! matchIP($ip,'acceptAllMail',0,1) &&
            ! matchIP($ip,'noBlockingIPs',0,1)
         )
       )
    {
        threads->yield;
        if (++$SMTPSessionIP{$ip} > $maxSMTPipSessions) {
            threads->yield;
            $SMTPSessionIP{$ip}--;
            threads->yield;
            d("limiting ip: $client");
            mlog(0,"limiting $ip connections to $maxSMTPipSessions") if $ConnectionLog >= 2 || $SessionLog;

            $Stats{smtpConnLimitIP}++;
            $Con{$client}->{messagereason}="limiting $ip connections to $maxSMTPipSessions";
            pbAdd( $client, $ip, 'iplValencePB', "LimitingIP" ) if ! matchIP($ip,'noPB',0,1);
            d('NewSMTPConnection - LimitingIP');
            $Con{$client}->{type} = 'C';
            $Con{$client}->{error} = '5';
            done($client);
            return;
        } else {
            $SMTPSession{$client}=1;
            threads->yield;
        }
    }

    if (! $ip ) {
        mlog(0,"error: unable to detect the remote connected IP address - localIP:port, $localip:$localport - remoteIP:port, $ip:$port - local-socket,$client");
        $Con{$client}->{type} = 'C';
        $Con{$client}->{error} = '5';
        done($client);
        return;
    }

    # check relayPort usage
    if ($relayused && $allowRelayCon && ! matchIP($ip,'allowRelayCon',0,1)) {
        $Con{$client}->{prepend} = "[RelayAttempt]";
        $Con{$client}->{type} = 'C';
        &NoLoopSyswrite($client,"554 <$myName> Relay Service denied for IP $ip, closing transmission channel\r\n",0);
        $Con{$client}->{error} = '5';
        mlog(0,"rejected relay attemp on allowRelayCon for ip $ip") if $ConnectionLog >= 2 || $SessionLog;
        done($client);
        $Stats{rcptRelayRejected}++;
        return;
    }

    my $bip = &ipNetwork( $ip, $PenaltyUseNetblocks);

    if (   $DelayIP
        && $DelayIPTime
  		&& $doIPcheck
    	&& !$allTestMode
    	&& (my $pbval = [split(/\s+/o,$PBBlack{$bip})]->[3]) > $DelayIP
    	&& ( ! $DelayIPPB{$bip} || ($DelayIPPB{$bip} + $DelayIPTime > time))
        && $ip !~ /$IPprivate/o
        && ! exists $PBWhite{$bip}
        && ! matchIP( $ip, 'noPB', 0, 1 ) )
    {
        $DelayIPPB{$bip} = time unless $DelayIPPB{$bip};
        $Stats{delayConnection}++;
        $Con{$client}->{type} = 'C';
        &NoLoopSyswrite($client,"451 4.7.1 Please try again later\r\n",0);
        $Con{$client}->{error} = '5';
        done($client);
        mlog(0,"delayed ip $ip, because PBBlack($pbval) is higher than DelayIP($DelayIP)- last penalty reason was: " . [split(/\s+/o,$PBBlack{$bip})]->[5] , 1) if $ConnectionLog >= 2 || $SessionLog;
        return;
    } elsif (   $DelayIP
             && $DelayIPTime
       		 && $doIPcheck
    	     && !$allTestMode
             && $DelayIPPB{$bip}
             && $DelayIPPB{$bip} + $DelayIPTime <= time)
    {
        delete $DelayIPPB{$bip};
    }

    if ($MaxAUTHErrors &&
        $doIPcheck &&
        $AUTHErrors{$bip} > $MaxAUTHErrors
       )
    {
        d("NewSMTPConnection - AUTHError ip: $client");
        $Con{$client}->{prepend} = "[AUTHError]";
        mlog(0,"blocked $ip - too much AUTH errors ($AUTHErrors{$bip})") if $ConnectionLog >= 2 || $SessionLog;

        $Stats{AUTHErrors}++;
        $Con{$client}->{type} = 'C';
        &NoLoopSyswrite($client,"554 <$myName> Service denied for IP $ip (harvester), closing transmission channel\r\n",0);
        $Con{$client}->{error} = '5';
        done($client);
        return;
    }
    
    my $intentForIP;
    my $peerhost;
    my $peerport;
    foreach my $destinationA (split(/\s*\|\s*/o, $destination)) {
        if ($destinationA =~ /^(_*INBOUND_*:)?(\d+)$/o){
            $localip = '127.0.0.1' if ($localip eq '0.0.0.0');
            if (exists $crtable{$localip}) {
                $destinationA=$crtable{$localip};
                $intentForIP = "X-Assp-Intended-For-IP: $localip\r\n";
            } else {
                $destinationA = $localip .':'.$2;
            }
        }
        if (! $server) {
            d("try to connect to server at $destinationA");
            mlog(0,"info: try to connect to server at $destinationA") if $ConnectionLog >= 2;
            $server = $CanUseIOSocketINET6
                      ? IO::Socket::INET6->new(Proto=>'tcp',PeerAddr=>$destinationA,Timeout=>2,&getDestSockDom($destinationA))
                      : IO::Socket::INET->new(Proto=>'tcp',PeerAddr=>$destinationA,Timeout=>2);
            threads->yield;
            if(ref($server) && eval{$peerhost = $server->peerhost(); $peerport = $server->peerport();$peerhost && $peerport;} ) {
                $destination=$destinationA;
                d("connected to server $server at $peerhost:$peerport");
                mlog(0,"info: connected to server at $peerhost:$peerport") if $ConnectionLog >= 2;
                last;
            } elsif (ref($server)) {
                mlog(0,"*** $destinationA - no peerhost information available, trying others...") ;
                eval {$server->close;};
                $server = undef;
                $intentForIP = '';
            } else {
                mlog(0,"*** $destinationA didn't work, trying others...") ;
                $server = undef;
                $intentForIP = '';
            }
        }
    }
    if(! (ref($server) && $peerhost && $peerport)) {
        mlog(0,"error: couldn't create server socket to $destination -- aborting connection") ;
        threads->yield;
        if (exists $SMTPSession{$client}) {
            $SMTPSessionIP{Total}++;
            threads->yield;
            $smtpConcurrentSessions++;
            threads->yield;
        }
        $Con{$client}->{type} = 'C';
        &NoLoopSyswrite($client,"421 <$myName> service temporarily unavailable, closing transmission\r\n",0);
        done($client);
        return;
    }
    if (! $ThreadDebug && &matchIP($peerhost,'debugIP',0,0)) {
       $ThreadDebug = 1;
    }
    $fnoS = fileno($server);
    addfh($client,\&getline,$server);
    if($sendNoopInfo) {
        addfh($server,\&skipok,$client);
    } else {
        addfh($server,\&reply,$client);
    }
    if ($ConTimeOutDebug) {
        my $m = &timestring();
        $Con{$client}->{contimeoutdebug}  = "$m $WorkerName\r\n";
        $Con{$client}->{contimeoutdebug} .= "$m client filenumber = $fnoC\r\n";
        $Con{$client}->{contimeoutdebug} .= "$m server filenumber = $fnoS\r\n";
        $Con{$client}->{contimeoutdebug} .= "$m client  = $client\r\n";
        $Con{$client}->{contimeoutdebug} .= "$m client IP  = $ip\r\n";
        $Con{$client}->{contimeoutdebug} .= "$m server  = $server\r\n";
    }
    $Con{$client}->{SessionID} = uc "$client";
    $Con{$client}->{SessionID} =~ s/^.+?\(0[xX]([^\)]+)\).*$/$1/o;
    $Con{$client}->{prescore} = 0;
    $Con{$client}->{debug}    = $ThreadDebug;
    $Con{$client}->{client}   = $client;
    $Con{$client}->{self}     = $client;
    $Con{$client}->{server}   = $server;
    $Con{$client}->{ip}       = $ip;
    $Con{$client}->{port}     = $port;
    $Con{$client}->{localip}  = $localip;
    $Con{$client}->{localport}= $localport;
    $Con{$client}->{relayok}  = $relayok;
    $Con{$client}->{myheaderCon} .= $intentForIP if $intentForIP;
    $Con{$client}->{myheaderCon} .= "X-Assp-Client-SSL: yes\r\n" if $isSSL;
    $Con{$client}->{chainMailInSession} = -1;
    $Con{$client}->{type}     = 'C';
    $Con{$client}->{fno}      = $fnoC;
    $Con{$server}->{type}     = 'S';
    $Con{$server}->{fno}      = $fnoS;
    $Con{$server}->{self}     = $server;
    $Con{$server}->{debug}    = $ThreadDebug;

    #  mlog(0,"connection fno : client = $fnoC , server = $fnoS");
    d("Connected: SID=$Con{$client}->{SessionID} $client -- $server");
    if( $Con{$client}->{relayok} || isOk2Relay($client,$ip) ) {
        $Con{$client}->{relayok} = 1;
        d("$client relaying ok: $ip");
    }
    my $time=$UseLocalTime ? localtime() : gmtime();
    my $tz=$UseLocalTime ? tzStr() : '+0000';
    $time=~s/... (...) +(\d+) (........) (....)/$2 $1 $4 $3/o;
    $Con{$client}->{rcvd}="Received: from =host ([$ip] helo=) by $myName with *SMTP* ($version); $time $tz\r\n";
    d("* connect SID=$Con{$client}->{SessionID} ip=$Con{$client}->{ip} relay=<$Con{$client}->{relayok}> *");
    my $text = $destination;
    $text = $server->sockhost() . ':' . $server->sockport() . " > $text , $fnoC-$fnoS" if $ConnectionLog >= 2;
    mlog(0,"Connected: session:$Con{$client}->{SessionID} $ip:$port > $localip:$localport > $text") if ($ConnectionLog && ! matchIP($ip,'noLog',0,1));
    $Con{$server}->{noop}="NOOP Connection from: $ip, $time $tz relayed by $myName\r\n" if $sendNoopInfo;

    # overall session limiting
    $maxSMTPSessions=999 if (!$maxSMTPSessions);
    my $numsess;
    threads->yield;
    $numsess = ++$SMTPSessionIP{Total};
    threads->yield;
    $smtpConcurrentSessions++;
    threads->yield;
    $SMTPSession{$client}=$client;
    if ($numsess>=$maxSMTPSessions) {
        d("$WorkerName limiting sessions: $client");
        if ($SessionLog) {
            mlog(0,"connected: $ip:$port") if !$ConnectionLog || matchIP($ip,'noLog',0,1); # log if not logged earlier
            mlog(0,"limiting total connections");
        }
        $Stats{smtpConnLimit}++;
    } else {      # increment Stats if connection not limited
        if (matchIP($ip,'noLog',0,1)) {
            $Stats{smtpConnNotLogged}++;
        } else {
            $Stats{smtpConn}++;
        }
    }
    if ($smtpConcurrentSessions>$Stats{smtpMaxConcurrentSessions}) {
        $Stats{smtpMaxConcurrentSessions}=$smtpConcurrentSessions;
    }
    newCrashFile($client);
}

sub SMTPTraffic {
    my $fh=shift;
    $SMTPbuf = '';
    my $ip = $Con{$fh}->{ip};
    my $pending = 0;
    eval{$pending = $fh->pending();} if ("$fh" =~ /SSL/io);
    $SMTPmaxbuf = max( $SMTPmaxbuf, 16384 , ($MaxBytes + 4096), $pending);
    $Con{$fh}->{prepend} = '';
    $Con{$fh}->{socketcalls}++;
    $fh->blocking(0) if $fh->blocking;
    &sigoffTry(__LINE__);
    my $hasread = $fh->sysread($SMTPbuf, $SMTPmaxbuf);
    &sigonTry(__LINE__);
    if ($hasread == 0 && "$fh" =~ /SSL/io && IO::Socket::SSL::errstr() =~ /SSL wants a/io) {
        ThreadYield();
        $Con{$fh}->{sslwantrw} ||= time;
        if (time - $Con{$fh}->{sslwantrw} > $SSLtimeout) {
            my $lastcmd = "- last command was \'$Con{$fh}->{lastcmd}\'";
            $lastcmd = '' unless $Con{$fh}->{lastcmd};
            mlog($fh,"info: can't read from SSL-Socket for $SSLtimeout seconds - close connection - $! $lastcmd") if ($ConnectionLog);
            delete $Con{$fh}->{sslwantrw};
            setSSLfailed($ip);
            done2($fh);
        }
        return;
    }
    delete $Con{$fh}->{sslwantrw};
    if($hasread > 0 or length($SMTPbuf) > 0) {
        my $crashfh = $Con{$fh}->{crashfh};
        if ($crashfh) {
            print $crashfh "+-+***+!+time:  ".timestring() .' / '. Time::HiRes::time()."+-+***+!+";
            print $crashfh $SMTPbuf;
        }
        if (! $ThreadDebug &&
            ( ($debugRe && $SMTPbuf =~ /($debugReRE)/) ||
              ($debugCode && eval($debugCode) && !$@)
            )
           )
        {
            if ($1||$2) {
                mlog($fh,"info: partial debug switched on - found ".($1||$2));
            } else {
                mlog($fh,"info: partial debug switched on - debugCode has returned 1");
            }
            $Con{$fh}->{debug} = 1;
            $Con{$Con{$fh}->{friend}}->{debug} = 1 if ($Con{$fh}->{friend} && exists $Con{$Con{$fh}->{friend}});
            $ThreadDebug = 1;
        }
        if ($@) {
            mlog($fh,"warning: possible syntax error in 'debugCode' - $debugCode - $@");
            mlog($fh,"warning: commending out debugCode because of syntax error");
            $debugCode = '0; # syntaxerror in : ' . $debugCode;
            $Config{debugCode} = $debugCode;
            $ConfigChanged = 1;
        }
        d('SMTPTraffic - read OK');
        $SMTPbuf=$Con{$fh}->{_}.$SMTPbuf;
        if ($Con{$fh}->{type} eq 'C'){
            $Con{$fh}->{timelast} = time;
            $Con{$fh}->{contimeoutdebug} .= "read from client = $SMTPbuf" if $ConTimeOutDebug;
        } else {
            $Con{$Con{$fh}->{friend}}->{contimeoutdebug} .= "read from server = $SMTPbuf" if $ConTimeOutDebug;
        }
        if((my $sb=$Con{$fh}->{skipbytes})>0) {

           # support for XEXCH50 thankyou Microsoft for making my life miserable
            my $l=length($SMTPbuf);
            d("skipbytes=$sb l=$l -> ");
            if($l >= $sb) {
                sendque($Con{$fh}->{friend},substr($SMTPbuf,0,$sb)); # send the binary chunk on to the server
                $SMTPbuf=substr($SMTPbuf,$sb);
                delete $Con{$fh}->{skipbytes};
            } else {
                sendque($Con{$fh}->{friend},$SMTPbuf); # send the binary chunk on to the server
                $Con{$fh}->{skipbytes}=$sb-=length($SMTPbuf);
                $SMTPbuf='';
            }
            d("skipbytes=$Con{$fh}->{skipbytes}");
        }
        d('SMTPTraffic - process read');
        my $bn= my $lbn=-1;
        if ($Con{$fh}->{type} ne 'C' or               # process line per line
            $Con{$fh}->{getline} ne \&whitebody or
            $SMTPbuf =~ /^\.(?:\x0D?\x0A)?$/o  or
            $SMTPbuf =~ /\x0D?\x0A\.\x0D?\x0A$/o)
        {
            while (($bn=index($SMTPbuf,"\n",$bn+1)) >= 0) {
                my $s=substr($SMTPbuf,$lbn+1,$bn-$lbn);
                if(defined($Con{$fh}->{bdata})) { $Con{$fh}->{bdata}-=length($s); }
                d("doing line <$s>");

                if ($Con{$fh}->{type} eq 'C') {
                    $Con{$fh}->{headerpassed} ||= $s =~ /^\x0D?\x0A/o; #header passed? if header and body in one junk
                }

                if ($Con{$fh}->{type} eq 'C' &&
                    ! $Con{$fh}->{headerpassed} &&
                    ! $Con{$fh}->{relayok})
                {
                    if ($preHeaderRe && $s =~ /($preHeaderReRE)/i) {
                        $Con{$fh}->{prepend} = '[preHeaderRE][block]';
                        mlog($fh,"early (pre)header line check found ".($1||$2));
                        NoLoopSyswrite($Con{$fh}->{friend}, "421 $myName Service not available, closing transmission channel\r\n",0) if $Con{$fh}->{friend};
                        done($fh);
                        $Stats{preHeader}++;
                        return;
                    }
                    if ($s =~ /^(X-ASSP-[^(]+?)(\(\d+\))?(:$HeaderValueRe)$/io) {  # change strange X-ASSP headers
                        my ($pre,$c,$post) = ($1,$2,$3);
                        $c =~ s/[^\d]//go;
                        $c = 0 unless $c;
                        $s = $pre . '(' . ++$c . ')' . $post;
                        $Con{$fh}->{nodkim} = 1;     # we have modified the header and should skip the DKIM check for this reason
                    }
                }
                Maillog($fh,$s) if $Con{$fh}->{maillog};
                if (! $Con{$fh}->{getline}) {
                   my $lastcmd = "\'$Con{$fh}->{lastcmd}\'";
                   $lastcmd = "\'n/a\'" unless $Con{$fh}->{lastcmd};
                   mlog($fh,'error: missing $Con{$fh}->{getline} in sub SMTPTraffic (1) - last command was '.$lastcmd);
                   done($fh);
                   return;
                }
                $Con{$fh}->{getline}->($fh,$s);
                last if((exists $ConDelete{$fh} && $ConDelete{$fh}) || ! exists $Con{$fh} || $Con{$fh}->{closeafterwrite});  # it's possible that the connection can be deleted while there's still something in the buffer
                if(($Con{$fh}->{inerror} || $Con{$fh}->{intemperror}) && $Con{$fh}->{cleanSMTPBuff}) { # 4/5xx from MTA after DATA
                    $Con{$fh}->{_} = $Con{$fh}->{header} = ''; # clean the SMTP buffer
                    delete $Con{$fh}->{cleanSMTPBuff};
                    mlog($fh,"info: SMTP buffer was cleaned after MTA has sent an error reply in DATA part") if $ConnectionLog;
                    last;
                }
                $lbn=$bn;
            }
        } else {         # process the complete buf in one junk
            $Con{$fh}->{_} = '';
            $Con{$fh}->{headerpassed} = 1;
            if(defined($Con{$fh}->{bdata})) { $Con{$fh}->{bdata}-=length($SMTPbuf); }
            if (! $Con{$fh}->{getline}) {
               my $lastcmd = "\'$Con{$fh}->{lastcmd}\'";
               $lastcmd = "\'n/a\'" unless $Con{$fh}->{lastcmd};
               mlog($fh,'error: missing $Con{$fh}->{getline} in sub SMTPTraffic (2) - last command was '.$lastcmd);
               done($fh);
               return;
            }
            d("doing full <$SMTPbuf>");
            Maillog($fh,$SMTPbuf) if $Con{$fh}->{maillog};
            $Con{$fh}->{getline}->($fh,$SMTPbuf);
            &NewSMTPConCall();
            return;
        }
        if(exists $Con{$fh} && ! exists $ConDelete{$fh} && ! $Con{$fh}->{closeafterwrite}) { # finish the mail as fast as possible
            ($Con{$fh}->{_})=substr($SMTPbuf,$lbn+1);
            if(length($Con{$fh}->{_}) > $MaxBytes) {
                d('SMTPTraffic - process rest');
                $Con{$fh}->{headerpassed} = 1;
                if(defined($Con{$fh}->{bdata})) { $Con{$fh}->{bdata}-=length($Con{$fh}->{_}); }
                Maillog($fh,$Con{$fh}->{_}) if $Con{$fh}->{maillog};
                if (! $Con{$fh}->{getline}) {
                   my $lastcmd = "\'$Con{$fh}->{lastcmd}\'";
                   $lastcmd = "\'n/a\'" unless $Con{$fh}->{lastcmd};
                   mlog($fh,'error: missing $Con{$fh}->{getline} in sub SMTPTraffic (3) - last command was '.$lastcmd);
                   done($fh);
                   return;
                }
                $Con{$fh}->{getline}->($fh,$Con{$fh}->{_});
                $Con{$fh}->{_} = '';
            }
        }
    } elsif ($hasread == 0) {
        my $error = $!;
        if ($error =~ /Resource temporarily unavailable/io) {
            d("SMTPTraffic - no more data - $error");
            return ;
        }
        if ($pending) {
            d("SMTPTraffic - got no more (SSL) data but $pending Byte are pending - $error");
            $pending = " (SSL pending = $pending)";
        } else {
            d("SMTPTraffic - no more data - $error");
            $pending = '';
        }
        eval {$ip = $fh->peerhost() . ':' . $fh->peerport();} unless $ip;
        my $lastcmd = "- last command was \'$Con{$fh}->{lastcmd}\'";
        $lastcmd = '' unless $Con{$fh}->{lastcmd};
        mlog($fh,"info: no (more) data$pending readable from $ip (connection closed by peer) - $! $lastcmd") if ($error && ($ConnectionLog or $pending));
        mlog($fh,"info: no (more) data$pending readable from $ip (connection closed by peer) $lastcmd") if (($ConnectionLog >= 2 or $pending) && ! $error);
        done2($fh);
    } else {
        my $error = $!;
        if ($pending) {
            d("SMTPTraffic - got no more (SSL) data but $pending Byte are pending - $error");
            $pending = " (SSL pending = $pending)";
        } else {
            d("SMTPTraffic - no more data - $error");
            $pending = '';
        }
        eval {$ip = $fh->peerhost() . ':' . $fh->peerport();} unless $ip;
        my $lastcmd = "- last command was \'$Con{$fh}->{lastcmd}\'";
        $lastcmd = '' unless $Con{$fh}->{lastcmd};
        mlog($fh,"error: reading from socket $ip$pending - $error $lastcmd") if ($error);
        done2($fh);
    }
    &NewSMTPConCall();
}

sub SMTPTimeOut {
    my $sfh = shift;
    if ($smtpIdleTimeout > 0 || $smtpNOOPIdleTimeout > 0){
        if (scalar keys %Con > 0){
            my $tmpNow = time;
            # Check timeouts only every 15 seconds at least
            if ($tmpNow > ($lastTimeoutCheck + 15)){
                while (my ($tmpfh,$v) = each %Con){
                    next if("$tmpfh" eq "$sfh");
                    delete $Con{$tmpfh}->{doNotTimeout} if ($tmpNow - $Con{$tmpfh}->{doNotTimeout} > $NpWlTimeOut);
                    if ($Con{$tmpfh}->{type} =~ /CC?/o &&
                        $Con{$tmpfh}->{timelast} > 0 &&
                        ! $Con{$tmpfh}->{movedtossl} &&
                        ! $Con{$tmpfh}->{doNotTimeout} &&
                        ! (($Con{$tmpfh}->{noprocessing} || $Con{$tmpfh}->{whitelisted}) && $tmpNow - $Con{$tmpfh}->{timelast} < $NpWlTimeOut) &&   # 20 minutes for realy large queued mails
                        (($smtpIdleTimeout && $tmpNow - $Con{$tmpfh}->{timelast} > $smtpIdleTimeout) ||
                          (uc($Con{$tmpfh}->{lastcmd}) =~ /NOOP/o &&
                          $smtpNOOPIdleTimeout &&
                          $tmpNow - $Con{$tmpfh}->{timelast} > $smtpNOOPIdleTimeout) ||
                          ($smtpNOOPIdleTimeout &&
                          $smtpNOOPIdleTimeoutCount &&
                          $Con{$tmpfh}->{NOOPcount} >= $smtpNOOPIdleTimeoutCount))
                        )
                    {
                        if ($ConTimeOutDebug) {
                           my $m = &timestring();
                           $Con{$tmpfh}->{contimeoutdebug} .= "$m client Timeout after $smtpIdleTimeout secs\r\n" if $ConTimeOutDebug;
                           my $check = "$m client was not readable\r\n";
                           my @handles = $readable->handles();
                           while (@handles) {
                              $_ = shift @handles;
                              $check = "$m client was readable\r\n" if ($tmpfh eq $_);
                           }
                           $Con{$tmpfh}->{contimeoutdebug} .= $check;
                           $check = "$m client was not writable\r\n";
                           @handles = $writable->handles();
                           while (@handles) {
                              $_ = shift @handles;
                              $check = "$m client was writable\r\n" if ($tmpfh eq $_);
                           }
                           $Con{$tmpfh}->{contimeoutdebug} .= $check;
                           $m=time;
                           my $f = "$base/debug/$m.txt";
                           my $CTOD;
                           open $CTOD,'>',"$f" or mlog(0,"error: unable to open connection timeout debug log [$f] : $!");
                           binmode $CTOD;
                           print $CTOD  $Con{$tmpfh}->{contimeoutdebug};
                           close $CTOD;
                        }
                        $Con{$tmpfh}->{prepend}='';
                        $Con{$tmpfh}->{timestart} = 0;
                        my $type;
                        my $addPB = 0;
                        if ($Con{$tmpfh}->{oldfh} && $Con{$tmpfh}->{ip}) {
                            setSSLfailed($Con{$tmpfh}->{ip});
                            $type = 'TLS-';
                            $Stats{smtpConnTLSIdleTimeout}++;
                        } elsif ("$tmpfh" =~/SSL/io && $Con{$tmpfh}->{ip}) {
                            $type = 'SSL-';
                            $Stats{smtpConnSSLIdleTimeout}++;
                        } else {
                            $addPB = 1;
                            $Stats{smtpConnIdleTimeout}++;
                        }
                        if ($Con{$tmpfh}->{damping}) {
                            $Con{$tmpfh}->{messagescore} = 0;
                            delete $ConDelete{$tmpfh};
                            $addPB = 0;
                        }
                        if ( ! $Con{$tmpfh}->{timedout} ) {
                            pbAdd( $tmpfh,$Con{$tmpfh}->{ip}, 'idleValencePB', "TimeOut",2 ) if $addPB;
                            mlog($tmpfh,$type."Connection idle for $smtpIdleTimeout secs - timeout",1) if $SessionLog;
                        } else {
                            done($Con{$tmpfh}->{client});
                            next;
                        }
                        $Con{$tmpfh}->{timedout} = 1;
                        if ($Con{$tmpfh}->{getline} != \&error) {
                            seterror($Con{$tmpfh}->{client},"451 Connection timeout, try later\r\n",1);
                        } else {
                            if (! $Con{$tmpfh}->{closeafterwrite}) {
                                sendque($Con{$tmpfh}->{client},"451 Connection timeout, try later\r\n");
                                $Con{$tmpfh}->{closeafterwrite} = 1;
                                unpoll($Con{$tmpfh}->{client}, $readable);
                            } else {
                                done($Con{$tmpfh}->{client});
                            }
                        }
                    }
                }
                $lastTimeoutCheck = $tmpNow;
            }
        }
    }
}

sub loadexportedRE {
    my $name = shift;
    return 0 if $WorkerNumber == 0;
    $name =~ s/[\^\s\<\>\?\"\'\:\|\\\/\*\&\.]/_/igo;  # remove not allowed characters from file name
    $name =~ s/\_+/_/go;
    return 0 if (! $name);
    return 0 unless exists $availOptRE{$name};
    (open my $optRE, '<',"$base/files/optRE/$name.txt") or return 0;
    binmode $optRE;
    my $re = join('',<$optRE>);
    close $optRE;
    if (exists $CryptFile{"$base/files/optRE/$name.txt"} && $re =~ /^(?:[a-zA-Z0-9]{2})+$/o) {
        $re = ASSP::CRYPT->new($webAdminPassword,0)->DECRYPT($re);
    }
    return $re;
}

sub exportOptRE {
    my ($ree, $name ) = @_;
    return unless $WorkerNumber == 0;
    my $re = $$ree;
    $name =~ s/[\^\s\<\>\?\"\'\:\|\\\/\*\&\.]/_/igo;  # remove not allowed characters from file name
    $name =~ s/\_+/_/go;
    return if (! $re || ! $name);
    -d "$base/files/optRE" or mkdir "$base/files/optRE", 0755;
    my $optRE;
    if (open $optRE, '>',"$base/files/optRE/$name.txt") {
        binmode $optRE;
        if (exists $cryptConfigVars{$name}) {
            print $optRE ASSP::CRYPT->new($webAdminPassword,0)->ENCRYPT($re);
            $CryptFile{"$base/files/optRE/$name.txt"} = 1;
        } else {
            print $optRE $re;
        }
        $availOptRE{$name} = 1 if close $optRE;
    } else {
        mlog(0,"error: unable to open $base/files/optRE/$name.txt for writing - $!");
        delete $availOptRE{$name};
    }
    return;
}

sub SetRE {
 use re 'eval';
 my ($var,$r,$f,$desc,$name,$noerror)=@_;
 return if (! $var);
 $name ||= $desc;

 my $noOptimize = 0;
 my $optimSX = ($f =~ s/-optimsx$//o) ? 1 : 0;
 if (exists $noOptRe{$var}) {
     if ($noOptRe{$var} == 0) {
         $noOptimize = 1;
     } elsif ($noOptRe{$var} == 1) {
         $optimSX = 0;
     } else {
         $optimSX = 1;
     }
 }
 my $how = ($optReModule eq 'Regex::Optimizer') ? ($optimSX ? 'strong ' : 'enhanced ') : '';
 $how = 'default ' if ($optReModule eq 'Regexp::Optimizer');
 $desc =~ s/[ *]*$//o;
 $desc =~ s/\<[a-zA-Z0-9]+ .*?\<\/[a-zA-Z0-9]+\>//gio;
 mlog(0,"ERROR: regex variable $var not defined for - '$name <$desc>' - please report")
     if(! defined($$var) && $WorkerNumber == 0);

 if (($CanUseRegexOptimizer || $CanUseRegexpOptimizer) &&
     ! $noOptimize &&
     $r !~ /$neverMatchRE/o &&      # the regex that never matches
     $r =~ /[^\\]\|/so &&                     # no | in regex
     $r !~ s/a(?:ssp)?\\?-do?\\?-n(?:ot)?\\?-o(?:ptimize)?\\?-r(?:egex)?\|?//iso &&  # the special word
     $r !~ /\Q$complexREStart\E/o )           # the complex AND NOT
 {
     my $lenBefore = length($r) + length($f) + 4 + 9;      # (?-xims:(?$f:......))
     if ($WorkerName eq 'startup' && $MaintenanceLog >= 2) {
        print $how . "optimizing regex for $name";
        print ' ' x (35 - length($name) - length($how));
     }
     eval{
         my $loadRE;
         if (($WorkerNumber != 0) && ($loadRE = &loadexportedRE($name))) {
             $loadRE =~ s/\)$//o if $loadRE =~ s/^\(\?(?:[xims\-\^]*)?\://o;
             $$var = qr/$loadRE/;
         } else {
             my $o = $optReModule->new;
             $o->set(optim_sx => $optimSX);
#             $o->set(debug => $debug);
             my @noOpt;
             if ($optReModule eq 'Regexp::Optimizer' && $r =~ /\<\<\<(.*?)\>\>\>/o) { # Regexp::Optimizer is unable to skip optim - so we have to do this
                 while ($r =~ s/\<\<\<(.*?)\>\>\>\|?//o) {
                     push @noOpt, $1;
                 }
                 my ($pre,$post) = $r =~ m{^(\^?).*(\$?)$}o;
                 $r =~ s/^\^?\$?$//;
                 my $noOpt;
                 $$var = '';
                 if (@noOpt) {
                     $noOpt = $pre . join('|',@noOpt) . $post;
                     $$var = qr/(?$f:$noOpt)/;
                     $$var .= '|' if $r;
                 }
                 $$var .= $o->optimize(qr/(?$f:$r)/) if $r;
                 $$var = qr/$$var/ if @noOpt && $r;
             } else {
                 $$var = $o->optimize(qr/(?$f:$r)/);
             }
         }
     };
     if ($@) {
         $RegexError{$name} = 'regex optimization failed - unoptimized regex is used' if $WorkerNumber == 0;
         mlog(0,"warning: ".$how."regex optimization failed for '$name - <$desc>' - $@ - try using unoptimized regex") if $WorkerNumber == 0;
         if ($WorkerName eq 'startup' && $MaintenanceLog >= 2) {
             print "[FAILED]\n";
         }
         eval{
             $r =~ s/a(?:ssp)?\\?-do?\\?-n(?:ot)?\\?-o(?:ptimize)?\\?-r(?:egex)?\|?//igos;   # the special word
             $r =~ s/\<\<\<(.*?)\>\>\>/$1/go;   # a single line that should not be optimized
             $$var=qr/(?$f:$r)/;
         };
     } else {
         my $lenAfter = length $$var;
         mlog(0,"info: ".$how."optimized regex for '$name <$desc>' - length in byte before: $lenBefore - after: $lenAfter") if $MaintenanceLog >= 2 && $WorkerNumber == 0;
         if ($WorkerNumber == 0 && $MaintenanceLog >= 2) {
             print "[OK]\n" if $WorkerName eq 'startup';
         }
     }
 } else {
     eval{
         $r =~ s/a(?:ssp)?\\?-do?\\?-n(?:ot)?\\?-o(?:ptimize)?\\?-r(?:egex)?\|?//igso;  # a-d-n-o-r
         $r =~ s/\<\<\<(.*?)\>\>\>/$1/go;      # a single line that should not be optimized

         # '?|' = alternativ gouping capture starting every time by $1
         # only available in 5.10 or above  and needed for complexRE
         # but buggy in 5.10 ([RT #59734]) - fixed in 5.12
         # so it is only used if complexRE is defined
         $$var = ($r !~ /\Q$complexREStart\E/o) ? qr/(?$f:$r)/ : qr/(?$f:(?|$r))/;
     };
 }
 if ($@) {
     $RegexError{$name} = 'error in regular expression' if $WorkerNumber == 0;
     mlog(0,"regular expression error in '$r' for '$name <$desc>': $@") unless $noerror;
     $r = $neverMatch; # regexp that never matches
     $$var=qr/(?$f:$r)/;
     return 0;
 } else {
     delete $RegexError{$name} if $WorkerNumber == 0;
     exportOptRE($var,$name) if ($WorkerNumber == 0);
 }
 return 1;
}

sub isOk2Relay {
  my ($fh,$ip)=@_;
  return 1 if ($Con{$fh}->{acceptall} = matchIP($ip,'acceptAllMail',$fh,0));
  return 1 if $PopB4SMTPFile && PopB4SMTP($ip);
# failed all tests -- return 0
  return 0;
}

sub POP3Collect {
    return 0 unless $allowPOP3;
    return 0 unless $POP3Interval;
    return 0 unless -e "$base/assp_pop3.pl";

    return 0 if $POP3ConfigFile !~ /^ *file: *.+/io;
    d('POP3 - collect');

    my $perl = $perl;
    my $cmd = "\"$perl\" \"$base/assp_pop3.pl\" \"$base\" 2>&1";
    $cmd =~ s/\//\\/go if $^O eq "MSWin32";
    my $out = qx($cmd);

    foreach (split(/\n/o,$out)) {
        s/\r|\n//go;
        mlog(0,$_) if $MaintenanceLog;
    }
    return 1;
}

sub PopB4SMTP {
    my $ip=shift;
    if($PopB4SMTPMerak) {
        return 1 if PopB4Merak($ip);
        return 0;
    }
    return 0 unless $PopB4SMTPFile;

    my %hash;

    eval {
    # tie %hash, 'DB_File', $PopB4SMTPFile, O_READ, 0400, $DB_HASH;
    tie %hash, 'DB_File', $PopB4SMTPFile;
    if($hash{$ip}) {
        mlog(0,"PopB4SMTP OK for $ip");
        return 1;
    } else {
        mlog(0,"PopB4SMTP failed for $ip");
        return 0;
    }
    };
}

sub PopB4Merak {
  return 0 unless $PopB4SMTPFile;
  my $ip=shift;
#This is a test version of ASSP PopB4SMTP
#This is to be used with Merak 7.5.2
#It also works with Merak 6.5 (which I run)
#Thanks to Jordon for the heads up on 7.5.2
#Basically, Merak's popsmtp file
#is made up of 64 Byte lines, no CR / LF.
#This holds the IP addy
#and the byte before it specifying the length.

  my $PB4S;
  my $ind;
  my $newIP;

#Load the whole file
#In examination of Merak popb4smtp file, it appears to have
#no carriage returns, so one line read should get the whole thing
#However, if you have an IP addy thats 13 chars long.... thus:

  $open->(my $MKPOPSMTP,'<',$PopB4SMTPFile) or return 0 ;
  $MKPOPSMTP->read($PB4S,[$stat->($PopB4SMTPFile)]->[7]);
  $MKPOPSMTP->close;
#We now have all the contents of the file AND we've released it

#Now, instead of heavy parsing....
#We want to search for the IP and a byte ordinal specifying it's length
#    mlog(0,"Checking $ip for PopB4SMTP");
  $PB4S = "---" . $PB4S;
#    mlog(0,"Searching: $PB4S");
  $newIP = chr(length($ip)) . $ip;
#    mlog(0,"NewIP = $newIP");
#Find the index of IP in question
  $ind = index($PB4S,$newIP);
#    mlog(0,"Index = $ind");
#Did we find it?
  if ($ind  > 0) {
    mlog(0,"PopB4SMTP OK for $ip");
    return 1;
  }
  mlog(0,"PopB4SMTP NOT OK for $ip");
  return 0;
}

sub NoLoopSyswrite {
    my ($fh,$out,$timeout) = @_;
    d('NoLoopSyswrite');
    return 0 unless fileno($fh);
    return 0 unless $out;
    $timeout ||= 30;
    my $written = 0;
    my $ip;
    my $port;
    my $error;
    eval{
      $ip=$fh->peerhost();
      $port=$fh->peerport();
    };
    if($@) {$! = $@; return 0;};
    d("NoLoopSyswrite - write($timeout $fh): '" . substr($out,0,30) . '\' - ' . length($out));
    &sigoffTry(__LINE__);
    
    if (   exists $Con{$fh}
        && $Con{$fh}->{type} eq 'C'       # is a client SMTP connection?
        && ($replyLogging == 2 or ($replyLogging == 1 && $out =~ /^[45]/o))
        && $out =~ /^(?:[1-5]\d\d\s+[^\r\n]+\r\n)+$/o)    # is a reply?
    {
        $out =~ s/SESSIONID/$Con{$fh}->{msgtime} $Con{$fh}->{SessionID}/go;
        $out =~ s/MYNAME/$myName/go;
        my @reply = split(/(?:\r?\n)+/o,$out);
        for (@reply) {
            next unless $_;
            my $what = 'Reply';
            if ($_ =~ /^([45])/o) {
                $what = ($1 == 5) ? 'Error' : 'Status';
            }
            mlog( $fh, "[SMTP $what] $_", 1, 1 );
        }
    }

    my $stime = Time::HiRes::time() + $timeout;
    my $wtime = Time::HiRes::time() + 1;
    my $NLwritable;
    if ($IOEngineRun == 0) {
        $NLwritable = IO::Poll->new();
    } else {
        $NLwritable = IO::Select->new();
    }
    &dopoll($fh,$NLwritable,POLLOUT);
    my $l = length($out);
    my $allwritten = 0;
    while (length($out) > 0 && fileno($fh) && Time::HiRes::time() < $stime) {
        my @canwrite;
        my $st = Time::HiRes::time();
        if ($IOEngineRun == 0) {
            $NLwritable->poll(1);
            @canwrite = $NLwritable->handles(POLLOUT);
        } else {
            @canwrite = $NLwritable->can_write(1);
        }
        my $polltime = Time::HiRes::time() - $st;
        $ThreadIdleTime{$WorkerNumber} += $polltime;
        mlog(0,"warning: the operating system socket poll cycle has taken $polltime seconds in NoLoopSyswrite - this is very much is too long")
            if ($ConnectionLog >= 2 and $polltime > 3);
        $written = 0;
        $error = 0;
        eval{$written = $fh->syswrite($out,length($out));
             $error = $!;
             $error = '' if ("$fh" =~ /SSL/io && ($IO::Socket::SSL::SSL_ERROR == eval('SSL_WANT_READ') ? 1 : $IO::Socket::SSL::SSL_ERROR == eval('SSL_WANT_WRITE') ) );
        } if @canwrite or "$fh" =~ /SSL/io;
        $allwritten += $written;
        if (@canwrite && ! $written && ($@ or $error)) {
            mlog(0,"warning: unable to write to socket $ip:$port $error") if $ConnectionLog == 3 && $error;
            mlog(0,"warning: unable to write to socket $ip:$port $@") if $ConnectionLog == 3 && $@;
            $! = $error;
            unpoll($fh,$NLwritable);
            &sigonTry(__LINE__);
            return 0;
        }
        if ($written) {
            $out = substr($out,$written);
            $Con{$fh}->{lastwritten} = time if exists $Con{$fh};
        }
        if ($WorkerNumber == 0 && $timeout > 1 && $wtime < Time::HiRes::time()) {
            &mlogWrite;
            $wtime = Time::HiRes::time() + 1;
        }
        if ($WorkerNumber == 10000 && ! $isRunTMM2 && length($out) && time % 2) {
            my $tt = Time::HiRes::time();
            ThreadMaintMain2();
            $stime += Time::HiRes::time() - $tt;
        }
    }
    d("NoLoopSyswrite - wrote: $allwritten to $fh");
    unpoll($fh,$NLwritable);
    if (time >= $stime) {
        mlog(0,"warning: timeout (30s) writing to socket $ip:$port") if $ConnectionLog == 3;
    }
    &sigonTry(__LINE__);
    return 1;
}

sub SNMPStats {
    my ($subOID_cs,$subOID_cts,$subOID_ct,$subOID_ctt,$subOID_css,$subOID_ctss) = @_;
    my %subh = (
                'currentstat'     => $subOID_cs,
                'cumulativestat'  => $subOID_cts,
                'currenttotal'    => $subOID_ct,
                'cumulativetotal' => $subOID_ctt,
                'currentscorestat'     => $subOID_css,
                'cumulativescorestat'  => $subOID_ctss
    );
    my $str = &ConfigStatsXml();
    my %st;
    while ($str =~ /<stat +name='(.+?)' type='(.+?)'>(.*?)<\/stat>/gso) {
        $st{$1}{$subh{$2}}=$3 if $subh{$2};
    }
    delete $st{memusage};
    my $i = 0;
    my $highOID;

    my $l;
    foreach my $k (keys %st) {
        $l = length($k) if $l < length($k);
    }

    foreach my $name (sort {(' ' x ($l - length($main::a)).$main::a) cmp (' ' x ($l - length($main::b)).$main::b)} keys %st) {
        foreach my $soid (sort {lc($main::a) cmp lc{$main::b}} keys %{$st{$name}}) {
            my $value = ${$st{$name}}{$soid};
            $value = 0 unless $value;
            $subOID{"$soid.$i.0"} = $value;
            my $li='.0';
            my $n = $name;
            $n = "mailCount" if $name eq 'Counter';
            if ($CreateMIB) {
                $subOID{"$soid.$i.1"} = $n;
                $li = '.1';
                if ($subOID_cs && exists $StatText{$name}) {
                    $subOID{"$soid.$i.2"} = $StatText{$name};
                    $li = '.2';
                }
                if ($subOID_css && exists $ScoreStatText{$name}) {
                    $subOID{"$soid.$i.2"} = $ScoreStatText{$name};
                    $li = '.2';
                }
            }
            $highOID = "$soid.$i$li" if NetSNMP::OID->new($SNMPBaseOID.$highOID) < NetSNMP::OID->new("$SNMPBaseOID$soid.$i$li");
        }
        $i++;
    }
    mlog(0,"info: SNMP read Stats") if $SNMPLog == 3;
    return $highOID;
}

sub SNMPcleanHTML {
     my $str = shift;
     $str =~ s/<table.+?<\/table>//go;
     $str =~ s/<div.*?<\/div>//go;
     $str =~ s/<\/?(?:hr|br)[^>]*>//go;
     $str =~ s/<a +href.*?<\/a>//go;
     $str =~ s/<\/?span[^>]*>//go;
     $str =~ s/<input[^>]+>//go;
     $str =~ s/<\/?img[^>]+>//go;
     $str =~ s/<\/?(?:i|b|small|p)>//go;
     $str =~ s/<\/?font[^>]*>//o;
     return $str;
}

sub SNMPVarType {
    my ($var,$sid,$asText) = @_;
    my $boolean = ($sid=~/^\.?1/o) ? $SNMPreturnBOOL : 'ASN_COUNTER';
#    my $ipaddr = ($sid=~/^\.?2/o) ? 'ASN_OCTET_STR' : 'ASN_IPADDRESS';
#    $$var =~ /^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/o and return $asText ? $ipaddr : $SNMPAS{$ipaddr};
    $$var =~ /^(?:0|1)$/o and return $asText ? $boolean : $SNMPAS{$boolean};
    $$var =~ /[^\d.]/o and return $asText ? 'ASN_OCTET_STR' : $SNMPAS{ASN_OCTET_STR};
    $$var =~ /\.[^.]*\./o and return $asText ? 'ASN_OCTET_STR' : $SNMPAS{ASN_OCTET_STR};
#    $$var =~ /\./o and return $asText ? 'ASN_FLOAT' : $SNMPAS{ASN_FLOAT};
    $$var =~ /^\d+$/o and return $asText ? 'ASN_COUNTER' : $SNMPAS{ASN_COUNTER};
    return $asText ? 'ASN_OCTET_STR' : $SNMPAS{ASN_OCTET_STR};
}

sub SNMPgetUsers {
    my $users = 'root:root';
    foreach my $k (sort keys %AdminUsers) {
        next if $k =~ /^[~#]/o;
        $users .= "|$k:$k";
    }
    return $users;
}

sub SNMPderefVal {
    my $val = shift;
    return $val unless ref $val;
    return $$val if $val =~ /SCALAR/o;
    my @vars = @{$val};
    my $call = shift @vars;
    foreach (@vars) {
       $_ = SNMPderefVal($_);
    }
    return $call->(@vars);
}

sub SNMPload_1_0 {
    return ( $_[0] ) ? $_[1] : $_[2];
}
sub SNMPload_1_0_healthy {
    return (&StatusASSP() !~ /not healthy/io);
}
sub SNMPload_1_13 {
    my $ret;
    while (my ($k,$v) = each %RunTaskNow) {
        next unless $k && $v;
        $ret .= "$v ";
    }
    return $ret;
}
sub SNMPload_1_14 {
   return memoryUsage() || 0;
}
sub SNMPload_1_30 {
    my %status = &WorkerStatus();
    foreach (keys %status) {
        if ($_ < 10000) {
            $subOID{'.1.30.'.$_.'.0'} = ($status{$_}{lastloop} < 180) ? 1 : 0;
        } else {
            $subOID{'.1.30.'.$_.'.0'} = $ComWorker{$_}->{run};
        }
        $subOID{'.1.30.'.$_.'.1.0'} = $status{$_}{lastloop};
        $subOID{'.1.30.'.$_.'.2.0'} = $status{$_}{lastaction};
    }
    mlog(0,"info: SNMP read worker status OIDs .1.30.1 - 1.30.10001.2") if $SNMPLog == 3;
    $subOIDLastLoad{'1.30'} = Time::HiRes::time() - 1;
}
sub SNMPload_1_31 {
    my $tmpCount = 0;
    my $dbOK = 1;
    foreach my $s (keys %failedTable) {
        $dbOK = 0 if $failedTable{$s} > 1;
        $tmpCount++;
        $subOID{'.1.31.'.$tmpCount.'.0'} = ($failedTable{$s} > 1) ? 0 : 1;
        $subOID{'.1.31.'.$tmpCount.'.1.0'} = $s;
    }
    if (!$dbOK) {
         $subOID{'.1.31.0.0'} = 0;
         $subOID{'.1.31.0.1.0'} = 'failed database table(s)';
    } else {
         $subOID{'.1.31.0.0'} = 1;
         $subOID{'.1.31.0.1.0'} = 'database OK';
    }
    mlog(0,"info: SNMP read database status OIDs .1.31.0 - .1.31.$tmpCount") if $SNMPLog == 3;
    $subOIDLastLoad{'1.31'} = Time::HiRes::time() - 1;
}
sub SNMPload_1_32 {
    my @regerr = keys %RegexError;
    if (@regerr) {
        $subOID{'.1.32.0.0'} = 0;
        $subOID{'.1.32.0.1.0'} = "regex failed for: @regerr";
    } else {
        $subOID{'.1.32.0.0'} = 1;
        $subOID{'.1.32.0.1.0'} = 'all regular expressions are OK';
    }
    mlog(0,"info: SNMP read regular expression status OID .1.32.0") if $SNMPLog == 3;
    $subOIDLastLoad{'1.32'} = Time::HiRes::time() - 1;
}
sub SNMPload_2_X56 {
    my $i = shift;
    my $server = $ConfigSync{$ConfigArray[$i]->[0]}->{sync_server};
    my $msg = $ConfigArray[$i]->[0].':='.$ConfigSync{$ConfigArray[$i]->[0]}->{sync_cfg};
    while (my ($k,$v) = each %{$server}) {
        $msg .= ",$k=$v";
    }
    return $msg;
}
sub SNMPload_2_X56s {
    my $name = shift;

    return $ConfigSync{$name}->{sync_cfg} if ($ConfigSync{$name}->{sync_cfg} < 1);
    my $syncserver = $ConfigSync{$name}->{sync_server};
    my $res = 0;
    while (my ($k,$v) = each %{$syncserver}) {
        if ($v == 1) {
            $res = $v;
            last;
        }
        $res |= $v;
    }
    return $res;
}
sub SNMPload_1 {
    $subOID{'.1.0.0'} = [\&SNMPload_1_0,[\&SNMPload_1_0_healthy], 1, 0];
    $subOID{'.1.1.0'} = [\&SNMPload_1_0,[\&SNMPload_1_0_healthy], \$webStatHealthyResp, \$webStatNotHealthyResp];
    $subOID{'.1.2.0'} = [\&SNMPload_1_0,\$doShutdownForce, 0, 1];
    $subOID{'.1.3.0'} = [\&SNMPload_1_0,\$doShutdownForce, 'shutdown in progress', 'running'];
    $subOID{'.1.4.0'} = $MAINVERSION;
    $subOID{'.1.5.0'} = $assp;
    $subOID{'.1.6.0'} = $];
    $subOID{'.1.7.0'} = $perl;
    $subOID{'.1.8.0'} = $^O;
    $subOID{'.1.9.0'} = \$localhostname;
    $subOID{'.1.10.0'} = \$localhostip;
    $subOID{'.1.11.0'} = \$myName;
    $subOID{'.1.12.0'} = \$NewAsspURL;
    $subOID{'.1.13.0'} = [\&SNMPload_1_13];
    $subOID{'.1.14.0'} = [\&SNMPload_1_14];

    $subOID{'.1.20.1.0'} = [\&timestring,\$nextBDBsync,'',''];
    $subOID{'.1.20.2.0'} = [\&timestring,\$NextConfigReload,'',''];
    $subOID{'.1.20.3.0'} = [\&timestring,\$nextCleanBATVTag,'',''];
    $subOID{'.1.20.4.0'} = [\&timestring,\$nextCleanCache,'',''];
    $subOID{'.1.20.5.0'} = [\&timestring,\$nextCleanIPDom,'',''];
    $subOID{'.1.20.6.0'} = [\&timestring,\$nextCleanDelayDB,'',''];
    $subOID{'.1.20.7.0'} = [\&timestring,\$nextCleanPB,'',''];
    $subOID{'.1.20.8.0'} = [\&timestring,\$nextDBBackup,'',''];
    $subOID{'.1.20.9.0'} = [\&timestring,\$nextDBcheck,'',''];
    $subOID{'.1.20.10.0'} = [\&timestring,\$nextDNSCheck,'',''];
    $subOID{'.1.20.11.0'} = [\&timestring,\$nextdetectHourJob,'',''];
    $subOID{'.1.20.12.0'} = [\&timestring,\$nextExport,'',''];
    $subOID{'.1.20.13.0'} = [\&timestring,\$nextGlobalUploadBlack,'',''];
    $subOID{'.1.20.14.0'} = [\&timestring,\$nextGlobalUploadWhite,'',''];
    $subOID{'.1.20.15.0'} = [\&timestring,\$nextHashFileCheck,'',''];
    $subOID{'.1.20.16.0'} = [\&timestring,\$nextLDAPcrossCheck,'',''];
    $subOID{'.1.20.17.0'} = [\&timestring,\$nextRebuildSpamDB,'',''];
    $subOID{'.1.20.18.0'} = [\&timestring,\$nextResendMail,'',''];
    $subOID{'.1.20.19.0'} = [\&timestring,\$NextASSPFileDownload,'',''];
    $subOID{'.1.20.20.0'} = [\&timestring,\$NextVersionFileDownload,'',''];
    $subOID{'.1.20.21.0'} = [\&timestring,\$NextBackDNSFileDownload,'',''];
    $subOID{'.1.20.22.0'} = [\&timestring,\$NextCodeChangeCheck,'',''];
    $subOID{'.1.20.23.0'} = [\&timestring,\$NextDroplistDownload,'',''];
    $subOID{'.1.20.24.0'} = [\&timestring,\$NextGriplistDownload,'',''];
    $subOID{'.1.20.25.0'} = [\&timestring,\$NextPOP3Collect,'',''];
    $subOID{'.1.20.26.0'} = [\&timestring,\$NextSaveStats,'',''];
    $subOID{'.1.20.27.0'} = [\&timestring,\$NextTLDlistDownload,'',''];
    $subOID{'.1.20.28.0'} = [\&timestring,\$NextSyncConfig,'',''];
    $subOID{'.1.20.29.0'} = [\&timestring,\$NextGroupsReload,'',''];
    $subOID{'.1.20.30.0'} = [\&timestring,\$nextBlockReportSchedule,'',''];
    $subOID{'.1.20.31.0'} = [\&timestring,\$$nextFileAgeSchedule,'',''];
    $subOID{'.1.20.32.0'} = [\&timestring,\$nextQueueSchedule,'',''];
    $subOID{'.1.20.33.0'} = [\&timestring,\$nextMemoryUsageCheckSchedule,'',''];

    mlog(0,"info: SNMP read application OIDs .1.0 - .1.36") if $SNMPLog == 3;
    &SNMPload_1_30();
    &SNMPload_1_31();
    &SNMPload_1_32();
    $subOIDLastLoad{1} = 9999999999;
}
sub SNMPload_2 {
    %subOID2Conf = ();
    my $j = scalar @ConfigArray;
    my $i = 0; my $lastid; my $h = -1;
    $ActWebSess = 'SNMP';
    $WebIP{$ActWebSess}->{user} = $SNMPUser;
    for ($i = 0;$i < $j;$i++) {
        if (@{$ConfigArray[$i]} == 5 && $ConfigArray[$i]->[3] =~ /heading/io) {
            $h++;
            $subOID{'.2.'.$h.'.0'} = [\&SNMPcleanHTML,\$ConfigArray[$i]->[4]];
            next;
        }
        my ($id) = $ConfigArray[$i]->[10] =~ /msg(\d{6})/o;
        $id =~ s/^0+//o;
        $id =~ s/0$//o;
        next unless $id;
        my $canSNMPDo = &canUserDo($SNMPUser,'cfg',$ConfigArray[$i]->[0]);
        next if ($SNMPUser ne 'root' && !$canSNMPDo && $AdminUsersRight{"$SNMPUser.user.hidDisabled"});
        $subOID{'.2.'.$h.'.'.$id.'.0'} = (($SNMPUser ne 'root' && exists $cryptConfigVars{$ConfigArray[$i]->[0]}) ? 'encrypted (ro)' : \$Config{$ConfigArray[$i]->[0]});
        my $li = '.0';
        if ($CreateMIB) {
            $subOID{'.2.'.$h.'.'.$id.'.1'} = \$ConfigArray[$i]->[0];
            $subOID{'.2.'.$h.'.'.$id.'.2'} = [\&SNMPcleanHTML,\$ConfigArray[$i]->[4]];
            $subOID{'.2.'.$h.'.'.$id.'.3'} = [\&SNMPcleanHTML,\$ConfigArray[$i]->[1]];
            $subOID{'.2.'.$h.'.'.$id.'.4'} = [\&SNMPcleanHTML,\$ConfigArray[$i]->[7]];
            $li = '.4';
        }
        if (&syncCanSync() or $CreateMIB) {
            my $ss = $ConfigSync{$ConfigArray[$i]->[0]}->{sync_cfg};
            $ss = 0 unless $ss;
            if ($ss > -1) {
                $subOID{'.2.'.$h.'.'.$id.'.5.0'} = [\&SNMPload_2_X56s,\$ConfigArray[$i]->[0]];
                $subOID{'.2.'.$h.'.'.$id.'.6.0'} = [\&SNMPload_2_X56,$i];
                $li = '.6.0';
            }
        }
        if (($SNMPUser eq 'root' || ($canSNMPDo && ! exists $cryptConfigVars{$ConfigArray[$i]->[0]})) &&
             $ConfigArray[$i]->[3] ne \&passnoinput &&
             $ConfigArray[$i]->[3] ne \&textnoinput
        ) {
            $subOID2Conf{'.2.'.$h.'.'.$id.'.0'} = $i;
        }
        $lastid = '.2.'.$h.'.'.$id.$li;
    }
    mlog(0,"info: SNMP read configuration OIDs .2.0 - $lastid") if $SNMPLog == 3;
    $subOIDLastLoad{2} = 9999999999;
}
sub SNMPload_3 {
    my ($dummy,@modules) = &StatsGetModules();
    my $i = 0;
    while (@modules){
        my $m = shift @modules;
        $m->[1] =~ s/<\/?a[^>]*>//o;
        $m->[1] =~ s/<\/?font[^>]*>//o;
        $m->[2] =~ s/<\/?font[^>]*>//o;
        $m->[3] =~ s/<\/?font[^>]*>//o;
        $subOID{'.3.'.$i.'.0'} = $m->[0];
        for (my $j = 1;$j < 5;$j++) {
            $subOID{'.3.'.$i.'.'.$j.'.0'} = $m->[$j];
        }
        $i++;
    }
    $i--;
    mlog(0,"info: SNMP read perl module configuration OIDs .3.0.0 - 3.$i.4") if $SNMPLog == 3;
    $subOIDLastLoad{3} = 9999999999;
}
sub SNMPload_4 {
    my $maxsubOID = &SNMPStats('.4.1','.4.2','.4.3','.4.4',undef,undef);
    $maxsubOID    = &SNMPStats(undef,undef,undef,undef,'.4.5','.4.6') || $maxsubOID;
    my $baseOID = NetSNMP::OID->new($SNMPBaseOID);
    $maxOID = $baseOID . $maxsubOID;
    mlog(0,"info: SNMP read Stat OIDs .4.1.1.0 - $maxsubOID") if $SNMPLog == 3;
    $subOIDLastLoad{4} = Time::HiRes::time() - 1;
}
sub SNMPload_5 {
    if ($CreateMIB or $SNMPUser eq 'root' or &canUserDo($SNMPUser,'action','SNMPAPI')) {
         my $baseOID = NetSNMP::OID->new($SNMPBaseOID);
         $subOID{'.5.0.0'} = '' unless exists $subOID{'.5.0.0'};
         $subOID{'.5.1.0'} = \$lastSNMPAPIresult;
         $canSNMPAPI = 1;
         $maxOID = $baseOID . '.5.1.0';
         mlog(0,"info: SNMP registered API OIDs .5.0.0 - 5.1.0") if $SNMPLog == 3;
    }
    $subOIDLastLoad{5} = Time::HiRes::time() - 5;
}

sub SNMPhandler {
    my ($handler, $registration_info, $request_info, $requests) = @_;

    my $request;
    if ($handler eq 'init') {
        mlog(0,"info: initalized SNMP OIDs") if $SNMPLog > 1;
    } else {
        mlog(0,"info: got snmp request") if $SNMPLog > 1;
        $MainThreadLoopWait = 0;
    }
    my $baseOID = NetSNMP::OID->new($SNMPBaseOID);
    my $minsubOID = '.1.0.0';
    my $minOID = $baseOID . $minsubOID;
    my $minOIDn = $SNMPBaseOID . $minsubOID;
    my $bid = '.'.join('.',$baseOID->to_array());
    $canSNMPAPI = 0;

    if ($handler eq 'init' or scalar @sortedOIDs != scalar keys %subOID) {
        delete $qs{ResetAllStats};
        delete $qs{ResetStats};
        &ConfigStats();
        %subOID = (); keys %subOID = 9216;
        %subOIDn = (); keys %subOIDn = 9216;
        &SNMPload_1();
        &SNMPload_2();
        &SNMPload_3();
        &SNMPload_4();
        &SNMPload_5();

        @sortedOIDs =  map { $_->[0] }
                       sort { NetSNMP::OID::compare( $main::a->[1], $main::b->[1] ) }
                       map { [ $_, NetSNMP::OID->new($SNMPBaseOID.$_) ] } keys %subOID;

        my $j = scalar @sortedOIDs;
        for (my $i = 0;$i < $j;$i++) {
             $subOIDn{$sortedOIDs[$i]} = $i;
        }
        mlog(0,"info: SNMP registered $j OIDs from $minOID to $maxOID") if $SNMPLog;
        if ($CreateMIB) {
            my $mibSUB;
            my $mibFile;
            if (open $mibFile , '<',"$base/SNMPmakeMIB.pl") {
                binmode $mibFile;
                while (<$mibFile>) {
                    $mibSUB .= $_;
                }
                close $mibFile;
                eval($mibSUB);
                mlog(0,"info: MIB failed - $@") if $@;
            }
            $mibSUB = '';
            if (open $mibFile , '<',"$base/SNMPmakeMRTG.pl") {
                binmode $mibFile;
                while (<$mibFile>) {
                    $mibSUB .= $_;
                }
                close $mibFile;
                eval($mibSUB);
                mlog(0,"info: MRTG-cfg failed - $@") if $@;
            }
        }
        return if $handler eq 'init';
    }

    my $retval = 0;
    for($request = $requests; $request; $request = $request->next()) {
        $retval = 1;
        my $oid = $request->getOID();
        my $sid = '.'.join('.',(NetSNMP::OID->new($oid))->to_array());
        $sid =~ s/^\Q$bid\E//;
        my ($ts,$tl) = $sid =~ /^\.?((\d+)\.\d+)/o;
        $tl ||= 1;
        if ($ts eq '1.30' && $subOIDLastLoad{$ts} < Time::HiRes::time() - 2) {
            &SNMPload_1_30();
        } elsif ($ts eq '1.31' && $subOIDLastLoad{$ts} < Time::HiRes::time() - 2) {
            &SNMPload_1_31();
        } elsif ($ts eq '1.32' && $subOIDLastLoad{$ts} < Time::HiRes::time() - 2) {
            &SNMPload_1_32();
        } elsif ($subOIDLastLoad{$tl} < Time::HiRes::time() - 2) {
            &{"SNMPload_$tl"};
        }
        my $mode = $request_info->getMode();
        my $value;
        if (exists $subOID{$sid}) {
            $value = SNMPderefVal($subOID{$sid});
        }

        if ($mode == $SNMPag{MODE_GET}) {
            if (exists $subOID{$sid}) {
                $request->setValue(SNMPVarType(\$value,$sid,0), $value);
                mlog(0,"info: snmp read request for OID - $oid - $sid - MODE_GET") if $SNMPLog == 3;
            } else {
                $request->setError($request_info, $SNMPag{SNMP_ERR_NOSUCHNAME});
                mlog(0,"info: snmp read request for unknown OID - $oid - $sid - MODE_GET") if $SNMPLog == 3;
            }
            mlog(0,"info: snmp MODE_GET - $oid") if $SNMPLog == 2;

        } elsif ($mode == $SNMPag{MODE_GETNEXT}) {
            if ($oid < NetSNMP::OID->new($minOID)) {
                $request->setOID(NetSNMP::OID->new($minOIDn));
                $value = SNMPderefVal($subOID{$minsubOID});
                $request->setValue(SNMPVarType(\$value,$minsubOID,0), $value);
                mlog(0,"info: snmp read request for OID - $oid - sid - MODE_GETNEXT - returned first available OID ".$minOID) if $SNMPLog == 3;
            } elsif ($oid >= NetSNMP::OID->new($maxOID)) {
                $request->setError($request_info, $SNMPag{SNMP_ERR_NOSUCHNAME});
                mlog(0,"info: snmp read request for unknown OID - $oid - $sid - MODE_GETNEXT") if $SNMPLog == 3;
            } else {
                my $j = scalar @sortedOIDs;
                my $i = $subOIDn{$sid};
                $i ||= 0;
                for ( ;$i < $j;$i++) {
                    next if $oid > NetSNMP::OID->new($baseOID.$sortedOIDs[$i]);
                    $i++ if $oid == NetSNMP::OID->new($baseOID.$sortedOIDs[$i]);
                    $request->setOID(NetSNMP::OID->new($SNMPBaseOID.$sortedOIDs[$i]));
                    $value = SNMPderefVal($subOID{$sortedOIDs[$i]});
                    $request->setValue(SNMPVarType(\$value,$sortedOIDs[$i],0), $value);
                    mlog(0,"info: snmp read request for OID - ". NetSNMP::OID->new($SNMPBaseOID.$sortedOIDs[$i])." - MODE_GETNEXT") if $SNMPLog == 3;
                    last;
                }
            }
            mlog(0,"info: snmp MODE_GETNEXT - $oid") if $SNMPLog == 2;

        } elsif ($mode == $SNMPag{MODE_GETBULK}) {
            my $answers = 0;
            if ($oid >= NetSNMP::OID->new($maxOID)) {
                $request->setError($request_info, $SNMPag{SNMP_ERR_NOSUCHNAME});
                mlog(0,"info: snmp read request for unknown OID - $oid - $sid - MODE_GETBULK") if $SNMPLog == 3;
            } else {
                my $repeat = $request->getRepeat();
                if ($oid < NetSNMP::OID->new($minOID)) {
                    $request->setOID(NetSNMP::OID->new($minOIDn));
                    $value = SNMPderefVal($subOID{$minsubOID});
                    $request->setValue(SNMPVarType(\$value,$minsubOID,0), $value);
                    mlog(0,"info: snmp read request for OID - $oid - $sid - MODE_GETBULK - used first available OID ".$minOID) if $SNMPLog == 3;
                    $request->setRepeat(--$repeat);
                    $answers++;
                }
                if ($repeat) {
                    my $j = scalar @sortedOIDs;
                    my $i = $subOIDn{$sid};
                    $i ||= 0;
                    for ( ;$i < $j;$i++) {
                        next if $oid > NetSNMP::OID->new($baseOID.$sortedOIDs[$i]);
                        $i++ if $oid == NetSNMP::OID->new($baseOID.$sortedOIDs[$i]);
                        $request->setOID(NetSNMP::OID->new($SNMPBaseOID.$sortedOIDs[$i]));
                        $value = SNMPderefVal($subOID{$sortedOIDs[$i]});
                        $request->setValue(SNMPVarType(\$value,$sortedOIDs[$i],0), $value);
                        $request->setRepeat(--$repeat);
                        $answers++;
                        last unless $repeat;
                    }
                }
            }
            mlog(0,"info: snmp MODE_GETBULK - $oid - $sid - $answers repeats") if $SNMPLog >= 2;

        } elsif ($mode == $SNMPag{MODE_SET_RESERVE1}) {
            if ($canSNMPAPI && $sid eq '.5.0.0') {
                $request->setError($request_info, $SNMPag{SNMP_ERR_NOERROR});
                mlog(0,"info: snmp init SNMPAPI request for OID - $oid - $sid - MODE_SET_RESERVE1") if $SNMPLog == 3;
            } elsif ($SNMPwriteable && exists $subOID2Conf{$sid}) {
                my $getValue = $request->getValue();
                my $q;
                $q = $1 if $getValue =~ s/^([\"\'])//o;
                $getValue =~ s/\Q$q\E$//o if $q;
                my $valid = $ConfigArray[$subOID2Conf{$sid}]->[5];
                if ($getValue =~ /$valid/i) {
                    $request->setError($request_info, $SNMPag{SNMP_ERR_NOERROR});
                    mlog(0,"info: snmp init configuration change request for OID - $oid - $sid - MODE_SET_RESERVE1") if $SNMPLog == 3;
                } else {
                    $request->setError($request_info, $SNMPag{SNMP_ERR_WRONGVALUE});
                    mlog(0,"info: snmp configuration change request (MODE_SET_RESERVE1) failed for - ".$ConfigArray[$subOID2Conf{$sid}]->[0]." - invalid value - $getValue") if $SNMPLog;
                }
            } elsif (exists $subOID{$sid}) {
                $request->setError($request_info, $SNMPag{SNMP_ERR_READONLY});
                mlog(0,"info: snmp configuration change request for readonly OID - $oid - $sid - MODE_SET_RESERVE1") if $SNMPLog == 3;
            } else {
                $request->setError($request_info, $SNMPag{SNMP_ERR_NOSUCHNAME});
                mlog(0,"info: snmp change request for unknown OID - $oid - $sid - MODE_SET_RESERVE1") if $SNMPLog == 3;
            }
            mlog(0,"info: snmp MODE_SET_RESERVE1 - $oid") if $SNMPLog >= 2;

        } elsif ($mode == $SNMPag{MODE_SET_RESERVE2}) {
            if ($canSNMPAPI && $sid eq '.5.0.0') {
                $request->setError($request_info, $SNMPag{SNMP_ERR_NOERROR});
                mlog(0,"info: snmp init SNMPAPI request for OID - $oid - $sid - MODE_SET_RESERVE2") if $SNMPLog == 3;
            } elsif ($SNMPwriteable && exists $subOID2Conf{$sid}) {
                $request->setError($request_info, $SNMPag{SNMP_ERR_NOERROR});
                mlog(0,"info: snmp init configuration change request for OID - $oid - $sid - MODE_SET_RESERVE2") if $SNMPLog == 3;
            } elsif (exists $subOID{$sid}) {
                $request->setError($request_info, $SNMPag{SNMP_ERR_READONLY});
                mlog(0,"info: snmp configuration change request for readonly OID - $oid - $sid - MODE_SET_RESERVE2") if $SNMPLog == 3;
            } else {
                $request->setError($request_info, $SNMPag{SNMP_ERR_NOSUCHNAME});
                mlog(0,"info: snmp change request for unknown OID - $oid - $sid - MODE_SET_RESERVE2") if $SNMPLog == 3;
            }
            mlog(0,"info: snmp MODE_SET_RESERVE2 - $oid - $sid") if $SNMPLog >= 2;

        } elsif ($mode == $SNMPag{MODE_SET_ACTION}) {
            my $value;
            if ($canSNMPAPI && $sid eq '.5.0.0') {
                $value = $request->getValue();
                my $q;
                $q = $1 if $value =~ s/^([\"\'])//o;
                $value =~ s/\Q$q\E$//o if $q;
                mlog(0,"info: SNMPAPI request to execute : $value ") if $value && $SNMPLog > 1;
                if ($SNMPUser ne 'root' and $value =~ /^\s*(system|qx|\xB4[^\xB4]*\xB4)/o) {     # ... 3. back ticks B4
                   mlog(0,"warning: SNMPAPI request to execute system command: $value - is not allowed for non root users") ;
                   $request->setError($request_info, $SNMPag{SNMP_ERR_WRONGVALUE});
                   $subOID{'.5.0.0'} = '';
                   $lastSNMPAPIresult = '';
                } elsif (! $value) {
                   $subOID{'.5.0.0'} = '';
                   $lastSNMPAPIresult = '';
                   $request->setError($request_info, $SNMPag{SNMP_ERR_NOERROR});
                   mlog(0,'info: SNMPAPI was reseted');
                } else {
                   $subOID{'.5.0.0'} = $value;
                   my ($sub,$parm) = &parseEval($value);
                   if ($sub) {
                       $sub =~ s/^\&//o;
                       $lastSNMPAPIresult = eval{$sub->(split(/\,/o,$parm));};
                   } else {
                       $last